/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainerShortIterator;
import org.roaringbitmap.Container;
import org.roaringbitmap.ReverseBitmapContainerShortIterator;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;

public final class BitmapContainer
extends Container
implements Cloneable {
    protected static final int MAX_CAPACITY = 65536;
    private static boolean USE_IN_PLACE = true;
    long[] bitmap;
    private static final long serialVersionUID = 2L;
    int cardinality;
    private static final int BLOCKSIZE = 128;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;
    public static final boolean USE_BRANCHLESS = true;

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[1024];
    }

    public LongBuffer toLongBuffer() {
        LongBuffer lb = LongBuffer.allocate(this.bitmap.length);
        lb.put(this.bitmap);
        return lb;
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = new long[1024];
        if (this.cardinality == 65536) {
            Arrays.fill(this.bitmap, -1L);
        } else {
            int firstWord = firstOfRun / 64;
            int lastWord = (lastOfRun - 1) / 64;
            int zeroPrefixLength = firstOfRun & 0x3F;
            int zeroSuffixLength = 63 - (lastOfRun - 1 & 0x3F);
            Arrays.fill(this.bitmap, firstWord, lastWord + 1, -1L);
            int n = firstWord;
            this.bitmap[n] = this.bitmap[n] ^ (1L << zeroPrefixLength) - 1L;
            long blockOfOnes = (1L << zeroSuffixLength) - 1L;
            long maskOnLeft = blockOfOnes << 64 - zeroSuffixLength;
            int n2 = lastWord;
            this.bitmap[n2] = this.bitmap[n2] ^ maskOnLeft;
        }
    }

    private BitmapContainer(int newCardinality, long[] newBitmap) {
        this.cardinality = newCardinality;
        this.bitmap = Arrays.copyOf(newBitmap, newBitmap.length);
    }

    public BitmapContainer(long[] newBitmap, int newCardinality) {
        this.cardinality = newCardinality;
        this.bitmap = newBitmap;
    }

    public BitmapContainer(MappeableBitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongArray();
    }

    @Override
    int numberOfRuns() {
        int numRuns = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        for (int blockOffset = 0; blockOffset < this.bitmap.length; blockOffset += 128) {
            for (int i = blockOffset; i < blockOffset + 128; ++i) {
                long word = this.bitmap[i];
                numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            }
            if (numRuns <= mustNotExceed) continue;
            return numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsAdjustment() {
        int ans = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            ans = (int)((long)ans + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL)));
        }
        long word = nextWord;
        if ((word & Long.MIN_VALUE) != 0L) {
            ++ans;
        }
        return ans;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = RunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public Container add(short i) {
        long newval;
        int x = Util.toIntUnsigned(i);
        long previous = this.bitmap[x / 64];
        this.bitmap[x / 64] = newval = previous | 1L << x;
        this.cardinality = (int)((long)this.cardinality + ((previous ^ newval) >>> x));
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v = value2.content[k];
            if (!this.contains(v)) continue;
            answer.content[answer.cardinality++] = v;
        }
        return answer;
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        int answer = 0;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short v = value2.content[k];
            if (!this.contains(v)) continue;
            ++answer;
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public int andCardinality(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        return newCardinality;
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            Arrays.fill(this.bitmap, 0L);
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean contains(short i) {
        int x = Util.toIntUnsigned(i);
        return (this.bitmap[x / 64] & 1L << x) != 0L;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = Long.reverseBytes(in.readLong());
            this.cardinality += Long.bitCount(w);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            return Arrays.equals(this.bitmap, srb.bitmap);
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    protected void fillArray(int[] array) {
        int pos = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                array[pos++] = k * 64 + Long.bitCount(t - 1L);
            }
        }
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                array[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
            }
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long t;
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset ^= t) {
                t = bitset & -bitset;
                x[pos++] = k * 64 + Long.bitCount(t - 1L) | mask;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        return new BitmapContainerShortIterator(this.bitmap);
    }

    public static ShortIterator getShortIterator(long[] bitmap) {
        return new BitmapContainerShortIterator(bitmap);
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseBitmapContainerShortIterator(this.bitmap);
    }

    public static ShortIterator getReverseShortIterator(long[] bitmap) {
        return new ReverseBitmapContainerShortIterator(bitmap);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }

    @Override
    public Container iand(ArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content[k]);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        return this.not(this, firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            int i = Util.toIntUnsigned(value2.content[k]) >>> 6;
            long bef = this.bitmap[i];
            this.bitmap[i] = aft = bef | 1L << value2.content[k];
            this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = this.bitmap[k] | b2.bitmap[k];
            this.cardinality += Long.bitCount(w);
        }
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            final ShortIterator si;
            {
                this.si = BitmapContainer.this.getShortIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Short next() {
                return this.si.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            long mask = 1L << vc;
            int index = Util.toIntUnsigned(vc) >>> 6;
            long ba = this.bitmap[index];
            this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
            this.bitmap[index] = ba ^ mask;
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] ^ b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    protected void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            short x = arrayContainer.content[k];
            int n = Util.toIntUnsigned(x) / 64;
            this.bitmap[n] = this.bitmap[n] | 1L << x;
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap[x]);
            }
            --x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    private Container not(BitmapContainer answer, int firstOfRange, int lastOfRange) {
        assert (this.bitmap.length == 1024);
        if (lastOfRange - firstOfRange == 65536) {
            int newCardinality = 65536 - this.cardinality;
            for (int k = 0; k < this.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            answer.cardinality = newCardinality;
            if (newCardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        int cardinalityChange = 0;
        int rangeFirstWord = firstOfRange / 64;
        int rangeFirstBitPos = firstOfRange & 0x3F;
        int rangeLastWord = (lastOfRange - 1) / 64;
        long rangeLastBitPos = lastOfRange - 1 & 0x3F;
        if (answer != this) {
            System.arraycopy(this.bitmap, 0, answer.bitmap, 0, rangeFirstWord);
            System.arraycopy(this.bitmap, rangeLastWord + 1, answer.bitmap, rangeLastWord + 1, this.bitmap.length - (rangeLastWord + 1));
        }
        long maskOnLeft = rangeLastBitPos == 63L ? -1L : (1L << (int)(rangeLastBitPos + 1L)) - 1L;
        long mask = -1L;
        mask ^= (1L << rangeFirstBitPos) - 1L;
        if (rangeFirstWord == rangeLastWord) {
            cardinalityChange = -Long.bitCount(this.bitmap[rangeFirstWord]);
            answer.bitmap[rangeFirstWord] = this.bitmap[rangeFirstWord] ^ (mask &= maskOnLeft);
            answer.cardinality = this.cardinality + (cardinalityChange += Long.bitCount(answer.bitmap[rangeFirstWord]));
            if (answer.cardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        cardinalityChange += -Long.bitCount(this.bitmap[rangeFirstWord]);
        answer.bitmap[rangeFirstWord] = this.bitmap[rangeFirstWord] ^ mask;
        cardinalityChange += Long.bitCount(answer.bitmap[rangeFirstWord]);
        cardinalityChange += -Long.bitCount(this.bitmap[rangeLastWord]);
        answer.bitmap[rangeLastWord] = this.bitmap[rangeLastWord] ^ maskOnLeft;
        cardinalityChange += Long.bitCount(answer.bitmap[rangeLastWord]);
        for (int i = rangeFirstWord + 1; i < rangeLastWord; ++i) {
            cardinalityChange += 64 - 2 * Long.bitCount(this.bitmap[i]);
            answer.bitmap[i] = this.bitmap[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        answer.cardinality = this.cardinality + cardinalityChange;
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        return this.not(new BitmapContainer(), firstOfRange, lastOfRange);
    }

    @Override
    public BitmapContainer or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v = value2.content[k];
            int i = Util.toIntUnsigned(v) >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w | 1L << v;
            answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
        }
        return answer;
    }

    @Override
    public Container or(BitmapContainer value2) {
        if (USE_IN_PLACE) {
            BitmapContainer value1 = this.clone();
            return value1.ior(value2);
        }
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = 0;
        for (int k = 0; k < answer.bitmap.length; ++k) {
            long w;
            answer.bitmap[k] = w = this.bitmap[k] | value2.bitmap[k];
            answer.cardinality += Long.bitCount(w);
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap[x / 64] = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - bef >>> 63));
        this.bitmap[index] = aft;
        return this;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        for (long w : this.bitmap) {
            out.writeLong(Long.reverseBytes(w));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return BitmapContainer.serializedSizeInBytes(0);
    }

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        ac.loadData(this);
        return ac;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ShortIterator i = this.getShortIterator();
        sb.append("{");
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            short vc = value2.content[k];
            int index = Util.toIntUnsigned(vc) >>> 6;
            long mask = 1L << vc;
            long val = answer.bitmap[index];
            answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((val & mask) >>> vc)));
            answer.bitmap[index] = val ^ mask;
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    protected Container ilazyor(ArrayContainer value2) {
        this.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            this.bitmap[n] = this.bitmap[n] | 1L << v;
        }
        return this;
    }

    protected Container ilazyor(BitmapContainer x) {
        this.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | x.bitmap[k];
        }
        return this;
    }

    protected Container lazyor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        answer.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v = value2.content[k];
            int n = i = Util.toIntUnsigned(v) >>> 6;
            answer.bitmap[n] = answer.bitmap[n] | 1L << v;
        }
        return answer;
    }

    protected Container lazyor(BitmapContainer x) {
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            answer.bitmap[k] = this.bitmap[k] | x.bitmap[k];
        }
        return answer;
    }

    protected void computeCardinality() {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
    }

    @Override
    public int rank(short lowbits) {
        int x = Util.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        for (int k = 0; k < (x + 1) / 64; ++k) {
            answer += Long.bitCount(this.bitmap[k]);
        }
        if (leftover != 0) {
            answer += Long.bitCount(this.bitmap[(x + 1) / 64] << 64 - leftover);
        }
        return answer;
    }

    @Override
    public short select(int j) {
        int leftover = j;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int w = Long.bitCount(this.bitmap[k]);
            if (w > leftover) {
                return (short)(k * 64 + Util.select(this.bitmap[k], leftover));
            }
            leftover -= w;
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            ArrayContainer ac = new ArrayContainer(maxcardinality);
            int pos = 0;
            for (int k = 0; ac.cardinality < maxcardinality && k < this.bitmap.length; ++k) {
                long t;
                for (long bitset = this.bitmap[k]; ac.cardinality < maxcardinality && bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    ac.content[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        BitmapContainer bc = new BitmapContainer(maxcardinality, this.bitmap);
        int s = Util.toIntUnsigned(this.select(maxcardinality));
        int usedwords = (s + 63) / 64;
        int todelete = this.bitmap.length - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap[bc.bitmap.length - 1 - k] = 0L;
        }
        int lastword = s % 64;
        if (lastword != 0) {
            bc.bitmap[s / 64] = bc.bitmap[s / 64] << 64 - lastword >> 64 - lastword;
        }
        return bc;
    }

    @Override
    public Container iadd(int begin, int end) {
        Util.setBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        return this;
    }

    @Override
    public Container iremove(int begin, int end) {
        Util.resetBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        if (this.getCardinality() <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container flip(short i) {
        int x = Util.toIntUnsigned(i);
        int index = x / 64;
        long bef = this.bitmap[index];
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            int n = index;
            this.bitmap[n] = this.bitmap[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((bef & mask) >>> x)));
        int n = index;
        this.bitmap[n] = this.bitmap[n] ^ mask;
        return this;
    }

    @Override
    public Container add(int begin, int end) {
        BitmapContainer answer = this.clone();
        Util.setBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        return answer;
    }

    @Override
    public Container remove(int begin, int end) {
        BitmapContainer answer = this.clone();
        Util.resetBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        if (answer.getCardinality() <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    protected Container lazyor(RunContainer x) {
        BitmapContainer bc = this.clone();
        bc.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(bc.bitmap, start, end);
        }
        return bc;
    }

    protected Container ilazyor(RunContainer x) {
        this.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(this.bitmap, start, end);
        }
        return this;
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public Container andNot(RunContainer x) {
        BitmapContainer answer = this.clone();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.resetBitmapRange(answer.bitmap, start, end);
        }
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public Container iand(RunContainer x) {
        int card = x.getCardinality();
        if (card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = Util.toIntUnsigned(x.getValue(rlepos));
                int runEnd = runStart + Util.toIntUnsigned(x.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!this.contains((short)runValue)) continue;
                    answer.content[answer.cardinality++] = (short)runValue;
                }
            }
            return answer;
        }
        int start = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int end = Util.toIntUnsigned(x.getValue(rlepos));
            Util.resetBitmapRange(this.bitmap, start, end);
            start = end + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
        }
        Util.resetBitmapRange(this.bitmap, start, Util.maxLowBitAsInteger() + 1);
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container iandNot(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.resetBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container ior(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.setBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        return this;
    }

    @Override
    public Container ixor(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = Util.toIntUnsigned(x.getValue(rlepos));
            int end = start + Util.toIntUnsigned(x.getLength(rlepos)) + 1;
            Util.flipBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public Container repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
        }
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            if (!this.contains(value2.content[k])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer value2) {
        for (int k = 0; k < this.bitmap.length; ++k) {
            if ((this.bitmap[k] & value2.bitmap[k]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableBitmapContainer(this);
    }
}

