/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.corelib.LoopFormState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;

@SupportsInformalParameters
public class Loop<T> {
    private static final ComponentAction<Loop> RESET_INDEX = new ComponentAction<Loop>(){
        private static final long serialVersionUID = 6477493424977597345L;

        @Override
        public void execute(Loop component) {
            component.resetIndex();
        }

        public String toString() {
            return "Loop.ResetIndex";
        }
    };
    private static final ComponentAction<Loop> SETUP_FOR_VOLATILE = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -977168791667037377L;

        @Override
        public void execute(Loop component) {
            component.setupForVolatile();
        }

        public String toString() {
            return "Loop.SetupForVolatile";
        }
    };
    private static final ComponentAction<Loop> ADVANCE_VOLATILE = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -4600281573714776832L;

        @Override
        public void execute(Loop component) {
            component.advanceVolatile();
        }

        public String toString() {
            return "Loop.AdvanceVolatile";
        }
    };
    private static final ComponentAction<Loop> END_HEARTBEAT = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -977168791667037377L;

        @Override
        public void execute(Loop component) {
            component.endHeartbeat();
        }

        public String toString() {
            return "Loop.EndHeartbeat";
        }
    };
    static final ComponentAction<Loop> PREPARE_FOR_SUBMISSION = new ComponentAction<Loop>(){

        @Override
        public void execute(Loop component) {
            component.prepareForSubmission();
        }

        public String toString() {
            return "Loop.PrepareForSubmission";
        }
    };
    static final ComponentAction<Loop> NOTIFY_CONTAINER = new ComponentAction<Loop>(){

        @Override
        public void execute(Loop component) {
            component.notifyContainer();
        }

        public String toString() {
            return "Loop.NotifyContainer";
        }
    };
    @Parameter(required=true, principal=true, autoconnect=true)
    private Iterable<T> source;
    @Parameter
    private ValueEncoder<T> encoder;
    @Parameter(allowNull=false, defaultPrefix="literal")
    private LoopFormState formState = LoopFormState.VALUES;
    @Environmental(value=false)
    private FormSupport formSupport;
    @Parameter(defaultPrefix="literal")
    private String element;
    @Parameter(principal=true)
    private T value;
    @Parameter
    private int index;
    @Parameter(defaultPrefix="literal")
    private Block empty;
    private Iterator<T> iterator;
    @Environmental
    private Heartbeat heartbeat;
    private boolean storeValuesInForm;
    private boolean storeIncrementsInForm;
    private boolean storeHeartbeatsInForm;
    @Inject
    private ComponentResources resources;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    private Block cleanupBlock;
    private List<T> synchonizedValues;

    LoopFormState defaultFormState() {
        return LoopFormState.VALUES;
    }

    String defaultElement() {
        return this.resources.getElementName();
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    @SetupRender
    boolean setup() {
        boolean hasContent;
        this.index = 0;
        this.iterator = this.source == null ? null : this.source.iterator();
        boolean insideForm = this.formSupport != null;
        this.storeValuesInForm = insideForm && this.formState == LoopFormState.VALUES;
        this.storeIncrementsInForm = insideForm && this.formState == LoopFormState.ITERATION;
        boolean bl = this.storeHeartbeatsInForm = insideForm && this.formState != LoopFormState.NONE;
        if (this.storeValuesInForm) {
            this.formSupport.store(this, PREPARE_FOR_SUBMISSION);
        }
        boolean bl2 = hasContent = this.iterator != null && this.iterator.hasNext();
        if (insideForm && hasContent) {
            if (this.storeValuesInForm) {
                this.formSupport.store(this, RESET_INDEX);
            }
            if (this.storeIncrementsInForm) {
                this.formSupport.store(this, SETUP_FOR_VOLATILE);
            }
        }
        this.cleanupBlock = hasContent ? null : this.empty;
        return hasContent;
    }

    Block cleanupRender() {
        if (this.storeValuesInForm) {
            this.formSupport.store(this, NOTIFY_CONTAINER);
        }
        return this.cleanupBlock;
    }

    private void setupForVolatile() {
        this.index = 0;
        this.iterator = this.source.iterator();
    }

    private void advanceVolatile() {
        this.value = this.iterator.next();
        this.startHeartbeat();
    }

    @BeginRender
    void begin(MarkupWriter writer) {
        this.value = this.iterator.next();
        if (this.storeValuesInForm) {
            if (this.encoder == null) {
                this.formSupport.store(this, new RestoreState(this.value));
            } else {
                String clientValue = this.encoder.toClient(this.value);
                this.formSupport.store(this, new RestoreStateFromStoredClientValue(clientValue));
            }
        }
        if (this.storeIncrementsInForm) {
            this.formSupport.store(this, ADVANCE_VOLATILE);
        }
        this.startHeartbeat();
        if (this.element != null) {
            writer.element(this.element, new Object[0]);
            this.resources.renderInformalParameters(writer);
        }
    }

    private void startHeartbeat() {
        this.heartbeat.begin();
    }

    @AfterRender
    Boolean after(MarkupWriter writer) {
        if (this.element != null) {
            writer.end();
        }
        this.endHeartbeat();
        if (this.storeHeartbeatsInForm) {
            this.formSupport.store(this, END_HEARTBEAT);
        }
        return this.iterator.hasNext() ? Boolean.valueOf(false) : null;
    }

    private void endHeartbeat() {
        this.heartbeat.end();
        ++this.index;
    }

    private void resetIndex() {
        this.index = 0;
    }

    private void restoreState(T storedValue) {
        this.value = storedValue;
        this.startHeartbeat();
    }

    private void restoreStateFromStoredClientValue(String clientValue) {
        T restoredValue = this.encoder.toValue(clientValue);
        this.restoreState(restoredValue);
        this.synchonizedValues.add(restoredValue);
    }

    private void prepareForSubmission() {
        this.synchonizedValues = CollectionFactory.newList();
    }

    private void notifyContainer() {
        Object[] values = this.synchonizedValues.toArray();
        this.resources.triggerEvent("synchronizeValues", values, null);
    }

    public int getIndex() {
        return this.index;
    }

    public T getValue() {
        return this.value;
    }

    void setSource(Iterable<T> source) {
        this.source = source;
    }

    void setHeartbeat(Heartbeat heartbeat) {
        this.heartbeat = heartbeat;
    }

    static class RestoreState
    implements ComponentAction<Loop> {
        private static final long serialVersionUID = -3926831611368720764L;
        private final Object storedValue;

        public RestoreState(Object storedValue) {
            this.storedValue = storedValue;
        }

        @Override
        public void execute(Loop component) {
            component.restoreState(this.storedValue);
        }

        public String toString() {
            return String.format("Loop.RestoreState[%s]", this.storedValue);
        }
    }

    static class RestoreStateFromStoredClientValue
    implements ComponentAction<Loop> {
        private final String clientValue;

        public RestoreStateFromStoredClientValue(String clientValue) {
            this.clientValue = clientValue;
        }

        @Override
        public void execute(Loop component) {
            component.restoreStateFromStoredClientValue(this.clientValue);
        }

        public String toString() {
            return String.format("Loop.RestoreStateFromStoredClientValue[%s]", this.clientValue);
        }
    }
}

