/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockMCSC;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.util.SortUtils;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class SparseBlockCSC
extends SparseBlock {
    private static final long serialVersionUID = -8020198259526080455L;
    private int[] _ptr = null;
    private int[] _indexes = null;
    private double[] _values = null;
    private int _size = 0;
    private int _rlen = -1;
    private int _clenInferred = -1;

    public SparseBlockCSC(int rlen, int clen) {
        this._rlen = rlen;
        this._ptr = new int[clen + 1];
        this._indexes = new int[4];
        this._values = new double[4];
        this._size = 0;
    }

    public SparseBlockCSC(int clen, int capacity, int size) {
        this._ptr = new int[clen + 1];
        this._indexes = new int[capacity];
        this._values = new double[capacity];
        this._size = size;
    }

    public SparseBlockCSC(int[] rowPtr, int[] rowInd, double[] values, int nnz) {
        this._ptr = rowPtr;
        this._indexes = rowInd;
        this._values = values;
        this._size = nnz;
    }

    public SparseBlockCSC(SparseBlock sblock, int clen) {
        this._clenInferred = clen;
        this._rlen = sblock.numRows();
        this._size = (int)sblock.size();
        this.initialize(sblock);
    }

    public SparseBlockCSC(SparseBlock sblock) {
        this.inferNumCol(sblock);
        this._rlen = sblock.numRows();
        this._size = (int)sblock.size();
        this.initialize(sblock);
    }

    private void initialize(SparseBlock sblock) {
        if (this._size > Integer.MAX_VALUE) {
            throw new RuntimeException("SparseBlockCSC supports nnz<=Integer.MAX_VALUE but got " + this._size);
        }
        if (sblock instanceof SparseBlockCSC) {
            SparseBlockCSC originalCSC = (SparseBlockCSC)sblock;
            this._ptr = Arrays.copyOf(originalCSC._ptr, originalCSC.numCols() + 1);
            this._indexes = Arrays.copyOf(originalCSC._indexes, originalCSC._size);
            this._values = Arrays.copyOf(originalCSC._values, originalCSC._size);
        } else if (sblock instanceof SparseBlockMCSC) {
            SparseRow[] columns;
            SparseBlockMCSC originalMCSC = (SparseBlockMCSC)sblock;
            this._ptr = new int[originalMCSC.numCols() + 1];
            this._ptr[0] = 0;
            this._values = new double[(int)originalMCSC.size()];
            this._indexes = new int[(int)originalMCSC.size()];
            int ptrPos = 1;
            int valPos = 0;
            for (SparseRow column : columns = originalMCSC.getCols()) {
                int[] rowIdx = column.indexes();
                double[] vals = column.values();
                System.arraycopy(rowIdx, 0, this._indexes, valPos, column.size());
                System.arraycopy(vals, 0, this._values, valPos, column.size());
                this._ptr[ptrPos] = this._ptr[ptrPos - 1] + column.size();
                ++ptrPos;
                valPos += column.size();
            }
        } else {
            int rlen = this._rlen;
            int clen = this._clenInferred;
            int nnz = this._size;
            int[] colCounts = new int[clen];
            for (int i = 0; i < rlen; ++i) {
                if (sblock.isEmpty(i)) continue;
                int alen = sblock.size(i);
                int apos = sblock.pos(i);
                int[] aix = sblock.indexes(i);
                for (int k = apos; k < apos + alen; ++k) {
                    int col;
                    int n = col = aix[k];
                    colCounts[n] = colCounts[n] + 1;
                }
            }
            this._ptr = new int[clen + 1];
            this._ptr[0] = 0;
            for (int j = 0; j < clen; ++j) {
                this._ptr[j + 1] = this._ptr[j] + colCounts[j];
            }
            this._size = nnz;
            this._indexes = new int[nnz];
            this._values = new double[nnz];
            int[] colPositions = new int[clen];
            System.arraycopy(this._ptr, 0, colPositions, 0, clen);
            for (int i = 0; i < rlen; ++i) {
                if (sblock.isEmpty(i)) continue;
                int alen = sblock.size(i);
                int apos = sblock.pos(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    int col = aix[k];
                    int pos = colPositions[col];
                    this._indexes[pos] = i;
                    this._values[pos] = avals[k];
                    int n = col;
                    colPositions[n] = colPositions[n] + 1;
                }
            }
        }
    }

    public SparseBlockCSC(SparseRow[] cols, int nnz) {
        int clen;
        this._clenInferred = clen = cols.length;
        this._ptr = new int[clen + 1];
        this._indexes = new int[nnz];
        this._values = new double[nnz];
        this._size = nnz;
        int pos = 0;
        for (int i = 0; i < clen; ++i) {
            if (cols[i] != null && !cols[i].isEmpty()) {
                int alen = cols[i].size();
                int[] aix = cols[i].indexes();
                double[] avals = cols[i].values();
                System.arraycopy(aix, 0, this._indexes, pos, alen);
                System.arraycopy(avals, 0, this._values, pos, alen);
                pos += alen;
            }
            this._ptr[i + 1] = pos;
        }
    }

    public SparseBlockCSC(int cols, int[] rowInd, int[] colInd, double[] values) {
        int nnz = values.length;
        this._ptr = new int[cols + 1];
        this._indexes = Arrays.copyOf(rowInd, rowInd.length);
        this._values = Arrays.copyOf(values, nnz);
        this._size = nnz;
        this._clenInferred = cols;
        int clast = 0;
        for (int i = 0; i < nnz; ++i) {
            int c = colInd[i];
            if (clast < c) {
                Arrays.fill(this._ptr, clast + 1, c + 1, i);
            }
            clast = c;
        }
        Arrays.fill(this._ptr, clast + 1, this.numCols() + 1, nnz);
    }

    public SparseBlockCSC(int cols, int nnz, int[] rowInd) {
        this._clenInferred = cols;
        this._ptr = new int[cols + 1];
        this._indexes = Arrays.copyOf(rowInd, nnz);
        this._values = new double[nnz];
        Arrays.fill(this._values, 1.0);
        this._size = nnz;
        int pos = 0;
        for (int i = 0; i < cols; ++i) {
            if (rowInd[i] >= 0 && cols > nnz) {
                this._indexes[pos] = rowInd[i];
            }
            this._ptr[i + 1] = ++pos;
        }
    }

    public void initUltraSparse(int nnz, DataInput in) throws IOException {
        if (this._values.length < nnz) {
            this.resize(this.newCapacity(nnz));
        }
        int clast = 0;
        for (int i = 0; i < nnz; ++i) {
            int r = in.readInt();
            int c = in.readInt();
            double v = in.readDouble();
            if (clast < c) {
                Arrays.fill(this._ptr, clast + 1, c + 1, i);
            }
            clast = c;
            this._indexes[i] = r;
            this._values[i] = v;
        }
        Arrays.fill(this._ptr, clast + 1, this.numCols() + 1, nnz);
        this._size = nnz;
    }

    public void initSparse(int clen, int nnz, DataInput in) throws IOException {
        if (this._values.length < nnz) {
            this.resize(this.newCapacity(nnz));
            System.out.println("hallo");
        }
        this._ptr[0] = 0;
        int pos = 0;
        for (int c = 0; c < clen; ++c) {
            int lnnz = in.readInt();
            int j = 0;
            while (j < lnnz) {
                this._indexes[pos] = in.readInt();
                this._values[pos] = in.readDouble();
                ++j;
                ++pos;
            }
            this._ptr[c + 1] = pos;
        }
        this._size = nnz;
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        double lnnz = Math.max(4.0, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 24.0;
        size += MemoryEstimates.intArrayCost(nrows + 1L);
        size += MemoryEstimates.intArrayCost((long)lnnz);
        return (long)Math.min(size += MemoryEstimates.doubleArrayCost((long)lnnz), 9.223372036854776E18);
    }

    public int[] colPointers() {
        return this._ptr;
    }

    public int[] indexes() {
        return this.indexes(0);
    }

    public double[] values() {
        return this.values(0);
    }

    @Override
    public void allocate(int r) {
    }

    @Override
    public void allocate(int r, int nnz) {
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
    }

    @Override
    public void compact(int r) {
    }

    @Override
    public int numRows() {
        int rlen;
        if (this._rlen > -1) {
            return this._rlen;
        }
        this._rlen = rlen = Arrays.stream(this._indexes).max().getAsInt();
        return rlen;
    }

    public int numCols() {
        return this._ptr.length - 1;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public boolean isAllocated(int r) {
        return true;
    }

    @Override
    public void reset() {
        if (this._size > 0) {
            Arrays.fill(this._ptr, 0);
            this._size = 0;
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        if (this._size > 0) {
            Arrays.fill(this._ptr, 0);
            this._size = 0;
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        ArrayList<Integer> posIdx = new ArrayList<Integer>();
        for (int i = 0; i < this._ptr.length - 1; ++i) {
            for (int j = this._ptr[i]; j < this._ptr[i + 1]; ++j) {
                if (this._indexes[j] != r) continue;
                cols.add(i);
                posIdx.add(j);
            }
        }
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            int c = (Integer)i.next();
            this.decrPtr(c + 1);
        }
        for (int i2 = posIdx.size() - 1; i2 >= 0; --i2) {
            if ((Integer)posIdx.get(i2) >= this._size - 1) continue;
            System.arraycopy(this._indexes, (Integer)posIdx.get(i2) + 1, this._indexes, (Integer)posIdx.get(i2), this._size - ((Integer)posIdx.get(i2) + 1));
            System.arraycopy(this._values, (Integer)posIdx.get(i2) + 1, this._values, (Integer)posIdx.get(i2), this._size - ((Integer)posIdx.get(i2) + 1));
        }
        this._size -= posIdx.size();
    }

    public void resetCol(int c) {
        int pos = this.posCol(c);
        int len = this.sizeCol(c);
        if (len > 0) {
            System.arraycopy(this._indexes, pos + len, this._indexes, pos, this._size - (pos + len));
            System.arraycopy(this._values, pos + len, this._values, pos, this._size - (pos + len));
            this._size -= len;
            this.decrPtr(c + 1, len);
        }
    }

    @Override
    public long size() {
        return this._ptr[this._ptr.length - 1];
    }

    @Override
    public int size(int r) {
        if (r < 0) {
            throw new RuntimeException("Row index has to be zero or larger.");
        }
        int nnz = 0;
        for (int c = 0; c < this._ptr.length - 1; ++c) {
            int ix = Arrays.binarySearch(this._indexes, this._ptr[c], this._ptr[c + 1], r);
            if (ix < 0) continue;
            ++nnz;
        }
        return nnz;
    }

    public int sizeCol(int c) {
        return this._ptr[c + 1] - this._ptr[c];
    }

    @Override
    public long size(int rl, int ru) {
        if (rl < 0 || ru > this._rlen) {
            throw new RuntimeException("Incorrect row boundaries.");
        }
        int nnz = 0;
        int row = -1;
        block0: for (int i = 0; i < this._size; ++i) {
            row = this._indexes[i];
            for (int j = rl; j < ru; ++j) {
                if (row != j) continue;
                ++nnz;
                continue block0;
            }
        }
        return nnz;
    }

    public long sizeCol(int cl, int cu) {
        return this._ptr[cu] - this._ptr[cl];
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = cl; i < cu; ++i) {
            if (this.isEmptyCol(i)) continue;
            int start = this.internPosFIndexGTECol(rl, i);
            int end = this.internPosFIndexLTECol(ru - 1, i);
            nnz += start != -1 && end != -1 ? (long)(end - start + 1) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        int clen = this.numCols();
        for (int c = 0; c < clen; ++c) {
            int ix = Arrays.binarySearch(this._indexes, this._ptr[c], this._ptr[c + 1], r);
            if (ix < 0) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyCol(int c) {
        return this._ptr[c + 1] - this._ptr[c] == 0;
    }

    @Override
    public boolean checkValidity(int rlen, int clen, long nnz, boolean strict) {
        int i;
        if (rlen < 0 || clen < 0) {
            throw new RuntimeException("Invalid block dimensions: " + rlen + " " + clen);
        }
        if ((long)this._size != nnz && this._ptr.length < clen + 1 && (long)this._values.length < nnz && (long)this._indexes.length < nnz) {
            throw new RuntimeException("Incorrect array lengths.");
        }
        for (i = 1; i < clen; ++i) {
            if (this._ptr[i - 1] <= this._ptr[i] || !strict) continue;
            throw new RuntimeException("Column pointers are decreasing at column: " + i + ", with pointers " + this._ptr[i - 1] + " > " + this._ptr[i]);
        }
        for (i = 0; i < clen; ++i) {
            int k;
            int apos = this.posCol(i);
            int alen = this.sizeCol(i);
            for (k = apos + 1; k < apos + alen; ++k) {
                if (this._indexes[k - 1] < this._indexes[k]) continue;
                throw new RuntimeException("Wrong sparse column ordering: " + k + " " + this._indexes[k - 1] + " " + this._indexes[k]);
            }
            for (k = apos; k < apos + alen; ++k) {
                if (this._values[k] != 0.0) continue;
                throw new RuntimeException("Wrong sparse column: zero at " + k + " at row index " + this._indexes[k]);
            }
        }
        for (i = 0; i < this._size; ++i) {
            if (this._values[i] != 0.0) continue;
            throw new RuntimeException("The values array should not contain zeros. The " + i + "th value is " + this._values[i]);
        }
        int capacity = this._values.length;
        if ((double)capacity > (double)nnz * 2.0) {
            throw new RuntimeException("Capacity is larger than the nnz times a resize factor. Current size: " + capacity + ", while Expected size:" + (double)nnz * 2.0);
        }
        return true;
    }

    @Override
    public long getExactSizeInMemory() {
        double size = 24.0;
        size += MemoryEstimates.intArrayCost(this._ptr.length);
        size += MemoryEstimates.intArrayCost(this._indexes.length);
        return (long)Math.min(size += MemoryEstimates.doubleArrayCost(this._values.length), 9.223372036854776E18);
    }

    @Override
    public int[] indexes(int r) {
        int clen = this.numCols();
        int[] cix = new int[clen];
        int pos = 0;
        for (int c = 0; c < clen; ++c) {
            int ix = Arrays.binarySearch(this._indexes, this._ptr[c], this._ptr[c + 1], r);
            if (ix < 0) continue;
            cix[pos++] = c;
        }
        return cix;
    }

    public int[] indexesCol(int c) {
        return this._indexes;
    }

    @Override
    public double[] values(int r) {
        int clen = this.numCols();
        double[] vals = new double[clen];
        int pos = 0;
        for (int c = 0; c < clen; ++c) {
            int ix = Arrays.binarySearch(this._indexes, this._ptr[c], this._ptr[c + 1], r);
            if (ix < 0) continue;
            vals[pos++] = this._values[ix];
        }
        return vals;
    }

    public double[] valuesCol(int c) {
        return this._values;
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    public int posCol(int c) {
        return this._ptr[c];
    }

    @Override
    public boolean set(int r, int c, double v) {
        int len;
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        if (index >= 0) {
            if (v == 0.0) {
                this.shiftLeftAndDelete(index);
                this.decrPtr(c + 1);
                return true;
            }
            this._values[index] = v;
            return false;
        }
        if (v == 0.0) {
            return false;
        }
        index = Math.abs(index + 1);
        if (this._size == this._values.length) {
            this.resizeAndInsert(index, r, v);
        } else {
            this.shiftRightAndInsert(index, r, v);
        }
        this.incrPtr(c + 1);
        return true;
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        double[] values = row.values();
        int[] colIndexes = row.indexes();
        for (int i = 0; i < row.size(); ++i) {
            this.set(r, colIndexes[i], values[i]);
        }
    }

    public void setCol(int c, SparseRow col, boolean deep) {
        int lsize;
        int pos = this.posCol(c);
        int len = this.sizeCol(c);
        int alen = col.size();
        int[] aix = col.indexes();
        double[] avals = col.values();
        if (len > 0) {
            this.deleteIndexRange(c, aix[pos], aix[pos + len - 1] + 1);
        }
        if (this._values.length < (lsize = this._size + alen)) {
            this.resize(lsize);
        }
        this.shiftRightByN(pos, alen);
        this.incrPtr(c + 1, alen);
        System.arraycopy(aix, 0, this._indexes, pos, alen);
        System.arraycopy(avals, 0, this._values, pos, alen);
    }

    @Override
    public boolean add(int r, int c, double v) {
        int len;
        if (v == 0.0) {
            return false;
        }
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        if (index >= 0) {
            int n = index;
            this._values[n] = this._values[n] + v;
            return false;
        }
        index = Math.abs(index + 1);
        if (this._size == this._values.length) {
            this.resizeAndInsert(index, r, v);
        } else {
            this.shiftRightAndInsert(index, r, v);
        }
        this.incrPtr(c + 1);
        return true;
    }

    @Override
    public void append(int r, int c, double v) {
        int len;
        if (v == 0.0) {
            return;
        }
        int pos = this.posCol(c);
        if (pos + (len = this.sizeCol(c)) == this._size) {
            if (this._size == this._values.length) {
                this.resize();
            }
            this.insert(this._size, r, v);
        } else if (this._size == this._values.length) {
            this.resizeAndInsert(pos + len, r, v);
        } else {
            this.shiftRightAndInsert(pos + len, r, v);
        }
        this.incrPtr(c + 1);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        int i;
        int lnnz;
        int lsize;
        if (!this.isEmpty(r)) {
            this.deleteIndexRange(r, cl, cu);
        }
        if (this._values.length < (lsize = this._size + (lnnz = UtilFunctions.computeNnz(v, vix, vlen)))) {
            this.resize(lsize);
        }
        int[] posIdx = new int[vlen];
        int insertionPnt = 0;
        for (i = cl; i < cu; ++i) {
            for (int j = this._ptr[i]; j < this._ptr[i + 1]; ++j) {
                if (this._indexes[j] > r) {
                    posIdx[insertionPnt] = j;
                    break;
                }
                if (j != this._ptr[i + 1] - 1) continue;
                posIdx[insertionPnt] = j + 1;
            }
            ++insertionPnt;
        }
        for (i = vix + vlen - 1; i >= vix; --i) {
            System.arraycopy(this._indexes, posIdx[i - vix], this._indexes, posIdx[i - vix] + 1, this._size - posIdx[i - vix]);
            System.arraycopy(this._values, posIdx[i - vix], this._values, posIdx[i - vix] + 1, this._size - posIdx[i - vix]);
            ++this._size;
            this._values[posIdx[i - vix]] = v[i];
            this._indexes[posIdx[i - vix]] = r;
        }
        for (int c = cl; c < cu; ++c) {
            this.incrPtr(c + 1);
        }
    }

    public void setIndexRangeCol(int c, int rl, int ru, double[] v, int vix, int vlen) {
        int index;
        int lnnz;
        int lsize;
        if (!this.isEmptyCol(c)) {
            this.deleteIndexRangeCol(c, rl, ru);
        }
        if (this._values.length < (lsize = this._size + (lnnz = UtilFunctions.computeNnz(v, vix, vlen)))) {
            this.resize(lsize);
        }
        int index2 = (index = this.internPosFIndexGTCol(rl, c)) > 0 ? index : this.posCol(c + 1);
        this.shiftRightByN(index2, lnnz);
        for (int i = vix; i < vix + vlen; ++i) {
            if (v[i] == 0.0) continue;
            this._indexes[index2] = rl + i - vix;
            this._values[index2] = v[i];
            ++index2;
        }
        this.incrPtr(c + 1, lnnz);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        int i;
        int lsize;
        if (!this.isEmpty(r)) {
            this.deleteIndexRange(r, cl, cu);
        }
        if (this._values.length < (lsize = this._size + vlen)) {
            this.resize(lsize);
        }
        int[] posIdx = new int[vlen];
        int insertionPnt = 0;
        int currentCol = 0;
        for (i = vpos; i < vpos + vlen; ++i) {
            currentCol = vix[i];
            for (int j = this._ptr[currentCol]; j < this._ptr[currentCol + 1]; ++j) {
                if (this._indexes[j] > r) {
                    posIdx[insertionPnt] = j;
                    break;
                }
                if (j != this._ptr[currentCol + 1] - 1) continue;
                posIdx[insertionPnt] = j + 1;
            }
            ++insertionPnt;
        }
        for (i = vpos + vlen - 1; i >= vpos; --i) {
            System.arraycopy(this._indexes, posIdx[i - vpos], this._indexes, posIdx[i - vpos] + 1, this._size - posIdx[i - vpos]);
            System.arraycopy(this._values, posIdx[i - vpos], this._values, posIdx[i - vpos] + 1, this._size - posIdx[i - vpos]);
            ++this._size;
            this._values[posIdx[i - vpos]] = v[i];
            this._indexes[posIdx[i - vpos]] = r;
        }
        for (i = vpos; i < vpos + vlen; ++i) {
            currentCol = vix[i];
            this.incrPtr(currentCol + 1);
        }
    }

    public void setIndexRangeCol(int c, int rl, int ru, double[] v, int[] vix, int vpos, int vlen) {
        int index;
        int lsize;
        if (!this.isEmptyCol(c)) {
            this.deleteIndexRangeCol(c, rl, ru);
        }
        if (this._values.length < (lsize = this._size + vlen)) {
            this.resize(lsize);
        }
        int index2 = (index = this.internPosFIndexGTCol(rl, c)) > 0 ? index : this.posCol(c + 1);
        this.shiftRightByN(index2, vlen);
        for (int i = vpos; i < vpos + vlen; ++i) {
            this._indexes[index2] = vix[i];
            this._values[index2] = v[i];
            ++index2;
        }
        this.incrPtr(c + 1, vlen);
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        ArrayList<Integer> posIdx = new ArrayList<Integer>();
        for (int i = cl; i < cu; ++i) {
            for (int j = this._ptr[i]; j < this._ptr[i + 1]; ++j) {
                if (this._indexes[j] != r) continue;
                cols.add(i);
                posIdx.add(j);
            }
        }
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            int c = (Integer)i.next();
            this.decrPtr(c + 1);
        }
        for (int i2 = posIdx.size() - 1; i2 >= 0; --i2) {
            if ((Integer)posIdx.get(i2) >= this._size - 1) continue;
            System.arraycopy(this._indexes, (Integer)posIdx.get(i2) + 1, this._indexes, (Integer)posIdx.get(i2), this._size - ((Integer)posIdx.get(i2) + 1));
            System.arraycopy(this._values, (Integer)posIdx.get(i2) + 1, this._values, (Integer)posIdx.get(i2), this._size - ((Integer)posIdx.get(i2) + 1));
        }
        this._size -= posIdx.size();
    }

    public void deleteIndexRangeCol(int c, int rl, int ru) {
        int start = this.internPosFIndexGTECol(rl, c);
        if (start < 0) {
            return;
        }
        int len = this.sizeCol(c);
        int end = this.internPosFIndexGTECol(ru, c);
        if (end < 0) {
            end = start + len;
        }
        System.arraycopy(this._indexes, end, this._indexes, start, this._size - end);
        System.arraycopy(this._values, end, this._values, start, this._size - end);
        this._size -= end - start;
        this.decrPtr(c + 1, end - start);
    }

    @Override
    public void sort() {
        for (int i = 0; i < this.numCols() && this.posCol(i) < this._size; ++i) {
            this.sortCol(i);
        }
    }

    @Override
    public void sort(int r) {
        this.sort();
    }

    public void sortCol(int c) {
        int pos = this.posCol(c);
        int len = this.sizeCol(c);
        if (len <= 100 || !SortUtils.isSorted(pos, pos + len, this._indexes)) {
            SortUtils.sortByIndex(pos, pos + len, this._indexes, this._values);
        }
    }

    @Override
    public double get(int r, int c) {
        int len;
        if (this.isEmptyCol(c)) {
            return 0.0;
        }
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        return index >= 0 ? this._values[index] : 0.0;
    }

    @Override
    public SparseRow get(int r) {
        int clen = this.numCols();
        SparseRowVector row = new SparseRowVector(clen);
        for (int c = 0; c < clen; ++c) {
            int ix = Arrays.binarySearch(this._indexes, this._ptr[c], this._ptr[c + 1], r);
            if (ix < 0) continue;
            row.append(c, this._values[ix]);
        }
        return row;
    }

    public SparseRow getCol(int c) {
        if (this.isEmptyCol(c)) {
            return new SparseRowScalar();
        }
        int pos = this.posCol(c);
        int len = this.sizeCol(c);
        SparseRowVector col = new SparseRowVector(len);
        System.arraycopy(this._indexes, pos, col.indexes(), 0, len);
        System.arraycopy(this._values, pos, col.values(), 0, len);
        col.setSize(len);
        return col;
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        int index = this.internPosFIndexLTE(r, c);
        return index >= 0 ? index - this.pos(r) : index;
    }

    public int posFIndexLTECol(int r, int c) {
        int index = this.internPosFIndexLTECol(r, c);
        return index >= 0 ? index - this.posCol(c) : index;
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        int pos = this.pos(r);
        int len = this.size(r);
        int end = pos + len;
        int index = Arrays.binarySearch(this.indexes(r), pos, end, c);
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return index < end ? index - pos : -1;
    }

    public int posFIndexGTECol(int r, int c) {
        int len;
        int end;
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, end = pos + (len = this.sizeCol(c)), r);
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return index < end ? index - pos : -1;
    }

    @Override
    public int posFIndexGT(int r, int c) {
        int index = this.internPosFIndexGT(r, c);
        return index >= 0 ? index - this.pos(r) : index;
    }

    public int posFIndexGTCol(int r, int c) {
        int index = this.internPosFIndexGTCol(r, c);
        return index >= 0 ? index - this.posCol(c) : index;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockCSR: clen=");
        sb.append(this.numCols());
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        int colDigits = (int)Math.max(Math.ceil(Math.log10(this.numCols())), 1.0);
        for (int i = 0; i < this.numCols(); ++i) {
            int len;
            int pos = this.posCol(i);
            if (pos >= pos + (len = this.sizeCol(i))) continue;
            sb.append(String.format("%0" + colDigits + "d ", i));
            for (int j = pos; j < pos + len; ++j) {
                if (this._values[j] == (double)((long)this._values[j])) {
                    sb.append(String.format("%" + colDigits + "d:%d", this._indexes[j], (long)this._values[j]));
                } else {
                    sb.append(String.format("%" + colDigits + "d:%s", this._indexes[j], Double.toString(this._values[j])));
                }
                if (j + 1 >= pos + len) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Iterator<Integer> getNonEmptyRowsIterator(int rl, int ru) {
        return new NonEmptyRowsIteratorCSC(rl, ru);
    }

    public Iterator<Integer> getNonEmptyColumnsIterator(int cl, int cu) {
        return new NonEmptyColumnsIteratorCSC(cl, cu);
    }

    private void inferNumCol(SparseBlock sblock) {
        int[] indexes = null;
        if (sblock instanceof SparseBlockMCSR) {
            SparseRow[] origRows;
            for (SparseRow row : origRows = ((SparseBlockMCSR)sblock).getRows()) {
                int max;
                if (row == null || (max = Arrays.stream(indexes = row.indexes()).max().getAsInt()) <= this._clenInferred) continue;
                this._clenInferred = max;
            }
        } else if (sblock instanceof SparseBlockMCSC) {
            this._clenInferred = ((SparseBlockMCSC)sblock).getCols().length;
        } else if (sblock instanceof SparseBlockCSC) {
            this._clenInferred = ((SparseBlockCSC)sblock).numCols();
        } else {
            indexes = sblock.indexes(0);
            this._clenInferred = Arrays.stream(indexes).max().getAsInt();
        }
        ++this._clenInferred;
    }

    private int newCapacity(int minsize) {
        double tmpCap;
        for (tmpCap = (double)Math.max(this._values.length, 1); tmpCap < (double)minsize; tmpCap *= tmpCap <= 1024.0 ? 2.0 : 1.1) {
        }
        return (int)Math.min(tmpCap, 2.147483647E9);
    }

    private void resize() {
        int newCap = this.newCapacity(this._values.length + 1);
        this.resizeCopy(newCap);
    }

    private void resize(int minsize) {
        int newCap = this.newCapacity(minsize);
        this.resizeCopy(newCap);
    }

    private void resizeCopy(int capacity) {
        this._indexes = Arrays.copyOf(this._indexes, capacity);
        this._values = Arrays.copyOf(this._values, capacity);
    }

    private void resizeAndInsert(int ix, int r, double v) {
        int newCap = this.newCapacity(this._values.length + 1);
        int[] oldindexes = this._indexes;
        double[] oldvalues = this._values;
        this._indexes = new int[newCap];
        this._values = new double[newCap];
        System.arraycopy(oldindexes, 0, this._indexes, 0, ix);
        System.arraycopy(oldvalues, 0, this._values, 0, ix);
        System.arraycopy(oldindexes, ix, this._indexes, ix + 1, this._size - ix);
        System.arraycopy(oldvalues, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, r, v);
    }

    private void shiftRightAndInsert(int ix, int r, double v) {
        System.arraycopy(this._indexes, ix, this._indexes, ix + 1, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + 1, this._size - ix);
        this.insert(ix, r, v);
    }

    private void shiftLeftAndDelete(int ix) {
        System.arraycopy(this._indexes, ix + 1, this._indexes, ix, this._size - ix - 1);
        System.arraycopy(this._values, ix + 1, this._values, ix, this._size - ix - 1);
        --this._size;
    }

    private void shiftRightByN(int ix, int n) {
        System.arraycopy(this._indexes, ix, this._indexes, ix + n, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix + n, this._size - ix);
        this._size += n;
    }

    private void shiftLeftByN(int ix, int n) {
        System.arraycopy(this._indexes, ix, this._indexes, ix - n, this._size - ix);
        System.arraycopy(this._values, ix, this._values, ix - n, this._size - ix);
        this._size -= n;
    }

    private void insert(int ix, int r, double v) {
        this._indexes[ix] = r;
        this._values[ix] = v;
        ++this._size;
    }

    private void incrPtr(int cl) {
        this.incrPtr(cl, 1);
    }

    private void incrPtr(int cl, int cnt) {
        int clen = this.numCols();
        int i = cl;
        while (i < clen + 1) {
            int n = i++;
            this._ptr[n] = this._ptr[n] + cnt;
        }
    }

    private void decrPtr(int cl) {
        this.decrPtr(cl, 1);
    }

    private void decrPtr(int cl, int cnt) {
        int i = cl;
        while (i < this._ptr.length) {
            int n = i++;
            this._ptr[n] = this._ptr[n] - cnt;
        }
    }

    private int internPosFIndexLTECol(int r, int c) {
        int len;
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) - 1 >= pos ? index - 1 : -1;
    }

    private int internPosFIndexGTECol(int r, int c) {
        int len;
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    private int internPosFIndexGTCol(int r, int c) {
        int len;
        int pos = this.posCol(c);
        int index = Arrays.binarySearch(this._indexes, pos, pos + (len = this.sizeCol(c)), r);
        if (index >= 0) {
            return index + 1 < pos + len ? index + 1 : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    private int internPosFIndexLTE(int r, int c) {
        int pos = this.pos(r);
        int len = this.size(r);
        int index = Arrays.binarySearch(this.indexes(r), pos, pos + len, c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) - 1 >= pos ? index - 1 : -1;
    }

    private int internPosFIndexGTE(int r, int c) {
        int pos = this.pos(r);
        int len = this.size(r);
        int index = Arrays.binarySearch(this.indexes(r), pos, pos + len, c);
        if (index >= 0) {
            return index < pos + len ? index : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    private int internPosFIndexGT(int r, int c) {
        int pos = this.pos(r);
        int len = this.size(r);
        int index = Arrays.binarySearch(this.indexes(r), pos, pos + len, c);
        if (index >= 0) {
            return index + 1 < pos + len ? index + 1 : -1;
        }
        return (index = Math.abs(index + 1)) < pos + len ? index : -1;
    }

    private class SparseNonEmptyColumnIterable
    implements Iterable<Integer> {
        private final int _cl;
        private final int _cu;

        protected SparseNonEmptyColumnIterable(int cl, int cu) {
            this._cl = cl;
            this._cu = cu;
        }

        @Override
        public Iterator<Integer> iterator() {
            return SparseBlockCSC.this.getNonEmptyColumnsIterator(this._cl, this._cu);
        }
    }

    public class NonEmptyColumnsIteratorCSC
    implements Iterator<Integer> {
        private int _cpos;
        private final int _cu;

        public NonEmptyColumnsIteratorCSC(int cl, int cu) {
            this._cpos = cl;
            this._cu = cu;
        }

        @Override
        public boolean hasNext() {
            while (this._cpos < this._cu && SparseBlockCSC.this.isEmptyCol(this._cpos)) {
                ++this._cpos;
            }
            return this._cpos < this._cu;
        }

        @Override
        public Integer next() {
            return this._cpos++;
        }
    }

    public class NonEmptyRowsIteratorCSC
    implements Iterator<Integer> {
        private int _rpos;
        private final int _ru;
        private BitSet _rows = null;

        public NonEmptyRowsIteratorCSC(int rl, int ru) {
            this._rpos = rl;
            this._ru = ru;
            this.checkNonEmptyRows();
        }

        @Override
        public boolean hasNext() {
            while (this._rpos < this._ru && !this._rows.get(this._rpos)) {
                ++this._rpos;
            }
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            return this._rpos++;
        }

        private void checkNonEmptyRows() {
            int rlen = SparseBlockCSC.this.numRows();
            this._rows = new BitSet(rlen);
            for (int i = 0; i < SparseBlockCSC.this._size; ++i) {
                this._rows.set(SparseBlockCSC.this._indexes[i]);
            }
        }
    }
}

