/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public interface MatrixBlockFromFrame {
    public static final Log LOG = LogFactory.getLog((String)MatrixBlockFromFrame.class.getName());
    public static final int blocksizeIJ = 32;

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame, int k) {
        int m = frame.getNumRows();
        int n = frame.getNumColumns();
        MatrixBlock mb = new MatrixBlock(m, n, false);
        mb.allocateDenseBlock();
        if (k == -1) {
            k = InfrastructureAnalyzer.getLocalParallelism();
        }
        long nnz = 0L;
        nnz = k == 1 ? MatrixBlockFromFrame.convert(frame, mb, n, 0, m) : MatrixBlockFromFrame.convertParallel(frame, mb, m, n, k);
        mb.setNonZeros(nnz);
        mb.examSparsity();
        return mb;
    }

    private static long convert(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        if (mb.getDenseBlock().isContiguous()) {
            return MatrixBlockFromFrame.convertContiguous(frame, mb, n, rl, ru);
        }
        return MatrixBlockFromFrame.convertGeneric(frame, mb, n, rl, ru);
    }

    private static long convertParallel(FrameBlock frame, MatrixBlock mb, int m, int n, int k) {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList<Future<Long>> tasks = new ArrayList<Future<Long>>();
            int blkz = Math.max(m / k, 1000);
            for (int i = 0; i < m; i += blkz) {
                int start = i;
                int end = Math.min(i + blkz, m);
                tasks.add(pool.submit(() -> MatrixBlockFromFrame.convert(frame, mb, n, start, end)));
            }
            long nnz = 0L;
            for (Future future : tasks) {
                nnz += ((Long)future.get()).longValue();
            }
            long l = nnz;
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
    }

    private static long convertContiguous(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        long lnnz = 0L;
        double[] c = mb.getDenseBlockValues();
        for (int bi = rl; bi < ru; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, ru);
                int bjmin = Math.min(bj + 32, n);
                int i = bi;
                int aix = bi * n;
                while (i < bimin) {
                    for (int j = bj; j < bjmin; ++j) {
                        double d = frame.getDoubleNaN(i, j);
                        c[aix + j] = d;
                        lnnz += d != 0.0 ? 1L : 0L;
                    }
                    ++i;
                    aix += n;
                }
            }
        }
        return lnnz;
    }

    private static long convertGeneric(FrameBlock frame, MatrixBlock mb, int n, int rl, int ru) {
        long lnnz = 0L;
        DenseBlock c = mb.getDenseBlock();
        for (int bi = rl; bi < ru; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, ru);
                int bjmin = Math.min(bj + 32, n);
                for (int i = bi; i < bimin; ++i) {
                    double[] cvals = c.values(i);
                    int cpos = c.pos(i);
                    for (int j = bj; j < bjmin; ++j) {
                        double d = frame.getDoubleNaN(i, j);
                        cvals[cpos + j] = d;
                        lnnz += d != 0.0 ? 1L : 0L;
                    }
                }
            }
        }
        return lnnz;
    }
}

