/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCZeros
extends ASDCZero
implements IMapToDataGroup {
    private static final long serialVersionUID = -3703199743391937991L;
    protected final AMapToData _data;

    private ColGroupSDCZeros(IColIndex colIndices, int numRows, IDictionary dict, AOffset indexes, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, indexes, cachedCounts);
        if (data.getUnique() != dict.getNumberOfValues(colIndices.size())) {
            throw new DMLCompressionException("Invalid construction of SDCZero group: number uniques: " + data.getUnique() + " vs." + dict.getNumberOfValues(colIndices.size()));
        }
        this._data = data;
    }

    public static AColGroup create(IColIndex colIndices, int numRows, IDictionary dict, AOffset offsets, AMapToData data, int[] cachedCounts) {
        if (dict == null) {
            return new ColGroupEmpty(colIndices);
        }
        if (data.getUnique() == 1) {
            MatrixBlock mb = dict.getMBDict(colIndices.size()).getMatrixBlock().slice(0, 0);
            return ColGroupSDCSingleZeros.create(colIndices, numRows, MatrixBlockDictionary.create(mb), offsets, null);
        }
        return new ColGroupSDCZeros(colIndices, numRows, dict, offsets, data, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCZeros;
    }

    @Override
    public AMapToData getMapToData() {
        return this._data;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, values, it);
        }
    }

    @Override
    public final void decompressToDenseBlockDenseDictionaryWithProvidedIterator(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int last = this._indexes.getOffsetToLast();
        if (it == null || it.value() >= ru || rl > last) {
            return;
        }
        boolean post = ru > last;
        boolean contiguous = db.isContiguous();
        if (post) {
            if (contiguous && this._colIndexes.size() == 1) {
                this.decompressToDenseBlockDenseDictionaryPostSingleColContiguous(db, rl, ru, offR, offC, values, it);
            } else if (contiguous && this._colIndexes.size() == db.getDim(1)) {
                this.decompressToDenseBlockDenseDictioanryPostAllCols(db, rl, ru, offR, values, it);
            } else {
                this.decompressToDenseBlockDenseDictionaryPostGeneric(db, rl, ru, offR, offC, values, it);
            }
        } else if (contiguous && this._colIndexes.size() == 1) {
            if (db.getDim(1) == 1) {
                ColGroupSDCZeros.decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(db, ru, offR, offC, values, it, this._data);
            } else {
                this.decompressToDenseBlockDenseDictionaryPreSingleColContiguous(db, rl, ru, offR, offC, values, it);
            }
        } else if (this._colIndexes.size() == db.getDim(1)) {
            this.decompressToDenseBlockDenseDictionaryPreAllCols(db, rl, ru, offR, offC, values, it);
        } else {
            this.decompressToDenseBlockDenseDictionaryPreGeneric(db, rl, ru, offR, offC, values, it);
        }
    }

    private final void decompressToDenseBlockDenseDictionaryPostSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int off;
        int lastOff = this._indexes.getOffsetToLast() + offR;
        int nCol = db.getDim(1);
        double[] c = db.values(0);
        it.setOff(it.value() + offR);
        offC += this._colIndexes.get(0);
        while (it.value() < lastOff) {
            int n = off = it.value() * nCol + offC;
            c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
            it.next();
        }
        int n = off = it.value() * nCol + offC;
        c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
        it.setOff(it.value() - offR);
    }

    private final void decompressToDenseBlockDenseDictioanryPostAllCols(DenseBlock db, int rl, int ru, int offR, double[] values, AIterator it) {
        int lastOff = this._indexes.getOffsetToLast();
        int nCol = this._colIndexes.size();
        while (true) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx);
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + j;
                c[n] = c[n] + values[offDict + j];
            }
            if (it.value() == lastOff) {
                return;
            }
            it.next();
        }
    }

    private final void decompressToDenseBlockDenseDictionaryPostGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int lastOff = this._indexes.getOffsetToLast();
        int nCol = this._colIndexes.size();
        while (true) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[offDict + j];
            }
            if (it.value() == lastOff) {
                return;
            }
            it.next();
        }
    }

    private static void decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(DenseBlock db, int ru, int offR, int offC, double[] values, AIterator it, AMapToData m) {
        double[] c = db.values(0);
        int of = offR + offC;
        int last = ru + of;
        it.setOff(it.value() + of);
        while (it.isNotOver(last)) {
            int n = it.value();
            c[n] = c[n] + values[m.getIndex(it.getDataIndex())];
            it.next();
        }
        it.setOff(it.value() - of);
    }

    private void decompressToDenseBlockDenseDictionaryPreSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int last = ru + offR;
        int nCol = db.getDim(1);
        double[] c = db.values(0);
        it.setOff(it.value() + offR);
        offC += this._colIndexes.get(0);
        while (it.isNotOver(last)) {
            int off;
            int n = off = it.value() * nCol + offC;
            c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
            it.next();
        }
        it.setOff(it.value() - offR);
    }

    private void decompressToDenseBlockDenseDictionaryPreGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int nCol = this._colIndexes.size();
        while (it.isNotOver(ru)) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[offDict + j];
            }
            it.next();
        }
    }

    private void decompressToDenseBlockDenseDictionaryPreAllCols(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int nCol = this._colIndexes.size();
        while (it.isNotOver(ru)) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + j;
                c[n] = c[n] + values[offDict + j];
            }
            it.next();
        }
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int last;
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        }
        if (ru > (last = this._indexes.getOffsetToLast())) {
            this.decompressToDenseBlockSparseDictionaryPost(db, rl, ru, offR, offC, sb, it, last);
        } else {
            this.decompressToDenseBlockSparseDictionaryPre(db, rl, ru, offR, offC, sb, it);
        }
    }

    private final void decompressToDenseBlockSparseDictionaryPost(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb, AIterator it, int last) {
        while (true) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int dx = it.getDataIndex();
            int dictIndex = this._data.getIndex(dx);
            if (sb.isEmpty(dictIndex)) {
                if (it.value() == last) {
                    return;
                }
                it.next();
                continue;
            }
            int off = db.pos(idx) + offC;
            int apos = sb.pos(dictIndex);
            int alen = sb.size(dictIndex) + apos;
            double[] avals = sb.values(dictIndex);
            int[] aix = sb.indexes(dictIndex);
            for (int j = apos; j < alen; ++j) {
                int n = off + this._colIndexes.get(aix[j]);
                c[n] = c[n] + avals[j];
            }
            if (it.value() == last) {
                return;
            }
            it.next();
        }
    }

    private final void decompressToDenseBlockSparseDictionaryPre(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb, AIterator it) {
        while (it.isNotOver(ru)) {
            int idx = offR + it.value();
            int dx = it.getDataIndex();
            int dictIndex = this._data.getIndex(dx);
            if (sb.isEmpty(dictIndex)) {
                it.next();
                continue;
            }
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int apos = sb.pos(dictIndex);
            int alen = sb.size(dictIndex) + apos;
            double[] avals = sb.values(dictIndex);
            int[] aix = sb.indexes(dictIndex);
            for (int j = apos; j < alen; ++j) {
                int n = off + this._colIndexes.get(aix[j]);
                c[n] = c[n] + avals[j];
            }
            it.next();
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                int lastOff = this._indexes.getOffsetToLast();
                while (true) {
                    int row = offR + it.value();
                    int dx = it.getDataIndex();
                    int dictIndex = this._data.getIndex(dx);
                    if (sb.isEmpty(dictIndex)) {
                        if (it.value() == lastOff) {
                            return;
                        }
                        it.next();
                        continue;
                    }
                    int apos = sb.pos(dictIndex);
                    int alen = sb.size(dictIndex) + apos;
                    double[] avals = sb.values(dictIndex);
                    int[] aix = sb.indexes(dictIndex);
                    for (int j = apos; j < alen; ++j) {
                        ret.append(row, this._colIndexes.get(aix[j]) + offC, avals[j]);
                    }
                    if (it.value() == lastOff) {
                        return;
                    }
                    it.next();
                }
            }
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                int dx = it.getDataIndex();
                int dictIndex = this._data.getIndex(dx);
                if (sb.isEmpty(dictIndex)) {
                    it.next();
                    continue;
                }
                int apos = sb.pos(dictIndex);
                int alen = sb.size(dictIndex) + apos;
                double[] avals = sb.values(dictIndex);
                int[] aix = sb.indexes(dictIndex);
                for (int j = apos; j < alen; ++j) {
                    ret.append(row, this._colIndexes.get(aix[j]) + offC, avals[j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                int lastOff = this._indexes.getOffsetToLast();
                int nCol = this._colIndexes.size();
                while (true) {
                    int row = offR + it.value();
                    int dx = it.getDataIndex();
                    int offDict = this._data.getIndex(dx) * nCol;
                    for (int j = 0; j < nCol; ++j) {
                        ret.append(row, this._colIndexes.get(j) + offC, values[offDict + j]);
                    }
                    if (it.value() == lastOff) {
                        return;
                    }
                    it.next();
                }
            }
            int nCol = this._colIndexes.size();
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                int dx = it.getDataIndex();
                int offDict = this._data.getIndex(dx) * nCol;
                for (int j = 0; j < nCol; ++j) {
                    ret.append(row, this._colIndexes.get(j) + offC, values[offDict + j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return 0.0;
        }
        int nCol = this._colIndexes.size();
        return this._dict.getValue(this._data.getIndex(it.getDataIndex()) * nCol + colIdx);
    }

    @Override
    protected double[] preAggProductRows() {
        return this._dict.productAllRowsToDoubleWithDefault(new double[this._colIndexes.size()]);
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDCZeros.computeRowSums(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowProduct(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    protected static final void computeRowSums(double[] c, int rl, int ru, double[] preAgg, AMapToData data, AOffset indexes, int nRows) {
        AIterator it = indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() > ru) {
            indexes.cacheIterator(it, ru);
        } else if (ru > indexes.getOffsetToLast()) {
            int maxId = data.size() - 1;
            int n = it.value();
            c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
            while (it.getDataIndex() < maxId) {
                it.next();
                int n2 = it.value();
                c[n2] = c[n2] + preAgg[data.getIndex(it.getDataIndex())];
            }
        } else {
            while (it.isNotOver(ru)) {
                int n = it.value();
                c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
                it.next();
            }
            indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowMxx(c, builtin, rl, ru, preAgg, this._data, this._indexes, this._numRows, 0.0);
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    protected void multiplyScalar(double v, double[] resV, int offRet, AIterator it) {
        int dx = this._data.getIndex(it.getDataIndex());
        this._dict.multiplyScalar(v, resV, offRet, dx, this._colIndexes);
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        this._data.preAggregateDense(m, preAgg, rl, ru, cl, cu, this._indexes);
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru) {
        this._data.preAggregateSparse(sb, preAgg, rl, ru, this._indexes);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        boolean isSparseSafeOp;
        double val0 = op.executeScalar(0.0);
        boolean bl = isSparseSafeOp = op.sparseSafe || val0 == 0.0;
        if (isSparseSafeOp) {
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, this._dict.applyScalarOp(op), this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus || op.fn instanceof Minus && op instanceof RightScalarOperator) {
            double[] reference = ColGroupUtils.createReference(this._colIndexes.size(), val0);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), reference);
        }
        IDictionary newDict = this._dict.applyScalarOp(op);
        double[] defaultTuple = ColGroupUtils.createReference(this._colIndexes.size(), val0);
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double val0 = op.fn.execute(0L);
        IDictionary nDict = this._dict.applyUnaryOp(op);
        if (val0 == 0.0) {
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, nDict, this._indexes, this._data, this.getCachedCounts());
        }
        double[] defaultTuple = new double[this._colIndexes.size()];
        Arrays.fill(defaultTuple, val0);
        return ColGroupSDC.create(this._colIndexes, this._numRows, nDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            IDictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus) {
            double[] reference = ColGroupUtils.binaryDefRowLeft(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), reference);
        }
        IDictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.size()];
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            defaultTuple[i] = op.fn.execute(v[this._colIndexes.get(i)], 0.0);
        }
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            IDictionary ret = this._dict.binOpRight(op, v, this._colIndexes);
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, ret, this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus) {
            double[] def = ColGroupUtils.binaryDefRowRight(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), def);
        }
        IDictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.size()];
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            defaultTuple[i] = op.fn.execute(0.0, v[this._colIndexes.get(i)]);
        }
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
    }

    public static ColGroupSDCZeros read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        AOffset indexes = OffsetFactory.readIn(in);
        AMapToData data = MapToFactory.readIn(in);
        return new ColGroupSDCZeros(cols, nRows, dict, indexes, data, null);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += this._data.getInMemorySize();
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that instanceof ColGroupSDCZeros) {
            ColGroupSDCZeros th = (ColGroupSDCZeros)that;
            return th._indexes == this._indexes && th._data == this._data;
        }
        if (that instanceof ColGroupSDC) {
            ColGroupSDC th = (ColGroupSDC)that;
            return th._indexes == this._indexes && th._data == this._data;
        }
        return false;
    }

    @Override
    public void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        this._data.preAggregateSDCZ_DDC(that._data, that._dict, this._indexes, ret, that._colIndexes.size());
    }

    @Override
    public void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        this._data.preAggregateSDCZ_SDCZ(that._data, that._dict, that._indexes, this._indexes, ret, that._colIndexes.size());
    }

    @Override
    public void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.size();
        int finalOffThis = this._indexes.getOffsetToLast();
        int finalOffThat = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        while (true) {
            if (itThat.value() == itThis.value()) {
                int to = this._data.getIndex(itThis.getDataIndex());
                that._dict.addToEntry(v, 0, to, nCol);
                if (itThat.value() >= finalOffThat) break;
                itThat.next();
                if (itThis.value() >= finalOffThis) break;
                itThis.next();
                continue;
            }
            if (itThat.value() < itThis.value()) {
                if (itThat.value() >= finalOffThat) break;
                itThat.next();
                continue;
            }
            if (itThis.value() >= finalOffThis) break;
            itThis.next();
        }
    }

    @Override
    protected void preAggregateThatRLEStructure(ColGroupRLE that, Dictionary ret) {
        int finalOff = this._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        int nv = that.getNumValues();
        int nCol = that._colIndexes.size();
        for (int k = 0; k < nv; ++k) {
            AIterator itThis = this._indexes.getIterator();
            int blen = that._ptr[k + 1];
            int rs = 0;
            int re = 0;
            block1: for (int apos = that._ptr[k]; apos < blen; apos += 2) {
                rs = re + that._data[apos];
                re = rs + that._data[apos + 1];
                if (itThis.value() >= re || rs == re || rs > finalOff) continue;
                while (itThis.value() < rs && itThis.value() != finalOff) {
                    itThis.next();
                }
                int rix = itThis.value();
                while (rix < re) {
                    that._dict.addToEntry(v, k, this._data.getIndex(itThis.getDataIndex()), nCol);
                    if (itThis.value() == finalOff) continue block1;
                    itThis.next();
                    rix = itThis.value();
                }
            }
        }
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        IDictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.size());
        if (pattern == 0.0) {
            double[] defaultTuple = new double[this._colIndexes.size()];
            for (int i = 0; i < this._colIndexes.size(); ++i) {
                defaultTuple[i] = replace;
            }
            return ColGroupSDC.create(this._colIndexes, this._numRows, replaced, defaultTuple, this._indexes, this._data, this.getCachedCounts());
        }
        return this.copyAndSet(replaced);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        c[0] = 0.0;
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            c[this._colIndexes.get((int)i)] = 0.0;
        }
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this._data.size();
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected int numRowsToMultiply() {
        return this._data.size();
    }

    @Override
    protected AColGroup allocateRightMultiplication(MatrixBlock right, IColIndex colIndexes, IDictionary preAgg) {
        if (colIndexes != null && preAgg != null) {
            return ColGroupSDCZeros.create(colIndexes, this._numRows, preAgg, this._indexes, this._data, this.getCachedCounts());
        }
        return null;
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        c = builtin.execute(c, 0.0);
        return this._dict.aggregate(c, builtin);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c[this._colIndexes.get((int)x)] = builtin.execute(c[this._colIndexes.get(x)], 0.0);
        }
        this._dict.aggregateCols(c, builtin, this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        return pattern == 0.0 || this._dict.containsValue(pattern);
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        if (ru > this._numRows) {
            throw new DMLRuntimeException("Invalid row range");
        }
        AOffset.OffsetSliceInfo off = this._indexes.slice(rl, ru);
        if (off.lIndex == -1) {
            return null;
        }
        AMapToData newData = this._data.slice(off.lIndex, off.uIndex);
        return ColGroupSDCZeros.create(this._colIndexes, ru - rl, this._dict, off.offsetSlice, newData, null);
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupSDCZeros.create(colIndexes, this._numRows, newDictionary, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        for (int i = 1; i < g.length; ++i) {
            AColGroup gs = g[i];
            if (!this._colIndexes.equals(gs._colIndexes)) {
                LOG.warn((Object)("Not same columns therefore not appending \n" + this._colIndexes + "\n\n" + g[i]._colIndexes));
                return null;
            }
            if (!(gs instanceof AOffsetsGroup)) {
                LOG.warn((Object)("Not valid OffsetGroup but " + gs.getClass().getSimpleName()));
                return null;
            }
            if (!(gs instanceof ColGroupSDCZeros)) continue;
            ColGroupSDCZeros gc = (ColGroupSDCZeros)gs;
            if (gc._dict.equals(this._dict)) continue;
            LOG.warn((Object)("Not same Dictionaries therefore not appending \n" + this._dict + "\n\n" + gc._dict));
            return null;
        }
        AMapToData nd = this._data.appendN((IMapToDataGroup[])Arrays.copyOf(g, g.length, IMapToDataGroup[].class));
        AOffset no = this._indexes.appendN((AOffsetsGroup[])Arrays.copyOf(g, g.length, AOffsetsGroup[].class), blen);
        return ColGroupSDCZeros.create(this._colIndexes, rlen, this._dict, no, nd, null);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public int getNumberOffsets() {
        return this._data.size();
    }

    @Override
    public IEncode getEncoding() {
        return EncodingFactory.create(this._data, this._indexes, this._numRows);
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        return ColGroupSDCZeros.create(newColIndex, this.getNumRows(), this._dict.reorder(reordering), this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }
}

