/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.errors;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.TaskNotSerializableException;
import org.apache.spark.scheduler.BarrierJobRunWithDynamicAllocationException;
import org.apache.spark.scheduler.BarrierJobSlotsNumberCheckFailed;
import org.apache.spark.scheduler.BarrierJobUnsupportedRDDChainException;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockNotFoundException;
import org.apache.spark.storage.BlockSavedOnDecommissionedBlockManagerException;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class SparkCoreErrors$ {
    public static SparkCoreErrors$ MODULE$;

    static {
        new SparkCoreErrors$();
    }

    public Throwable unexpectedPy4JServerError(Object other) {
        return new RuntimeException(new StringBuilder(23).append("Unexpected Py4J server ").append(other.getClass()).toString());
    }

    public Throwable eofExceptionWhileReadPortNumberError(String daemonModule, Option<Object> daemonExitValue) {
        String msg = new StringBuilder(66).append("EOFException occurred while reading the port number from ").append(daemonModule).append("'s").append(" stdout").append(daemonExitValue.map((Function1 & Serializable & scala.Serializable)v -> SparkCoreErrors$.$anonfun$eofExceptionWhileReadPortNumberError$1(BoxesRunTime.unboxToInt((Object)v))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        return new SparkException(msg);
    }

    public Option<Object> eofExceptionWhileReadPortNumberError$default$2() {
        return null;
    }

    public Throwable unsupportedDataTypeError(Object other) {
        return new SparkException(new StringBuilder(30).append("Data of type ").append(other).append(" is not supported").toString());
    }

    public Throwable rddBlockNotFoundError(BlockId blockId, int id) {
        return new Exception(new StringBuilder(49).append("Could not compute split, block ").append(blockId).append(" of RDD ").append(id).append(" not found").toString());
    }

    public Throwable blockHaveBeenRemovedError(String string) {
        return new SparkException(new StringBuilder(53).append("Attempted to use ").append(string).append(" after its blocks have been removed!").toString());
    }

    public Throwable histogramOnEmptyRDDOrContainingInfinityOrNaNError() {
        return new UnsupportedOperationException("Histogram on either an empty RDD or RDD containing +/-infinity or NaN");
    }

    public Throwable emptyRDDError() {
        return new UnsupportedOperationException("empty RDD");
    }

    public Throwable pathNotSupportedError(String path) {
        return new IOException(new StringBuilder(135).append("Path: ").append(path).append(" is a directory, which is not supported by the ").append("record reader when `mapreduce.input.fileinputformat.input.dir.recursive` is false.").toString());
    }

    public Throwable checkpointRDDBlockIdNotFoundError(RDDBlockId rddBlockId) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(340).append("\n         |Checkpoint block ").append(rddBlockId).append(" not found! Either the executor\n         |that originally checkpointed this partition is no longer alive, or the original RDD is\n         |unpersisted. If this problem persists, you may consider using `rdd.checkpoint()`\n         |instead, which is slower than local checkpointing but more fault-tolerant.\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable endOfStreamError() {
        return new NoSuchElementException("End of stream");
    }

    public Throwable cannotUseMapSideCombiningWithArrayKeyError() {
        return new SparkException("Cannot use map-side combining with array keys.");
    }

    public Throwable hashPartitionerCannotPartitionArrayKeyError() {
        return new SparkException("HashPartitioner cannot partition array keys.");
    }

    public Throwable reduceByKeyLocallyNotSupportArrayKeysError() {
        return new SparkException("reduceByKeyLocally() does not support array keys");
    }

    public Throwable rddLacksSparkContextError() {
        return new SparkException("This RDD lacks a SparkContext. It could happen in the following cases: \n(1) RDD transformations and actions are NOT invoked by the driver, but inside of other transformations; for example, rdd1.map(x => rdd2.values.count() * x) is invalid because the values transformation and count action cannot be performed inside of the rdd1.map transformation. For more information, see SPARK-5063.\n(2) When a Spark Streaming job recovers from checkpoint, this exception will be hit if a reference to an RDD not defined by the streaming job is used in DStream operations. For more information, See SPARK-13758.");
    }

    public Throwable cannotChangeStorageLevelError() {
        return new UnsupportedOperationException("Cannot change storage level of an RDD after it was already assigned a level");
    }

    public Throwable canOnlyZipRDDsWithSamePartitionSizeError() {
        return new SparkException("Can only zip RDDs with same number of elements in each partition");
    }

    public Throwable emptyCollectionError() {
        return new UnsupportedOperationException("empty collection");
    }

    public Throwable countByValueApproxNotSupportArraysError() {
        return new SparkException("countByValueApprox() does not support arrays");
    }

    public Throwable checkpointDirectoryHasNotBeenSetInSparkContextError() {
        return new SparkException("Checkpoint directory has not been set in the SparkContext");
    }

    public Throwable invalidCheckpointFileError(Path path) {
        return new SparkException(new StringBuilder(25).append("Invalid checkpoint file: ").append(path).toString());
    }

    public Throwable failToCreateCheckpointPathError(Path checkpointDirPath) {
        return new SparkException(new StringBuilder(33).append("Failed to create checkpoint path ").append(checkpointDirPath).toString());
    }

    public Throwable checkpointRDDHasDifferentNumberOfPartitionsFromOriginalRDDError(int originalRDDId, int originalRDDLength, int newRDDId, int newRDDLength) {
        return new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |Checkpoint RDD has a different number of partitions from original RDD. Original\n         |RDD [ID: ").append(originalRDDId).append(", num of partitions: ").append(originalRDDLength).append("];\n         |Checkpoint RDD [ID: ").append(newRDDId).append(", num of partitions: ").append(newRDDLength).append("].\n       ").toString())).stripMargin().replaceAll("\n", " "));
    }

    public Throwable checkpointFailedToSaveError(int task, Path path) {
        return new IOException(new StringBuilder(89).append("Checkpoint failed: failed to save output of task: ").append(task).append(" and final output path does not exist: ").append(path).toString());
    }

    public Throwable mustSpecifyCheckpointDirError() {
        return new SparkException("Checkpoint dir must be specified.");
    }

    public Throwable askStandaloneSchedulerToShutDownExecutorsError(Exception e) {
        return new SparkException("Error asking standalone scheduler to shut down executors", e);
    }

    public Throwable stopStandaloneSchedulerDriverEndpointError(Exception e) {
        return new SparkException("Error stopping standalone scheduler's driver endpoint", e);
    }

    public Throwable noExecutorIdleError(String id) {
        return new NoSuchElementException(id);
    }

    public Throwable barrierStageWithRDDChainPatternError() {
        return new BarrierJobUnsupportedRDDChainException();
    }

    public Throwable barrierStageWithDynamicAllocationError() {
        return new BarrierJobRunWithDynamicAllocationException();
    }

    public Throwable numPartitionsGreaterThanMaxNumConcurrentTasksError(int numPartitions, int maxNumConcurrentTasks) {
        return new BarrierJobSlotsNumberCheckFailed(numPartitions, maxNumConcurrentTasks);
    }

    public Throwable cannotRunSubmitMapStageOnZeroPartitionRDDError() {
        return new SparkException("Can't run submitMapStage on RDD with 0 partitions");
    }

    public Throwable accessNonExistentAccumulatorError(long id) {
        return new SparkException(new StringBuilder(45).append("attempted to access non-existent accumulator ").append(id).toString());
    }

    public Throwable sendResubmittedTaskStatusForShuffleMapStagesOnlyError() {
        return new SparkException("TaskSetManagers should only send Resubmitted task statuses for tasks in ShuffleMapStages.");
    }

    public Throwable nonEmptyEventQueueAfterTimeoutError(long timeoutMillis) {
        return new TimeoutException(new StringBuilder(39).append("The event queue is not empty after ").append(timeoutMillis).append(" ms.").toString());
    }

    public Throwable durationCalledOnUnfinishedTaskError() {
        return new UnsupportedOperationException("duration() called on unfinished task");
    }

    public Throwable unrecognizedSchedulerModePropertyError(String schedulerModeProperty, String schedulingModeConf) {
        return new SparkException(new StringBuilder(15).append("Unrecognized ").append(schedulerModeProperty).append(": ").append(schedulingModeConf).toString());
    }

    public Throwable sparkError(String errorMsg) {
        return new SparkException(errorMsg);
    }

    public Throwable clusterSchedulerError(String message) {
        return new SparkException(new StringBuilder(45).append("Exiting due to error from cluster scheduler: ").append(message).toString());
    }

    public Throwable failToSerializeTaskError(Throwable e) {
        return new TaskNotSerializableException(e);
    }

    public Throwable unrecognizedBlockIdError(String name) {
        return new UnrecognizedBlockId(name);
    }

    public Throwable taskHasNotLockedBlockError(long currentTaskAttemptId, BlockId blockId) {
        return new SparkException(new StringBuilder(39).append("Task ").append(currentTaskAttemptId).append(" has not locked block ").append(blockId).append(" for writing").toString());
    }

    public Throwable blockDoesNotExistError(BlockId blockId) {
        return new SparkException(new StringBuilder(21).append("Block ").append(blockId).append(" does not exist").toString());
    }

    public Throwable cannotSaveBlockOnDecommissionedExecutorError(BlockId blockId) {
        return new BlockSavedOnDecommissionedBlockManagerException(blockId);
    }

    public Throwable waitingForReplicationToFinishError(Throwable e) {
        return new SparkException("Error occurred while waiting for replication to finish", e);
    }

    public Throwable unableToRegisterWithExternalShuffleServerError(Throwable e) {
        return new SparkException(new StringBuilder(57).append("Unable to register with external shuffle server due to : ").append(e.getMessage()).toString(), e);
    }

    public Throwable waitingForAsyncReregistrationError(Throwable e) {
        return new SparkException("Error occurred while waiting for async. reregistration", e);
    }

    public Throwable unexpectedShuffleBlockWithUnsupportedResolverError(ShuffleManager shuffleManager, BlockId blockId) {
        return new SparkException(new StringBuilder(60).append("Unexpected shuffle block ").append(blockId).append(" with unsupported shuffle ").append("resolver ").append(shuffleManager.shuffleBlockResolver()).toString());
    }

    public Throwable failToStoreBlockOnBlockManagerError(BlockManagerId blockManagerId, BlockId blockId) {
        return new SparkException(new StringBuilder(41).append("Failure while trying to store block ").append(blockId).append(" on ").append(blockManagerId).append(".").toString());
    }

    public Throwable readLockedBlockNotFoundError(BlockId blockId) {
        return new SparkException(new StringBuilder(49).append("Block ").append(blockId).append(" was not found even though it's read-locked").toString());
    }

    public Throwable failToGetBlockWithLockError(BlockId blockId) {
        return new SparkException(new StringBuilder(50).append("get() failed for block ").append(blockId).append(" even though we held a lock").toString());
    }

    public Throwable blockNotFoundError(BlockId blockId) {
        return new BlockNotFoundException(blockId.toString());
    }

    public Throwable interruptedError() {
        return new InterruptedException();
    }

    public Throwable blockStatusQueryReturnedNullError(BlockId blockId) {
        return new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
    }

    public Throwable unexpectedBlockManagerMasterEndpointResultError() {
        return new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
    }

    public Throwable failToCreateDirectoryError(String path, int maxAttempts) {
        return new IOException(new StringBuilder(64).append("Failed to create directory ").append(path).append(" with permission 770 after ").append(maxAttempts).append(" attempts!").toString());
    }

    public Throwable unsupportedOperationError() {
        return new UnsupportedOperationException();
    }

    public Throwable noSuchElementError() {
        return new NoSuchElementException();
    }

    public Throwable fetchFailedError(BlockManagerId bmAddress, int shuffleId, long mapId, int mapIndex, int reduceId, String message, Throwable cause) {
        return new FetchFailedException(bmAddress, shuffleId, mapId, mapIndex, reduceId, message, cause);
    }

    public Throwable fetchFailedError$default$7() {
        return null;
    }

    public Throwable failToGetNonShuffleBlockError(BlockId blockId, Throwable e) {
        return new SparkException(new StringBuilder(50).append("Failed to get block ").append(blockId).append(", which is not a shuffle block").toString(), e);
    }

    public Throwable graphiteSinkInvalidProtocolError(String invalidProtocol) {
        return new SparkException("GRAPHITE_SINK_INVALID_PROTOCOL", (String[])((Object[])new String[]{invalidProtocol}), null);
    }

    public Throwable graphiteSinkPropertyMissingError(String missingProperty) {
        return new SparkException("GRAPHITE_SINK_PROPERTY_MISSING", (String[])((Object[])new String[]{missingProperty}), null);
    }

    public static final /* synthetic */ String $anonfun$eofExceptionWhileReadPortNumberError$1(int v) {
        return new StringBuilder(28).append(" and terminated with code: ").append(v).append(".").toString();
    }

    private SparkCoreErrors$() {
        MODULE$ = this;
    }
}

