/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlock;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlockParallel;
import org.apache.sysds.runtime.io.FrameWriterProto;
import org.apache.sysds.runtime.io.FrameWriterTextCSV;
import org.apache.sysds.runtime.io.FrameWriterTextCSVParallel;
import org.apache.sysds.runtime.io.FrameWriterTextCell;
import org.apache.sysds.runtime.io.FrameWriterTextCellParallel;

public class FrameWriterFactory {
    public static FrameWriter createFrameWriter(Types.FileFormat fmt) {
        return FrameWriterFactory.createFrameWriter(fmt, null);
    }

    public static FrameWriter createFrameWriter(Types.FileFormat fmt, FileFormatProperties props) {
        FrameWriter writer = null;
        switch (fmt) {
            case TEXT: {
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    writer = new FrameWriterTextCellParallel();
                    break;
                }
                writer = new FrameWriterTextCell();
                break;
            }
            case CSV: {
                if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
                }
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS)) {
                    writer = new FrameWriterTextCSVParallel((FileFormatPropertiesCSV)props);
                    break;
                }
                writer = new FrameWriterTextCSV((FileFormatPropertiesCSV)props);
                break;
            }
            case BINARY: {
                if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS)) {
                    writer = new FrameWriterBinaryBlockParallel();
                    break;
                }
                writer = new FrameWriterBinaryBlock();
                break;
            }
            case PROTO: {
                writer = new FrameWriterProto();
                break;
            }
            default: {
                throw new DMLRuntimeException("Failed to create frame writer for unknown format: " + fmt.toString());
            }
        }
        return writer;
    }
}

