/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorSample;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class CoCodeCostMatrixMult
extends AColumnCoCoder {
    protected CoCodeCostMatrixMult(CompressedSizeEstimator e, CompressionSettings cs) {
        super(e, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        List<CompressedSizeInfoColGroup> joinRes = this.join(colInfos.getInfo());
        if (this._cs.samplingRatio < 0.1 && this._est instanceof CompressedSizeEstimatorSample) {
            LOG.debug((Object)"Performing second join with double sample rate");
            CompressedSizeEstimatorSample estS = (CompressedSizeEstimatorSample)this._est;
            estS.sampleData(estS.getSample().getNumRows() * 2);
            ArrayList<int[]> colG = new ArrayList<int[]>(joinRes.size());
            for (CompressedSizeInfoColGroup g : joinRes) {
                colG.add(g.getColumns());
            }
            joinRes = this.join(estS.computeCompressedSizeInfos(colG, k));
        }
        colInfos.setInfo(joinRes);
        return colInfos;
    }

    private List<CompressedSizeInfoColGroup> join(List<CompressedSizeInfoColGroup> currentGroups) {
        PriorityQueue<CostOfJoin> que = new PriorityQueue<CostOfJoin>(currentGroups.size());
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup g : currentGroups) {
            if (g == null) continue;
            que.add(new CostOfJoin(g));
        }
        CostOfJoin l = (CostOfJoin)que.poll();
        while (que.peek() != null) {
            CostOfJoin r = (CostOfJoin)que.peek();
            double costIndividual = l.cost + r.cost;
            CostOfJoin g = new CostOfJoin(this.joinWithAnalysis(l.elm, r.elm));
            if (g.cost < costIndividual) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("\nl:      " + l + "\nr:      " + r + "\njoined: " + g));
                }
                que.poll();
                que.add(g);
            } else {
                ret.add(l.elm);
            }
            l = (CostOfJoin)que.poll();
        }
        if (l != null) {
            ret.add(l.elm);
        }
        for (CostOfJoin g : que) {
            ret.add(g.elm);
        }
        return ret;
    }

    private class CostOfJoin
    implements Comparable<CostOfJoin> {
        protected final CompressedSizeInfoColGroup elm;
        protected final double cost;

        protected CostOfJoin(CompressedSizeInfoColGroup elm) {
            this.elm = elm;
            if (elm == null) {
                this.cost = Double.POSITIVE_INFINITY;
            } else {
                double nRows;
                int nCols = elm.getColumns().length;
                double preAggregateCost = nRows = (double)CoCodeCostMatrixMult.this._est.getNumRows();
                int numberTuples = elm.getNumVals();
                double tupleSparsity = elm.getTupleSparsity();
                double postScalingCost = nCols > 1 && tupleSparsity > 0.4 ? (double)(numberTuples * nCols) : (double)(numberTuples * nCols) * tupleSparsity;
                this.cost = preAggregateCost + postScalingCost;
            }
        }

        @Override
        public int compareTo(CostOfJoin o) {
            return this.cost == o.cost ? 0 : (this.cost > o.cost ? 1 : -1);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.cost);
            sb.append(" - ");
            sb.append((Object)this.elm.getBestCompressionType());
            sb.append(" nrVals: ");
            sb.append(this.elm.getNumVals());
            sb.append(" ");
            sb.append(Arrays.toString(this.elm.getColumns()));
            return sb.toString();
        }
    }
}

