/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWCeMMFEDInstruction
extends QuaternaryFEDInstruction {
    protected QuaternaryWCeMMFEDInstruction(Operator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, operator, in1, in2, in3, in4, out, opcode, instruction_str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        Future<FederatedResponse>[] response;
        QuaternaryOperator qop = (QuaternaryOperator)this._optr;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixObject U = ec.getMatrixObject(this.input2);
        MatrixObject V = ec.getMatrixObject(this.input3);
        ScalarObject eps = null;
        if (qop.hasFourInputs()) {
            ScalarObject scalarObject = eps = this._input4.getDataType() == Types.DataType.SCALAR ? ec.getScalarInput(this._input4) : new DoubleObject(ec.getMatrixInput(this._input4.getName()).quickGetValue(0, 0));
        }
        if (X.isFederated(FederationMap.FType.ROW) && !U.isFederated() && !V.isFederated()) {
            FederationMap fedMap = X.getFedMapping();
            FederatedRequest[] fr1 = fedMap.broadcastSliced(U, false);
            FederatedRequest fr2 = fedMap.broadcast(V);
            FederatedRequest fr3 = null;
            FederatedRequest frComp = null;
            if (eps != null) {
                fr3 = fedMap.broadcast(eps);
                this.instString = this.instString.replace("true", "false");
                frComp = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3, this._input4}, new long[]{fedMap.getID(), fr1[0].getID(), fr2.getID(), fr3.getID()});
            } else {
                frComp = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{fedMap.getID(), fr1[0].getID(), fr2.getID()});
            }
            FederatedRequest frGet = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frComp.getID());
            FederatedRequest frClean1 = fedMap.cleanup(this.getTID(), frComp.getID());
            FederatedRequest frClean2 = fedMap.cleanup(this.getTID(), fr1[0].getID());
            FederatedRequest frClean3 = fedMap.cleanup(this.getTID(), fr2.getID());
            if (fr3 != null) {
                FederatedRequest frClean4 = fedMap.cleanup(this.getTID(), fr3.getID());
                response = fedMap.execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2, fr3, frComp, frGet, frClean1, frClean2, frClean3, frClean4});
            } else {
                response = fedMap.execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2, frComp, frGet, frClean1, frClean2, frClean3});
            }
        } else {
            throw new DMLRuntimeException("Unsupported federated inputs (X, U, V) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ")");
        }
        AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
        ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, response));
    }
}

