/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.utils.MemoryEstimates;

public abstract class AColGroup
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)AColGroup.class.getName());
    private static final long serialVersionUID = 2439785418908671481L;
    protected int[] _colIndexes;

    protected AColGroup() {
    }

    protected AColGroup(int[] colIndices) {
        this._colIndexes = colIndices;
    }

    public int[] getColIndices() {
        return this._colIndexes;
    }

    protected void setColIndices(int[] colIndexes) {
        this._colIndexes = colIndexes;
    }

    public abstract int getNumRows();

    public abstract int getNumValues();

    public int getNumCols() {
        return this._colIndexes.length;
    }

    public abstract CompressionType getCompType();

    protected abstract ColGroupType getColGroupType();

    public final void shiftColIndices(int offset) {
        int i = 0;
        while (i < this._colIndexes.length) {
            int n = i++;
            this._colIndexes[n] = this._colIndexes[n] + offset;
        }
    }

    public long estimateInMemorySize() {
        long size = 16L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._colIndexes.length));
        return size;
    }

    public abstract void decompressToBlockSafe(MatrixBlock var1, int var2, int var3, int var4);

    public void decompressToBlockUnSafe(MatrixBlock target, int rl, int ru) {
        this.decompressToBlockUnSafe(target, rl, ru, rl);
    }

    public abstract void decompressToBlockUnSafe(MatrixBlock var1, int var2, int var3, int var4);

    public static final void decompressColumnToBlockUnSafe(MatrixBlock target, int rl, int ru, List<AColGroup> colGroups) {
        for (AColGroup g : colGroups) {
            g.decompressToBlockUnSafe(target, rl, ru, rl);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this._colIndexes.length);
        for (int i = 0; i < this._colIndexes.length; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numCols = in.readInt();
        this._colIndexes = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
    }

    public long getExactSizeOnDisk() {
        return 4 + 4 * this._colIndexes.length;
    }

    public abstract double get(int var1, int var2);

    public abstract double[] getValues();

    public abstract MatrixBlock getValuesAsBlock();

    public abstract AColGroup rightMultByMatrix(MatrixBlock var1);

    public abstract void tsmm(double[] var1, int var2);

    public abstract void tsmm(double[] var1, int var2, int var3, int var4);

    public final void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result) {
        this.leftMultByMatrix(matrix, result, 0, matrix.getNumRows());
    }

    public abstract void leftMultByMatrix(MatrixBlock var1, MatrixBlock var2, int var3, int var4);

    public abstract void leftMultByAColGroup(AColGroup var1, MatrixBlock var2);

    public abstract AColGroup scalarOperation(ScalarOperator var1);

    public abstract AColGroup binaryRowOp(BinaryOperator var1, double[] var2, boolean var3, boolean var4);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2, int var3, int var4);

    public abstract void countNonZerosPerRow(int[] var1, int var2, int var3);

    public abstract boolean isLossy();

    public abstract boolean isDense();

    public final AColGroup sliceColumns(int cl, int cu) {
        AColGroup ret = cu - cl == 1 ? this.sliceColumn(cl) : this.sliceMultiColumns(cl, cu);
        return ret;
    }

    public final AColGroup sliceColumn(int col) {
        int idx = Arrays.binarySearch(this._colIndexes, col);
        if (idx >= 0) {
            return this.sliceSingleColumn(idx);
        }
        return null;
    }

    protected final AColGroup sliceMultiColumns(int cl, int cu) {
        int numberOfOutputColumns;
        int idStart = 0;
        int idEnd = 0;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this._colIndexes[i] < cl) {
                ++idStart;
            }
            if (this._colIndexes[i] >= cu) break;
            ++idEnd;
        }
        if ((numberOfOutputColumns = idEnd - idStart) > 0) {
            int[] outputCols = new int[numberOfOutputColumns];
            int idIt = idStart;
            for (int i = 0; i < numberOfOutputColumns; ++i) {
                outputCols[i] = this._colIndexes[idIt++] - cl;
            }
            return this.sliceMultiColumns(idStart, idEnd, outputCols);
        }
        return null;
    }

    protected abstract AColGroup sliceSingleColumn(int var1);

    protected abstract AColGroup sliceMultiColumns(int var1, int var2, int[] var3);

    public abstract double getMin();

    public abstract double getMax();

    public abstract AColGroup copy();

    public abstract boolean containsValue(double var1);

    public abstract long getNumberNonZeros();

    public abstract AColGroup replace(double var1, double var3);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ColGroupType: ");
        sb.append(this.getClass().getSimpleName());
        sb.append(String.format("\n%15s%5d ", "Columns:", this._colIndexes.length));
        sb.append(Arrays.toString(this._colIndexes));
        return sb.toString();
    }

    protected static enum ColGroupType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCSingle,
        SDCSingleZeros,
        SDCZeros;

    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC;

    }
}

