/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.recompile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.JMLCUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.recompile.LiteralReplacement;
import org.apache.sysds.hops.recompile.RecompileStatus;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriter;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.Explain;
import org.apache.sysds.utils.JSONHelper;
import org.apache.wink.json4j.JSONObject;

public class Recompiler {
    private static final long CP_REBLOCK_THRESHOLD_SIZE = 0x40000000L;
    private static final long CP_CSV_REBLOCK_UNKNOWN_THRESHOLD_SIZE = 0x40000000L;
    private static ThreadLocal<ProgramRewriter> _rewriter = new ThreadLocal<ProgramRewriter>(){

        @Override
        protected ProgramRewriter initialValue() {
            return new ProgramRewriter(false, true);
        }
    };

    public static void reinitRecompiler() {
        _rewriter.set(new ProgramRewriter(false, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag(StatementBlock sb, ArrayList<Hop> hops, ExecutionContext ec, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, ec, status, inplace, replaceLit, true, false, false, null, tid);
        }
        if (ProgramBlock.isThreadID(tid)) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (ec.getVariables().getRegisteredOutputs() != null) {
            newInst = JMLCUtils.cleanupRuntimeInstructions(newInst, ec.getVariables().getRegisteredOutputs());
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    public static ArrayList<Instruction> recompileHopsDag(StatementBlock sb, ArrayList<Hop> hops, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) {
        return Recompiler.recompileHopsDag(sb, hops, new ExecutionContext(vars), status, inplace, replaceLit, tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag(Hop hop, ExecutionContext ec, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), ec, status, inplace, replaceLit, true, false, true, null, tid);
        }
        if (ProgramBlock.isThreadID(tid)) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag(Hop hop, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), vars, status, inplace, replaceLit, true, false, true, null, tid);
        }
        if (ProgramBlock.isThreadID(tid)) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag2Forced(StatementBlock sb, ArrayList<Hop> hops, long tid, LopProperties.ExecType et) {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, (LocalVariableMap)null, null, true, false, false, true, false, et, tid);
        }
        if (ProgramBlock.isThreadID(tid)) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag2Forced(Hop hop, long tid, LopProperties.ExecType et) {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), (LocalVariableMap)null, null, true, false, false, true, true, et, tid);
        }
        if (ProgramBlock.isThreadID(tid)) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDagInstructions(StatementBlock sb, ArrayList<Hop> hops) {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, (LocalVariableMap)null, null, true, false, false, false, false, null, 0L);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDagInstructions(Hop hop) {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), (LocalVariableMap)null, null, true, false, false, false, true, null, 0L);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    private static ArrayList<Instruction> recompile(StatementBlock sb, ArrayList<Hop> hops, ExecutionContext ec, RecompileStatus status, boolean inplace, boolean replaceLit, boolean updateStats, boolean forceEt, boolean pred, LopProperties.ExecType et, long tid) {
        boolean codegen;
        boolean bl = codegen = ConfigurationManager.isCodegenEnabled() && (!forceEt || et != null);
        if (!inplace) {
            hops = Recompiler.deepCopyHopsDag(hops);
        } else if (!codegen) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rClearLops(hop);
            }
        }
        Hop.resetVisitStatus(hops);
        int maxK = Recompiler.rGetMaxParallelism(hops);
        if (!inplace && replaceLit) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rReplaceLiterals(hop, ec, false);
            }
        }
        if (forceEt) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rSetExecType(hop, et);
            }
            Hop.resetVisitStatus(hops);
        }
        if (updateStats) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rUpdateStatistics(hop, ec.getVariables());
            }
            if (!inplace) {
                _rewriter.get().rewriteHopDAG(hops, null);
                Hop.resetVisitStatus(hops);
                for (Hop hop : hops) {
                    Recompiler.rUpdateStatistics(hop, ec.getVariables());
                }
            }
            Hop.resetVisitStatus(hops);
            MemoTable memoTable = new MemoTable();
            memoTable.init(hops, status);
            Hop.resetVisitStatus(hops);
            for (Hop hopRoot : hops) {
                hopRoot.refreshMemEstimates(memoTable);
            }
            memoTable.extract(hops, status);
        }
        if (codegen) {
            if (inplace) {
                hops = Recompiler.deepCopyHopsDag(hops);
            }
            Hop.resetVisitStatus(hops);
            hops = SpoofCompiler.optimize(hops, status == null || !status.isInitialCodegen());
        }
        Hop.resetVisitStatus(hops);
        Recompiler.rSetMaxParallelism(hops, maxK);
        Dag<Lop> dag = new Dag<Lop>();
        for (Hop hopRoot : hops) {
            Lop lops = hopRoot.constructLops();
            lops.addToDag(dag);
        }
        ArrayList<Instruction> arrayList = dag.getJobs(sb, ConfigurationManager.getDMLConfig());
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            if (pred) {
                Recompiler.logExplainPred(hops.get(0), arrayList);
            } else {
                Recompiler.logExplainDAG(sb, hops, arrayList);
            }
        }
        return arrayList;
    }

    private static ArrayList<Instruction> recompile(StatementBlock sb, ArrayList<Hop> hops, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, boolean updateStats, boolean forceEt, boolean pred, LopProperties.ExecType et, long tid) {
        return Recompiler.recompile(sb, hops, new ExecutionContext(vars), status, inplace, replaceLit, updateStats, forceEt, pred, et, tid);
    }

    private static void logExplainDAG(StatementBlock sb, ArrayList<Hop> hops, ArrayList<Instruction> inst) {
        StatementBlock pi;
        ParseInfo parseInfo = pi = sb != null ? sb : (ParseInfo)hops.get(0);
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            System.out.println("EXPLAIN RECOMPILE \nGENERIC (lines " + pi.getBeginLine() + "-" + pi.getEndLine() + "):\n" + Explain.explainHops(hops, 1));
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            System.out.println("EXPLAIN RECOMPILE \nGENERIC (lines " + pi.getBeginLine() + "-" + pi.getEndLine() + "):\n" + Explain.explain(inst, 1));
        }
    }

    private static void logExplainPred(Hop hops, ArrayList<Instruction> inst) {
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            System.out.println("EXPLAIN RECOMPILE \nPRED (line " + hops.getBeginLine() + "):\n" + Explain.explain(hops, 1));
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            System.out.println("EXPLAIN RECOMPILE \nPRED (line " + hops.getBeginLine() + "):\n" + Explain.explain(inst, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompileProgramBlockHierarchy(ArrayList<ProgramBlock> pbs, LocalVariableMap vars, long tid, ResetType resetRecompile) {
        RecompileStatus status = new RecompileStatus();
        ArrayList<ProgramBlock> arrayList = pbs;
        synchronized (arrayList) {
            for (ProgramBlock pb : pbs) {
                Recompiler.rRecompileProgramBlock(pb, vars, status, tid, resetRecompile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompileProgramBlockHierarchy2Forced(ArrayList<ProgramBlock> pbs, long tid, HashSet<String> fnStack, LopProperties.ExecType et) {
        ArrayList<ProgramBlock> arrayList = pbs;
        synchronized (arrayList) {
            for (ProgramBlock pb : pbs) {
                Recompiler.rRecompileProgramBlock2Forced(pb, tid, fnStack, et);
            }
        }
    }

    public static void recompileProgramBlockInstructions(ProgramBlock pb) throws IOException {
        BasicProgramBlock bpb;
        StatementBlock sb;
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)pb.getStatementBlock();
            if (wsb != null && wsb.getPredicateHops() != null) {
                wpb.setPredicate(Recompiler.recompileHopsDagInstructions(wsb.getPredicateHops()));
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)pb.getStatementBlock();
            if (isb != null && isb.getPredicateHops() != null) {
                ipb.setPredicate(Recompiler.recompileHopsDagInstructions(isb.getPredicateHops()));
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)pb.getStatementBlock();
            if (fsb != null && fsb.getFromHops() != null) {
                fpb.setFromInstructions(Recompiler.recompileHopsDagInstructions(fsb.getFromHops()));
            }
            if (fsb != null && fsb.getToHops() != null) {
                fpb.setToInstructions(Recompiler.recompileHopsDagInstructions(fsb.getToHops()));
            }
            if (fsb != null && fsb.getIncrementHops() != null) {
                fpb.setIncrementInstructions(Recompiler.recompileHopsDagInstructions(fsb.getIncrementHops()));
            }
        } else if (pb instanceof BasicProgramBlock && (sb = (bpb = (BasicProgramBlock)pb).getStatementBlock()) != null && sb.getHops() != null) {
            bpb.setInstructions(Recompiler.recompileHopsDagInstructions(sb, sb.getHops()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresRecompilation(ArrayList<Hop> hops) {
        if (hops == null) {
            return false;
        }
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            Hop.resetVisitStatus(hops);
            return hops.stream().anyMatch(h -> Recompiler.rRequiresRecompile(h));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresRecompilation(Hop hop) {
        if (hop == null) {
            return false;
        }
        Hop hop2 = hop;
        synchronized (hop2) {
            hop.resetVisitStatus();
            return Recompiler.rRequiresRecompile(hop);
        }
    }

    public static ArrayList<Hop> deepCopyHopsDag(List<Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>(hops.size());
        try {
            HashMap<Long, Hop> memo = new HashMap<Long, Hop>();
            for (Hop hopRoot : hops) {
                ret.add(Recompiler.rDeepCopyHopsDag(hopRoot, memo));
            }
        }
        catch (Exception ex) {
            throw new HopsException(ex);
        }
        return ret;
    }

    public static Hop deepCopyHopsDag(Hop hops) {
        Hop ret = null;
        try {
            HashMap<Long, Hop> memo = new HashMap<Long, Hop>();
            ret = Recompiler.rDeepCopyHopsDag(hops, memo);
        }
        catch (Exception ex) {
            throw new HopsException(ex);
        }
        return ret;
    }

    private static Hop rDeepCopyHopsDag(Hop hop, HashMap<Long, Hop> memo) throws CloneNotSupportedException {
        Hop ret = memo.get(hop.getHopID());
        if (ret == null) {
            ret = (Hop)hop.clone();
            for (Hop in : hop.getInput()) {
                Hop tmp = Recompiler.rDeepCopyHopsDag(in, memo);
                ret.getInput().add(tmp);
                tmp.getParent().add(ret);
            }
            memo.put(hop.getHopID(), ret);
        }
        return ret;
    }

    public static void updateFunctionNames(ArrayList<Hop> hops, long pid) {
        Hop.resetVisitStatus(hops);
        for (Hop hopRoot : hops) {
            Recompiler.rUpdateFunctionNames(hopRoot, pid);
        }
    }

    public static void rUpdateFunctionNames(Hop hop, long pid) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof FunctionOp && ((FunctionOp)hop).getFunctionType() != FunctionOp.FunctionType.MULTIRETURN_BUILTIN) {
            FunctionOp fop = (FunctionOp)hop;
            fop.setFunctionName(fop.getFunctionName() + "_t" + pid);
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rUpdateFunctionNames(c, pid);
            }
        }
        hop.setVisited();
    }

    private static void rRecompileProgramBlock(ProgramBlock pb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)wpb.getStatementBlock();
            Recompiler.recompileWhilePredicate(wpb, wsb, vars, status, tid, resetRecompile);
            Recompiler.removeUpdatedScalars(vars, wsb);
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : wpb.getChildBlocks()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldVars, vars, (StatementBlock)wsb) | Recompiler.reconcileUpdatedCallVarsLoops(oldStatus, status, (StatementBlock)wsb)) {
                Recompiler.recompileWhilePredicate(wpb, wsb, vars, status, tid, resetRecompile);
                for (ProgramBlock pb2 : wpb.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
                }
            }
            Recompiler.removeUpdatedScalars(vars, wsb);
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)ipb.getStatementBlock();
            Recompiler.recompileIfPredicate(ipb, isb, vars, status, tid, resetRecompile);
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            LocalVariableMap varsElse = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            RecompileStatus statusElse = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : ipb.getChildBlocksIfBody()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            for (ProgramBlock pb2 : ipb.getChildBlocksElseBody()) {
                Recompiler.rRecompileProgramBlock(pb2, varsElse, statusElse, tid, resetRecompile);
            }
            Recompiler.reconcileUpdatedCallVarsIf(oldVars, vars, varsElse, (StatementBlock)isb);
            Recompiler.reconcileUpdatedCallVarsIf(oldStatus, status, statusElse, (StatementBlock)isb);
            Recompiler.removeUpdatedScalars(vars, ipb.getStatementBlock());
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
            Recompiler.recompileForPredicates(fpb, fsb, vars, status, tid, resetRecompile);
            Recompiler.removeUpdatedScalars(vars, fpb.getStatementBlock());
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldVars, vars, (StatementBlock)fsb) | Recompiler.reconcileUpdatedCallVarsLoops(oldStatus, status, (StatementBlock)fsb)) {
                Recompiler.recompileForPredicates(fpb, fsb, vars, status, tid, resetRecompile);
                for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
                }
            }
            Recompiler.removeUpdatedScalars(vars, fpb.getStatementBlock());
        } else if (!(pb instanceof FunctionProgramBlock) && pb instanceof BasicProgramBlock) {
            StatementBlock sb = pb.getStatementBlock();
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            ArrayList<Instruction> tmp = bpb.getInstructions();
            if (sb == null) {
                return;
            }
            tmp = Recompiler.recompileHopsDag(sb, sb.getHops(), vars, status, true, false, tid);
            bpb.setInstructions(tmp);
            Recompiler.extractDAGOutputStatistics(sb.getHops(), vars);
            if (!Recompiler.containsRootFunctionOp(sb.getHops()) && resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(sb.getHops(), LopProperties.ExecType.CP, resetRecompile);
                sb.updateRecompilationFlag();
            }
        }
    }

    public static boolean reconcileUpdatedCallVarsLoops(LocalVariableMap oldCallVars, LocalVariableMap callVars, StatementBlock sb) {
        boolean requiresRecompile = false;
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            Data dat1 = oldCallVars.get(varname);
            Data dat2 = callVars.get(varname);
            if (dat1 == null || !(dat1 instanceof MatrixObject) || dat2 == null || !(dat2 instanceof MatrixObject)) continue;
            MatrixObject moOld = (MatrixObject)dat1;
            MatrixObject mo = (MatrixObject)dat2;
            DataCharacteristics mcOld = moOld.getDataCharacteristics();
            DataCharacteristics mc = mo.getDataCharacteristics();
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mc.getRows();
            long ldim2 = mc.getCols();
            long lnnz = mc.getNonZeros();
            if (mcOld.getRows() != mc.getRows()) {
                ldim1 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getCols() != mc.getCols()) {
                ldim2 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getNonZeros() != mc.getNonZeros()) {
                lnnz = -1L;
                requiresRecompile = true;
            }
            MatrixObject moNew = Recompiler.createOutputMatrix(ldim1, ldim2, lnnz);
            callVars.put(varname, moNew);
        }
        return requiresRecompile;
    }

    public static boolean reconcileUpdatedCallVarsLoops(RecompileStatus oldCallStatus, RecompileStatus callStatus, StatementBlock sb) {
        boolean requiresRecompile = false;
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            DataCharacteristics dat1 = oldCallStatus.getTWriteStats().get(varname);
            DataCharacteristics dat2 = callStatus.getTWriteStats().get(varname);
            if (dat1 == null || dat2 == null) continue;
            DataCharacteristics dcOld = dat1;
            DataCharacteristics dc = dat2;
            if (dcOld.getRows() == dc.getRows() && dcOld.getCols() == dc.getCols() && dcOld.getNonZeros() == dc.getNonZeros()) continue;
            long ldim1 = dc.getRows();
            long ldim2 = dc.getCols();
            long lnnz = dc.getNonZeros();
            if (dcOld.getRows() != dc.getRows()) {
                ldim1 = -1L;
                requiresRecompile = true;
            }
            if (dcOld.getCols() != dc.getCols()) {
                ldim2 = -1L;
                requiresRecompile = true;
            }
            if (dcOld.getNonZeros() != dc.getNonZeros()) {
                lnnz = -1L;
                requiresRecompile = true;
            }
            MatrixCharacteristics moNew = new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
            callStatus.getTWriteStats().put(varname, moNew);
        }
        return requiresRecompile;
    }

    public static LocalVariableMap reconcileUpdatedCallVarsIf(LocalVariableMap oldCallVars, LocalVariableMap callVarsIf, LocalVariableMap callVarsElse, StatementBlock sb) {
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            Data origVar = oldCallVars.get(varname);
            Data ifVar = callVarsIf.get(varname);
            Data elseVar = callVarsElse.get(varname);
            Data dat1 = null;
            Data dat2 = null;
            if (ifVar != null && elseVar != null) {
                dat1 = ifVar;
                dat2 = elseVar;
            } else if (ifVar != null && elseVar == null) {
                dat1 = origVar;
                dat2 = ifVar;
            } else {
                dat1 = origVar;
                dat2 = elseVar;
            }
            if (dat1 == null || !(dat1 instanceof MatrixObject) || dat2 == null || !(dat1 instanceof MatrixObject) || !(dat2 instanceof MatrixObject)) continue;
            MatrixObject moOld = (MatrixObject)dat1;
            MatrixObject mo = (MatrixObject)dat2;
            DataCharacteristics mcOld = moOld.getDataCharacteristics();
            DataCharacteristics mc = mo.getDataCharacteristics();
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mc.getRows();
            long ldim2 = mc.getCols();
            long lnnz = mc.getNonZeros();
            if (mcOld.getRows() != mc.getRows()) {
                ldim1 = -1L;
            }
            if (mcOld.getCols() != mc.getCols()) {
                ldim2 = -1L;
            }
            if (mcOld.getNonZeros() != mc.getNonZeros()) {
                lnnz = -1L;
            }
            MatrixObject moNew = Recompiler.createOutputMatrix(ldim1, ldim2, lnnz);
            callVarsIf.put(varname, moNew);
        }
        return callVarsIf;
    }

    public static RecompileStatus reconcileUpdatedCallVarsIf(RecompileStatus oldStatus, RecompileStatus callStatusIf, RecompileStatus callStatusElse, StatementBlock sb) {
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            DataCharacteristics origVar = oldStatus.getTWriteStats().get(varname);
            DataCharacteristics ifVar = callStatusIf.getTWriteStats().get(varname);
            DataCharacteristics elseVar = callStatusElse.getTWriteStats().get(varname);
            DataCharacteristics dat1 = null;
            DataCharacteristics dat2 = null;
            if (ifVar != null && elseVar != null) {
                dat1 = ifVar;
                dat2 = elseVar;
            } else if (ifVar != null && elseVar == null) {
                dat1 = origVar;
                dat2 = ifVar;
            } else {
                dat1 = origVar;
                dat2 = elseVar;
            }
            if (dat1 == null || dat2 == null) continue;
            DataCharacteristics dcOld = dat1;
            DataCharacteristics dc = dat2;
            if (dcOld.getRows() == dc.getRows() && dcOld.getCols() == dc.getCols() && dcOld.getNonZeros() == dc.getNonZeros()) continue;
            long ldim1 = dcOld.getRows() >= 0L && dc.getRows() >= 0L ? Math.max(dcOld.getRows(), dc.getRows()) : -1L;
            long ldim2 = dcOld.getCols() >= 0L && dc.getCols() >= 0L ? Math.max(dcOld.getCols(), dc.getCols()) : -1L;
            long lnnz = dcOld.getNonZeros() >= 0L && dc.getNonZeros() >= 0L ? Math.max(dcOld.getNonZeros(), dc.getNonZeros()) : -1L;
            MatrixCharacteristics mcNew = new MatrixCharacteristics(ldim1, ldim2, -1, lnnz);
            callStatusIf.getTWriteStats().put(varname, mcNew);
        }
        return callStatusIf;
    }

    private static boolean containsRootFunctionOp(ArrayList<Hop> hops) {
        boolean ret = false;
        for (Hop h : hops) {
            if (!(h instanceof FunctionOp)) continue;
            ret |= true;
        }
        return ret;
    }

    private static MatrixObject createOutputMatrix(long dim1, long dim2, long nnz) {
        MatrixObject moOut = new MatrixObject(Types.ValueType.FP64, null);
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(dim1, dim2, blksz, nnz);
        MetaDataFormat meta = new MetaDataFormat(mc, null);
        moOut.setMetaData(meta);
        return moOut;
    }

    private static void recompileIfPredicate(IfProgramBlock ipb, IfStatementBlock isb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) {
        if (isb == null) {
            return;
        }
        Hop hops = isb.getPredicateHops();
        if (hops != null) {
            ArrayList<Instruction> tmp = Recompiler.recompileHopsDag(hops, vars, status, true, false, tid);
            ipb.setPredicate(tmp);
            if (resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(hops, LopProperties.ExecType.CP, resetRecompile);
                isb.updatePredicateRecompilationFlag();
            }
        }
    }

    private static void recompileWhilePredicate(WhileProgramBlock wpb, WhileStatementBlock wsb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) {
        if (wsb == null) {
            return;
        }
        Hop hops = wsb.getPredicateHops();
        if (hops != null) {
            ArrayList<Instruction> tmp = Recompiler.recompileHopsDag(hops, vars, status, true, false, tid);
            wpb.setPredicate(tmp);
            if (resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(hops, LopProperties.ExecType.CP, resetRecompile);
                wsb.updatePredicateRecompilationFlag();
            }
        }
    }

    private static void recompileForPredicates(ForProgramBlock fpb, ForStatementBlock fsb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) {
        if (fsb != null) {
            Hop fromHops = fsb.getFromHops();
            Hop toHops = fsb.getToHops();
            Hop incrHops = fsb.getIncrementHops();
            if (resetRecompile.isReset()) {
                ArrayList<Instruction> tmp;
                if (fromHops != null) {
                    tmp = Recompiler.recompileHopsDag(fromHops, vars, status, true, false, tid);
                    fpb.setFromInstructions(tmp);
                    Hop.resetRecompilationFlag(fromHops, LopProperties.ExecType.CP, resetRecompile);
                }
                if (toHops != null) {
                    tmp = Recompiler.recompileHopsDag(toHops, vars, status, true, false, tid);
                    fpb.setToInstructions(tmp);
                    Hop.resetRecompilationFlag(toHops, LopProperties.ExecType.CP, resetRecompile);
                }
                if (incrHops != null) {
                    tmp = Recompiler.recompileHopsDag(incrHops, vars, status, true, false, tid);
                    fpb.setIncrementInstructions(tmp);
                    Hop.resetRecompilationFlag(incrHops, LopProperties.ExecType.CP, resetRecompile);
                }
                fsb.updatePredicateRecompilationFlags();
            } else {
                ArrayList<Instruction> tmp;
                if (fromHops != null) {
                    tmp = Recompiler.recompileHopsDag(fromHops, vars, status, true, false, tid);
                    fpb.setFromInstructions(tmp);
                }
                if (toHops != null) {
                    tmp = Recompiler.recompileHopsDag(toHops, vars, status, true, false, tid);
                    fpb.setToInstructions(tmp);
                }
                if (incrHops != null) {
                    tmp = Recompiler.recompileHopsDag(incrHops, vars, status, true, false, tid);
                    fpb.setIncrementInstructions(tmp);
                }
            }
        }
    }

    private static void rRecompileProgramBlock2Forced(ProgramBlock pb, long tid, HashSet<String> fnStack, LopProperties.ExecType et) {
        block14: {
            ArrayList<Instruction> tmp;
            block17: {
                block16: {
                    block15: {
                        block13: {
                            if (!(pb instanceof WhileProgramBlock)) break block13;
                            WhileProgramBlock pbTmp = (WhileProgramBlock)pb;
                            WhileStatementBlock sbTmp = (WhileStatementBlock)pbTmp.getStatementBlock();
                            if (sbTmp != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsSparkInstruction(pbTmp.getPredicate(), true))) {
                                pbTmp.setPredicate(Recompiler.recompileHopsDag2Forced(sbTmp.getPredicateHops(), tid, et));
                            }
                            for (ProgramBlock pb2 : pbTmp.getChildBlocks()) {
                                Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                            }
                            break block14;
                        }
                        if (!(pb instanceof IfProgramBlock)) break block15;
                        IfProgramBlock pbTmp = (IfProgramBlock)pb;
                        IfStatementBlock sbTmp = (IfStatementBlock)pbTmp.getStatementBlock();
                        if (sbTmp != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsSparkInstruction(pbTmp.getPredicate(), true))) {
                            pbTmp.setPredicate(Recompiler.recompileHopsDag2Forced(sbTmp.getPredicateHops(), tid, et));
                        }
                        for (ProgramBlock pb2 : pbTmp.getChildBlocksIfBody()) {
                            Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                        }
                        for (ProgramBlock pb2 : pbTmp.getChildBlocksElseBody()) {
                            Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                        }
                        break block14;
                    }
                    if (!(pb instanceof ForProgramBlock)) break block16;
                    ForProgramBlock pbTmp = (ForProgramBlock)pb;
                    ForStatementBlock sbTmp = (ForStatementBlock)pbTmp.getStatementBlock();
                    if (sbTmp != null && sbTmp.getFromHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsSparkInstruction(pbTmp.getFromInstructions(), true))) {
                        pbTmp.setFromInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getFromHops(), tid, et));
                    }
                    if (sbTmp != null && sbTmp.getToHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsSparkInstruction(pbTmp.getToInstructions(), true))) {
                        pbTmp.setToInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getToHops(), tid, et));
                    }
                    if (sbTmp != null && sbTmp.getIncrementHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsSparkInstruction(pbTmp.getIncrementInstructions(), true))) {
                        pbTmp.setIncrementInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getIncrementHops(), tid, et));
                    }
                    for (ProgramBlock pb2 : pbTmp.getChildBlocks()) {
                        Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                    }
                    break block14;
                }
                if (!(pb instanceof FunctionProgramBlock)) break block17;
                FunctionProgramBlock tmp2 = (FunctionProgramBlock)pb;
                for (ProgramBlock pb2 : tmp2.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                }
                break block14;
            }
            if (!(pb instanceof BasicProgramBlock)) break block14;
            BasicProgramBlock bpb = (BasicProgramBlock)pb;
            StatementBlock sb = bpb.getStatementBlock();
            if (sb != null) {
                tmp = bpb.getInstructions();
                tmp = Recompiler.recompileHopsDag2Forced(sb, sb.getHops(), tid, et);
                bpb.setInstructions(tmp);
            }
            if (OptTreeConverter.containsFunctionCallInstruction(bpb)) {
                tmp = bpb.getInstructions();
                for (Instruction inst : tmp) {
                    if (!(inst instanceof FunctionCallCPInstruction)) continue;
                    FunctionCallCPInstruction func = (FunctionCallCPInstruction)inst;
                    String fname = func.getFunctionName();
                    String fnamespace = func.getNamespace();
                    String fKey = DMLProgram.constructFunctionKey(fnamespace, fname);
                    if (fnStack.contains(fKey)) continue;
                    fnStack.add(fKey);
                    FunctionProgramBlock fpb = pb.getProgram().getFunctionProgramBlock(fnamespace, fname);
                    Recompiler.rRecompileProgramBlock2Forced(fpb, tid, fnStack, et);
                }
            }
        }
    }

    public static void removeUpdatedScalars(LocalVariableMap callVars, StatementBlock sb) {
        if (sb != null) {
            for (String varname : sb.variablesUpdated().getVariables().keySet()) {
                Data dat = callVars.get(varname);
                if (dat == null || dat.getDataType() != Types.DataType.SCALAR) continue;
                callVars.remove(varname);
            }
        }
    }

    public static void extractDAGOutputStatistics(ArrayList<Hop> hops, LocalVariableMap vars) {
        Recompiler.extractDAGOutputStatistics(hops, vars, true);
    }

    public static void extractDAGOutputStatistics(ArrayList<Hop> hops, LocalVariableMap vars, boolean overwrite) {
        for (Hop hop : hops) {
            Recompiler.extractDAGOutputStatistics(hop, vars, overwrite);
        }
    }

    public static void extractDAGOutputStatistics(Hop hop, LocalVariableMap vars, boolean overwrite) {
        if (hop instanceof DataOp && ((DataOp)hop).getOp() == Types.OpOpData.TRANSIENTWRITE) {
            String varName = hop.getName();
            if (!vars.keySet().contains(varName) || overwrite) {
                if (hop.getDataType() == Types.DataType.MATRIX) {
                    MatrixObject mo = new MatrixObject(Types.ValueType.FP64, null);
                    MatrixCharacteristics mc = new MatrixCharacteristics(hop.getDim1(), hop.getDim2(), ConfigurationManager.getBlocksize(), hop.getNnz());
                    MetaDataFormat meta = new MetaDataFormat(mc, null);
                    mo.setMetaData(meta);
                    vars.put(varName, mo);
                } else if (hop.getDataType() == Types.DataType.TENSOR) {
                    TensorObject to = new TensorObject(hop.getValueType(), null);
                    MatrixCharacteristics mc = new MatrixCharacteristics(hop.getDim1(), hop.getDim2(), ConfigurationManager.getBlocksize(), hop.getNnz());
                    MetaDataFormat meta = new MetaDataFormat(mc, null);
                    to.setMetaData(meta);
                    vars.put(varName, to);
                } else if (hop.getDataType() == Types.DataType.SCALAR) {
                    if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof LiteralOp) {
                        ScalarObject constant = HopRewriteUtils.getScalarObject((LiteralOp)hop.getInput().get(0));
                        if (constant != null) {
                            vars.put(varName, constant);
                        }
                    } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof DataOp) {
                        DataOp dop = (DataOp)hop.getInput().get(0);
                        String dopvarname = dop.getName();
                        if (dop.isRead() && vars.keySet().contains(dopvarname)) {
                            ScalarObject constant = (ScalarObject)vars.get(dopvarname);
                            vars.put(varName, constant);
                        }
                    } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof UnaryOp && (((UnaryOp)hop.getInput().get(0)).getOp() == Types.OpOp1.NROW || ((UnaryOp)hop.getInput().get(0)).getOp() == Types.OpOp1.NCOL)) {
                        UnaryOp uop = (UnaryOp)hop.getInput().get(0);
                        if (uop.getOp() == Types.OpOp1.NROW && uop.getInput().get(0).getDim1() > 0L) {
                            vars.put(varName, new IntObject(uop.getInput().get(0).getDim1()));
                        } else if (uop.getOp() == Types.OpOp1.NCOL && uop.getInput().get(0).getDim2() > 0L) {
                            vars.put(varName, new IntObject(uop.getInput().get(0).getDim2()));
                        }
                    } else {
                        vars.remove(varName);
                    }
                }
            } else {
                ScalarObject constant;
                Data dat = vars.get(varName);
                if (dat instanceof MatrixObject) {
                    MatrixObject mo = (MatrixObject)dat;
                    DataCharacteristics mc = mo.getDataCharacteristics();
                    if (OptimizerUtils.estimateSizeExactSparsity(mc.getRows(), mc.getCols(), mc.getNonZeros() >= 0L ? (double)mc.getNonZeros() / (double)mc.getRows() / (double)mc.getCols() : 1.0) < OptimizerUtils.estimateSize(hop.getDim1(), hop.getDim2())) {
                        mc.setDimension(hop.getDim1(), hop.getDim2());
                        mc.setNonZeros(hop.getNnz());
                    }
                } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof LiteralOp && (constant = HopRewriteUtils.getScalarObject((LiteralOp)hop.getInput().get(0))) != null) {
                    vars.put(varName, constant);
                }
            }
        }
    }

    private static boolean rRequiresRecompile(Hop hop) {
        boolean ret = hop.requiresRecompile();
        if (hop.isVisited()) {
            return ret;
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                if (ret |= Recompiler.rRequiresRecompile(c)) break;
            }
        }
        hop.setVisited();
        return ret;
    }

    public static void rClearLops(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof LiteralOp) {
            if (hop.getLops() != null) {
                hop.getLops().getOutputs().clear();
            }
        } else {
            hop.resetExecType();
            hop.setLops(null);
            if (hop.getInput() != null) {
                for (Hop c : hop.getInput()) {
                    Recompiler.rClearLops(c);
                }
            }
        }
        hop.setVisited();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rUpdateStatistics(Hop hop, LocalVariableMap vars) {
        HashMap<Long, Long> memo;
        Hop d;
        if (hop.isVisited()) {
            return;
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rUpdateStatistics(c, vars);
            }
        }
        if (HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTREAD)) {
            d = (DataOp)hop;
            String varName = d.getName();
            if (vars.keySet().contains(varName)) {
                Data dat = vars.get(varName);
                if (dat instanceof MatrixObject) {
                    MatrixObject mo = (MatrixObject)dat;
                    d.setDim1(mo.getNumRows());
                    d.setDim2(mo.getNumColumns());
                    d.setNnz(mo.getNnz());
                } else if (dat instanceof FrameObject) {
                    FrameObject fo = (FrameObject)dat;
                    d.setDim1(fo.getNumRows());
                    d.setDim2(fo.getNumColumns());
                } else if (dat instanceof TensorObject) {
                    TensorObject to = (TensorObject)dat;
                    d.setDim1(to.getNumRows());
                    d.setDim2(to.getNumColumns());
                    d.setNnz(to.getNnz());
                }
            }
        } else if (HopRewriteUtils.isData(hop, Types.OpOpData.PERSISTENTREAD) && !hop.dimsKnown() && ((DataOp)hop).getInputFormatType() != Types.FileFormat.CSV && !ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA)) {
            DataOp dop = (DataOp)hop;
            Recompiler.tryReadMetaDataFileDataCharacteristics(dop);
        } else if (hop instanceof DataGenOp) {
            d = (DataGenOp)hop;
            HashMap<String, Integer> params = ((DataGenOp)d).getParamIndexMap();
            if (((DataGenOp)d).getOp() == Types.OpOpDG.RAND || ((DataGenOp)d).getOp() == Types.OpOpDG.SINIT || ((DataGenOp)d).getOp() == Types.OpOpDG.SAMPLE) {
                boolean initUnknown;
                boolean bl = initUnknown = !d.dimsKnown();
                if (params.containsKey("rows") && params.containsKey("cols")) {
                    int ix1 = params.get("rows");
                    int ix2 = params.get("cols");
                    HashMap<Long, Long> memo2 = new HashMap<Long, Long>();
                    d.refreshRowsParameterInformation(d.getInput().get(ix1), vars, memo2);
                    d.refreshColsParameterInformation(d.getInput().get(ix2), vars, memo2);
                    if (!(initUnknown & d.dimsKnown())) {
                        ((DataGenOp)d).refreshSizeInformation();
                    }
                }
            } else if (((DataGenOp)d).getOp() == Types.OpOpDG.SEQ) {
                boolean initUnknown = !d.dimsKnown();
                int ix1 = params.get("from");
                int ix2 = params.get("to");
                int ix3 = params.get("incr");
                HashMap<Long, Double> memo3 = new HashMap<Long, Double>();
                double from = Hop.computeBoundsInformation(d.getInput().get(ix1), vars, memo3);
                double to = Hop.computeBoundsInformation(d.getInput().get(ix2), vars, memo3);
                double incr = Hop.computeBoundsInformation(d.getInput().get(ix3), vars, memo3);
                if (from != Double.MAX_VALUE && to != Double.MAX_VALUE) {
                    incr *= from > to && incr > 0.0 || from < to && incr < 0.0 ? -1.0 : 1.0;
                }
                if (from != Double.MAX_VALUE && to != Double.MAX_VALUE && incr != Double.MAX_VALUE) {
                    d.setDim1(UtilFunctions.getSeqLength(from, to, incr));
                    d.setDim2(1L);
                    ((DataGenOp)d).setIncrementValue(incr);
                }
                if (!(initUnknown & d.dimsKnown())) {
                    ((DataGenOp)d).refreshSizeInformation();
                }
            } else {
                if (((DataGenOp)d).getOp() != Types.OpOpDG.TIME) throw new DMLRuntimeException("Unexpected data generation method: " + (Object)((Object)((DataGenOp)d).getOp()));
                ((DataGenOp)d).refreshSizeInformation();
            }
        } else if (HopRewriteUtils.isReorg(hop, Types.ReOrgOp.RESHAPE)) {
            if (hop.getDataType() != Types.DataType.TENSOR) {
                hop.refreshSizeInformation();
                if (!hop.dimsKnown()) {
                    memo = new HashMap<Long, Long>();
                    hop.refreshRowsParameterInformation(hop.getInput().get(1), vars, memo);
                    hop.refreshColsParameterInformation(hop.getInput().get(2), vars, memo);
                }
            }
        } else if (hop instanceof IndexingOp && hop.getDataType() != Types.DataType.LIST) {
            hop.refreshSizeInformation();
            if (!hop.dimsKnown()) {
                memo = new HashMap();
                double rl = Hop.computeBoundsInformation(hop.getInput().get(1), vars, memo);
                double ru = Hop.computeBoundsInformation(hop.getInput().get(2), vars, memo);
                double cl = Hop.computeBoundsInformation(hop.getInput().get(3), vars, memo);
                double cu = Hop.computeBoundsInformation(hop.getInput().get(4), vars, memo);
                if (rl != Double.MAX_VALUE && ru != Double.MAX_VALUE) {
                    hop.setDim1((long)(ru - rl + 1.0));
                }
                if (cl != Double.MAX_VALUE && cu != Double.MAX_VALUE) {
                    hop.setDim2((long)(cu - cl + 1.0));
                }
            }
        } else {
            hop.refreshSizeInformation();
        }
        hop.setVisited();
    }

    public static void rReplaceLiterals(Hop hop, ExecutionContext ec, boolean scalarsOnly) {
        LiteralReplacement.rReplaceLiterals(hop, ec, scalarsOnly);
    }

    public static void rReplaceLiterals(Hop hop, LocalVariableMap vars, boolean scalarsOnly) {
        LiteralReplacement.rReplaceLiterals(hop, new ExecutionContext(vars), scalarsOnly);
    }

    public static void rSetExecType(Hop hop, LopProperties.ExecType etype) {
        if (hop.isVisited()) {
            return;
        }
        hop.setForcedExecType(etype);
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rSetExecType(c, etype);
            }
        }
        hop.setVisited();
    }

    public static int rGetMaxParallelism(List<Hop> hops) {
        int ret = -1;
        for (Hop c : hops) {
            ret = Math.max(ret, Recompiler.rGetMaxParallelism(c));
        }
        return ret;
    }

    public static int rGetMaxParallelism(Hop hop) {
        if (hop.isVisited()) {
            return -1;
        }
        int ret = Recompiler.rGetMaxParallelism(hop.getInput());
        if (hop instanceof MultiThreadedHop) {
            ret = Math.max(ret, ((MultiThreadedHop)hop).getMaxNumThreads());
        }
        hop.setVisited();
        return ret;
    }

    public static void rSetMaxParallelism(List<Hop> hops, int k) {
        for (Hop c : hops) {
            Recompiler.rSetMaxParallelism(c, k);
        }
    }

    public static void rSetMaxParallelism(Hop hop, int k) {
        if (hop.isVisited()) {
            return;
        }
        Recompiler.rSetMaxParallelism(hop.getInput(), k);
        if (hop instanceof MultiThreadedHop) {
            ((MultiThreadedHop)hop).setMaxNumThreads(k);
        }
        hop.setVisited();
    }

    public static boolean checkCPReblock(ExecutionContext ec, String varin) {
        CacheableData<?> obj = ec.getCacheableData(varin);
        DataCharacteristics mc = ec.getDataCharacteristics(varin);
        long rows = mc.getRows();
        long cols = mc.getCols();
        long nnz = mc.getNonZeros();
        if (!ConfigurationManager.isDynamicRecompilation() || !OptimizerUtils.isHybridExecutionMode()) {
            return false;
        }
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (obj.getRDDHandle() != null && iimd.getFileFormat() != Types.FileFormat.BINARY) {
            return false;
        }
        if (rows <= 0L || cols <= 0L) {
            try {
                long size = HDFSTool.getFilesizeOnHDFS(new Path(obj.getFileName()));
                return (double)size < OptimizerUtils.getLocalMemBudget() && size < 0x40000000L * (long)OptimizerUtils.getParallelTextReadParallelism();
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        double sp = OptimizerUtils.getSparsity(rows, cols, nnz);
        double mem = MatrixBlock.estimateSizeInMemory(rows, cols, sp);
        if (!OptimizerUtils.isValidCPDimensions(rows, cols) || !OptimizerUtils.isValidCPMatrixSize(rows, cols, sp) || mem >= OptimizerUtils.getLocalMemBudget()) {
            return false;
        }
        long estFilesize = (long)(3.5 * mem);
        long cpThreshold = 0x40000000L * (long)OptimizerUtils.getParallelTextReadParallelism();
        return estFilesize < cpThreshold;
    }

    public static boolean checkCPCheckpoint(DataCharacteristics dc) {
        return OptimizerUtils.isHybridExecutionMode() && OptimizerUtils.isValidCPDimensions(dc.getRows(), dc.getCols()) && !OptimizerUtils.exceedsCachingThreshold(dc.getCols(), OptimizerUtils.estimateSize(dc));
    }

    public static void executeInMemoryMatrixReblock(ExecutionContext ec, String varin, String varout) {
        MatrixObject in = ec.getMatrixObject(varin);
        MatrixObject out = ec.getMatrixObject(varout);
        MatrixBlock mb = (MatrixBlock)in.acquireRead();
        out.acquireModify(mb);
        out.release();
        in.release();
    }

    public static void executeInMemoryFrameReblock(ExecutionContext ec, String varin, String varout) {
        FrameObject in = ec.getFrameObject(varin);
        FrameObject out = ec.getFrameObject(varout);
        FrameBlock fb = (FrameBlock)in.acquireRead();
        out.acquireModify(fb);
        out.release();
        in.release();
    }

    private static void tryReadMetaDataFileDataCharacteristics(DataOp dop) {
        block15: {
            try {
                String mtdname = DataExpression.getMTDFileName(dop.getFileName());
                Path path = new Path(mtdname);
                FileSystem fs = IOUtilFunctions.getFileSystem(mtdname);
                if (!fs.exists(path)) break block15;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                    JSONObject mtd = JSONHelper.parse(br);
                    Types.DataType dt = Types.DataType.valueOf(String.valueOf(mtd.get("data_type")).toUpperCase());
                    dop.setDataType(dt);
                    if (dt != Types.DataType.FRAME) {
                        dop.setValueType(Types.ValueType.valueOf(String.valueOf(mtd.get("value_type")).toUpperCase()));
                    }
                    dop.setDim1(dt == Types.DataType.MATRIX || dt == Types.DataType.FRAME ? Long.parseLong(mtd.get("rows").toString()) : 0L);
                    dop.setDim2(dt == Types.DataType.MATRIX || dt == Types.DataType.FRAME ? Long.parseLong(mtd.get("cols").toString()) : 0L);
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
    }

    public static enum ResetType {
        RESET,
        RESET_KNOWN_DIMS,
        NO_RESET;


        public boolean isReset() {
            return this != NO_RESET;
        }
    }
}

