/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class TsmmSPInstruction
extends UnarySPInstruction {
    private MMTSJ.MMTSJType _type = null;

    private TsmmSPInstruction(Operator op, CPOperand in1, CPOperand out, MMTSJ.MMTSJType type, String opcode, String istr) {
        super(SPInstruction.SPType.TSMM, op, in1, out, opcode, istr);
        this._type = type;
    }

    public static TsmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("TsmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType type = MMTSJ.MMTSJType.valueOf(parts[3]);
        return new TsmmSPInstruction(null, in1, out, type, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaRDD tmp = in.map((Function)new RDDTSMMFunction(this._type));
        MatrixBlock out = RDDAggregateUtils.sumStable((JavaRDD<MatrixBlock>)tmp);
        sec.setMatrixOutput(this.output.getName(), out, this.getExtendedOpcode());
    }

    private static class RDDTSMMFunction
    implements Function<Tuple2<MatrixIndexes, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = 2935770425858019666L;
        private MMTSJ.MMTSJType _type = null;

        public RDDTSMMFunction(MMTSJ.MMTSJType type) {
            this._type = type;
        }

        public MatrixBlock call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            return ((MatrixBlock)arg0._2()).transposeSelfMatrixMultOperations(new MatrixBlock(), this._type);
        }
    }
}

