/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class MessageContextCreatorForAxis2 {
    private static final Log log = LogFactory.getLog(MessageContextCreatorForAxis2.class);
    private static SynapseConfiguration synCfg = null;
    private static SynapseEnvironment synEnv = null;

    public static MessageContext getSynapseMessageContext(org.apache.axis2.context.MessageContext axisMsgCtx) throws AxisFault {
        if (synCfg == null || synEnv == null) {
            String msg = "Synapse environment has not initialized properly..";
            log.fatal((Object)msg);
            throw new SynapseException(msg);
        }
        SynapseEnvironment synapseEnvironment = MessageContextCreatorForAxis2.getSynapseEnvironment(axisMsgCtx);
        SynapseConfiguration synapseConfiguration = MessageContextCreatorForAxis2.getSynapseConfiguration(axisMsgCtx);
        if (synapseConfiguration != null && synapseEnvironment != null) {
            return new Axis2MessageContext(axisMsgCtx, synapseConfiguration, synapseEnvironment);
        }
        return new Axis2MessageContext(axisMsgCtx, synCfg, synEnv);
    }

    public static void setSynConfig(SynapseConfiguration synCfg) {
        MessageContextCreatorForAxis2.synCfg = synCfg;
    }

    public static void setSynEnv(SynapseEnvironment synEnv) {
        MessageContextCreatorForAxis2.synEnv = synEnv;
    }

    private static SynapseConfiguration getSynapseConfiguration(org.apache.axis2.context.MessageContext axisMsgCtx) {
        AxisConfiguration axisCfg = axisMsgCtx.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisCfg.getParameter("synapse.config");
        if (param != null) {
            return (SynapseConfiguration)param.getValue();
        }
        return null;
    }

    private static SynapseEnvironment getSynapseEnvironment(org.apache.axis2.context.MessageContext axisMsgCtx) {
        AxisConfiguration axisCfg = axisMsgCtx.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisCfg.getParameter("synapse.env");
        if (param != null) {
            return (SynapseEnvironment)param.getValue();
        }
        return null;
    }
}

