/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

class FtpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer;
    private final FtpFileObject fileObject;
    private DataInputStream dis;
    private FtpFileObject.FtpInputStream mis;

    FtpRandomAccessContent(FtpFileObject fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(pos)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream(this.filePointer);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++FtpRandomAccessContent.this.filePointer;
                }
                return ret;
            }

            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            public void close() throws IOException {
                FtpRandomAccessContent.this.close();
            }
        });
        return this.dis;
    }

    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.abort();
            DataInputStream oldDis = this.dis;
            this.dis = null;
            oldDis.close();
            this.mis = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

