/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleXpathEngine;
import org.custommonkey.xmlunit.Transform;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUnit {
    private static DocumentBuilderFactory controlBuilderFactory;
    private static DocumentBuilderFactory testBuilderFactory;
    private static TransformerFactory transformerFactory;
    private static boolean ignoreWhitespace;
    private static URIResolver uriResolver;
    private static EntityResolver testEntityResolver;
    private static EntityResolver controlEntityResolver;
    private static NamespaceContext namespaceContext;
    private static boolean ignoreDiffBetweenTextAndCDATA;
    private static boolean ignoreComments;
    private static boolean normalize;
    private static boolean normalizeWhitespace;
    private static boolean ignoreAttributeOrder;
    private static String xsltVersion;
    private static String xpathFactoryName;
    private static final String XSLT_VERSION_START = " version=\"";
    private static final String XSLT_VERSION_END = "\">";
    private static final String STRIP_WHITESPACE_STYLESHEET_START;
    private static final String STRIP_WHITESPACE_STYLESHEET_END;
    private static final String STRIP_COMMENTS_STYLESHEET_START;
    private static final String STRIP_COMMENTS_STYLESHEET_END;

    private XMLUnit() {
    }

    public static void setControlParser(String className) {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", className);
        controlBuilderFactory = null;
        controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
    }

    public static DocumentBuilder newControlParser() throws ConfigurationException {
        try {
            controlBuilderFactory = XMLUnit.getControlDocumentBuilderFactory();
            DocumentBuilder builder = controlBuilderFactory.newDocumentBuilder();
            if (controlEntityResolver != null) {
                builder.setEntityResolver(controlEntityResolver);
            }
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static void setTestEntityResolver(EntityResolver resolver) {
        testEntityResolver = resolver;
    }

    public static void setControlEntityResolver(EntityResolver resolver) {
        controlEntityResolver = resolver;
    }

    public static EntityResolver getControlEntityResolver() {
        return controlEntityResolver;
    }

    public static DocumentBuilderFactory getControlDocumentBuilderFactory() {
        if (controlBuilderFactory == null) {
            controlBuilderFactory = DocumentBuilderFactory.newInstance();
            controlBuilderFactory.setNamespaceAware(true);
        }
        return controlBuilderFactory;
    }

    public static void setControlDocumentBuilderFactory(DocumentBuilderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot set control DocumentBuilderFactory to null!");
        }
        controlBuilderFactory = factory;
    }

    public static void setTestParser(String className) {
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", className);
        testBuilderFactory = null;
        testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
    }

    public static DocumentBuilder newTestParser() throws ConfigurationException {
        try {
            testBuilderFactory = XMLUnit.getTestDocumentBuilderFactory();
            DocumentBuilder builder = testBuilderFactory.newDocumentBuilder();
            if (testEntityResolver != null) {
                builder.setEntityResolver(testEntityResolver);
            }
            return builder;
        }
        catch (ParserConfigurationException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static DocumentBuilder getTestParser() throws ConfigurationException {
        return XMLUnit.newTestParser();
    }

    public static DocumentBuilder getControlParser() throws ConfigurationException {
        return XMLUnit.newControlParser();
    }

    public static DocumentBuilderFactory getTestDocumentBuilderFactory() {
        if (testBuilderFactory == null) {
            testBuilderFactory = DocumentBuilderFactory.newInstance();
            testBuilderFactory.setNamespaceAware(true);
        }
        return testBuilderFactory;
    }

    public static void setTestDocumentBuilderFactory(DocumentBuilderFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Cannot set test DocumentBuilderFactory to null!");
        }
        testBuilderFactory = factory;
    }

    public static void setIgnoreWhitespace(boolean ignore) {
        ignoreWhitespace = ignore;
        XMLUnit.getControlDocumentBuilderFactory().setIgnoringElementContentWhitespace(ignore);
        XMLUnit.getTestDocumentBuilderFactory().setIgnoringElementContentWhitespace(ignore);
    }

    public static boolean getIgnoreWhitespace() {
        return ignoreWhitespace;
    }

    public static Document buildControlDocument(String fromXML) throws SAXException, IOException {
        return XMLUnit.buildDocument(XMLUnit.newControlParser(), new StringReader(fromXML));
    }

    public static Document buildControlDocument(InputSource fromSource) throws IOException, SAXException {
        return XMLUnit.buildDocument(XMLUnit.newControlParser(), fromSource);
    }

    public static Document buildTestDocument(String fromXML) throws SAXException, IOException {
        return XMLUnit.buildDocument(XMLUnit.newTestParser(), new StringReader(fromXML));
    }

    public static Document buildTestDocument(InputSource fromSource) throws IOException, SAXException {
        return XMLUnit.buildDocument(XMLUnit.newTestParser(), fromSource);
    }

    public static Document buildDocument(DocumentBuilder withBuilder, Reader fromReader) throws SAXException, IOException {
        return XMLUnit.buildDocument(withBuilder, new InputSource(fromReader));
    }

    public static Document buildDocument(DocumentBuilder withBuilder, InputSource fromSource) throws IOException, SAXException {
        return withBuilder.parse(fromSource);
    }

    public static void setTransformerFactory(String className) {
        System.setProperty("javax.xml.transform.TransformerFactory", className);
        transformerFactory = null;
        XMLUnit.getTransformerFactory();
    }

    public static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            if (uriResolver != null) {
                transformerFactory.setURIResolver(uriResolver);
            }
        }
        return transformerFactory;
    }

    public static void setURIResolver(URIResolver resolver) {
        if (uriResolver != resolver) {
            uriResolver = resolver;
            transformerFactory = null;
            XMLUnit.getTransformerFactory();
        }
    }

    public static URIResolver getURIResolver() {
        return uriResolver;
    }

    public static void setSAXParserFactory(String className) {
        System.setProperty("javax.xml.parsers.SAXParserFactory", className);
        XMLUnit.getSAXParserFactory();
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory newFactory = SAXParserFactory.newInstance();
        newFactory.setNamespaceAware(true);
        return newFactory;
    }

    private static String getStripWhitespaceStylesheet() {
        return STRIP_WHITESPACE_STYLESHEET_START + XMLUnit.getXSLTVersion() + STRIP_WHITESPACE_STYLESHEET_END;
    }

    public static Transform getStripWhitespaceTransform(Document forDocument) {
        return new Transform((Node)forDocument, XMLUnit.getStripWhitespaceStylesheet());
    }

    private static String getStripCommentsStylesheet() {
        return STRIP_COMMENTS_STYLESHEET_START + XMLUnit.getXSLTVersion() + STRIP_COMMENTS_STYLESHEET_END;
    }

    public static Transform getStripCommentsTransform(Document forDocument) {
        return new Transform((Node)forDocument, XMLUnit.getStripCommentsStylesheet());
    }

    public static String getVersion() {
        return "1.1";
    }

    public static Diff compareXML(InputSource control, InputSource test) throws SAXException, IOException {
        return new Diff(control, test);
    }

    public static Diff compareXML(Reader control, Reader test) throws SAXException, IOException {
        return new Diff(control, test);
    }

    public static Diff compareXML(String control, Reader test) throws SAXException, IOException {
        return new Diff(new StringReader(control), test);
    }

    public static Diff compareXML(Reader control, String test) throws SAXException, IOException {
        return new Diff(control, new StringReader(test));
    }

    public static Diff compareXML(String control, String test) throws SAXException, IOException {
        return new Diff(control, test);
    }

    public static Diff compareXML(Document control, Document test) {
        return new Diff(control, test);
    }

    public static NamespaceContext getXpathNamespaceContext() {
        return namespaceContext;
    }

    public static void setXpathNamespaceContext(NamespaceContext ctx) {
        namespaceContext = ctx;
    }

    public static XpathEngine newXpathEngine() {
        XpathEngine eng = null;
        try {
            Class.forName("javax.xml.xpath.XPath");
            Class<?> c = Class.forName("org.custommonkey.xmlunit.jaxp13.Jaxp13XpathEngine");
            eng = (XpathEngine)c.newInstance();
        }
        catch (Throwable ex) {
            eng = new SimpleXpathEngine();
        }
        if (namespaceContext != null) {
            eng.setNamespaceContext(namespaceContext);
        }
        return eng;
    }

    public static void setIgnoreDiffBetweenTextAndCDATA(boolean b) {
        ignoreDiffBetweenTextAndCDATA = b;
    }

    public static boolean getIgnoreDiffBetweenTextAndCDATA() {
        return ignoreDiffBetweenTextAndCDATA;
    }

    public static void setIgnoreComments(boolean b) {
        ignoreComments = b;
    }

    public static boolean getIgnoreComments() {
        return ignoreComments;
    }

    public static void setNormalize(boolean b) {
        normalize = b;
    }

    public static boolean getNormalize() {
        return normalize;
    }

    public static void setNormalizeWhitespace(boolean b) {
        normalizeWhitespace = b;
    }

    public static boolean getNormalizeWhitespace() {
        return normalizeWhitespace;
    }

    public static void setIgnoreAttributeOrder(boolean b) {
        ignoreAttributeOrder = b;
    }

    public static boolean getIgnoreAttributeOrder() {
        return ignoreAttributeOrder;
    }

    public static void setXSLTVersion(String s) {
        try {
            Number n = NumberFormat.getInstance(Locale.US).parse(s);
            if (n.doubleValue() < 0.0) {
                throw new ConfigurationException(s + " doesn't reperesent a" + " positive number.");
            }
        }
        catch (ParseException e) {
            throw new ConfigurationException(e);
        }
        xsltVersion = s;
    }

    public static String getXSLTVersion() {
        return xsltVersion;
    }

    public static void setXPathFactory(String className) {
        xpathFactoryName = className;
    }

    public static String getXPathFactory() {
        return xpathFactoryName;
    }

    static String getXSLTStart() {
        return "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"" + XMLUnit.getXSLTVersion() + XSLT_VERSION_END;
    }

    static {
        ignoreWhitespace = false;
        uriResolver = null;
        testEntityResolver = null;
        controlEntityResolver = null;
        namespaceContext = null;
        ignoreDiffBetweenTextAndCDATA = false;
        ignoreComments = false;
        normalize = false;
        normalizeWhitespace = false;
        ignoreAttributeOrder = false;
        xsltVersion = "1.0";
        xpathFactoryName = null;
        STRIP_WHITESPACE_STYLESHEET_START = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"" + XSLT_VERSION_START;
        STRIP_WHITESPACE_STYLESHEET_END = XSLT_VERSION_END + "<xsl:output method=\"xml\" version=\"1.0\" indent=\"no\"/>" + "<xsl:strip-space elements=\"*\"/>" + "<xsl:template match=\"/\"><xsl:copy-of select=\".\"/></xsl:template>" + "</xsl:stylesheet>";
        STRIP_COMMENTS_STYLESHEET_START = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>" + "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"" + XSLT_VERSION_START;
        STRIP_COMMENTS_STYLESHEET_END = XSLT_VERSION_END + "<xsl:output method=\"xml\" version=\"1.0\" indent=\"no\"/>" + "<xsl:template match=\"node()[not(self::comment())]|@*\"><xsl:copy><xsl:apply-templates select=\"node()[not(self::comment())]|@*\"/></xsl:copy></xsl:template>" + "</xsl:stylesheet>";
    }
}

