/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.ClassUtils;

public class TypeMismatchException
extends PropertyAccessException {
    public static final String ERROR_CODE = "typeMismatch";
    private final Class requiredType;

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class requiredType) {
        this(propertyChangeEvent, requiredType, null);
    }

    public TypeMismatchException(PropertyChangeEvent propertyChangeEvent, Class requiredType, Throwable ex) {
        super(propertyChangeEvent, "Failed to convert property value of type [" + (propertyChangeEvent.getNewValue() != null ? ClassUtils.getQualifiedName(propertyChangeEvent.getNewValue().getClass()) : null) + "]" + (requiredType != null ? " to required type [" + ClassUtils.getQualifiedName((Class)requiredType) + "]" : "") + (propertyChangeEvent.getPropertyName() != null ? " for property '" + propertyChangeEvent.getPropertyName() + "'" : ""), ex);
        this.requiredType = requiredType;
    }

    public Class getRequiredType() {
        return this.requiredType;
    }

    public String getErrorCode() {
        return ERROR_CODE;
    }
}

