/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Layout } from 'src/dashboard/types';
import { buildTree } from './utils';

// The types defined for Layout and sub elements is not compatible with the data we get back fro a real dashboard layout
// This test file is using data from a real example dashboard to test real world data sets.  ts-ignore is set for this entire file
// until we can reconcile adjusting types to match the actual data structures used

describe('Ensure buildTree does not throw runtime errors when encountering an invalid node', () => {
  const node = {
    children: ['TABS-97PVJa11D_'],
    id: 'ROOT_ID',
    type: 'ROOT',
    parents: [],
  };

  const treeItem = {
    children: [],
    key: 'ROOT_ID',
    type: 'ROOT',
    title: 'All panels',
  };

  const layout: Layout = {
    'CHART-1L7NIcXvVN': {
      children: [],
      id: 'CHART-1L7NIcXvVN',
      meta: {
        chartId: 95,
        height: 79,
        sliceName: 'Games per Genre over time',
        uuid: '0f8976aa-7bb4-40c7-860b-64445a51aaaf',
        width: 6,
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq', 'ROW-fjg6YQBkH'],
      type: 'CHART',
    },
    'CHART-7mKdnU7OUJ': {
      children: [],
      id: 'CHART-7mKdnU7OUJ',
      meta: {
        chartId: 131,
        height: 80,
        sliceName: 'Games per Genre',
        uuid: '0499bdec-0837-44f3-ae8a-8c670de81afd',
        width: 3,
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq', 'ROW-yP9SB89PZ'],
      type: 'CHART',
    },
    'CHART-8OG3UJX-Tn': {
      children: [],
      id: 'CHART-8OG3UJX-Tn',
      meta: {
        chartId: 125,
        height: 54,
        sliceName: '# of Games That Hit 100k in Sales By Release Year',
        sliceNameOverride: 'Top 10 Consoles, by # of Hit Games',
        uuid: '2b69887b-23e3-b46d-d38c-8ea11856c555',
        width: 6,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-7kAf1blYU',
      ],
      type: 'CHART',
    },
    'CHART-W02beJK7ms': {
      children: [],
      id: 'CHART-W02beJK7ms',
      meta: {
        chartId: 78,
        height: 54,
        sliceName: 'Publishers With Most Titles',
        sliceNameOverride: 'Top 10 Games (by Global Sales)',
        uuid: 'd20b7324-3b80-24d4-37e2-3bd583b66713',
        width: 3,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-7kAf1blYU',
      ],
      type: 'CHART',
    },
    'CHART-XFag0yZdLk': {
      children: [],
      id: 'CHART-XFag0yZdLk',
      meta: {
        chartId: 123,
        height: 54,
        sliceName: 'Most Dominant Platforms',
        sliceNameOverride: 'Publishers of Top 25 Games',
        uuid: '1810975a-f6d4-07c3-495c-c3b535d01f21',
        width: 3,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-7kAf1blYU',
      ],
      type: 'CHART',
    },
    'CHART-XRvRfsMsaQ': {
      children: [],
      id: 'CHART-XRvRfsMsaQ',
      meta: {
        chartId: 113,
        height: 62,
        sliceName: 'Top 10 Games: Proportion of Sales in Markets',
        uuid: 'a40879d5-653a-42fe-9314-bbe88ad26e92',
        width: 6,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-NuR8GFQTO',
      ],
      type: 'CHART',
    },
    'CHART-XVIYTeubZh': {
      children: [],
      id: 'CHART-XVIYTeubZh',
      meta: {
        chartId: 132,
        height: 80,
        sliceName: 'Games',
        uuid: '2a5e562b-ab37-1b9b-1de3-1be4335c8e83',
        width: 5,
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq', 'ROW-yP9SB89PZ'],
      type: 'CHART',
    },
    'CHART-_sx22yawJO': {
      children: [],
      id: 'CHART-_sx22yawJO',
      meta: {
        chartId: 93,
        height: 62,
        sliceName: 'Popular Genres Across Platforms',
        uuid: '326fc7e5-b7f1-448e-8a6f-80d0e7ce0b64',
        width: 6,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-NuR8GFQTO',
      ],
      type: 'CHART',
    },
    'CHART-nYns6xr4Ft': {
      children: [],
      id: 'CHART-nYns6xr4Ft',
      meta: {
        chartId: 120,
        height: 79,
        sliceName: 'Total Sales per Market (Grouped by Genre)',
        uuid: 'd8bf948e-46fd-4380-9f9c-a950c34bcc92',
        width: 6,
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq', 'ROW-fjg6YQBkH'],
      type: 'CHART',
    },
    'CHART-uP9GF0z0rT': {
      children: [],
      id: 'CHART-uP9GF0z0rT',
      meta: {
        chartId: 127,
        height: 45,
        sliceName: 'Video Game Sales filter',
        uuid: 'fd9ce7ec-ae08-4f71-93e0-7c26b132b2e6',
        width: 4,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-2_QXp8aNq',
        'ROW-yP9SB89PZ',
        'COLUMN-F53B1OSMcz',
      ],
      type: 'CHART',
    },
    'CHART-wt6ZO8jRXZ': {
      children: [],
      id: 'CHART-wt6ZO8jRXZ',
      meta: {
        chartId: 103,
        height: 72,
        sliceName: 'Rise & Fall of Video Game Consoles',
        sliceNameOverride: 'Global Sales per Console',
        uuid: '83b0e2d0-d38b-d980-ed8e-e1c9846361b6',
        width: 12,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-XT1DsNA_V',
      ],
      type: 'CHART',
    },
    'COLUMN-F53B1OSMcz': {
      children: ['MARKDOWN-7K5cBNy7qu', 'CHART-uP9GF0z0rT'],
      id: 'COLUMN-F53B1OSMcz',
      meta: {
        // @ts-expect-error
        background: 'BACKGROUND_TRANSPARENT',
        width: 4,
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq', 'ROW-yP9SB89PZ'],
      type: 'COLUMN',
    },
    // @ts-expect-error
    DASHBOARD_VERSION_KEY: 'v2',
    // @ts-expect-error
    GRID_ID: {
      children: [],
      id: 'GRID_ID',
      parents: ['ROOT_ID'],
      type: 'GRID',
    },
    HEADER_ID: {
      id: 'HEADER_ID',
      type: 'HEADER',
      // @ts-expect-error
      meta: {
        text: 'Video Game Sales',
      },
    },
    'MARKDOWN-7K5cBNy7qu': {
      children: [],
      id: 'MARKDOWN-7K5cBNy7qu',
      meta: {
        // @ts-expect-error
        code: '# 🤿 Explore Trends\n\nDive into data on popular video games using the following dimensions:\n\n- Year\n- Platform\n- Publisher\n- Genre\n\nTo use the **Filter Games** box below, select values for each dimension you want to zoom in on and then click **Apply**. \n\nThe filter criteria you set in this Filter-box will apply to *all* charts in this tab.',
        height: 33,
        width: 4,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-2_QXp8aNq',
        'ROW-yP9SB89PZ',
        'COLUMN-F53B1OSMcz',
      ],
      type: 'MARKDOWN',
    },
    'MARKDOWN-JOZKOjVc3a': {
      children: [],
      id: 'MARKDOWN-JOZKOjVc3a',
      meta: {
        // @ts-expect-error
        code: '## 🎮Video Game Sales\n\nThis dashboard visualizes sales & platform data on video games that sold more than 100k copies. The data was last updated in early 2017.\n\n[Original dataset](https://www.kaggle.com/gregorut/videogamesales)',
        height: 18,
        width: 12,
      },
      parents: [
        'ROOT_ID',
        'TABS-97PVJa11D_',
        'TAB-lg-5ymUDgm',
        'ROW-0F99WDC-sz',
      ],
      type: 'MARKDOWN',
    },
    // @ts-expect-error
    ROOT_ID: {
      children: ['TABS-97PVJa11D_'],
      id: 'ROOT_ID',
      type: 'ROOT',
    },
    'ROW-0F99WDC-sz': {
      children: ['MARKDOWN-JOZKOjVc3a'],
      id: 'ROW-0F99WDC-sz',
      meta: {
        // @ts-expect-error
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-lg-5ymUDgm'],
      type: 'ROW',
    },
    'ROW-7kAf1blYU': {
      children: ['CHART-W02beJK7ms', 'CHART-XFag0yZdLk', 'CHART-8OG3UJX-Tn'],
      id: 'ROW-7kAf1blYU',
      meta: {
        // @ts-expect-error
        '0': 'ROOT_ID',
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-lg-5ymUDgm'],
      type: 'ROW',
    },
    'ROW-NuR8GFQTO': {
      children: ['CHART-_sx22yawJO', 'CHART-XRvRfsMsaQ'],
      id: 'ROW-NuR8GFQTO',
      meta: {
        // @ts-expect-error
        '0': 'ROOT_ID',
        '1': 'TABS-97PVJa11D_',
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-lg-5ymUDgm'],
      type: 'ROW',
    },
    'ROW-XT1DsNA_V': {
      children: ['CHART-wt6ZO8jRXZ'],
      id: 'ROW-XT1DsNA_V',
      meta: {
        // @ts-expect-error
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-lg-5ymUDgm'],
      type: 'ROW',
    },
    'ROW-fjg6YQBkH': {
      children: ['CHART-1L7NIcXvVN', 'CHART-nYns6xr4Ft'],
      id: 'ROW-fjg6YQBkH',
      meta: {
        // @ts-expect-error
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq'],
      type: 'ROW',
    },
    'ROW-yP9SB89PZ': {
      children: ['COLUMN-F53B1OSMcz', 'CHART-XVIYTeubZh', 'CHART-7mKdnU7OUJ'],
      id: 'ROW-yP9SB89PZ',
      meta: {
        // @ts-expect-error
        background: 'BACKGROUND_TRANSPARENT',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_', 'TAB-2_QXp8aNq'],
      type: 'ROW',
    },
    'TAB-2_QXp8aNq': {
      children: ['ROW-yP9SB89PZ', 'ROW-fjg6YQBkH'],
      id: 'TAB-2_QXp8aNq',
      // @ts-expect-error
      meta: {
        text: '🤿 Explore Trends',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_'],
      type: 'TAB',
    },
    'TAB-lg-5ymUDgm': {
      children: [
        'ROW-0F99WDC-sz',
        'ROW-XT1DsNA_V',
        'ROW-7kAf1blYU',
        'ROW-NuR8GFQTO',
      ],
      id: 'TAB-lg-5ymUDgm',
      // @ts-expect-error
      meta: {
        text: 'Overview',
      },
      parents: ['ROOT_ID', 'TABS-97PVJa11D_'],
      type: 'TAB',
    },
    'TABS-97PVJa11D_': {
      children: ['TAB-lg-5ymUDgm', 'TAB-2_QXp8aNq'],
      id: 'TABS-97PVJa11D_',
      // @ts-expect-error
      meta: {},
      parents: ['ROOT_ID'],
      type: 'TABS',
    },
  };

  const charts = {
    '78': {
      id: 78,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673046999783,
      chartUpdateStartTime: 1673046994590,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'table',
        slice_id: 78,
        url_params: {},
        granularity_sqla: 'year',
        time_grain_sqla: 'P1D',
        time_range: 'No filter',
        query_mode: 'raw',
        groupby: [],
        metrics: ['count'],
        all_columns: [
          'rank',
          'name',
          'global_sales',
          'platform',
          'genre',
          'publisher',
          'year',
        ],
        percent_metrics: [],
        adhoc_filters: [],
        order_by_cols: [],
        row_limit: 10,
        server_page_length: 10,
        order_desc: true,
        table_timestamp_format: 'smart_date',
        page_length: null,
        show_cell_bars: false,
        color_pn: false,
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          Europe: '#5AC189',
          Japan: '#FF7F44',
          'North America': '#666666',
          Other: '#E04355',
          PS2: '#FCC700',
          X360: '#A868B7',
          PS3: '#3CCCCB',
          Wii: '#A38F79',
          DS: '#8FD3E4',
          PS: '#A1A6BD',
          GBA: '#ACE1C4',
          PSP: '#FEC0A1',
          PS4: '#B2B2B2',
          PC: '#EFA1AA',
          GB: '#FDE380',
          XB: '#D3B3DA',
          NES: '#9EE5E5',
          '3DS': '#D1C6BC',
          N64: '#1FA8C9',
          SNES: '#454E7C',
          GC: '#5AC189',
          XOne: '#FF7F44',
          WiiU: '#E04355',
          PSV: '#FCC700',
          SAT: '#A868B7',
          GEN: '#3CCCCB',
          DC: '#A38F79',
          SCD: '#8FD3E4',
          NG: '#A1A6BD',
          WS: '#ACE1C4',
          TG16: '#FEC0A1',
          '3DO': '#B2B2B2',
          GG: '#EFA1AA',
          PCFX: '#FDE380',
          Nintendo: '#D3B3DA',
          'Take-Two Interactive': '#9EE5E5',
          'Microsoft Game Studios': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          Fighting: '#5AC189',
          Misc: '#FF7F44',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
        },
        shared_label_colors: {},
        color_scheme: 'supersetColors',
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        extra_form_data: {},
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '83862e7cb770044d4b5a4b2d8e665022',
          cached_dttm: null,
          cache_timeout: 86400,
          applied_template_filters: [],
          annotation_data: {},
          error: null,
          is_cached: null,
          query:
            'SELECT rank AS rank,\n       name AS name,\n       global_sales AS global_sales,\n       platform AS platform,\n       genre AS genre,\n       publisher AS publisher,\n       year AS year\nFROM main.video_game_sales\nLIMIT 10\nOFFSET 0;\n\n',
          status: 'success',
          stacktrace: null,
          rowcount: 10,
          from_dttm: null,
          to_dttm: null,
          label_map: {
            rank: ['rank'],
            name: ['name'],
            global_sales: ['global_sales'],
            platform: ['platform'],
            genre: ['genre'],
            publisher: ['publisher'],
            year: ['year'],
          },
          colnames: [
            'rank',
            'name',
            'global_sales',
            'platform',
            'genre',
            'publisher',
            'year',
          ],
          indexnames: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
          coltypes: [0, 1, 0, 1, 1, 1, 2],
          data: [
            {
              rank: 1,
              name: 'Wii Sports',
              global_sales: 82.74,
              platform: 'Wii',
              genre: 'Sports',
              publisher: 'Nintendo',
              year: 1136073600000,
            },
            {
              rank: 2,
              name: 'Super Mario Bros.',
              global_sales: 40.24,
              platform: 'NES',
              genre: 'Platform',
              publisher: 'Nintendo',
              year: 473385600000,
            },
            {
              rank: 3,
              name: 'Mario Kart Wii',
              global_sales: 35.82,
              platform: 'Wii',
              genre: 'Racing',
              publisher: 'Nintendo',
              year: 1199145600000,
            },
            {
              rank: 4,
              name: 'Wii Sports Resort',
              global_sales: 33,
              platform: 'Wii',
              genre: 'Sports',
              publisher: 'Nintendo',
              year: 1230768000000,
            },
            {
              rank: 5,
              name: 'Pokemon Red/Pokemon Blue',
              global_sales: 31.37,
              platform: 'GB',
              genre: 'Role-Playing',
              publisher: 'Nintendo',
              year: 820454400000,
            },
            {
              rank: 6,
              name: 'Tetris',
              global_sales: 30.26,
              platform: 'GB',
              genre: 'Puzzle',
              publisher: 'Nintendo',
              year: 599616000000,
            },
            {
              rank: 7,
              name: 'New Super Mario Bros.',
              global_sales: 30.01,
              platform: 'DS',
              genre: 'Platform',
              publisher: 'Nintendo',
              year: 1136073600000,
            },
            {
              rank: 8,
              name: 'Wii Play',
              global_sales: 29.02,
              platform: 'Wii',
              genre: 'Misc',
              publisher: 'Nintendo',
              year: 1136073600000,
            },
            {
              rank: 9,
              name: 'New Super Mario Bros. Wii',
              global_sales: 28.62,
              platform: 'Wii',
              genre: 'Platform',
              publisher: 'Nintendo',
              year: 1230768000000,
            },
            {
              rank: 10,
              name: 'Duck Hunt',
              global_sales: 28.31,
              platform: 'NES',
              genre: 'Shooter',
              publisher: 'Nintendo',
              year: 441763200000,
            },
          ],
          result_format: 'json',
          applied_filters: [
            {
              column: '__time_range',
            },
          ],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'table',
        slice_id: 78,
        url_params: {},
        granularity_sqla: 'year',
        time_grain_sqla: 'P1D',
        time_range: 'No filter',
        query_mode: 'raw',
        groupby: [],
        metrics: ['count'],
        all_columns: [
          'rank',
          'name',
          'global_sales',
          'platform',
          'genre',
          'publisher',
          'year',
        ],
        percent_metrics: [],
        adhoc_filters: [],
        order_by_cols: [],
        row_limit: 10,
        server_page_length: 10,
        order_desc: true,
        table_timestamp_format: 'smart_date',
        page_length: null,
        show_cell_bars: false,
        color_pn: false,
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '93': {
      id: 93,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673046999051,
      chartUpdateStartTime: 1673046994633,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'heatmap',
        slice_id: 93,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        all_columns_x: 'platform',
        all_columns_y: 'genre',
        metric: 'count',
        adhoc_filters: [],
        row_limit: 10000,
        linear_color_scheme: 'blue_white_yellow',
        xscale_interval: null,
        yscale_interval: null,
        canvas_image_rendering: 'pixelated',
        normalize_across: 'heatmap',
        left_margin: 'auto',
        bottom_margin: 'auto',
        y_axis_bounds: [null, null],
        y_axis_format: 'SMART_NUMBER',
        sort_x_axis: 'alpha_asc',
        sort_y_axis: 'alpha_asc',
        show_legend: true,
        show_perc: true,
        show_values: true,
        queryFields: {
          metric: 'metrics',
        },
        shared_label_colors: {},
        color_scheme: 'supersetColors',
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        extra_form_data: {},
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '74366173c918f7430ab23aaa5567af49',
          cached_dttm: null,
          cache_timeout: 86400,
          errors: [],
          form_data: {
            datasource: '20__table',
            viz_type: 'heatmap',
            slice_id: 93,
            url_params: {},
            granularity_sqla: 'year',
            time_range: 'No filter',
            all_columns_x: 'platform',
            all_columns_y: 'genre',
            metric: 'count',
            adhoc_filters: [],
            row_limit: 10000,
            linear_color_scheme: 'blue_white_yellow',
            xscale_interval: null,
            yscale_interval: null,
            canvas_image_rendering: 'pixelated',
            normalize_across: 'heatmap',
            left_margin: 'auto',
            bottom_margin: 'auto',
            y_axis_bounds: [null, null],
            y_axis_format: 'SMART_NUMBER',
            sort_x_axis: 'alpha_asc',
            sort_y_axis: 'alpha_asc',
            show_legend: true,
            show_perc: true,
            show_values: true,
            queryFields: {
              metric: 'metrics',
            },
            shared_label_colors: {},
            color_scheme: 'supersetColors',
            dashboardId: 9,
            applied_time_extras: {},
            where: '',
            having: '',
            having_filters: [],
            filters: [],
          },
          is_cached: false,
          query:
            'SELECT platform AS platform,\n       genre AS genre,\n       COUNT(*) AS count\nFROM main.video_game_sales\nGROUP BY platform,\n         genre\nLIMIT 10000\nOFFSET 0',
          from_dttm: null,
          to_dttm: null,
          status: 'success',
          stacktrace: null,
          rowcount: 293,
          colnames: ['platform', 'genre', 'count'],
          coltypes: [1, 1, 0],
          data: {
            records: [
              {
                x: '2600',
                y: 'Action',
                v: 61,
                perc: 0.15037593984962405,
                rank: 0.6962457337883959,
              },
              {
                x: '2600',
                y: 'Adventure',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: '2600',
                y: 'Fighting',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: '2600',
                y: 'Misc',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: '2600',
                y: 'Platform',
                v: 9,
                perc: 0.020050125313283207,
                rank: 0.2832764505119454,
              },
              {
                x: '2600',
                y: 'Puzzle',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: '2600',
                y: 'Racing',
                v: 6,
                perc: 0.012531328320802004,
                rank: 0.22184300341296928,
              },
              {
                x: '2600',
                y: 'Shooter',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: '2600',
                y: 'Simulation',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: '2600',
                y: 'Sports',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: '3DO',
                y: 'Adventure',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: '3DO',
                y: 'Puzzle',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: '3DO',
                y: 'Simulation',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: '3DS',
                y: 'Action',
                v: 182,
                perc: 0.45363408521303256,
                rank: 0.9146757679180887,
              },
              {
                x: '3DS',
                y: 'Adventure',
                v: 37,
                perc: 0.09022556390977443,
                rank: 0.6006825938566553,
              },
              {
                x: '3DS',
                y: 'Fighting',
                v: 14,
                perc: 0.03258145363408521,
                rank: 0.378839590443686,
              },
              {
                x: '3DS',
                y: 'Misc',
                v: 53,
                perc: 0.13032581453634084,
                rank: 0.6723549488054608,
              },
              {
                x: '3DS',
                y: 'Platform',
                v: 28,
                perc: 0.06766917293233082,
                rank: 0.5426621160409556,
              },
              {
                x: '3DS',
                y: 'Puzzle',
                v: 20,
                perc: 0.047619047619047616,
                rank: 0.4590443686006826,
              },
              {
                x: '3DS',
                y: 'Racing',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: '3DS',
                y: 'Role-Playing',
                v: 86,
                perc: 0.21303258145363407,
                rank: 0.7832764505119454,
              },
              {
                x: '3DS',
                y: 'Shooter',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: '3DS',
                y: 'Simulation',
                v: 30,
                perc: 0.07268170426065163,
                rank: 0.5580204778156996,
              },
              {
                x: '3DS',
                y: 'Sports',
                v: 26,
                perc: 0.06265664160401002,
                rank: 0.5273037542662116,
              },
              {
                x: '3DS',
                y: 'Strategy',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'DC',
                y: 'Action',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'DC',
                y: 'Adventure',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'DC',
                y: 'Fighting',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: 'DC',
                y: 'Platform',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'DC',
                y: 'Racing',
                v: 6,
                perc: 0.012531328320802004,
                rank: 0.22184300341296928,
              },
              {
                x: 'DC',
                y: 'Role-Playing',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'DC',
                y: 'Shooter',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'DC',
                y: 'Simulation',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'DC',
                y: 'Sports',
                v: 10,
                perc: 0.022556390977443608,
                rank: 0.3003412969283277,
              },
              {
                x: 'DS',
                y: 'Action',
                v: 343,
                perc: 0.8571428571428571,
                rank: 0.9863481228668942,
              },
              {
                x: 'DS',
                y: 'Adventure',
                v: 240,
                perc: 0.5989974937343359,
                rank: 0.9692832764505119,
              },
              {
                x: 'DS',
                y: 'Fighting',
                v: 36,
                perc: 0.08771929824561403,
                rank: 0.5887372013651877,
              },
              {
                x: 'DS',
                y: 'Misc',
                v: 393,
                perc: 0.9824561403508771,
                rank: 0.9965870307167235,
              },
              {
                x: 'DS',
                y: 'Platform',
                v: 92,
                perc: 0.22807017543859648,
                rank: 0.8003412969283277,
              },
              {
                x: 'DS',
                y: 'Puzzle',
                v: 238,
                perc: 0.5939849624060151,
                rank: 0.9641638225255973,
              },
              {
                x: 'DS',
                y: 'Racing',
                v: 67,
                perc: 0.16541353383458646,
                rank: 0.726962457337884,
              },
              {
                x: 'DS',
                y: 'Role-Playing',
                v: 200,
                perc: 0.49874686716791977,
                rank: 0.931740614334471,
              },
              {
                x: 'DS',
                y: 'Shooter',
                v: 42,
                perc: 0.10275689223057644,
                rank: 0.6279863481228669,
              },
              {
                x: 'DS',
                y: 'Simulation',
                v: 284,
                perc: 0.7092731829573935,
                rank: 0.9795221843003413,
              },
              {
                x: 'DS',
                y: 'Sports',
                v: 148,
                perc: 0.3684210526315789,
                rank: 0.8822525597269625,
              },
              {
                x: 'DS',
                y: 'Strategy',
                v: 79,
                perc: 0.19548872180451127,
                rank: 0.7679180887372014,
              },
              {
                x: 'GB',
                y: 'Action',
                v: 6,
                perc: 0.012531328320802004,
                rank: 0.22184300341296928,
              },
              {
                x: 'GB',
                y: 'Adventure',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'GB',
                y: 'Misc',
                v: 8,
                perc: 0.017543859649122806,
                rank: 0.26791808873720135,
              },
              {
                x: 'GB',
                y: 'Platform',
                v: 19,
                perc: 0.045112781954887216,
                rank: 0.45051194539249145,
              },
              {
                x: 'GB',
                y: 'Puzzle',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'GB',
                y: 'Racing',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'GB',
                y: 'Role-Playing',
                v: 21,
                perc: 0.05012531328320802,
                rank: 0.46757679180887374,
              },
              {
                x: 'GB',
                y: 'Shooter',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'GB',
                y: 'Simulation',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'GB',
                y: 'Sports',
                v: 9,
                perc: 0.020050125313283207,
                rank: 0.2832764505119454,
              },
              {
                x: 'GB',
                y: 'Strategy',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'GBA',
                y: 'Action',
                v: 167,
                perc: 0.41604010025062654,
                rank: 0.9078498293515358,
              },
              {
                x: 'GBA',
                y: 'Adventure',
                v: 38,
                perc: 0.09273182957393483,
                rank: 0.6092150170648464,
              },
              {
                x: 'GBA',
                y: 'Fighting',
                v: 23,
                perc: 0.05513784461152882,
                rank: 0.4812286689419795,
              },
              {
                x: 'GBA',
                y: 'Misc',
                v: 110,
                perc: 0.2731829573934837,
                rank: 0.8378839590443686,
              },
              {
                x: 'GBA',
                y: 'Platform',
                v: 142,
                perc: 0.3533834586466165,
                rank: 0.8737201365187713,
              },
              {
                x: 'GBA',
                y: 'Puzzle',
                v: 41,
                perc: 0.10025062656641603,
                rank: 0.621160409556314,
              },
              {
                x: 'GBA',
                y: 'Racing',
                v: 64,
                perc: 0.15789473684210525,
                rank: 0.7081911262798635,
              },
              {
                x: 'GBA',
                y: 'Role-Playing',
                v: 73,
                perc: 0.18045112781954886,
                rank: 0.7457337883959044,
              },
              {
                x: 'GBA',
                y: 'Shooter',
                v: 40,
                perc: 0.09774436090225563,
                rank: 0.6160409556313993,
              },
              {
                x: 'GBA',
                y: 'Simulation',
                v: 18,
                perc: 0.042606516290726815,
                rank: 0.43686006825938567,
              },
              {
                x: 'GBA',
                y: 'Sports',
                v: 88,
                perc: 0.21804511278195488,
                rank: 0.7918088737201365,
              },
              {
                x: 'GBA',
                y: 'Strategy',
                v: 18,
                perc: 0.042606516290726815,
                rank: 0.43686006825938567,
              },
              {
                x: 'GC',
                y: 'Action',
                v: 101,
                perc: 0.2506265664160401,
                rank: 0.8156996587030717,
              },
              {
                x: 'GC',
                y: 'Adventure',
                v: 20,
                perc: 0.047619047619047616,
                rank: 0.4590443686006826,
              },
              {
                x: 'GC',
                y: 'Fighting',
                v: 42,
                perc: 0.10275689223057644,
                rank: 0.6279863481228669,
              },
              {
                x: 'GC',
                y: 'Misc',
                v: 36,
                perc: 0.08771929824561403,
                rank: 0.5887372013651877,
              },
              {
                x: 'GC',
                y: 'Platform',
                v: 73,
                perc: 0.18045112781954886,
                rank: 0.7457337883959044,
              },
              {
                x: 'GC',
                y: 'Puzzle',
                v: 13,
                perc: 0.03007518796992481,
                rank: 0.36689419795221845,
              },
              {
                x: 'GC',
                y: 'Racing',
                v: 63,
                perc: 0.15538847117794485,
                rank: 0.7013651877133106,
              },
              {
                x: 'GC',
                y: 'Role-Playing',
                v: 27,
                perc: 0.06516290726817042,
                rank: 0.5358361774744027,
              },
              {
                x: 'GC',
                y: 'Shooter',
                v: 48,
                perc: 0.11779448621553884,
                rank: 0.6535836177474402,
              },
              {
                x: 'GC',
                y: 'Simulation',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: 'GC',
                y: 'Sports',
                v: 110,
                perc: 0.2731829573934837,
                rank: 0.8378839590443686,
              },
              {
                x: 'GC',
                y: 'Strategy',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'GEN',
                y: 'Action',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'GEN',
                y: 'Adventure',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'GEN',
                y: 'Fighting',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'GEN',
                y: 'Misc',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'GEN',
                y: 'Platform',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'GEN',
                y: 'Racing',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'GEN',
                y: 'Role-Playing',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'GEN',
                y: 'Shooter',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'GEN',
                y: 'Sports',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'GEN',
                y: 'Strategy',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'GG',
                y: 'Platform',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'N64',
                y: 'Action',
                v: 38,
                perc: 0.09273182957393483,
                rank: 0.6092150170648464,
              },
              {
                x: 'N64',
                y: 'Adventure',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'N64',
                y: 'Fighting',
                v: 29,
                perc: 0.07017543859649122,
                rank: 0.5511945392491467,
              },
              {
                x: 'N64',
                y: 'Misc',
                v: 18,
                perc: 0.042606516290726815,
                rank: 0.43686006825938567,
              },
              {
                x: 'N64',
                y: 'Platform',
                v: 30,
                perc: 0.07268170426065163,
                rank: 0.5580204778156996,
              },
              {
                x: 'N64',
                y: 'Puzzle',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: 'N64',
                y: 'Racing',
                v: 57,
                perc: 0.14035087719298245,
                rank: 0.6791808873720137,
              },
              {
                x: 'N64',
                y: 'Role-Playing',
                v: 8,
                perc: 0.017543859649122806,
                rank: 0.26791808873720135,
              },
              {
                x: 'N64',
                y: 'Shooter',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'N64',
                y: 'Simulation',
                v: 10,
                perc: 0.022556390977443608,
                rank: 0.3003412969283277,
              },
              {
                x: 'N64',
                y: 'Sports',
                v: 80,
                perc: 0.19799498746867167,
                rank: 0.7713310580204779,
              },
              {
                x: 'N64',
                y: 'Strategy',
                v: 9,
                perc: 0.020050125313283207,
                rank: 0.2832764505119454,
              },
              {
                x: 'NES',
                y: 'Action',
                v: 13,
                perc: 0.03007518796992481,
                rank: 0.36689419795221845,
              },
              {
                x: 'NES',
                y: 'Adventure',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'NES',
                y: 'Fighting',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'NES',
                y: 'Misc',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'NES',
                y: 'Platform',
                v: 28,
                perc: 0.06766917293233082,
                rank: 0.5426621160409556,
              },
              {
                x: 'NES',
                y: 'Puzzle',
                v: 14,
                perc: 0.03258145363408521,
                rank: 0.378839590443686,
              },
              {
                x: 'NES',
                y: 'Racing',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'NES',
                y: 'Role-Playing',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'NES',
                y: 'Shooter',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'NES',
                y: 'Sports',
                v: 14,
                perc: 0.03258145363408521,
                rank: 0.378839590443686,
              },
              {
                x: 'NG',
                y: 'Fighting',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'NG',
                y: 'Sports',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'PC',
                y: 'Action',
                v: 165,
                perc: 0.41102756892230574,
                rank: 0.9044368600682594,
              },
              {
                x: 'PC',
                y: 'Adventure',
                v: 65,
                perc: 0.16040100250626566,
                rank: 0.7167235494880546,
              },
              {
                x: 'PC',
                y: 'Fighting',
                v: 6,
                perc: 0.012531328320802004,
                rank: 0.22184300341296928,
              },
              {
                x: 'PC',
                y: 'Misc',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'PC',
                y: 'Platform',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'PC',
                y: 'Puzzle',
                v: 25,
                perc: 0.06015037593984962,
                rank: 0.515358361774744,
              },
              {
                x: 'PC',
                y: 'Racing',
                v: 60,
                perc: 0.14786967418546365,
                rank: 0.689419795221843,
              },
              {
                x: 'PC',
                y: 'Role-Playing',
                v: 104,
                perc: 0.2581453634085213,
                rank: 0.8225255972696246,
              },
              {
                x: 'PC',
                y: 'Shooter',
                v: 148,
                perc: 0.3684210526315789,
                rank: 0.8822525597269625,
              },
              {
                x: 'PC',
                y: 'Simulation',
                v: 115,
                perc: 0.2857142857142857,
                rank: 0.8430034129692833,
              },
              {
                x: 'PC',
                y: 'Sports',
                v: 49,
                perc: 0.12030075187969924,
                rank: 0.6621160409556314,
              },
              {
                x: 'PC',
                y: 'Strategy',
                v: 188,
                perc: 0.46867167919799496,
                rank: 0.9215017064846417,
              },
              {
                x: 'PCFX',
                y: 'Role-Playing',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'PS',
                y: 'Action',
                v: 157,
                perc: 0.39097744360902253,
                rank: 0.8976109215017065,
              },
              {
                x: 'PS',
                y: 'Adventure',
                v: 69,
                perc: 0.17042606516290726,
                rank: 0.7337883959044369,
              },
              {
                x: 'PS',
                y: 'Fighting',
                v: 108,
                perc: 0.2681704260651629,
                rank: 0.8327645051194539,
              },
              {
                x: 'PS',
                y: 'Misc',
                v: 76,
                perc: 0.18796992481203006,
                rank: 0.7610921501706485,
              },
              {
                x: 'PS',
                y: 'Platform',
                v: 64,
                perc: 0.15789473684210525,
                rank: 0.7081911262798635,
              },
              {
                x: 'PS',
                y: 'Puzzle',
                v: 32,
                perc: 0.07769423558897243,
                rank: 0.5699658703071673,
              },
              {
                x: 'PS',
                y: 'Racing',
                v: 145,
                perc: 0.3609022556390977,
                rank: 0.8771331058020477,
              },
              {
                x: 'PS',
                y: 'Role-Playing',
                v: 97,
                perc: 0.24060150375939848,
                rank: 0.8122866894197952,
              },
              {
                x: 'PS',
                y: 'Shooter',
                v: 96,
                perc: 0.23809523809523808,
                rank: 0.8088737201365188,
              },
              {
                x: 'PS',
                y: 'Simulation',
                v: 60,
                perc: 0.14786967418546365,
                rank: 0.689419795221843,
              },
              {
                x: 'PS',
                y: 'Sports',
                v: 222,
                perc: 0.5538847117794486,
                rank: 0.9556313993174061,
              },
              {
                x: 'PS',
                y: 'Strategy',
                v: 70,
                perc: 0.17293233082706766,
                rank: 0.7372013651877133,
              },
              {
                x: 'PS2',
                y: 'Action',
                v: 348,
                perc: 0.8696741854636592,
                rank: 0.9897610921501706,
              },
              {
                x: 'PS2',
                y: 'Adventure',
                v: 196,
                perc: 0.48872180451127817,
                rank: 0.9283276450511946,
              },
              {
                x: 'PS2',
                y: 'Fighting',
                v: 150,
                perc: 0.37343358395989973,
                rank: 0.8873720136518771,
              },
              {
                x: 'PS2',
                y: 'Misc',
                v: 222,
                perc: 0.5538847117794486,
                rank: 0.9556313993174061,
              },
              {
                x: 'PS2',
                y: 'Platform',
                v: 103,
                perc: 0.2556390977443609,
                rank: 0.8191126279863481,
              },
              {
                x: 'PS2',
                y: 'Puzzle',
                v: 18,
                perc: 0.042606516290726815,
                rank: 0.43686006825938567,
              },
              {
                x: 'PS2',
                y: 'Racing',
                v: 216,
                perc: 0.5388471177944862,
                rank: 0.9453924914675768,
              },
              {
                x: 'PS2',
                y: 'Role-Playing',
                v: 187,
                perc: 0.46616541353383456,
                rank: 0.9180887372013652,
              },
              {
                x: 'PS2',
                y: 'Shooter',
                v: 160,
                perc: 0.39849624060150374,
                rank: 0.9010238907849829,
              },
              {
                x: 'PS2',
                y: 'Simulation',
                v: 90,
                perc: 0.22305764411027568,
                rank: 0.7952218430034129,
              },
              {
                x: 'PS2',
                y: 'Sports',
                v: 400,
                perc: 1,
                rank: 1,
              },
              {
                x: 'PS2',
                y: 'Strategy',
                v: 71,
                perc: 0.17543859649122806,
                rank: 0.7406143344709898,
              },
              {
                x: 'PS3',
                y: 'Action',
                v: 380,
                perc: 0.949874686716792,
                rank: 0.9931740614334471,
              },
              {
                x: 'PS3',
                y: 'Adventure',
                v: 74,
                perc: 0.18295739348370926,
                rank: 0.7525597269624573,
              },
              {
                x: 'PS3',
                y: 'Fighting',
                v: 76,
                perc: 0.18796992481203006,
                rank: 0.7610921501706485,
              },
              {
                x: 'PS3',
                y: 'Misc',
                v: 124,
                perc: 0.3082706766917293,
                rank: 0.856655290102389,
              },
              {
                x: 'PS3',
                y: 'Platform',
                v: 37,
                perc: 0.09022556390977443,
                rank: 0.6006825938566553,
              },
              {
                x: 'PS3',
                y: 'Puzzle',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'PS3',
                y: 'Racing',
                v: 92,
                perc: 0.22807017543859648,
                rank: 0.8003412969283277,
              },
              {
                x: 'PS3',
                y: 'Role-Playing',
                v: 119,
                perc: 0.2957393483709273,
                rank: 0.8464163822525598,
              },
              {
                x: 'PS3',
                y: 'Shooter',
                v: 156,
                perc: 0.38847117794486213,
                rank: 0.89419795221843,
              },
              {
                x: 'PS3',
                y: 'Simulation',
                v: 31,
                perc: 0.07518796992481203,
                rank: 0.5648464163822525,
              },
              {
                x: 'PS3',
                y: 'Sports',
                v: 213,
                perc: 0.531328320802005,
                rank: 0.9402730375426621,
              },
              {
                x: 'PS3',
                y: 'Strategy',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'PS4',
                y: 'Action',
                v: 122,
                perc: 0.3032581453634085,
                rank: 0.8498293515358362,
              },
              {
                x: 'PS4',
                y: 'Adventure',
                v: 19,
                perc: 0.045112781954887216,
                rank: 0.45051194539249145,
              },
              {
                x: 'PS4',
                y: 'Fighting',
                v: 17,
                perc: 0.040100250626566414,
                rank: 0.42150170648464164,
              },
              {
                x: 'PS4',
                y: 'Misc',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'PS4',
                y: 'Platform',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'PS4',
                y: 'Puzzle',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'PS4',
                y: 'Racing',
                v: 17,
                perc: 0.040100250626566414,
                rank: 0.42150170648464164,
              },
              {
                x: 'PS4',
                y: 'Role-Playing',
                v: 47,
                perc: 0.11528822055137844,
                rank: 0.6467576791808873,
              },
              {
                x: 'PS4',
                y: 'Shooter',
                v: 34,
                perc: 0.08270676691729323,
                rank: 0.5767918088737202,
              },
              {
                x: 'PS4',
                y: 'Simulation',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'PS4',
                y: 'Sports',
                v: 43,
                perc: 0.10526315789473684,
                rank: 0.6348122866894198,
              },
              {
                x: 'PS4',
                y: 'Strategy',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'PSP',
                y: 'Action',
                v: 222,
                perc: 0.5538847117794486,
                rank: 0.9556313993174061,
              },
              {
                x: 'PSP',
                y: 'Adventure',
                v: 213,
                perc: 0.531328320802005,
                rank: 0.9402730375426621,
              },
              {
                x: 'PSP',
                y: 'Fighting',
                v: 74,
                perc: 0.18295739348370926,
                rank: 0.7525597269624573,
              },
              {
                x: 'PSP',
                y: 'Misc',
                v: 106,
                perc: 0.2631578947368421,
                rank: 0.8293515358361775,
              },
              {
                x: 'PSP',
                y: 'Platform',
                v: 36,
                perc: 0.08771929824561403,
                rank: 0.5887372013651877,
              },
              {
                x: 'PSP',
                y: 'Puzzle',
                v: 44,
                perc: 0.10776942355889724,
                rank: 0.6382252559726962,
              },
              {
                x: 'PSP',
                y: 'Racing',
                v: 65,
                perc: 0.16040100250626566,
                rank: 0.7167235494880546,
              },
              {
                x: 'PSP',
                y: 'Role-Playing',
                v: 192,
                perc: 0.47869674185463656,
                rank: 0.9249146757679181,
              },
              {
                x: 'PSP',
                y: 'Shooter',
                v: 37,
                perc: 0.09022556390977443,
                rank: 0.6006825938566553,
              },
              {
                x: 'PSP',
                y: 'Simulation',
                v: 29,
                perc: 0.07017543859649122,
                rank: 0.5511945392491467,
              },
              {
                x: 'PSP',
                y: 'Sports',
                v: 135,
                perc: 0.3358395989974937,
                rank: 0.8668941979522184,
              },
              {
                x: 'PSP',
                y: 'Strategy',
                v: 60,
                perc: 0.14786967418546365,
                rank: 0.689419795221843,
              },
              {
                x: 'PSV',
                y: 'Action',
                v: 141,
                perc: 0.3508771929824561,
                rank: 0.8703071672354948,
              },
              {
                x: 'PSV',
                y: 'Adventure',
                v: 86,
                perc: 0.21303258145363407,
                rank: 0.7832764505119454,
              },
              {
                x: 'PSV',
                y: 'Fighting',
                v: 16,
                perc: 0.03759398496240601,
                rank: 0.40955631399317405,
              },
              {
                x: 'PSV',
                y: 'Misc',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'PSV',
                y: 'Platform',
                v: 10,
                perc: 0.022556390977443608,
                rank: 0.3003412969283277,
              },
              {
                x: 'PSV',
                y: 'Puzzle',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'PSV',
                y: 'Racing',
                v: 11,
                perc: 0.02506265664160401,
                rank: 0.3242320819112628,
              },
              {
                x: 'PSV',
                y: 'Role-Playing',
                v: 82,
                perc: 0.20300751879699247,
                rank: 0.7747440273037542,
              },
              {
                x: 'PSV',
                y: 'Shooter',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'PSV',
                y: 'Simulation',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'PSV',
                y: 'Sports',
                v: 23,
                perc: 0.05513784461152882,
                rank: 0.4812286689419795,
              },
              {
                x: 'PSV',
                y: 'Strategy',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'SAT',
                y: 'Action',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'SAT',
                y: 'Adventure',
                v: 26,
                perc: 0.06265664160401002,
                rank: 0.5273037542662116,
              },
              {
                x: 'SAT',
                y: 'Fighting',
                v: 31,
                perc: 0.07518796992481203,
                rank: 0.5648464163822525,
              },
              {
                x: 'SAT',
                y: 'Misc',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'SAT',
                y: 'Platform',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'SAT',
                y: 'Puzzle',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'SAT',
                y: 'Racing',
                v: 8,
                perc: 0.017543859649122806,
                rank: 0.26791808873720135,
              },
              {
                x: 'SAT',
                y: 'Role-Playing',
                v: 17,
                perc: 0.040100250626566414,
                rank: 0.42150170648464164,
              },
              {
                x: 'SAT',
                y: 'Shooter',
                v: 22,
                perc: 0.05263157894736842,
                rank: 0.47440273037542663,
              },
              {
                x: 'SAT',
                y: 'Simulation',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'SAT',
                y: 'Sports',
                v: 16,
                perc: 0.03759398496240601,
                rank: 0.40955631399317405,
              },
              {
                x: 'SAT',
                y: 'Strategy',
                v: 18,
                perc: 0.042606516290726815,
                rank: 0.43686006825938567,
              },
              {
                x: 'SCD',
                y: 'Misc',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'SCD',
                y: 'Platform',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'SCD',
                y: 'Racing',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'SCD',
                y: 'Role-Playing',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'SCD',
                y: 'Strategy',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'SNES',
                y: 'Action',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: 'SNES',
                y: 'Adventure',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'SNES',
                y: 'Fighting',
                v: 25,
                perc: 0.06015037593984962,
                rank: 0.515358361774744,
              },
              {
                x: 'SNES',
                y: 'Misc',
                v: 17,
                perc: 0.040100250626566414,
                rank: 0.42150170648464164,
              },
              {
                x: 'SNES',
                y: 'Platform',
                v: 26,
                perc: 0.06265664160401002,
                rank: 0.5273037542662116,
              },
              {
                x: 'SNES',
                y: 'Puzzle',
                v: 13,
                perc: 0.03007518796992481,
                rank: 0.36689419795221845,
              },
              {
                x: 'SNES',
                y: 'Racing',
                v: 9,
                perc: 0.020050125313283207,
                rank: 0.2832764505119454,
              },
              {
                x: 'SNES',
                y: 'Role-Playing',
                v: 50,
                perc: 0.12280701754385964,
                rank: 0.6689419795221843,
              },
              {
                x: 'SNES',
                y: 'Shooter',
                v: 10,
                perc: 0.022556390977443608,
                rank: 0.3003412969283277,
              },
              {
                x: 'SNES',
                y: 'Simulation',
                v: 9,
                perc: 0.020050125313283207,
                rank: 0.2832764505119454,
              },
              {
                x: 'SNES',
                y: 'Sports',
                v: 49,
                perc: 0.12030075187969924,
                rank: 0.6621160409556314,
              },
              {
                x: 'SNES',
                y: 'Strategy',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'TG16',
                y: 'Adventure',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'TG16',
                y: 'Shooter',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'WS',
                y: 'Role-Playing',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'WS',
                y: 'Strategy',
                v: 2,
                perc: 0.002506265664160401,
                rank: 0.09044368600682594,
              },
              {
                x: 'Wii',
                y: 'Action',
                v: 238,
                perc: 0.5939849624060151,
                rank: 0.9641638225255973,
              },
              {
                x: 'Wii',
                y: 'Adventure',
                v: 84,
                perc: 0.20802005012531327,
                rank: 0.7781569965870307,
              },
              {
                x: 'Wii',
                y: 'Fighting',
                v: 42,
                perc: 0.10275689223057644,
                rank: 0.6279863481228669,
              },
              {
                x: 'Wii',
                y: 'Misc',
                v: 280,
                perc: 0.6992481203007519,
                rank: 0.9761092150170648,
              },
              {
                x: 'Wii',
                y: 'Platform',
                v: 58,
                perc: 0.14285714285714285,
                rank: 0.6825938566552902,
              },
              {
                x: 'Wii',
                y: 'Puzzle',
                v: 55,
                perc: 0.13533834586466165,
                rank: 0.6757679180887372,
              },
              {
                x: 'Wii',
                y: 'Racing',
                v: 94,
                perc: 0.23308270676691728,
                rank: 0.8054607508532423,
              },
              {
                x: 'Wii',
                y: 'Role-Playing',
                v: 35,
                perc: 0.08521303258145363,
                rank: 0.5802047781569966,
              },
              {
                x: 'Wii',
                y: 'Shooter',
                v: 66,
                perc: 0.16290726817042606,
                rank: 0.7235494880546075,
              },
              {
                x: 'Wii',
                y: 'Simulation',
                v: 87,
                perc: 0.21553884711779447,
                rank: 0.78839590443686,
              },
              {
                x: 'Wii',
                y: 'Sports',
                v: 261,
                perc: 0.6516290726817042,
                rank: 0.9726962457337884,
              },
              {
                x: 'Wii',
                y: 'Strategy',
                v: 25,
                perc: 0.06015037593984962,
                rank: 0.515358361774744,
              },
              {
                x: 'WiiU',
                y: 'Action',
                v: 63,
                perc: 0.15538847117794485,
                rank: 0.7013651877133106,
              },
              {
                x: 'WiiU',
                y: 'Adventure',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'WiiU',
                y: 'Fighting',
                v: 5,
                perc: 0.010025062656641603,
                rank: 0.1962457337883959,
              },
              {
                x: 'WiiU',
                y: 'Misc',
                v: 21,
                perc: 0.05012531328320802,
                rank: 0.46757679180887374,
              },
              {
                x: 'WiiU',
                y: 'Platform',
                v: 16,
                perc: 0.03759398496240601,
                rank: 0.40955631399317405,
              },
              {
                x: 'WiiU',
                y: 'Puzzle',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'WiiU',
                y: 'Racing',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'WiiU',
                y: 'Role-Playing',
                v: 6,
                perc: 0.012531328320802004,
                rank: 0.22184300341296928,
              },
              {
                x: 'WiiU',
                y: 'Shooter',
                v: 10,
                perc: 0.022556390977443608,
                rank: 0.3003412969283277,
              },
              {
                x: 'WiiU',
                y: 'Simulation',
                v: 1,
                perc: 0,
                rank: 0.03924914675767918,
              },
              {
                x: 'WiiU',
                y: 'Sports',
                v: 8,
                perc: 0.017543859649122806,
                rank: 0.26791808873720135,
              },
              {
                x: 'WiiU',
                y: 'Strategy',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'X360',
                y: 'Action',
                v: 324,
                perc: 0.8095238095238095,
                rank: 0.9829351535836177,
              },
              {
                x: 'X360',
                y: 'Adventure',
                v: 47,
                perc: 0.11528822055137844,
                rank: 0.6467576791808873,
              },
              {
                x: 'X360',
                y: 'Fighting',
                v: 65,
                perc: 0.16040100250626566,
                rank: 0.7167235494880546,
              },
              {
                x: 'X360',
                y: 'Misc',
                v: 126,
                perc: 0.3132832080200501,
                rank: 0.8600682593856656,
              },
              {
                x: 'X360',
                y: 'Platform',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'X360',
                y: 'Puzzle',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'X360',
                y: 'Racing',
                v: 105,
                perc: 0.2606516290726817,
                rank: 0.825938566552901,
              },
              {
                x: 'X360',
                y: 'Role-Playing',
                v: 76,
                perc: 0.18796992481203006,
                rank: 0.7610921501706485,
              },
              {
                x: 'X360',
                y: 'Shooter',
                v: 203,
                perc: 0.506265664160401,
                rank: 0.9351535836177475,
              },
              {
                x: 'X360',
                y: 'Simulation',
                v: 40,
                perc: 0.09774436090225563,
                rank: 0.6160409556313993,
              },
              {
                x: 'X360',
                y: 'Sports',
                v: 220,
                perc: 0.5488721804511278,
                rank: 0.9488054607508533,
              },
              {
                x: 'X360',
                y: 'Strategy',
                v: 28,
                perc: 0.06766917293233082,
                rank: 0.5426621160409556,
              },
              {
                x: 'XB',
                y: 'Action',
                v: 155,
                perc: 0.38596491228070173,
                rank: 0.8907849829351536,
              },
              {
                x: 'XB',
                y: 'Adventure',
                v: 26,
                perc: 0.06265664160401002,
                rank: 0.5273037542662116,
              },
              {
                x: 'XB',
                y: 'Fighting',
                v: 48,
                perc: 0.11779448621553884,
                rank: 0.6535836177474402,
              },
              {
                x: 'XB',
                y: 'Misc',
                v: 46,
                perc: 0.11278195488721804,
                rank: 0.6416382252559727,
              },
              {
                x: 'XB',
                y: 'Platform',
                v: 49,
                perc: 0.12030075187969924,
                rank: 0.6621160409556314,
              },
              {
                x: 'XB',
                y: 'Puzzle',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'XB',
                y: 'Racing',
                v: 123,
                perc: 0.3057644110275689,
                rank: 0.8532423208191127,
              },
              {
                x: 'XB',
                y: 'Role-Playing',
                v: 23,
                perc: 0.05513784461152882,
                rank: 0.4812286689419795,
              },
              {
                x: 'XB',
                y: 'Shooter',
                v: 132,
                perc: 0.3283208020050125,
                rank: 0.863481228668942,
              },
              {
                x: 'XB',
                y: 'Simulation',
                v: 24,
                perc: 0.05764411027568922,
                rank: 0.49829351535836175,
              },
              {
                x: 'XB',
                y: 'Sports',
                v: 170,
                perc: 0.42355889724310775,
                rank: 0.9112627986348123,
              },
              {
                x: 'XB',
                y: 'Strategy',
                v: 21,
                perc: 0.05012531328320802,
                rank: 0.46757679180887374,
              },
              {
                x: 'XOne',
                y: 'Action',
                v: 68,
                perc: 0.16791979949874686,
                rank: 0.7303754266211604,
              },
              {
                x: 'XOne',
                y: 'Adventure',
                v: 12,
                perc: 0.02756892230576441,
                rank: 0.34982935153583616,
              },
              {
                x: 'XOne',
                y: 'Fighting',
                v: 7,
                perc: 0.015037593984962405,
                rank: 0.24573378839590443,
              },
              {
                x: 'XOne',
                y: 'Misc',
                v: 15,
                perc: 0.03508771929824561,
                rank: 0.39419795221843,
              },
              {
                x: 'XOne',
                y: 'Platform',
                v: 4,
                perc: 0.007518796992481203,
                rank: 0.16552901023890784,
              },
              {
                x: 'XOne',
                y: 'Racing',
                v: 19,
                perc: 0.045112781954887216,
                rank: 0.45051194539249145,
              },
              {
                x: 'XOne',
                y: 'Role-Playing',
                v: 13,
                perc: 0.03007518796992481,
                rank: 0.36689419795221845,
              },
              {
                x: 'XOne',
                y: 'Shooter',
                v: 33,
                perc: 0.08020050125313283,
                rank: 0.5733788395904437,
              },
              {
                x: 'XOne',
                y: 'Simulation',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
              {
                x: 'XOne',
                y: 'Sports',
                v: 36,
                perc: 0.08771929824561403,
                rank: 0.5887372013651877,
              },
              {
                x: 'XOne',
                y: 'Strategy',
                v: 3,
                perc: 0.005012531328320802,
                rank: 0.12798634812286688,
              },
            ],
            extents: [1, 400],
          },
          applied_filters: [],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'heatmap',
        slice_id: 93,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        all_columns_x: 'platform',
        all_columns_y: 'genre',
        metric: 'count',
        adhoc_filters: [],
        row_limit: 10000,
        linear_color_scheme: 'blue_white_yellow',
        xscale_interval: null,
        yscale_interval: null,
        canvas_image_rendering: 'pixelated',
        normalize_across: 'heatmap',
        left_margin: 'auto',
        bottom_margin: 'auto',
        y_axis_bounds: [null, null],
        y_axis_format: 'SMART_NUMBER',
        sort_x_axis: 'alpha_asc',
        sort_y_axis: 'alpha_asc',
        show_legend: true,
        show_perc: true,
        show_values: true,
        queryFields: {
          metric: 'metrics',
        },
      },
    },
    '95': {
      id: 95,
      chartAlert: null,
      chartStatus: 'loading',
      chartStackTrace: null,
      chartUpdateEndTime: null,
      chartUpdateStartTime: 0,
      latestQueryFormData: {},
      sliceFormData: null,
      queryController: null,
      queriesResponse: null,
      triggerQuery: true,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'line',
        slice_id: 95,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'year',
        time_grain_sqla: null,
        time_range: 'No filter',
        metrics: ['count'],
        adhoc_filters: [],
        groupby: ['genre'],
        order_desc: true,
        contribution: false,
        row_limit: null,
        color_scheme: 'supersetColors',
        show_brush: 'auto',
        show_legend: true,
        rich_tooltip: true,
        show_markers: false,
        line_interpolation: 'linear',
        x_axis_label: 'Year Published',
        bottom_margin: 'auto',
        x_ticks_layout: 'auto',
        x_axis_format: 'smart_date',
        x_axis_showminmax: true,
        y_axis_label: '# of Games Published',
        left_margin: 'auto',
        y_axis_showminmax: true,
        y_axis_format: 'SMART_NUMBER',
        y_axis_bounds: [null, null],
        rolling_type: 'None',
        comparison_type: 'values',
        annotation_layers: [],
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          '3DO': '#B2B2B2',
          '3DS': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          DC: '#A38F79',
          DS: '#8FD3E4',
          Europe: '#5AC189',
          Fighting: '#5AC189',
          GB: '#FDE380',
          GBA: '#ACE1C4',
          GC: '#5AC189',
          GEN: '#3CCCCB',
          GG: '#EFA1AA',
          Japan: '#FF7F44',
          'Microsoft Game Studios': '#D1C6BC',
          Misc: '#FF7F44',
          N64: '#1FA8C9',
          NES: '#9EE5E5',
          NG: '#A1A6BD',
          Nintendo: '#D3B3DA',
          'North America': '#666666',
          Other: '#E04355',
          PC: '#EFA1AA',
          PCFX: '#FDE380',
          PS: '#A1A6BD',
          PS2: '#FCC700',
          PS3: '#3CCCCB',
          PS4: '#B2B2B2',
          PSP: '#FEC0A1',
          PSV: '#FCC700',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          SAT: '#A868B7',
          SCD: '#8FD3E4',
          SNES: '#454E7C',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
          TG16: '#FEC0A1',
          'Take-Two Interactive': '#9EE5E5',
          WS: '#ACE1C4',
          Wii: '#A38F79',
          WiiU: '#E04355',
          X360: '#A868B7',
          XB: '#D3B3DA',
          XOne: '#FF7F44',
        },
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '103': {
      id: 103,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673047001527,
      chartUpdateStartTime: 1673046994566,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'area',
        slice_id: 103,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'year',
        time_grain_sqla: null,
        time_range: 'No filter',
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'global_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 887,
              is_dttm: false,
              optionName: '_col_Global_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: false,
            isNew: false,
            label: 'SUM(Global_Sales)',
            optionName: 'metric_ufl75addr8c_oqqhdumirpn',
            sqlExpression: null,
          },
        ],
        adhoc_filters: [],
        groupby: ['platform'],
        order_desc: true,
        contribution: false,
        row_limit: null,
        show_brush: 'auto',
        show_legend: false,
        line_interpolation: 'linear',
        stacked_style: 'stream',
        color_scheme: 'supersetColors',
        rich_tooltip: true,
        x_axis_label: 'Year Published',
        bottom_margin: 'auto',
        x_ticks_layout: 'auto',
        x_axis_format: 'smart_date',
        x_axis_showminmax: true,
        y_axis_format: 'SMART_NUMBER',
        y_axis_bounds: [null, null],
        rolling_type: 'None',
        comparison_type: 'values',
        annotation_layers: [],
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
        shared_label_colors: {},
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        extra_form_data: {},
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '20775ba73440f8cab2208ae3f422402f',
          cached_dttm: null,
          cache_timeout: 86400,
          errors: [],
          form_data: {
            datasource: '20__table',
            viz_type: 'area',
            slice_id: 103,
            url_params: {
              preselect_filters:
                '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
            },
            granularity_sqla: 'year',
            time_grain_sqla: null,
            time_range: 'No filter',
            metrics: [
              {
                aggregate: 'SUM',
                column: {
                  column_name: 'global_sales',
                  description: null,
                  expression: null,
                  filterable: true,
                  groupby: true,
                  id: 887,
                  is_dttm: false,
                  optionName: '_col_Global_Sales',
                  python_date_format: null,
                  type: 'DOUBLE PRECISION',
                  verbose_name: null,
                },
                expressionType: 'SIMPLE',
                hasCustomLabel: false,
                isNew: false,
                label: 'SUM(Global_Sales)',
                optionName: 'metric_ufl75addr8c_oqqhdumirpn',
                sqlExpression: null,
              },
            ],
            adhoc_filters: [],
            groupby: ['platform'],
            order_desc: true,
            contribution: false,
            row_limit: null,
            show_brush: 'auto',
            show_legend: false,
            line_interpolation: 'linear',
            stacked_style: 'stream',
            color_scheme: 'supersetColors',
            rich_tooltip: true,
            x_axis_label: 'Year Published',
            bottom_margin: 'auto',
            x_ticks_layout: 'auto',
            x_axis_format: 'smart_date',
            x_axis_showminmax: true,
            y_axis_format: 'SMART_NUMBER',
            y_axis_bounds: [null, null],
            rolling_type: 'None',
            comparison_type: 'values',
            annotation_layers: [],
            queryFields: {
              groupby: 'groupby',
              metrics: 'metrics',
            },
            shared_label_colors: {},
            dashboardId: 9,
            applied_time_extras: {},
            where: '',
            having: '',
            having_filters: [],
            filters: [],
          },
          is_cached: false,
          query:
            'SELECT year AS __timestamp,\n               platform AS platform,\n               sum(global_sales) AS "SUM(Global_Sales)"\nFROM main.video_game_sales\nGROUP BY platform,\n         year\nORDER BY "SUM(Global_Sales)" DESC\nLIMIT 50000\nOFFSET 0',
          from_dttm: null,
          to_dttm: null,
          status: 'success',
          stacktrace: null,
          rowcount: 255,
          colnames: ['__timestamp', 'platform', 'SUM(Global_Sales)'],
          coltypes: [2, 1, 0],
          data: [
            {
              key: ['PS2'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 0,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 0,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 0,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 0,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 0,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 0,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 0,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 0,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 0,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 0,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 0,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 0,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 0,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 0,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 0,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 0,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 0,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 0,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 0,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 0,
                },
                {
                  x: 946684800000,
                  y: 39.11000000000001,
                  index: 20,
                  seriesIndex: 0,
                  display: {
                    y: 39.11000000000001,
                    y0: 422.2363863019829,
                  },
                  series: 0,
                },
                {
                  x: 978307200000,
                  y: 166.43000000000006,
                  index: 21,
                  seriesIndex: 0,
                  display: {
                    y: 166.43000000000006,
                    y0: 375.71659853838435,
                  },
                  series: 0,
                },
                {
                  x: 1009843200000,
                  y: 205.40000000000006,
                  index: 22,
                  seriesIndex: 0,
                  display: {
                    y: 205.40000000000006,
                    y0: 366.939571207276,
                  },
                  series: 0,
                },
                {
                  x: 1041379200000,
                  y: 184.28999999999996,
                  index: 23,
                  seriesIndex: 0,
                  display: {
                    y: 184.28999999999996,
                    y0: 366.3006269568918,
                  },
                  series: 0,
                },
                {
                  x: 1072915200000,
                  y: 211.77999999999992,
                  index: 24,
                  seriesIndex: 0,
                  display: {
                    y: 211.77999999999992,
                    y0: 358.5965490670251,
                  },
                  series: 0,
                },
                {
                  x: 1104537600000,
                  y: 160.65000000000012,
                  index: 25,
                  seriesIndex: 0,
                  display: {
                    y: 160.65000000000012,
                    y0: 367.8171603424089,
                  },
                  series: 0,
                },
                {
                  x: 1136073600000,
                  y: 103.41999999999999,
                  index: 26,
                  seriesIndex: 0,
                  display: {
                    y: 103.41999999999999,
                    y0: 332.2283968117778,
                  },
                  series: 0,
                },
                {
                  x: 1167609600000,
                  y: 76,
                  index: 27,
                  seriesIndex: 0,
                  display: {
                    y: 76,
                    y0: 334.2380715127416,
                  },
                  series: 0,
                },
                {
                  x: 1199145600000,
                  y: 53.830000000000034,
                  index: 28,
                  seriesIndex: 0,
                  display: {
                    y: 53.830000000000034,
                    y0: 331.2200000000006,
                  },
                  series: 0,
                },
                {
                  x: 1230768000000,
                  y: 26.45,
                  index: 29,
                  seriesIndex: 0,
                  display: {
                    y: 26.45,
                    y0: 323.57657904990293,
                  },
                  series: 0,
                },
                {
                  x: 1262304000000,
                  y: 5.629999999999995,
                  index: 30,
                  seriesIndex: 0,
                  display: {
                    y: 5.629999999999995,
                    y0: 353.63872327506743,
                  },
                  series: 0,
                },
                {
                  x: 1293840000000,
                  y: 0.47,
                  index: 31,
                  seriesIndex: 0,
                  display: {
                    y: 0.47,
                    y0: 346.7617397094945,
                  },
                  series: 0,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 0,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 0,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 0,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 0,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 0,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 0,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 0,
                },
              ],
            },
            {
              key: ['X360'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 1,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 1,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 1,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 1,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 1,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 303.54220029343605,
                  },
                  series: 1,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 1,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 1,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 1,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 1,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 1,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 1,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 1,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 1,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 317.05655475227184,
                  },
                  series: 1,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 297.7616336309462,
                  },
                  series: 1,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 247.66008078133538,
                  },
                  series: 1,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 231.76302062609608,
                  },
                  series: 1,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 204.41326841336158,
                  },
                  series: 1,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 218.39108391063536,
                  },
                  series: 1,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 264.466386301983,
                  },
                  series: 1,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 216.18659853838435,
                  },
                  series: 1,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 185.4195712072759,
                  },
                  series: 1,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 201.70062695689174,
                  },
                  series: 1,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 161.52654906702506,
                  },
                  series: 1,
                },
                {
                  x: 1104537600000,
                  y: 8.319999999999999,
                  index: 25,
                  seriesIndex: 1,
                  display: {
                    y: 8.319999999999999,
                    y0: 72.99716034240856,
                  },
                  series: 1,
                },
                {
                  x: 1136073600000,
                  y: 51.879999999999995,
                  index: 26,
                  seriesIndex: 1,
                  display: {
                    y: 51.879999999999995,
                    y0: 76.55839681177778,
                  },
                  series: 1,
                },
                {
                  x: 1167609600000,
                  y: 95.83999999999993,
                  index: 27,
                  seriesIndex: 1,
                  display: {
                    y: 95.83999999999993,
                    y0: 37.28807151274146,
                  },
                  series: 1,
                },
                {
                  x: 1199145600000,
                  y: 135.76000000000002,
                  index: 28,
                  seriesIndex: 1,
                  display: {
                    y: 135.76000000000002,
                    y0: 12.669999999999975,
                  },
                  series: 1,
                },
                {
                  x: 1230768000000,
                  y: 120.85000000000001,
                  index: 29,
                  seriesIndex: 1,
                  display: {
                    y: 120.85000000000001,
                    y0: 42.666579049902865,
                  },
                  series: 1,
                },
                {
                  x: 1262304000000,
                  y: 171.05000000000004,
                  index: 30,
                  seriesIndex: 1,
                  display: {
                    y: 171.05000000000004,
                    y0: 59.49872327506736,
                  },
                  series: 1,
                },
                {
                  x: 1293840000000,
                  y: 145.1200000000002,
                  index: 31,
                  seriesIndex: 1,
                  display: {
                    y: 145.1200000000002,
                    y0: 155.9517397094943,
                  },
                  series: 1,
                },
                {
                  x: 1325376000000,
                  y: 100.87999999999992,
                  index: 32,
                  seriesIndex: 1,
                  display: {
                    y: 100.87999999999992,
                    y0: 234.96331147601265,
                  },
                  series: 1,
                },
                {
                  x: 1356998400000,
                  y: 89.61000000000001,
                  index: 33,
                  seriesIndex: 1,
                  display: {
                    y: 89.61000000000001,
                    y0: 252.25434975261473,
                  },
                  series: 1,
                },
                {
                  x: 1388534400000,
                  y: 36.41999999999998,
                  index: 34,
                  seriesIndex: 1,
                  display: {
                    y: 36.41999999999998,
                    y0: 319.4614727314013,
                  },
                  series: 1,
                },
                {
                  x: 1420070400000,
                  y: 13.049999999999999,
                  index: 35,
                  seriesIndex: 1,
                  display: {
                    y: 13.049999999999999,
                    y0: 339.81176221105636,
                  },
                  series: 1,
                },
                {
                  x: 1451606400000,
                  y: 0.8300000000000001,
                  index: 36,
                  seriesIndex: 1,
                  display: {
                    y: 0.8300000000000001,
                    y0: 322.48515851727376,
                  },
                  series: 1,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 1,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 1,
                },
              ],
            },
            {
              key: ['PS3'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 2,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 2,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 2,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 2,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 2,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 2,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 2,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 2,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 2,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 2,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 2,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 2,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 2,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 2,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 2,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 2,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 2,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 2,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 2,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 2,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 461.34638630198293,
                  },
                  series: 2,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 542.1465985383844,
                  },
                  series: 2,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 572.3395712072761,
                  },
                  series: 2,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 550.5906269568918,
                  },
                  series: 2,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 570.376549067025,
                  },
                  series: 2,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 528.467160342409,
                  },
                  series: 2,
                },
                {
                  x: 1136073600000,
                  y: 21.070000000000004,
                  index: 26,
                  seriesIndex: 2,
                  display: {
                    y: 21.070000000000004,
                    y0: 573.5583968117778,
                  },
                  series: 2,
                },
                {
                  x: 1167609600000,
                  y: 73.81000000000006,
                  index: 27,
                  seriesIndex: 2,
                  display: {
                    y: 73.81000000000006,
                    y0: 565.2080715127415,
                  },
                  series: 2,
                },
                {
                  x: 1199145600000,
                  y: 119.69000000000001,
                  index: 28,
                  seriesIndex: 2,
                  display: {
                    y: 119.69000000000001,
                    y0: 559.2100000000006,
                  },
                  series: 2,
                },
                {
                  x: 1230768000000,
                  y: 132.33999999999997,
                  index: 29,
                  seriesIndex: 2,
                  display: {
                    y: 132.33999999999997,
                    y0: 560.4665790499031,
                  },
                  series: 2,
                },
                {
                  x: 1262304000000,
                  y: 144.42000000000007,
                  index: 30,
                  seriesIndex: 2,
                  display: {
                    y: 144.42000000000007,
                    y0: 491.06872327506755,
                  },
                  series: 2,
                },
                {
                  x: 1293840000000,
                  y: 159.3700000000001,
                  index: 31,
                  seriesIndex: 2,
                  display: {
                    y: 159.3700000000001,
                    y0: 409.6417397094946,
                  },
                  series: 2,
                },
                {
                  x: 1325376000000,
                  y: 109.49000000000002,
                  index: 32,
                  seriesIndex: 2,
                  display: {
                    y: 109.49000000000002,
                    y0: 377.9733114760125,
                  },
                  series: 2,
                },
                {
                  x: 1356998400000,
                  y: 117.38999999999994,
                  index: 33,
                  seriesIndex: 2,
                  display: {
                    y: 117.38999999999994,
                    y0: 356.37434975261476,
                  },
                  series: 2,
                },
                {
                  x: 1388534400000,
                  y: 50.96000000000002,
                  index: 34,
                  seriesIndex: 2,
                  display: {
                    y: 50.96000000000002,
                    y0: 360.5814727314012,
                  },
                  series: 2,
                },
                {
                  x: 1420070400000,
                  y: 18.220000000000002,
                  index: 35,
                  seriesIndex: 2,
                  display: {
                    y: 18.220000000000002,
                    y0: 354.5317622110564,
                  },
                  series: 2,
                },
                {
                  x: 1451606400000,
                  y: 2.59,
                  index: 36,
                  seriesIndex: 2,
                  display: {
                    y: 2.59,
                    y0: 323.31515851727374,
                  },
                  series: 2,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 2,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 2,
                },
              ],
            },
            {
              key: ['Wii'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 3,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 3,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 3,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 3,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 3,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 3,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 3,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 3,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 3,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 3,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 3,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 3,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 3,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 3,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 3,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 3,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 3,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 3,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 3,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 3,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 461.34638630198293,
                  },
                  series: 3,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 542.1465985383844,
                  },
                  series: 3,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 572.3395712072761,
                  },
                  series: 3,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 550.5906269568918,
                  },
                  series: 3,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 570.376549067025,
                  },
                  series: 3,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 528.467160342409,
                  },
                  series: 3,
                },
                {
                  x: 1136073600000,
                  y: 137.91000000000003,
                  index: 26,
                  seriesIndex: 3,
                  display: {
                    y: 137.91000000000003,
                    y0: 435.64839681177784,
                  },
                  series: 3,
                },
                {
                  x: 1167609600000,
                  y: 154.96999999999997,
                  index: 27,
                  seriesIndex: 3,
                  display: {
                    y: 154.96999999999997,
                    y0: 410.2380715127416,
                  },
                  series: 3,
                },
                {
                  x: 1199145600000,
                  y: 174.16,
                  index: 28,
                  seriesIndex: 3,
                  display: {
                    y: 174.16,
                    y0: 385.05000000000064,
                  },
                  series: 3,
                },
                {
                  x: 1230768000000,
                  y: 210.4400000000002,
                  index: 29,
                  seriesIndex: 3,
                  display: {
                    y: 210.4400000000002,
                    y0: 350.0265790499029,
                  },
                  series: 3,
                },
                {
                  x: 1262304000000,
                  y: 131.8000000000001,
                  index: 30,
                  seriesIndex: 3,
                  display: {
                    y: 131.8000000000001,
                    y0: 359.26872327506743,
                  },
                  series: 3,
                },
                {
                  x: 1293840000000,
                  y: 62.41000000000001,
                  index: 31,
                  seriesIndex: 3,
                  display: {
                    y: 62.41000000000001,
                    y0: 347.23173970949455,
                  },
                  series: 3,
                },
                {
                  x: 1325376000000,
                  y: 22.770000000000003,
                  index: 32,
                  seriesIndex: 3,
                  display: {
                    y: 22.770000000000003,
                    y0: 355.2033114760125,
                  },
                  series: 3,
                },
                {
                  x: 1356998400000,
                  y: 9.359999999999998,
                  index: 33,
                  seriesIndex: 3,
                  display: {
                    y: 9.359999999999998,
                    y0: 347.01434975261475,
                  },
                  series: 3,
                },
                {
                  x: 1388534400000,
                  y: 4.439999999999999,
                  index: 34,
                  seriesIndex: 3,
                  display: {
                    y: 4.439999999999999,
                    y0: 356.1414727314012,
                  },
                  series: 3,
                },
                {
                  x: 1420070400000,
                  y: 1.55,
                  index: 35,
                  seriesIndex: 3,
                  display: {
                    y: 1.55,
                    y0: 352.9817622110564,
                  },
                  series: 3,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 3,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 3,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 3,
                },
              ],
            },
            {
              key: ['DS'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 4,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 4,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 4,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 4,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 4,
                },
                {
                  x: 473385600000,
                  y: 0.02,
                  index: 5,
                  seriesIndex: 4,
                  display: {
                    y: 0.02,
                    y0: 303.54220029343605,
                  },
                  series: 4,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 4,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 4,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 4,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 4,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 4,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 4,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 4,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 4,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 317.05655475227184,
                  },
                  series: 4,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 297.7616336309462,
                  },
                  series: 4,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 247.66008078133538,
                  },
                  series: 4,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 231.76302062609608,
                  },
                  series: 4,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 204.41326841336158,
                  },
                  series: 4,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 218.39108391063536,
                  },
                  series: 4,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 264.466386301983,
                  },
                  series: 4,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 216.18659853838435,
                  },
                  series: 4,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 185.4195712072759,
                  },
                  series: 4,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 201.70062695689174,
                  },
                  series: 4,
                },
                {
                  x: 1072915200000,
                  y: 17.459999999999994,
                  index: 24,
                  seriesIndex: 4,
                  display: {
                    y: 17.459999999999994,
                    y0: 161.52654906702506,
                  },
                  series: 4,
                },
                {
                  x: 1104537600000,
                  y: 131.4000000000002,
                  index: 25,
                  seriesIndex: 4,
                  display: {
                    y: 131.4000000000002,
                    y0: 81.31716034240856,
                  },
                  series: 4,
                },
                {
                  x: 1136073600000,
                  y: 121.14999999999998,
                  index: 26,
                  seriesIndex: 4,
                  display: {
                    y: 121.14999999999998,
                    y0: 128.43839681177778,
                  },
                  series: 4,
                },
                {
                  x: 1167609600000,
                  y: 149.3600000000002,
                  index: 27,
                  seriesIndex: 4,
                  display: {
                    y: 149.3600000000002,
                    y0: 133.1280715127414,
                  },
                  series: 4,
                },
                {
                  x: 1199145600000,
                  y: 147.89000000000047,
                  index: 28,
                  seriesIndex: 4,
                  display: {
                    y: 147.89000000000047,
                    y0: 148.43,
                  },
                  series: 4,
                },
                {
                  x: 1230768000000,
                  y: 121.99000000000001,
                  index: 29,
                  seriesIndex: 4,
                  display: {
                    y: 121.99000000000001,
                    y0: 163.51657904990287,
                  },
                  series: 4,
                },
                {
                  x: 1262304000000,
                  y: 87.97999999999995,
                  index: 30,
                  seriesIndex: 4,
                  display: {
                    y: 87.97999999999995,
                    y0: 230.5487232750674,
                  },
                  series: 4,
                },
                {
                  x: 1293840000000,
                  y: 27.799999999999994,
                  index: 31,
                  seriesIndex: 4,
                  display: {
                    y: 27.799999999999994,
                    y0: 301.0717397094945,
                  },
                  series: 4,
                },
                {
                  x: 1325376000000,
                  y: 11.639999999999993,
                  index: 32,
                  seriesIndex: 4,
                  display: {
                    y: 11.639999999999993,
                    y0: 335.84331147601256,
                  },
                  series: 4,
                },
                {
                  x: 1356998400000,
                  y: 1.96,
                  index: 33,
                  seriesIndex: 4,
                  display: {
                    y: 1.96,
                    y0: 341.86434975261477,
                  },
                  series: 4,
                },
                {
                  x: 1388534400000,
                  y: 0.02,
                  index: 34,
                  seriesIndex: 4,
                  display: {
                    y: 0.02,
                    y0: 355.88147273140123,
                  },
                  series: 4,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 352.8617622110564,
                  },
                  series: 4,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 4,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 4,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 4,
                },
              ],
            },
            {
              key: ['PS'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 5,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 5,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 5,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 5,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 5,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 5,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 5,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 5,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 5,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 5,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 5,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 5,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 5,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 5,
                },
                {
                  x: 757382400000,
                  y: 6.020000000000001,
                  index: 14,
                  seriesIndex: 5,
                  display: {
                    y: 6.020000000000001,
                    y0: 317.05655475227184,
                  },
                  series: 5,
                },
                {
                  x: 788918400000,
                  y: 35.92000000000002,
                  index: 15,
                  seriesIndex: 5,
                  display: {
                    y: 35.92000000000002,
                    y0: 297.7616336309462,
                  },
                  series: 5,
                },
                {
                  x: 820454400000,
                  y: 94.67999999999999,
                  index: 16,
                  seriesIndex: 5,
                  display: {
                    y: 94.67999999999999,
                    y0: 247.66008078133538,
                  },
                  series: 5,
                },
                {
                  x: 852076800000,
                  y: 136.0799999999999,
                  index: 17,
                  seriesIndex: 5,
                  display: {
                    y: 136.0799999999999,
                    y0: 231.76302062609608,
                  },
                  series: 5,
                },
                {
                  x: 883612800000,
                  y: 169.58,
                  index: 18,
                  seriesIndex: 5,
                  display: {
                    y: 169.58,
                    y0: 204.41326841336158,
                  },
                  series: 5,
                },
                {
                  x: 915148800000,
                  y: 144.5700000000001,
                  index: 19,
                  seriesIndex: 5,
                  display: {
                    y: 144.5700000000001,
                    y0: 218.39108391063536,
                  },
                  series: 5,
                },
                {
                  x: 946684800000,
                  y: 96.27999999999993,
                  index: 20,
                  seriesIndex: 5,
                  display: {
                    y: 96.27999999999993,
                    y0: 265.516386301983,
                  },
                  series: 5,
                },
                {
                  x: 978307200000,
                  y: 35.520000000000024,
                  index: 21,
                  seriesIndex: 5,
                  display: {
                    y: 35.520000000000024,
                    y0: 300.04659853838433,
                  },
                  series: 5,
                },
                {
                  x: 1009843200000,
                  y: 6.689999999999998,
                  index: 22,
                  seriesIndex: 5,
                  display: {
                    y: 6.689999999999998,
                    y0: 307.949571207276,
                  },
                  series: 5,
                },
                {
                  x: 1041379200000,
                  y: 2.05,
                  index: 23,
                  seriesIndex: 5,
                  display: {
                    y: 2.05,
                    y0: 313.59062695689175,
                  },
                  series: 5,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 5,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 5,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 5,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 5,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 5,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 5,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 5,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 5,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 5,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 5,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 5,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 5,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 5,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 5,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 5,
                },
              ],
            },
            {
              key: ['GBA'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 6,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 6,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 6,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 6,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 6,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 6,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 6,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 6,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 6,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 6,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 6,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 6,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 6,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 6,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 317.05655475227184,
                  },
                  series: 6,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 297.7616336309462,
                  },
                  series: 6,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 247.66008078133538,
                  },
                  series: 6,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 231.76302062609608,
                  },
                  series: 6,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 204.41326841336158,
                  },
                  series: 6,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 218.39108391063536,
                  },
                  series: 6,
                },
                {
                  x: 946684800000,
                  y: 0.06,
                  index: 20,
                  seriesIndex: 6,
                  display: {
                    y: 0.06,
                    y0: 265.456386301983,
                  },
                  series: 6,
                },
                {
                  x: 978307200000,
                  y: 61.62000000000001,
                  index: 21,
                  seriesIndex: 6,
                  display: {
                    y: 61.62000000000001,
                    y0: 238.42659853838433,
                  },
                  series: 6,
                },
                {
                  x: 1009843200000,
                  y: 74.38,
                  index: 22,
                  seriesIndex: 6,
                  display: {
                    y: 74.38,
                    y0: 233.56957120727597,
                  },
                  series: 6,
                },
                {
                  x: 1041379200000,
                  y: 56.72999999999996,
                  index: 23,
                  seriesIndex: 6,
                  display: {
                    y: 56.72999999999996,
                    y0: 256.8606269568918,
                  },
                  series: 6,
                },
                {
                  x: 1072915200000,
                  y: 78.09,
                  index: 24,
                  seriesIndex: 6,
                  display: {
                    y: 78.09,
                    y0: 251.61654906702506,
                  },
                  series: 6,
                },
                {
                  x: 1104537600000,
                  y: 33.90000000000001,
                  index: 25,
                  seriesIndex: 6,
                  display: {
                    y: 33.90000000000001,
                    y0: 306.1171603424089,
                  },
                  series: 6,
                },
                {
                  x: 1136073600000,
                  y: 5.35,
                  index: 26,
                  seriesIndex: 6,
                  display: {
                    y: 5.35,
                    y0: 315.5883968117778,
                  },
                  series: 6,
                },
                {
                  x: 1167609600000,
                  y: 3.4299999999999997,
                  index: 27,
                  seriesIndex: 6,
                  display: {
                    y: 3.4299999999999997,
                    y0: 330.51807151274164,
                  },
                  series: 6,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 6,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 6,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 6,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 6,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 6,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 6,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 6,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 6,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 6,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 6,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 6,
                },
              ],
            },
            {
              key: ['PSP'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 7,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 7,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 7,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 7,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 7,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 7,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 7,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 7,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 7,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 7,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 7,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 7,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 7,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 7,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 317.05655475227184,
                  },
                  series: 7,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 297.7616336309462,
                  },
                  series: 7,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 247.66008078133538,
                  },
                  series: 7,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 231.76302062609608,
                  },
                  series: 7,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 204.41326841336158,
                  },
                  series: 7,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 218.39108391063536,
                  },
                  series: 7,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 264.466386301983,
                  },
                  series: 7,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 216.18659853838435,
                  },
                  series: 7,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 185.4195712072759,
                  },
                  series: 7,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 201.70062695689174,
                  },
                  series: 7,
                },
                {
                  x: 1072915200000,
                  y: 7.13,
                  index: 24,
                  seriesIndex: 7,
                  display: {
                    y: 7.13,
                    y0: 178.98654906702507,
                  },
                  series: 7,
                },
                {
                  x: 1104537600000,
                  y: 44.23000000000001,
                  index: 25,
                  seriesIndex: 7,
                  display: {
                    y: 44.23000000000001,
                    y0: 212.71716034240876,
                  },
                  series: 7,
                },
                {
                  x: 1136073600000,
                  y: 55.850000000000044,
                  index: 26,
                  seriesIndex: 7,
                  display: {
                    y: 55.850000000000044,
                    y0: 249.58839681177776,
                  },
                  series: 7,
                },
                {
                  x: 1167609600000,
                  y: 47.48000000000004,
                  index: 27,
                  seriesIndex: 7,
                  display: {
                    y: 47.48000000000004,
                    y0: 282.4880715127416,
                  },
                  series: 7,
                },
                {
                  x: 1199145600000,
                  y: 34.680000000000035,
                  index: 28,
                  seriesIndex: 7,
                  display: {
                    y: 34.680000000000035,
                    y0: 296.3200000000005,
                  },
                  series: 7,
                },
                {
                  x: 1230768000000,
                  y: 38.070000000000036,
                  index: 29,
                  seriesIndex: 7,
                  display: {
                    y: 38.070000000000036,
                    y0: 285.5065790499029,
                  },
                  series: 7,
                },
                {
                  x: 1262304000000,
                  y: 35.11000000000007,
                  index: 30,
                  seriesIndex: 7,
                  display: {
                    y: 35.11000000000007,
                    y0: 318.52872327506736,
                  },
                  series: 7,
                },
                {
                  x: 1293840000000,
                  y: 17.89000000000001,
                  index: 31,
                  seriesIndex: 7,
                  display: {
                    y: 17.89000000000001,
                    y0: 328.87173970949453,
                  },
                  series: 7,
                },
                {
                  x: 1325376000000,
                  y: 7.71999999999999,
                  index: 32,
                  seriesIndex: 7,
                  display: {
                    y: 7.71999999999999,
                    y0: 347.48331147601255,
                  },
                  series: 7,
                },
                {
                  x: 1356998400000,
                  y: 3.189999999999996,
                  index: 33,
                  seriesIndex: 7,
                  display: {
                    y: 3.189999999999996,
                    y0: 343.82434975261475,
                  },
                  series: 7,
                },
                {
                  x: 1388534400000,
                  y: 0.24000000000000005,
                  index: 34,
                  seriesIndex: 7,
                  display: {
                    y: 0.24000000000000005,
                    y0: 355.9014727314012,
                  },
                  series: 7,
                },
                {
                  x: 1420070400000,
                  y: 0.12000000000000001,
                  index: 35,
                  seriesIndex: 7,
                  display: {
                    y: 0.12000000000000001,
                    y0: 352.8617622110564,
                  },
                  series: 7,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 7,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 7,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 7,
                },
              ],
            },
            {
              key: ['PS4'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 8,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 8,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 8,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 8,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 8,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 303.5122002934361,
                  },
                  series: 8,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 8,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 8,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 305.7350172280039,
                  },
                  series: 8,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 8,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 8,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 8,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 299.5500376687394,
                  },
                  series: 8,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 8,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 304.2065547522718,
                  },
                  series: 8,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 293.5316336309462,
                  },
                  series: 8,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 237.07008078133538,
                  },
                  series: 8,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 220.5030206260961,
                  },
                  series: 8,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 201.13326841336158,
                  },
                  series: 8,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 213.64108391063536,
                  },
                  series: 8,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 259.786386301983,
                  },
                  series: 8,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 210.67659853838435,
                  },
                  series: 8,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 176.8195712072759,
                  },
                  series: 8,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 192.74062695689176,
                  },
                  series: 8,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 151.06654906702508,
                  },
                  series: 8,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 68.52716034240856,
                  },
                  series: 8,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 73.58839681177778,
                  },
                  series: 8,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 27.888071512741476,
                  },
                  series: 8,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 0,
                  },
                  series: 8,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 25.506579049902825,
                  },
                  series: 8,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 35.038723275067355,
                  },
                  series: 8,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 115.55173970949426,
                  },
                  series: 8,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 8,
                  display: {
                    y: 0,
                    y0: 175.06331147601264,
                  },
                  series: 8,
                },
                {
                  x: 1356998400000,
                  y: 24.760000000000005,
                  index: 33,
                  seriesIndex: 8,
                  display: {
                    y: 24.760000000000005,
                    y0: 180.13434975261472,
                  },
                  series: 8,
                },
                {
                  x: 1388534400000,
                  y: 98.76000000000003,
                  index: 34,
                  seriesIndex: 8,
                  display: {
                    y: 98.76000000000003,
                    y0: 170.06147273140124,
                  },
                  series: 8,
                },
                {
                  x: 1420070400000,
                  y: 115.29999999999997,
                  index: 35,
                  seriesIndex: 8,
                  display: {
                    y: 115.29999999999997,
                    y0: 192.96176221105642,
                  },
                  series: 8,
                },
                {
                  x: 1451606400000,
                  y: 39.25000000000002,
                  index: 36,
                  seriesIndex: 8,
                  display: {
                    y: 39.25000000000002,
                    y0: 273.94515851727374,
                  },
                  series: 8,
                },
                {
                  x: 1483228800000,
                  y: 0.03,
                  index: 37,
                  seriesIndex: 8,
                  display: {
                    y: 0.03,
                    y0: 293.55515851727375,
                  },
                  series: 8,
                },
              ],
            },
            {
              key: ['PC'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 9,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 9,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 9,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 9,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 9,
                },
                {
                  x: 473385600000,
                  y: 0.03,
                  index: 5,
                  seriesIndex: 9,
                  display: {
                    y: 0.03,
                    y0: 303.5122002934361,
                  },
                  series: 9,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 9,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 9,
                },
                {
                  x: 567993600000,
                  y: 0.03,
                  index: 8,
                  seriesIndex: 9,
                  display: {
                    y: 0.03,
                    y0: 305.7350172280039,
                  },
                  series: 9,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 9,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 9,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 9,
                },
                {
                  x: 694224000000,
                  y: 3.0199999999999996,
                  index: 12,
                  seriesIndex: 9,
                  display: {
                    y: 3.0199999999999996,
                    y0: 299.5500376687394,
                  },
                  series: 9,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 9,
                },
                {
                  x: 757382400000,
                  y: 12.85,
                  index: 14,
                  seriesIndex: 9,
                  display: {
                    y: 12.85,
                    y0: 304.2065547522718,
                  },
                  series: 9,
                },
                {
                  x: 788918400000,
                  y: 4.2299999999999995,
                  index: 15,
                  seriesIndex: 9,
                  display: {
                    y: 4.2299999999999995,
                    y0: 293.5316336309462,
                  },
                  series: 9,
                },
                {
                  x: 820454400000,
                  y: 10.59,
                  index: 16,
                  seriesIndex: 9,
                  display: {
                    y: 10.59,
                    y0: 237.07008078133538,
                  },
                  series: 9,
                },
                {
                  x: 852076800000,
                  y: 11.260000000000002,
                  index: 17,
                  seriesIndex: 9,
                  display: {
                    y: 11.260000000000002,
                    y0: 220.5030206260961,
                  },
                  series: 9,
                },
                {
                  x: 883612800000,
                  y: 3.2800000000000002,
                  index: 18,
                  seriesIndex: 9,
                  display: {
                    y: 3.2800000000000002,
                    y0: 201.13326841336158,
                  },
                  series: 9,
                },
                {
                  x: 915148800000,
                  y: 4.749999999999999,
                  index: 19,
                  seriesIndex: 9,
                  display: {
                    y: 4.749999999999999,
                    y0: 213.64108391063536,
                  },
                  series: 9,
                },
                {
                  x: 946684800000,
                  y: 4.679999999999999,
                  index: 20,
                  seriesIndex: 9,
                  display: {
                    y: 4.679999999999999,
                    y0: 259.786386301983,
                  },
                  series: 9,
                },
                {
                  x: 978307200000,
                  y: 5.51,
                  index: 21,
                  seriesIndex: 9,
                  display: {
                    y: 5.51,
                    y0: 210.67659853838435,
                  },
                  series: 9,
                },
                {
                  x: 1009843200000,
                  y: 8.599999999999996,
                  index: 22,
                  seriesIndex: 9,
                  display: {
                    y: 8.599999999999996,
                    y0: 176.8195712072759,
                  },
                  series: 9,
                },
                {
                  x: 1041379200000,
                  y: 8.959999999999988,
                  index: 23,
                  seriesIndex: 9,
                  display: {
                    y: 8.959999999999988,
                    y0: 192.74062695689176,
                  },
                  series: 9,
                },
                {
                  x: 1072915200000,
                  y: 10.459999999999992,
                  index: 24,
                  seriesIndex: 9,
                  display: {
                    y: 10.459999999999992,
                    y0: 151.06654906702508,
                  },
                  series: 9,
                },
                {
                  x: 1104537600000,
                  y: 4.469999999999995,
                  index: 25,
                  seriesIndex: 9,
                  display: {
                    y: 4.469999999999995,
                    y0: 68.52716034240856,
                  },
                  series: 9,
                },
                {
                  x: 1136073600000,
                  y: 2.969999999999998,
                  index: 26,
                  seriesIndex: 9,
                  display: {
                    y: 2.969999999999998,
                    y0: 73.58839681177778,
                  },
                  series: 9,
                },
                {
                  x: 1167609600000,
                  y: 9.399999999999984,
                  index: 27,
                  seriesIndex: 9,
                  display: {
                    y: 9.399999999999984,
                    y0: 27.888071512741476,
                  },
                  series: 9,
                },
                {
                  x: 1199145600000,
                  y: 12.669999999999975,
                  index: 28,
                  seriesIndex: 9,
                  display: {
                    y: 12.669999999999975,
                    y0: 0,
                  },
                  series: 9,
                },
                {
                  x: 1230768000000,
                  y: 17.160000000000043,
                  index: 29,
                  seriesIndex: 9,
                  display: {
                    y: 17.160000000000043,
                    y0: 25.506579049902825,
                  },
                  series: 9,
                },
                {
                  x: 1262304000000,
                  y: 24.460000000000004,
                  index: 30,
                  seriesIndex: 9,
                  display: {
                    y: 24.460000000000004,
                    y0: 35.038723275067355,
                  },
                  series: 9,
                },
                {
                  x: 1293840000000,
                  y: 35.250000000000036,
                  index: 31,
                  seriesIndex: 9,
                  display: {
                    y: 35.250000000000036,
                    y0: 120.70173970949426,
                  },
                  series: 9,
                },
                {
                  x: 1325376000000,
                  y: 23.53,
                  index: 32,
                  seriesIndex: 9,
                  display: {
                    y: 23.53,
                    y0: 211.43331147601265,
                  },
                  series: 9,
                },
                {
                  x: 1356998400000,
                  y: 12.829999999999995,
                  index: 33,
                  seriesIndex: 9,
                  display: {
                    y: 12.829999999999995,
                    y0: 239.42434975261475,
                  },
                  series: 9,
                },
                {
                  x: 1388534400000,
                  y: 13.389999999999993,
                  index: 34,
                  seriesIndex: 9,
                  display: {
                    y: 13.389999999999993,
                    y0: 306.0714727314013,
                  },
                  series: 9,
                },
                {
                  x: 1420070400000,
                  y: 8.069999999999997,
                  index: 35,
                  seriesIndex: 9,
                  display: {
                    y: 8.069999999999997,
                    y0: 331.74176221105637,
                  },
                  series: 9,
                },
                {
                  x: 1451606400000,
                  y: 2.5999999999999974,
                  index: 36,
                  seriesIndex: 9,
                  display: {
                    y: 2.5999999999999974,
                    y0: 319.88515851727374,
                  },
                  series: 9,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 9,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 9,
                },
              ],
            },
            {
              key: ['GB'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 10,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 10,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 10,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 10,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 10,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 10,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 10,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 10,
                },
                {
                  x: 567993600000,
                  y: 1.43,
                  index: 8,
                  seriesIndex: 10,
                  display: {
                    y: 1.43,
                    y0: 305.7650172280039,
                  },
                  series: 10,
                },
                {
                  x: 599616000000,
                  y: 64.98,
                  index: 9,
                  seriesIndex: 10,
                  display: {
                    y: 64.98,
                    y0: 272.3260219931503,
                  },
                  series: 10,
                },
                {
                  x: 631152000000,
                  y: 4.890000000000001,
                  index: 10,
                  seriesIndex: 10,
                  display: {
                    y: 4.890000000000001,
                    y0: 315.774808184687,
                  },
                  series: 10,
                },
                {
                  x: 662688000000,
                  y: 5.57,
                  index: 11,
                  seriesIndex: 10,
                  display: {
                    y: 5.57,
                    y0: 323.71638745865533,
                  },
                  series: 10,
                },
                {
                  x: 694224000000,
                  y: 25.48,
                  index: 12,
                  seriesIndex: 10,
                  display: {
                    y: 25.48,
                    y0: 302.57003766873936,
                  },
                  series: 10,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 333.14055311023566,
                  },
                  series: 10,
                },
                {
                  x: 757382400000,
                  y: 12.170000000000002,
                  index: 14,
                  seriesIndex: 10,
                  display: {
                    y: 12.170000000000002,
                    y0: 327.9065547522718,
                  },
                  series: 10,
                },
                {
                  x: 788918400000,
                  y: 3.5999999999999996,
                  index: 15,
                  seriesIndex: 10,
                  display: {
                    y: 3.5999999999999996,
                    y0: 345.8316336309462,
                  },
                  series: 10,
                },
                {
                  x: 820454400000,
                  y: 36.02,
                  index: 16,
                  seriesIndex: 10,
                  display: {
                    y: 36.02,
                    y0: 350.16008078133535,
                  },
                  series: 10,
                },
                {
                  x: 852076800000,
                  y: 6.37,
                  index: 17,
                  seriesIndex: 10,
                  display: {
                    y: 6.37,
                    y0: 374.61302062609593,
                  },
                  series: 10,
                },
                {
                  x: 883612800000,
                  y: 26.9,
                  index: 18,
                  seriesIndex: 10,
                  display: {
                    y: 26.9,
                    y0: 377.8132684133616,
                  },
                  series: 10,
                },
                {
                  x: 915148800000,
                  y: 38.010000000000005,
                  index: 19,
                  seriesIndex: 10,
                  display: {
                    y: 38.010000000000005,
                    y0: 363.05108391063544,
                  },
                  series: 10,
                },
                {
                  x: 946684800000,
                  y: 19.759999999999998,
                  index: 20,
                  seriesIndex: 10,
                  display: {
                    y: 19.759999999999998,
                    y0: 361.7963863019829,
                  },
                  series: 10,
                },
                {
                  x: 978307200000,
                  y: 9.24,
                  index: 21,
                  seriesIndex: 10,
                  display: {
                    y: 9.24,
                    y0: 335.56659853838437,
                  },
                  series: 10,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 10,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 10,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 10,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 10,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 10,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 10,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 10,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 10,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 10,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 10,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 10,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 10,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 10,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 10,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 10,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 10,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 10,
                },
              ],
            },
            {
              key: ['XB'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 11,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 11,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 11,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 11,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 11,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 11,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 11,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 11,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 11,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 11,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 11,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 11,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 11,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 11,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 317.05655475227184,
                  },
                  series: 11,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 297.7616336309462,
                  },
                  series: 11,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 247.66008078133538,
                  },
                  series: 11,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 231.76302062609608,
                  },
                  series: 11,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 204.41326841336158,
                  },
                  series: 11,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 218.39108391063536,
                  },
                  series: 11,
                },
                {
                  x: 946684800000,
                  y: 0.99,
                  index: 20,
                  seriesIndex: 11,
                  display: {
                    y: 0.99,
                    y0: 264.466386301983,
                  },
                  series: 11,
                },
                {
                  x: 978307200000,
                  y: 22.23999999999999,
                  index: 21,
                  seriesIndex: 11,
                  display: {
                    y: 22.23999999999999,
                    y0: 216.18659853838435,
                  },
                  series: 11,
                },
                {
                  x: 1009843200000,
                  y: 48.15000000000006,
                  index: 22,
                  seriesIndex: 11,
                  display: {
                    y: 48.15000000000006,
                    y0: 185.4195712072759,
                  },
                  series: 11,
                },
                {
                  x: 1041379200000,
                  y: 55.16000000000003,
                  index: 23,
                  seriesIndex: 11,
                  display: {
                    y: 55.16000000000003,
                    y0: 201.70062695689174,
                  },
                  series: 11,
                },
                {
                  x: 1072915200000,
                  y: 65.50000000000001,
                  index: 24,
                  seriesIndex: 11,
                  display: {
                    y: 65.50000000000001,
                    y0: 186.11654906702506,
                  },
                  series: 11,
                },
                {
                  x: 1104537600000,
                  y: 49.17000000000011,
                  index: 25,
                  seriesIndex: 11,
                  display: {
                    y: 49.17000000000011,
                    y0: 256.9471603424088,
                  },
                  series: 11,
                },
                {
                  x: 1136073600000,
                  y: 10.149999999999991,
                  index: 26,
                  seriesIndex: 11,
                  display: {
                    y: 10.149999999999991,
                    y0: 305.4383968117778,
                  },
                  series: 11,
                },
                {
                  x: 1167609600000,
                  y: 0.5499999999999999,
                  index: 27,
                  seriesIndex: 11,
                  display: {
                    y: 0.5499999999999999,
                    y0: 329.96807151274163,
                  },
                  series: 11,
                },
                {
                  x: 1199145600000,
                  y: 0.18,
                  index: 28,
                  seriesIndex: 11,
                  display: {
                    y: 0.18,
                    y0: 331.00000000000057,
                  },
                  series: 11,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 11,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 11,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 11,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 11,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 11,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 11,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 11,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 11,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 11,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 11,
                },
              ],
            },
            {
              key: ['NES'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 12,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 12,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 12,
                },
                {
                  x: 410227200000,
                  y: 10.959999999999999,
                  index: 3,
                  seriesIndex: 12,
                  display: {
                    y: 10.959999999999999,
                    y0: 325.1457418579461,
                  },
                  series: 12,
                },
                {
                  x: 441763200000,
                  y: 50.09000000000001,
                  index: 4,
                  seriesIndex: 12,
                  display: {
                    y: 50.09000000000001,
                    y0: 305.6707329222829,
                  },
                  series: 12,
                },
                {
                  x: 473385600000,
                  y: 53.44,
                  index: 5,
                  seriesIndex: 12,
                  display: {
                    y: 53.44,
                    y0: 304.012200293436,
                  },
                  series: 12,
                },
                {
                  x: 504921600000,
                  y: 36.410000000000004,
                  index: 6,
                  seriesIndex: 12,
                  display: {
                    y: 36.410000000000004,
                    y0: 312.37746735575064,
                  },
                  series: 12,
                },
                {
                  x: 536457600000,
                  y: 19.759999999999998,
                  index: 7,
                  seriesIndex: 12,
                  display: {
                    y: 19.759999999999998,
                    y0: 320.00436707976166,
                  },
                  series: 12,
                },
                {
                  x: 567993600000,
                  y: 45.01,
                  index: 8,
                  seriesIndex: 12,
                  display: {
                    y: 45.01,
                    y0: 307.9450172280039,
                  },
                  series: 12,
                },
                {
                  x: 599616000000,
                  y: 7.849999999999999,
                  index: 9,
                  seriesIndex: 12,
                  display: {
                    y: 7.849999999999999,
                    y0: 337.9260219931503,
                  },
                  series: 12,
                },
                {
                  x: 631152000000,
                  y: 15.74,
                  index: 10,
                  seriesIndex: 12,
                  display: {
                    y: 15.74,
                    y0: 320.664808184687,
                  },
                  series: 12,
                },
                {
                  x: 662688000000,
                  y: 6.11,
                  index: 11,
                  seriesIndex: 12,
                  display: {
                    y: 6.11,
                    y0: 329.2863874586553,
                  },
                  series: 12,
                },
                {
                  x: 694224000000,
                  y: 1.9800000000000002,
                  index: 12,
                  seriesIndex: 12,
                  display: {
                    y: 1.9800000000000002,
                    y0: 328.0500376687394,
                  },
                  series: 12,
                },
                {
                  x: 725846400000,
                  y: 3.61,
                  index: 13,
                  seriesIndex: 12,
                  display: {
                    y: 3.61,
                    y0: 333.14055311023566,
                  },
                  series: 12,
                },
                {
                  x: 757382400000,
                  y: 0.11,
                  index: 14,
                  seriesIndex: 12,
                  display: {
                    y: 0.11,
                    y0: 340.0765547522718,
                  },
                  series: 12,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 349.43163363094624,
                  },
                  series: 12,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 386.18008078133533,
                  },
                  series: 12,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 380.98302062609594,
                  },
                  series: 12,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 404.71326841336156,
                  },
                  series: 12,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 401.06108391063543,
                  },
                  series: 12,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 381.5563863019829,
                  },
                  series: 12,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 344.8065985383844,
                  },
                  series: 12,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 12,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 12,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 12,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 12,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 12,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 12,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 12,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 12,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 12,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 12,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 12,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 12,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 12,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 12,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 12,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 12,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 12,
                },
              ],
            },
            {
              key: ['3DS'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 13,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 13,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 13,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 13,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 13,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 13,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 13,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 13,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 13,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 13,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 13,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 13,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 13,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 13,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 13,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 13,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 13,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 13,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 13,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 13,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 461.34638630198293,
                  },
                  series: 13,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 542.1465985383844,
                  },
                  series: 13,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 572.3395712072761,
                  },
                  series: 13,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 550.5906269568918,
                  },
                  series: 13,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 570.376549067025,
                  },
                  series: 13,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 528.467160342409,
                  },
                  series: 13,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 594.6283968117779,
                  },
                  series: 13,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 639.0180715127416,
                  },
                  series: 13,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 678.9000000000007,
                  },
                  series: 13,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 692.8065790499031,
                  },
                  series: 13,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 635.4887232750676,
                  },
                  series: 13,
                },
                {
                  x: 1293840000000,
                  y: 62.53,
                  index: 31,
                  seriesIndex: 13,
                  display: {
                    y: 62.53,
                    y0: 569.0117397094947,
                  },
                  series: 13,
                },
                {
                  x: 1325376000000,
                  y: 51.14000000000004,
                  index: 32,
                  seriesIndex: 13,
                  display: {
                    y: 51.14000000000004,
                    y0: 487.4633114760125,
                  },
                  series: 13,
                },
                {
                  x: 1356998400000,
                  y: 55.88000000000002,
                  index: 33,
                  seriesIndex: 13,
                  display: {
                    y: 55.88000000000002,
                    y0: 473.7643497526147,
                  },
                  series: 13,
                },
                {
                  x: 1388534400000,
                  y: 43.140000000000036,
                  index: 34,
                  seriesIndex: 13,
                  display: {
                    y: 43.140000000000036,
                    y0: 411.54147273140126,
                  },
                  series: 13,
                },
                {
                  x: 1420070400000,
                  y: 26.99,
                  index: 35,
                  seriesIndex: 13,
                  display: {
                    y: 26.99,
                    y0: 372.7517622110564,
                  },
                  series: 13,
                },
                {
                  x: 1451606400000,
                  y: 6.599999999999999,
                  index: 36,
                  seriesIndex: 13,
                  display: {
                    y: 6.599999999999999,
                    y0: 325.9051585172737,
                  },
                  series: 13,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 13,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 13,
                },
              ],
            },
            {
              key: ['N64'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 14,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 14,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 14,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 14,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 14,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 14,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 14,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 14,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 14,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 14,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 14,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 14,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 14,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 14,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 14,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 14,
                },
                {
                  x: 820454400000,
                  y: 34.10999999999999,
                  index: 16,
                  seriesIndex: 14,
                  display: {
                    y: 34.10999999999999,
                    y0: 402.11008078133534,
                  },
                  series: 14,
                },
                {
                  x: 852076800000,
                  y: 39.509999999999984,
                  index: 17,
                  seriesIndex: 14,
                  display: {
                    y: 39.509999999999984,
                    y0: 381.97302062609594,
                  },
                  series: 14,
                },
                {
                  x: 883612800000,
                  y: 49.28000000000002,
                  index: 18,
                  seriesIndex: 14,
                  display: {
                    y: 49.28000000000002,
                    y0: 404.9332684133616,
                  },
                  series: 14,
                },
                {
                  x: 915148800000,
                  y: 57.95999999999997,
                  index: 19,
                  seriesIndex: 14,
                  display: {
                    y: 57.95999999999997,
                    y0: 401.3210839106354,
                  },
                  series: 14,
                },
                {
                  x: 946684800000,
                  y: 34.00999999999999,
                  index: 20,
                  seriesIndex: 14,
                  display: {
                    y: 34.00999999999999,
                    y0: 381.5563863019829,
                  },
                  series: 14,
                },
                {
                  x: 978307200000,
                  y: 3.2600000000000002,
                  index: 21,
                  seriesIndex: 14,
                  display: {
                    y: 3.2600000000000002,
                    y0: 344.8065985383844,
                  },
                  series: 14,
                },
                {
                  x: 1009843200000,
                  y: 0.08,
                  index: 22,
                  seriesIndex: 14,
                  display: {
                    y: 0.08,
                    y0: 314.639571207276,
                  },
                  series: 14,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 14,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 14,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 14,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 14,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 14,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 14,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 14,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 14,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 14,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 14,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 14,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 14,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 14,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 14,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 14,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 14,
                },
              ],
            },
            {
              key: ['SNES'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 15,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 15,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 15,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 15,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 15,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 15,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 15,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 15,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 15,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 15,
                },
                {
                  x: 631152000000,
                  y: 26.16,
                  index: 10,
                  seriesIndex: 15,
                  display: {
                    y: 26.16,
                    y0: 339.004808184687,
                  },
                  series: 15,
                },
                {
                  x: 662688000000,
                  y: 16.21,
                  index: 11,
                  seriesIndex: 15,
                  display: {
                    y: 16.21,
                    y0: 339.7363874586553,
                  },
                  series: 15,
                },
                {
                  x: 694224000000,
                  y: 32.97999999999999,
                  index: 12,
                  seriesIndex: 15,
                  display: {
                    y: 32.97999999999999,
                    y0: 342.73003766873944,
                  },
                  series: 15,
                },
                {
                  x: 725846400000,
                  y: 40.010000000000005,
                  index: 13,
                  seriesIndex: 15,
                  display: {
                    y: 40.010000000000005,
                    y0: 337.40055311023565,
                  },
                  series: 15,
                },
                {
                  x: 757382400000,
                  y: 35.08,
                  index: 14,
                  seriesIndex: 15,
                  display: {
                    y: 35.08,
                    y0: 348.29655475227185,
                  },
                  series: 15,
                },
                {
                  x: 788918400000,
                  y: 32.21000000000001,
                  index: 15,
                  seriesIndex: 15,
                  display: {
                    y: 32.21000000000001,
                    y0: 349.43163363094624,
                  },
                  series: 15,
                },
                {
                  x: 820454400000,
                  y: 15.929999999999996,
                  index: 16,
                  seriesIndex: 15,
                  display: {
                    y: 15.929999999999996,
                    y0: 386.18008078133533,
                  },
                  series: 15,
                },
                {
                  x: 852076800000,
                  y: 0.99,
                  index: 17,
                  seriesIndex: 15,
                  display: {
                    y: 0.99,
                    y0: 380.98302062609594,
                  },
                  series: 15,
                },
                {
                  x: 883612800000,
                  y: 0.22000000000000003,
                  index: 18,
                  seriesIndex: 15,
                  display: {
                    y: 0.22000000000000003,
                    y0: 404.71326841336156,
                  },
                  series: 15,
                },
                {
                  x: 915148800000,
                  y: 0.26,
                  index: 19,
                  seriesIndex: 15,
                  display: {
                    y: 0.26,
                    y0: 401.06108391063543,
                  },
                  series: 15,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 381.5563863019829,
                  },
                  series: 15,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 344.8065985383844,
                  },
                  series: 15,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 15,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 15,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 15,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 15,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 15,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 15,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 15,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 15,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 15,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 15,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 15,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 15,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 15,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 15,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 15,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 15,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 15,
                },
              ],
            },
            {
              key: ['GC'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 16,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 16,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 16,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 16,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 16,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 16,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 16,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 16,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 16,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 16,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 16,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 16,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 16,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 16,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 16,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 16,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 16,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 16,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 16,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 16,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 422.2363863019829,
                  },
                  series: 16,
                },
                {
                  x: 978307200000,
                  y: 26.299999999999997,
                  index: 21,
                  seriesIndex: 16,
                  display: {
                    y: 26.299999999999997,
                    y0: 349.41659853838433,
                  },
                  series: 16,
                },
                {
                  x: 1009843200000,
                  y: 51.93,
                  index: 22,
                  seriesIndex: 16,
                  display: {
                    y: 51.93,
                    y0: 315.009571207276,
                  },
                  series: 16,
                },
                {
                  x: 1041379200000,
                  y: 50.660000000000004,
                  index: 23,
                  seriesIndex: 16,
                  display: {
                    y: 50.660000000000004,
                    y0: 315.64062695689177,
                  },
                  series: 16,
                },
                {
                  x: 1072915200000,
                  y: 28.889999999999983,
                  index: 24,
                  seriesIndex: 16,
                  display: {
                    y: 28.889999999999983,
                    y0: 329.7065490670251,
                  },
                  series: 16,
                },
                {
                  x: 1104537600000,
                  y: 27.799999999999976,
                  index: 25,
                  seriesIndex: 16,
                  display: {
                    y: 27.799999999999976,
                    y0: 340.01716034240894,
                  },
                  series: 16,
                },
                {
                  x: 1136073600000,
                  y: 11.29,
                  index: 26,
                  seriesIndex: 16,
                  display: {
                    y: 11.29,
                    y0: 320.9383968117778,
                  },
                  series: 16,
                },
                {
                  x: 1167609600000,
                  y: 0.27,
                  index: 27,
                  seriesIndex: 16,
                  display: {
                    y: 0.27,
                    y0: 333.96807151274163,
                  },
                  series: 16,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 331.2200000000006,
                  },
                  series: 16,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 16,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 16,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 16,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 16,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 16,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 16,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 16,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 16,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 16,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 16,
                },
              ],
            },
            {
              key: ['XOne'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 17,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 17,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 17,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 17,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 17,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 17,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 17,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 17,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 17,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 17,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 17,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 17,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 17,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 17,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 17,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 17,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 17,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 17,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 17,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 464.9110839106354,
                  },
                  series: 17,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 461.34638630198293,
                  },
                  series: 17,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 542.1465985383844,
                  },
                  series: 17,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 572.3395712072761,
                  },
                  series: 17,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 550.5906269568918,
                  },
                  series: 17,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 570.376549067025,
                  },
                  series: 17,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 528.467160342409,
                  },
                  series: 17,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 594.6283968117779,
                  },
                  series: 17,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 639.0180715127416,
                  },
                  series: 17,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 678.9000000000007,
                  },
                  series: 17,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 692.8065790499031,
                  },
                  series: 17,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 635.4887232750676,
                  },
                  series: 17,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 631.5417397094947,
                  },
                  series: 17,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 538.6033114760125,
                  },
                  series: 17,
                },
                {
                  x: 1356998400000,
                  y: 18.599999999999998,
                  index: 33,
                  seriesIndex: 17,
                  display: {
                    y: 18.599999999999998,
                    y0: 529.6443497526147,
                  },
                  series: 17,
                },
                {
                  x: 1388534400000,
                  y: 52.43,
                  index: 34,
                  seriesIndex: 17,
                  display: {
                    y: 52.43,
                    y0: 454.6814727314013,
                  },
                  series: 17,
                },
                {
                  x: 1420070400000,
                  y: 57.660000000000025,
                  index: 35,
                  seriesIndex: 17,
                  display: {
                    y: 57.660000000000025,
                    y0: 399.7417622110564,
                  },
                  series: 17,
                },
                {
                  x: 1451606400000,
                  y: 12.369999999999987,
                  index: 36,
                  seriesIndex: 17,
                  display: {
                    y: 12.369999999999987,
                    y0: 332.50515851727374,
                  },
                  series: 17,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 17,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 17,
                },
              ],
            },
            {
              key: ['2600'],
              values: [
                {
                  x: 315532800000,
                  y: 11.379999999999999,
                  index: 0,
                  seriesIndex: 18,
                  display: {
                    y: 11.379999999999999,
                    y0: 312.60127789129933,
                  },
                  series: 18,
                },
                {
                  x: 347155200000,
                  y: 35.77000000000001,
                  index: 1,
                  seriesIndex: 18,
                  display: {
                    y: 35.77000000000001,
                    y0: 300.40627789129934,
                  },
                  series: 18,
                },
                {
                  x: 378691200000,
                  y: 28.859999999999996,
                  index: 2,
                  seriesIndex: 18,
                  display: {
                    y: 28.859999999999996,
                    y0: 303.8612778912993,
                  },
                  series: 18,
                },
                {
                  x: 410227200000,
                  y: 5.83,
                  index: 3,
                  seriesIndex: 18,
                  display: {
                    y: 5.83,
                    y0: 319.31574185794614,
                  },
                  series: 18,
                },
                {
                  x: 441763200000,
                  y: 0.27,
                  index: 4,
                  seriesIndex: 18,
                  display: {
                    y: 0.27,
                    y0: 305.40073292228294,
                  },
                  series: 18,
                },
                {
                  x: 473385600000,
                  y: 0.45,
                  index: 5,
                  seriesIndex: 18,
                  display: {
                    y: 0.45,
                    y0: 303.56220029343604,
                  },
                  series: 18,
                },
                {
                  x: 504921600000,
                  y: 0.6599999999999999,
                  index: 6,
                  seriesIndex: 18,
                  display: {
                    y: 0.6599999999999999,
                    y0: 311.7174673557506,
                  },
                  series: 18,
                },
                {
                  x: 536457600000,
                  y: 1.9800000000000002,
                  index: 7,
                  seriesIndex: 18,
                  display: {
                    y: 1.9800000000000002,
                    y0: 318.02436707976165,
                  },
                  series: 18,
                },
                {
                  x: 567993600000,
                  y: 0.75,
                  index: 8,
                  seriesIndex: 18,
                  display: {
                    y: 0.75,
                    y0: 307.1950172280039,
                  },
                  series: 18,
                },
                {
                  x: 599616000000,
                  y: 0.62,
                  index: 9,
                  seriesIndex: 18,
                  display: {
                    y: 0.62,
                    y0: 337.3060219931503,
                  },
                  series: 18,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 320.664808184687,
                  },
                  series: 18,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 329.2863874586553,
                  },
                  series: 18,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 328.0500376687394,
                  },
                  series: 18,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 333.14055311023566,
                  },
                  series: 18,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 340.0765547522718,
                  },
                  series: 18,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 349.43163363094624,
                  },
                  series: 18,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 386.18008078133533,
                  },
                  series: 18,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 380.98302062609594,
                  },
                  series: 18,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 404.71326841336156,
                  },
                  series: 18,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 401.06108391063543,
                  },
                  series: 18,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 381.5563863019829,
                  },
                  series: 18,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 344.8065985383844,
                  },
                  series: 18,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 18,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 18,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 18,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 18,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 18,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 18,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 18,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 18,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 18,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 18,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 18,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 18,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 18,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 18,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 18,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 18,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 18,
                },
              ],
            },
            {
              key: ['WiiU'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 19,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 19,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 19,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 19,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 19,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 303.5122002934361,
                  },
                  series: 19,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 19,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 19,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 305.7350172280039,
                  },
                  series: 19,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 19,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 19,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 19,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 299.5500376687394,
                  },
                  series: 19,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 19,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 304.2065547522718,
                  },
                  series: 19,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 293.5316336309462,
                  },
                  series: 19,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 237.07008078133538,
                  },
                  series: 19,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 220.5030206260961,
                  },
                  series: 19,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 201.13326841336158,
                  },
                  series: 19,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 213.64108391063536,
                  },
                  series: 19,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 259.786386301983,
                  },
                  series: 19,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 210.67659853838435,
                  },
                  series: 19,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 176.8195712072759,
                  },
                  series: 19,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 192.74062695689176,
                  },
                  series: 19,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 151.06654906702508,
                  },
                  series: 19,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 68.52716034240856,
                  },
                  series: 19,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 73.58839681177778,
                  },
                  series: 19,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 27.888071512741476,
                  },
                  series: 19,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 0,
                  },
                  series: 19,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 25.506579049902825,
                  },
                  series: 19,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 35.038723275067355,
                  },
                  series: 19,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 115.55173970949426,
                  },
                  series: 19,
                },
                {
                  x: 1325376000000,
                  y: 17.840000000000003,
                  index: 32,
                  seriesIndex: 19,
                  display: {
                    y: 17.840000000000003,
                    y0: 175.06331147601264,
                  },
                  series: 19,
                },
                {
                  x: 1356998400000,
                  y: 21.84,
                  index: 33,
                  seriesIndex: 19,
                  display: {
                    y: 21.84,
                    y0: 204.89434975261474,
                  },
                  series: 19,
                },
                {
                  x: 1388534400000,
                  y: 22.509999999999994,
                  index: 34,
                  seriesIndex: 19,
                  display: {
                    y: 22.509999999999994,
                    y0: 268.8214727314013,
                  },
                  series: 19,
                },
                {
                  x: 1420070400000,
                  y: 16.380000000000003,
                  index: 35,
                  seriesIndex: 19,
                  display: {
                    y: 16.380000000000003,
                    y0: 308.2617622110564,
                  },
                  series: 19,
                },
                {
                  x: 1451606400000,
                  y: 3.2899999999999996,
                  index: 36,
                  seriesIndex: 19,
                  display: {
                    y: 3.2899999999999996,
                    y0: 313.19515851727374,
                  },
                  series: 19,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 19,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 19,
                },
              ],
            },
            {
              key: ['PSV'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 20,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 20,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 20,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 20,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 20,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 303.5122002934361,
                  },
                  series: 20,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 20,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 20,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 305.7350172280039,
                  },
                  series: 20,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 20,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 20,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 20,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 299.5500376687394,
                  },
                  series: 20,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 20,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 304.2065547522718,
                  },
                  series: 20,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 293.5316336309462,
                  },
                  series: 20,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 237.07008078133538,
                  },
                  series: 20,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 220.5030206260961,
                  },
                  series: 20,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 201.13326841336158,
                  },
                  series: 20,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 213.64108391063536,
                  },
                  series: 20,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 259.786386301983,
                  },
                  series: 20,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 210.67659853838435,
                  },
                  series: 20,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 176.8195712072759,
                  },
                  series: 20,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 192.74062695689176,
                  },
                  series: 20,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 151.06654906702508,
                  },
                  series: 20,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 68.52716034240856,
                  },
                  series: 20,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 73.58839681177778,
                  },
                  series: 20,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 27.888071512741476,
                  },
                  series: 20,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 0,
                  },
                  series: 20,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 25.506579049902825,
                  },
                  series: 20,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 35.038723275067355,
                  },
                  series: 20,
                },
                {
                  x: 1293840000000,
                  y: 5.1499999999999995,
                  index: 31,
                  seriesIndex: 20,
                  display: {
                    y: 5.1499999999999995,
                    y0: 115.55173970949426,
                  },
                  series: 20,
                },
                {
                  x: 1325376000000,
                  y: 18.530000000000005,
                  index: 32,
                  seriesIndex: 20,
                  display: {
                    y: 18.530000000000005,
                    y0: 192.90331147601265,
                  },
                  series: 20,
                },
                {
                  x: 1356998400000,
                  y: 12.690000000000001,
                  index: 33,
                  seriesIndex: 20,
                  display: {
                    y: 12.690000000000001,
                    y0: 226.73434975261475,
                  },
                  series: 20,
                },
                {
                  x: 1388534400000,
                  y: 14.73999999999999,
                  index: 34,
                  seriesIndex: 20,
                  display: {
                    y: 14.73999999999999,
                    y0: 291.3314727314013,
                  },
                  series: 20,
                },
                {
                  x: 1420070400000,
                  y: 7.09999999999999,
                  index: 35,
                  seriesIndex: 20,
                  display: {
                    y: 7.09999999999999,
                    y0: 324.6417622110564,
                  },
                  series: 20,
                },
                {
                  x: 1451606400000,
                  y: 3.399999999999996,
                  index: 36,
                  seriesIndex: 20,
                  display: {
                    y: 3.399999999999996,
                    y0: 316.48515851727376,
                  },
                  series: 20,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 20,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 20,
                },
              ],
            },
            {
              key: ['SAT'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 21,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 21,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 21,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 21,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 21,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 21,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 21,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 21,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 21,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 21,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 21,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 21,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 21,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 21,
                },
                {
                  x: 757382400000,
                  y: 3.6400000000000006,
                  index: 14,
                  seriesIndex: 21,
                  display: {
                    y: 3.6400000000000006,
                    y0: 323.0965547522718,
                  },
                  series: 21,
                },
                {
                  x: 788918400000,
                  y: 11.579999999999998,
                  index: 15,
                  seriesIndex: 21,
                  display: {
                    y: 11.579999999999998,
                    y0: 333.92163363094625,
                  },
                  series: 21,
                },
                {
                  x: 820454400000,
                  y: 7.69,
                  index: 16,
                  seriesIndex: 21,
                  display: {
                    y: 7.69,
                    y0: 342.37008078133533,
                  },
                  series: 21,
                },
                {
                  x: 852076800000,
                  y: 6.7700000000000005,
                  index: 17,
                  seriesIndex: 21,
                  display: {
                    y: 6.7700000000000005,
                    y0: 367.84302062609595,
                  },
                  series: 21,
                },
                {
                  x: 883612800000,
                  y: 3.819999999999999,
                  index: 18,
                  seriesIndex: 21,
                  display: {
                    y: 3.819999999999999,
                    y0: 373.9932684133616,
                  },
                  series: 21,
                },
                {
                  x: 915148800000,
                  y: 0.09,
                  index: 19,
                  seriesIndex: 21,
                  display: {
                    y: 0.09,
                    y0: 362.96108391063547,
                  },
                  series: 21,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 21,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 21,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 21,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 21,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 21,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 21,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 21,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 21,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 21,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 21,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 21,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 21,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 21,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 21,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 21,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 21,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 21,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 21,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 21,
                },
              ],
            },
            {
              key: ['GEN'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 22,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 22,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 22,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 22,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 22,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 22,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 22,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 22,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 22,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 22,
                },
                {
                  x: 631152000000,
                  y: 2.6,
                  index: 10,
                  seriesIndex: 22,
                  display: {
                    y: 2.6,
                    y0: 336.404808184687,
                  },
                  series: 22,
                },
                {
                  x: 662688000000,
                  y: 4.34,
                  index: 11,
                  seriesIndex: 22,
                  display: {
                    y: 4.34,
                    y0: 335.39638745865534,
                  },
                  series: 22,
                },
                {
                  x: 694224000000,
                  y: 12.66,
                  index: 12,
                  seriesIndex: 22,
                  display: {
                    y: 12.66,
                    y0: 330.0300376687394,
                  },
                  series: 22,
                },
                {
                  x: 725846400000,
                  y: 0.6500000000000001,
                  index: 13,
                  seriesIndex: 22,
                  display: {
                    y: 0.6500000000000001,
                    y0: 336.75055311023567,
                  },
                  series: 22,
                },
                {
                  x: 757382400000,
                  y: 8.109999999999998,
                  index: 14,
                  seriesIndex: 22,
                  display: {
                    y: 8.109999999999998,
                    y0: 340.18655475227183,
                  },
                  series: 22,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 349.43163363094624,
                  },
                  series: 22,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 386.18008078133533,
                  },
                  series: 22,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 380.98302062609594,
                  },
                  series: 22,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 404.71326841336156,
                  },
                  series: 22,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 401.06108391063543,
                  },
                  series: 22,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 381.5563863019829,
                  },
                  series: 22,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 344.8065985383844,
                  },
                  series: 22,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 22,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 22,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 22,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 22,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 22,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 22,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 22,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 22,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 22,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 22,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 22,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 22,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 22,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 22,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 22,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 22,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 22,
                },
              ],
            },
            {
              key: ['DC'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 23,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 23,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 23,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 23,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 23,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 23,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 23,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 23,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 23,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 23,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 23,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 23,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 23,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 23,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 23,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 23,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 23,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 23,
                },
                {
                  x: 883612800000,
                  y: 3.39,
                  index: 18,
                  seriesIndex: 23,
                  display: {
                    y: 3.39,
                    y0: 454.2132684133616,
                  },
                  series: 23,
                },
                {
                  x: 915148800000,
                  y: 5.169999999999999,
                  index: 19,
                  seriesIndex: 23,
                  display: {
                    y: 5.169999999999999,
                    y0: 459.2810839106354,
                  },
                  series: 23,
                },
                {
                  x: 946684800000,
                  y: 5.989999999999998,
                  index: 20,
                  seriesIndex: 23,
                  display: {
                    y: 5.989999999999998,
                    y0: 415.5663863019829,
                  },
                  series: 23,
                },
                {
                  x: 978307200000,
                  y: 1.07,
                  index: 21,
                  seriesIndex: 23,
                  display: {
                    y: 1.07,
                    y0: 348.06659853838437,
                  },
                  series: 23,
                },
                {
                  x: 1009843200000,
                  y: 0.29,
                  index: 22,
                  seriesIndex: 23,
                  display: {
                    y: 0.29,
                    y0: 314.719571207276,
                  },
                  series: 23,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 23,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 23,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 23,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 23,
                },
                {
                  x: 1167609600000,
                  y: 0.02,
                  index: 27,
                  seriesIndex: 23,
                  display: {
                    y: 0.02,
                    y0: 333.94807151274165,
                  },
                  series: 23,
                },
                {
                  x: 1199145600000,
                  y: 0.04,
                  index: 28,
                  seriesIndex: 23,
                  display: {
                    y: 0.04,
                    y0: 331.1800000000006,
                  },
                  series: 23,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 23,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 23,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 23,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 23,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 23,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 23,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 23,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 23,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 23,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 23,
                },
              ],
            },
            {
              key: ['SCD'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 24,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 24,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 24,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 24,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 24,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 24,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 24,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 24,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 24,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 24,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 24,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 24,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 24,
                },
                {
                  x: 725846400000,
                  y: 1.5,
                  index: 13,
                  seriesIndex: 24,
                  display: {
                    y: 1.5,
                    y0: 331.64055311023566,
                  },
                  series: 24,
                },
                {
                  x: 757382400000,
                  y: 0.37,
                  index: 14,
                  seriesIndex: 24,
                  display: {
                    y: 0.37,
                    y0: 327.5365547522718,
                  },
                  series: 24,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 345.8316336309462,
                  },
                  series: 24,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 350.16008078133535,
                  },
                  series: 24,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 374.61302062609593,
                  },
                  series: 24,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 377.8132684133616,
                  },
                  series: 24,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 363.05108391063544,
                  },
                  series: 24,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 24,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 24,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 24,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 24,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 24,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 24,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 24,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 24,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 24,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 24,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 24,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 24,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 24,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 24,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 24,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 24,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 24,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 24,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 24,
                },
              ],
            },
            {
              key: ['NG'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 25,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 25,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 25,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 25,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 25,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 25,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 25,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 25,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 25,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 25,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 25,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 25,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 25,
                },
                {
                  x: 725846400000,
                  y: 0.21000000000000002,
                  index: 13,
                  seriesIndex: 25,
                  display: {
                    y: 0.21000000000000002,
                    y0: 331.4305531102357,
                  },
                  series: 25,
                },
                {
                  x: 757382400000,
                  y: 0.7999999999999999,
                  index: 14,
                  seriesIndex: 25,
                  display: {
                    y: 0.7999999999999999,
                    y0: 326.7365547522718,
                  },
                  series: 25,
                },
                {
                  x: 788918400000,
                  y: 0.33000000000000007,
                  index: 15,
                  seriesIndex: 25,
                  display: {
                    y: 0.33000000000000007,
                    y0: 345.50163363094623,
                  },
                  series: 25,
                },
                {
                  x: 820454400000,
                  y: 0.1,
                  index: 16,
                  seriesIndex: 25,
                  display: {
                    y: 0.1,
                    y0: 350.06008078133533,
                  },
                  series: 25,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 374.61302062609593,
                  },
                  series: 25,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 377.8132684133616,
                  },
                  series: 25,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 363.05108391063544,
                  },
                  series: 25,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 25,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 25,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 25,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 25,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 25,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 25,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 25,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 25,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 25,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 25,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 25,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 25,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 25,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 25,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 25,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 25,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 25,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 25,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 25,
                },
              ],
            },
            {
              key: ['WS'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 26,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 26,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 26,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 26,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 26,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 26,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 26,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 26,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 26,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 26,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 365.16480818468705,
                  },
                  series: 26,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 355.9463874586553,
                  },
                  series: 26,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 375.71003766873946,
                  },
                  series: 26,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 377.41055311023564,
                  },
                  series: 26,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 383.37655475227183,
                  },
                  series: 26,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 381.6416336309462,
                  },
                  series: 26,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 436.22008078133535,
                  },
                  series: 26,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 421.48302062609594,
                  },
                  series: 26,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 457.6032684133616,
                  },
                  series: 26,
                },
                {
                  x: 915148800000,
                  y: 0.46,
                  index: 19,
                  seriesIndex: 26,
                  display: {
                    y: 0.46,
                    y0: 464.4510839106354,
                  },
                  series: 26,
                },
                {
                  x: 946684800000,
                  y: 0.68,
                  index: 20,
                  seriesIndex: 26,
                  display: {
                    y: 0.68,
                    y0: 421.5563863019829,
                  },
                  series: 26,
                },
                {
                  x: 978307200000,
                  y: 0.28,
                  index: 21,
                  seriesIndex: 26,
                  display: {
                    y: 0.28,
                    y0: 349.13659853838436,
                  },
                  series: 26,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 315.009571207276,
                  },
                  series: 26,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 26,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 26,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 26,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 26,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 333.96807151274163,
                  },
                  series: 26,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 331.2200000000006,
                  },
                  series: 26,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 26,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 26,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 26,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 26,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 26,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 26,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 26,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 26,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 26,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 26,
                },
              ],
            },
            {
              key: ['TG16'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 27,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 27,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 27,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 27,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 27,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 27,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 27,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 27,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 27,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 27,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 27,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 27,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 27,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 27,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 323.0965547522718,
                  },
                  series: 27,
                },
                {
                  x: 788918400000,
                  y: 0.16,
                  index: 15,
                  seriesIndex: 27,
                  display: {
                    y: 0.16,
                    y0: 333.7616336309462,
                  },
                  series: 27,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 342.37008078133533,
                  },
                  series: 27,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 367.84302062609595,
                  },
                  series: 27,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 373.9932684133616,
                  },
                  series: 27,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 362.96108391063547,
                  },
                  series: 27,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 27,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 27,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 27,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 27,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 27,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 27,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 27,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 27,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 27,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 27,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 27,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 27,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 27,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 27,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 27,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 27,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 27,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 27,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 27,
                },
              ],
            },
            {
              key: ['3DO'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 28,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 28,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 28,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 28,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 28,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 28,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 28,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 28,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 28,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 28,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 28,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 28,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 28,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 28,
                },
                {
                  x: 757382400000,
                  y: 0.02,
                  index: 14,
                  seriesIndex: 28,
                  display: {
                    y: 0.02,
                    y0: 323.0765547522718,
                  },
                  series: 28,
                },
                {
                  x: 788918400000,
                  y: 0.08,
                  index: 15,
                  seriesIndex: 28,
                  display: {
                    y: 0.08,
                    y0: 333.68163363094624,
                  },
                  series: 28,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 342.37008078133533,
                  },
                  series: 28,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 367.84302062609595,
                  },
                  series: 28,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 373.9932684133616,
                  },
                  series: 28,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 362.96108391063547,
                  },
                  series: 28,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 28,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 28,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 28,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 28,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 28,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 28,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 28,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 28,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 28,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 28,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 28,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 28,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 28,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 28,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 28,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 28,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 28,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 28,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 28,
                },
              ],
            },
            {
              key: ['GG'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 323.9812778912993,
                  },
                  series: 29,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 336.1762778912994,
                  },
                  series: 29,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 332.72127789129934,
                  },
                  series: 29,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 336.1057418579461,
                  },
                  series: 29,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 355.76073292228295,
                  },
                  series: 29,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 357.452200293436,
                  },
                  series: 29,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 348.78746735575066,
                  },
                  series: 29,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 339.76436707976166,
                  },
                  series: 29,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 352.9550172280039,
                  },
                  series: 29,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 345.7760219931503,
                  },
                  series: 29,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 339.004808184687,
                  },
                  series: 29,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 339.7363874586553,
                  },
                  series: 29,
                },
                {
                  x: 694224000000,
                  y: 0.04,
                  index: 12,
                  seriesIndex: 29,
                  display: {
                    y: 0.04,
                    y0: 342.6900376687394,
                  },
                  series: 29,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 337.40055311023565,
                  },
                  series: 29,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 348.29655475227185,
                  },
                  series: 29,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 349.43163363094624,
                  },
                  series: 29,
                },
                {
                  x: 820454400000,
                  y: 0,
                  index: 16,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 386.18008078133533,
                  },
                  series: 29,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 380.98302062609594,
                  },
                  series: 29,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 404.71326841336156,
                  },
                  series: 29,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 401.06108391063543,
                  },
                  series: 29,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 381.5563863019829,
                  },
                  series: 29,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 344.8065985383844,
                  },
                  series: 29,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 29,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 29,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 29,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 29,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 29,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 29,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 29,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 29,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 29,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 29,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 29,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 29,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 29,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 29,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 29,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 29,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 29,
                },
              ],
            },
            {
              key: ['PCFX'],
              values: [
                {
                  x: 315532800000,
                  y: 0,
                  index: 0,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 312.60127789129933,
                  },
                  series: 30,
                },
                {
                  x: 347155200000,
                  y: 0,
                  index: 1,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 300.40627789129934,
                  },
                  series: 30,
                },
                {
                  x: 378691200000,
                  y: 0,
                  index: 2,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 303.8612778912993,
                  },
                  series: 30,
                },
                {
                  x: 410227200000,
                  y: 0,
                  index: 3,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 319.31574185794614,
                  },
                  series: 30,
                },
                {
                  x: 441763200000,
                  y: 0,
                  index: 4,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 305.40073292228294,
                  },
                  series: 30,
                },
                {
                  x: 473385600000,
                  y: 0,
                  index: 5,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 303.56220029343604,
                  },
                  series: 30,
                },
                {
                  x: 504921600000,
                  y: 0,
                  index: 6,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 311.7174673557506,
                  },
                  series: 30,
                },
                {
                  x: 536457600000,
                  y: 0,
                  index: 7,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 318.02436707976165,
                  },
                  series: 30,
                },
                {
                  x: 567993600000,
                  y: 0,
                  index: 8,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 305.7650172280039,
                  },
                  series: 30,
                },
                {
                  x: 599616000000,
                  y: 0,
                  index: 9,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 272.3260219931503,
                  },
                  series: 30,
                },
                {
                  x: 631152000000,
                  y: 0,
                  index: 10,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 315.774808184687,
                  },
                  series: 30,
                },
                {
                  x: 662688000000,
                  y: 0,
                  index: 11,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 323.71638745865533,
                  },
                  series: 30,
                },
                {
                  x: 694224000000,
                  y: 0,
                  index: 12,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 302.57003766873936,
                  },
                  series: 30,
                },
                {
                  x: 725846400000,
                  y: 0,
                  index: 13,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 331.4305531102357,
                  },
                  series: 30,
                },
                {
                  x: 757382400000,
                  y: 0,
                  index: 14,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 323.0765547522718,
                  },
                  series: 30,
                },
                {
                  x: 788918400000,
                  y: 0,
                  index: 15,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 333.68163363094624,
                  },
                  series: 30,
                },
                {
                  x: 820454400000,
                  y: 0.03,
                  index: 16,
                  seriesIndex: 30,
                  display: {
                    y: 0.03,
                    y0: 342.34008078133536,
                  },
                  series: 30,
                },
                {
                  x: 852076800000,
                  y: 0,
                  index: 17,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 367.84302062609595,
                  },
                  series: 30,
                },
                {
                  x: 883612800000,
                  y: 0,
                  index: 18,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 373.9932684133616,
                  },
                  series: 30,
                },
                {
                  x: 915148800000,
                  y: 0,
                  index: 19,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 362.96108391063547,
                  },
                  series: 30,
                },
                {
                  x: 946684800000,
                  y: 0,
                  index: 20,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 361.7963863019829,
                  },
                  series: 30,
                },
                {
                  x: 978307200000,
                  y: 0,
                  index: 21,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 335.56659853838437,
                  },
                  series: 30,
                },
                {
                  x: 1009843200000,
                  y: 0,
                  index: 22,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 314.639571207276,
                  },
                  series: 30,
                },
                {
                  x: 1041379200000,
                  y: 0,
                  index: 23,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 315.64062695689177,
                  },
                  series: 30,
                },
                {
                  x: 1072915200000,
                  y: 0,
                  index: 24,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 329.7065490670251,
                  },
                  series: 30,
                },
                {
                  x: 1104537600000,
                  y: 0,
                  index: 25,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 340.01716034240894,
                  },
                  series: 30,
                },
                {
                  x: 1136073600000,
                  y: 0,
                  index: 26,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 320.9383968117778,
                  },
                  series: 30,
                },
                {
                  x: 1167609600000,
                  y: 0,
                  index: 27,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 333.94807151274165,
                  },
                  series: 30,
                },
                {
                  x: 1199145600000,
                  y: 0,
                  index: 28,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 331.1800000000006,
                  },
                  series: 30,
                },
                {
                  x: 1230768000000,
                  y: 0,
                  index: 29,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 323.57657904990293,
                  },
                  series: 30,
                },
                {
                  x: 1262304000000,
                  y: 0,
                  index: 30,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 353.63872327506743,
                  },
                  series: 30,
                },
                {
                  x: 1293840000000,
                  y: 0,
                  index: 31,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 346.7617397094945,
                  },
                  series: 30,
                },
                {
                  x: 1325376000000,
                  y: 0,
                  index: 32,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 355.2033114760125,
                  },
                  series: 30,
                },
                {
                  x: 1356998400000,
                  y: 0,
                  index: 33,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 347.01434975261475,
                  },
                  series: 30,
                },
                {
                  x: 1388534400000,
                  y: 0,
                  index: 34,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 356.1414727314012,
                  },
                  series: 30,
                },
                {
                  x: 1420070400000,
                  y: 0,
                  index: 35,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 352.9817622110564,
                  },
                  series: 30,
                },
                {
                  x: 1451606400000,
                  y: 0,
                  index: 36,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 323.31515851727374,
                  },
                  series: 30,
                },
                {
                  x: 1483228800000,
                  y: 0,
                  index: 37,
                  seriesIndex: 30,
                  display: {
                    y: 0,
                    y0: 293.5851585172737,
                  },
                  series: 30,
                },
              ],
            },
          ],
          applied_filters: [],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'area',
        slice_id: 103,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'year',
        time_grain_sqla: null,
        time_range: 'No filter',
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'global_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 887,
              is_dttm: false,
              optionName: '_col_Global_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: false,
            isNew: false,
            label: 'SUM(Global_Sales)',
            optionName: 'metric_ufl75addr8c_oqqhdumirpn',
            sqlExpression: null,
          },
        ],
        adhoc_filters: [],
        groupby: ['platform'],
        order_desc: true,
        contribution: false,
        row_limit: null,
        show_brush: 'auto',
        show_legend: false,
        line_interpolation: 'linear',
        stacked_style: 'stream',
        color_scheme: 'supersetColors',
        rich_tooltip: true,
        x_axis_label: 'Year Published',
        bottom_margin: 'auto',
        x_ticks_layout: 'auto',
        x_axis_format: 'smart_date',
        x_axis_showminmax: true,
        y_axis_format: 'SMART_NUMBER',
        y_axis_bounds: [null, null],
        rolling_type: 'None',
        comparison_type: 'values',
        annotation_layers: [],
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          '3DO': '#B2B2B2',
          '3DS': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          DC: '#A38F79',
          DS: '#8FD3E4',
          Europe: '#5AC189',
          Fighting: '#5AC189',
          GB: '#FDE380',
          GBA: '#ACE1C4',
          GC: '#5AC189',
          GEN: '#3CCCCB',
          GG: '#EFA1AA',
          Japan: '#FF7F44',
          'Microsoft Game Studios': '#D1C6BC',
          Misc: '#FF7F44',
          N64: '#1FA8C9',
          NES: '#9EE5E5',
          NG: '#A1A6BD',
          Nintendo: '#D3B3DA',
          'North America': '#666666',
          Other: '#E04355',
          PC: '#EFA1AA',
          PCFX: '#FDE380',
          PS: '#A1A6BD',
          PS2: '#FCC700',
          PS3: '#3CCCCB',
          PS4: '#B2B2B2',
          PSP: '#FEC0A1',
          PSV: '#FCC700',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          SAT: '#A868B7',
          SCD: '#8FD3E4',
          SNES: '#454E7C',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
          TG16: '#FEC0A1',
          'Take-Two Interactive': '#9EE5E5',
          WS: '#ACE1C4',
          Wii: '#A38F79',
          WiiU: '#E04355',
          X360: '#A868B7',
          XB: '#D3B3DA',
          XOne: '#FF7F44',
        },
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '113': {
      id: 113,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673047001005,
      chartUpdateStartTime: 1673046994648,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'dist_bar',
        slice_id: 113,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'na_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 883,
              is_dttm: false,
              optionName: '_col_NA_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'North America',
            optionName: 'metric_a943v7wg5g_0mm03hrsmpf',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'eu_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 884,
              is_dttm: false,
              optionName: '_col_EU_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Europe',
            optionName: 'metric_bibau54x0rb_dwrjtqkbyso',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'jp_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 885,
              is_dttm: false,
              optionName: '_col_JP_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Japan',
            optionName: 'metric_06whpr2oyhw_4l88xxu6zvd',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'other_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 886,
              is_dttm: false,
              optionName: '_col_Other_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Other',
            optionName: 'metric_pcx05ioxums_ibr16zvi74',
            sqlExpression: null,
          },
        ],
        adhoc_filters: [
          {
            clause: 'WHERE',
            comparator: '10',
            expressionType: 'SIMPLE',
            filterOptionName: 'filter_juemdnqji5_d6fm8tuf4rc',
            isExtra: false,
            isNew: false,
            operator: '<=',
            sqlExpression: null,
            subject: 'rank',
          },
        ],
        groupby: ['name'],
        columns: [],
        row_limit: null,
        order_desc: true,
        contribution: true,
        color_scheme: 'supersetColors',
        show_legend: true,
        rich_tooltip: true,
        bar_stacked: true,
        y_axis_format: 'SMART_NUMBER',
        y_axis_bounds: [null, null],
        bottom_margin: 'auto',
        x_ticks_layout: 'staggered',
        queryFields: {
          columns: 'groupby',
          groupby: 'groupby',
          metrics: 'metrics',
        },
        shared_label_colors: {},
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        extra_form_data: {},
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '420a73a7c686ce86838126ba14e5c69a',
          cached_dttm: null,
          cache_timeout: 86400,
          errors: [],
          form_data: {
            datasource: '20__table',
            viz_type: 'dist_bar',
            slice_id: 113,
            url_params: {},
            granularity_sqla: 'year',
            time_range: 'No filter',
            metrics: [
              {
                aggregate: 'SUM',
                column: {
                  column_name: 'na_sales',
                  description: null,
                  expression: null,
                  filterable: true,
                  groupby: true,
                  id: 883,
                  is_dttm: false,
                  optionName: '_col_NA_Sales',
                  python_date_format: null,
                  type: 'DOUBLE PRECISION',
                  verbose_name: null,
                },
                expressionType: 'SIMPLE',
                hasCustomLabel: true,
                isNew: false,
                label: 'North America',
                optionName: 'metric_a943v7wg5g_0mm03hrsmpf',
                sqlExpression: null,
              },
              {
                aggregate: 'SUM',
                column: {
                  column_name: 'eu_sales',
                  description: null,
                  expression: null,
                  filterable: true,
                  groupby: true,
                  id: 884,
                  is_dttm: false,
                  optionName: '_col_EU_Sales',
                  python_date_format: null,
                  type: 'DOUBLE PRECISION',
                  verbose_name: null,
                },
                expressionType: 'SIMPLE',
                hasCustomLabel: true,
                isNew: false,
                label: 'Europe',
                optionName: 'metric_bibau54x0rb_dwrjtqkbyso',
                sqlExpression: null,
              },
              {
                aggregate: 'SUM',
                column: {
                  column_name: 'jp_sales',
                  description: null,
                  expression: null,
                  filterable: true,
                  groupby: true,
                  id: 885,
                  is_dttm: false,
                  optionName: '_col_JP_Sales',
                  python_date_format: null,
                  type: 'DOUBLE PRECISION',
                  verbose_name: null,
                },
                expressionType: 'SIMPLE',
                hasCustomLabel: true,
                isNew: false,
                label: 'Japan',
                optionName: 'metric_06whpr2oyhw_4l88xxu6zvd',
                sqlExpression: null,
              },
              {
                aggregate: 'SUM',
                column: {
                  column_name: 'other_sales',
                  description: null,
                  expression: null,
                  filterable: true,
                  groupby: true,
                  id: 886,
                  is_dttm: false,
                  optionName: '_col_Other_Sales',
                  python_date_format: null,
                  type: 'DOUBLE PRECISION',
                  verbose_name: null,
                },
                expressionType: 'SIMPLE',
                hasCustomLabel: true,
                isNew: false,
                label: 'Other',
                optionName: 'metric_pcx05ioxums_ibr16zvi74',
                sqlExpression: null,
              },
            ],
            adhoc_filters: [
              {
                clause: 'WHERE',
                comparator: '10',
                expressionType: 'SIMPLE',
                filterOptionName: 'filter_juemdnqji5_d6fm8tuf4rc',
                isExtra: false,
                isNew: false,
                operator: '<=',
                sqlExpression: null,
                subject: 'rank',
              },
            ],
            groupby: ['name'],
            columns: [],
            row_limit: null,
            order_desc: true,
            contribution: true,
            color_scheme: 'supersetColors',
            show_legend: true,
            rich_tooltip: true,
            bar_stacked: true,
            y_axis_format: 'SMART_NUMBER',
            y_axis_bounds: [null, null],
            bottom_margin: 'auto',
            x_ticks_layout: 'staggered',
            queryFields: {
              columns: 'groupby',
              groupby: 'groupby',
              metrics: 'metrics',
            },
            shared_label_colors: {},
            dashboardId: 9,
            applied_time_extras: {},
            where: '',
            having: '',
            having_filters: [],
            filters: [
              {
                col: 'rank',
                op: '<=',
                val: '10',
              },
            ],
          },
          is_cached: false,
          query:
            'SELECT name AS name,\n       sum(na_sales) AS "North America",\n       sum(eu_sales) AS "Europe",\n       sum(jp_sales) AS "Japan",\n       sum(other_sales) AS "Other"\nFROM main.video_game_sales\nWHERE rank <= 10\nGROUP BY name\nORDER BY "North America" DESC\nLIMIT 50000\nOFFSET 0',
          from_dttm: null,
          to_dttm: null,
          status: 'success',
          stacktrace: null,
          rowcount: 10,
          colnames: ['name', 'North America', 'Europe', 'Japan', 'Other'],
          coltypes: [1, 0, 0, 0, 0],
          data: [
            {
              key: 'North America',
              values: [
                {
                  x: 'Wii Sports',
                  y: 0.5014503263234228,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.5014503263234228,
                  y1: 0.5014503263234228,
                },
                {
                  x: 'Super Mario Bros.',
                  y: 0.7226640159045725,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.7226640159045725,
                  y1: 0.7226640159045725,
                },
                {
                  x: 'Duck Hunt',
                  y: 0.9512539738608266,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.9512539738608266,
                  y1: 0.9512539738608266,
                },
                {
                  x: 'Tetris',
                  y: 0.7666886979510906,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.7666886979510906,
                  y1: 0.7666886979510906,
                },
                {
                  x: 'Mario Kart Wii',
                  y: 0.44236673178900354,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.44236673178900354,
                  y1: 0.44236673178900354,
                },
                {
                  x: 'Wii Sports Resort',
                  y: 0.4772727272727273,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.4772727272727273,
                  y1: 0.4772727272727273,
                },
                {
                  x: 'New Super Mario Bros. Wii',
                  y: 0.5099615519049283,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.5099615519049283,
                  y1: 0.5099615519049283,
                },
                {
                  x: 'Wii Play',
                  y: 0.4836263357462944,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.4836263357462944,
                  y1: 0.4836263357462944,
                },
                {
                  x: 'New Super Mario Bros.',
                  y: 0.3792069310229924,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.3792069310229924,
                  y1: 0.3792069310229924,
                },
                {
                  x: 'Pokemon Red/Pokemon Blue',
                  y: 0.3591459528362014,
                  y0: 0,
                  series: 0,
                  key: 'North America',
                  size: 0.3591459528362014,
                  y1: 0.3591459528362014,
                },
              ],
            },
            {
              key: 'Europe',
              values: [
                {
                  x: 'Wii Sports',
                  y: 0.3507372492144065,
                  y0: 0.5014503263234228,
                  series: 1,
                  key: 'Europe',
                  size: 0.3507372492144065,
                  y1: 0.8521875755378293,
                },
                {
                  x: 'Super Mario Bros.',
                  y: 0.0889662027833002,
                  y0: 0.7226640159045725,
                  series: 1,
                  key: 'Europe',
                  size: 0.0889662027833002,
                  y1: 0.8116302186878728,
                },
                {
                  x: 'Duck Hunt',
                  y: 0.022253620628753093,
                  y0: 0.9512539738608266,
                  series: 1,
                  key: 'Europe',
                  size: 0.022253620628753093,
                  y1: 0.9735075944895797,
                },
                {
                  x: 'Tetris',
                  y: 0.07468605419695969,
                  y0: 0.7666886979510906,
                  series: 1,
                  key: 'Europe',
                  size: 0.07468605419695969,
                  y1: 0.8413747521480504,
                },
                {
                  x: 'Mario Kart Wii',
                  y: 0.35947530002790956,
                  y0: 0.44236673178900354,
                  series: 1,
                  key: 'Europe',
                  size: 0.35947530002790956,
                  y1: 0.801842031816913,
                },
                {
                  x: 'Wii Sports Resort',
                  y: 0.3336363636363636,
                  y0: 0.4772727272727273,
                  series: 1,
                  key: 'Europe',
                  size: 0.3336363636363636,
                  y1: 0.8109090909090909,
                },
                {
                  x: 'New Super Mario Bros. Wii',
                  y: 0.24676686473261097,
                  y0: 0.5099615519049283,
                  series: 1,
                  key: 'Europe',
                  size: 0.24676686473261097,
                  y1: 0.7567284166375393,
                },
                {
                  x: 'Wii Play',
                  y: 0.31713202344019303,
                  y0: 0.4836263357462944,
                  series: 1,
                  key: 'Europe',
                  size: 0.31713202344019303,
                  y1: 0.8007583591864874,
                },
                {
                  x: 'New Super Mario Bros.',
                  y: 0.30756414528490506,
                  y0: 0.3792069310229924,
                  series: 1,
                  key: 'Europe',
                  size: 0.30756414528490506,
                  y1: 0.6867710763078975,
                },
                {
                  x: 'Pokemon Red/Pokemon Blue',
                  y: 0.28330146590184835,
                  y0: 0.3591459528362014,
                  series: 1,
                  key: 'Europe',
                  size: 0.28330146590184835,
                  y1: 0.6424474187380498,
                },
              ],
            },
            {
              key: 'Japan',
              values: [
                {
                  x: 'Wii Sports',
                  y: 0.04556441866086536,
                  y0: 0.8521875755378293,
                  series: 2,
                  key: 'Japan',
                  size: 0.04556441866086536,
                  y1: 0.8977519941986947,
                },
                {
                  x: 'Super Mario Bros.',
                  y: 0.169234592445328,
                  y0: 0.8116302186878728,
                  series: 2,
                  key: 'Japan',
                  size: 0.169234592445328,
                  y1: 0.9808648111332008,
                },
                {
                  x: 'Duck Hunt',
                  y: 0.009890498057223597,
                  y0: 0.9735075944895797,
                  series: 2,
                  key: 'Japan',
                  size: 0.009890498057223597,
                  y1: 0.9833980925468033,
                },
                {
                  x: 'Tetris',
                  y: 0.1394580304031725,
                  y0: 0.8413747521480504,
                  series: 2,
                  key: 'Japan',
                  size: 0.1394580304031725,
                  y1: 0.9808327825512229,
                },
                {
                  x: 'Mario Kart Wii',
                  y: 0.1057772816075914,
                  y0: 0.801842031816913,
                  series: 2,
                  key: 'Japan',
                  size: 0.1057772816075914,
                  y1: 0.9076193134245044,
                },
                {
                  x: 'Wii Sports Resort',
                  y: 0.09939393939393938,
                  y0: 0.8109090909090909,
                  series: 2,
                  key: 'Japan',
                  size: 0.09939393939393938,
                  y1: 0.9103030303030303,
                },
                {
                  x: 'New Super Mario Bros. Wii',
                  y: 0.16427822439706397,
                  y0: 0.7567284166375393,
                  series: 2,
                  key: 'Japan',
                  size: 0.16427822439706397,
                  y1: 0.9210066410346033,
                },
                {
                  x: 'Wii Play',
                  y: 0.10099965529127888,
                  y0: 0.8007583591864874,
                  series: 2,
                  key: 'Japan',
                  size: 0.10099965529127888,
                  y1: 0.9017580144777663,
                },
                {
                  x: 'New Super Mario Bros.',
                  y: 0.21659446851049652,
                  y0: 0.6867710763078975,
                  series: 2,
                  key: 'Japan',
                  size: 0.21659446851049652,
                  y1: 0.9033655448183939,
                },
                {
                  x: 'Pokemon Red/Pokemon Blue',
                  y: 0.32568514977692803,
                  y0: 0.6424474187380498,
                  series: 2,
                  key: 'Japan',
                  size: 0.32568514977692803,
                  y1: 0.9681325685149778,
                },
              ],
            },
            {
              key: 'Other',
              values: [
                {
                  x: 'Wii Sports',
                  y: 0.10224800580130529,
                  y0: 0.8977519941986947,
                  series: 3,
                  key: 'Other',
                  size: 0.10224800580130529,
                  y1: 1,
                },
                {
                  x: 'Super Mario Bros.',
                  y: 0.019135188866799203,
                  y0: 0.9808648111332008,
                  series: 3,
                  key: 'Other',
                  size: 0.019135188866799203,
                  y1: 1,
                },
                {
                  x: 'Duck Hunt',
                  y: 0.01660190745319675,
                  y0: 0.9833980925468033,
                  series: 3,
                  key: 'Other',
                  size: 0.01660190745319675,
                  y1: 1,
                },
                {
                  x: 'Tetris',
                  y: 0.019167217448777262,
                  y0: 0.9808327825512229,
                  series: 3,
                  key: 'Other',
                  size: 0.019167217448777262,
                  y1: 1.0000000000000002,
                },
                {
                  x: 'Mario Kart Wii',
                  y: 0.09238068657549538,
                  y0: 0.9076193134245044,
                  series: 3,
                  key: 'Other',
                  size: 0.09238068657549538,
                  y1: 0.9999999999999998,
                },
                {
                  x: 'Wii Sports Resort',
                  y: 0.08969696969696969,
                  y0: 0.9103030303030303,
                  series: 3,
                  key: 'Other',
                  size: 0.08969696969696969,
                  y1: 1,
                },
                {
                  x: 'New Super Mario Bros. Wii',
                  y: 0.0789933589653967,
                  y0: 0.9210066410346033,
                  series: 3,
                  key: 'Other',
                  size: 0.0789933589653967,
                  y1: 1,
                },
                {
                  x: 'Wii Play',
                  y: 0.09824198552223372,
                  y0: 0.9017580144777663,
                  series: 3,
                  key: 'Other',
                  size: 0.09824198552223372,
                  y1: 1,
                },
                {
                  x: 'New Super Mario Bros.',
                  y: 0.09663445518160614,
                  y0: 0.9033655448183939,
                  series: 3,
                  key: 'Other',
                  size: 0.09663445518160614,
                  y1: 1,
                },
                {
                  x: 'Pokemon Red/Pokemon Blue',
                  y: 0.03186743148502231,
                  y0: 0.9681325685149778,
                  series: 3,
                  key: 'Other',
                  size: 0.03186743148502231,
                  y1: 1,
                },
              ],
            },
          ],
          applied_filters: [
            {
              column: 'rank',
            },
          ],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'dist_bar',
        slice_id: 113,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'na_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 883,
              is_dttm: false,
              optionName: '_col_NA_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'North America',
            optionName: 'metric_a943v7wg5g_0mm03hrsmpf',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'eu_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 884,
              is_dttm: false,
              optionName: '_col_EU_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Europe',
            optionName: 'metric_bibau54x0rb_dwrjtqkbyso',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'jp_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 885,
              is_dttm: false,
              optionName: '_col_JP_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Japan',
            optionName: 'metric_06whpr2oyhw_4l88xxu6zvd',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'other_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 886,
              is_dttm: false,
              optionName: '_col_Other_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Other',
            optionName: 'metric_pcx05ioxums_ibr16zvi74',
            sqlExpression: null,
          },
        ],
        adhoc_filters: [
          {
            clause: 'WHERE',
            comparator: '10',
            expressionType: 'SIMPLE',
            filterOptionName: 'filter_juemdnqji5_d6fm8tuf4rc',
            isExtra: false,
            isNew: false,
            operator: '<=',
            sqlExpression: null,
            subject: 'rank',
          },
        ],
        groupby: ['name'],
        columns: [],
        row_limit: null,
        order_desc: true,
        contribution: true,
        color_scheme: 'supersetColors',
        show_legend: true,
        rich_tooltip: true,
        bar_stacked: true,
        y_axis_format: 'SMART_NUMBER',
        y_axis_bounds: [null, null],
        bottom_margin: 'auto',
        x_ticks_layout: 'staggered',
        label_colors: {},
        queryFields: {
          columns: 'groupby',
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '120': {
      id: 120,
      chartAlert: null,
      chartStatus: 'loading',
      chartStackTrace: null,
      chartUpdateEndTime: null,
      chartUpdateStartTime: 0,
      latestQueryFormData: {},
      sliceFormData: null,
      queryController: null,
      queriesResponse: null,
      triggerQuery: true,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'dist_bar',
        slice_id: 120,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'na_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 883,
              is_dttm: false,
              optionName: '_col_NA_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'North America',
            optionName: 'metric_3pl6jwmyd72_p9o4j2xxgyp',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'eu_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 884,
              is_dttm: false,
              optionName: '_col_EU_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Europe',
            optionName: 'metric_e8rdyfxxjdu_6dgyhf7xcne',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'jp_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 885,
              is_dttm: false,
              optionName: '_col_JP_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Japan',
            optionName: 'metric_6gesefugzy6_517l3wowdwu',
            sqlExpression: null,
          },
          {
            aggregate: 'SUM',
            column: {
              column_name: 'other_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 886,
              is_dttm: false,
              optionName: '_col_Other_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: true,
            isNew: false,
            label: 'Other',
            optionName: 'metric_cf6kbre28f_2sg5b5pfq5a',
            sqlExpression: null,
          },
        ],
        adhoc_filters: [],
        groupby: ['genre'],
        columns: [],
        row_limit: null,
        order_desc: true,
        contribution: false,
        color_scheme: 'supersetColors',
        show_legend: true,
        show_bar_value: false,
        rich_tooltip: true,
        bar_stacked: true,
        order_bars: false,
        y_axis_format: 'SMART_NUMBER',
        show_controls: true,
        y_axis_bounds: [null, null],
        x_axis_label: 'Genre',
        bottom_margin: 'auto',
        x_ticks_layout: 'flat',
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          '3DO': '#B2B2B2',
          '3DS': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          DC: '#A38F79',
          DS: '#8FD3E4',
          Europe: '#5AC189',
          Fighting: '#5AC189',
          GB: '#FDE380',
          GBA: '#ACE1C4',
          GC: '#5AC189',
          GEN: '#3CCCCB',
          GG: '#EFA1AA',
          Japan: '#FF7F44',
          'Microsoft Game Studios': '#D1C6BC',
          Misc: '#FF7F44',
          N64: '#1FA8C9',
          NES: '#9EE5E5',
          NG: '#A1A6BD',
          Nintendo: '#D3B3DA',
          'North America': '#666666',
          Other: '#E04355',
          PC: '#EFA1AA',
          PCFX: '#FDE380',
          PS: '#A1A6BD',
          PS2: '#FCC700',
          PS3: '#3CCCCB',
          PS4: '#B2B2B2',
          PSP: '#FEC0A1',
          PSV: '#FCC700',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          SAT: '#A868B7',
          SCD: '#8FD3E4',
          SNES: '#454E7C',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
          TG16: '#FEC0A1',
          'Take-Two Interactive': '#9EE5E5',
          WS: '#ACE1C4',
          Wii: '#A38F79',
          WiiU: '#E04355',
          X360: '#A868B7',
          XB: '#D3B3DA',
          XOne: '#FF7F44',
        },
        queryFields: {
          columns: 'groupby',
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '123': {
      id: 123,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673046998143,
      chartUpdateStartTime: 1673046994604,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'pie',
        slice_id: 123,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        groupby: ['publisher'],
        metric: {
          aggregate: 'SUM',
          column: {
            column_name: 'global_sales',
            description: null,
            expression: null,
            filterable: true,
            groupby: true,
            id: 887,
            is_dttm: false,
            optionName: '_col_Global_Sales',
            python_date_format: null,
            type: 'DOUBLE PRECISION',
            verbose_name: null,
          },
          expressionType: 'SIMPLE',
          hasCustomLabel: false,
          isNew: false,
          label: 'SUM(Global_Sales)',
          optionName: 'metric_k2rqz0zqhkf_49hu4kq9h3u',
          sqlExpression: null,
        },
        adhoc_filters: [
          {
            clause: 'WHERE',
            comparator: '25',
            expressionType: 'SIMPLE',
            filterOptionName: 'filter_znxs4o61aod_n5blgxo29r',
            isExtra: false,
            isNew: false,
            operator: '<=',
            sqlExpression: null,
            subject: 'rank',
          },
        ],
        row_limit: null,
        sort_by_metric: true,
        color_scheme: 'supersetColors',
        show_labels_threshold: 5,
        show_legend: false,
        legendType: 'scroll',
        legendOrientation: 'top',
        label_type: 'key',
        number_format: 'SMART_NUMBER',
        date_format: 'smart_date',
        show_labels: true,
        labels_outside: true,
        label_line: true,
        outerRadius: 67,
        donut: true,
        innerRadius: 45,
        queryFields: {
          groupby: 'groupby',
          metric: 'metrics',
        },
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          Europe: '#5AC189',
          Japan: '#FF7F44',
          'North America': '#666666',
          Other: '#E04355',
          PS2: '#FCC700',
          X360: '#A868B7',
          PS3: '#3CCCCB',
          Wii: '#A38F79',
          DS: '#8FD3E4',
          PS: '#A1A6BD',
          GBA: '#ACE1C4',
          PSP: '#FEC0A1',
          PS4: '#B2B2B2',
          PC: '#EFA1AA',
          GB: '#FDE380',
          XB: '#D3B3DA',
          NES: '#9EE5E5',
          '3DS': '#D1C6BC',
          N64: '#1FA8C9',
          SNES: '#454E7C',
          GC: '#5AC189',
          XOne: '#FF7F44',
          WiiU: '#E04355',
          PSV: '#FCC700',
          SAT: '#A868B7',
          GEN: '#3CCCCB',
          DC: '#A38F79',
          SCD: '#8FD3E4',
          NG: '#A1A6BD',
          WS: '#ACE1C4',
          TG16: '#FEC0A1',
          '3DO': '#B2B2B2',
          GG: '#EFA1AA',
          PCFX: '#FDE380',
          Nintendo: '#D3B3DA',
          'Take-Two Interactive': '#9EE5E5',
          'Microsoft Game Studios': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          Fighting: '#5AC189',
          Misc: '#FF7F44',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
        },
        shared_label_colors: {},
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        extra_form_data: {},
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '18929e0056e248f9ae6e413e91a3e0ef',
          cached_dttm: null,
          cache_timeout: 86400,
          applied_template_filters: [],
          annotation_data: {},
          error: null,
          is_cached: null,
          query:
            'SELECT publisher AS publisher,\n       sum(global_sales) AS "SUM(Global_Sales)"\nFROM main.video_game_sales\nWHERE rank <= 25\nGROUP BY publisher\nORDER BY "SUM(Global_Sales)" DESC\nLIMIT 50000\nOFFSET 0;\n\n',
          status: 'success',
          stacktrace: null,
          rowcount: 3,
          from_dttm: null,
          to_dttm: null,
          label_map: {
            publisher: ['publisher'],
            'SUM(Global_Sales)': ['SUM(Global_Sales)'],
          },
          colnames: ['publisher', 'SUM(Global_Sales)'],
          indexnames: [0, 1, 2],
          coltypes: [1, 0],
          data: [
            {
              publisher: 'Nintendo',
              'SUM(Global_Sales)': 580,
            },
            {
              publisher: 'Take-Two Interactive',
              'SUM(Global_Sales)': 74.73999999999998,
            },
            {
              publisher: 'Microsoft Game Studios',
              'SUM(Global_Sales)': 21.82,
            },
          ],
          result_format: 'json',
          applied_filters: [
            {
              column: 'rank',
            },
            {
              column: '__time_range',
            },
          ],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'pie',
        slice_id: 123,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        groupby: ['publisher'],
        metric: {
          aggregate: 'SUM',
          column: {
            column_name: 'global_sales',
            description: null,
            expression: null,
            filterable: true,
            groupby: true,
            id: 887,
            is_dttm: false,
            optionName: '_col_Global_Sales',
            python_date_format: null,
            type: 'DOUBLE PRECISION',
            verbose_name: null,
          },
          expressionType: 'SIMPLE',
          hasCustomLabel: false,
          isNew: false,
          label: 'SUM(Global_Sales)',
          optionName: 'metric_k2rqz0zqhkf_49hu4kq9h3u',
          sqlExpression: null,
        },
        adhoc_filters: [
          {
            clause: 'WHERE',
            comparator: '25',
            expressionType: 'SIMPLE',
            filterOptionName: 'filter_znxs4o61aod_n5blgxo29r',
            isExtra: false,
            isNew: false,
            operator: '<=',
            sqlExpression: null,
            subject: 'rank',
          },
        ],
        row_limit: null,
        sort_by_metric: true,
        color_scheme: 'supersetColors',
        show_labels_threshold: 5,
        show_legend: false,
        legendType: 'scroll',
        legendOrientation: 'top',
        label_type: 'key',
        number_format: 'SMART_NUMBER',
        date_format: 'smart_date',
        show_labels: true,
        labels_outside: true,
        label_line: true,
        outerRadius: 67,
        donut: true,
        innerRadius: 45,
        queryFields: {
          groupby: 'groupby',
          metric: 'metrics',
        },
      },
    },
    '125': {
      id: 125,
      chartAlert: null,
      chartStatus: 'rendered',
      chartStackTrace: null,
      chartUpdateEndTime: 1673046997626,
      chartUpdateStartTime: 1673046994618,
      latestQueryFormData: {
        datasource: '20__table',
        viz_type: 'treemap',
        slice_id: 125,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: ['count'],
        adhoc_filters: [],
        groupby: ['platform'],
        row_limit: 10,
        order_desc: true,
        color_scheme: 'supersetColors',
        treemap_ratio: 1.618033988749895,
        number_format: 'SMART_NUMBER',
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
        shared_label_colors: {},
        extra_filters: [
          {
            col: '__time_range',
            op: '==',
            val: 'No filter',
          },
        ],
        dashboardId: 9,
      },
      sliceFormData: null,
      queryController: {},
      queriesResponse: [
        {
          cache_key: '9a7e15121b29cddbb238559d031557df',
          cached_dttm: null,
          cache_timeout: 86400,
          errors: [],
          form_data: {
            datasource: '20__table',
            viz_type: 'treemap',
            slice_id: 125,
            url_params: {},
            granularity_sqla: 'year',
            time_range: 'No filter',
            metrics: ['count'],
            adhoc_filters: [],
            groupby: ['platform'],
            row_limit: 10,
            order_desc: true,
            color_scheme: 'supersetColors',
            treemap_ratio: 1.618033988749895,
            number_format: 'SMART_NUMBER',
            queryFields: {
              groupby: 'groupby',
              metrics: 'metrics',
            },
            shared_label_colors: {},
            dashboardId: 9,
            applied_time_extras: {},
            where: '',
            having: '',
            having_filters: [],
            filters: [],
          },
          is_cached: false,
          query:
            'SELECT platform AS platform,\n       COUNT(*) AS count\nFROM main.video_game_sales\nGROUP BY platform\nLIMIT 10\nOFFSET 0',
          from_dttm: null,
          to_dttm: null,
          status: 'success',
          stacktrace: null,
          rowcount: 10,
          colnames: ['platform', 'count'],
          coltypes: [1, 0],
          data: [
            {
              name: 'count',
              children: [
                {
                  name: '2600',
                  value: 133,
                },
                {
                  name: '3DO',
                  value: 3,
                },
                {
                  name: '3DS',
                  value: 509,
                },
                {
                  name: 'DC',
                  value: 52,
                },
                {
                  name: 'DS',
                  value: 2162,
                },
                {
                  name: 'GB',
                  value: 98,
                },
                {
                  name: 'GBA',
                  value: 822,
                },
                {
                  name: 'GC',
                  value: 556,
                },
                {
                  name: 'GEN',
                  value: 27,
                },
                {
                  name: 'GG',
                  value: 1,
                },
              ],
            },
          ],
          applied_filters: [],
          rejected_filters: [],
        },
      ],
      triggerQuery: false,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'treemap',
        slice_id: 125,
        url_params: {},
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: ['count'],
        adhoc_filters: [],
        groupby: ['platform'],
        row_limit: 10,
        order_desc: true,
        color_scheme: 'supersetColors',
        treemap_ratio: 1.618033988749895,
        number_format: 'SMART_NUMBER',
        label_colors: {
          '2600': '#D1C6BC',
          '3DO': '#A38F79',
          '3DS': '#B2B2B2',
          Action: '#ACE1C4',
          Adventure: '#5AC189',
          'COUNT(*)': '#1FA8C9',
          DC: '#666666',
          DS: '#E04355',
          Fighting: '#D1C6BC',
          GB: '#A1A6BD',
          GBA: '#A868B7',
          GC: '#D3B3DA',
          GEN: '#FF7F44',
          GG: '#8FD3E4',
          'Microsoft Game Studios': '#FCC700',
          Misc: '#D3B3DA',
          N64: '#EFA1AA',
          NES: '#FEC0A1',
          NG: '#FCC700',
          Nintendo: '#666666',
          PC: '#8FD3E4',
          PCFX: '#A1A6BD',
          PS: '#FCC700',
          PS2: '#454E7C',
          PS3: '#FF7F44',
          PS4: '#A38F79',
          PSP: '#3CCCCB',
          PSV: '#454E7C',
          Platform: '#FDE380',
          Puzzle: '#454E7C',
          Racing: '#9EE5E5',
          'Role-Playing': '#EFA1AA',
          SAT: '#5AC189',
          SCD: '#E04355',
          SNES: '#FDE380',
          Shooter: '#B2B2B2',
          Simulation: '#1FA8C9',
          Sports: '#FEC0A1',
          Strategy: '#FF7F44',
          TG16: '#3CCCCB',
          'Take-Two Interactive': '#E04355',
          WS: '#A868B7',
          Wii: '#666666',
          WiiU: '#1FA8C9',
          X360: '#5AC189',
          XB: '#ACE1C4',
          XOne: '#9EE5E5',
        },
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '127': {
      id: 127,
      chartAlert: null,
      chartStatus: 'loading',
      chartStackTrace: null,
      chartUpdateEndTime: null,
      chartUpdateStartTime: 0,
      latestQueryFormData: {},
      sliceFormData: null,
      queryController: null,
      queriesResponse: null,
      triggerQuery: true,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'filter_box',
        slice_id: 127,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'Year',
        time_range: 'No filter',
        filter_configs: [
          {
            asc: true,
            clearable: true,
            column: 'platform',
            key: 's3ItH9vhG',
            label: 'Platform',
            multiple: true,
            searchAllOptions: false,
          },
          {
            asc: true,
            clearable: true,
            column: 'genre',
            key: '202hDeMsG',
            label: 'Genre',
            multiple: true,
            searchAllOptions: false,
          },
          {
            asc: true,
            clearable: true,
            column: 'publisher',
            key: '5Os6jsJFK',
            label: 'Publisher',
            multiple: true,
            searchAllOptions: false,
          },
        ],
        date_filter: true,
        adhoc_filters: [],
        queryFields: {},
      },
    },
    '131': {
      id: 131,
      chartAlert: null,
      chartStatus: 'loading',
      chartStackTrace: null,
      chartUpdateEndTime: null,
      chartUpdateStartTime: 0,
      latestQueryFormData: {},
      sliceFormData: null,
      queryController: null,
      queriesResponse: null,
      triggerQuery: true,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'treemap',
        slice_id: 131,
        url_params: {
          preselect_filters:
            '{"1389": {"platform": ["PS", "PS2", "PS3", "PS4"], "genre": null, "__time_range": "No filter"}}',
        },
        granularity_sqla: 'year',
        time_range: 'No filter',
        metrics: ['count'],
        adhoc_filters: [],
        groupby: ['genre'],
        row_limit: null,
        order_desc: true,
        color_scheme: 'supersetColors',
        treemap_ratio: 1.618033988749895,
        number_format: 'SMART_NUMBER',
        label_colors: {
          '0': '#1FA8C9',
          '1': '#454E7C',
          '2600': '#666666',
          '3DO': '#B2B2B2',
          '3DS': '#D1C6BC',
          Action: '#1FA8C9',
          Adventure: '#454E7C',
          DC: '#A38F79',
          DS: '#8FD3E4',
          Europe: '#5AC189',
          Fighting: '#5AC189',
          GB: '#FDE380',
          GBA: '#ACE1C4',
          GC: '#5AC189',
          GEN: '#3CCCCB',
          GG: '#EFA1AA',
          Japan: '#FF7F44',
          'Microsoft Game Studios': '#D1C6BC',
          Misc: '#FF7F44',
          N64: '#1FA8C9',
          NES: '#9EE5E5',
          NG: '#A1A6BD',
          Nintendo: '#D3B3DA',
          'North America': '#666666',
          Other: '#E04355',
          PC: '#EFA1AA',
          PCFX: '#FDE380',
          PS: '#A1A6BD',
          PS2: '#FCC700',
          PS3: '#3CCCCB',
          PS4: '#B2B2B2',
          PSP: '#FEC0A1',
          PSV: '#FCC700',
          Platform: '#666666',
          Puzzle: '#E04355',
          Racing: '#FCC700',
          'Role-Playing': '#A868B7',
          SAT: '#A868B7',
          SCD: '#8FD3E4',
          SNES: '#454E7C',
          Shooter: '#3CCCCB',
          Simulation: '#A38F79',
          Sports: '#8FD3E4',
          Strategy: '#A1A6BD',
          TG16: '#FEC0A1',
          'Take-Two Interactive': '#9EE5E5',
          WS: '#ACE1C4',
          Wii: '#A38F79',
          WiiU: '#E04355',
          X360: '#A868B7',
          XB: '#D3B3DA',
          XOne: '#FF7F44',
        },
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
      },
    },
    '132': {
      id: 132,
      chartAlert: null,
      chartStatus: 'loading',
      chartStackTrace: null,
      chartUpdateEndTime: null,
      chartUpdateStartTime: 0,
      latestQueryFormData: {},
      sliceFormData: null,
      queryController: null,
      queriesResponse: null,
      triggerQuery: true,
      lastRendered: 0,
      form_data: {
        datasource: '20__table',
        viz_type: 'table',
        slice_id: 132,
        url_params: {},
        granularity_sqla: 'year',
        time_grain_sqla: 'P1D',
        time_range: 'No filter',
        query_mode: 'raw',
        groupby: ['name'],
        metrics: [
          {
            aggregate: 'SUM',
            column: {
              column_name: 'global_sales',
              description: null,
              expression: null,
              filterable: true,
              groupby: true,
              id: 887,
              is_dttm: false,
              optionName: '_col_Global_Sales',
              python_date_format: null,
              type: 'DOUBLE PRECISION',
              verbose_name: null,
            },
            expressionType: 'SIMPLE',
            hasCustomLabel: false,
            isNew: false,
            label: 'SUM(Global_Sales)',
            optionName: 'metric_pkpvgdsf70d_pnqv77v0x2p',
            sqlExpression: null,
          },
        ],
        all_columns: [
          'name',
          'global_sales',
          'platform',
          'genre',
          'publisher',
          'year',
        ],
        percent_metrics: [],
        adhoc_filters: [],
        order_by_cols: ['["global_sales", false]'],
        row_limit: null,
        server_page_length: 10,
        order_desc: true,
        table_timestamp_format: 'smart_date',
        page_length: '15',
        include_search: true,
        show_cell_bars: false,
        color_pn: false,
        queryFields: {
          groupby: 'groupby',
          metrics: 'metrics',
        },
        table_filter: false,
      },
    },
  };

  const validNodes = [
    'ROOT_ID',
    'TABS-97PVJa11D_',
    'TAB-2_QXp8aNq',
    'ROW-fjg6YQBkH',
    'CHART-1L7NIcXvVN',
    'ROW-yP9SB89PZ',
    'CHART-7mKdnU7OUJ',
    'TAB-lg-5ymUDgm',
    'ROW-7kAf1blYU',
    'CHART-8OG3UJX-Tn',
    'CHART-W02beJK7ms',
    'CHART-XFag0yZdLk',
    'ROW-NuR8GFQTO',
    'CHART-XRvRfsMsaQ',
    'CHART-XVIYTeubZh',
    'CHART-_sx22yawJO',
    'CHART-nYns6xr4Ft',
    'COLUMN-F53B1OSMcz',
    'CHART-uP9GF0z0rT',
    'ROW-XT1DsNA_V',
    'CHART-wt6ZO8jRXZ',
  ];

  const initiallyExcludedCharts: number[] = [];
  it('Succeeds with valid', () => {
    expect(() => {
      buildTree(
        // @ts-ignore
        node,
        treeItem,
        layout,
        charts,
        validNodes,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();
  });

  it('Avoids runtime error with invalid inputs', () => {
    expect(() => {
      buildTree(
        // @ts-expect-error
        undefined,
        treeItem,
        layout,
        charts,
        validNodes,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();

    expect(() => {
      buildTree(
        // @ts-expect-error
        node,
        null,
        layout,
        charts,
        validNodes,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();

    expect(() => {
      buildTree(
        // @ts-expect-error
        node,
        treeItem,
        null,
        charts,
        validNodes,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();

    expect(() => {
      buildTree(
        // @ts-expect-error
        node,
        treeItem,
        layout,
        null,
        validNodes,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();

    expect(() => {
      buildTree(
        // @ts-expect-error
        node,
        treeItem,
        layout,
        charts,
        null,
        initiallyExcludedCharts,
        () => 'Fake title',
      );
    }).not.toThrowError();

    expect(() => {
      buildTree(
        // @ts-expect-error
        node,
        treeItem,
        layout,
        charts,
        validNodes,
        null,
        () => 'Fake title',
      );
    }).not.toThrowError();
  });
});
