 <!-- * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. -->
 # Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [2.1.0](https://github.com/apache/superset/compare/v2021.41.0...v2.1.0) (2023-04-18)

### Bug Fixes

- add timegrains to data payload ([#20938](https://github.com/apache/superset/issues/20938)) ([6e5036d](https://github.com/apache/superset/commit/6e5036d87fcb444eaf01d7a8a1f274426597a69f))
- dashboard full screen layout ([#17985](https://github.com/apache/superset/issues/17985)) ([c139312](https://github.com/apache/superset/commit/c139312bb3cc849bfd26141d719612306fe46156))
- dashboard reload crash ([#17992](https://github.com/apache/superset/issues/17992)) ([3d829fc](https://github.com/apache/superset/commit/3d829fc3c838358dd8c798ecaeefd34c502edca0))
- "Refresh Dashboard" only refreshes active tab ([#20688](https://github.com/apache/superset/issues/20688)) ([558201c](https://github.com/apache/superset/commit/558201c8653dfb2ee5f011662ee0e0a79f4b281d))
- "Week Staring Monday" time grain for BigQuery ([#20091](https://github.com/apache/superset/issues/20091)) ([694f75d](https://github.com/apache/superset/commit/694f75d37657a554831fe9747e5baef36339ed88))
- (dashboard) Adds optional chaining to avoid runtime error ([#22213](https://github.com/apache/superset/issues/22213)) ([1831e8c](https://github.com/apache/superset/commit/1831e8c9273275f45ac174a301f21d3c2b11cc16))
- [alert] allow decimal for alert threshold value ([#17751](https://github.com/apache/superset/issues/17751)) ([c5af7a4](https://github.com/apache/superset/commit/c5af7a48df24207839913a61d9aed31148697ee2))
- [alert] should run alert query from report account ([#17499](https://github.com/apache/superset/issues/17499)) ([a01c4c9](https://github.com/apache/superset/commit/a01c4c95db9bd099758b5cf49119e4ad536613e8))
- [explore][mixed time series chart] when user change size of view query window, query B part will disappear ([#20750](https://github.com/apache/superset/issues/20750)) ([6e0ddcf](https://github.com/apache/superset/commit/6e0ddcf84839eecb19c694f66460ffb8aa5453dd))
- [sc-54864] Adds safety check to provide near term fix to save query ([#21034](https://github.com/apache/superset/issues/21034)) ([ab6ec89](https://github.com/apache/superset/commit/ab6ec89f680dbf022a39ed568c6fcdce0439b2dd))
- 🐛 broken unit test due to missing babel-polyfill ([896657e](https://github.com/apache/superset/commit/896657e1474260245c16a9df52c0e3fe878be3f4))
- 🐛 Fixed type definition for chart plugin ([#123](https://github.com/apache/superset/issues/123)) ([fdd10fa](https://github.com/apache/superset/commit/fdd10fa062d48a93a76f79c30855a1d0016a7cad))
- 0 indicator on radar viz ([#1282](https://github.com/apache/superset/issues/1282)) ([353d7f4](https://github.com/apache/superset/commit/353d7f4a346192206c60f0154a7e30c7da08befe))
- **20428:** Address-Presto/Trino-Poll-Issue-Refactor ([#20434](https://github.com/apache/superset/issues/20434)) ([8b7262f](https://github.com/apache/superset/commit/8b7262fa9040b6bc956dfa2c191953fe3b65bea6))
- A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button ([#19967](https://github.com/apache/superset/issues/19967)) ([8345eb4](https://github.com/apache/superset/commit/8345eb4644947180e3c84ed26498abb7fa194de9))
- A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button ([#20363](https://github.com/apache/superset/issues/20363)) ([ead1040](https://github.com/apache/superset/commit/ead10401e7f5344d821ee3086c191fedb5d6ee4b))
- accept headers on import ([#17080](https://github.com/apache/superset/issues/17080)) ([40e9add](https://github.com/apache/superset/commit/40e9add641483a1c3a8bc87efa0d8e525d4cfd0d))
- accept old database payload ([#21923](https://github.com/apache/superset/issues/21923)) ([1388f21](https://github.com/apache/superset/commit/1388f21ee34251b6ef83beb009ba0901e4067848))
- accept only JSON credentials ([#22040](https://github.com/apache/superset/issues/22040)) ([cd1b379](https://github.com/apache/superset/commit/cd1b379bdf323f78c2e7d574525a55898c920942))
- Adaptive formatting spelling ([#19359](https://github.com/apache/superset/issues/19359)) ([dc769a9](https://github.com/apache/superset/commit/dc769a9a34e9b6417447ee490ecd203ace0941d9))
- adaptive formatting typo in explore dropdowns ([#19312](https://github.com/apache/superset/issues/19312)) ([0363e55](https://github.com/apache/superset/commit/0363e55b810df1980c3dc2381aedcd90e8706b32))
- add **init**.py to key_value ([#17730](https://github.com/apache/superset/issues/17730)) ([ec24256](https://github.com/apache/superset/commit/ec24256407dc0a0122f746cd3354c3647ccaddb5))
- add `get_column` function for Query obj ([#21691](https://github.com/apache/superset/issues/21691)) ([51c54b3](https://github.com/apache/superset/commit/51c54b3c9bc69273bb5da004b8f9a7ae202de8fd))
- add advanced analytics to all of timeseries viz ([#1308](https://github.com/apache/superset/issues/1308)) ([4de4fc3](https://github.com/apache/superset/commit/4de4fc37fc84cad5aa4bae7dcd27efb380b2966c))
- add back custom sql filtering with Query as source ([#21190](https://github.com/apache/superset/issues/21190)) ([c61a507](https://github.com/apache/superset/commit/c61a507e14491b400c8d5155317960a8671ab3e2))
- add back database lookup from sip 68 revert ([#22129](https://github.com/apache/superset/issues/22129)) ([6f6cb18](https://github.com/apache/superset/commit/6f6cb1839e8c688a929639dca7d0754e868ebfbf))
- add back nvd3 missing css ([#776](https://github.com/apache/superset/issues/776)) ([104c1b5](https://github.com/apache/superset/commit/104c1b597a45b6127c68e9c75b73bdd1688284dc))
- add back view for report reload error ([#19522](https://github.com/apache/superset/issues/19522)) ([79abd23](https://github.com/apache/superset/commit/79abd23f48bcad15f3c879b2ec0713648f066849))
- add columns back into SQL Lab to Explore Flow ([#22320](https://github.com/apache/superset/issues/22320)) ([5e1b817](https://github.com/apache/superset/commit/5e1b8170ca9e6093ecde0852c92bd050c31e9c30))
- add complex type to pydruid ([#20834](https://github.com/apache/superset/issues/20834)) ([672266c](https://github.com/apache/superset/commit/672266ca588b14975cb7adc31edd49f36b6d80c7))
- add container css for interval type annotation ([#372](https://github.com/apache/superset/issues/372)) ([2277583](https://github.com/apache/superset/commit/227758355765e31d570d55768dc3a199a70f550e))
- Add cypress test for report page direct link issue ([#20099](https://github.com/apache/superset/issues/20099)) ([6244728](https://github.com/apache/superset/commit/62447282561b114b46be9e704c4ae8a7f02b9e34))
- Add database search in available charts on dashboard. ([#19244](https://github.com/apache/superset/issues/19244)) ([9622520](https://github.com/apache/superset/commit/962252030bb320ed0a798e732473d8b0eda3a848))
- add disallowed query params for engines specs ([#23217](https://github.com/apache/superset/issues/23217)) ([2f37582](https://github.com/apache/superset/commit/2f3758278fe42cfdd3789c7c93448bc1e5a5a9fe))
- add fallback and validation for report and cron timezones ([#17338](https://github.com/apache/superset/issues/17338)) ([f10bc6d](https://github.com/apache/superset/commit/f10bc6d8fe7f3fa4056db2aaff8256f9c3e1550b))
- add fetchRetryOptions in SupersetClientClass.request method ([#867](https://github.com/apache/superset/issues/867)) ([b96586b](https://github.com/apache/superset/commit/b96586b0a973b058d2b36e46ae20cfd28f165132))
- add form data for empty state control to save dataset ([#21944](https://github.com/apache/superset/issues/21944)) ([d3f930a](https://github.com/apache/superset/commit/d3f930a5575f03bc5f4f468b8bf37e834bf2aa4d))
- Add french translation missing ([#20061](https://github.com/apache/superset/issues/20061)) ([944808a](https://github.com/apache/superset/commit/944808a0ce6f094071bff5b3b789e63157a8b8f7))
- Add locale for DatePicker component ([#20063](https://github.com/apache/superset/issues/20063)) ([c382d53](https://github.com/apache/superset/commit/c382d53478c7292e6aa21ba081eb055886477d18))
- add logging to alerts and reports to find non-triggering issues ([#21684](https://github.com/apache/superset/issues/21684)) ([84c3cf6](https://github.com/apache/superset/commit/84c3cf66ea0858f7dd7ae1a1fca7260cec076bf6))
- Add mexico back to country map ([#18219](https://github.com/apache/superset/issues/18219)) ([7f3453f](https://github.com/apache/superset/commit/7f3453f3ea4d5185c3a5f2c1d8738f474817600f))
- Add migration to add created_by_fk as explicit owner for charts and datasets ([#20617](https://github.com/apache/superset/issues/20617)) ([e1094e2](https://github.com/apache/superset/commit/e1094e2198d9e5714714f3f276ed3cc4fa28dfd5))
- add missing init on python pkg key_value ([#19428](https://github.com/apache/superset/issues/19428)) ([fa35109](https://github.com/apache/superset/commit/fa35109bf2a416462e3c83f527aa82c20b67818d))
- add new config to allow for specific import data urls ([#22942](https://github.com/apache/superset/issues/22942)) ([7a0f350](https://github.com/apache/superset/commit/7a0f350028817e9980abcc1afcf5672d04af3e8b))
- Add perm for showing DBC-UI in Global Nav ([#19023](https://github.com/apache/superset/issues/19023)) ([c337491](https://github.com/apache/superset/commit/c337491d0ebd10f83ca502779cbebe5cb6570049))
- add plain postgres alias ([#21045](https://github.com/apache/superset/issues/21045)) ([4f1996d](https://github.com/apache/superset/commit/4f1996dba8e35ee958048b726750247ec8e518aa))
- add primary button loading state to modals ([#20018](https://github.com/apache/superset/issues/20018)) ([63702c4](https://github.com/apache/superset/commit/63702c48ab77ee73b7e304c92fc74ce02748107e))
- Add scrollTopOnPagination property to Table ([#22115](https://github.com/apache/superset/issues/22115)) ([896c832](https://github.com/apache/superset/commit/896c8326494b512743aa6194b015b5e9dfe0c487))
- Add serviceAccountName to celerybeat pods. ([#19670](https://github.com/apache/superset/issues/19670)) ([1918dc0](https://github.com/apache/superset/commit/1918dc04559fcc6df369f3bf09d165561a29176e))
- add timeout value to error details in rejectAfterTimeout ([#715](https://github.com/apache/superset/issues/715)) ([c244286](https://github.com/apache/superset/commit/c24428643ddc6abfd12d79ce1c4d3c6a3d33c08f))
- Add tooltip to dropdown trigger in horizontal filter bar ([#22373](https://github.com/apache/superset/issues/22373)) ([de4f509](https://github.com/apache/superset/commit/de4f50909e20608ca143d7f85e42971be6bce495))
- add typings for @storybook/react ([#203](https://github.com/apache/superset/issues/203)) ([a2a02ef](https://github.com/apache/superset/commit/a2a02ef93284351f463c763f8d60245b75a86420))
- add/find owners from report/alert modal ([#18971](https://github.com/apache/superset/issues/18971)) ([7e336d1](https://github.com/apache/superset/commit/7e336d1230ca8333afc3e5be7780bc962cbf8478))
- adding extraConfig to celery beat deployment ([#22586](https://github.com/apache/superset/issues/22586)) ([db20180](https://github.com/apache/superset/commit/db201804aeaba232cb2eef4e3554278567032513))
- adding extraConfig to worker deployment [#20828](https://github.com/apache/superset/issues/20828) ([#20829](https://github.com/apache/superset/issues/20829)) ([3f943ff](https://github.com/apache/superset/commit/3f943ffadb92632489e275ba2103a1531f4dc790))
- adding missing examples for bubble chart, bullet chart, calendar heatmap chart and country map chart in the gallery ([#22523](https://github.com/apache/superset/issues/22523)) ([839ec7c](https://github.com/apache/superset/commit/839ec7ceacc66c65928fd0ddead2b014db3d5563))
- Address performance regression introduced in [#11785](https://github.com/apache/superset/issues/11785) ([#20893](https://github.com/apache/superset/issues/20893)) ([50d2e5a](https://github.com/apache/superset/commit/50d2e5a15d83b4759cdbbcce363a83f6fe12c6bb))
- Address regression in main_dttm_col for non-dnd ([#20712](https://github.com/apache/superset/issues/20712)) ([a6abcd9](https://github.com/apache/superset/commit/a6abcd9ea8fac4a477b824adb367b4b5206a5d27))
- Address regression introduced in [#21284](https://github.com/apache/superset/issues/21284) ([#21470](https://github.com/apache/superset/issues/21470)) ([8c16806](https://github.com/apache/superset/commit/8c16806f5759ecc53ecef88a2e96e2e0964bffc6))
- Adds logging for SPA route navigation with React router ([#21960](https://github.com/apache/superset/issues/21960)) ([d1807db](https://github.com/apache/superset/commit/d1807db0410642d6bfb5faf37c2a9bf4ef5c9f3e))
- Adds time grain to Pivot Table v2 ([#22170](https://github.com/apache/superset/issues/22170)) ([9a2cb43](https://github.com/apache/superset/commit/9a2cb431ce9b82d656838d70c088bc00f3e4bd5e))
- Adhere to series limit ordering for prequery ([#17388](https://github.com/apache/superset/issues/17388)) ([ce614ea](https://github.com/apache/superset/commit/ce614ea815db492cd88f53918daea6dcdd7ddedc))
- adhoc column in legacy chart ([#19234](https://github.com/apache/superset/issues/19234)) ([b5e9fad](https://github.com/apache/superset/commit/b5e9fad11a2146c471c7f27d88cc425d928f94dd))
- adjust timeseries grid right offset to match the rest ([#20933](https://github.com/apache/superset/issues/20933)) ([fe581a3](https://github.com/apache/superset/commit/fe581a36404ec1cfe689995b61a43164cb1988df))
- **adjusted upstream break change:** adjusted upstream break change ([ad02316](https://github.com/apache/superset/commit/ad023162e19ed032fb5fd6b86fc67e6b4f124cca))
- advanced data type API spec and permission name ([#20128](https://github.com/apache/superset/issues/20128)) ([d8117f7](https://github.com/apache/superset/commit/d8117f7e377a2c231ea3fb17fb3b4f96408b58fe))
- **alembic:** Making Alembic logger config optional ([#17774](https://github.com/apache/superset/issues/17774)) ([b3db614](https://github.com/apache/superset/commit/b3db6140c88106fedebe91db0ca817eca4234dc8))
- **alert & report:** make to fix the issue when recreate report ([#19419](https://github.com/apache/superset/issues/19419)) ([68ed39b](https://github.com/apache/superset/commit/68ed39bcd34f8cc3c10b37121fa717dfe4ad3cce))
- alert & reports active toggle optimistic update ([#20402](https://github.com/apache/superset/issues/20402)) ([4dc3044](https://github.com/apache/superset/commit/4dc30441b7e38aa43db9aa5eda3f8a52322e46b1))
- alert modal bug fix ([#22688](https://github.com/apache/superset/issues/22688)) ([5a422b3](https://github.com/apache/superset/commit/5a422b31c5d1ee3059c7659b376e3b8e1eeb257b))
- alert/report created by filter inconsistency with table display ([#19518](https://github.com/apache/superset/issues/19518)) ([a05ff5e](https://github.com/apache/superset/commit/a05ff5e5983632809518995b7b50b985845fba88))
- **AlertReportModal:** Text Area Change ([#17176](https://github.com/apache/superset/issues/17176)) ([5948a9f](https://github.com/apache/superset/commit/5948a9fd0246b9d67fd2074a613f081e53a19670))
- **alerts:** cron picker alignment issues ([#22274](https://github.com/apache/superset/issues/22274)) ([09bb1cc](https://github.com/apache/superset/commit/09bb1cc3b589464acfaaecf05b99b78aa1dbb5b4))
- **alerts:** execute query as report executor ([#22167](https://github.com/apache/superset/issues/22167)) ([c3f9f0b](https://github.com/apache/superset/commit/c3f9f0bf691df6923bf44df0457de718728c3e7b))
- **alerts:** restrict list view and gamma perms ([#21765](https://github.com/apache/superset/issues/21765)) ([4c1777f](https://github.com/apache/superset/commit/4c1777f20d6ca3a91383ba7fc042f20c286a7795))
- allow adhoc columns in non-aggregate query ([#21729](https://github.com/apache/superset/issues/21729)) ([d1a6f0e](https://github.com/apache/superset/commit/d1a6f0ebc4e2dd092580ad49da7c724c577e6ece))
- Allow clickhouse dbs with timestamps to visualize queries ([#21446](https://github.com/apache/superset/issues/21446)) ([4d0c2ba](https://github.com/apache/superset/commit/4d0c2ba6ef3f8ca7479cf46383ddac9470aa3329))
- Allow comma in Number Format ([#21817](https://github.com/apache/superset/issues/21817)) ([383dc29](https://github.com/apache/superset/commit/383dc29ad1fb921ee618ed80b847316d77247886))
- allow CSV upload in Other db ([#22807](https://github.com/apache/superset/issues/22807)) ([3084763](https://github.com/apache/superset/commit/3084763eb70fa92899e932d8ec95b52cf36ade3d))
- Allow dataset owners to explore their datasets ([#20382](https://github.com/apache/superset/issues/20382)) ([f910958](https://github.com/apache/superset/commit/f9109583ce1ede0cb2b9f4ad09452bba552a55ce))
- Allow dataset owners to see their datasets ([#20135](https://github.com/apache/superset/issues/20135)) ([b0c6935](https://github.com/apache/superset/commit/b0c6935f0600f111f06ae7ff05f7fa902e9ad252))
- allow datasource imports on Windows ([#22264](https://github.com/apache/superset/issues/22264)) ([32ccb97](https://github.com/apache/superset/commit/32ccb97c9b94d9071bf5d52c7467d47c36ed70b2))
- Allow empty CSS in Handlebars ([#22422](https://github.com/apache/superset/issues/22422)) ([bb318cb](https://github.com/apache/superset/commit/bb318cb137acd27009ddbe63ba4f8e0c37b754ca))
- allow for multiple columns in pivot table report ([#17636](https://github.com/apache/superset/issues/17636)) ([13e1929](https://github.com/apache/superset/commit/13e19291f2aa7041b156f0284c17f70a06000d3c))
- allow POST chart/data request without CSRF token ([#17429](https://github.com/apache/superset/issues/17429)) ([aa8040e](https://github.com/apache/superset/commit/aa8040ec9b0033fab8301afea6fccfcf2a245260))
- allow subquery in ad-hoc SQL (WIP) ([#19242](https://github.com/apache/superset/issues/19242)) ([50902d5](https://github.com/apache/superset/commit/50902d51f56eac7813572178527ee83b429db284))
- allow to select <NULL> in a native filter single mode ([#19076](https://github.com/apache/superset/issues/19076)) ([19fcd03](https://github.com/apache/superset/commit/19fcd03c8962b5ae2d2bb5cd196b1ef07a27b9c3))
- Allow users to update database in Dataset Edit Modal ([#17265](https://github.com/apache/superset/issues/17265)) ([d0bad96](https://github.com/apache/superset/commit/d0bad96b1ab9065a5e1d313793da35089ee1f07c))
- allow_browser_login in import/export API ([#19656](https://github.com/apache/superset/issues/19656)) ([5c63df5](https://github.com/apache/superset/commit/5c63df522a6df73e58142a1b9db62155c6ec5cd4))
- **allow-db-explore:** make that the set the allow-db-explore option ([#19030](https://github.com/apache/superset/issues/19030)) ([62ad574](https://github.com/apache/superset/commit/62ad574c2405edca7107f4ceaf9c2358927219d3))
- **allow-db-explore:** make to check the allow virtual table explore option by default ([#19883](https://github.com/apache/superset/issues/19883)) ([ea6753d](https://github.com/apache/superset/commit/ea6753d27df81f57d691593a7ec131bcfaf1e7ea))
- Allows PUT and DELETE only for owners of dashboard filter state ([#17644](https://github.com/apache/superset/issues/17644)) ([2ae83fa](https://github.com/apache/superset/commit/2ae83fac8623acd20f92e9f441ce03793354e0a1))
- Alpha are unable to perform a second modification to a Dataset when in Explore ([#20296](https://github.com/apache/superset/issues/20296)) ([b6c11f2](https://github.com/apache/superset/commit/b6c11f2b971abd45281dafa0ac0b105e9d3ba6db))
- Alpha should not be able to edit datasets that they don't own ([#19854](https://github.com/apache/superset/issues/19854)) ([8b15b68](https://github.com/apache/superset/commit/8b15b68979bf033979fe7014ef2730095ae85120))
- **altered-modal:** displayed the metric value in altered modal correctly ([#18813](https://github.com/apache/superset/issues/18813)) ([3c17c60](https://github.com/apache/superset/commit/3c17c609c98a9702dcb5e69bee7cc925140e98f8))
- **altered-modal:** make specified text fields wrap in table ([#18822](https://github.com/apache/superset/issues/18822)) ([220c461](https://github.com/apache/superset/commit/220c46131e2e6e97496429fa946b0e1a89969f7e))
- always create parameter json field ([#19899](https://github.com/apache/superset/issues/19899)) ([0501ad2](https://github.com/apache/superset/commit/0501ad25e8437757b0ac611026734f2460796e1b))
- Always use temporal type for dttm columns [ID-2] ([#17458](https://github.com/apache/superset/issues/17458)) ([1f8eff7](https://github.com/apache/superset/commit/1f8eff72defe7d0b42058b799a8945c59756f730))
- **annotataion:** handle required fields properly ([#17234](https://github.com/apache/superset/issues/17234)) ([4316fe6](https://github.com/apache/superset/commit/4316fe6ae64522ff5ac31383b378b94be786ad60))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **Annotation Layers:** Error when render options with renamed columns ([#22453](https://github.com/apache/superset/issues/22453)) ([5da09bf](https://github.com/apache/superset/commit/5da09bf341cbad437f653d4ca698c585be840d8a))
- annotation PropType for formula annotations ([#594](https://github.com/apache/superset/issues/594)) ([794c76b](https://github.com/apache/superset/commit/794c76bcd25580cdb0faeba942684ccb2e8fe3ac))
- API logger output ([#17981](https://github.com/apache/superset/issues/17981)) ([3a58424](https://github.com/apache/superset/commit/3a58424e62592ead7d05eb64a351c21f8305e6ab))
- **api:** incorrect api schema definitions ([#17620](https://github.com/apache/superset/issues/17620)) ([0544bee](https://github.com/apache/superset/commit/0544bee74eb1cb36aa2a12847aaa6ac4ff082f90))
- Apply border radius and fix height for MetadataBar ([#22010](https://github.com/apache/superset/issues/22010)) ([389e44e](https://github.com/apache/superset/commit/389e44e1c5d33b162ff20e1568490259c403329c))
- apply margins in nvd3 ([#283](https://github.com/apache/superset/issues/283)) ([929c546](https://github.com/apache/superset/commit/929c546ebc8b88789952e1e210459843da00a386))
- **assets api:** import replaces dashboard ([#22208](https://github.com/apache/superset/issues/22208)) ([7d8fff8](https://github.com/apache/superset/commit/7d8fff87b55a2276b7e287772a654c3c63f5b2ce))
- Assign an owner when creating a dataset from a csv, excel or tabular ([#17986](https://github.com/apache/superset/issues/17986)) ([8b83c7f](https://github.com/apache/superset/commit/8b83c7fe0a5c144295007211cc614cc3379e4c54))
- **async-queries:** make global async. queries cookie SameSite option configurable ([#21185](https://github.com/apache/superset/issues/21185)) ([80b3113](https://github.com/apache/superset/commit/80b31130b4e639028d1bc613ce93fd4c4f5ad58f))
- Athena timestamp literal format ([#19970](https://github.com/apache/superset/issues/19970)) ([8531546](https://github.com/apache/superset/commit/85315460cbc23cae6ada309012f6d9057f23019d)), closes [#19969](https://github.com/apache/superset/issues/19969)
- auto refresh interval won't be updated ([#17112](https://github.com/apache/superset/issues/17112)) ([35cbcc4](https://github.com/apache/superset/commit/35cbcc46438c8fec06cf1e5f2c36aa5e0dcb46d7))
- auto-complete of tables and names are not working in SQL lab ([#19152](https://github.com/apache/superset/issues/19152)) ([3b427b2](https://github.com/apache/superset/commit/3b427b2029cbeb5c656d20f4201ea4eada069a25))
- avoid escaping bind-like params containing colons ([#17419](https://github.com/apache/superset/issues/17419)) ([ad8a7c4](https://github.com/apache/superset/commit/ad8a7c42f9da8ce6092b368d7081c3e06b797f8d))
- avoid filters containing null value ([#17168](https://github.com/apache/superset/issues/17168)) ([4c708af](https://github.com/apache/superset/commit/4c708af71081eef3454e7f0ac2bba5d0588bfa87))
- avoid unnecessary rerenders caused by ownState ([#1096](https://github.com/apache/superset/issues/1096)) ([cb76b9d](https://github.com/apache/superset/commit/cb76b9dac1555e1028b32ef15d1fae2237a44b48))
- avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied ([#20173](https://github.com/apache/superset/issues/20173)) ([365acee](https://github.com/apache/superset/commit/365acee663f7942ba7d8dfd0e4cf72c4cecb7a2d))
- Bad date type in email text report for table chart ([#20119](https://github.com/apache/superset/issues/20119)) ([e7b965a](https://github.com/apache/superset/commit/e7b965a3b2bb22da75b42d64cf4856073ecc026d))
- bar label for many bars and long labels ([#21](https://github.com/apache/superset/issues/21)) ([a2209f2](https://github.com/apache/superset/commit/a2209f2876d96eb890e3ec84007b3b49bb08909b))
- **bar-chart-v2:** remove marker from bar chart V2 ([#20409](https://github.com/apache/superset/issues/20409)) ([b32288f](https://github.com/apache/superset/commit/b32288fddfc077d941452245a4e8002335746ba4))
- better logic to extract errors on databricks ([#22792](https://github.com/apache/superset/issues/22792)) ([d091a68](https://github.com/apache/superset/commit/d091a6890996997080c7a1d10e2937157393d8ac))
- big number with trendline can't calculate cumsum ([#19542](https://github.com/apache/superset/issues/19542)) ([2daa071](https://github.com/apache/superset/commit/2daa07163326b8555488dab523c5479cf92821cf))
- big number with trendline fix ([#34](https://github.com/apache/superset/issues/34)) ([66a5a5e](https://github.com/apache/superset/commit/66a5a5e56596868443db4c6c68dbc25e1ec4551c))
- **big number:** time grain control is useless in BigNumber Viz ([#21372](https://github.com/apache/superset/issues/21372)) ([b80f659](https://github.com/apache/superset/commit/b80f6591018858b709194687fe7ea3d244131761))
- **big-number:** big number gets cut off on a Dashboard ([#20488](https://github.com/apache/superset/issues/20488)) ([24a53c3](https://github.com/apache/superset/commit/24a53c38c68108c47af9f7685542fcb8378915bf))
- **big-number:** Big Number with Trendline Chart is not working if Time Grain is set to Month ([#19043](https://github.com/apache/superset/issues/19043)) ([c32eaf4](https://github.com/apache/superset/commit/c32eaf47e50f5fc0cb7630cbf38819cd03b5294b))
- BIGINT rendering regression in chartAction ([#21937](https://github.com/apache/superset/issues/21937)) ([4002406](https://github.com/apache/superset/commit/40024064ae35e596215a79d98ed8d0b4a90847f2))
- bignumber format by time formatter ([#1307](https://github.com/apache/superset/issues/1307)) ([03b1db9](https://github.com/apache/superset/commit/03b1db93c2dfbfb34498845de69105bc7b9fad54))
- BigQuery cannot accept Time Grain ([#21489](https://github.com/apache/superset/issues/21489)) ([33509ab](https://github.com/apache/superset/commit/33509ab7da384144d42d67dd8c6233b1be9c9fa0))
- BigQuery get_parameters_from_uri ([#20966](https://github.com/apache/superset/issues/20966)) ([7e501cd](https://github.com/apache/superset/commit/7e501cd816937608cddcd513bea9e7ea11bd3add))
- **bigquery:** calculated column cannot orderby in BigQuery ([#17196](https://github.com/apache/superset/issues/17196)) ([bedb8f4](https://github.com/apache/superset/commit/bedb8f4dffb824a0f6c252b11890969577df132b))
- **bigquery:** Properly display errors for BigQuery DBs ([#22349](https://github.com/apache/superset/issues/22349)) ([60a617e](https://github.com/apache/superset/commit/60a617eabab42acb3adad166c01af3965dafac18))
- **bootstrap-data:** always check flashes ([#22659](https://github.com/apache/superset/issues/22659)) ([73e53fa](https://github.com/apache/superset/commit/73e53fab7a5141881711a0269740627fd0527d30))
- bootstraping frontend ([#22720](https://github.com/apache/superset/issues/22720)) ([91850eb](https://github.com/apache/superset/commit/91850ebc571e31996d6670aceb00b2e0c92c4c91))
- both the CSS and className were expecting true/false strings ([#286](https://github.com/apache/superset/issues/286)) ([64c7937](https://github.com/apache/superset/commit/64c7937ac493de2eb6035b47d174920f63deee13))
- Box Plot Chart throws an error when the average (AVG) / SUM is being calculated on the Metrics ([#20235](https://github.com/apache/superset/issues/20235)) ([8638f59](https://github.com/apache/superset/commit/8638f59b4c7ebe954afe46bbfbd5880f1ae6afda))
- broken build due to failing unit tests ([#141](https://github.com/apache/superset/issues/141)) ([d6f3933](https://github.com/apache/superset/commit/d6f39335d82d0a3b7b71e8ae7ef08b074228139e))
- broken build due to file rename in vega-lite ([#37](https://github.com/apache/superset/issues/37)) ([1b4d911](https://github.com/apache/superset/commit/1b4d9117a8b202af9bb21140f9543a2d4c75ea61))
- broken build due to vega type ([#96](https://github.com/apache/superset/issues/96)) ([b652510](https://github.com/apache/superset/commit/b65251076504a39751997fde998e06d547d7be1a))
- Broken effect in useCSSTextTruncation hook ([#22324](https://github.com/apache/superset/issues/22324)) ([2731cba](https://github.com/apache/superset/commit/2731cbacbf5ce7220d114ac85186e27136926deb))
- bug due to name mangle when minifying ([46384d7](https://github.com/apache/superset/commit/46384d790a9d6314cb26b52bb44fb98f7321e471))
- build error ([#235](https://github.com/apache/superset/issues/235)) ([ac99cd0](https://github.com/apache/superset/commit/ac99cd0efbc92130484d4ac625faccd8d371a016))
- Build scripts ([#18201](https://github.com/apache/superset/issues/18201)) ([74a9fc1](https://github.com/apache/superset/commit/74a9fc14697c6cc077b3b9b1cfa3f7cbb22ca73a)), closes [#17714](https://github.com/apache/superset/issues/17714) [#17736](https://github.com/apache/superset/issues/17736) [#17990](https://github.com/apache/superset/issues/17990) [#17929](https://github.com/apache/superset/issues/17929) [#18036](https://github.com/apache/superset/issues/18036) [#18115](https://github.com/apache/superset/issues/18115) [#18128](https://github.com/apache/superset/issues/18128) [#18092](https://github.com/apache/superset/issues/18092) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18041](https://github.com/apache/superset/issues/18041) [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051) [#17593](https://github.com/apache/superset/issues/17593) [#18058](https://github.com/apache/superset/issues/18058) [#18059](https://github.com/apache/superset/issues/18059) [#18027](https://github.com/apache/superset/issues/18027) [#18045](https://github.com/apache/superset/issues/18045) [#18048](https://github.com/apache/superset/issues/18048) [#18073](https://github.com/apache/superset/issues/18073) [#17771](https://github.com/apache/superset/issues/17771) [#18060](https://github.com/apache/superset/issues/18060) [#17207](https://github.com/apache/superset/issues/17207) [#18087](https://github.com/apache/superset/issues/18087) [#18086](https://github.com/apache/superset/issues/18086) [#18082](https://github.com/apache/superset/issues/18082) [#18097](https://github.com/apache/superset/issues/18097) [#17807](https://github.com/apache/superset/issues/17807) [#18089](https://github.com/apache/superset/issues/18089) [#18100](https://github.com/apache/superset/issues/18100) [#18101](https://github.com/apache/superset/issues/18101) [#18105](https://github.com/apache/superset/issues/18105) [#18111](https://github.com/apache/superset/issues/18111) [#18083](https://github.com/apache/superset/issues/18083) [#17882](https://github.com/apache/superset/issues/17882) [#17843](https://github.com/apache/superset/issues/17843) [#17917](https://github.com/apache/superset/issues/17917) [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18081](https://github.com/apache/superset/issues/18081) [#18100](https://github.com/apache/superset/issues/18100) [#18133](https://github.com/apache/superset/issues/18133) [#18100](https://github.com/apache/superset/issues/18100) [#18116](https://github.com/apache/superset/issues/18116) [#18114](https://github.com/apache/superset/issues/18114) [#18108](https://github.com/apache/superset/issues/18108) [#18125](https://github.com/apache/superset/issues/18125) [#18152](https://github.com/apache/superset/issues/18152) [#18093](https://github.com/apache/superset/issues/18093) [#18130](https://github.com/apache/superset/issues/18130) [#18151](https://github.com/apache/superset/issues/18151)
- **build:** update webpack jsx paths ([#18685](https://github.com/apache/superset/issues/18685)) ([09141d2](https://github.com/apache/superset/commit/09141d2a8f8cb0096c9ff9d079786f056fb4de8c))
- Bulk update Spanish translations ([#16799](https://github.com/apache/superset/issues/16799)) ([0f3b630](https://github.com/apache/superset/commit/0f3b6304549c52dee6b6614446ba3ae09548f526))
- bump expected npm version in superset-websocket ([#21973](https://github.com/apache/superset/issues/21973)) ([3ea8f20](https://github.com/apache/superset/commit/3ea8f20f710ceb5e37e7c2147332536d4df31333))
- Bump FAB to 3.3.4 ([#17113](https://github.com/apache/superset/issues/17113)) ([d944503](https://github.com/apache/superset/commit/d94450387366647766840503feedf3487bab8c2c))
- bump FAB to 4.1.2 ([#20483](https://github.com/apache/superset/issues/20483)) ([c56e37c](https://github.com/apache/superset/commit/c56e37cda24ba70819d58501d1bfccc12db585cc))
- bump FAB to 4.3.0 ([#23184](https://github.com/apache/superset/issues/23184)) ([0082cf6](https://github.com/apache/superset/commit/0082cf6a020c0288e87d9d24ccfc60bc33a540c0))
- bump gecko and mozilla in Dockerfile ([#21995](https://github.com/apache/superset/issues/21995)) ([25be9ab](https://github.com/apache/superset/commit/25be9ab4bcce9c9dcec6a67366c70cf590de28ff))
- bump Helm chart release version ([#18751](https://github.com/apache/superset/issues/18751)) ([4ab0786](https://github.com/apache/superset/commit/4ab0786ab3917f601e2f33e0592517410d5328b1))
- bump Helm chart release version ([#18751](https://github.com/apache/superset/issues/18751)) ([#18758](https://github.com/apache/superset/issues/18758)) ([0994217](https://github.com/apache/superset/commit/099421770c8b6513d220b8d49333d0b9e7c025a8))
- bump isort to fix pre-commit CI ([#22907](https://github.com/apache/superset/issues/22907)) ([c9b7507](https://github.com/apache/superset/commit/c9b750793153cc29004cf5b40655e9e9a8a4d05e))
- **bump lunar version of datatable:** bump lunar version of datatable ([f814882](https://github.com/apache/superset/commit/f81488255003409f31a782a8ef22ccce6651874a))
- bump min version of elastic search ([#21274](https://github.com/apache/superset/issues/21274)) ([9c4ae2a](https://github.com/apache/superset/commit/9c4ae2ab7e323a71f44507259c9058faecdd725d))
- bump peer dependencies ([82503ce](https://github.com/apache/superset/commit/82503cedf3dd9f2d1d1a490419f83958ad45d602))
- bump peer dependencies ([#136](https://github.com/apache/superset/issues/136)) ([99c2e4c](https://github.com/apache/superset/commit/99c2e4c875091e2e656fdea539b76eae5eced571))
- Button resizing in horizontal filter bar ([#22365](https://github.com/apache/superset/issues/22365)) ([3a442e0](https://github.com/apache/superset/commit/3a442e09bf102a07e242554ee802b70c2de71ee0))
- cache key with guest token rls ([#19110](https://github.com/apache/superset/issues/19110)) ([2726816](https://github.com/apache/superset/commit/27268169e4c939fe34393f446d706e475277430b))
- cache warmup solution non legacy charts. ([#23012](https://github.com/apache/superset/issues/23012)) ([e755b4f](https://github.com/apache/superset/commit/e755b4f4171f8b6c45b93c8882f226c4d9f8df6d))
- cached common bootstrap Revert ([#21018](https://github.com/apache/superset/issues/21018)) ([#21419](https://github.com/apache/superset/issues/21419)) ([094400c](https://github.com/apache/superset/commit/094400c308b7e16fbabc9c4287054c298ff95899))
- **cache:** only warn about fallback cache for non-debug mode ([#19305](https://github.com/apache/superset/issues/19305)) ([7ca10fb](https://github.com/apache/superset/commit/7ca10fb770934f78f3df1cc3f47a6613c4c62c13))
- **cache:** respect default cache timeout on v1 chart data requests ([#21441](https://github.com/apache/superset/issues/21441)) ([05b97ff](https://github.com/apache/superset/commit/05b97fff4dd56a480405b4ada65de712b3028ecc))
- **caching:** support metastore cache for non-required caches ([#19369](https://github.com/apache/superset/issues/19369)) ([02308a6](https://github.com/apache/superset/commit/02308a6f78321e381502bbdfe49e20c5a8b47f11))
- can not correctly set force in store ([#19932](https://github.com/apache/superset/issues/19932)) ([24e4ab6](https://github.com/apache/superset/commit/24e4ab6a1fb8f3e2a17e355a4cbeea6969e72728))
- can't save dataset modal ([#19452](https://github.com/apache/superset/issues/19452)) ([6b136c2](https://github.com/apache/superset/commit/6b136c2bc9a6c9756e5319b045e3c42da06243cb))
- can't show duckdb table names in the "SEE TABLE SCHEMA" dropdown list ([#21495](https://github.com/apache/superset/issues/21495)) ([fdb4702](https://github.com/apache/superset/commit/fdb470233282730c87d17d1b1ab094d9980a21a2))
- can't sync temporal flag on virtual table ([#19366](https://github.com/apache/superset/issues/19366)) ([d954c3d](https://github.com/apache/superset/commit/d954c3df8604dc4b6a2459a17dd39450a1d57638))
- can't update package-lock.json ([#1442](https://github.com/apache/superset/issues/1442)) ([7f5249e](https://github.com/apache/superset/commit/7f5249eda0c8171792f203fe8a9fa27021398384))
- cannot delete a database if team member has SQL editor tab that uses that db ([#19243](https://github.com/apache/superset/issues/19243)) ([350f21d](https://github.com/apache/superset/commit/350f21d9d34525ae47d4b95a8b95918afa891f01))
- Cannot re-order metrics by drag and drop ([#19876](https://github.com/apache/superset/issues/19876)) ([e4fca89](https://github.com/apache/superset/commit/e4fca89217fc52a31053470f1b4c91a56ed3f4e9))
- catch error when masking encrypted extra is none ([#21570](https://github.com/apache/superset/issues/21570)) ([ef78ec6](https://github.com/apache/superset/commit/ef78ec6b30ece829e6fcf0a73d35dac343dcd70c))
- catch some potential errors on dual write ([#20351](https://github.com/apache/superset/issues/20351)) ([5a13782](https://github.com/apache/superset/commit/5a137820d0fd192fe8466e9448a59e327d13eeb5))
- categorical x-axis can't apply the label of column ([#21869](https://github.com/apache/superset/issues/21869)) ([9aa804e](https://github.com/apache/superset/commit/9aa804e070d9361df5e7dcde326ef16a769ac322))
- **celery cache warmup:** add auth and use warm_up_cache endpoint ([#21076](https://github.com/apache/superset/issues/21076)) ([04dd8d4](https://github.com/apache/superset/commit/04dd8d414db6a3cddcd073ad74acb2a4b7a53b0b))
- Ch31968query context ([#17600](https://github.com/apache/superset/issues/17600)) ([d7e3a60](https://github.com/apache/superset/commit/d7e3a601b6b06b81e109c1b222ece009c7be5193))
- change 401 response to a 403 for Security Exceptions ([#17768](https://github.com/apache/superset/issues/17768)) ([3aa1161](https://github.com/apache/superset/commit/3aa11614b552b439dbfdc6261413b3ac8ae0131a))
- change database database selector ([#18609](https://github.com/apache/superset/issues/18609)) ([9c08bc0](https://github.com/apache/superset/commit/9c08bc0ffc51f5fa779ff90ca061668b7b332ad7))
- Change dataset name affect data access role set to this dataset ([#20574](https://github.com/apache/superset/issues/20574)) ([9291ad5](https://github.com/apache/superset/commit/9291ad5d4ce1fb9a7d5301c06cf62efb1c355092))
- Change datatype of column type in BaseColumn to allow larger datatype names for complexed columns ([#17360](https://github.com/apache/superset/issues/17360)) ([e6db62c](https://github.com/apache/superset/commit/e6db62c469b9dcf391015e7bb768a73316d9efbc))
- Change default SECRET_KEY, improve docs and banner warning ([#17984](https://github.com/apache/superset/issues/17984)) ([412189f](https://github.com/apache/superset/commit/412189fcb73268ddd4829d2fdb8381c5e47595ce))
- Change downloadAsImage to use Superset theme ([#22011](https://github.com/apache/superset/issues/22011)) ([ba65f66](https://github.com/apache/superset/commit/ba65f668972666dcd32602b718c858622c87dab6))
- Change dropdown in Alert/Report modal to use javascript for conditional rendering instead of css ([#22360](https://github.com/apache/superset/issues/22360)) ([49f1cfc](https://github.com/apache/superset/commit/49f1cfc3f99478a3394fccddc50ab9bf7f5c4ae4))
- change example comment to match type ([#21772](https://github.com/apache/superset/issues/21772)) ([af34e45](https://github.com/apache/superset/commit/af34e454be5008de1113189f023990637ccbc224))
- change order of webdriver timeout checks ([#22698](https://github.com/apache/superset/issues/22698)) ([0a2fc9c](https://github.com/apache/superset/commit/0a2fc9cdde48b59dc177beecca26d5a6d4e15671))
- Change timer font to monospace ([#21876](https://github.com/apache/superset/issues/21876)) ([28c7636](https://github.com/apache/superset/commit/28c7636c591f39547f1201ff02da822e4a1bdf88))
- change type of slack error ([#22443](https://github.com/apache/superset/issues/22443)) ([7591acb](https://github.com/apache/superset/commit/7591acba548c7e501a1722a7a32660a1b6c619f7))
- change world map color scheme ([#215](https://github.com/apache/superset/issues/215)) ([bab5aeb](https://github.com/apache/superset/commit/bab5aeb97578ac8a49e2b51e129e0954926b335d))
- Changes the return type of get_permissions to be JSON friendly ([#20472](https://github.com/apache/superset/issues/20472)) ([a169b60](https://github.com/apache/superset/commit/a169b6071209c4f6681c95486127fc43884ff6d1))
- **chart & alert:** make to show metrics properly ([#19939](https://github.com/apache/superset/issues/19939)) ([55aef4d](https://github.com/apache/superset/commit/55aef4db3c85d54064498a0828a55afe97fa2b85))
- **chart & explore:** Show labels for `SliderControl` ([#19765](https://github.com/apache/superset/issues/19765)) ([dfbaba9](https://github.com/apache/superset/commit/dfbaba97c61c28ecde8ce134a1f6ec385467c383))
- **chart & filters:** make to padding between textarea and buttons ([#20026](https://github.com/apache/superset/issues/20026)) ([26c81a7](https://github.com/apache/superset/commit/26c81a70e7574e34c8351c825385dee272abe0cb))
- **chart & gallery:** make to add mixed time-series into recommended charts ([#20064](https://github.com/apache/superset/issues/20064)) ([f43dbc0](https://github.com/apache/superset/commit/f43dbc0dfdbd9ee21267229b566dfab8f59cd0db))
- **chart & heatmap:** make to fix that y label is rendering out of bounds ([#20011](https://github.com/apache/superset/issues/20011)) ([56e9695](https://github.com/apache/superset/commit/56e96950c17ec65ef18cedfb2ed6591796a96cfc))
- **chart & table:** make to allow highlight in case of numeric column ([#19938](https://github.com/apache/superset/issues/19938)) ([902ac05](https://github.com/apache/superset/commit/902ac053722ada89f817156a0af38ec03f27376c))
- **chart & table:** make to prevent dates from wrapping ([#20384](https://github.com/apache/superset/issues/20384)) ([1ae9353](https://github.com/apache/superset/commit/1ae935379fa8f1f5043205f218d7c1af93fae053))
- Chart download as image issue ([#19885](https://github.com/apache/superset/issues/19885)) ([c2999fd](https://github.com/apache/superset/commit/c2999fdc2217372f5b5499530cf25a08ca1ff945))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- chart id mapping in dashboard api ([#22179](https://github.com/apache/superset/issues/22179)) ([ac0ff78](https://github.com/apache/superset/commit/ac0ff78616119bd5d8bebbb2781e0ef3486c4d19))
- chart import error with virtual dataset ([#19782](https://github.com/apache/superset/issues/19782)) ([36d45d9](https://github.com/apache/superset/commit/36d45d9b98d57493ad9a29efb6a349902383897a))
- **chart-controls:** add a tooltip to span in ColumnOption, refactor RB Tooltips to Antd ([#914](https://github.com/apache/superset/issues/914)) ([83c0efe](https://github.com/apache/superset/commit/83c0efe0bc56eaeea7606afdb2500cf052c6b889))
- **chart-controls:** export/import DTTM_ALIAS properly ([#1035](https://github.com/apache/superset/issues/1035)) ([cd5a957](https://github.com/apache/superset/commit/cd5a95763dcbc49802903dd820b575c027fb187e))
- **chart-controls:** expose datasource for some controls ([#969](https://github.com/apache/superset/issues/969)) ([61c2f0d](https://github.com/apache/superset/commit/61c2f0d97dc486dbf2a979532a5f51efe8b35ed2))
- **chart-controls:** lower minOpacity in conditional formatting ([#1284](https://github.com/apache/superset/issues/1284)) ([128ec7e](https://github.com/apache/superset/commit/128ec7e0757725d4dca15ed2206b62e70479f055))
- **chart-controls:** temporal col placeholder for hybrid dnd ([#1317](https://github.com/apache/superset/issues/1317)) ([1411bee](https://github.com/apache/superset/commit/1411bee4221b7b1a3003bba5b89a0023c866adc1))
- **chart-controls:** transform emotion css prop ([#1036](https://github.com/apache/superset/issues/1036)) ([6f3f377](https://github.com/apache/superset/commit/6f3f377b43c9d13085cb70ec7474f3d05dcfb1f8))
- **chart-crud:** make to update Viz type Filter label to Chart type ([#19140](https://github.com/apache/superset/issues/19140)) ([b888341](https://github.com/apache/superset/commit/b8883410905a8212b9863a652c4d5a775e2a703b))
- **chart-list:** Hide 'Dashboards added to' column. ([#22475](https://github.com/apache/superset/issues/22475)) ([7a94f3a](https://github.com/apache/superset/commit/7a94f3afc611993324cb507b23a8f8c320ac76cd))
- **chart-table:** Scrollbar causing header + footer overflow ([#21064](https://github.com/apache/superset/issues/21064)) ([2679ee2](https://github.com/apache/superset/commit/2679ee2e46edf53ab07c19e1186ce2877e159303))
- **chart:** chart gets cut off on the dashboard ([#20315](https://github.com/apache/superset/issues/20315)) ([07b4a71](https://github.com/apache/superset/commit/07b4a7159dd293061b83c671ad64cc51c928a199))
- **chart:** deprecate persisting url_params ([#18960](https://github.com/apache/superset/issues/18960)) ([bd63a1b](https://github.com/apache/superset/commit/bd63a1bd98c1faf152205b3b862119a1c59b2f05))
- **chart:** ensure samples data is displayed ([#16900](https://github.com/apache/superset/issues/16900)) ([e6ff25c](https://github.com/apache/superset/commit/e6ff25c9802d5a8b523a966a66168b739a97b476))
- **chart:** import types from package, not monorepo ([#122](https://github.com/apache/superset/issues/122)) ([12ce877](https://github.com/apache/superset/commit/12ce87753038205580f07dc5323afdf70791dfd9))
- **charts list:** do not trigger ListViewError exception for anonymous users [#18210](https://github.com/apache/superset/issues/18210) ([#20171](https://github.com/apache/superset/issues/20171)) ([a813528](https://github.com/apache/superset/commit/a8135289584df2a816a98ccc1a4e1963fe3824e5))
- charts rerender with zero-height during tab switch ([#703](https://github.com/apache/superset/issues/703)) ([33d2fa1](https://github.com/apache/superset/commit/33d2fa155fbc0b3ead5c27c6f687a060ac8a56b3))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **chart:** Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([9362e27](https://github.com/apache/superset/commit/9362e27ce2ace1803a975ab289fe2024fd195367))
- check embedded feature flag in request loader ([#18628](https://github.com/apache/superset/issues/18628)) ([e86f6bb](https://github.com/apache/superset/commit/e86f6bbabcc85f7005b6af85aabdfcf93acc6e82))
- check that imports are ZIPs ([#21875](https://github.com/apache/superset/issues/21875)) ([a88dfe2](https://github.com/apache/superset/commit/a88dfe24c77a07152837094d0a3063cb2702b988))
- check type of url before performing string actions ([#19569](https://github.com/apache/superset/issues/19569)) ([aa419b8](https://github.com/apache/superset/commit/aa419b811951a5d667fa721f295f7706bfad4680))
- CI is blocked by mypy checking ([#17213](https://github.com/apache/superset/issues/17213)) ([31085e3](https://github.com/apache/superset/commit/31085e34ce3d710ba1f143b3686ecf272b93c772))
- clean up chart metadata config ([#19143](https://github.com/apache/superset/issues/19143)) ([3d66912](https://github.com/apache/superset/commit/3d66912d89851f03c38803b29128a45d66b34cb6))
- Clean up custom css when dashboard unmounted ([#19342](https://github.com/apache/superset/issues/19342)) ([a88fa89](https://github.com/apache/superset/commit/a88fa8910d8da21748f6bf9fc43b07e802a36662))
- clean up unneeded Promise.resolves() ([#185](https://github.com/apache/superset/issues/185)) ([e1c635d](https://github.com/apache/superset/commit/e1c635d9e2f88f5bdc546357d87d61382c858b6b))
- clear 'delete' confirmation ([#17345](https://github.com/apache/superset/issues/17345)) ([43f4ab8](https://github.com/apache/superset/commit/43f4ab845a9d0c5b70a58b1596319b638081ce54))
- clear modal state after adding dataset ([#17044](https://github.com/apache/superset/issues/17044)) ([16a1df7](https://github.com/apache/superset/commit/16a1df75fcb5b2d0916abe648b717add36c43b3e))
- **clickhouse:** add clickhouse connect driver ([#23185](https://github.com/apache/superset/issues/23185)) ([7d014ad](https://github.com/apache/superset/commit/7d014ad9dd41a946bd730a0de71e9e33cbb812b9))
- **clickhouse:** add missing default format ([#23192](https://github.com/apache/superset/issues/23192)) ([a94e672](https://github.com/apache/superset/commit/a94e67243b3a7c5ad46a6216ae874fe44991a0e5))
- **cli:** fail CLI script on failed import/export ([#16976](https://github.com/apache/superset/issues/16976)) ([f0c0ef7](https://github.com/apache/superset/commit/f0c0ef70483ca8f45c9a15d8fd774cb37f7f95e3)), closes [#16956](https://github.com/apache/superset/issues/16956)
- **codecov:** improve core code coverage ([#20274](https://github.com/apache/superset/issues/20274)) ([5425504](https://github.com/apache/superset/commit/54255042310b9810c09fee25d475a4a1bc8f75de))
- Color consistency ([#1406](https://github.com/apache/superset/issues/1406)) ([57e90b1](https://github.com/apache/superset/commit/57e90b1c4bb5a7f48046b08c1be583bba88ce4fd))
- Color consistency ([#17089](https://github.com/apache/superset/issues/17089)) ([59a6502](https://github.com/apache/superset/commit/59a6502efe69feee587eaa97782935a2b857ae6c))
- column extra in import/export ([#17738](https://github.com/apache/superset/issues/17738)) ([37cc2c4](https://github.com/apache/superset/commit/37cc2c4d1568ac35d145a88ce8e27d8d2d108478))
- **column-header-tooltip:** make that hide the tooltip when the cloum… ([#18988](https://github.com/apache/superset/issues/18988)) ([741033e](https://github.com/apache/superset/commit/741033e87da40331d34257fbb38c0233f2a5a1ed))
- columns are lost when dashboard to explore ([#20699](https://github.com/apache/superset/issues/20699)) ([6b0bb80](https://github.com/apache/superset/commit/6b0bb80a6d3a423104f6802f767b27d382bb8f4b))
- Columns not passing properly from SQL Lab to Explore ([#20975](https://github.com/apache/superset/issues/20975)) ([d42cf4e](https://github.com/apache/superset/commit/d42cf4e4c92e44d8ae74993780ba22807979d9bd))
- commit yarn lock change for release ([800b8eb](https://github.com/apache/superset/commit/800b8ebd9896a08bfc47616d6e7154da534e14d1))
- compatible with window ([#426](https://github.com/apache/superset/issues/426)) ([2aae804](https://github.com/apache/superset/commit/2aae804ae534f17d9e15e4c615c0ec8ad550754d))
- **connection:** disable caching when on an insecure connection ([#194](https://github.com/apache/superset/issues/194)) ([fb4a3c2](https://github.com/apache/superset/commit/fb4a3c2ec55c8eade4f3a8a77d2afcb8e8a5c7b8)), closes [#193](https://github.com/apache/superset/issues/193)
- contribution operator meets nan value ([#18782](https://github.com/apache/superset/issues/18782)) ([987740a](https://github.com/apache/superset/commit/987740aa8dfff4bf771b587a40f1e12811453660))
- controls validator glitch ([#20623](https://github.com/apache/superset/issues/20623)) ([34e1336](https://github.com/apache/superset/commit/34e1336bca39b36f4cdbea143c5e0432b3072456))
- convert <NA> values to None instead of stringifying ([#22321](https://github.com/apache/superset/issues/22321)) ([1c20206](https://github.com/apache/superset/commit/1c202060573e1bf3b4ff02f38d00c9da951f35ed))
- convert scale config to data-ui's config correctly ([#115](https://github.com/apache/superset/issues/115)) ([0dfaff8](https://github.com/apache/superset/commit/0dfaff8c2a5df28b5521e8f379edaa87fbe08092))
- Convert TIMESTAMP\_\* to TIMESTAMP in Snowflake ([#22872](https://github.com/apache/superset/issues/22872)) ([3fd4718](https://github.com/apache/superset/commit/3fd4718ecb8be2012429bac8a6132f18d8ab7d4a))
- copying controls from Sankey to Sankey Loop ([#797](https://github.com/apache/superset/issues/797)) ([3c7320e](https://github.com/apache/superset/commit/3c7320eb100efc83ebd1c03585a6505352610d63))
- core coverage and add a coverage step in workflow ([#20784](https://github.com/apache/superset/issues/20784)) ([9c7bcfc](https://github.com/apache/superset/commit/9c7bcfceadb1101899d6c09330aa8e79330d656f))
- **core:** 'AND undefined' error in sql query ([#886](https://github.com/apache/superset/issues/886)) ([c0e4d82](https://github.com/apache/superset/commit/c0e4d82fe7cb158149753d04d2223ba3f6544f8e))
- **core:** clean up datatype logic ([#1102](https://github.com/apache/superset/issues/1102)) ([a622b1d](https://github.com/apache/superset/commit/a622b1d70e4d2fcae6eb5f57408ffa1484aa828e))
- **core:** don't add metrics to query object when in raw records mode ([#995](https://github.com/apache/superset/issues/995)) ([bc30636](https://github.com/apache/superset/commit/bc30636c917e38ce9bbaf15aa7a67887971b6e8d))
- **core:** missing translation ([#1144](https://github.com/apache/superset/issues/1144)) ([9227b1e](https://github.com/apache/superset/commit/9227b1e8489b74151d721a37abcabfd97d0aad09))
- **core:** remove height and width requirement on SuperChart ([#1176](https://github.com/apache/superset/issues/1176)) ([1bd2ff6](https://github.com/apache/superset/commit/1bd2ff6abdfd1dfbc9829ae0626e4adade5fea6b))
- correct exception level in log and add error message ([#22381](https://github.com/apache/superset/issues/22381)) ([c3a6327](https://github.com/apache/superset/commit/c3a6327ff05d63c1791a5fe99fc84878e426a346))
- Correct Ukraine map ([#19528](https://github.com/apache/superset/issues/19528)) ([cccec9a](https://github.com/apache/superset/commit/cccec9a6ab8eadea2ecaac6ee2094c8eb7d6b1f4))
- correction from mmsql to mssql in setup.py ([#20493](https://github.com/apache/superset/issues/20493)) ([5a2abfa](https://github.com/apache/superset/commit/5a2abfab65f5eac95a4376ab2319528ba82975f1))
- **cosmetic:** cannot find m-r-10 class in superset.less ([#20276](https://github.com/apache/superset/issues/20276)) ([f6f93aa](https://github.com/apache/superset/commit/f6f93aad37e6258ec27af1b39335d0de9163210d))
- **cosmetic:** Fix Datasource Modal Out Of Box ([#20237](https://github.com/apache/superset/issues/20237)) ([5c02ab7](https://github.com/apache/superset/commit/5c02ab7aafd3909cf341ad38c70a69076fb50d03))
- **cosmetic:** Limiting modal height ([#20147](https://github.com/apache/superset/issues/20147)) ([c8fe518](https://github.com/apache/superset/commit/c8fe518a7b55fe48545228dca6cf4f7c400f04e6))
- count(distinct column_name) in metrics ([#19842](https://github.com/apache/superset/issues/19842)) ([25e572a](https://github.com/apache/superset/commit/25e572a56e8cca1c9dd466fcd64ad610e86a385c))
- **cpq:** Add `schema` to Query.data() payload ([#22791](https://github.com/apache/superset/issues/22791)) ([88a5d98](https://github.com/apache/superset/commit/88a5d987da331e96dd94dee42937847dc0cfb0d4))
- Crash caused by numpy.vectorize ([#21936](https://github.com/apache/superset/issues/21936)) ([059e53a](https://github.com/apache/superset/commit/059e53a39f8c46051efba56d0866b25285fd6623))
- Create dataset polish/bug fix ([#22262](https://github.com/apache/superset/issues/22262)) ([6b20e74](https://github.com/apache/superset/commit/6b20e7444205498077014c0382dcccb485c49bf2))
- create property for schema_perm for `Query` ([#20871](https://github.com/apache/superset/issues/20871)) ([35184b2](https://github.com/apache/superset/commit/35184b299478edd44ee1c9d970f0d53ddc93ac86))
- create virtual table with exotic type ([#19714](https://github.com/apache/superset/issues/19714)) ([2b17ce2](https://github.com/apache/superset/commit/2b17ce2bd0d646196261dd02fd23080a6563e499))
- create-admin command in Makefile ([#17471](https://github.com/apache/superset/issues/17471)) ([7b68002](https://github.com/apache/superset/commit/7b68002eb143c6982870c12a153fdb2284faf172))
- **CRUD/listviews:** Errors with rison and search strings using special characters ([#18056](https://github.com/apache/superset/issues/18056)) ([c8df849](https://github.com/apache/superset/commit/c8df84985cf4f16f66287c493ba616b7d47a7c63))
- **CRUD:** make to fix the dancing when crud view is on hover ([#20051](https://github.com/apache/superset/issues/20051)) ([1c3c3ae](https://github.com/apache/superset/commit/1c3c3ae2ea1541b3719f303dd211e159adee3792))
- css template API response, less data ([#17980](https://github.com/apache/superset/issues/17980)) ([d35da1f](https://github.com/apache/superset/commit/d35da1fc733547533ceb883a35e7142069b3da26))
- css template permissions for gamma role ([#23083](https://github.com/apache/superset/issues/23083)) ([c39cf36](https://github.com/apache/superset/commit/c39cf36d2718133a57bbd37f54832d6cecfda414))
- **css:** transparent linear gradient not working in safari ([#20086](https://github.com/apache/superset/issues/20086)) ([ce01ce9](https://github.com/apache/superset/commit/ce01ce9e2f6859b3435e6ffb5425d1c29144442c))
- **csv-export:** pivot v2 with verbose names ([#18633](https://github.com/apache/superset/issues/18633)) ([fdbcbb5](https://github.com/apache/superset/commit/fdbcbb5c84f998666fd325ac14bc10d2cbdb2288))
- **csv:** Do not coerce persisted data integer columns to float ([#20760](https://github.com/apache/superset/issues/20760)) ([e1fd906](https://github.com/apache/superset/commit/e1fd90697c1ed4f72e7982629779783ad9736a47))
- **csv:** Ensure df_to_escaped_csv handles NULL ([#20151](https://github.com/apache/superset/issues/20151)) ([97ce920](https://github.com/apache/superset/commit/97ce920d493d126ddcff93b9e46cdde1c5c8bb69))
- custom SQL in Sort By Breaks Bar Chart ([#19069](https://github.com/apache/superset/issues/19069)) ([4f0074a](https://github.com/apache/superset/commit/4f0074a4aec7bf0868c3032ef00c4eb92930422a))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **CustomFrame:** Resolves issue [#21731](https://github.com/apache/superset/issues/21731) where date range in explore throws runtime error ([#21776](https://github.com/apache/superset/issues/21776)) ([2258fbf](https://github.com/apache/superset/commit/2258fbf8789439f3223a67ecac24722bac415408))
- customize tab on heatmap chart is blank ([#23243](https://github.com/apache/superset/issues/23243)) ([d670cb6](https://github.com/apache/superset/commit/d670cb6a7f9f9777c4c63ea9796c1963bd79c97c))
- Cypress tests reliability improvements ([#19800](https://github.com/apache/superset/issues/19800)) ([3f0413b](https://github.com/apache/superset/commit/3f0413b8cbf54bac94ea52dd9d49f07f835e6f0a))
- **cypress:** disable flaky tests ([#22512](https://github.com/apache/superset/issues/22512)) ([630c129](https://github.com/apache/superset/commit/630c129e3e3e8a48c22d754e5d9943583ac0dae4))
- **cypress:** Fix failing/flaky E2E tests ([#22460](https://github.com/apache/superset/issues/22460)) ([21b56b2](https://github.com/apache/superset/commit/21b56b2d4993e2556e27a0849c91c570adf68d6c))
- **cypress:** flake cypress test case ([#17918](https://github.com/apache/superset/issues/17918)) ([eff4d38](https://github.com/apache/superset/commit/eff4d387de1501d21b4bd51e3a77541b425e79cc))
- **cypress:** make test chart time range deterministic ([#22567](https://github.com/apache/superset/issues/22567)) ([38d02a1](https://github.com/apache/superset/commit/38d02a10b5abbe325dfac4ecc227d6a2b5db5aaa))
- d3 scale types ([#246](https://github.com/apache/superset/issues/246)) ([f8bd7c6](https://github.com/apache/superset/commit/f8bd7c60651f5ce20aa98906cdab353bdc0a0135))
- **dao:** use explicit id filter ([#23246](https://github.com/apache/superset/issues/23246)) ([a336e68](https://github.com/apache/superset/commit/a336e685cd36bc985c1accb68da6d70cfbfc60c8))
- dashbaord unable to refresh ([#20220](https://github.com/apache/superset/issues/20220)) ([3d5ae62](https://github.com/apache/superset/commit/3d5ae6226bc5035fc86d3d3aa2cbc0202bede363))
- Dashboad export loading indicator ([#17613](https://github.com/apache/superset/issues/17613)) ([76cd7b0](https://github.com/apache/superset/commit/76cd7b048133989a6fb9777de53e2420af867df1))
- Dashboard access when DASHBOARD_RBAC is disabled ([#17511](https://github.com/apache/superset/issues/17511)) ([7602431](https://github.com/apache/superset/commit/76024313c6677824394813ba107bf442ac65974b))
- dashboard api cache decorator ([#21964](https://github.com/apache/superset/issues/21964)) ([c9470ca](https://github.com/apache/superset/commit/c9470cac91943599972d2854db747e3f4d25c206))
- Dashboard API flaky test ([#17611](https://github.com/apache/superset/issues/17611)) ([78c5d9a](https://github.com/apache/superset/commit/78c5d9ac277a3c9ba2ac72c0af30b15842e1fa4b))
- Dashboard Edit View Tab Headers Hidden when Dashboard Name is Long ([#19472](https://github.com/apache/superset/issues/19472)) ([154f1ea](https://github.com/apache/superset/commit/154f1ea8c92e38ba46a906d2121a85a1c9fac310))
- dashboard filter value is cleared when 2 similar dashboards opened in succession ([#21461](https://github.com/apache/superset/issues/21461)) ([59ca786](https://github.com/apache/superset/commit/59ca7861c0ec47a574c9f033a843ea1b726752f2))
- dashboard get by id or slug access filter ([#22358](https://github.com/apache/superset/issues/22358)) ([3761694](https://github.com/apache/superset/commit/3761694d72ba77332d9af68ec67fb178a25b1292))
- Dashboard import holding issue ([#19112](https://github.com/apache/superset/issues/19112)) ([e118b4d](https://github.com/apache/superset/commit/e118b4d733c6355127b6a1713c50a423168b5f42))
- **dashboard list:** do not show favorite star for anonymous users [#18210](https://github.com/apache/superset/issues/18210) ([#19409](https://github.com/apache/superset/issues/19409)) ([b8891ac](https://github.com/apache/superset/commit/b8891acf4a478da8883bd168272715023d6a3351))
- Dashboard report creation error handling ([#19859](https://github.com/apache/superset/issues/19859)) ([ad878b0](https://github.com/apache/superset/commit/ad878b07e48edb4059fbc6620accd2f7b993ae4b))
- dashboard standalone class not added when parameter set ([#16619](https://github.com/apache/superset/issues/16619)) ([5134c63](https://github.com/apache/superset/commit/5134c63ae289a583e52ddd692848461f227aec50))
- dashboard top level tabs edit ([#19722](https://github.com/apache/superset/issues/19722)) ([1c5d3b7](https://github.com/apache/superset/commit/1c5d3b73df3553d481fc59d89f94ad15193f5775))
- **dashboard-css:** make to load saved css template ([#19840](https://github.com/apache/superset/issues/19840)) ([4a835a4](https://github.com/apache/superset/commit/4a835a4299bbe90def232e376f919bc494b2d0a1))
- **dashboard-css:** make to stay custom css when reload ([#19084](https://github.com/apache/superset/issues/19084)) ([30c97ad](https://github.com/apache/superset/commit/30c97ad5bfe1dc9b074efc294c647c32fdd05fe0))
- **dashboard:** Add correct icon, label and badge to horizontal native filters dropdown button ([#22211](https://github.com/apache/superset/issues/22211)) ([435926b](https://github.com/apache/superset/commit/435926b89e08395f3017a32ea00f3de252fd4fb7))
- **dashboard:** Add runtime safety checks and improved tests ([#22457](https://github.com/apache/superset/issues/22457)) ([fad873c](https://github.com/apache/superset/commit/fad873c100cb35912308a5c700a2d49831506e3a))
- **dashboard:** Add safety checks to areas that throw runtime errors in dashboard filters ([#22648](https://github.com/apache/superset/issues/22648)) ([02e8511](https://github.com/apache/superset/commit/02e8511563767aa88fe83facbdaaba9a363ec1b8))
- **dashboard:** add toast if JSON metadata is invalid ([#20823](https://github.com/apache/superset/issues/20823)) ([557cf4b](https://github.com/apache/superset/commit/557cf4b739a8a7933f947a034812e295a0ae95cb))
- **dashboard:** Change horizontal filter bar divider truncation logic ([#22252](https://github.com/apache/superset/issues/22252)) ([91d1905](https://github.com/apache/superset/commit/91d19056cf236e78230228e26b3358060e626499))
- **dashboard:** Change text and icons in dashboard editmode ([#21305](https://github.com/apache/superset/issues/21305)) ([1d70079](https://github.com/apache/superset/commit/1d70079f7162fe42f83914fc0e63a265e5ac35bf))
- **dashboard:** chart doesn't resize when tab switch ([#22009](https://github.com/apache/superset/issues/22009)) ([309c064](https://github.com/apache/superset/commit/309c064cc808e7402cf1ec8370652045bab8fb43))
- **dashboard:** Chart stuck in loading state when when datasets request and chart request fail ([#19327](https://github.com/apache/superset/issues/19327)) ([a08f83b](https://github.com/apache/superset/commit/a08f83bc608f02ab29a2f1eb433d0405eea6f721))
- **dashboard:** Charts crashing when cross filter on adhoc column is applied ([#23238](https://github.com/apache/superset/issues/23238)) ([224f962](https://github.com/apache/superset/commit/224f962e4641bbfe6eff807745262fc03a0f9b92))
- **dashboard:** commit update once ([#17781](https://github.com/apache/superset/issues/17781)) ([3657cbe](https://github.com/apache/superset/commit/3657cbea7f5c37ccc06280b6c5230c1fdad76f9e))
- **Dashboard:** Copy dashboard with duplicating charts 500 error ([#17707](https://github.com/apache/superset/issues/17707)) ([dad8c20](https://github.com/apache/superset/commit/dad8c20af78f237cd068e29e1bbe6bbf37a238eb))
- **dashboard:** copy permalink to dashboard chart ([#19772](https://github.com/apache/superset/issues/19772)) ([e061955](https://github.com/apache/superset/commit/e061955fd077a9eab6f22f081aa02690801bfd3e))
- **dashboard:** dashboard actions fail when bad component id exists in children array ([#22323](https://github.com/apache/superset/issues/22323)) ([92bc641](https://github.com/apache/superset/commit/92bc6410671d3512e66303e80ce43a77a687adab))
- **dashboard:** dashboard doesn't load properly if it has tabs ([#21576](https://github.com/apache/superset/issues/21576)) ([24412e2](https://github.com/apache/superset/commit/24412e282d60fe2089fdc78d5d7b91f37344c41d))
- **dashboard:** Dashboard header overflowing in edit mode ([#21100](https://github.com/apache/superset/issues/21100)) ([d3684c0](https://github.com/apache/superset/commit/d3684c0937cf3f10654d8bba6a859e95d7dba7d8))
- **dashboard:** Don't show cross filters checkbox to users without write permissions ([#23237](https://github.com/apache/superset/issues/23237)) ([bac5bab](https://github.com/apache/superset/commit/bac5babff80c6aff49d68c0550517038c78bfe74))
- **dashboard:** don't show report modal for anonymous user ([#17106](https://github.com/apache/superset/issues/17106)) ([8756c90](https://github.com/apache/superset/commit/8756c9089ea765454cebcb8ab76fffddb86f916a))
- **dashboard:** drag preview not working ([#21432](https://github.com/apache/superset/issues/21432)) ([99628d3](https://github.com/apache/superset/commit/99628d3e84930e1a3751e9e8c9648a82d4f7ec1b))
- **dashboard:** Empty states overflowing small chart containers ([#19095](https://github.com/apache/superset/issues/19095)) ([70081a6](https://github.com/apache/superset/commit/70081a698fd423ab953d0943fc15ce88c24311ae))
- **dashboard:** Ensure correct positioning of "Drill to detail by" submenu ([#21894](https://github.com/apache/superset/issues/21894)) ([40f8254](https://github.com/apache/superset/commit/40f82545abf385f24a8681b6655ceb5042e1f3a7))
- **dashboard:** export & import chart description and certification details ([#22471](https://github.com/apache/superset/issues/22471)) ([efe6d22](https://github.com/apache/superset/commit/efe6d22d4a9c789d4262f197d01709a820332cf0))
- **dashboard:** Fix BigNumber causing dashboard to crash when overflowing ([#19688](https://github.com/apache/superset/issues/19688)) ([ee85466](https://github.com/apache/superset/commit/ee85466f2ed45d3f51a7609ef4e30cf087c033e4))
- **Dashboard:** Fix blinking native filters on zoom ([#18717](https://github.com/apache/superset/issues/18717)) ([db33953](https://github.com/apache/superset/commit/db339534ca4764d8c32934737a7fc54d82a4c775))
- **dashboard:** Fix dashboard's left side being cut off ([#22319](https://github.com/apache/superset/issues/22319)) ([b2d909f](https://github.com/apache/superset/commit/b2d909f529bb18f87dac88e8f4eccf6bb88de693))
- **dashboard:** fix default filter bar visibility + add docs ([#18741](https://github.com/apache/superset/issues/18741)) ([b7ecb14](https://github.com/apache/superset/commit/b7ecb14230383da679a3f61e38faa33cdb5014f7))
- **dashboard:** Fix filter card positioning for horizontal native filters ([#22212](https://github.com/apache/superset/issues/22212)) ([4b96474](https://github.com/apache/superset/commit/4b96474d6c9d405bc2dbf8e899d2b7486bf5f213))
- **dashboard:** Fix FilterWithDataMask typing and add null check ([#22260](https://github.com/apache/superset/issues/22260)) ([a642d12](https://github.com/apache/superset/commit/a642d126f8019d8f96cc206abfeda7ddc19eda7f))
- **dashboard:** Fix hover labels for horizontal overflow native filter dividers ([#22210](https://github.com/apache/superset/issues/22210)) ([93158ea](https://github.com/apache/superset/commit/93158ea6495d86950eb7faf7ad7c0968846fd96a))
- **dashboard:** fix Pivot Table V2 dragPreview in the dashboard ([#21539](https://github.com/apache/superset/issues/21539)) ([ab53d77](https://github.com/apache/superset/commit/ab53d77abacaf03e67c5a922c1e9dbd9a62fedbf))
- **dashboard:** Fix scroll behaviour in DashboardBuilderSidepane ([#20969](https://github.com/apache/superset/issues/20969)) ([6f3a555](https://github.com/apache/superset/commit/6f3a555e589cd8caee7ef6d5e667531b5e7ac43d))
- **dashboard:** Fix scrolling on "View as table" modal ([#21282](https://github.com/apache/superset/issues/21282)) ([875e9f8](https://github.com/apache/superset/commit/875e9f8a04464b0e79cfbda21d1e1ac7895970a5))
- **dashboard:** Focusing charts and native filters from filters badge ([#23190](https://github.com/apache/superset/issues/23190)) ([22bab71](https://github.com/apache/superset/commit/22bab714d6de0d3bb7e806dbec5187c96db37bf3))
- **dashboard:** Force native filters into vertical orientation when FF off ([#22265](https://github.com/apache/superset/issues/22265)) ([969c963](https://github.com/apache/superset/commit/969c9634f6a370cde8f0036af61d96375ec5c4c8))
- **dashboard:** import handle missing excluded charts ([#19088](https://github.com/apache/superset/issues/19088)) ([999c2c6](https://github.com/apache/superset/commit/999c2c68264cf7092aa1e98eef16f0a74b90cb64))
- **dashboard:** incorrect chart error with slow dataset api request ([#18852](https://github.com/apache/superset/issues/18852)) ([cdd4fa5](https://github.com/apache/superset/commit/cdd4fa58d0eea1aa27a00c4d2f2e94aa9e229fd9))
- **dashboard:** Incorrect scopes of cross filters ([#20927](https://github.com/apache/superset/issues/20927)) ([90e2d82](https://github.com/apache/superset/commit/90e2d82a38508938c7dcc92bad0087b529489fce))
- **dashboard:** Infinite load when filter with default first value is out of scope ([#23299](https://github.com/apache/superset/issues/23299)) ([81a1318](https://github.com/apache/superset/commit/81a13189b0407acdaae94e8fb4e037131c85c11f))
- **dashboard:** JS error when editing charts ([#21422](https://github.com/apache/superset/issues/21422)) ([1084bde](https://github.com/apache/superset/commit/1084bde2cc9600ec400505f7c11fac7d70f2f0c2))
- **dashboard:** make to filter the correct certified or non-certified… ([#19429](https://github.com/apache/superset/issues/19429)) ([3ccfa56](https://github.com/apache/superset/commit/3ccfa564d710480b55898d6e3ac42ccdd4ccdbcf))
- **dashboard:** make to show the correct owned objects ([#19223](https://github.com/apache/superset/issues/19223)) ([29cba2b](https://github.com/apache/superset/commit/29cba2b00cc4a68bf89740e34e3b107384616380))
- **dashboard:** make to show the correct owned objects ([#19372](https://github.com/apache/superset/issues/19372)) ([6d89ffb](https://github.com/apache/superset/commit/6d89ffbcb7533dc04093a66852aab26db0b5bc11))
- **dashboard:** Native filter on the dashboard with multiple tabs is displayed as out of scope ([#20693](https://github.com/apache/superset/issues/20693)) ([effa7d9](https://github.com/apache/superset/commit/effa7d9f5822c8b837877b23d4866d6d30de6267))
- **dashboard:** new created chart did not have high lighted effect when using the permalink of chart share in dashboard ([#20411](https://github.com/apache/superset/issues/20411)) ([c2f01a6](https://github.com/apache/superset/commit/c2f01a676c5e5eb53b98a6a609674c8342f8a0ac))
- **Dashboard:** Only apply changes when editing properties ([#17392](https://github.com/apache/superset/issues/17392)) ([0712be4](https://github.com/apache/superset/commit/0712be4c124ff90152d80c8bb11444415db4a7c7))
- **dashboard:** padding between rows within tabs ([#21323](https://github.com/apache/superset/issues/21323)) ([d994bab](https://github.com/apache/superset/commit/d994babe754a0a8fcf54d239cb4c558ccdf84b23))
- **dashboard:** Prevent XSS attack vector ([#21822](https://github.com/apache/superset/issues/21822)) ([ec20c01](https://github.com/apache/superset/commit/ec20c0104e6913cd9b2ab8bacae22eb25ae4cce1))
- **dashboard:** race condition between hydrating dashboard and set active tabs ([#17084](https://github.com/apache/superset/issues/17084)) ([3ad7483](https://github.com/apache/superset/commit/3ad7483dc19b75afe40df80eab10523c9a13485f))
- **dashboard:** Race condition when setting activeTabs with nested tabs ([#17007](https://github.com/apache/superset/issues/17007)) ([45908ff](https://github.com/apache/superset/commit/45908ff104efbd881fa1221278fba78989b43a52))
- **dashboard:** Remove bar at bottom of dashboard edit sidebar ([#21807](https://github.com/apache/superset/issues/21807)) ([95b4323](https://github.com/apache/superset/commit/95b43238a04e2b5c27bd6ab45dccfc23fab624a2))
- **dashboard:** Return columns and verbose_map for groupby values of Pivot Table v2 [ID-7] ([#17287](https://github.com/apache/superset/issues/17287)) ([fa51b32](https://github.com/apache/superset/commit/fa51b3234ed83a5f2910951f4cd2b1676a7b7d6d))
- **Dashboard:** Save empty label_colors in json_metadata ([#17462](https://github.com/apache/superset/issues/17462)) ([b2363e4](https://github.com/apache/superset/commit/b2363e4151f7a79d7235954366142db90f54c3c8))
- **dashboard:** scope of nativefilter not update ([#18048](https://github.com/apache/superset/issues/18048)) ([3b64563](https://github.com/apache/superset/commit/3b64563f3f9427e1d8f6f5f670f05e19bf9cb705))
- **dashboard:** scope status of filter not update in dashboard metadata ([#17945](https://github.com/apache/superset/issues/17945)) ([bd9e123](https://github.com/apache/superset/commit/bd9e1235a9e5b798ec1ba3a4d9c0660187bedeed))
- **dashboard:** scrolling table viz overlaps next chart ([#19121](https://github.com/apache/superset/issues/19121)) ([74910f9](https://github.com/apache/superset/commit/74910f99d8e1fe0c054780848927b4b54554cec9))
- **dashboard:** show correct roles for dashboard access dropdown ([#21549](https://github.com/apache/superset/issues/21549)) ([73429c6](https://github.com/apache/superset/commit/73429c6b2a63edc5a119eceafebdae2bc7431cd4))
- **Dashboard:** Sidepanel positioning ([#17200](https://github.com/apache/superset/issues/17200)) ([a2a457b](https://github.com/apache/superset/commit/a2a457b7efdd586af348c40bf9f099dcf6e1f20d))
- **dashboard:** Stop updating chart owners for charts removed from dashboard ([#21720](https://github.com/apache/superset/issues/21720)) ([684b888](https://github.com/apache/superset/commit/684b8888b1f60b5e9d440cdd07ecc6c116fcd542))
- **dashboard:** support input undo when editing chart title ([#18137](https://github.com/apache/superset/issues/18137)) ([a2bad75](https://github.com/apache/superset/commit/a2bad7551e4c17f7d7f6677d30e72caf0fe7667a))
- **dashboard:** update native filter info in metadata is not updated ([#17842](https://github.com/apache/superset/issues/17842)) ([ec48dd5](https://github.com/apache/superset/commit/ec48dd5c4083c6d0ad80a54bc382678f688677e2))
- **dashboard:** Update owners of dashboard list after editing ([#22383](https://github.com/apache/superset/issues/22383)) ([9f3c43f](https://github.com/apache/superset/commit/9f3c43f839f4f57981839151ce0a416973b3394d))
- **dashobard-edge-cutting:** make to be not cut without Filter ([#19080](https://github.com/apache/superset/issues/19080)) ([158396f](https://github.com/apache/superset/commit/158396fb6cce49a146d2c73b34c8eb3946163a90))
- **data-upload:** make to change err message ([#19430](https://github.com/apache/superset/issues/19430)) ([5fc0651](https://github.com/apache/superset/commit/5fc0651aaba9f2d7ed6605bea9cc44254cd6e02f))
- database modal crashed when use SQLAlchemy URI string ([#21342](https://github.com/apache/superset/issues/21342)) ([d130b4a](https://github.com/apache/superset/commit/d130b4a24f67a6440101f267d2d3640e34f4a154))
- database permissions on update and delete (avoid orphaned perms) ([#20081](https://github.com/apache/superset/issues/20081)) ([bfd2a3d](https://github.com/apache/superset/commit/bfd2a3d79f3d6d9c1da616d6d7904b48eccee28c))
- database schema selector on import data ([#21759](https://github.com/apache/superset/issues/21759)) ([91f0de0](https://github.com/apache/superset/commit/91f0de0c5dc81b1d644265c829d3b486fc1ba951))
- Database selector overflow ([#17369](https://github.com/apache/superset/issues/17369)) ([ed4a628](https://github.com/apache/superset/commit/ed4a628861728a6366bc165b291759986c843b76))
- **database-api:** allow search for all columns ([#19662](https://github.com/apache/superset/issues/19662)) ([3a231f6](https://github.com/apache/superset/commit/3a231f6b871cdab00b9dfb6192af76cf4cf9832a))
- **database-list:** hidden upload file button if no permission ([#21216](https://github.com/apache/superset/issues/21216)) ([0c43190](https://github.com/apache/superset/commit/0c43190e04edc182f8787cc88d9a6fcf7f86a9f7))
- **database-modal:** 'CTAS & CVAS SCHEMA' getting cut off ([#21004](https://github.com/apache/superset/issues/21004)) ([5c2a1f8](https://github.com/apache/superset/commit/5c2a1f85ffe675d36ddb906b4532428736235f02))
- **database-modal:** forms in database modal will be effected by external form values ([#20487](https://github.com/apache/superset/issues/20487)) ([932e304](https://github.com/apache/superset/commit/932e304ffbd14c46b2d816743c50c6aa7832fca2))
- **database-modal:** Refresh Data when importing ([#20523](https://github.com/apache/superset/issues/20523)) ([850f5fa](https://github.com/apache/superset/commit/850f5fa136aa2043a146fed0d5f58f6b2a9de96b))
- **database-modal:** Show a different placeholder text in Snowflake connection form ([#21172](https://github.com/apache/superset/issues/21172)) ([da3401a](https://github.com/apache/superset/commit/da3401a6987538fa69e791cd1096a4400972a424))
- **database:** Handle String errors in DatabaseModal ([#21709](https://github.com/apache/superset/issues/21709)) ([97273f5](https://github.com/apache/superset/commit/97273f59f867a9b329370b903e3616c24b43a5bc))
- **database:** make to allow the expose db as default in sqlalchemy form db ([#19337](https://github.com/apache/superset/issues/19337)) ([5ae7e54](https://github.com/apache/superset/commit/5ae7e5499966c9e01d5e42a61edf1ce94dd346fa))
- **database:** make to display validation error msg when all cases ([#20095](https://github.com/apache/superset/issues/20095)) ([d568999](https://github.com/apache/superset/commit/d568999592bb687d862dcfbf6f76c7ff7ee5610d))
- **databases:** GSheets and Clickhouse DBs are not allowed to upload files ([#21065](https://github.com/apache/superset/issues/21065)) ([b36bd3f](https://github.com/apache/superset/commit/b36bd3f083d0b2c125f472c23caa39b035ee5f27))
- Databricks views showing up as tables ([#20674](https://github.com/apache/superset/issues/20674)) ([2c5201f](https://github.com/apache/superset/commit/2c5201fa4bf31091d4fe4ce31f81b4a354f0cbfe))
- dataset after insert when db relation does not exist ([#21492](https://github.com/apache/superset/issues/21492)) ([7e2e8b8](https://github.com/apache/superset/commit/7e2e8b8ad95e868e40b6692653ead5a7e1d75b13))
- Dataset creation header is now uneditable and holds proper default values ([#21557](https://github.com/apache/superset/issues/21557)) ([df3b5a8](https://github.com/apache/superset/commit/df3b5a8305bc5339e094bf30025801e48c78951e))
- Dataset duplication fatal error ([#21358](https://github.com/apache/superset/issues/21358)) ([e3ddd0b](https://github.com/apache/superset/commit/e3ddd0bdd5f8f976e0a1733f6da29e33a2545c27))
- dataset exists error in save Dataset modal ([#21244](https://github.com/apache/superset/issues/21244)) ([a7fe485](https://github.com/apache/superset/commit/a7fe4850edef65128d12e20469e8a9b86ef08408))
- dataset extra import/export ([#17740](https://github.com/apache/superset/issues/17740)) ([c49545a](https://github.com/apache/superset/commit/c49545aec1ecddc6ee0e6a55597d8f26c2680009))
- dataset import error message ([#23025](https://github.com/apache/superset/issues/23025)) ([7bb9b81](https://github.com/apache/superset/commit/7bb9b810ee7dc9292b375cab28d8a559d030f87c))
- Dataset left panel now uses client side search ([#21770](https://github.com/apache/superset/issues/21770)) ([8f4415b](https://github.com/apache/superset/commit/8f4415bc831d234965001a476acc0c123448aee9))
- dataset modal doesn't work in dev mode ([#18658](https://github.com/apache/superset/issues/18658)) ([8212975](https://github.com/apache/superset/commit/82129753b07730a439fd88f26332a48692137044))
- dataset name change and permission change ([#21161](https://github.com/apache/superset/issues/21161)) ([3f2e894](https://github.com/apache/superset/commit/3f2e894af3dbb7a5c714de46240243b91d3d579c))
- Dataset search when creating a chart ([#19065](https://github.com/apache/superset/issues/19065)) ([fd154f7](https://github.com/apache/superset/commit/fd154f7ba63d41eae7a6774d72e85cd42e0d8a22))
- Dataset timeout ([#21516](https://github.com/apache/superset/issues/21516)) ([94ed427](https://github.com/apache/superset/commit/94ed4279c7d69a4f72fd5db5fe69eb27a55d24c9))
- **dataset:** avoid crash if database missing ([#19582](https://github.com/apache/superset/issues/19582)) ([db21351](https://github.com/apache/superset/commit/db2135109a2b41240547653c845854422adaa92b))
- **dataset:** handle missing database in migration ([#18948](https://github.com/apache/superset/issues/18948)) ([2bacedd](https://github.com/apache/superset/commit/2baceddbf16f087ae9247406f23579a6c6664fb6))
- **dataset:** handle missing python_type gracefully ([#19553](https://github.com/apache/superset/issues/19553)) ([d9343a4](https://github.com/apache/superset/commit/d9343a463980cf8b09ed394554fb54200027cc70))
- **dataset:** handle missing sqla uri in migration ([#20073](https://github.com/apache/superset/issues/20073)) ([4435e53](https://github.com/apache/superset/commit/4435e53901df4d64992a540694fbd3d5489c2220))
- **dataset:** modal sql editor error ([#17612](https://github.com/apache/superset/issues/17612)) ([b5d13d7](https://github.com/apache/superset/commit/b5d13d72f209132b6a334bf1978e96cbc06026d9))
- **datasets:** Fix property selection on JSON response ([#22944](https://github.com/apache/superset/issues/22944)) ([b410dbb](https://github.com/apache/superset/commit/b410dbb5dd510f1ed1dce6b2d0e114dda263eedb))
- **datasets:** Include expression and description in duplicated dataset columns ([#22943](https://github.com/apache/superset/issues/22943)) ([4b05a1e](https://github.com/apache/superset/commit/4b05a1eddd9d71811f0169d7b122cff26f7cc923))
- **datasets:** Stop showing alert when saving from query ([#21442](https://github.com/apache/superset/issues/21442)) ([605b692](https://github.com/apache/superset/commit/605b6920a65e0ef152a4c3f3d09246e5c596437d))
- datasource save, improve data validation ([#22038](https://github.com/apache/superset/issues/22038)) ([e33a086](https://github.com/apache/superset/commit/e33a08693bf789284d21f493074263712f17116f))
- datasourcedao datasource not found error ([#20725](https://github.com/apache/superset/issues/20725)) ([1d9d505](https://github.com/apache/superset/commit/1d9d505a6efa458d8b3b8a5743489bc1d03e1181))
- datatable crash when column is empty string ([#17303](https://github.com/apache/superset/issues/17303)) ([1f2a7a4](https://github.com/apache/superset/commit/1f2a7a40c4e64063c12dfe95bb39e2b6e06c3ec2))
- **datatable:** adding the consideration of padding ([#198](https://github.com/apache/superset/issues/198)) ([ddbd50f](https://github.com/apache/superset/commit/ddbd50f4feabe3da900050d5dc7a0a902ee5d6cd))
- datatype tracking issue on virtual dataset ([#20088](https://github.com/apache/superset/issues/20088)) ([74c5479](https://github.com/apache/superset/commit/74c5479926d89cebe5bad193123d8ecaff65f360))
- Dates alignment in Table viz ([#19668](https://github.com/apache/superset/issues/19668)) ([ed1309e](https://github.com/apache/superset/commit/ed1309e6bd9e8c0365794cf12bf4a272e540bbbd))
- datetime value should be seconds in sqlite ([#21113](https://github.com/apache/superset/issues/21113)) ([1afcdfb](https://github.com/apache/superset/commit/1afcdfb9fa47184f4ee54a57fa9d1985bb2ec6df))
- datetime.data in series ([#20618](https://github.com/apache/superset/issues/20618)) ([414cc99](https://github.com/apache/superset/commit/414cc99ca20a314f32c8796895955cf0a98b9785))
- **db & connection:** make to show/hide the password when only creating db connection ([#19694](https://github.com/apache/superset/issues/19694)) ([1d043e5](https://github.com/apache/superset/commit/1d043e53d09f444f15a083ebb961faff092147a5))
- DB connection modal connect bug ([#21299](https://github.com/apache/superset/issues/21299)) ([99a4f05](https://github.com/apache/superset/commit/99a4f05069d4b9de0b266a035423e3165408b4c3))
- **db-migration:** new_dataset_models_take_2 error on postgres ([#21417](https://github.com/apache/superset/issues/21417)) ([2e5270c](https://github.com/apache/superset/commit/2e5270cdb0486391037d225e808987c4b0573d2f))
- **db:** make to allow to show/hide the password when only creating ([#20186](https://github.com/apache/superset/issues/20186)) ([95b28fc](https://github.com/apache/superset/commit/95b28fc1346939017f8f6d867abeb12c7704d846))
- dbmodal test connection error timeout ([#20068](https://github.com/apache/superset/issues/20068)) ([5111011](https://github.com/apache/superset/commit/5111011de9de614e68c3c373dc9e938a9df3791f))
- **dbs-dropdown:** make to allow the search in supported db dropdown ([#19125](https://github.com/apache/superset/issues/19125)) ([8e7af79](https://github.com/apache/superset/commit/8e7af79aa9eadafe5def8dd7bac593f0b5f55776))
- **db:** set slices.query_context to MEDIUMTEXT for mysql ([#20779](https://github.com/apache/superset/issues/20779)) ([a64cdec](https://github.com/apache/superset/commit/a64cdec8c299cd572c12a271b695b1a83c521cee))
- **db:** Show the only db install guide when the db is already installed and error is existed while importing file. ([#20442](https://github.com/apache/superset/issues/20442)) ([23e62d3](https://github.com/apache/superset/commit/23e62d3782e75f1ed6c7baf0d511b4464249dbf3))
- **db:** use paginated_update for area chart migration ([#20761](https://github.com/apache/superset/issues/20761)) ([e2d3ea8](https://github.com/apache/superset/commit/e2d3ea831a7c634aeb2364a469a142c3514e4cf3))
- deactivate embedding on a dashboard ([#19626](https://github.com/apache/superset/issues/19626)) ([ae70212](https://github.com/apache/superset/commit/ae70212df31e4e483a9c316898419a55389fe619))
- deck.gl GeoJsonLayer Autozoom & fill/stroke options ([#19778](https://github.com/apache/superset/issues/19778)) ([d65b77e](https://github.com/apache/superset/commit/d65b77ec7dac4c2368fcaa1fe6e98db102966198))
- **deck.gl:** multiple layers map size is shrunk ([#18939](https://github.com/apache/superset/issues/18939)) ([2cb3635](https://github.com/apache/superset/commit/2cb3635256ee8e91f0bac2f3091684673c04ff2b))
- **deck.gl:** update view state on property changes ([#17720](https://github.com/apache/superset/issues/17720)) ([#17826](https://github.com/apache/superset/issues/17826)) ([97d918b](https://github.com/apache/superset/commit/97d918b6927f572dca3b33c61b89c8b3ebdc4376))
- **deckgl:** deckgl unable to load map ([#17851](https://github.com/apache/superset/issues/17851)) ([52f5dcb](https://github.com/apache/superset/commit/52f5dcb58eec7b188f4387b8781dcda4252a5680))
- Default temporal column in Datasource ([#21857](https://github.com/apache/superset/issues/21857)) ([fa67315](https://github.com/apache/superset/commit/fa67315f5b4769b2d739da23ef253fd504d610d9))
- **delete-modal:** Changed the color of the help text with grayScale.dark1 in DeleteModal ([#18786](https://github.com/apache/superset/issues/18786)) ([2d67d2f](https://github.com/apache/superset/commit/2d67d2f14e8143e2e1589d2e3cd9218fb06562ec))
- **demo:** add antd css and implement action hook ([#851](https://github.com/apache/superset/issues/851)) ([a6d8f57](https://github.com/apache/superset/commit/a6d8f57bceefe7cfbd8ff041960958d5a63a6e2c))
- **dependency:** update cryptography import ([#22744](https://github.com/apache/superset/issues/22744)) ([e18bf3f](https://github.com/apache/superset/commit/e18bf3f4496a387e86cb0ed8a685be4e5fa587e2))
- deprecate approve and request_access endpoint ([#22022](https://github.com/apache/superset/issues/22022)) ([358a4ec](https://github.com/apache/superset/commit/358a4ecedd13a20b3491ca9f536d773d87b6ca65))
- **dev-server run:** Check for environment tag not being undefined ([#21232](https://github.com/apache/superset/issues/21232)) ([b354f22](https://github.com/apache/superset/commit/b354f2265aab1e5569315364ecbcc314049aae5d))
- dict bug on QueryContextFactory ([#23093](https://github.com/apache/superset/issues/23093)) ([21dd160](https://github.com/apache/superset/commit/21dd1601bf2d59781b7540ef8dc1005819d588a2))
- **dimension:** set 0 width/height in createHiddenSvgNode ([#261](https://github.com/apache/superset/issues/261)) ([d6a46c1](https://github.com/apache/superset/commit/d6a46c1265c4558d9e09c579b3b708b65c4662ff))
- Direct link issue on report/list ([#20033](https://github.com/apache/superset/issues/20033)) ([9cf9f97](https://github.com/apache/superset/commit/9cf9f97a0cee74bc642e297a3bdb089e70fffe57))
- Disable filtering on wide result sets ([#18021](https://github.com/apache/superset/issues/18021)) ([343d3f8](https://github.com/apache/superset/commit/343d3f8f7a3bfb083164fba6afce40daec26fcaa))
- disable lazy import for line chart and box plot ([#82](https://github.com/apache/superset/issues/82)) ([f1164ae](https://github.com/apache/superset/commit/f1164aece052bcac7971f3098fcb62c5bb7b80bd))
- disable lint error ([#150](https://github.com/apache/superset/issues/150)) ([fa11638](https://github.com/apache/superset/commit/fa11638a80fb74c740d5e4890552d93fbb8a417e))
- disallow users from viewing other user's profile on config ([#21302](https://github.com/apache/superset/issues/21302)) ([c3f8417](https://github.com/apache/superset/commit/c3f841713989634ef4ba522b6a89e04ff89e2c0d))
- Display Error Messages in DB Connection Modal ([#22200](https://github.com/apache/superset/issues/22200)) ([aafb993](https://github.com/apache/superset/commit/aafb993ee2aa66398a693a68acf8b79e271ddeeb))
- dist bar will render value multi times ([#713](https://github.com/apache/superset/issues/713)) ([12bfdb2](https://github.com/apache/superset/commit/12bfdb2767d6f51ba3ebcf7626227afd63f7c558))
- **dnd&column:** make to fix the blank state issue when only one column select ([#19651](https://github.com/apache/superset/issues/19651)) ([c320c29](https://github.com/apache/superset/commit/c320c295dcf73f2575d371eaf0c2ba9f9eef6141))
- do not show migration toast if user not enable dashboard filter components ([#17440](https://github.com/apache/superset/issues/17440)) ([9f1bf1c](https://github.com/apache/superset/commit/9f1bf1cbd5cf5d58b72e2c686cecb59d006445cf))
- docker links ([#21797](https://github.com/apache/superset/issues/21797)) ([54f6fd6](https://github.com/apache/superset/commit/54f6fd6a82d0d66248bb4067f8811ebdcc01e0f9))
- **docker:** add ecpg to docker image ([#16566](https://github.com/apache/superset/issues/16566)) ([9cfce64](https://github.com/apache/superset/commit/9cfce649594ddddf25be1ef37ec3f37f155d67b0))
- **dockerfile:** fix "unhealthy" container state ([#22663](https://github.com/apache/superset/issues/22663)) ([1e3746b](https://github.com/apache/superset/commit/1e3746be215e5c2060b00d4c3196518f7c71697a))
- **docker:** Fixing ws docker push ([#22303](https://github.com/apache/superset/issues/22303)) ([2bdf22b](https://github.com/apache/superset/commit/2bdf22b21510861093ff63fb48c3e8b0b8148f88))
- **docker:** Make Gunicorn Keepalive Adjustable ([#20348](https://github.com/apache/superset/issues/20348)) ([86368dd](https://github.com/apache/superset/commit/86368dd406b9e828f31186a4b6179d24758a7d87))
- **docs:** add missing static files to build ([#18920](https://github.com/apache/superset/issues/18920)) ([1638090](https://github.com/apache/superset/commit/16380906d1ba0f98b486cfec4b4b16ebed5b8a14))
- **docs:** added missing timescale.png ([#21542](https://github.com/apache/superset/issues/21542)) ([e438c96](https://github.com/apache/superset/commit/e438c967c9fd3452d8f5aa811a43bce6ae8ffbd2))
- **docs:** bump broken packages ([#17800](https://github.com/apache/superset/issues/17800)) ([f396818](https://github.com/apache/superset/commit/f39681861615f592abb99f792d5d67523b12f0c9))
- **docs:** fix path of image for "Create New Chart" ([#18089](https://github.com/apache/superset/issues/18089)) ([5ce79ff](https://github.com/apache/superset/commit/5ce79ff8563b0610e21b2f11275438b23a74a81f))
- **docs:** prevent some symbols from being copied with ([#20480](https://github.com/apache/superset/issues/20480)) ([aa40680](https://github.com/apache/superset/commit/aa4068048a779359b21d2fa3e2c0328a0dd754ad))
- Don't allow duplicated tag values in the Select ([#19283](https://github.com/apache/superset/issues/19283)) ([d3ce398](https://github.com/apache/superset/commit/d3ce3984485de1cf16dbb214aa0063e5ac31b949))
- don't stringify extraJson in form ([#22171](https://github.com/apache/superset/issues/22171)) ([78a4bd6](https://github.com/apache/superset/commit/78a4bd6bb28ec895ee2df930fc3bb962fb7042ae))
- Drill to detail blocked by tooltip ([#22082](https://github.com/apache/superset/issues/22082)) ([3bc0865](https://github.com/apache/superset/commit/3bc0865d9071cdf32d268ee8fee4c4ad93680429))
- Drill to detail formatted val on TableChart ([#21719](https://github.com/apache/superset/issues/21719)) ([eb2a134](https://github.com/apache/superset/commit/eb2a1345a87dae968d1357279e6056a76988bd01))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the mixed chart ([#21845](https://github.com/apache/superset/issues/21845)) ([f381154](https://github.com/apache/superset/commit/f38115489b09cb22bb77427bf73462784650cbaa))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- **drill:** specify an SA URL parm of `impersonation_target` for drill+sadrill ([#19252](https://github.com/apache/superset/issues/19252)) ([85e330e](https://github.com/apache/superset/commit/85e330e94bc490d5a35fa0536f44e7189e299d20))
- drop the first level of MultiIndex ([#19716](https://github.com/apache/superset/issues/19716)) ([9425dd2](https://github.com/apache/superset/commit/9425dd2cac42f1a92f621848c469cadcc483e757))
- dropdown placement for cascading filters popover ([#17046](https://github.com/apache/superset/issues/17046)) ([824e62b](https://github.com/apache/superset/commit/824e62bd1f98c774d40ccf6f383ed67d13528b43))
- DropdownContainer items width calculation ([#22371](https://github.com/apache/superset/issues/22371)) ([1edfd7e](https://github.com/apache/superset/commit/1edfd7e1e154545381146fe46f29cbab7c6d1d85))
- DropdownContainer resize algorithm ([#22318](https://github.com/apache/superset/issues/22318)) ([aba3b81](https://github.com/apache/superset/commit/aba3b81e132cf2c92a79e5d381f01550481def9b))
- dual line chart color consistency for secondary y axis ([#18](https://github.com/apache/superset/issues/18)) ([7ea874c](https://github.com/apache/superset/commit/7ea874c9c0c8ec08465137d224498e83087d5c10))
- Duplicated numeric values in Select ([#21480](https://github.com/apache/superset/issues/21480)) ([b739e27](https://github.com/apache/superset/commit/b739e27f6dc4b159d766074e3e353a5546d00adb))
- Dynamic form to connect to Snowflake DB is not displaying authentication errors ([#19491](https://github.com/apache/superset/issues/19491)) ([634693b](https://github.com/apache/superset/commit/634693b2706e4f20479964e89da542661e9d4a77))
- edit pyarrow stringify to better handle emojis and accents ([#22881](https://github.com/apache/superset/issues/22881)) ([f2b61fc](https://github.com/apache/superset/commit/f2b61fca1537d0a80fafb5b313a365743cc41186))
- **elasticsearch:** time_zone setting does not work for cast datetime expressions ([#17048](https://github.com/apache/superset/issues/17048)) ([5a1c681](https://github.com/apache/superset/commit/5a1c68177ee68f78f8b31877f33f5bf93d5cc6c2))
- **embedded:** CSV download for chart ([#20261](https://github.com/apache/superset/issues/20261)) ([ab9f72f](https://github.com/apache/superset/commit/ab9f72f1a1359a59e64afd9e820d5823fd53b77b))
- **embedded:** download chart as image ([#19339](https://github.com/apache/superset/issues/19339)) ([0ad6925](https://github.com/apache/superset/commit/0ad692511ef998802cefe318f4488090ec344c44))
- **embedded:** Ensure guest token is passed to log endpoint ([#20647](https://github.com/apache/superset/issues/20647)) ([dfab521](https://github.com/apache/superset/commit/dfab521f50593b97fc778475498920552cad15dc))
- **embedded:** Referecing local variable response before initialization ([#20263](https://github.com/apache/superset/issues/20263)) ([2a45be3](https://github.com/apache/superset/commit/2a45be39968ad978748e541c08b8ab7c6daa1526))
- **embedded:** Retry when executing alert queries to avoid sending transient errors to users as alert failure notifications ([#20419](https://github.com/apache/superset/issues/20419)) ([818962c](https://github.com/apache/superset/commit/818962cc89aad34afdb8ea673908416d99631a06))
- **embedded:** third party cookies ([#20019](https://github.com/apache/superset/issues/20019)) ([3e36d4a](https://github.com/apache/superset/commit/3e36d4a0a1d9e1a1d2d009b6b8db1042d3d37d8b))
- **embed:** fix server error due to breaking change on flask-login ([#22462](https://github.com/apache/superset/issues/22462)) ([d5ecfbb](https://github.com/apache/superset/commit/d5ecfbb90147b7c22c816470e40e7b390f6ce65b))
- Empty Error Alert Modal ([#22186](https://github.com/apache/superset/issues/22186)) ([f885a18](https://github.com/apache/superset/commit/f885a18fecd38631ee5a8951620ce6b416a0edba))
- enable admin to edit dataset in explore ([#20613](https://github.com/apache/superset/issues/20613)) ([e1a918f](https://github.com/apache/superset/commit/e1a918f14112b257a470a0478fe77d2be3d795df))
- enable find text browser functionality inside SQL Lab editor ([#19061](https://github.com/apache/superset/issues/19061)) ([fd757c4](https://github.com/apache/superset/commit/fd757c4aa4138ad7da7f80585e4ae34c9c9631bc))
- ensure column name in description is string ([#20340](https://github.com/apache/superset/issues/20340)) ([f3b289d](https://github.com/apache/superset/commit/f3b289d3c333fe2351e9fbac6fa85b875cb1897c))
- Ensure consistent rollback logic ([#20811](https://github.com/apache/superset/issues/20811)) ([7a1aa79](https://github.com/apache/superset/commit/7a1aa79c52c7f5b69c222b8528ddd91f9ce44879))
- Ensure data cleanup in Cypress ([#21921](https://github.com/apache/superset/issues/21921)) ([a36ab71](https://github.com/apache/superset/commit/a36ab71a2793bd9dc51f3234b502ab43b0d304a0))
- ensure validation for db modal for googlesheets ([#19018](https://github.com/apache/superset/issues/19018)) ([bb17dec](https://github.com/apache/superset/commit/bb17decb0652bd2cfc64dda15e88bbccec2b8065))
- error alert levels again ([#17027](https://github.com/apache/superset/issues/17027)) ([153469d](https://github.com/apache/superset/commit/153469dba952db76d0d4a3793e5eb218eff294f6))
- error alerts again ([#17026](https://github.com/apache/superset/issues/17026)) ([ea70038](https://github.com/apache/superset/commit/ea700384b3746bd56279f6115b79ed3fcce284ec))
- error alerts js crash ([#17015](https://github.com/apache/superset/issues/17015)) ([03cdbac](https://github.com/apache/superset/commit/03cdbac8bbfc3a67332135e0a5d67cd36ffd2346))
- Error Message is cut off in alerts & reports log page ([#19444](https://github.com/apache/superset/issues/19444)) ([156ac7d](https://github.com/apache/superset/commit/156ac7dd79105bca47138d8906b50d01dc4f1cb6))
- Error when saving datasource from Explore ([#20749](https://github.com/apache/superset/issues/20749)) ([92f3621](https://github.com/apache/superset/commit/92f3621c754a4f3ddb99285aad273296be26567e))
- error_parsing ([#21946](https://github.com/apache/superset/issues/21946)) ([33fc578](https://github.com/apache/superset/commit/33fc57854d3e3b0702511e8960a09128591a27ec))
- escape bind-like strings in virtual table query ([#17111](https://github.com/apache/superset/issues/17111)) ([434b576](https://github.com/apache/superset/commit/434b5767c910d984e2b39655999f96afd00b84a6))
- eslint issues ([#198](https://github.com/apache/superset/issues/198)) ([e48b445](https://github.com/apache/superset/commit/e48b445bfe2771863516d3a7bf99b9cca2f749b9))
- exception thrown for charts without a x-axis ([#36](https://github.com/apache/superset/issues/36)) ([77396af](https://github.com/apache/superset/commit/77396afc7c96bb703b3ac8f70fa6ecabe538c580))
- exclude node_modules from ts tracking ([#18117](https://github.com/apache/superset/issues/18117)) ([9900e5a](https://github.com/apache/superset/commit/9900e5a6891929876b8fb7b5d29c25cd5b042626))
- Exclude SUPERSET_DEFAULT from the list of available color schemes ([#17018](https://github.com/apache/superset/issues/17018)) ([14b7f6c](https://github.com/apache/superset/commit/14b7f6cdbaad3a97aa24d234768a47752b700a11))
- **explore comma:** make that the comma can be added by removing it from token separators… ([#18926](https://github.com/apache/superset/issues/18926)) ([e7355b9](https://github.com/apache/superset/commit/e7355b9610d1371d1d3fca51c17d1999ca3ecef3))
- Explore long URL problem ([#18181](https://github.com/apache/superset/issues/18181)) ([4b61c76](https://github.com/apache/superset/commit/4b61c767425911551d276b59f1386b39bf319c5d)), closes [#2](https://github.com/apache/superset/issues/2)
- Explore scrolled down when navigating from dashboard ([#20962](https://github.com/apache/superset/issues/20962)) ([e4fc556](https://github.com/apache/superset/commit/e4fc5564ced1e2ad2f475629ce082ededd063ba9))
- explore warnings cleanup ([#20864](https://github.com/apache/superset/issues/20864)) ([5d107b8](https://github.com/apache/superset/commit/5d107b86abd1712571861e92f922ace57fb622ba))
- **explore-sqllab:** make that Timestamp column keep the Is temporal flagged when overwriting ([#19010](https://github.com/apache/superset/issues/19010)) ([4463586](https://github.com/apache/superset/commit/446358642f9e3e8522e366ccdac66e369acd5f20))
- **explore:** Adhoc columns don't display correctly ([#20802](https://github.com/apache/superset/issues/20802)) ([af1bddf](https://github.com/apache/superset/commit/af1bddffad930efc0583b638716980db6747bfbc))
- **explore:** Change copy of cross filters checkbox ([#19646](https://github.com/apache/superset/issues/19646)) ([4a5dddf](https://github.com/apache/superset/commit/4a5dddf52d8191b002fa11add6baaee26bc3b1a7))
- **explore:** Chart header icon paddings ([#19534](https://github.com/apache/superset/issues/19534)) ([bb96029](https://github.com/apache/superset/commit/bb96029c9de26d2c581ae498d235956cba6a7fd2))
- **explore:** chart link is broken without localStorage ([#21707](https://github.com/apache/superset/issues/21707)) ([35d9cb3](https://github.com/apache/superset/commit/35d9cb38a80849cd90524a2dfa3995490e219940))
- **explore:** Chart save modal displays error instead of failing silently ([#21920](https://github.com/apache/superset/issues/21920)) ([9d25453](https://github.com/apache/superset/commit/9d254534255e8938f93a7f613d9d254431f470db))
- **explore:** clean data when hidding control ([#19039](https://github.com/apache/superset/issues/19039)) ([0e29871](https://github.com/apache/superset/commit/0e29871493171b6a70f974d26f41b6797e5b5d5c))
- **explore:** Dashboard list is unsorted in save modal ([#21317](https://github.com/apache/superset/issues/21317)) ([3edc656](https://github.com/apache/superset/commit/3edc656f20ad794be8b892dad1f14c4f7deeca40))
- **explore:** datasource_type typo ([#22543](https://github.com/apache/superset/issues/22543)) ([c2ace8d](https://github.com/apache/superset/commit/c2ace8dacb70ef7200640f47d6862bbc85cab489))
- **explore:** deck.gl Multiple chart broken ([#17703](https://github.com/apache/superset/issues/17703)) ([bdc4e7a](https://github.com/apache/superset/commit/bdc4e7a322dc0adc441ce7052619a291a319de2b))
- **explore:** disable resize bar when the results area is collapsed ([#21366](https://github.com/apache/superset/issues/21366)) ([d28909d](https://github.com/apache/superset/commit/d28909d56c21c160a0140b87c4f268b1c4ea90f1))
- **explore:** don't apply time range filter to Samples table ([#17711](https://github.com/apache/superset/issues/17711)) ([b5b6ceb](https://github.com/apache/superset/commit/b5b6ceb1b32db987197ff252a8c495623beaa7d3))
- **explore:** Double divider if no permissions for adding reports ([#19777](https://github.com/apache/superset/issues/19777)) ([3663a33](https://github.com/apache/superset/commit/3663a33f14ef4bc3792e0a4089c3edd244f158ff))
- **explore:** Enable saving metric after changing title ([#23020](https://github.com/apache/superset/issues/23020)) ([98bf878](https://github.com/apache/superset/commit/98bf878d6ea263d4747cf4b7c23bc52555b177e7))
- **explore:** Filters with custom SQL disappearing ([#21114](https://github.com/apache/superset/issues/21114)) ([55304b0](https://github.com/apache/superset/commit/55304b02cd599827359cd13e3fe6ccb8581e0fd2))
- **Explore:** Fix cache timeout field not being saved and unit tests ([#18738](https://github.com/apache/superset/issues/18738)) ([cf8b57e](https://github.com/apache/superset/commit/cf8b57e80d80adc7f85a689e173a9fcc16e956bf))
- **explore:** fix chart embed code modal glitch ([#17843](https://github.com/apache/superset/issues/17843)) ([b083b34](https://github.com/apache/superset/commit/b083b3421f9186a014b751d223e3b3d9b2e2becb))
- **explore:** fix chart save when dashboard deleted ([#21497](https://github.com/apache/superset/issues/21497)) ([6644a84](https://github.com/apache/superset/commit/6644a84f79385ab11fdf1314293ef1fb284431ec))
- **explore:** Fix chart standalone URL for report/thumbnail generation ([#20673](https://github.com/apache/superset/issues/20673)) ([84d4302](https://github.com/apache/superset/commit/84d4302628d18aa19c13cc5322e68abbc690ea4d))
- **explore:** Fix datasource switch for table chart ([#21544](https://github.com/apache/superset/issues/21544)) ([954fc89](https://github.com/apache/superset/commit/954fc89871d26d4041247739d37b4ae2988069f6))
- **explore:** Fix generic X-axis time grain disappearing ([#21484](https://github.com/apache/superset/issues/21484)) ([324e997](https://github.com/apache/superset/commit/324e9979fa968b07d0be2628cac9119c492dc9b6))
- **Explore:** Force different color for same metrics in Mixed Time-Series ([#18603](https://github.com/apache/superset/issues/18603)) ([f565230](https://github.com/apache/superset/commit/f565230d8d8342f7a51b263d2a0865122c8f756e))
- **explore:** handle null control sections ([#20142](https://github.com/apache/superset/issues/20142)) ([e766f8c](https://github.com/apache/superset/commit/e766f8cb571fda1cef9aa398b146800bdbfaaeb1))
- **explore:** ignore temporary controls in altered pill ([#19843](https://github.com/apache/superset/issues/19843)) ([2dafff1](https://github.com/apache/superset/commit/2dafff12ef78082b8a0448e4b9e26ea6d21745ca))
- **explore:** Incorrect conversion from simple bool filter to custom sql ([#21293](https://github.com/apache/superset/issues/21293)) ([076af60](https://github.com/apache/superset/commit/076af6003a4b71f8c21e8191a595503bc491b0e7))
- **explore:** make SORT-Descending visible if Sort-by has value ([#17726](https://github.com/apache/superset/issues/17726)) ([d5768ab](https://github.com/apache/superset/commit/d5768ab649a70fd4f541ad4982498f622160b220))
- **explore:** make to convert null to N/A in view results ([#19316](https://github.com/apache/superset/issues/19316)) ([468c5ca](https://github.com/apache/superset/commit/468c5ca29a42a1b602de75eb4a2f0aed70dfdf2e))
- **explore:** make to fix the issue of explore error broken when see more/less ([#20282](https://github.com/apache/superset/issues/20282)) ([1e5cacd](https://github.com/apache/superset/commit/1e5cacda8f939874bc05832234f24579b7400c3a))
- **explore:** make to show the null value as N/A in view result ([#19603](https://github.com/apache/superset/issues/19603)) ([34323f9](https://github.com/apache/superset/commit/34323f9b5fcb1768f172d634e166230b6689f0da))
- **explore:** Mark time range dashboard filter with warning icon ([#22984](https://github.com/apache/superset/issues/22984)) ([5d550f4](https://github.com/apache/superset/commit/5d550f449aa791b32ab8dffe764086d461531abe))
- **explore:** Metric control breaks when saved metric deleted from dataset ([#17503](https://github.com/apache/superset/issues/17503)) ([7353a2b](https://github.com/apache/superset/commit/7353a2bd75ae5c76458615443f530a688e78db1c))
- **explore:** Metrics disappearing after removing metric from dataset ([#17201](https://github.com/apache/superset/issues/17201)) ([fa44325](https://github.com/apache/superset/commit/fa44325a368dab45f24204c2f8241a1c7afa3d86))
- **explore:** Persist URL params to form-data ([#21792](https://github.com/apache/superset/issues/21792)) ([b1bf25e](https://github.com/apache/superset/commit/b1bf25e98ceb1a2d52f102d22ebc3631b5278e71))
- **explore:** Pie chart label formatting when series is temporal ([#18216](https://github.com/apache/superset/issues/18216)) ([37430d4](https://github.com/apache/superset/commit/37430d404436b3d3833bfd9cbae602718c26c4a8))
- **Explore:** Pivot table V2 sort by failure with D&D enabled ([#18835](https://github.com/apache/superset/issues/18835)) ([eafe0cf](https://github.com/apache/superset/commit/eafe0cfc6f040670a9b35ebcd27f5c83eabe068e))
- **explore:** Prevent infinite rerenders when editing dataset ([#22219](https://github.com/apache/superset/issues/22219)) ([d1e576c](https://github.com/apache/superset/commit/d1e576cbd14a0fcc9d5a0a6e6c01e19ac52c44bb))
- **explore:** Prevent shared controls from checking feature flags outside React render ([#21315](https://github.com/apache/superset/issues/21315)) ([2285ebe](https://github.com/apache/superset/commit/2285ebe72ec4edded6d195052740b7f9f13d1f1b))
- **explore:** Prevent unnecessary series limit subquery ([#21154](https://github.com/apache/superset/issues/21154)) ([0726840](https://github.com/apache/superset/commit/0726840fb70cbd8c75f3499f08aee557640fd717))
- **Explore:** Remove changes to the properties on cancel ([#17184](https://github.com/apache/superset/issues/17184)) ([5491a4d](https://github.com/apache/superset/commit/5491a4d13ca9f8c1fb87887f756e2752bf679f18))
- **explore:** remove unnecessary parameters from the explore url ([#17123](https://github.com/apache/superset/issues/17123)) ([57f869c](https://github.com/apache/superset/commit/57f869cf2232f00d68251622a09a8646300c7739))
- **explore:** Replace url search params only if current page is Explore ([#20972](https://github.com/apache/superset/issues/20972)) ([9350bba](https://github.com/apache/superset/commit/9350bbafeeef0f4f3fa43a2068e0ea87afa55fca))
- **explore:** Restore missing dataset states ([#22693](https://github.com/apache/superset/issues/22693)) ([f5c404f](https://github.com/apache/superset/commit/f5c404fc51e9bcdee23fd4ec269f6083b283f74b))
- **explore:** Save button incorrectly disabled when adding new metric with dnd ([#23000](https://github.com/apache/superset/issues/23000)) ([7d5c86b](https://github.com/apache/superset/commit/7d5c86b44cb0a80fe81bf4693e1eea13132eb83e))
- **explore:** simple tab content input problem ([#17872](https://github.com/apache/superset/issues/17872)) ([07998fe](https://github.com/apache/superset/commit/07998fea68c762660333f1b98c34412b93132da3))
- **explore:** Small changes in metadata bar copy and tooltip placement ([#21952](https://github.com/apache/superset/issues/21952)) ([3c7a081](https://github.com/apache/superset/commit/3c7a0812819c26b963effae189efb50dddca60b4))
- **explore:** support saving undefined time grain ([#22565](https://github.com/apache/superset/issues/22565)) ([a7a4561](https://github.com/apache/superset/commit/a7a4561550e06bad11ef6d5a50af1ae1af173790))
- **explore:** Time column label not formatted when GENERIC_X_AXES enabled ([#21294](https://github.com/apache/superset/issues/21294)) ([c3a00d4](https://github.com/apache/superset/commit/c3a00d43d055224d4a31ea9315934a59b556eea7))
- **explore:** Time comparison in Mixed Chart in GENERIC_CHART_AXES not working ([#22945](https://github.com/apache/superset/issues/22945)) ([ed7b353](https://github.com/apache/superset/commit/ed7b3533bcc119b2240a613ebc56ace33f1e1002))
- **explore:** timestamp format when copy datatable to clipboard ([#17166](https://github.com/apache/superset/issues/17166)) ([860e481](https://github.com/apache/superset/commit/860e481a97c0e9db024e50761f672a718b4d8666))
- **explore:** unable to update linked charts ([#22896](https://github.com/apache/superset/issues/22896)) ([ad1ffbd](https://github.com/apache/superset/commit/ad1ffbd723702cf356d0fcac1a719f1a861a8497))
- **Explore:** Undefined owners ([#17167](https://github.com/apache/superset/issues/17167)) ([f580f6b](https://github.com/apache/superset/commit/f580f6bcba15a20c12ead5b3e6eef643cc0aa1d6))
- **explore:** Value undefined and Unhashable type errors ([#22207](https://github.com/apache/superset/issues/22207)) ([1809d2b](https://github.com/apache/superset/commit/1809d2b957394290cc55666b6e56c838fc8841c9))
- export superset theme props ([#391](https://github.com/apache/superset/issues/391)) ([c21ad5c](https://github.com/apache/superset/commit/c21ad5cee42d7bead3fe15ad962161bd6bb83ee1))
- exporting CSV can't apply pagination [#17861](https://github.com/apache/superset/issues/17861) ([#20178](https://github.com/apache/superset/issues/20178)) ([d4f320f](https://github.com/apache/superset/commit/d4f320f2a0efbcd05b688fbeda4351749fd512f6))
- **external-link:** change the external link in creating chart dashboard ([#18982](https://github.com/apache/superset/issues/18982)) ([37752ce](https://github.com/apache/superset/commit/37752cea9b3832b763f8fcb31e8895857cbb1955))
- extra column in metrics ([#17784](https://github.com/apache/superset/issues/17784)) ([30c0459](https://github.com/apache/superset/commit/30c0459808f773f2315100a2670e7d2ebf0f4f75))
- extract tables doesn't work with reserved keywords ([#17654](https://github.com/apache/superset/issues/17654)) ([8c25f2f](https://github.com/apache/superset/commit/8c25f2f356e488120d7ce3ff852a4b6b9a049b3b))
- **fab:** Fix regression on FAB dropdowns ([#22889](https://github.com/apache/superset/issues/22889)) ([a35aeb9](https://github.com/apache/superset/commit/a35aeb9d6b704b674f22f7e9c63422314131ed2b))
- failed mypy ([#17886](https://github.com/apache/superset/issues/17886)) ([ef57bd1](https://github.com/apache/superset/commit/ef57bd19024e2e8bac64d5475e74b7d0c215872d))
- failed samples should throw exception ([#20228](https://github.com/apache/superset/issues/20228)) ([1530c34](https://github.com/apache/superset/commit/1530c3479237e0540fe5dda7bb14fbfc8291c88c))
- failed timezone selector UT ([#17370](https://github.com/apache/superset/issues/17370)) ([33a8e87](https://github.com/apache/superset/commit/33a8e875139afcf463f68ec48f46c6abf01a9670))
- feature flags typing ([#15254](https://github.com/apache/superset/issues/15254)) ([69f9ee8](https://github.com/apache/superset/commit/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b))
- **file_upload:** Fix columnar and Excel upload forms ([#22249](https://github.com/apache/superset/issues/22249)) ([fb3e717](https://github.com/apache/superset/commit/fb3e7175733978cb34c6fe87dde367ad38bec6da))
- Filter dependencies are not being applied in default values ([#19698](https://github.com/apache/superset/issues/19698)) ([7bc9123](https://github.com/apache/superset/commit/7bc9123fe569c47ebb9eb049c96ff833478f7ded))
- filter indicator pointing issue on popover ([#18853](https://github.com/apache/superset/issues/18853)) ([c1ee75d](https://github.com/apache/superset/commit/c1ee75dd8efc27dac85805720107703aa5916a9c))
- Filter throwing an error on Embedded Dashboard ([#21157](https://github.com/apache/superset/issues/21157)) ([604e30b](https://github.com/apache/superset/commit/604e30b3f089f9592bef03381b0dea5dd5b70f78))
- **filter-indicator:** show filters handled by jinja as applied ([#17140](https://github.com/apache/superset/issues/17140)) ([d7834f1](https://github.com/apache/superset/commit/d7834f17e3e0da1404130018fea968f3e1a4001e))
- **filter-sets:** 404 on dashboard load ([#17777](https://github.com/apache/superset/issues/17777)) ([961766e](https://github.com/apache/superset/commit/961766e83393826087e8f187e0e1a5f45a750b86))
- FilterBox date endpoints to use [inclusive, exclusive) ([#18857](https://github.com/apache/superset/issues/18857)) ([324601e](https://github.com/apache/superset/commit/324601e0bb5b8a030e701a785ecb51b1d50e6d3b))
- Filtering db names while creating dataset is not working ([#17023](https://github.com/apache/superset/issues/17023)) ([be21143](https://github.com/apache/superset/commit/be211437ded95fe66f9901d00e9a2500ee7df7f6))
- fine tune time pivot chart tooltip ([#33](https://github.com/apache/superset/issues/33)) ([fa0d4ea](https://github.com/apache/superset/commit/fa0d4ea6bce7869e432070a2f4f5498f86a21e2c))
- Fix auto-reversion of label/title in the Metrics popover ([#19889](https://github.com/apache/superset/issues/19889)) ([7b5ba39](https://github.com/apache/superset/commit/7b5ba390296a423c83c36b2658956fd4b6c6180b))
- Fix chart title truncating when Chrome is zoomed out ([#20847](https://github.com/apache/superset/issues/20847)) ([46deb79](https://github.com/apache/superset/commit/46deb79f50971775abbf10c3b4bf646a752c11c7))
- fix comment in Docker environment files ([#22421](https://github.com/apache/superset/issues/22421)) ([b55ef5b](https://github.com/apache/superset/commit/b55ef5b514b4db93e2e275e67de2fed270436e84))
- Fix console errors about feature flags when running tests ([#21275](https://github.com/apache/superset/issues/21275)) ([742dbdd](https://github.com/apache/superset/commit/742dbdd0a5c0f0f75d56101b3551077ec06cd53f))
- **fix issues in superset:** fix issues in superset ([db4863d](https://github.com/apache/superset/commit/db4863d14be0ace246b2618c5c3c0b3f08e45276))
- Fix migration for removing time_range_endpoints 3 ([#19767](https://github.com/apache/superset/issues/19767)) ([7e92340](https://github.com/apache/superset/commit/7e92340c7085358940de5ff199b9cc919b35111f))
- fix nvd3 and histogram regressions and migrate control panels to TS ([#875](https://github.com/apache/superset/issues/875)) ([146f9a4](https://github.com/apache/superset/commit/146f9a4dfd42a94ae56a7d4a1a58ebab044eec0e))
- fix React.Fragment complaining about width/height ([#219](https://github.com/apache/superset/issues/219)) ([885e4e9](https://github.com/apache/superset/commit/885e4e978526dd917679b44029cf190f6fed9300))
- Fix regression introduced in [#20893](https://github.com/apache/superset/issues/20893) ([#21743](https://github.com/apache/superset/issues/21743)) ([3936e9e](https://github.com/apache/superset/commit/3936e9ed5fc41272fcd2d46ce847bf97dc1e0249))
- **fix types:** fix types ([66ce93c](https://github.com/apache/superset/commit/66ce93c2139d85015688eec7ead9698ded218ff7))
- fix warning in ssh tunnel ([#22912](https://github.com/apache/superset/issues/22912)) ([16800cc](https://github.com/apache/superset/commit/16800cc14cf9c1be4fbab74fa6df2b8e52dbc319))
- fix word cloud randomness ([#19977](https://github.com/apache/superset/issues/19977)) ([2e31021](https://github.com/apache/superset/commit/2e31021ecd6cc390fbe29d2837c026c6ac43903b))
- Fixed spacing in alert modal ([#22066](https://github.com/apache/superset/issues/22066)) ([1bab5b9](https://github.com/apache/superset/commit/1bab5b9eba4fe4e8cec1ae6d40c520cb2725bc21))
- Fixes error caused by step id placed in wrong location ([#21226](https://github.com/apache/superset/issues/21226)) ([5f76ac9](https://github.com/apache/superset/commit/5f76ac9001f10307d4e7446ad10372ad0c980e86))
- Fixes metric control when changing viz type to tree chart ([#1116](https://github.com/apache/superset/issues/1116)) ([a60771f](https://github.com/apache/superset/commit/a60771f5092e5e7125b3b8fab50a323f1e03bc00))
- Fixes Tabs style ([#20050](https://github.com/apache/superset/issues/20050)) ([fff9ad0](https://github.com/apache/superset/commit/fff9ad05d4823c897117508bd37e5aec4bb9f739))
- Fixes the instructions to publish to PyPi ([#20710](https://github.com/apache/superset/issues/20710)) ([4495868](https://github.com/apache/superset/commit/4495868b441f5a910596c191efdfe4d8a6f261f6))
- fixing tooltip for expanded area chart ([#134](https://github.com/apache/superset/issues/134)) ([7bf3587](https://github.com/apache/superset/commit/7bf358750bc6b20ce939b0a7081c8643a4ada15a))
- Flaky E2E tests ([#22152](https://github.com/apache/superset/issues/22152)) ([e990690](https://github.com/apache/superset/commit/e990690dde9d3a5dbc6eeacde651a06e3a8d1ce7))
- flaky test for dashboard changed on ([#19483](https://github.com/apache/superset/issues/19483)) ([a2e921b](https://github.com/apache/superset/commit/a2e921bd035ff1af54c22ecc8e4203af68c6baa8))
- flaky test when sync metadata ([#21306](https://github.com/apache/superset/issues/21306)) ([f71ee2e](https://github.com/apache/superset/commit/f71ee2e7bc89860f51f599a4403808f65c7430dc))
- flash message on database data upload forms ([#21761](https://github.com/apache/superset/issues/21761)) ([ba3275a](https://github.com/apache/superset/commit/ba3275a4d08ec170762e44b89148978222778785))
- **fonts:** Show the all the A's in our workspace correctly, not funky ([#20361](https://github.com/apache/superset/issues/20361)) ([df8bb46](https://github.com/apache/superset/commit/df8bb46ee26807a06e168b3a234e43b02bf658e1))
- for series limit comparison on explore with chart = Query ([#20989](https://github.com/apache/superset/issues/20989)) ([be4fbaf](https://github.com/apache/superset/commit/be4fbaf951e3ef2ae510410c20ee3991ec1531ba))
- Force configuration for SafeMarkdown component in Handlebars ([#22417](https://github.com/apache/superset/issues/22417)) ([ebaa949](https://github.com/apache/superset/commit/ebaa94974b2fca41d21f1c0972c288e086525687))
- **force to publish new version:** force to publish new version ([9468cfb](https://github.com/apache/superset/commit/9468cfb1618fdcfd628dabb188a9f64cf2f2d445))
- force_screenshot migration ([#17928](https://github.com/apache/superset/issues/17928)) ([4479fc9](https://github.com/apache/superset/commit/4479fc9222af9a46abf1d02f670da43533bae185))
- Form data was not being passed to save/update slice ([#22989](https://github.com/apache/superset/issues/22989)) ([c9b9b74](https://github.com/apache/superset/commit/c9b9b7404a2440a4c9d3173f0c494ed40f7fa2bd))
- forwardRef warnings in selects ([#20970](https://github.com/apache/superset/issues/20970)) ([6650076](https://github.com/apache/superset/commit/665007622845cf4303b50e57d11549a162dbbb1b))
- generator-superset public access ([a546210](https://github.com/apache/superset/commit/a546210bda824c222901c03225656e5de27b6425))
- **generator-superset:** add fixes to viz plugin generator ([#803](https://github.com/apache/superset/issues/803)) ([f9c7d35](https://github.com/apache/superset/commit/f9c7d3594deda9c7f8337bd206c0967f2307fa50))
- **generator-superset:** update plugin template to 0.17 standards ([#1013](https://github.com/apache/superset/issues/1013)) ([6e7e02e](https://github.com/apache/superset/commit/6e7e02ec014c6a167c98239ff46b919eda15952b))
- **generator:** add lockfile and fix styling issues ([#18073](https://github.com/apache/superset/issues/18073)) ([5bfe2d4](https://github.com/apache/superset/commit/5bfe2d47b0d46d6f561fdae6e803d6929ffe840b))
- **generator:** more cleanup to plugin framework ([#18027](https://github.com/apache/superset/issues/18027)) ([8dea7f5](https://github.com/apache/superset/commit/8dea7f500bea194f55c15c9f1511a35b2c328cd6))
- **generic-axes:** apply contribution before flatten ([#20077](https://github.com/apache/superset/issues/20077)) ([d5802f7](https://github.com/apache/superset/commit/d5802f78964a5027184ff9e7f6b78c14b04fd988))
- **generic-chart-axes:** apply time filter on all target column types ([#22238](https://github.com/apache/superset/issues/22238)) ([940a175](https://github.com/apache/superset/commit/940a17514fcb933e0c44364767eab5db40d3d20e))
- **generic-chart-axes:** set x-axis if unset and ff is enabled ([#20107](https://github.com/apache/superset/issues/20107)) ([0b3d3dd](https://github.com/apache/superset/commit/0b3d3dd4caa7f4c31c1ba7229966a40ba0469e85))
- getting default value in run-server.sh ([#20736](https://github.com/apache/superset/issues/20736)) ([5990ea6](https://github.com/apache/superset/commit/5990ea639e4f94b54d3109d14b1918a6f9770f14))
- GH issue 8669 NVD3 tooltip overflow ([#278](https://github.com/apache/superset/issues/278)) ([7786a41](https://github.com/apache/superset/commit/7786a418671c9e67bc984ee783502f1d2172a4f1))
- got one color wrong when copy pasting ([#624](https://github.com/apache/superset/issues/624)) ([2a28128](https://github.com/apache/superset/commit/2a28128f55d0d8e14655e5a4d5d03a4071289f42))
- gradient not working when y axis title has space ([#98](https://github.com/apache/superset/issues/98)) ([012f516](https://github.com/apache/superset/commit/012f5165da3cc1ebf9d66d4662a43ef5fd4adb05))
- gridlines ([75d54d2](https://github.com/apache/superset/commit/75d54d28955108f69167bea2ed8213d49d3591af))
- gsheets editing with dynamic forms ([#21710](https://github.com/apache/superset/issues/21710)) ([882bfb6](https://github.com/apache/superset/commit/882bfb67aed076b638b15a8c277ad9acd27649dc))
- Gsheets takes 2 clicks to save ([#21740](https://github.com/apache/superset/issues/21740)) ([aef6217](https://github.com/apache/superset/commit/aef6217a80d8b7d30120efe6502505edc01eb8d3))
- handle null params in [#18936](https://github.com/apache/superset/issues/18936) migration ([#19474](https://github.com/apache/superset/issues/19474)) ([7f85da6](https://github.com/apache/superset/commit/7f85da6e5b677bc80b4956719dbfe98192bf0db3))
- handle null values in time-series table ([#18039](https://github.com/apache/superset/issues/18039)) ([26dc600](https://github.com/apache/superset/commit/26dc600aff9dac446c0458270a2e1dbde0736e21))
- handle TIME column serialization ([#16869](https://github.com/apache/superset/issues/16869)) ([0d77f36](https://github.com/apache/superset/commit/0d77f36679a5714ea7402085988d4fb9867dd913))
- Handles disabled options on Select All ([#22830](https://github.com/apache/superset/issues/22830)) ([5e64211](https://github.com/apache/superset/commit/5e64211bdb0302315ee8f8e64f7a95180da594ad))
- heatmap errors with null data ([bfc5178](https://github.com/apache/superset/commit/bfc5178ce4e5c1ab4dcb70f45835b9e4d7f8b308))
- **heatmap:** add detail descriptions for heatmap 'normalize across' ([#20566](https://github.com/apache/superset/issues/20566)) ([d925b0c](https://github.com/apache/superset/commit/d925b0c8835fb1773b80298a3de1bdc368c88850))
- **helm:** allows extra top-level properties ([#18174](https://github.com/apache/superset/issues/18174)) ([568b8e1](https://github.com/apache/superset/commit/568b8e160fc8f3d2965ec3ac8a6d0fd6f20a860f))
- **helm:** fix postgresql values ([#19835](https://github.com/apache/superset/issues/19835)) ([f198f9f](https://github.com/apache/superset/commit/f198f9f007741d5098f176d770b1ab3245969332))
- **helm:** Fix support for ingress.ingressClassName ([#18619](https://github.com/apache/superset/issues/18619)) ([11d71d6](https://github.com/apache/superset/commit/11d71d69feeb13acae309fed9ca48d02d620b7be))
- **helm:** Fixing up chart and linting ([#22590](https://github.com/apache/superset/issues/22590)) ([01671b9](https://github.com/apache/superset/commit/01671b9d1b3a15c264bcfb9eced1776c70e293b5))
- **helm:** pin correct psycopg2 version ([#17999](https://github.com/apache/superset/issues/17999)) ([cdcdf11](https://github.com/apache/superset/commit/cdcdf11d0736f223aaf2a594323be869e0860169))
- **helm:** remove config overrides for CSRF ([#22716](https://github.com/apache/superset/issues/22716)) ([85da86d](https://github.com/apache/superset/commit/85da86dc81cf9f5c4791a817befd3d7961ce97ac))
- **helm:** service account apiVersion indent ([#17920](https://github.com/apache/superset/issues/17920)) ([48d5dc1](https://github.com/apache/superset/commit/48d5dc12fc9283ca6a84b24643f91320b2c676f6))
- **hex:** restore control panel to functioning state ([#42](https://github.com/apache/superset/issues/42)) ([55b3c79](https://github.com/apache/superset/commit/55b3c7933df677d9aaa3f95d2e8c8c25dddd528a))
- Hide Safari default tooltip ([#1283](https://github.com/apache/superset/issues/1283)) ([50a5032](https://github.com/apache/superset/commit/50a50324a705a275c19ca8446d28e5fba98c98bc))
- hide time_grain when x_axis value is undefined ([#21464](https://github.com/apache/superset/issues/21464)) ([ae6d2cf](https://github.com/apache/superset/commit/ae6d2cf18dbf0fec78e577b0cad1881940796b50))
- hiding HiddenControl inputs for real, to reduce bootstrap space consumption ([#15182](https://github.com/apache/superset/issues/15182)) ([6d66963](https://github.com/apache/superset/commit/6d66963489162640ac0b3b872b70cf7311c53da1))
- **histogram:** display correct percentile value instead of formula ([#18084](https://github.com/apache/superset/issues/18084)) ([28e729b](https://github.com/apache/superset/commit/28e729b835d8195f3610f7131504441803e43406))
- **hive:** Fix regression from [#21943](https://github.com/apache/superset/issues/21943) ([#22431](https://github.com/apache/superset/issues/22431)) ([4f9c2c8](https://github.com/apache/superset/commit/4f9c2c8165ab5d875c14c7cd8e8585c78d45900f))
- **hive:** Regression in [#21794](https://github.com/apache/superset/issues/21794) ([#22794](https://github.com/apache/superset/issues/22794)) ([0b31b2c](https://github.com/apache/superset/commit/0b31b2cb877ce629c4f346ea434cd02c4a8a469b))
- **hive:** Update \_latest_partition_from_df in HiveEngineSpec to work on tables with multiple indexes ([#14302](https://github.com/apache/superset/issues/14302)) ([bc855f4](https://github.com/apache/superset/commit/bc855f404023f1c6c89d6fdadd87a1d7ad417ca8))
- **hive:** Workaround for Python 3.9 s3 transfer issue ([#19887](https://github.com/apache/superset/issues/19887)) ([fdf48c6](https://github.com/apache/superset/commit/fdf48c63f1220607b9390104b04ba1d9fae7bfcf))
- **homepage:** make to show indicator when tab is choosen ([#20048](https://github.com/apache/superset/issues/20048)) ([ded9122](https://github.com/apache/superset/commit/ded9122ceb671b3c80a7ff5b9c76d5dce38f567c))
- **home:** Show home page tabs as pills instead of links ([#20257](https://github.com/apache/superset/issues/20257)) ([a833674](https://github.com/apache/superset/commit/a833674a8d3fff5c813d8204efb9350c4c89f7b6))
- Horizontal filter bar resizing ([#22286](https://github.com/apache/superset/issues/22286)) ([ead2834](https://github.com/apache/superset/commit/ead2834a771d515600d1fac1e20bd108d83c5fb9))
- hundreds lint warning ([#447](https://github.com/apache/superset/issues/447)) ([67e15d0](https://github.com/apache/superset/commit/67e15d011a23200abea2e1884150c45eb0db4586))
- **i18n:** greatly optimize Chinese translation ([#22036](https://github.com/apache/superset/issues/22036)) ([b381c20](https://github.com/apache/superset/commit/b381c20d5253c900ab88ff5b4d9786c57235b95e))
- **i18n:** improve Russian translation ([#22939](https://github.com/apache/superset/issues/22939)) ([a7bb14e](https://github.com/apache/superset/commit/a7bb14e433907f11b5e487b43927d4fc32a11350))
- ignore disabled series in stacked bar values ([#116](https://github.com/apache/superset/issues/116)) ([5b5086b](https://github.com/apache/superset/commit/5b5086b96a2df60871e2e31caca3f2cacb4e9c9c))
- implement extra filter logic ([#688](https://github.com/apache/superset/issues/688)) ([ea72983](https://github.com/apache/superset/commit/ea729831c30aa5706cc351b19ca431a1afe89ecb))
- import dash with missing immune ID ([#17732](https://github.com/apache/superset/issues/17732)) ([fceabf6](https://github.com/apache/superset/commit/fceabf6bc5f9eacb082f321185aa2c1cbe657a40))
- import dashboard stale filter_scopes ([#17741](https://github.com/apache/superset/issues/17741)) ([2633bcc](https://github.com/apache/superset/commit/2633bcccc372f0059a23cd5a8367a983f388dcb2))
- import DB errors ([#17748](https://github.com/apache/superset/issues/17748)) ([2a6e5e5](https://github.com/apache/superset/commit/2a6e5e5e5c0d35eae1879fb8d07586262d61a3ca))
- import should accept old keys ([#17330](https://github.com/apache/superset/issues/17330)) ([cb34a22](https://github.com/apache/superset/commit/cb34a226840bfc7770a9e4ac769c8e4c8e552303))
- import typeddict from extensions ([#17823](https://github.com/apache/superset/issues/17823)) ([0199104](https://github.com/apache/superset/commit/01991044f3b002a7cee744922fac98c35051d2f5))
- **import_datasources:** --sync flag works correctly ([#18046](https://github.com/apache/superset/issues/18046)) ([2dd64f9](https://github.com/apache/superset/commit/2dd64f9a93bff7e96182bb27a547b21a0a6ef48e))
- **import:** Add the error alert on failed database import ([#19673](https://github.com/apache/superset/issues/19673)) ([a2d34ec](https://github.com/apache/superset/commit/a2d34ec4b8a89723e7468f194a98386699af0bd7))
- **import:** error with disable_data_preview field ([#20932](https://github.com/apache/superset/issues/20932)) ([6ce027d](https://github.com/apache/superset/commit/6ce027d2f80476b2586adccde80083b689de1d07))
- **import:** Show the error message with db install guide when exist the importing db issue ([#20573](https://github.com/apache/superset/issues/20573)) ([c992ff3](https://github.com/apache/superset/commit/c992ff3be472738a34491d6e8ba8ba10167b2f8c))
- Improve big number time format UX ([#1320](https://github.com/apache/superset/issues/1320)) ([3276a65](https://github.com/apache/superset/commit/3276a653e3d92f2ed3ac7ce8cef210b68bc39c2a))
- improve cypress flakiness ([#19044](https://github.com/apache/superset/issues/19044)) ([002bd6e](https://github.com/apache/superset/commit/002bd6ed0a179821a81e68170a94aa1cbdce57de))
- improve get_db_engine_spec_for_backend ([#21171](https://github.com/apache/superset/issues/21171)) ([8772e2c](https://github.com/apache/superset/commit/8772e2cdb3b5a500812e7df12c133f9c9f2e6bad))
- Improve performance of CSV download ([#22929](https://github.com/apache/superset/issues/22929)) ([98f4e90](https://github.com/apache/superset/commit/98f4e909444ec5a72b0a6ad20ca25032e300bd26))
- improve the alerts & reports modal layout on small screens ([#19294](https://github.com/apache/superset/issues/19294)) ([32239b0](https://github.com/apache/superset/commit/32239b04aa84657f0485925749f4d65999f68477))
- incorporating ScheduleQueries into featureFlags ([#1020](https://github.com/apache/superset/issues/1020)) ([9559a69](https://github.com/apache/superset/commit/9559a69d3f7295a123bb75cf28a951f4b5c942c8))
- incorrect commit message ([#1443](https://github.com/apache/superset/issues/1443)) ([2029b37](https://github.com/apache/superset/commit/2029b37f2ed846529efb24307311cce2ef0b2f0b))
- **init:** Initialize \_jwt_cookie_name in AsyncQueryManager **init** ([#22314](https://github.com/apache/superset/issues/22314)) ([a2a578a](https://github.com/apache/superset/commit/a2a578ad9bdac2b637d68654518ad95ba767b9b6))
- interactiveGroupBy can works regardless to queryMode ([c86ffd2](https://github.com/apache/superset/commit/c86ffd26c54bc76b9be28ff1a7ea34ecda93210c))
- invalid dataset schema ([#20826](https://github.com/apache/superset/issues/20826)) ([3fb5c79](https://github.com/apache/superset/commit/3fb5c79d77f5c7fce001605bc5ba5a725b833c88))
- invalid float number format by json-bigint ([#21968](https://github.com/apache/superset/issues/21968)) ([3bb9187](https://github.com/apache/superset/commit/3bb91877974650ab3fa82539a30dc0e2a7045dd7))
- invalid float number format by json-bigint ([#21996](https://github.com/apache/superset/issues/21996)) ([3a02339](https://github.com/apache/superset/commit/3a023392e6bfec9660449b7b739530574d2a8238))
- invalid margin breaking chart ([#102](https://github.com/apache/superset/issues/102)) ([6d8ebc8](https://github.com/apache/superset/commit/6d8ebc8ac56d82e6df1bfc67cedddd4dcdb473fc))
- invalid metric should raise an exception ([#20882](https://github.com/apache/superset/issues/20882)) ([718bc30](https://github.com/apache/superset/commit/718bc3062e99cc44afbb57f786b5ca228c5b13fb))
- issue with sorting by multiple columns in a table ([#19920](https://github.com/apache/superset/issues/19920)) ([a45d011](https://github.com/apache/superset/commit/a45d011e74be7a52fee9b0e580187dd6f25509db))
- javascript file suffixes to extract ([#17673](https://github.com/apache/superset/issues/17673)) ([3350076](https://github.com/apache/superset/commit/3350076eea7517c0a0996586cf6260713224a442))
- **jest:** add superset-frontend to testRegex ([#18601](https://github.com/apache/superset/issues/18601)) ([cebff83](https://github.com/apache/superset/commit/cebff83d0ca0b6f556fd761ec43f58415cff8ddb))
- JS exception: Cannot read property "dispatch" of undefined ([#287](https://github.com/apache/superset/issues/287)) ([e3da248](https://github.com/apache/superset/commit/e3da2483180be783d75a27e190b20ea62223a230))
- JSON serializers ([#22029](https://github.com/apache/superset/issues/22029)) ([6bbf4f8](https://github.com/apache/superset/commit/6bbf4f8718ce9054d6c4c75b532576184e1c3ef6))
- **key_value:** use longblob on mysql ([#19805](https://github.com/apache/superset/issues/19805)) ([a1bd5b2](https://github.com/apache/superset/commit/a1bd5b283cc3b766d54c7c61d6487b4bce7ce916))
- **key-value:** lost url_params after long-url feature ([#18846](https://github.com/apache/superset/issues/18846)) ([4c16586](https://github.com/apache/superset/commit/4c165860674d1746d99e3e38bc6f7aa849b1601c))
- lazily create metadata ([#74](https://github.com/apache/superset/issues/74)) ([ede2e92](https://github.com/apache/superset/commit/ede2e92d97f0eee8e23fc7fd4a0567d1e2b49029))
- **legacy-plugin-chart-calendar:** fix timestamp timezone in Calendar ([#17664](https://github.com/apache/superset/issues/17664)) ([e660ea2](https://github.com/apache/superset/commit/e660ea25331b092ecb5976254abfc45a413f07d5))
- **legacy-plugin-chart-country-map:** Add Syria to control panel selection ([#1025](https://github.com/apache/superset/issues/1025)) ([20aee01](https://github.com/apache/superset/commit/20aee01215eafa51a3387f8c05eb7786db4fcc54))
- **legacy-plugin-chart-country-map:** Correct ISO 3166-2 county codes for Estonia ([#1344](https://github.com/apache/superset/issues/1344)) ([3d3da9d](https://github.com/apache/superset/commit/3d3da9d134d8ce2a77962f8991a760a4fc98fc5c))
- **legacy-plugin-chart-country-map:** fix broken map of Finland ([#1321](https://github.com/apache/superset/issues/1321)) ([370f4c0](https://github.com/apache/superset/commit/370f4c0ec571b82374f5e52503b132b854ffac65))
- **legacy-plugin-chart-country-map:** higher quality geojson and re-arrange controls ([#1045](https://github.com/apache/superset/issues/1045)) ([cbaec13](https://github.com/apache/superset/commit/cbaec13962502786313de2bb8c3538456a2c87e9))
- **legacy-plugin-chart-histogram:** fixes legend overflow ([#863](https://github.com/apache/superset/issues/863)) ([e4ebd82](https://github.com/apache/superset/commit/e4ebd828fe597b67592530f9e25180e3e1e700b0))
- **legacy-plugin-chart-horizon:** error on missing groupby ([#1100](https://github.com/apache/superset/issues/1100)) ([8d45a17](https://github.com/apache/superset/commit/8d45a179237f4b8508f2d1568d5b1edc1a962f97))
- **legacy-plugin-chart-horizon:** horizon chart should scroll when overflowing ([#180](https://github.com/apache/superset/issues/180)) ([7019442](https://github.com/apache/superset/commit/7019442a55adce54a3994ddf81b3bcdf6fe3c88f))
- **legacy-plugin-chart-map-box:** fix downloading map as image ([#965](https://github.com/apache/superset/issues/965)) ([e903988](https://github.com/apache/superset/commit/e9039884fb2204a14e0d9aa0a4bcb0eba29c17cb))
- **legacy-plugin-chart-nvd3:** disable bad linting rule ([#488](https://github.com/apache/superset/issues/488)) ([caf9a40](https://github.com/apache/superset/commit/caf9a4000e2d12306aa880a60c06a1f26dd41500))
- **legacy-plugin-chart-paired-t-test:** fix paired t-test table chart ([#961](https://github.com/apache/superset/issues/961)) ([4db9249](https://github.com/apache/superset/commit/4db92492cf11e082308171cfe428f03000db39bb))
- **legacy-plugin-chart-pivot-table:** fix displaying image inside rows ([#954](https://github.com/apache/superset/issues/954)) ([9357d2b](https://github.com/apache/superset/commit/9357d2bd822d940f0a3e58912a4521bfb2f8fa33))
- **legacy-plugin-chart-pivot-table:** formatting non-numeric values ([#695](https://github.com/apache/superset/issues/695)) ([4306386](https://github.com/apache/superset/commit/4306386946a04c536c57048a56fe9259b9283036))
- **legacy-plugin-chart-pivot-table:** pivot table chart string aggregation empty values ([#880](https://github.com/apache/superset/issues/880)) ([d3bc089](https://github.com/apache/superset/commit/d3bc0894c50aed825f127f0d09e4be9faed7cd2b))
- **legacy-plugin-chart-pivot-table:** remove nulls from table ([#839](https://github.com/apache/superset/issues/839)) ([6a42164](https://github.com/apache/superset/commit/6a42164a57cc6ecf44580b366dc238cbb036438d))
- **legacy-plugin-chart-sankey-loop:** clear element before redrawing ([#1223](https://github.com/apache/superset/issues/1223)) ([a4bc5ba](https://github.com/apache/superset/commit/a4bc5bae61ffe99fe3e6302db519510374941074)), closes [apache/superset#254](https://github.com/apache/superset/issues/254)
- **legacy-plugin-chart-sankey:** ensure tooltip position is within chart ([#1092](https://github.com/apache/superset/issues/1092)) ([556cd1c](https://github.com/apache/superset/commit/556cd1cc1f8ac1a3b7af1baa5f3e2db62c705e8a))
- **legacy-plugin-chart-sunburst:** chart broken when secondary metric is remove ([#20223](https://github.com/apache/superset/issues/20223)) ([ad72ea5](https://github.com/apache/superset/commit/ad72ea53a1adf802b072235edc0ebb6e7d93e748))
- **legacy-plugin-chart-sunburst:** linear color scheme not work when secondary metric is provided ([#20221](https://github.com/apache/superset/issues/20221)) ([9646591](https://github.com/apache/superset/commit/9646591d240516a7eb1515e70cfb8768352e4f30))
- **legacy-plugin-chart-sunburst:** move color scheme controls to own row ([#1263](https://github.com/apache/superset/issues/1263)) ([ca44905](https://github.com/apache/superset/commit/ca44905adc775f257f138f6bfd53730b9535c9d9))
- **legacy-plugin-chart-table:** parse numeric pageLength ([#522](https://github.com/apache/superset/issues/522)) ([6d04279](https://github.com/apache/superset/commit/6d04279dafb677ffe4024e1b18a777a791aa07d9))
- **legacy-plugin-chart-table:** time column formating ([#340](https://github.com/apache/superset/issues/340)) ([21f82d2](https://github.com/apache/superset/commit/21f82d2e6851315e60a92f2a2b81700b30376c49))
- **legacy-plugin-chart-treemap:** incorrect template literal ([#693](https://github.com/apache/superset/issues/693)) ([4eff7f6](https://github.com/apache/superset/commit/4eff7f68bb6b86f07e5eec574302e30363cb1f25))
- **legacy-plugin-world-map:** set useLegacyApi to true by default ([#444](https://github.com/apache/superset/issues/444)) ([5ff9f22](https://github.com/apache/superset/commit/5ff9f2220a694799357d9684a4f7aa48616b4e0b))
- **legacy-preset-chart-big-number:** example images got mixed up ([#1196](https://github.com/apache/superset/issues/1196)) ([c160a4a](https://github.com/apache/superset/commit/c160a4abde0aa46beaf41a133845850f80994f32))
- **legacy-preset-chart-nvd3:** bar chart unexpected error ([#1276](https://github.com/apache/superset/issues/1276)) ([adff009](https://github.com/apache/superset/commit/adff00922afae1202f8043cf269dd5dccf3c2f06))
- **legacy-preset-chart-nvd3:** custom yAxisFormat for contribution ([#808](https://github.com/apache/superset/issues/808)) ([e5226c9](https://github.com/apache/superset/commit/e5226c9757dcbfe549307d4e4ac9140220eb84fa))
- **legacy-preset-chart-nvd3:** dual line dnd control missing ([#1259](https://github.com/apache/superset/issues/1259)) ([072e494](https://github.com/apache/superset/commit/072e4949e8af4519d2a6996671f71a5c89468eb5))
- **legacy-preset-chart-nvd3:** fix tokenizer input type ([#1049](https://github.com/apache/superset/issues/1049)) ([5b8f9ef](https://github.com/apache/superset/commit/5b8f9efa22449296db7c6ff8b3f503ff79aab0c1))
- **legacy-preset-chart-nvd3:** make deep copy of queryData ([#855](https://github.com/apache/superset/issues/855)) ([b5f5bd1](https://github.com/apache/superset/commit/b5f5bd1182ffbffdc06767df5f66c55491ca18cf))
- **legacy-preset-chart-nvd3:** make wide bar chart scrollable ([#903](https://github.com/apache/superset/issues/903)) ([3170f24](https://github.com/apache/superset/commit/3170f24aff3efcbf20bbcb1144f57c02f704897b))
- **legacy-preset-chart-nvd3:** redraw bar values after legend change ([#7](https://github.com/apache/superset/issues/7)) ([444bb03](https://github.com/apache/superset/commit/444bb039b8eb28fa6f7f9ac9a595d66bf96ac435))
- **legacy-preset-chart-nvd3:** redraw markers after legend interaction ([#6](https://github.com/apache/superset/issues/6)) ([8c382ad](https://github.com/apache/superset/commit/8c382ade40c1f4321d83ad68cc30c74c23d4772b))
- **legacy-preset-chart-nvd3:** remove data fetching from multiline chart ([#899](https://github.com/apache/superset/issues/899)) ([368e198](https://github.com/apache/superset/commit/368e19805d19566f7d97ef4dfc0e1b0b5eafd2a4))
- **legacy-preset-chart-nvd3:** remove unnecessary control override ([#767](https://github.com/apache/superset/issues/767)) ([68c5beb](https://github.com/apache/superset/commit/68c5beb1b581ca7fa4061566a08baec17b13ea3a))
- **legacy-preset-chart-nvd3:** stacked bar charts labels ([#40](https://github.com/apache/superset/issues/40)) ([06bf56f](https://github.com/apache/superset/commit/06bf56fd8306d5502da2380501f9fb3e6636a6dc))
- **legacy-preset-chart-nvd3:** time compare and stacked area tooltips ([#850](https://github.com/apache/superset/issues/850)) ([778a7a5](https://github.com/apache/superset/commit/778a7a58650b9955b0b4f295c862e1a9db58a822))
- **legacy-preset-chart-nvd3:** tooltip's disappearance and stickiness ([#1](https://github.com/apache/superset/issues/1)) ([0ecf719](https://github.com/apache/superset/commit/0ecf719391416ca4ac7d28395ac6d053968d2b5c))
- **legacy-table-chart:** when data is empty ([#397](https://github.com/apache/superset/issues/397)) ([b51674e](https://github.com/apache/superset/commit/b51674e172947d1aa7d3ad850ae0308e712ae57d))
- **legacy-table:** adjust sort icon position ([#399](https://github.com/apache/superset/issues/399)) ([f45ab69](https://github.com/apache/superset/commit/f45ab69462191287a3fb578ee8e29f6e6a2d3db8))
- **legacy-table:** avoid React DOM ([#392](https://github.com/apache/superset/issues/392)) ([51f7667](https://github.com/apache/superset/commit/51f7667e8313e2f9c366fec0015f115aa27921cc))
- **legacy-table:** container height on tall headers ([#398](https://github.com/apache/superset/issues/398)) ([182d112](https://github.com/apache/superset/commit/182d112d866cce277eb6f192de0edd3300dce44d))
- legend types ([1c9c3ad](https://github.com/apache/superset/commit/1c9c3adbb15fc95e2aa003d414bca008db84af6b))
- lerna can't update package-lock.json ([#1432](https://github.com/apache/superset/issues/1432)) ([2443df9](https://github.com/apache/superset/commit/2443df97dfdccdb1c72da1b05102a5bc960b1fac))
- letter format of sort chart in dashboard edit ([#17003](https://github.com/apache/superset/issues/17003)) ([6dc00b3](https://github.com/apache/superset/commit/6dc00b3e3fb34c908578021deb20c5a525191fc4))
- Line Chart Annotation Info Update ([#19001](https://github.com/apache/superset/issues/19001)) ([ac2c66c](https://github.com/apache/superset/commit/ac2c66ccf60fa809f0db749ffa955c5822129ea0))
- line chart does not handle temporal field correctly ([#68](https://github.com/apache/superset/issues/68)) ([2430aa1](https://github.com/apache/superset/commit/2430aa1dbe23c31dfdf3b040e776fd128b441a83))
- line chart tooltip should use full datetime format ([#24](https://github.com/apache/superset/issues/24)) ([4bd482d](https://github.com/apache/superset/commit/4bd482dbc4702030c2b79aae3676950ba1490805))
- line chart tooltip when there is only one lien ([#103](https://github.com/apache/superset/issues/103)) ([de4c481](https://github.com/apache/superset/commit/de4c4816855503d5cce167f6d4253387610e65c4))
- Line not hidden after legend selection ([#204](https://github.com/apache/superset/issues/204)) ([126d409](https://github.com/apache/superset/commit/126d409b65fb4b9ebb79f06b399c064eed69a739))
- **line-chart:** Formula Annotations on Line Charts are broken ([#20687](https://github.com/apache/superset/issues/20687)) ([acdb271](https://github.com/apache/superset/commit/acdb271422b937314d7175ac85eeeac5ead3bc16))
- lint ([b98fecd](https://github.com/apache/superset/commit/b98fecd1bec948e02d6d9edab3ec2e31aaf25c5a))
- lint ([b1074fc](https://github.com/apache/superset/commit/b1074fc872a9072b285f32db0ca8c6d0d2493f81))
- lint ([f01d32d](https://github.com/apache/superset/commit/f01d32d6d132572e227bc4fd7b2b78b576973609))
- lint ([6ca9d8f](https://github.com/apache/superset/commit/6ca9d8f56dad18a5c9550ea996a6a1ce34e582f6))
- lint ([45a3dfe](https://github.com/apache/superset/commit/45a3dfe5b8f090aa3ad0b1fcde03ebbae4cc46d5))
- lint ([#144](https://github.com/apache/superset/issues/144)) ([8028c73](https://github.com/apache/superset/commit/8028c73ccecf3733d9702aaa5b874bb07aa4f3f3))
- lint ([#79](https://github.com/apache/superset/issues/79)) ([eefb1cf](https://github.com/apache/superset/commit/eefb1cf1b72cdbe079da77cbeedfb1abd3fb799b))
- lint errors ([#420](https://github.com/apache/superset/issues/420)) ([62b2a50](https://github.com/apache/superset/commit/62b2a50faf6d85a8302e3c9384a80e4d4595f326))
- **lint:** fix unnecessary type ignore ([#17555](https://github.com/apache/superset/issues/17555)) ([7429282](https://github.com/apache/superset/commit/74292829726ae9c47ca00889907e9421e8dc2b56))
- lints (mostly disabled) ([096454e](https://github.com/apache/superset/commit/096454e9cff12c85f66b14fdbf2144079c28db10))
- list css as side effects ([#57](https://github.com/apache/superset/issues/57)) ([e2f32cb](https://github.com/apache/superset/commit/e2f32cbf0e7f949db3aa2f901d155303e60bee0d))
- **listview:** add nowrap to view mode container ([#18246](https://github.com/apache/superset/issues/18246)) ([8b0634c](https://github.com/apache/superset/commit/8b0634c9edb2919a9e4d03ae81c700368ac0e371))
- Loading indicator of table and schema selectors ([#17040](https://github.com/apache/superset/issues/17040)) ([7c1c89c](https://github.com/apache/superset/commit/7c1c89c94b900ffe3de75c9cb314a75a3b559801))
- local warning in the frontend development ([#17727](https://github.com/apache/superset/issues/17727)) ([142b5bc](https://github.com/apache/superset/commit/142b5bc506c81847e503e76e498c06e8321dffb1))
- **localization:** pybabel doesn't extract plural forms from frontend ([#22507](https://github.com/apache/superset/issues/22507)) ([64496e8](https://github.com/apache/superset/commit/64496e8c8881900c2bfd62f8a78aff1311bf05ac))
- logger message ([#20714](https://github.com/apache/superset/issues/20714)) ([c70d102](https://github.com/apache/superset/commit/c70d102b73704b301d1d2902680cfbf1c0dda605))
- logging warning on dataframe (don't use python's warnings) ([#18111](https://github.com/apache/superset/issues/18111)) ([5fb8b0a](https://github.com/apache/superset/commit/5fb8b0a13a3b50f279007d1934356dcc85298cb5))
- Logic for showing extension in Global Nav ([#19158](https://github.com/apache/superset/issues/19158)) ([181ecf4](https://github.com/apache/superset/commit/181ecf450990c5102c1e9a077dfe7455073fb70d))
- login button does not render ([#19685](https://github.com/apache/superset/issues/19685)) ([2ba484f](https://github.com/apache/superset/commit/2ba484fe43880ee09d6e61d778ad467ab7b0e459))
- Logo resizing on page load ([#19307](https://github.com/apache/superset/issues/19307)) ([d10a3d8](https://github.com/apache/superset/commit/d10a3d8bbad9efec53b372c1962cf8e1eab9d7ce))
- lost renameOperator in mixed timeseries chart ([#19802](https://github.com/apache/superset/issues/19802)) ([108a2a4](https://github.com/apache/superset/commit/108a2a4eafc3150f7b7c33ed734e843a5d5c9f62))
- make a new entrypoint for deprecated postgres dialect ([#20895](https://github.com/apache/superset/issues/20895)) ([4d29d16](https://github.com/apache/superset/commit/4d29d16b64c43bb40b8f399b90296a12e7f66426))
- make all filter operators uppercase ([#378](https://github.com/apache/superset/issues/378)) ([1917d84](https://github.com/apache/superset/commit/1917d84c7abb3efd00fcf75cb54e5921b3ddf98c))
- Make cte_alias a property of db engine spec ([#22947](https://github.com/apache/superset/issues/22947)) ([9dfaad7](https://github.com/apache/superset/commit/9dfaad772d2ac42c35519a55e7b3df27ca03b072))
- make database connection modal ace fields uncontrolled ([#22350](https://github.com/apache/superset/issues/22350)) ([608ffcb](https://github.com/apache/superset/commit/608ffcbfb9d91aa44cdca77cc1b08fcb610209b8))
- make line chart query operate in time series mode ([#71](https://github.com/apache/superset/issues/71)) ([911382f](https://github.com/apache/superset/commit/911382f152dd280b7d30379d4c99bc8a1f8a02a0))
- make max-requests and max-requests-jitter adjustable ([#20733](https://github.com/apache/superset/issues/20733)) ([8832410](https://github.com/apache/superset/commit/883241070f5dd717d188b69dd681af127656283b))
- make pivot table handle null string ([#23](https://github.com/apache/superset/issues/23)) ([d8e8dc4](https://github.com/apache/superset/commit/d8e8dc4111c7137584a29a03f1165e64c4e50349))
- make sure that gsheets db connection form loads properly ([#22361](https://github.com/apache/superset/issues/22361)) ([368e7e6](https://github.com/apache/superset/commit/368e7e6b0855b5335cf1f45d935daa794b4eae34))
- Make the scrollbar appear inside the table ([#1310](https://github.com/apache/superset/issues/1310)) ([fdcc079](https://github.com/apache/superset/commit/fdcc079e18c0e58098796ed635d0435e8f2c4870))
- make translation module type check correctly ([#140](https://github.com/apache/superset/issues/140)) ([a35f88a](https://github.com/apache/superset/commit/a35f88a69e78231411fadb325715edadf72e701d))
- Making chart update more truthful ([#19877](https://github.com/apache/superset/issues/19877)) ([35db7fb](https://github.com/apache/superset/commit/35db7fb6c52465f91452a6ac1f540f4d64413908))
- making crossFilter.chartsInScope optional ([#21030](https://github.com/apache/superset/issues/21030)) ([0042ade](https://github.com/apache/superset/commit/0042ade66f08530e31b7ded7143017ded46b3a3b))
- making location of sorting arrows in Table more consistent. ([#1124](https://github.com/apache/superset/issues/1124)) ([ade57cf](https://github.com/apache/superset/commit/ade57cf9910822ee3ed04435277da6a740c2adc4))
- Making viz components respect D3 Format from metric ([#280](https://github.com/apache/superset/issues/280)) ([652e430](https://github.com/apache/superset/commit/652e43021f9fb77de7a34de0f047001cbbb46671))
- memoize primitives ([#19930](https://github.com/apache/superset/issues/19930)) ([1ebdaac](https://github.com/apache/superset/commit/1ebdaac487ec1684050174957a1d5699912bf001))
- memoized decorator memory leak ([#23139](https://github.com/apache/superset/issues/23139)) ([b14e53e](https://github.com/apache/superset/commit/b14e53e492c5d77309d9a1ccb0080e79785b3398))
- **memorize filter in state:** memorize filter in state ([a71b9f2](https://github.com/apache/superset/commit/a71b9f23185669b3ee7a31d33a6a77aa0764a00f))
- Menu items are not disappearing when deleting a dashboard ([#23039](https://github.com/apache/superset/issues/23039)) ([17fbb2d](https://github.com/apache/superset/commit/17fbb2dbb2357417d81de01308264031606a661f))
- migration out-of-scope bind ([#17728](https://github.com/apache/superset/issues/17728)) ([0d2299c](https://github.com/apache/superset/commit/0d2299cb60b2b646a4280f648f1ca3a2ee44a9a2))
- migration revision order ([#20484](https://github.com/apache/superset/issues/20484)) ([b33c23e](https://github.com/apache/superset/commit/b33c23ef2529c8f6c1537bbd70af47a184ea3f76))
- migration revisions from [#19532](https://github.com/apache/superset/issues/19532) ([#20641](https://github.com/apache/superset/issues/20641)) ([4bfa622](https://github.com/apache/superset/commit/4bfa622d02819dc9d6f6dc252a7ddd2137d12397))
- **migration:** Catch DatabaseError to avoid migration crash with MySQL 8.0 ([#21679](https://github.com/apache/superset/issues/21679)) ([5da20f4](https://github.com/apache/superset/commit/5da20f449d70ffa669137f1513b76acd434a7137))
- **migration:** Ensure key_value LargeBinary is encoded as a MEDIUMBLOB as opposed to BLOB for MySQL ([#20385](https://github.com/apache/superset/issues/20385)) ([f5cb23e](https://github.com/apache/superset/commit/f5cb23e0a39a5d5160f5481ba07838ca48beebf7))
- **migration:** Ensure the paginated update is deterministic ([#21778](https://github.com/apache/superset/issues/21778)) ([88a89c9](https://github.com/apache/superset/commit/88a89c9fd683b50d8a81754199fba6dbb4c7bef3))
- **migrations:** Flask-Migrate output is not logged during alembic migrations [#17991](https://github.com/apache/superset/issues/17991) ([#22991](https://github.com/apache/superset/issues/22991)) ([a2c3ef8](https://github.com/apache/superset/commit/a2c3ef81303b90f36e0101834ddda77186f16f8c))
- **migrations:** reorder skipped 1.4 migrations ([#19543](https://github.com/apache/superset/issues/19543)) ([e1ef2ba](https://github.com/apache/superset/commit/e1ef2baad7bd2081e94af93b5487afe96a7b8292))
- **migrations:** sl_columns is_temporal mapping ([#19786](https://github.com/apache/superset/issues/19786)) ([9c20299](https://github.com/apache/superset/commit/9c20299039e5c2ad0136b6f1f0a9954a5a19116e))
- minor wordcloud update ([1c2b003](https://github.com/apache/superset/commit/1c2b003c3c131b331b9487de50393ff466a9bc84))
- miss-spelling on CONTRIBUTING.md line 1351 ([#17760](https://github.com/apache/superset/issues/17760)) ([71e4131](https://github.com/apache/superset/commit/71e41315a47ec6af4b7509f22e50cb94e515651b))
- missing **init** on module sqllab commands ([#23107](https://github.com/apache/superset/issues/23107)) ([4b03d25](https://github.com/apache/superset/commit/4b03d2553c465969049ff449673ea8a1e3eacb51))
- Missing applied filters indicator ([#22137](https://github.com/apache/superset/issues/22137)) ([e8a0a5e](https://github.com/apache/superset/commit/e8a0a5ee5c470b943b29c3a6f99d6cca41191eef))
- missing bracket, little linty things ([#517](https://github.com/apache/superset/issues/517)) ([2078602](https://github.com/apache/superset/commit/20786020cbbf029598f82a69531859cb973a7f22))
- missing groupby/dimension select options ([#21](https://github.com/apache/superset/issues/21)) ([667d56c](https://github.com/apache/superset/commit/667d56c0d1ebb1c1474ee6a9c09b3a23eb50a3a2))
- missing init on importexport pkg ([#19435](https://github.com/apache/superset/issues/19435)) ([2451937](https://github.com/apache/superset/commit/2451937097c0adfde34d735d9d85997d9340a20d))
- missing nan value in timeseries chart ([#1231](https://github.com/apache/superset/issues/1231)) ([db6b76a](https://github.com/apache/superset/commit/db6b76aa1735576a50b4afa6a2d67e8e6dd1e686))
- Missing spacing in adhoc filters popover ([#22346](https://github.com/apache/superset/issues/22346)) ([3a4131f](https://github.com/apache/superset/commit/3a4131ffc7630e4862f5f3451cbeec5ffc29a01f))
- Mistaken use of BootstrapUser type ([#21892](https://github.com/apache/superset/issues/21892)) ([e418694](https://github.com/apache/superset/commit/e4186941508476780323f67fa6a20332dec057eb))
- **Mixed Timeseries Chart:** Custom Metric Label ([#17649](https://github.com/apache/superset/issues/17649)) ([89d0d38](https://github.com/apache/superset/commit/89d0d38ed0eb211d44de8067bd091392a0f84f85))
- Monospacing errors in dashboards & charts ([#18796](https://github.com/apache/superset/issues/18796)) ([4923256](https://github.com/apache/superset/commit/4923256b01305bb327be5bd52eab26234baa174f))
- Most common flaky Cypress tests ([#21941](https://github.com/apache/superset/issues/21941)) ([7e3e133](https://github.com/apache/superset/commit/7e3e13321b2b86d3a7ef1af30b5863ea9edecf05))
- most Recently Selected Table Should Appear at the Top of the List on the Left Panel ([#19258](https://github.com/apache/superset/issues/19258)) ([4669b6c](https://github.com/apache/superset/commit/4669b6ce11dd74e5d1020a1f124e8696b801d730))
- move columns to datasource object for bootstrap data ([#20203](https://github.com/apache/superset/issues/20203)) ([9432c62](https://github.com/apache/superset/commit/9432c62ec168f449e4ba71112db3c6fc14365710))
- move eslint disable comment in reactify test ([#184](https://github.com/apache/superset/issues/184)) ([3d6ef61](https://github.com/apache/superset/commit/3d6ef61658df6ba970f9b14c8fcf98218cd0f739))
- move padding ([f889a4f](https://github.com/apache/superset/commit/f889a4fd3e0135c6d3b52c532c9ebc346bbc08ff))
- move react to table peerdependency ([#179](https://github.com/apache/superset/issues/179)) ([652d663](https://github.com/apache/superset/commit/652d663d7eb93379e99a56a856ed26c588d49f7e))
- move series in front of xy gridlines ([#119](https://github.com/apache/superset/issues/119)) ([58fce4b](https://github.com/apache/superset/commit/58fce4b6461060e44e01fcb233ed9515056d9612))
- **mssql:** support cte in virtual tables ([#18567](https://github.com/apache/superset/issues/18567)) ([b8aef10](https://github.com/apache/superset/commit/b8aef10098d9b58dff111455c9d45424a2c5b7fc)), closes [#8074](https://github.com/apache/superset/issues/8074) [#8074](https://github.com/apache/superset/issues/8074)
- **mssql:** support top syntax for limiting queries ([#18746](https://github.com/apache/superset/issues/18746)) ([7e51b20](https://github.com/apache/superset/commit/7e51b200b42f598c3344548f5f64521814a1d3cd))
- **mssql:** week time grain should respect datefirst setting ([#10811](https://github.com/apache/superset/issues/10811)) ([211b32a](https://github.com/apache/superset/commit/211b32a4cdb9f970333de7c745612f040d346224))
- native filter dropdown not attached to parent node ([#19399](https://github.com/apache/superset/issues/19399)) ([c5b0dc3](https://github.com/apache/superset/commit/c5b0dc3ea62aa98aa732e0c618e84e7cf68c4e54))
- native filter truncation rerendering loop on hover ([#20021](https://github.com/apache/superset/issues/20021)) ([cede148](https://github.com/apache/superset/commit/cede148d4609a9838b6efad9ab9ba26c91af0636))
- **native filters:** groupby filter issue ([#21084](https://github.com/apache/superset/issues/21084)) ([d79b0bf](https://github.com/apache/superset/commit/d79b0bfc744885f6e6f0b5e9a4128c63c1dea58d))
- **native-filter:** fix required filters of a dashboard won't load properly ([#18695](https://github.com/apache/superset/issues/18695)) ([0b1bc5b](https://github.com/apache/superset/commit/0b1bc5b5de4a71e332d9ea6deaca6c1967042406))
- **native-filters:** Add empty text node before OutPortal ([#22289](https://github.com/apache/superset/issues/22289)) ([ffff3e4](https://github.com/apache/superset/commit/ffff3e4bf4e7e92a1b8cec2be5aedfbb8e173a45))
- **native-filters:** apply default value correctly when it's set ([#17982](https://github.com/apache/superset/issues/17982)) ([35f4c33](https://github.com/apache/superset/commit/35f4c3324565fd0c8af92ca99c53bdd036a83c71))
- **native-filters:** Default value not shown in native filters ([#18963](https://github.com/apache/superset/issues/18963)) ([2072225](https://github.com/apache/superset/commit/2072225a8637299c23c337966c9d5aaaeaaa732b))
- **native-filters:** Don't include description icon in truncation calc ([#22941](https://github.com/apache/superset/issues/22941)) ([32d4977](https://github.com/apache/superset/commit/32d497785a0fa9bb37a88b694e2bc66d337cf163))
- **native-filters:** Ensure that time range filter loses focus after closing modal ([#22937](https://github.com/apache/superset/issues/22937)) ([eaf53db](https://github.com/apache/superset/commit/eaf53dbb27e486455e9b6d8433dac7efae5ad82b))
- **native-filters:** Fix update ownState ([#17181](https://github.com/apache/superset/issues/17181)) ([cf284ba](https://github.com/apache/superset/commit/cf284ba3c72550f64ddb19aeed44de2c5cf0b677))
- **native-filters:** Misc spacing fixes for horizontal and horizontal overflow filter bar items ([#22288](https://github.com/apache/superset/issues/22288)) ([04e0bb9](https://github.com/apache/superset/commit/04e0bb9f36b28a375e64fb84db2ed897691e3477))
- **native-filters:** panels are collapsed when switch native filters ([#21976](https://github.com/apache/superset/issues/21976)) ([9b6322b](https://github.com/apache/superset/commit/9b6322b640a12d5d680bb959414dc12d2277a094))
- **native-filters:** Range filter max/min default display value ([#21680](https://github.com/apache/superset/issues/21680)) ([f784455](https://github.com/apache/superset/commit/f784455264b9376a20f05760bf6d90d1dc1e7010))
- **native-filters:** values is not sorted when setting sort option ([#18145](https://github.com/apache/superset/issues/18145)) ([7c937ca](https://github.com/apache/superset/commit/7c937ca1828e0188da0c7610cced42152185af68))
- Navbar styles and Welcome page text ([#19586](https://github.com/apache/superset/issues/19586)) ([59dda1f](https://github.com/apache/superset/commit/59dda1fa05488c921cacc8791d761cd9f9b86e9c))
- **nav:** infinite redirect and upload dataset nav permissions ([#19708](https://github.com/apache/superset/issues/19708)) ([32a9265](https://github.com/apache/superset/commit/32a9265cc0cb850910e55b6f49a73169fc7ed377))
- **nav:** make doc and bug buttons customizable ([#22682](https://github.com/apache/superset/issues/22682)) ([7b15e6e](https://github.com/apache/superset/commit/7b15e6e3c789f82ce682b011d0904e818dfbadc3))
- **nested-tab-available:** make the another tabs into one tabs available ([#18877](https://github.com/apache/superset/issues/18877)) ([6fe2431](https://github.com/apache/superset/commit/6fe24316765af2e5e004c2daa2ef075e899e235a))
- new alert should have force_screenshot be true ([#18182](https://github.com/apache/superset/issues/18182)) ([a80efa6](https://github.com/apache/superset/commit/a80efa609c3c71bb1c6041148e4868b53041079c))
- new line at end ([8e8d1f7](https://github.com/apache/superset/commit/8e8d1f799d993a9589177a1acebaf1acbad28173))
- New Members per Month time range ([#17783](https://github.com/apache/superset/issues/17783)) ([d9acb28](https://github.com/apache/superset/commit/d9acb280c40a8d01c2098170a8ce7b4656298bdc))
- new welcome new users action ([#21662](https://github.com/apache/superset/issues/21662)) ([389fa31](https://github.com/apache/superset/commit/389fa31b89461c78015b3b3d9a7bbfe61a0b879f))
- No back button in save dataset modal ([#20964](https://github.com/apache/superset/issues/20964)) ([eb5369f](https://github.com/apache/superset/commit/eb5369f2a6f2dc238838119eb70194bf2b42b085))
- None dataset and schema permissions ([#20108](https://github.com/apache/superset/issues/20108)) ([b9a98aa](https://github.com/apache/superset/commit/b9a98aae79705b4db2dab94f1a5fafcf8b821a8b))
- Normalize prequery result type ([#17312](https://github.com/apache/superset/issues/17312)) ([36f489e](https://github.com/apache/superset/commit/36f489eea001cb7ffc8c1f8c7a75d1835aa380b2))
- npm exclude template files ([#34](https://github.com/apache/superset/issues/34)) ([ffcc272](https://github.com/apache/superset/commit/ffcc27270c4ea0289371c5ce9303e4466d53d068))
- npm registry connection set to ssl ([#1395](https://github.com/apache/superset/issues/1395)) ([b0a4f87](https://github.com/apache/superset/commit/b0a4f873d0647b7482f19536d3b51dda2bbe723f))
- null dates in table chart ([#17974](https://github.com/apache/superset/issues/17974)) ([1e544ce](https://github.com/apache/superset/commit/1e544ce5316fad4b2c65127426c8aaffaf71fad3))
- null schema issue in saved queries ([#18849](https://github.com/apache/superset/issues/18849)) ([79633ce](https://github.com/apache/superset/commit/79633ce673dd1cf62b6a5004be1b5bceeddd7597))
- null value and empty string in filter ([#18171](https://github.com/apache/superset/issues/18171)) ([20b4ae1](https://github.com/apache/superset/commit/20b4ae1ef90d311a8588ba164cd7e812220a1f2f))
- Null values on Explore filter ([#19341](https://github.com/apache/superset/issues/19341)) ([65c204b](https://github.com/apache/superset/commit/65c204b2882edd2e6c0f09c61992b58a28a07eef))
- Null values on Treemap right-click ([#21722](https://github.com/apache/superset/issues/21722)) ([0ff1e49](https://github.com/apache/superset/commit/0ff1e49e3c720ed229f6a08daaa70bf14a053dca))
- number format should editable when AA in time comparison ([#19351](https://github.com/apache/superset/issues/19351)) ([e15573d](https://github.com/apache/superset/commit/e15573d4453f8432e2da1db86f2e9417666fb8b5))
- nvd3 annotation tooltip ([#540](https://github.com/apache/superset/issues/540)) ([93212e9](https://github.com/apache/superset/commit/93212e97986e81e37e6f3df6957ac7f59a0db284))
- nvd3 charts break on stateChange dispatch ([#159](https://github.com/apache/superset/issues/159)) ([dd2af3f](https://github.com/apache/superset/commit/dd2af3faa855c0f89b5921f708c876b018ce3a3c))
- nvd3 line chart y axis bounds ([#17](https://github.com/apache/superset/issues/17)) ([54f15d7](https://github.com/apache/superset/commit/54f15d72cbc81cfbcdd742446e2e8338da194a6a))
- nvd3 tooltip bolding/non-linebreak on ONLY header row ([#291](https://github.com/apache/superset/issues/291)) ([7a9d72f](https://github.com/apache/superset/commit/7a9d72f3fe3df181387534f562e76ac05eb55a15))
- Only redirect to relative paths when authentication expires ([#18714](https://github.com/apache/superset/issues/18714)) ([8027f5f](https://github.com/apache/superset/commit/8027f5f0a63425c280121d671ae843e4c420793b))
- only remove tooltips relating to a single vis ([#167](https://github.com/apache/superset/issues/167)) ([f4d01bd](https://github.com/apache/superset/commit/f4d01bd914798a774b3e16742d4b0b353ee2dad7))
- OpenAPI docs small fixes ([#19936](https://github.com/apache/superset/issues/19936)) ([5dd3ea1](https://github.com/apache/superset/commit/5dd3ea154ba5393502671beca72cd5d100cf26b1))
- Order of Select items when unselecting ([#17169](https://github.com/apache/superset/issues/17169)) ([55be249](https://github.com/apache/superset/commit/55be249870251b4fa6186d2fa25177e77719335c))
- **other:** column name in created content on profile page ([#17029](https://github.com/apache/superset/issues/17029)) ([f2d41dc](https://github.com/apache/superset/commit/f2d41dc416da9daf7b4e51487a9c07bf06ba21d7))
- overwrite update override columns on PUT /dataset ([#20862](https://github.com/apache/superset/issues/20862)) ([bc435e0](https://github.com/apache/superset/commit/bc435e08d01b87efcf8774f29a7078cee8988e39))
- Owners selection in dataset edit UX ([#17063](https://github.com/apache/superset/issues/17063)) ([959fd76](https://github.com/apache/superset/commit/959fd763a8b22367e7de5d3438e457f3448c6ceb))
- package.json local file dependencies ([#17957](https://github.com/apache/superset/issues/17957)) ([79b6dc2](https://github.com/apache/superset/commit/79b6dc251e76b3e733f7b82d1ef171e9fb093c00))
- **packages:** Fixing users packages ([#18973](https://github.com/apache/superset/issues/18973)) ([5fc7adb](https://github.com/apache/superset/commit/5fc7adb55b364c2f0f72a7b37f73590038936bf4))
- pandas bug when data is blank on post-processing ([#20629](https://github.com/apache/superset/issues/20629)) ([c2be54c](https://github.com/apache/superset/commit/c2be54c335d14521afc1221749e8554ff23c215b))
- pass all props to transformProps in LineMulti chart ([#247](https://github.com/apache/superset/issues/247)) ([ade25f4](https://github.com/apache/superset/commit/ade25f4c2cef11721d87806f13a5f724324d2571))
- pass in slack error messages properly ([#22727](https://github.com/apache/superset/issues/22727)) ([c58dbf8](https://github.com/apache/superset/commit/c58dbf8b9c7c93f5c15b99557a2ec0c6294201e7))
- Pass slice_id in Explore get ([#21696](https://github.com/apache/superset/issues/21696)) ([f1fbaf8](https://github.com/apache/superset/commit/f1fbaf82449456c00536171612a546afb7bc8f0f))
- passing url params in sqllab ([#15246](https://github.com/apache/superset/issues/15246)) ([57c4d0f](https://github.com/apache/superset/commit/57c4d0f9a42d875d701e94044a5e0eee550d0ab7))
- peer dependencies ([5152708](https://github.com/apache/superset/commit/5152708e8389f63c1e54d80cb472d202841c2127))
- peer dependency version ([39be9ad](https://github.com/apache/superset/commit/39be9ad6f0f22441e22a113a3cfa964a3ecfd284))
- peerDependencies version ([#210](https://github.com/apache/superset/issues/210)) ([13ceb8d](https://github.com/apache/superset/commit/13ceb8dc70680e03486d33de54796da28b86569e))
- **permalink:** remove memoize on get salt func ([#19749](https://github.com/apache/superset/issues/19749)) ([cf51459](https://github.com/apache/superset/commit/cf5145918ba6da3b8b803bed86ad7ca22d50494a))
- permission sqlalchemy events ([#21454](https://github.com/apache/superset/issues/21454)) ([64d216a](https://github.com/apache/superset/commit/64d216adb3239959eea8bb4942114913bea3e194))
- pie chart orientation description error ([#21514](https://github.com/apache/superset/issues/21514)) ([c66205f](https://github.com/apache/superset/commit/c66205feac118a444e30cd6b6cb48d2c2e3d6411))
- Pivot Table Conditional Formatting Doesn't Show All Options ([#19071](https://github.com/apache/superset/issues/19071)) ([0e0bece](https://github.com/apache/superset/commit/0e0beceac173f765d8f9a0887732029b78603f6d))
- pivot-table-fixed ([#1360](https://github.com/apache/superset/issues/1360)) ([4352600](https://github.com/apache/superset/commit/43526009f333c02d812073e89ee75384ca78920e))
- **plugin-chart-echarts:** 'SORT BY METRIC' add checkbox to Gauge ([#1113](https://github.com/apache/superset/issues/1113)) ([62ec367](https://github.com/apache/superset/commit/62ec36745725b08db525203204abda9cb7d6a62c))
- **plugin-chart-echarts:** [feature parity] annotation line chart color not working ([#19758](https://github.com/apache/superset/issues/19758)) ([1156297](https://github.com/apache/superset/commit/11562971fb95a601d11b2902f1704b72409f302d))
- **plugin-chart-echarts:** [feature-parity] apply button of annotation layer doesn't work as expected ([#19761](https://github.com/apache/superset/issues/19761)) ([9f02ff6](https://github.com/apache/superset/commit/9f02ff656d63e537c06822657dcfc2ff46f70e67))
- **plugin-chart-echarts:** [feature-parity] display custom metrics ([#1337](https://github.com/apache/superset/issues/1337)) ([b7e49fc](https://github.com/apache/superset/commit/b7e49fc4db938a51920cc794482b3a31fb41c287))
- **plugin-chart-echarts:** [guage chart] filter indicator not shown ([#1326](https://github.com/apache/superset/issues/1326)) ([6b1b142](https://github.com/apache/superset/commit/6b1b1423b934bb2d8ece0faf8746432dc756c8fa))
- **plugin-chart-echarts:** [scatter-plot] remove contribution mode ([#1325](https://github.com/apache/superset/issues/1325)) ([18c0570](https://github.com/apache/superset/commit/18c05701ddc366bc51424674e09f478230cef01e))
- **plugin-chart-echarts:** [time-series][mixed timeseries] marker control does not work ([#1187](https://github.com/apache/superset/issues/1187)) ([360d4a5](https://github.com/apache/superset/commit/360d4a55f05869b5b18f1df0d035ac24c79708c1))
- **plugin-chart-echarts:** [treemap v2] the section color and disabling the zoom on the explore ([6d10d83](https://github.com/apache/superset/commit/6d10d8305ecf0fb923bcbf561939399b1df4b197))
- **plugin-chart-echarts:** add orderby to funnel chart ([#1099](https://github.com/apache/superset/issues/1099)) ([e994fc0](https://github.com/apache/superset/commit/e994fc08027cadcfdeee96e4e003bc82035819db))
- **plugin-chart-echarts:** add series deduplication ([#1046](https://github.com/apache/superset/issues/1046)) ([6377933](https://github.com/apache/superset/commit/637793342cf7698fb930c282c403c9214b1351ea))
- **plugin-chart-echarts:** Apply temporary filters to Query B in explore ([#18998](https://github.com/apache/superset/issues/18998)) ([9f834e8](https://github.com/apache/superset/commit/9f834e8317dca7c71470c89e2c86bb35ca7ca39f))
- **plugin-chart-echarts:** bar chart overflow ([#20805](https://github.com/apache/superset/issues/20805)) ([9bf7ed5](https://github.com/apache/superset/commit/9bf7ed58cdc1d5523d0cb661f8fdbf7df9b10fe7))
- **plugin-chart-echarts:** boxplot groupby incorrect ([#1448](https://github.com/apache/superset/issues/1448)) ([25da47c](https://github.com/apache/superset/commit/25da47c111b13fe31a77afec0ee3d50b73ede7cf))
- **plugin-chart-echarts:** boxplot throw error in the dashboard ([#21661](https://github.com/apache/superset/issues/21661)) ([61bd696](https://github.com/apache/superset/commit/61bd6962265d879e168f208854fc17b145b9e04d))
- **plugin-chart-echarts:** default to standard x-axis format ([#1043](https://github.com/apache/superset/issues/1043)) ([ed87d47](https://github.com/apache/superset/commit/ed87d473ee3b2f2503837629292af665dae61fa5))
- **plugin-chart-echarts:** disable pie chart animation ([#816](https://github.com/apache/superset/issues/816)) ([1d8f559](https://github.com/apache/superset/commit/1d8f559feb2ff4eefc3500f82436407506d7c965))
- **plugin-chart-echarts:** disabling dragging treemap on the dashboard ([#1109](https://github.com/apache/superset/issues/1109)) ([b6f2df9](https://github.com/apache/superset/commit/b6f2df958369d1071c3690c9e5f9ff92215933c7))
- **plugin-chart-echarts:** enable animation to clear old nodes ([#1200](https://github.com/apache/superset/issues/1200)) ([f27c2ee](https://github.com/apache/superset/commit/f27c2ee528f5dee55b90007dfbeb3aa0f53905ea))
- **plugin-chart-echarts:** fill missing values when stacked chart ([#1014](https://github.com/apache/superset/issues/1014)) ([e861c7b](https://github.com/apache/superset/commit/e861c7b153088289810da0b5ee623f9a66c5d5ef))
- **plugin-chart-echarts:** fix broken boxplot storybook example ([#823](https://github.com/apache/superset/issues/823)) ([7a8275e](https://github.com/apache/superset/commit/7a8275e08c396502344187e52b43803b67a0cd95))
- **plugin-chart-echarts:** fix customize margin ([#18958](https://github.com/apache/superset/issues/18958)) ([c4e3c45](https://github.com/apache/superset/commit/c4e3c45b3c24034205a1ceeb5387d63dc666a7fe))
- **plugin-chart-echarts:** fix default y axis bounds ([#810](https://github.com/apache/superset/issues/810)) ([fdd8067](https://github.com/apache/superset/commit/fdd806723b2220828574ea0f287a73c808dcd6a7))
- **plugin-chart-echarts:** fix forecasts on verbose metrics ([#18252](https://github.com/apache/superset/issues/18252)) ([2929bb1](https://github.com/apache/superset/commit/2929bb1680d29e5fd1d3b351e3e2f86971a60b44))
- **plugin-chart-echarts:** fix GraphViz crash with DnD control ([#991](https://github.com/apache/superset/issues/991)) ([3fd7593](https://github.com/apache/superset/commit/3fd75938dcbc4c5359b302bf9a0650ce5839aeb6))
- **plugin-chart-echarts:** fix incorrect groupby in buildQuery ([#800](https://github.com/apache/superset/issues/800)) ([5d70fd3](https://github.com/apache/superset/commit/5d70fd3946a715ffa55a7d8c16b2999082ec0b72))
- **plugin-chart-echarts:** fix legend margin in radar and ts chart ([#1470](https://github.com/apache/superset/issues/1470)) ([7f44a04](https://github.com/apache/superset/commit/7f44a0402d335b9ea22913a4024386a86f7339ae))
- **plugin-chart-echarts:** fix null labels on pie and funnel charts ([#1270](https://github.com/apache/superset/issues/1270)) ([5ed2ba1](https://github.com/apache/superset/commit/5ed2ba131c747b79121d07207c5553077ac97724))
- **plugin-chart-echarts:** fix opacity on area chart ([#1464](https://github.com/apache/superset/issues/1464)) ([e186adb](https://github.com/apache/superset/commit/e186adb62afaf0e617789ebc29834f87f8409e9e))
- **plugin-chart-echarts:** fix tick labels and tooltip ([#1447](https://github.com/apache/superset/issues/1447)) ([fb5e5af](https://github.com/apache/superset/commit/fb5e5af88a2cd62f0cb3d14b675044b827d7bd98))
- **plugin-chart-echarts:** fix time-series chart xAxisShowMin(Max)Label default value ([#1161](https://github.com/apache/superset/issues/1161)) ([2d408ce](https://github.com/apache/superset/commit/2d408ce6c2a1306a5f46f3723a80f712c0145b6d))
- **plugin-chart-echarts:** fix Time-series line x-filtering not working when not rich tooltip ([#1302](https://github.com/apache/superset/issues/1302)) ([c31892e](https://github.com/apache/superset/commit/c31892e905b596ef20785c25b9b9c75ade9348a7))
- **plugin-chart-echarts:** fix tooltip format in mixed ts chart ([#1143](https://github.com/apache/superset/issues/1143)) ([b9194ad](https://github.com/apache/superset/commit/b9194ad0510201ea321233b227955d64640afe39))
- **plugin-chart-echarts:** fix unnecessary chart clearing ([#1044](https://github.com/apache/superset/issues/1044)) ([53df21d](https://github.com/apache/superset/commit/53df21d7237d58da2897fc3a93e3922265ecdd2b))
- **plugin-chart-echarts:** fix unnecessary highlight ([#1052](https://github.com/apache/superset/issues/1052)) ([cca4b74](https://github.com/apache/superset/commit/cca4b74fd97f0af2940dc2e3d3d074272d21df5e))
- **plugin-chart-echarts:** funnel chart improvements ([#1110](https://github.com/apache/superset/issues/1110)) ([dab8a4b](https://github.com/apache/superset/commit/dab8a4be4bda6a208681073d2094c84bf82f718b))
- **plugin-chart-echarts:** gauge chart enhancements and fixes ([#21007](https://github.com/apache/superset/issues/21007)) ([b303d1e](https://github.com/apache/superset/commit/b303d1e156185d134927246004a4804931cd6bca))
- **plugin-chart-echarts:** improve ECharts visuals ([#806](https://github.com/apache/superset/issues/806)) ([adaa5f8](https://github.com/apache/superset/commit/adaa5f89e6e9a834f2665d7bb316024d337b5f12))
- **plugin-chart-echarts:** improve marksize range ([#1323](https://github.com/apache/superset/issues/1323)) ([d20e08e](https://github.com/apache/superset/commit/d20e08e7f81a511718b27dc548cdd260ab26b885))
- **plugin-chart-echarts:** improve yAxisBounds parsing ([#815](https://github.com/apache/superset/issues/815)) ([fb30d68](https://github.com/apache/superset/commit/fb30d687b7b17fddc78fd8e43237bfb2618b6ea2))
- **plugin-chart-echarts:** include label length in distance calculation ([#1056](https://github.com/apache/superset/issues/1056)) ([99866e7](https://github.com/apache/superset/commit/99866e70c5f2b98f97a3912fabf188def8fb7885))
- **plugin-chart-echarts:** invalid total label location for negative values in stacked bar chart ([#21032](https://github.com/apache/superset/issues/21032)) ([a8ba544](https://github.com/apache/superset/commit/a8ba544e609ad3af449239c1fb956bb18c7066c4))
- **plugin-chart-echarts:** label type and hover bugs ([#942](https://github.com/apache/superset/issues/942)) ([d3bb433](https://github.com/apache/superset/commit/d3bb433560fe72fa46045b3a8423635f0fc38b05))
- **plugin-chart-echarts:** layout broken when resizing ([#20783](https://github.com/apache/superset/issues/20783)) ([d90b973](https://github.com/apache/superset/commit/d90b97323584dbd1602cccaa0aea6ac25f466038))
- **plugin-chart-echarts:** make filtered pie slices semi-transparent ([#1239](https://github.com/apache/superset/issues/1239)) ([8e8a221](https://github.com/apache/superset/commit/8e8a221711392abf41dd9485eb23d6fe6c55348c))
- **plugin-chart-echarts:** make to allow the custome of x & y axis title margin i… ([#18947](https://github.com/apache/superset/issues/18947)) ([c79ee56](https://github.com/apache/superset/commit/c79ee568849761d9c5793ce88f5b7aba8d9e7ac9))
- **plugin-chart-echarts:** missing dnd control in tree chart ([#1260](https://github.com/apache/superset/issues/1260)) ([c2c6bb0](https://github.com/apache/superset/commit/c2c6bb0a35a1aa96f04caffdadd31d8e438bb529))
- **plugin-chart-echarts:** missing value format in mixed timeseries ([#21044](https://github.com/apache/superset/issues/21044)) ([2d1ba46](https://github.com/apache/superset/commit/2d1ba468441b113c574d6fcc5984e8e09ddbc1c6))
- **plugin-chart-echarts:** order by timeseries limit metric ([#1156](https://github.com/apache/superset/issues/1156)) ([2023dc0](https://github.com/apache/superset/commit/2023dc0a49302e61c0127154d6081650d9165fae))
- **plugin-chart-echarts:** radar legend control is duplicated ([#1180](https://github.com/apache/superset/issues/1180)) ([25ec1e3](https://github.com/apache/superset/commit/25ec1e3d491e5804a000e79f8f7b4cd16f65fe60))
- **plugin-chart-echarts:** remove columns from formData ([#901](https://github.com/apache/superset/issues/901)) ([1e8cb81](https://github.com/apache/superset/commit/1e8cb81531ff6d550c04e0aa259dc62dcea3e2c8))
- **plugin-chart-echarts:** remove label line if below threshold ([#1071](https://github.com/apache/superset/issues/1071)) ([31ca397](https://github.com/apache/superset/commit/31ca397c70696e6d118cc94729ee29c348fd0b17))
- **plugin-chart-echarts:** sanitize series from html tags ([#1126](https://github.com/apache/superset/issues/1126)) ([895d9d3](https://github.com/apache/superset/commit/895d9d325d65e083a4bca4a362f43347cd58d463))
- **plugin-chart-echarts:** show zero value in tooltip ([#21296](https://github.com/apache/superset/issues/21296)) ([1aeb8fd](https://github.com/apache/superset/commit/1aeb8fd6b78d5b53501d277f54b46a02f7067163))
- **plugin-chart-echarts:** single select in boxPlot x-filtering ([#1212](https://github.com/apache/superset/issues/1212)) ([0a56420](https://github.com/apache/superset/commit/0a56420066191b0761b6a150e5bb0b308d4e59ba))
- **plugin-chart-echarts:** support adhoc x-axis ([#20055](https://github.com/apache/superset/issues/20055)) ([b53daa9](https://github.com/apache/superset/commit/b53daa91ecf0e82fe219b498e907d0c3f3ca9ccb))
- **plugin-chart-echarts:** tooltip of big number truncated at then bottom ([#20029](https://github.com/apache/superset/issues/20029)) ([35e6e27](https://github.com/apache/superset/commit/35e6e2709c9dec3d9c08280489f42b5b6a8e632e))
- **plugin-chart-echarts:** tooltip overflow bug ([#22218](https://github.com/apache/superset/issues/22218)) ([2e650ea](https://github.com/apache/superset/commit/2e650eaebebc1197549636174f4c3945c55d4d5e))
- **plugin-chart-echarts:** tree graph tooltip polish ([#1182](https://github.com/apache/superset/issues/1182)) ([28003ad](https://github.com/apache/superset/commit/28003ad4dcccacd95cba267daaa6e9dbe3328e9e))
- **plugin-chart-echarts:** use verbose x-axis name when defined ([#18217](https://github.com/apache/superset/issues/18217)) ([cec4677](https://github.com/apache/superset/commit/cec467797187324269971d870520b360c56419f3))
- **plugin-chart-echarts:** xAxis scale is not correct when setting quarter time grain ([#19686](https://github.com/apache/superset/issues/19686)) ([059cb4e](https://github.com/apache/superset/commit/059cb4ec25855b844a9c35be9b6c462595e90a5c))
- **plugin-chart-handlebars:** fix overflow, debounce and control reset ([#19879](https://github.com/apache/superset/issues/19879)) ([d5ea537](https://github.com/apache/superset/commit/d5ea537b0eb3e102677d63811b99cf2c4b31a3ab))
- **plugin-chart-handlebars:** order by control not work ([#21005](https://github.com/apache/superset/issues/21005)) ([e70699f](https://github.com/apache/superset/commit/e70699fb433849e07af81ea1812f20aa271d028e))
- **plugin-chart-handlebars:** Update webpack/babel config to fix build/runtime warnings/errors ([#21779](https://github.com/apache/superset/issues/21779)) ([d5b4bde](https://github.com/apache/superset/commit/d5b4bdeb72e558e78d80e0fdb47249467cb14f03))
- **plugin-chart-pivot-table:** color weight of Conditional formatting metrics not work ([#20396](https://github.com/apache/superset/issues/20396)) ([1665403](https://github.com/apache/superset/commit/16654034849505109b638fd2a784dfb377238a0e))
- **plugin-chart-pivot-table:** cross filtering by adhoc column ([#1465](https://github.com/apache/superset/issues/1465)) ([2b8e4a1](https://github.com/apache/superset/commit/2b8e4a18dced0aee9535393b05d3220954f56416))
- **plugin-chart-pivot-table:** dont apply colors to subtotals ([#1269](https://github.com/apache/superset/issues/1269)) ([7a4ef38](https://github.com/apache/superset/commit/7a4ef386406516c9eaba66c864aedbbd94642729))
- **plugin-chart-pivot-table:** dont display nulls as 0 ([#1265](https://github.com/apache/superset/issues/1265)) ([635c182](https://github.com/apache/superset/commit/635c182c8cef35c89c4b17da83969d67341679d9))
- **plugin-chart-pivot-table:** fix displaying column labels ([#1132](https://github.com/apache/superset/issues/1132)) ([124cd34](https://github.com/apache/superset/commit/124cd34153bb82334705b1f23a467cf438912ab3))
- **plugin-chart-pivot-table:** Invalid Formats Date Fields ([#20909](https://github.com/apache/superset/issues/20909)) ([3f124d9](https://github.com/apache/superset/commit/3f124d9d67f194746da0a49ee2456a0530ec73f9))
- **plugin-chart-pivot-table:** make date formatting clearable ([#1261](https://github.com/apache/superset/issues/1261)) ([35f061a](https://github.com/apache/superset/commit/35f061a39d7626ae898373b3f9c2913370eca795))
- **plugin-chart-pivot-table:** pivot table supports single select ([#1221](https://github.com/apache/superset/issues/1221)) ([89474f8](https://github.com/apache/superset/commit/89474f84e5e1b86cdae012e3700535b11ada5174))
- **plugin-chart-table:** add text align to table header ([#1039](https://github.com/apache/superset/issues/1039)) ([79d561d](https://github.com/apache/superset/commit/79d561d67aa82f7f8576bb92c03e40e161ad0338))
- **plugin-chart-table:** always sort descending by first metric ([#935](https://github.com/apache/superset/issues/935)) ([ea63b7c](https://github.com/apache/superset/commit/ea63b7cf8e95a813a75de90ccfa2db2f11882776))
- **plugin-chart-table:** anchor should keep href ([#661](https://github.com/apache/superset/issues/661)) ([771cf48](https://github.com/apache/superset/commit/771cf48c6b040517ad862ca5ab44579e1e54920b))
- **plugin-chart-table:** apply correct date formatting for time grain ([#1315](https://github.com/apache/superset/issues/1315)) ([42d15c9](https://github.com/apache/superset/commit/42d15c9478427af49004b4e2fb9564f78a6d1f25))
- **plugin-chart-table:** better rendering for temporal columns ([#937](https://github.com/apache/superset/issues/937)) ([79f67fe](https://github.com/apache/superset/commit/79f67fe6c30b46fc1cfd31672bef042236872f82))
- **plugin-chart-table:** change default queryMode to null ([#659](https://github.com/apache/superset/issues/659)) ([c41a607](https://github.com/apache/superset/commit/c41a60726c4a6d912fe95577352aced4d5d5b06b))
- **plugin-chart-table:** check if control values are set ([#1095](https://github.com/apache/superset/issues/1095)) ([33198ab](https://github.com/apache/superset/commit/33198abcfb29b882c5d679e824fb16da72365be7))
- **plugin-chart-table:** chinesee translation improve ([#1189](https://github.com/apache/superset/issues/1189)) ([af43889](https://github.com/apache/superset/commit/af4388988757a8fec2cce5fdc013d1e98e49c418))
- **plugin-chart-table:** fix empty metrics ([#1047](https://github.com/apache/superset/issues/1047)) ([a0d60c0](https://github.com/apache/superset/commit/a0d60c066d6a698ec7f63c983a1dcfa4056d3ff8))
- **plugin-chart-table:** formatting non-numeric metrics ([#663](https://github.com/apache/superset/issues/663)) ([0e1ea12](https://github.com/apache/superset/commit/0e1ea1217c791e0e919873ec58bb3979da4f197f))
- **plugin-chart-table:** hide cell bar for group by fields ([#957](https://github.com/apache/superset/issues/957)) ([eb16861](https://github.com/apache/superset/commit/eb168618c134db7132fbb6be0af58ca84425569c))
- **plugin-chart-table:** hide column configs when no columns ([#1085](https://github.com/apache/superset/issues/1085)) ([679b82b](https://github.com/apache/superset/commit/679b82b491f7d439a0e5def80db68c7db1925b61))
- **plugin-chart-table:** ignore duplicate percent metrics ([#994](https://github.com/apache/superset/issues/994)) ([69a5c90](https://github.com/apache/superset/commit/69a5c9004bca1ad958bfc508f6bf109e1854e605))
- **plugin-chart-table:** metrics should be undefined ([#1005](https://github.com/apache/superset/issues/1005)) ([e03c4ee](https://github.com/apache/superset/commit/e03c4ee4950a489ea8ba9a8d47846d088d75eb59))
- **plugin-chart-table:** refine ordering logic ([#930](https://github.com/apache/superset/issues/930)) ([b011c79](https://github.com/apache/superset/commit/b011c7914b05a7be280ce060f64ce154900cac85))
- **plugin-chart-table:** Resetting controls when switching query mode ([#19792](https://github.com/apache/superset/issues/19792)) ([fcc8080](https://github.com/apache/superset/commit/fcc8080ff3b99e2f5f5cdbd48335d7ab83aba16a))
- **plugin-chart-table:** resize and totals formatting bug ([#1082](https://github.com/apache/superset/issues/1082)) ([6089bcf](https://github.com/apache/superset/commit/6089bcfd8973fe5efbf7bcc95386c2f33f93a7a4))
- **plugin-chart-table:** sort alphanumeric columns case insensitive ([#17765](https://github.com/apache/superset/issues/17765)) ([82b47ca](https://github.com/apache/superset/commit/82b47cacba9653c7837c361be65e10520e9068b3))
- **plugin-chart-table:** sort and search time column ([#669](https://github.com/apache/superset/issues/669)) ([142544c](https://github.com/apache/superset/commit/142544cd44aea5ad71bd08933cb2395ab246daa0))
- **plugin-chart-table:** table clear x-filtering highlighting ([#1222](https://github.com/apache/superset/issues/1222)) ([4051fda](https://github.com/apache/superset/commit/4051fda671b8b6d4b0a4f2ba8266d61cda73b916))
- **plugin-chart-table:** unnecessary post_processing in raw records mode ([#925](https://github.com/apache/superset/issues/925)) ([b4bee55](https://github.com/apache/superset/commit/b4bee55e9fb5371641a70911ecbb6e05caef1317))
- **plugin-chart-table:** Upgrade old color formats ([#21101](https://github.com/apache/superset/issues/21101)) ([8005b7f](https://github.com/apache/superset/commit/8005b7f8c77fa96e0ff32958830ba307db74abff))
- **plugin-chart-table:** value undefined when table name has dot ([#686](https://github.com/apache/superset/issues/686)) ([7b7c8a0](https://github.com/apache/superset/commit/7b7c8a0c1a8bd0af3473639578788bf70dc61975))
- **plugin-chart-word-cloud:** ensure top results are always displayed ([#841](https://github.com/apache/superset/issues/841)) ([b695fc2](https://github.com/apache/superset/commit/b695fc28153e97fe8df7c10ed8478fc8476ef1aa))
- **plugin-chart-word-cloud:** make colors schemes work ([#788](https://github.com/apache/superset/issues/788)) ([e71af2f](https://github.com/apache/superset/commit/e71af2f2b14e5a70fc3ef323a9b86f3e4d32d85a))
- **plugin-chart-word-cloud:** make wordcloud take current formdata ([#428](https://github.com/apache/superset/issues/428)) ([6190450](https://github.com/apache/superset/commit/619045048ffdfc64128d47665eb50c5210cb0900))
- point version badge to npm page ([#821](https://github.com/apache/superset/issues/821)) ([dc1f82d](https://github.com/apache/superset/commit/dc1f82dfce7a6596a63a7aa367bc3e42010dbf1a))
- pointing nvd3 package to nvd3-fork ([#615](https://github.com/apache/superset/issues/615)) ([b182b64](https://github.com/apache/superset/commit/b182b641f60834a82fc3da201843a76cddf634d0))
- Popovers in Explore not attached to the fields they are triggered by ([#19139](https://github.com/apache/superset/issues/19139)) ([0277ebc](https://github.com/apache/superset/commit/0277ebc225889006d9b07c2eedc2caeafdc4e8f8))
- Position of arrows in Table chart ([#18739](https://github.com/apache/superset/issues/18739)) ([a9a8929](https://github.com/apache/superset/commit/a9a892945e6058c92c6e4f63255d799790a9bfa8))
- **postgres:** remove redundant tz factory ([#17713](https://github.com/apache/superset/issues/17713)) ([6a7e649](https://github.com/apache/superset/commit/6a7e6490a9d386850c6b6c31b9bd8abf3caf3ba1))
- Preserve unknown URL params ([#21785](https://github.com/apache/superset/issues/21785)) ([11d7d6e](https://github.com/apache/superset/commit/11d7d6e078b75079c432d8d8028dac45678b2c37))
- **preset-chart-xy:** Pick LegendRenderer ([#118](https://github.com/apache/superset/issues/118)) ([06449c5](https://github.com/apache/superset/commit/06449c521e1ac449cf5f11ca99347e0ad2d43501))
- Presto \_show_columns return type ([#20757](https://github.com/apache/superset/issues/20757)) ([8c0ac90](https://github.com/apache/superset/commit/8c0ac9017f414c36c1b8110a48a242bca3688969))
- **presto,trino:** use correct literal dttm separator ([#20123](https://github.com/apache/superset/issues/20123)) ([e2f11d3](https://github.com/apache/superset/commit/e2f11d3680a8f8a0fba7746b13551e49cdca7fd6))
- **presto/trino:** Add TIME/TIMESTAMP WITH TIME ZONE ([#19263](https://github.com/apache/superset/issues/19263)) ([82a6811](https://github.com/apache/superset/commit/82a6811e7ef3b00e5abbead15377481298764891))
- **presto/trino:** Ensure get_table_names only returns real tables ([#21794](https://github.com/apache/superset/issues/21794)) ([9f7bd1e](https://github.com/apache/superset/commit/9f7bd1e63fbd4084b1dd1ad9b1dd718ff43c7e7c))
- **presto:** expand data with null item ([#17470](https://github.com/apache/superset/issues/17470)) ([8da982b](https://github.com/apache/superset/commit/8da982bc7cd4a0ffa03c58305715459c72803690))
- **presto:** use correct timespec for presto ([#20333](https://github.com/apache/superset/issues/20333)) ([41bbf62](https://github.com/apache/superset/commit/41bbf62e586933172bde4b4080a4f21fe1ccd290))
- prevent caching error pages ([#17100](https://github.com/apache/superset/issues/17100)) ([031f594](https://github.com/apache/superset/commit/031f594fa3624c7f11987a7bf67eef990137ed85))
- preventing sql lab None limit value ([#17155](https://github.com/apache/superset/issues/17155)) ([029ed90](https://github.com/apache/superset/commit/029ed90afb2f81204726cd161ef1eb7a0ac91e23)), closes [#17172](https://github.com/apache/superset/issues/17172) [#17173](https://github.com/apache/superset/issues/17173)
- Prevents last temporal filter removal ([#22982](https://github.com/apache/superset/issues/22982)) ([b63ea63](https://github.com/apache/superset/commit/b63ea6386fedecbacce68bfd552b144b79845cca))
- process color scheme configs correctly ([#17786](https://github.com/apache/superset/issues/17786)) ([de3d397](https://github.com/apache/superset/commit/de3d3973a249ab56b294d3f5d770a79fe8970abd))
- properly set `owners` to Sqlatable.owners_data inside payload ([#20794](https://github.com/apache/superset/issues/20794)) ([84b852c](https://github.com/apache/superset/commit/84b852c45751930fdf8850c519509bdb2e5a5e38))
- publish settings ([1feab46](https://github.com/apache/superset/commit/1feab468e50c48bb11cd0df568e72f05ed3e4ce3))
- Published Dashboard without charts don't show up for non admin users ([#20638](https://github.com/apache/superset/issues/20638)) ([8b354b4](https://github.com/apache/superset/commit/8b354b4b6999e5a2474fb94ffab6b8428c4d4e6e))
- Query execution time is displayed as invalid date ([#19605](https://github.com/apache/superset/issues/19605)) ([e3dbe8d](https://github.com/apache/superset/commit/e3dbe8d8af434f9095309638e1df0a905f7bbf29))
- query execution time is not fully displayed in bubble icon ([#20364](https://github.com/apache/superset/issues/20364)) ([e1532f6](https://github.com/apache/superset/commit/e1532f63aca5dfd1386dd1cbd811f382ab9b7f98))
- **query:** equals operator, duplicate filters and time range endpoints ([#700](https://github.com/apache/superset/issues/700)) ([0e16cbb](https://github.com/apache/superset/commit/0e16cbbeb9cc7d472fa87a6dc3ba2b225e958ef2))
- Race conditions with setupExtensions ([#21647](https://github.com/apache/superset/issues/21647)) ([de444d4](https://github.com/apache/superset/commit/de444d4de6a917af8f8efe2335fb1a26ac86e6d8))
- RBAC for export for dashboard viewers ([#17527](https://github.com/apache/superset/issues/17527)) ([2e29f36](https://github.com/apache/superset/commit/2e29f36e7885b693a0af2cf8b0b8ca86d2970f64))
- **rbac:** show objects accessible by database access perm ([#23118](https://github.com/apache/superset/issues/23118)) ([ae6e2a0](https://github.com/apache/superset/commit/ae6e2a00a029543159d8afb90064e0a8d33a7934))
- Re-add filter-box time granularity/column ([#20485](https://github.com/apache/superset/issues/20485)) ([661ab35](https://github.com/apache/superset/commit/661ab35bd07b22defe45c112f5e5230929b27681))
- Read MAPBOX_API_KEY from environment ([#16926](https://github.com/apache/superset/issues/16926)) ([0870a0b](https://github.com/apache/superset/commit/0870a0b04605e8397df7489d9d5a537ab38c1f1b))
- **readme:** link target and title ([#19576](https://github.com/apache/superset/issues/19576)) ([8610012](https://github.com/apache/superset/commit/861001251d48eb801863a48dd9182ed7504e176d))
- Redirect on 401 ([#17597](https://github.com/apache/superset/issues/17597)) ([46cdc77](https://github.com/apache/superset/commit/46cdc77ae64d0cc55a54719c748391b92a475a33))
- Redirect to full url on 401 ([#19357](https://github.com/apache/superset/issues/19357)) ([b8e5954](https://github.com/apache/superset/commit/b8e595413fa02b5f00c7b91df6283701a5f1b972))
- Redirects old Explore URLs to the new one ([#20812](https://github.com/apache/superset/issues/20812)) ([34278c2](https://github.com/apache/superset/commit/34278c2d56e3e3ac09660227b23fa4b107311ee5))
- Reduce bundle sizes from react-icons ([#1225](https://github.com/apache/superset/issues/1225)) ([4005789](https://github.com/apache/superset/commit/4005789244ce1f9dfb4e615560e0b2f2f66b4dc7))
- reenabling terser plugin for webpack ([#17205](https://github.com/apache/superset/issues/17205)) ([ef01cbb](https://github.com/apache/superset/commit/ef01cbb625f9171ab5d65c821298eee17bfce838))
- Refactor ownership checks and ensure consistency ([#20499](https://github.com/apache/superset/issues/20499)) ([f0ca158](https://github.com/apache/superset/commit/f0ca158989644b793719884b52d04f93c05de1ba))
- Refactor SQL username logic ([#19914](https://github.com/apache/superset/issues/19914)) ([449d08b](https://github.com/apache/superset/commit/449d08b25e5190e42863a2b7c7d95a63fd35a1be))
- refuse to start with default secret on non debug envs ([#23186](https://github.com/apache/superset/issues/23186)) ([c60ba87](https://github.com/apache/superset/commit/c60ba87d0ff6c89b734b6098d2b7c69d11f79bfc))
- regression in [#21766](https://github.com/apache/superset/issues/21766) ([#21782](https://github.com/apache/superset/issues/21782)) ([8f74e46](https://github.com/apache/superset/commit/8f74e46d45ca94f5656f7b881f1096c16657c829))
- Regression on Data and Alerts & Reports Headers ([#19850](https://github.com/apache/superset/issues/19850)) ([7645eac](https://github.com/apache/superset/commit/7645eac31f2cc583906f504e8896e4a119eee751))
- regression on Select component when handling null values ([#19326](https://github.com/apache/superset/issues/19326)) ([9e58916](https://github.com/apache/superset/commit/9e58916d935cf15c3fbe1949dd81f7acec2514c3))
- **releases:** docker build on M1 npm run build fails ([#20700](https://github.com/apache/superset/issues/20700)) ([e6b0141](https://github.com/apache/superset/commit/e6b0141c6769ed9d51dc9674014a559ef6f63a44))
- Remove .ts suffix from NVD3 imports ([#453](https://github.com/apache/superset/issues/453)) ([5e54132](https://github.com/apache/superset/commit/5e541322fdf81ec8538449f374c8e483beaab37c))
- remove & reimplement the tests for AlertReportCronScheduler component ([#19288](https://github.com/apache/superset/issues/19288)) ([7f22edf](https://github.com/apache/superset/commit/7f22edfd0600e14b0d23fe09fd87b28d1cc8363f))
- Remove button is broken for metrics on Explore ([#22940](https://github.com/apache/superset/issues/22940)) ([ebed50f](https://github.com/apache/superset/commit/ebed50fd12c78e523c102abccc38a8d89554f863))
- remove console.log from timeseries chart ([#1208](https://github.com/apache/superset/issues/1208)) ([d66ecb7](https://github.com/apache/superset/commit/d66ecb731335eb5a88b59e740ec9b746468e447e))
- remove deprecated ETagResponseMixin ([#21773](https://github.com/apache/superset/issues/21773)) ([75e6a04](https://github.com/apache/superset/commit/75e6a04269bf73c0c7160290333ded4e63421a4b))
- remove duplicated group by field ([#979](https://github.com/apache/superset/issues/979)) ([3930079](https://github.com/apache/superset/commit/39300798c3e3a59b5b783aa6337f4ec4f6f092bc))
- remove expose ([#19700](https://github.com/apache/superset/issues/19700)) ([57157c8](https://github.com/apache/superset/commit/57157c8b1580545b5ef4d25a4d9039006bc27548))
- remove extra < character in email report ([#18224](https://github.com/apache/superset/issues/18224)) ([987237b](https://github.com/apache/superset/commit/987237b9281243f3d932a2170c9b6b23ba224f23))
- remove extra line for link ([#20959](https://github.com/apache/superset/issues/20959)) ([fa416fa](https://github.com/apache/superset/commit/fa416fa130e2efe93ff0d55092530b4595113e9f))
- remove extras from all adhoc_filters controls ([#21450](https://github.com/apache/superset/issues/21450)) ([e1e9fda](https://github.com/apache/superset/commit/e1e9fda72b27f554a68a740c0f5e8d0b27437315))
- Remove gap from SQLLab results bottom ([#19138](https://github.com/apache/superset/issues/19138)) ([8947eb9](https://github.com/apache/superset/commit/8947eb968024e2eb18167b6fc18ce7f66f6cb90b))
- Remove horizontal scroll navigation from SQL Lab ([#17356](https://github.com/apache/superset/issues/17356)) ([f05a32e](https://github.com/apache/superset/commit/f05a32eeb92f24326d8e85d3d597a279995a4d1d))
- remove is_prequery and prequeries ([#208](https://github.com/apache/superset/issues/208)) ([bffc760](https://github.com/apache/superset/commit/bffc760ac87b5a967b9c9561d6a5baf8401c87a1))
- remove max-width from tooltip div ([#909](https://github.com/apache/superset/issues/909)) ([4db360c](https://github.com/apache/superset/commit/4db360c0a635c5ec8557d6a39ed1b393abe36c6a))
- remove npm logout ([#1433](https://github.com/apache/superset/issues/1433)) ([9565777](https://github.com/apache/superset/commit/95657773c688b3130b6e608ce3cba6d20a8fc349))
- remove package-lock.json ([#1426](https://github.com/apache/superset/issues/1426)) ([58d0246](https://github.com/apache/superset/commit/58d0246f9e0c2cb4ac0be5b412c522509730c7ef))
- remove padding in WithLegend ([70d210c](https://github.com/apache/superset/commit/70d210ca5d58e62e758530ed4f8fded62707e862))
- Remove positions from json_metadata ([#17766](https://github.com/apache/superset/issues/17766)) ([274fb37](https://github.com/apache/superset/commit/274fb37a917e78acd0711b754edf7b833f06911d))
- remove redundant target from sankey tooltip ([#193](https://github.com/apache/superset/issues/193)) ([79c755e](https://github.com/apache/superset/commit/79c755e85f942c38d7e2797f20a12fd9881cee27))
- remove standalone ([#18157](https://github.com/apache/superset/issues/18157)) ([fa11a97](https://github.com/apache/superset/commit/fa11a97585ffa692e097823f04e9d7aa10637286))
- remove sticky tooltip when query returns no data in explore view ([#42](https://github.com/apache/superset/issues/42)) ([8b4bb80](https://github.com/apache/superset/commit/8b4bb80738d8404473f864c86c3afac04cc2d562))
- remove storybook dependency ([#3](https://github.com/apache/superset/issues/3)) ([317f185](https://github.com/apache/superset/commit/317f185d36d8d04c55bc79d8336648dbe1fb287a))
- remove unnecessary divider ([#19048](https://github.com/apache/superset/issues/19048)) ([4d96393](https://github.com/apache/superset/commit/4d96393fafdbf0b2d29a299b4b605ce057daebe2))
- remove unneeded complexity in migration ([#19022](https://github.com/apache/superset/issues/19022)) ([50bb86d](https://github.com/apache/superset/commit/50bb86d6666953b0ceee49f385fd6c523a7b9f1b))
- remove unsupported REST API search col with dotted notation on c… ([#22440](https://github.com/apache/superset/issues/22440)) ([277f8e0](https://github.com/apache/superset/commit/277f8e04e23e4413be76877f909ddafb55d66d55))
- remove variables from styled component ([#17228](https://github.com/apache/superset/issues/17228)) ([9a4ab10](https://github.com/apache/superset/commit/9a4ab1026ed656541789973863a2b5ca1bbc1cec))
- remove whitespace from http_path for databricks ([#22671](https://github.com/apache/superset/issues/22671)) ([cd1f6d4](https://github.com/apache/superset/commit/cd1f6d469b34c7c211c7b990ccfbde8909ecbea4))
- Remove`time_range_endpoints` from query context object ([#19423](https://github.com/apache/superset/issues/19423)) ([129063d](https://github.com/apache/superset/commit/129063d544b0a1313640b3cc6e57f380b8fe27fe))
- removed redundant logger definition ([#17289](https://github.com/apache/superset/issues/17289)) ([4e9f812](https://github.com/apache/superset/commit/4e9f812dab7798d55eae1bd6f383e41d4d3039e5))
- Removes duplicated import in dashboard filter state tests ([#17887](https://github.com/apache/superset/issues/17887)) ([8ebec60](https://github.com/apache/superset/commit/8ebec6016ecd0b729ff149bf1bb051da808f3f95))
- Removes psycopg2 as a required dependency ([#20543](https://github.com/apache/superset/issues/20543)) ([cb3cd41](https://github.com/apache/superset/commit/cb3cd41dcd33af37b06e8ffc4d6d7ae1166d2d7f))
- Removetime_range_endpoints from query context object pt 2 ([#19728](https://github.com/apache/superset/issues/19728)) ([8664202](https://github.com/apache/superset/commit/86642025ba0bb555e6e5d6c058a74e98d997f2e8))
- removing pyproject.toml ([#23101](https://github.com/apache/superset/issues/23101)) ([75495d1](https://github.com/apache/superset/commit/75495d1601235b3d60519a0e6595e7f776c60e63))
- rename datasource->dataset in error message ([#21959](https://github.com/apache/superset/issues/21959)) ([72598a5](https://github.com/apache/superset/commit/72598a5b2ae6e25aa9e6cfb2d6d664ecea158a92))
- rename DnD types to match component names in Superset ([#988](https://github.com/apache/superset/issues/988)) ([93b0c18](https://github.com/apache/superset/commit/93b0c18ce446d101cc6acfd6dd4866ea39007ae7))
- rename file from js to ts ([#75](https://github.com/apache/superset/issues/75)) ([f17bb4a](https://github.com/apache/superset/commit/f17bb4a6c2283ca8e882fe9ba694e7241e578a24))
- rename to schemas_allowed_for_file_upload in dbs.extra ([#17323](https://github.com/apache/superset/issues/17323)) ([0ca4312](https://github.com/apache/superset/commit/0ca4312212ee58b9461106d704321e0907c59e57))
- Reordering native filters ignored by filter bar ([#22362](https://github.com/apache/superset/issues/22362)) ([da64fa2](https://github.com/apache/superset/commit/da64fa2525028d77557b3340edc7a12d2ec7cb90))
- reorganize role permissions ([#23096](https://github.com/apache/superset/issues/23096)) ([7a4cd44](https://github.com/apache/superset/commit/7a4cd44a5dd3faf0baca6b046499173827947588))
- replace absolute difference with difference in echart ([#1383](https://github.com/apache/superset/issues/1383)) ([b309c6b](https://github.com/apache/superset/commit/b309c6bbeac601e456994d405b3b86ec57837b55))
- replace absolute difference with difference in legacy charts ([#1384](https://github.com/apache/superset/issues/1384)) ([d1461c6](https://github.com/apache/superset/commit/d1461c684fa152d65f9183c84d00deff18d4bb13))
- replace datamask with key from new key value api ([#17680](https://github.com/apache/superset/issues/17680)) ([cfd851a](https://github.com/apache/superset/commit/cfd851aa13e1f9642cce014e84669293e65c38bb))
- Replace unsafe lifecycle methods ([#285](https://github.com/apache/superset/issues/285)) ([bce43cb](https://github.com/apache/superset/commit/bce43cb1f9169b99c7974ebcfafd1679912dabf3))
- report list search by created_by ([#18725](https://github.com/apache/superset/issues/18725)) ([59b811a](https://github.com/apache/superset/commit/59b811ac5bf6ea64da8e9343fed28676001b9015))
- Report screenshot cut off on left and right sides ([#22614](https://github.com/apache/superset/issues/22614)) ([0807875](https://github.com/apache/superset/commit/08078753b7e043c0c636c4d6c53ba5d0f287e7b7))
- **report-add:** make to add error toast message when already attached report is added again into dashboard or chart ([#19122](https://github.com/apache/superset/issues/19122)) ([cb03570](https://github.com/apache/superset/commit/cb0357005e323ba08de53948c352cfc04de3c05a))
- **report:** Capture unexpected errors in report screenshots. Fixes [#21653](https://github.com/apache/superset/issues/21653) ([#21724](https://github.com/apache/superset/issues/21724)) ([d1989a4](https://github.com/apache/superset/commit/d1989a4766ca624763fcefe50fa5a4c582e950f6))
- **report:** Fix permission check for set up email report on charts/dashboards. Fixes [#21559](https://github.com/apache/superset/issues/21559) ([#21561](https://github.com/apache/superset/issues/21561)) ([7f971b4](https://github.com/apache/superset/commit/7f971b41037c5f3ad9bf7fada1ff264bb94350f9))
- **reports:** Clear last value when state is WORKING ([#19941](https://github.com/apache/superset/issues/19941)) ([89a844a](https://github.com/apache/superset/commit/89a844a40f55d91d0ca1b6b737cc6a371f770149))
- **reports:** force data generation in csv reports ([#22196](https://github.com/apache/superset/issues/22196)) ([a8bc53d](https://github.com/apache/superset/commit/a8bc53d805b404adf395cf7a844402fffd6fe220))
- **reports:** Owners no longer showing undefined in reports ([#17223](https://github.com/apache/superset/issues/17223)) ([456efc0](https://github.com/apache/superset/commit/456efc0c2053a27083e513b77998f93571c79028))
- request samples with default row limit ([#19456](https://github.com/apache/superset/issues/19456)) ([d684ad0](https://github.com/apache/superset/commit/d684ad073d63953d803cf05b4b208484f1fe7e51))
- resample method shouldn't be freeform ([#21135](https://github.com/apache/superset/issues/21135)) ([fea68ef](https://github.com/apache/superset/commit/fea68ef23cd19853f6ceee42802ac3b4b1b05da0))
- Reset dataset name after saving a new dataset in SQL Lab ([#21529](https://github.com/apache/superset/issues/21529)) ([cbadb87](https://github.com/apache/superset/commit/cbadb8773f06ca62ad4d9ebf04df211af3de9853))
- Reset sorting bar issue in Barchart ([#19371](https://github.com/apache/superset/issues/19371)) ([94e06c2](https://github.com/apache/superset/commit/94e06c2b6a1f782133bb9ef85a1d46ce7eacf9ba))
- resolve issues post `0.10.0` ([5c5a060](https://github.com/apache/superset/commit/5c5a060252bd0acb7f0688bc84f05a07cda5e74b))
- respect chart cache timeout setting ([#21637](https://github.com/apache/superset/issues/21637)) ([5ea9249](https://github.com/apache/superset/commit/5ea924905971338a53604b5d0ef9be5d04aa65db))
- Respecting max/min opacities, and adding tests. ([#20555](https://github.com/apache/superset/issues/20555)) ([ac8e502](https://github.com/apache/superset/commit/ac8e502228d1b247c1b56ee692c2cefade1bf1a9))
- responsive y-axis on stacked charts ([#141](https://github.com/apache/superset/issues/141)) ([a6c10eb](https://github.com/apache/superset/commit/a6c10eb3cfd7532e7127932773d8226a3ab7d5b3))
- Returns 404 instead of 500 for unknown dashboard filter state keys ([#17878](https://github.com/apache/superset/issues/17878)) ([3a9bd12](https://github.com/apache/superset/commit/3a9bd12e3d294450e703ed87937e8e2c6308216e))
- Revert "[#20095](https://github.com/apache/superset/issues/20095) - fix(database): make to display validation error msg when all … ([#21277](https://github.com/apache/superset/issues/21277)) ([4b22137](https://github.com/apache/superset/commit/4b221378cc609fd418e0b43a31239da04804ccee))
- revert "feat(sqla): apply time grain to all temporal groupbys" ([#17239](https://github.com/apache/superset/issues/17239)) ([b7bda70](https://github.com/apache/superset/commit/b7bda7031e6067c5d093d4fceeb539feb7e35777)), closes [#16318](https://github.com/apache/superset/issues/16318)
- Revert "refactor: converted QueryAutoRefresh to functional component … ([#19226](https://github.com/apache/superset/issues/19226)) ([fc87218](https://github.com/apache/superset/commit/fc8721800b00ea8a4a627ec54adb5852857f6d3c)), closes [#18179](https://github.com/apache/superset/issues/18179)
- revert [#17654](https://github.com/apache/superset/issues/17654) to fix subselect table name parsing ([#18017](https://github.com/apache/superset/issues/18017)) ([14b9298](https://github.com/apache/superset/commit/14b9298ef72e73372c2d3f3b1f9f5a1cfb064e1d))
- revert [#21356](https://github.com/apache/superset/issues/21356)(able to sort bar on the bar chart V2) ([#21481](https://github.com/apache/superset/issues/21481)) ([1c0bff3](https://github.com/apache/superset/commit/1c0bff3dfb3649d219abe6a13d9018ded14f334f))
- revert default series limit and update eligible choices ([#1430](https://github.com/apache/superset/issues/1430)) ([4e31029](https://github.com/apache/superset/commit/4e3102935cc10e4a3f407f0e351eb88a2e0bdae0)), closes [#1033](https://github.com/apache/superset/issues/1033)
- Revert default series sort-by metric and enforce non-xor with series limit ([#17236](https://github.com/apache/superset/issues/17236)) ([1c12167](https://github.com/apache/superset/commit/1c12167d8d12b6a092356c008286f6f07f1c9954))
- revert handle null values in time-series table ([#18684](https://github.com/apache/superset/issues/18684)) ([35684c5](https://github.com/apache/superset/commit/35684c54b3150ad9f62ffb845761eba47840e6a7))
- revert permission refactoring PR ([#21313](https://github.com/apache/superset/issues/21313)) ([286474c](https://github.com/apache/superset/commit/286474c3d83903beb37ab5dc650aa2a0977033bb))
- revert RESTful apis and react view for RLS ([#22818](https://github.com/apache/superset/issues/22818)) ([8226110](https://github.com/apache/superset/commit/8226110be8bea6f1b06ce02def7ea56df44e6b50))
- Revert shared controls typing change. ([#22014](https://github.com/apache/superset/issues/22014)) ([4cbd70d](https://github.com/apache/superset/commit/4cbd70db34b140a026ef1a86a8ef0ba3355a350e))
- Reverts [#20749](https://github.com/apache/superset/issues/20749) and [#20645](https://github.com/apache/superset/issues/20645) ([#20796](https://github.com/apache/superset/issues/20796)) ([3311128](https://github.com/apache/superset/commit/3311128c5e6c5de2ea5d6a2dfeb01ea3179e9af8))
- Right click on country map with code filter ([#22081](https://github.com/apache/superset/issues/22081)) ([824dc71](https://github.com/apache/superset/commit/824dc7188b953270ca754f96ca615e96c61dbea4))
- Right-click on misconfigured World Map ([#21697](https://github.com/apache/superset/issues/21697)) ([770f68f](https://github.com/apache/superset/commit/770f68f5b187b573f50f53a80d9cfffb24f0c583))
- RLS new db migration downgrade fails on SQLite ([#20449](https://github.com/apache/superset/issues/20449)) ([ba4ba02](https://github.com/apache/superset/commit/ba4ba0267e6f9f6ce6fed09c5d89965eee5c9f92))
- rm eslint-plugin-translation-vars engine requirement ([#20420](https://github.com/apache/superset/issues/20420)) ([fa7f144](https://github.com/apache/superset/commit/fa7f144a687a438f7a67c99b167dd4af10471712))
- rolling and cum operator in multiple series chart ([#1386](https://github.com/apache/superset/issues/1386)) ([b5dcf1a](https://github.com/apache/superset/commit/b5dcf1ae81209973d1c6a2c0960ee574715e284a))
- rolling and cum operator on multiple series ([#16945](https://github.com/apache/superset/issues/16945)) ([fd84614](https://github.com/apache/superset/commit/fd8461406d62e818c4bc88075ac25ddf44ba9caf))
- running dev-server on a different port ([#17775](https://github.com/apache/superset/issues/17775)) ([4fd6df9](https://github.com/apache/superset/commit/4fd6df9ef89fd7425d998828cce944a0cc4a19a4))
- Save dataset + chart when Chart source is Query ([#20880](https://github.com/apache/superset/issues/20880)) ([0d8889d](https://github.com/apache/superset/commit/0d8889dc9ce9490a8a5502e3400255a74229a031))
- save dataset and repopulate state ([#20965](https://github.com/apache/superset/issues/20965)) ([463406f](https://github.com/apache/superset/commit/463406ff095375613bf0270343a4af53142c84d6))
- Save properties after applying changes in Dashboard ([#17570](https://github.com/apache/superset/issues/17570)) ([12bd1fc](https://github.com/apache/superset/commit/12bd1fcde5bb3f0c5d6897a044a599934acdb902))
- scale type category missing ordinal ([814e572](https://github.com/apache/superset/commit/814e5725c20acc7b17282511d8b155a76ae59711))
- **scatter:** fix legend and labels ([#43](https://github.com/apache/superset/issues/43)) ([c3e5edf](https://github.com/apache/superset/commit/c3e5edf7cf064d12febdb974d5a9ac3190b91ab9))
- **schedule-query:** getUISchema function called in SchemaForm component ([#20256](https://github.com/apache/superset/issues/20256)) ([4137fe0](https://github.com/apache/superset/commit/4137fe03a00e0a5732141895002cd55607b28d64))
- Select clear and loading icons overlap ([#19070](https://github.com/apache/superset/issues/19070)) ([79a7a5d](https://github.com/apache/superset/commit/79a7a5d1b1682f79f1aab1723f76a34dcb9bf030))
- Selected tab after save and go to dashboard ([#21630](https://github.com/apache/superset/issues/21630)) ([6af35a7](https://github.com/apache/superset/commit/6af35a7d982e823e95cf85e35ab1a1f7870714ff))
- **select:** make to consider the case sensitive in case of d3 format selector ([#19159](https://github.com/apache/superset/issues/19159)) ([d099f5e](https://github.com/apache/superset/commit/d099f5ed4ad6f5b553c7e3eedbc34cf5ad55eae7))
- **Select:** options will be overwritten due to seState ([#17951](https://github.com/apache/superset/issues/17951)) ([2ae29c9](https://github.com/apache/superset/commit/2ae29c92812dd134a58e2e5a59093779d65bd831))
- **select:** render when empty multiselect ([#19612](https://github.com/apache/superset/issues/19612)) ([1ad82af](https://github.com/apache/superset/commit/1ad82af058ec79a544f48df7a1aa9b0a165ecfb8))
- **select:** select component sort functionality on certain options ([#17638](https://github.com/apache/superset/issues/17638)) ([f476ba2](https://github.com/apache/superset/commit/f476ba23a279cb87a94ad3075e035cad0ae264b6))
- series limit solution for source is query ([#20977](https://github.com/apache/superset/issues/20977)) ([e350823](https://github.com/apache/superset/commit/e3508232ab3dedef01e055c370e11bcab3263a24))
- set allow `filter_select` for Query objects in Explore ([#20754](https://github.com/apache/superset/issues/20754)) ([81bd496](https://github.com/apache/superset/commit/81bd4968d0a916cb2a20e47b20e31a1434be4f46))
- set correct favicon from config for login and FAB list views ([#21498](https://github.com/apache/superset/issues/21498)) ([b29e7e7](https://github.com/apache/superset/commit/b29e7e7d9e6f4c1f429eb1220f03640596579e9f))
- set correct schema on config import ([#16041](https://github.com/apache/superset/issues/16041)) ([1fbce88](https://github.com/apache/superset/commit/1fbce88a46f188465970209ed99fc392081dc6c9))
- Set fixed maxWidth of the cron schedule modal ([#19485](https://github.com/apache/superset/issues/19485)) ([7cfd892](https://github.com/apache/superset/commit/7cfd892bb9950041b362060a092ac15a8297f6a5))
- set reference to columns properly for sqllab -> explore ([#20747](https://github.com/apache/superset/issues/20747)) ([510c1c4](https://github.com/apache/superset/commit/510c1c4817024af051cc30f315a042c282dbd3b2))
- should be able to remove selection from X-AXIS control ([#21371](https://github.com/apache/superset/issues/21371)) ([eb4ba5b](https://github.com/apache/superset/commit/eb4ba5b08975df2124057c25d3732ef68a0e880a))
- should raise exception when apply a categorical axis ([#20451](https://github.com/apache/superset/issues/20451)) ([8bbbd6f](https://github.com/apache/superset/commit/8bbbd6f03fbd7fccf457706d942f114b7abb682d))
- Show full long number in text email report for table chart. ([#19575](https://github.com/apache/superset/issues/19575)) ([4dc1934](https://github.com/apache/superset/commit/4dc19345d8b1144b6b72cd139313b33fd950936c))
- show onhover menu only in edit mode ([#17034](https://github.com/apache/superset/issues/17034)) ([bdbcfbc](https://github.com/apache/superset/commit/bdbcfbc8fc37bb044fb47477b92eb63717d95f1b))
- show only necessary tick labels on log scale ([#19](https://github.com/apache/superset/issues/19)) ([49a6951](https://github.com/apache/superset/commit/49a6951f4f2bb1c7f093919b1d8cafa790b08c54))
- show question mark icon when can not infer datatype ([#1001](https://github.com/apache/superset/issues/1001)) ([fc149ce](https://github.com/apache/superset/commit/fc149ced493a0c8ff47d83e86311429be7642073))
- show SCHEDULED_QUERIES when defined ([#17854](https://github.com/apache/superset/issues/17854)) ([c6c4143](https://github.com/apache/superset/commit/c6c4143b044a6ed19db2c3c8bc9b5abdd1cb3a78)), closes [/github.com/apache/superset/blob/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b/superset-frontend/src/SqlLab/components/ScheduleQueryButton/index.tsx#L33](https://github.com//github.com/apache/superset/blob/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b/superset-frontend/src/SqlLab/components/ScheduleQueryButton/index.tsx/issues/L33)
- Show sqllab state when deleting databases ([#17331](https://github.com/apache/superset/issues/17331)) ([e5fe186](https://github.com/apache/superset/commit/e5fe18660cd362a8bca6c4465097665415d18d6d))
- show the total row count in the SQL Lab Query History tab when limited by DISPLAY_MAX_ROW ([#19054](https://github.com/apache/superset/issues/19054)) ([bd76648](https://github.com/apache/superset/commit/bd76648e4e74725b95fb927196e690a8be68b2e7))
- Show Totals error with sort and group by together ([#19072](https://github.com/apache/superset/issues/19072)) ([bc6aad0](https://github.com/apache/superset/commit/bc6aad0a88bbbbfd6c592f8813d1b72471788897))
- show value on the selected series ([#1429](https://github.com/apache/superset/issues/1429)) ([3a5bfa6](https://github.com/apache/superset/commit/3a5bfa6488472a38ef874bba6ee07dcd1819d3d9))
- single y axis bounds ([#148](https://github.com/apache/superset/issues/148)) ([e5d1e7c](https://github.com/apache/superset/commit/e5d1e7ca272e347171bb2d4f253bb4000c382c56))
- **SIP-68:** handle empty table name during migration ([#19793](https://github.com/apache/superset/issues/19793)) ([fa68036](https://github.com/apache/superset/commit/fa680369ea66c9713d63b609df19bebe5cd99d08))
- slug is empty if filename is non-ASCII ([#22118](https://github.com/apache/superset/issues/22118)) ([394fb2f](https://github.com/apache/superset/commit/394fb2f2d0e05f27ced88e8ff4fc6994696cab68))
- small bump to shillelagh ([#21953](https://github.com/apache/superset/issues/21953)) ([102909e](https://github.com/apache/superset/commit/102909e00404cd25a62dbd5142790a8e69f1a681))
- small cleanup for created by me dashboards API ([#19755](https://github.com/apache/superset/issues/19755)) ([f06db79](https://github.com/apache/superset/commit/f06db796b5a609915d96b0a176f474d5142d9813))
- small rendering for no results message ([#309](https://github.com/apache/superset/issues/309)) ([eef4699](https://github.com/apache/superset/commit/eef4699807d34c79a3e987f07b9f81c6a837d8c3))
- smartDateVerbose at seconds ([#132](https://github.com/apache/superset/issues/132)) ([cbc1de5](https://github.com/apache/superset/commit/cbc1de5c760e74a891e2c1cdc08fc088c14b2058))
- **snowflake:** Allow encrypted_extra field to be imported ([#22357](https://github.com/apache/superset/issues/22357)) ([d41cb66](https://github.com/apache/superset/commit/d41cb66737fab210f1cd799a3325dad5ef83af4d))
- Source from Apache Foundation's website link ([#18894](https://github.com/apache/superset/issues/18894)) ([7345795](https://github.com/apache/superset/commit/7345795a2f2cc5fbbeca1fc7ea6e3e9ba817bc4a))
- Spacing in alert modal ([#22709](https://github.com/apache/superset/issues/22709)) ([2ccdb72](https://github.com/apache/superset/commit/2ccdb72830ffb549c0112442ba0bc7e4219261d4))
- **SQL Editor:** names new query tabs correctly ([#18951](https://github.com/apache/superset/issues/18951)) ([5a5ff99](https://github.com/apache/superset/commit/5a5ff99c372041e14621bc20015edd1b057cb417))
- SQL Lab cancel query in Redshift database connection does not wo… ([#16326](https://github.com/apache/superset/issues/16326)) ([90d486a](https://github.com/apache/superset/commit/90d486a643e59b44278d2cef64652151eb6248f6)), closes [#16325](https://github.com/apache/superset/issues/16325)
- sql lab crash caused by invalid template ([#17133](https://github.com/apache/superset/issues/17133)) ([96f4421](https://github.com/apache/superset/commit/96f44219615a287db267f9dc1c0073aa038e0ed0))
- sql lab ctrl t behaved differently from clicking ([#19420](https://github.com/apache/superset/issues/19420)) ([56381f4](https://github.com/apache/superset/commit/56381f4ee8a7a1e36fcb33b2b3a5e16793ab0b8b))
- SQL Lab QuerySource via referrer ([#22172](https://github.com/apache/superset/issues/22172)) ([f40e6d1](https://github.com/apache/superset/commit/f40e6d10543e96164ce068cbee93f99a8283ce57))
- SQL Lab sorting of non-numbers ([#18006](https://github.com/apache/superset/issues/18006)) ([27000da](https://github.com/apache/superset/commit/27000da2f8f7cffd9fe9cebbd592238573fc780e))
- **sql Lab tabs:** Empty SQL Lab tabs ([#18817](https://github.com/apache/superset/issues/18817)) ([147dc5a](https://github.com/apache/superset/commit/147dc5af71e67f667dea6990ab1a3efbca5698d6))
- SQL Lab UI Error: Objects are not valid as a React child ([#19783](https://github.com/apache/superset/issues/19783)) ([dfba9ea](https://github.com/apache/superset/commit/dfba9ea596605dc11b29ca1c82615db539e394b2))
- **sql lab:** add quotes when autocompleting table names with spaces in the editor ([#19311](https://github.com/apache/superset/issues/19311)) ([8d4a52c](https://github.com/apache/superset/commit/8d4a52c9d014047baecbdab76f48eb729e3842dc))
- **sql lab:** deleting the last saved query or the last executed from history ([#19225](https://github.com/apache/superset/issues/19225)) ([aa5c80b](https://github.com/apache/superset/commit/aa5c80bda6856295368c937307bcec75bba957cf))
- **sql lab:** display the 'View Results' button consistently in the history tab on sync mode ([#19362](https://github.com/apache/superset/issues/19362)) ([6d5d03e](https://github.com/apache/superset/commit/6d5d03e592087df497a85d1a10447166cc6ab628))
- **sql lab:** increase the size of the action icons in the history tab ([#19313](https://github.com/apache/superset/issues/19313)) ([c6c9188](https://github.com/apache/superset/commit/c6c9188a2405ae326e4055ce611089ec9ae80fbb))
- **sql lab:** MultiSelector component render twice ([#20706](https://github.com/apache/superset/issues/20706)) ([115ab70](https://github.com/apache/superset/commit/115ab700df0f3bf4c8ce0321be7b439c82afc97f))
- **sql lab:** NULL styling in grid cell ([#17385](https://github.com/apache/superset/issues/17385)) ([eb029ab](https://github.com/apache/superset/commit/eb029ab068afb314a892f8945e960813118f71a1))
- **sql lab:** replace the output column in the query history table ([#19370](https://github.com/apache/superset/issues/19370)) ([d4e7c65](https://github.com/apache/superset/commit/d4e7c65f6abc656625d827af362d2b6b0d0e1877))
- **sql lab:** Save Dataset Modal Autocomplete should display list when overwritting ([#20512](https://github.com/apache/superset/issues/20512)) ([8a57a71](https://github.com/apache/superset/commit/8a57a71bed30a781a1d5e5b2ce42ccd08045b3e9))
- **sql lab:** Selecting edit on a query from query history doesn't update the SQL Editor properly ([#19290](https://github.com/apache/superset/issues/19290)) ([bbe0af3](https://github.com/apache/superset/commit/bbe0af348bd0c973ce62f1a0b95fd9b7c04fd97e))
- **sql lab:** SQL Lab Compile Query Delay ([#20206](https://github.com/apache/superset/issues/20206)) ([653cf77](https://github.com/apache/superset/commit/653cf773f7c3337a6a20072e22137db3f7e4e2af))
- **sql lab:** Syntax errors should return with 422 status ([#20491](https://github.com/apache/superset/issues/20491)) ([383313b](https://github.com/apache/superset/commit/383313b105b0e82bea0f38cc971630eded5affe0))
- **sql lab:** table selector should display all the selected tables ([#19257](https://github.com/apache/superset/issues/19257)) ([26a0f05](https://github.com/apache/superset/commit/26a0f0575931850f81a593785d29232f40fd7d71))
- **sql lab:** View result button is not showing consistently ([#20164](https://github.com/apache/superset/issues/20164)) ([9205785](https://github.com/apache/superset/commit/92057858c2ff88c65c69f3818ecebe30d97413f2))
- **sql lab:** when editing a saved query, the status is lost when switching tabs ([#19448](https://github.com/apache/superset/issues/19448)) ([800ced5](https://github.com/apache/superset/commit/800ced5e257d5d83d6dbe4ced0e7318ac40d026f))
- **sql_lab:** Add custom timestamp type for literal casting for presto timestamps ([#13082](https://github.com/apache/superset/issues/13082)) ([1b55778](https://github.com/apache/superset/commit/1b55778427cdb5e4b40074536a3ae2a597f30a69))
- **sql-lab:** do not replace undefined schema with empty object ([#19664](https://github.com/apache/superset/issues/19664)) ([87d4798](https://github.com/apache/superset/commit/87d47987b7800a183f3eebf2cfa7781d450e6e37))
- **sqla:** apply jinja to metrics ([#19565](https://github.com/apache/superset/issues/19565)) ([34b5576](https://github.com/apache/superset/commit/34b55765c4b0cbd8f0b9f89c6ca0f62f4478270e))
- **sqla:** avoid unnecessary groupby for when no metrics ([#18579](https://github.com/apache/superset/issues/18579)) ([55cd7fb](https://github.com/apache/superset/commit/55cd7fb412a497b124633f596ff351358448bea9))
- **sqla:** convert prequery results to native python types ([#17195](https://github.com/apache/superset/issues/17195)) ([2ba046f](https://github.com/apache/superset/commit/2ba046f228595625d1011a945120227508b055b0))
- **sqla:** copy temporal range logic to helper ([#22405](https://github.com/apache/superset/issues/22405)) ([1014a32](https://github.com/apache/superset/commit/1014a327f5ed2e1e4f1daec283825e94c7640d05))
- SQLAlchemy coercing subquery warning on RLS ([#21257](https://github.com/apache/superset/issues/21257)) ([6223042](https://github.com/apache/superset/commit/622304205058d31b34a6590f4c0d652421730464))
- **sqla:** make text clause escaping optional ([#17641](https://github.com/apache/superset/issues/17641)) ([b2ffa26](https://github.com/apache/superset/commit/b2ffa268cd4587d283fd824bea8155d2203db8d1))
- **sqla:** replace custom dttm type with literal_column ([#19917](https://github.com/apache/superset/issues/19917)) ([99f1f9e](https://github.com/apache/superset/commit/99f1f9ec610159db650081d9691835eea0f42b88))
- **sqla:** use same template processor in all methods ([#22280](https://github.com/apache/superset/issues/22280)) ([1ad5147](https://github.com/apache/superset/commit/1ad514701609785f19b27ad495ba34f3b9fff585))
- sqllab schema select error msg ([#18564](https://github.com/apache/superset/issues/18564)) ([151d30b](https://github.com/apache/superset/commit/151d30bea482b446d97917b3b15288780869aff2))
- **sqllab/charts:** casting from timestamp[us] to timestamp[ns] would result in out of bounds timestamp ([#18873](https://github.com/apache/superset/issues/18873)) ([8b72354](https://github.com/apache/superset/commit/8b72354654a8d1eec02510ca011644d3856fa09e))
- **sqllab:** Add templateParams on kv store ([#22013](https://github.com/apache/superset/issues/22013)) ([c3f1873](https://github.com/apache/superset/commit/c3f1873c4314ba19a508118a9876c345e50ab204))
- **sqllab:** Async queries are now fetched properly ([#21698](https://github.com/apache/superset/issues/21698)) ([d21e1d7](https://github.com/apache/superset/commit/d21e1d799d7d5c04606f6b70dbc5666e54a15f39))
- **sqllab:** async query broken due to [#21320](https://github.com/apache/superset/issues/21320) ([#21667](https://github.com/apache/superset/issues/21667)) ([50cb396](https://github.com/apache/superset/commit/50cb396bf23a016d51801f04ce5e330e5b2f73ce))
- **sqllab:** avoid unexpected re-rendering on DatabaseSelector ([#21141](https://github.com/apache/superset/issues/21141)) ([a1389d3](https://github.com/apache/superset/commit/a1389d3a9f90a6dc1ca1fb6203a90f8ba70214a9))
- **sqllab:** avoid unexpected re-rendering on DatabaseSelector ([#21316](https://github.com/apache/superset/issues/21316)) ([e2b77a7](https://github.com/apache/superset/commit/e2b77a7543d851d03ba8cfae2d852381c269b87c))
- **sqllab:** Bugfix for tracking url transformation ([#17263](https://github.com/apache/superset/issues/17263)) ([2544a4a](https://github.com/apache/superset/commit/2544a4a8accf29edb7bb45ffd1c9fc97ddc7ad40))
- **sqllab:** clean unwanted scrollbar ([#22990](https://github.com/apache/superset/issues/22990)) ([a1b7eb3](https://github.com/apache/superset/commit/a1b7eb387078f24dd6d5cbf93682d6167d21b557))
- **sqllab:** Copy link doesn't apply the unsaved changes ([#21311](https://github.com/apache/superset/issues/21311)) ([acd9515](https://github.com/apache/superset/commit/acd9515353a15901a9870e7493bbed238a3e9e88))
- **sqllab:** Fix autocomplete for SQL Lab ([#22329](https://github.com/apache/superset/issues/22329)) ([96de314](https://github.com/apache/superset/commit/96de314c0cee53eaea4008b07b599907a5450f1f))
- **sqllab:** fix control x to stop query ([#21899](https://github.com/apache/superset/issues/21899)) ([88e98d5](https://github.com/apache/superset/commit/88e98d576c12a0802c71315b5f089be834d0774b))
- **sqllab:** Fix cursor alignment in SQL lab editor by avoiding Lucida Console font on Windows ([#21380](https://github.com/apache/superset/issues/21380)) ([3098e65](https://github.com/apache/superset/commit/3098e657e5699b60e5c3e10df1249bc3f4ca1729))
- **sqllab:** fix query results sorting ([#18666](https://github.com/apache/superset/issues/18666)) ([5bb406b](https://github.com/apache/superset/commit/5bb406b296b77292d2191cb92ae0967149c8057b))
- **sqllab:** Fix spacing on Schedule option in SqlEditor dropdown ([#21832](https://github.com/apache/superset/issues/21832)) ([fcb9800](https://github.com/apache/superset/commit/fcb98003a3ffeea25de64082100ca7d9109f9864))
- **sqllab:** Fix tab state ([#20947](https://github.com/apache/superset/issues/20947)) ([c06d5eb](https://github.com/apache/superset/commit/c06d5eb70ce4ee40e3433b3d6e3bf5e4501e50fe))
- **sqllab:** Floating numbers not sorting correctly in result column ([#17573](https://github.com/apache/superset/issues/17573)) ([05752e3](https://github.com/apache/superset/commit/05752e3fe81abf9e9edfd2069e16f4075869775a))
- **sqllab:** Have table name tooltip only show when name is truncated ([#17386](https://github.com/apache/superset/issues/17386)) ([8e1619b](https://github.com/apache/superset/commit/8e1619b1055e50c9ee7cbab650f777ec6a64ef3e))
- **sqllab:** hide tracking url when fetching ([#20905](https://github.com/apache/superset/issues/20905)) ([5ae0e83](https://github.com/apache/superset/commit/5ae0e83b8ae01403639ec23569cd4b840dd154f5))
- **sqllab:** Hover tooltip flashes in SQL Lab ([#17068](https://github.com/apache/superset/issues/17068)) ([635898a](https://github.com/apache/superset/commit/635898a76db13612bcdeafb72a8ef0f06dd5d0f1))
- **sqllab:** inconsistent addNewQueryEditor behavior ([#21999](https://github.com/apache/superset/issues/21999)) ([19779d7](https://github.com/apache/superset/commit/19779d7517b1dcec99d6e9213f21a263a13a6b99))
- **sqllab:** Invalid schema fetch by deprecated value ([#22968](https://github.com/apache/superset/issues/22968)) ([d3d59ee](https://github.com/apache/superset/commit/d3d59ee0ae5aad485d24cb32c4c1754305fc5e0e))
- **sqllab:** Invalid schema fetch for deprecated value ([#22695](https://github.com/apache/superset/issues/22695)) ([d591cc8](https://github.com/apache/superset/commit/d591cc80820c57c54e0e1f7e269527af2ac3c37b))
- **sqllab:** invalid table metadata request ([#21304](https://github.com/apache/superset/issues/21304)) ([222f1e7](https://github.com/apache/superset/commit/222f1e7ea8e95066abd78a06f470d74777f87cc5))
- **sqllab:** make to hide the delete button of most recent query history ([#19358](https://github.com/apache/superset/issues/19358)) ([5db36ec](https://github.com/apache/superset/commit/5db36ec81c0e8b6d4ce8435a77c3dce8a036fec6))
- **sqllab:** missing zero values while copy-to-clipboard ([#21153](https://github.com/apache/superset/issues/21153)) ([4e23d62](https://github.com/apache/superset/commit/4e23d62d4f3714808af8b915caa5790900688526))
- **sqllab:** null database with backend persistence ([#19548](https://github.com/apache/superset/issues/19548)) ([2d81c4c](https://github.com/apache/superset/commit/2d81c4c79f93b9954d5090964b4f140bfb35723e))
- **sqllab:** Overflow bigint in json-tree view ([#22609](https://github.com/apache/superset/issues/22609)) ([a8f3a4f](https://github.com/apache/superset/commit/a8f3a4fb6e90f061a9b87e7366f7f7c7184ca629))
- **sqllab:** perf regression on [#21532](https://github.com/apache/superset/issues/21532) refactor ([#21632](https://github.com/apache/superset/issues/21632)) ([8d1b7ec](https://github.com/apache/superset/commit/8d1b7ecfde4eadbf74af1a467adaf69102acc404))
- **sqllab:** Query limit dropdown number breaks to separate lines ([#17382](https://github.com/apache/superset/issues/17382)) ([1beda79](https://github.com/apache/superset/commit/1beda796f2d5eeaf5a7c6a1d9ba3ff8bffa39dfe))
- **sqllab:** remove link to sqllab if missing perms ([#22566](https://github.com/apache/superset/issues/22566)) ([5b2ca97](https://github.com/apache/superset/commit/5b2ca97341306b8b06ae55ff77eb2528a57f20ce))
- **sqllab:** remove set state on component update lifecycle ([#21771](https://github.com/apache/superset/issues/21771)) ([792820e](https://github.com/apache/superset/commit/792820ef480b7e8c44b5cb3f9c45b51b42add794))
- **sqllab:** Removed the tooltip from CopyToClipboard button in sqllab ([#18749](https://github.com/apache/superset/issues/18749)) ([91236a5](https://github.com/apache/superset/commit/91236a5225d23b3d7b44c3c93cfdf5a41251e6cc))
- **sqllab:** Replace stringified 'null' schema column values with NULL ([#18992](https://github.com/apache/superset/issues/18992)) ([19eb73b](https://github.com/apache/superset/commit/19eb73b3162bcfb404f83fc2d1669422b03f8510))
- **sqllab:** result set min-height ([#21016](https://github.com/apache/superset/issues/21016)) ([58245dd](https://github.com/apache/superset/commit/58245dd7f7343da6b8a1e64be654f3d77991ec4d))
- **sqllab:** resultset disappeared on switching tabs ([#21741](https://github.com/apache/superset/issues/21741)) ([d7ee443](https://github.com/apache/superset/commit/d7ee443a134f88aa7fff8d2d038b50c94fb039e2))
- **sqllab:** reverts [#22695](https://github.com/apache/superset/issues/22695) ([#22861](https://github.com/apache/superset/issues/22861)) ([0045816](https://github.com/apache/superset/commit/0045816772b17d80050a46d6e18e7e5a4edc18fb))
- **sqllab:** SqlEditorLeftBar listening to database changes ([#21628](https://github.com/apache/superset/issues/21628)) ([71bf267](https://github.com/apache/superset/commit/71bf2673071d5db6688fbaefd4457aeeae3464bb))
- **sqllab:** SqlJsonExecutionContext.query null pointer ([#16997](https://github.com/apache/superset/issues/16997)) ([cde4cdc](https://github.com/apache/superset/commit/cde4cdcd0cb23f3b4a34172231ae4318456fda54))
- **sqllab:** tracking url and error alert padding ([#20937](https://github.com/apache/superset/issues/20937)) ([ac58582](https://github.com/apache/superset/commit/ac585821d8d6810d76a244a322cd1e24d15c265a))
- **sqllab:** type error on renderBigIntStr ([#22813](https://github.com/apache/superset/issues/22813)) ([02a3c0d](https://github.com/apache/superset/commit/02a3c0d0e619d7c203889e383c97d6ffdc2ea891))
- **sqllab:** Un-render deselected tabs ([#18934](https://github.com/apache/superset/issues/18934)) ([420a63f](https://github.com/apache/superset/commit/420a63f3436fb01084720aa9fdc863c1766a3262))
- **sqllab:** unable to create new tabs ([#21260](https://github.com/apache/superset/issues/21260)) ([034ee1c](https://github.com/apache/superset/commit/034ee1c3c1fda20b238ba1cc9093a4156d9fa01e))
- **sqllab:** update persistent queryEditor keys ([#21246](https://github.com/apache/superset/issues/21246)) ([ad6b98c](https://github.com/apache/superset/commit/ad6b98c2b7db12b4c555f06bc87fe34f47216247))
- **sqllab:** Updated blank states for query results and query history ([#19111](https://github.com/apache/superset/issues/19111)) ([bb618a4](https://github.com/apache/superset/commit/bb618a47ff1e1747cf66bffa8bceee133a5c9064))
- **sqllab:** wiped out unsaved changes by delayed actions ([#21877](https://github.com/apache/superset/issues/21877)) ([fb8231b](https://github.com/apache/superset/commit/fb8231b50c4ed8fc10db5bc50594b23110bdc515))
- sqloxide optional ([#19570](https://github.com/apache/superset/issues/19570)) ([6136942](https://github.com/apache/superset/commit/61369427594adde9f6a3e6ffcc90ffa54b67adab))
- **sql:** unable to filter text with quotes ([#17881](https://github.com/apache/superset/issues/17881)) ([9671384](https://github.com/apache/superset/commit/9671384efebb2cf77fcd9bedae63192c0cf6570d))
- **ssh_tunnel:** Display SSHTunnel Switch when editing a DB that was created with the Dynamic Form ([#23195](https://github.com/apache/superset/issues/23195)) ([e0a394f](https://github.com/apache/superset/commit/e0a394fe9b5804cc86fc585f338f480bdf8f4a3e))
- **ssh_tunnel:** Fix bug on database edition for databases with ssh tunnels ([#23006](https://github.com/apache/superset/issues/23006)) ([ddd8d17](https://github.com/apache/superset/commit/ddd8d17aa4785918afc5395312678d206a2f100a))
- **ssh-tunnel:** add password to `from_private_key` function ([#23175](https://github.com/apache/superset/issues/23175)) ([f5a5c26](https://github.com/apache/superset/commit/f5a5c261e0691a6d14c8a8080d2c7f81c7d0aafe))
- **ssh-tunnel:** fix dataset creation flow through modal for DB with tunnel ([#22581](https://github.com/apache/superset/issues/22581)) ([d18c7d6](https://github.com/apache/superset/commit/d18c7d6128d7e99f7756ad4006f79df3fb0cc3d6))
- **ssh-tunnel:** update fields for open tunnel with private + private key passwords ([#22764](https://github.com/apache/superset/issues/22764)) ([e6271f0](https://github.com/apache/superset/commit/e6271f0ca7e6b96a8975dac7cea936ecc6c1ca47))
- **ssh-tunnel:** wrap pkey into StringIO buffer before creating the tunnel ([#22763](https://github.com/apache/superset/issues/22763)) ([c536f71](https://github.com/apache/superset/commit/c536f713d6bfd4865f7d853e75c83096e57ec21a))
- **sshtunnel:** argument params to properly setting `server_port` ([#23196](https://github.com/apache/superset/issues/23196)) ([a6d714b](https://github.com/apache/superset/commit/a6d714b0c46c609703c1f6d088ae3f54bae94643))
- Stop query in SQL Lab with impala engine ([#22635](https://github.com/apache/superset/issues/22635)) ([8bf6d80](https://github.com/apache/superset/commit/8bf6d801553a13552831be0fe8ed41bf5171824c))
- string aggregation is incorrect in PivotTableV2 ([#19102](https://github.com/apache/superset/issues/19102)) ([22b7496](https://github.com/apache/superset/commit/22b7496d2ea444ca619aa21f9e820bb610cc5648))
- stringify ValueErrors for NaT types ([#22628](https://github.com/apache/superset/issues/22628)) ([804e89d](https://github.com/apache/superset/commit/804e89d725cd9202ff595d1fe5b49bdffa235d73))
- **style:** throw if there is no theme ([#761](https://github.com/apache/superset/issues/761)) ([9907d13](https://github.com/apache/superset/commit/9907d130634822490059782288eb309b545aad59))
- Styling fixes for horizontal filter bar ([#22337](https://github.com/apache/superset/issues/22337)) ([d2b76a8](https://github.com/apache/superset/commit/d2b76a8b1a42b16c72979693380f26b4d8c02fe5))
- subject Remove margin to fit last label ([#900](https://github.com/apache/superset/issues/900)) ([4e27daf](https://github.com/apache/superset/commit/4e27daf8a2b252e8f96802fc62dd2641b1a5fe06))
- Sunburst chart respects and prefers Metric's D3 Format ([#282](https://github.com/apache/superset/issues/282)) ([97735be](https://github.com/apache/superset/commit/97735be32a41ac9a33c987af14cac5e30fc3bcdd))
- **superset-embedded-sdk:** Buffer is not defined ([#21641](https://github.com/apache/superset/issues/21641)) ([7ec136f](https://github.com/apache/superset/commit/7ec136fec27a29338493745ae91ec110708a8a2a))
- **superset-ui-legacy-preset-chart-deckgl:** fix download map as image ([#25](https://github.com/apache/superset/issues/25)) ([18d0c48](https://github.com/apache/superset/commit/18d0c48333b1b620d586163f080dcc214394204b))
- **superset-ui-query:** add unit tests for [#387](https://github.com/apache/superset/issues/387) ([#390](https://github.com/apache/superset/issues/390)) ([8ab578e](https://github.com/apache/superset/commit/8ab578e121b3057d9086fbae3c7c3eafb916dc32))
- superset-ui/core code coverage ([#20676](https://github.com/apache/superset/issues/20676)) ([8d4994a](https://github.com/apache/superset/commit/8d4994a89900c2cf636444e4febad61ce3b69d68))
- superset-ui/core codes coverage ([#20324](https://github.com/apache/superset/issues/20324)) ([d04357c](https://github.com/apache/superset/commit/d04357c47bec7bac49c602f3d2166375892200ad))
- **superset.cli:** superset cli group doesn't support superset extension app ([#17539](https://github.com/apache/superset/issues/17539)) ([da75028](https://github.com/apache/superset/commit/da7502829527b4a2221cfbb4495859d517d47ec4))
- **superset:** Fixed API for bulk delete of embedded dashboards ([#21911](https://github.com/apache/superset/issues/21911)) ([7edf1fb](https://github.com/apache/superset/commit/7edf1fbdf0593261d1c4e99ae0dbc525bab804a3))
- Support the Clipboard API in modern browsers ([#20058](https://github.com/apache/superset/issues/20058)) ([0e38c68](https://github.com/apache/superset/commit/0e38c686c69dd7c8c5cb4a9b3615b395b02ae973))
- Supports form_data param in old Explore endpoint ([#21469](https://github.com/apache/superset/issues/21469)) ([2c7323a](https://github.com/apache/superset/commit/2c7323a87def2a60581c162db34783a48307e9aa))
- suppress translation warning in jest ([#20404](https://github.com/apache/superset/issues/20404)) ([9fad26f](https://github.com/apache/superset/commit/9fad26fa1919fceda4abdfce0b973d536b42b6af))
- switch form_data between different datasource ([#20867](https://github.com/apache/superset/issues/20867)) ([cb9ae38](https://github.com/apache/superset/commit/cb9ae383614456fc872dbb257a14e30fcf2434bf))
- Switch tab on drag hover ([#21648](https://github.com/apache/superset/issues/21648)) ([b2a360f](https://github.com/apache/superset/commit/b2a360fa14046e384e48ed6273f42eef394ad005))
- Table Autosizing Has Unnecessary Scroll Bars ([#19628](https://github.com/apache/superset/issues/19628)) ([9554135](https://github.com/apache/superset/commit/955413539b3edd892efd6bc069240efb5f5a29ac))
- Table chart column config issue ([#19841](https://github.com/apache/superset/issues/19841)) ([9376940](https://github.com/apache/superset/commit/9376940282475e47b0213cee6336551502463a69))
- Table content disappears when switching between tabs ([#21251](https://github.com/apache/superset/issues/21251)) ([0c87ff7](https://github.com/apache/superset/commit/0c87ff783ac00ad0ac4f7544ff4d910cd2d105b7))
- table viz sort icon bottom aligned ([#20447](https://github.com/apache/superset/issues/20447)) ([93774d1](https://github.com/apache/superset/commit/93774d1860fd40dfee1f18e2787d9d0b79b551e2))
- **table-chart:** don't color empty cells in table chart with color formatters ([#21501](https://github.com/apache/superset/issues/21501)) ([60bab42](https://github.com/apache/superset/commit/60bab4269f1a0ebd42c85aab1ecd8c34ae1b9448))
- **table:** Fix backend pagination table case ([#1007](https://github.com/apache/superset/issues/1007)) ([716a962](https://github.com/apache/superset/commit/716a9624c07f3836cc1edeb40aafebea4fafe645))
- **table:** fix rendering boolean ([#256](https://github.com/apache/superset/issues/256)) ([33e9610](https://github.com/apache/superset/commit/33e96103017bf169bceded3ac822eef3c62bfb67))
- **table:** fix sorting, column width calculation, and text wrapping ([#253](https://github.com/apache/superset/issues/253)) ([7fff83e](https://github.com/apache/superset/commit/7fff83e6dc32e4002885724b877192755561edee))
- **table:** fixed performance issue ([#241](https://github.com/apache/superset/issues/241)) ([aa9f1c0](https://github.com/apache/superset/commit/aa9f1c0b89760895a3cb77b6e45415768e1ecca6))
- **table:** TableVis dynamic height enabled ([#229](https://github.com/apache/superset/issues/229)) ([f8358fc](https://github.com/apache/superset/commit/f8358fcd229057029a7cabae7230d2f92e411a9c)), closes [#233](https://github.com/apache/superset/issues/233)
- **tablevis:** Set proper width for each column ([#189](https://github.com/apache/superset/issues/189)) ([d922d1e](https://github.com/apache/superset/commit/d922d1e244bbe63185d5df3d251188606899a4b5))
- **tablevis:** update datatable change ([02b9772](https://github.com/apache/superset/commit/02b9772ea890d6c3b67a986d97473acb62ef099e))
- **tags:** Adding **init** to tags ([#21591](https://github.com/apache/superset/issues/21591)) ([18ec294](https://github.com/apache/superset/commit/18ec294336865cb88329831fc761294f914c6319))
- take form_data reference for metrics for pivot_v2 table reports ([#21029](https://github.com/apache/superset/issues/21029)) ([e13c5b2](https://github.com/apache/superset/commit/e13c5b2b7b1be52e74643981990eb646ccc76d20))
- Talisman configuration ([#22591](https://github.com/apache/superset/issues/22591)) ([84177cb](https://github.com/apache/superset/commit/84177cbc750b9a72eaaa0d7b624821caa8bb2190))
- **temporary-cache:** when user is anonymous ([#20181](https://github.com/apache/superset/issues/20181)) ([64c4226](https://github.com/apache/superset/commit/64c4226817b04ff598be29b52d8e2c4a679ef70a))
- **teradata:** LIMIT syntax ([#18240](https://github.com/apache/superset/issues/18240)) ([8c37654](https://github.com/apache/superset/commit/8c376548e3cf6464e5710e80120f82227174fcdc))
- **test:** make test_clean_requests_after_schema_grant more idempotent ([#19625](https://github.com/apache/superset/issues/19625)) ([738bd04](https://github.com/apache/superset/commit/738bd04b4fde728474233e562a97a6c84efc8049))
- tests can failed on different order executions ([#17885](https://github.com/apache/superset/issues/17885)) ([886e4ef](https://github.com/apache/superset/commit/886e4ef7f544ec50922fadb96c7edd8ac1102d67))
- **textarea-control:** ace editor input exception ([#18146](https://github.com/apache/superset/issues/18146)) ([7bb8674](https://github.com/apache/superset/commit/7bb867407af99060b8a4eb03a6d8bf8e15569abc))
- The dynamic form to connect to Snowflake DB is not returning any errors ([#20013](https://github.com/apache/superset/issues/20013)) ([c6dd7fe](https://github.com/apache/superset/commit/c6dd7fedbd9547dd5a3374b1c5f30e3337077260))
- the TimePicker overlay the AdhocFilter ([#22234](https://github.com/apache/superset/issues/22234)) ([0fdc520](https://github.com/apache/superset/commit/0fdc52079704ae33ab59385b789b9c4768e8ca63))
- Time Column on Generic X-axis ([#23021](https://github.com/apache/superset/issues/23021)) ([464ddee](https://github.com/apache/superset/commit/464ddee4b4164460193027645d87cb25e7b2320e))
- time comparision ([#19659](https://github.com/apache/superset/issues/19659)) ([d7dd411](https://github.com/apache/superset/commit/d7dd4119d4277dcd4682631de154b6aae27cbe69))
- Time filter position and click in Horizontal FilterBar ([#22338](https://github.com/apache/superset/issues/22338)) ([f64423a](https://github.com/apache/superset/commit/f64423a7409955561a4a27dba6912ad34d717220))
- time filter should be [start, end) ([#19166](https://github.com/apache/superset/issues/19166)) ([e4c9a0d](https://github.com/apache/superset/commit/e4c9a0d8aea3c06abf75cea4ef259bbee804d304))
- time formatter test ([#1012](https://github.com/apache/superset/issues/1012)) ([b354c15](https://github.com/apache/superset/commit/b354c15b0008966d1e5acc901cda6f7c528dc88f))
- time grain can't be removed in explore ([#21644](https://github.com/apache/superset/issues/21644)) ([4c17f0e](https://github.com/apache/superset/commit/4c17f0e71e05caa55410edb2317e084c52a25440))
- time grain key from P0.25Y to P3M ([#21919](https://github.com/apache/superset/issues/21919)) ([c6c9215](https://github.com/apache/superset/commit/c6c9215a2b8651be13151939f7206c78868e2a7c))
- Time Offset in SQLite and refine logic in Date Type conversion ([#21378](https://github.com/apache/superset/issues/21378)) ([2dfcba0](https://github.com/apache/superset/commit/2dfcba04b0e191cc46405a5514f99bf61831f48d))
- Time range filter applied on a dashboard is not persisting to the chart explore ([#22920](https://github.com/apache/superset/issues/22920)) ([e9423c3](https://github.com/apache/superset/commit/e9423c3c878f89124041dc2ee4ffaa7c9f461491))
- **time-format:** remove week number ([#493](https://github.com/apache/superset/issues/493)) ([7140b11](https://github.com/apache/superset/commit/7140b116ad988f5175e2e355fdc5e4088cc158e1))
- **time-series table:** display null values in time-series table and sortable ([#19024](https://github.com/apache/superset/issues/19024)) ([d539fc2](https://github.com/apache/superset/commit/d539fc217a52bb1fc82ebe0f6d5aa2f03031db28))
- Timeseries visualization with Chart Source = Query ([#20795](https://github.com/apache/superset/issues/20795)) ([2c01097](https://github.com/apache/superset/commit/2c010974e8c3607ff19d864c9edd910b1f7920e8))
- title case in menus ([#17135](https://github.com/apache/superset/issues/17135)) ([0257cf7](https://github.com/apache/superset/commit/0257cf774d034f17d60c84cb6d1bd6762d7720fb))
- **tooltip-not-dissapeared:** make the tooltip disappear when mouse away ([#18892](https://github.com/apache/superset/issues/18892)) ([ca93d63](https://github.com/apache/superset/commit/ca93d63bbb72630f90afcd7fc514014cad9b3e52))
- tooltips on nvd3 charts ([#1162](https://github.com/apache/superset/issues/1162)) ([5c0d196](https://github.com/apache/superset/commit/5c0d196c69a6eb33397dddfbcb133b09b5d66f53))
- **translations:** French translation (typo fixes) ([#21942](https://github.com/apache/superset/issues/21942)) ([a993c3c](https://github.com/apache/superset/commit/a993c3ca2c16d5e8dcfeee6fdd800c058a03731c))
- trap SQLAlchemy common exceptions & throw 422 error instead ([#19672](https://github.com/apache/superset/issues/19672)) ([4513cc4](https://github.com/apache/superset/commit/4513cc475831c3fd4869b44255edf91dabe18e0f))
- **treemap-v2:** color scheme not work when there is only one dimension ([#20671](https://github.com/apache/superset/issues/20671)) ([bd6037e](https://github.com/apache/superset/commit/bd6037ef50a579c9e9e3a133482670f6acb5fe5f))
- **Trino:** create `PrestoBaseEngineSpec` base class to share common code between Trino and Presto ([#21066](https://github.com/apache/superset/issues/21066)) ([ccb293a](https://github.com/apache/superset/commit/ccb293a083acbaae8c975059f74cac341c7dbe9a))
- **trino:** Fix Trino timestamp conversion ([#21737](https://github.com/apache/superset/issues/21737)) ([90d79c7](https://github.com/apache/superset/commit/90d79c78d2d507fba28f08a28eaf510e0872c149))
- type of AnnotationLayer ([#21878](https://github.com/apache/superset/issues/21878)) ([f4a4ab4](https://github.com/apache/superset/commit/f4a4ab41e05be90b31ab2f9d2a0f23110bd5df21))
- typing issues surfaced by typescript 3.7 ([#260](https://github.com/apache/superset/issues/260)) ([62e801f](https://github.com/apache/superset/commit/62e801fd0746bb418ae8f83e7d9179fc9cca9ee4))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))
- typo on doc string ([#19346](https://github.com/apache/superset/issues/19346)) ([2af2d00](https://github.com/apache/superset/commit/2af2d00e852032e1d4eaaa50fd7e8d5415a1db16))
- **ui:** Quick Fix for app_icon ([#21399](https://github.com/apache/superset/issues/21399)) ([9ada541](https://github.com/apache/superset/commit/9ada541fd9a69b4bc6c3d1095e5c60f6c7dc955a))
- unable bump new version ([#1434](https://github.com/apache/superset/issues/1434)) ([9b059b8](https://github.com/apache/superset/commit/9b059b8127edf3bb27edbec86d5401cd06efabcf))
- Unable to download the Dashboard as image in case there's an image added through Markdown ([#20362](https://github.com/apache/superset/issues/20362)) ([c5d3678](https://github.com/apache/superset/commit/c5d3678a31e622aab0648c9176883f0932870558))
- Unable to export multiple Dashboards with the same name ([#20383](https://github.com/apache/superset/issues/20383)) ([3fe53f7](https://github.com/apache/superset/commit/3fe53f735e645a96ca5158054b5c9cb26e3e83e7))
- Unable to select None for Alert's log retention ([#17268](https://github.com/apache/superset/issues/17268)) ([85a19a9](https://github.com/apache/superset/commit/85a19a9cc21b47bb701574d6a63b1633686bfb1b))
- unable to set destroyOnClose on ModalTrigger ([#20201](https://github.com/apache/superset/issues/20201)) ([e140b7a](https://github.com/apache/superset/commit/e140b7aa87c06068890ee02379252bcb3cbefe95))
- unable to show view as table modal ([#21025](https://github.com/apache/superset/issues/21025)) ([dfe5a04](https://github.com/apache/superset/commit/dfe5a0493886136620ec3046d315b8d1159503d5))
- Unable to sync columns when dataset name has '+' ([#21019](https://github.com/apache/superset/issues/21019)) ([0c84203](https://github.com/apache/superset/commit/0c8420305368e1ea54deb48535dff77b2c84ba38))
- unambiguous trino driver ([#18683](https://github.com/apache/superset/issues/18683)) ([40ab26d](https://github.com/apache/superset/commit/40ab26d4f14b2fbf24ba46a7bf8c75af1f366c52))
- undefined error when adding extra sequential color scheme ([#18152](https://github.com/apache/superset/issues/18152)) ([c77d24c](https://github.com/apache/superset/commit/c77d24cda31558e374d7a253f02e7131dd6c45f2))
- unexpected commit causes pytest failure ([#20780](https://github.com/apache/superset/issues/20780)) ([922b4b8](https://github.com/apache/superset/commit/922b4b8d1dd6767d9e675ce95b3ffefe16034a7a))
- Unexpected error on simple filter ([#22814](https://github.com/apache/superset/issues/22814)) ([d479009](https://github.com/apache/superset/commit/d479009e35a86dfda321492afeda2a1683a9345a))
- Unhandled exception Str Column Type ([#22147](https://github.com/apache/superset/issues/22147)) ([cc38400](https://github.com/apache/superset/commit/cc38400d7120188b4d0b29f03012ab3e06d952b4))
- Unnecessary queries when changing filter values ([#16994](https://github.com/apache/superset/issues/16994)) ([c471a85](https://github.com/apache/superset/commit/c471a851705a9ca85dabf6090eef3ca368210790))
- unset row_limit when it's not a number ([#387](https://github.com/apache/superset/issues/387)) ([0cb4e4f](https://github.com/apache/superset/commit/0cb4e4f9ffcf4091ba78c7fcea4e317c1a9a5858))
- update chart sorting control labels/descriptions ([#1462](https://github.com/apache/superset/issues/1462)) ([3894cb0](https://github.com/apache/superset/commit/3894cb0e268ee488e042fa774e6e03eb818c8bda))
- update connection modal to use existing catalog ([#20372](https://github.com/apache/superset/issues/20372)) ([160e674](https://github.com/apache/superset/commit/160e674b9049c006d3fada3e99a89a2c9dbe80ac))
- Update eslint error message to reflect location of antd components ([#19857](https://github.com/apache/superset/issues/19857)) ([768e4b7](https://github.com/apache/superset/commit/768e4b7a546f7f6abdbc079f117014eac0cec23d))
- Update exception for DatasourceNotFound from `DatasourceDao.get_datasource()` ([#21217](https://github.com/apache/superset/issues/21217)) ([653c9f0](https://github.com/apache/superset/commit/653c9f0e7fd319bf0a10f75839fa8f89d4fea66f))
- update kubernetes.mdx ([#14512](https://github.com/apache/superset/issues/14512)) ([a304116](https://github.com/apache/superset/commit/a3041166a30fed715f41c13d96e0076e05f249d0))
- update lineMulti when queryData changes ([#782](https://github.com/apache/superset/issues/782)) ([ec1a1a2](https://github.com/apache/superset/commit/ec1a1a2ec5ac78346b4b72d116e05e1c6d8c6cd3))
- Update package-lock.json of superset-frontend and cypress-base ([#17125](https://github.com/apache/superset/issues/17125)) ([5253193](https://github.com/apache/superset/commit/525319370837f5adbb10466f51212289db1d13db))
- update package.json ([9377688](https://github.com/apache/superset/commit/937768808155f8b9ec9c68ce2b883fbfa6e2900a))
- update Permissions for right nav ([#19051](https://github.com/apache/superset/issues/19051)) ([4bf4d58](https://github.com/apache/superset/commit/4bf4d58423e39c3cf3b592adece41049984ffced))
- update slug name ([#17961](https://github.com/apache/superset/issues/17961)) ([765c72a](https://github.com/apache/superset/commit/765c72a8584068fdac85195a71279477a12db632))
- update standalone url for slack reports ([#18756](https://github.com/apache/superset/issues/18756)) ([5d2e726](https://github.com/apache/superset/commit/5d2e726f76cb104552acb1abeda06bd8cd715fe6))
- Update time grain expressions for Spark >= 3.x ([#18690](https://github.com/apache/superset/issues/18690)) ([03b2b06](https://github.com/apache/superset/commit/03b2b06e90f34e67fbda1172eab2c7de6dc8246a))
- Update typo in docker-add-drivers.mdx ([#21965](https://github.com/apache/superset/issues/21965)) ([85c9480](https://github.com/apache/superset/commit/85c9480791b46496b955f22e300171417d6fe01f))
- update values for default timezone selector ([#17124](https://github.com/apache/superset/issues/17124)) ([ae4ced8](https://github.com/apache/superset/commit/ae4ced8da6933cdc657452d1f11415c49c6c68b8))
- update yarn.lock ([#1067](https://github.com/apache/superset/issues/1067)) ([8d1e28c](https://github.com/apache/superset/commit/8d1e28c8bb34d116b279c29323042c74899be61c))
- update yarn.lock for react-icons ([636dc28](https://github.com/apache/superset/commit/636dc28ced343bde810929c0dda8a6a77ce34496))
- Updated connection string for Firebolt ([#17242](https://github.com/apache/superset/issues/17242)) ([0a660a1](https://github.com/apache/superset/commit/0a660a1a3852da0e636c0d4e094d63bb970561b9))
- URI form is blank when trying to connect from sql lab ([#20004](https://github.com/apache/superset/issues/20004)) ([cc026e9](https://github.com/apache/superset/commit/cc026e9fec156bb2f4a89c59d3291a8900a84e0d))
- Use cache_manager.cache rather than cache_manager.data_cache for caching table metadata ([#20726](https://github.com/apache/superset/issues/20726)) ([8bfc9b7](https://github.com/apache/superset/commit/8bfc9b76a6d109dd5ca7bb5c3eb3b64f771f73b5))
- use correct number format ([#47](https://github.com/apache/superset/issues/47)) ([ec5be03](https://github.com/apache/superset/commit/ec5be03d8fbb6a3c44d660f2b53492d654bc6cbb))
- Use Home page in SPA ([#21006](https://github.com/apache/superset/issues/21006)) ([dcab326](https://github.com/apache/superset/commit/dcab32676b4dede51ab12cf1d90a6c1c61697d93))
- use proper time grain when using native filters or filter box ([#1104](https://github.com/apache/superset/issues/1104)) ([e51f034](https://github.com/apache/superset/commit/e51f034317e5dd46afd92f5f0c3547ad3370475a))
- Use SPA Dataset link in Chart and Dashboard ([#20941](https://github.com/apache/superset/issues/20941)) ([96a63bc](https://github.com/apache/superset/commit/96a63bcbfedb72a9f2b3a65eb31fc231d851496f))
- user UUIDs on export for Native Filter Configuration ([#18562](https://github.com/apache/superset/issues/18562)) ([7194a01](https://github.com/apache/superset/commit/7194a01040c679d813c147f17bb6d346b16930ab))
- Users being able to update datasets across DBs ([#17348](https://github.com/apache/superset/issues/17348)) ([a1961cf](https://github.com/apache/superset/commit/a1961cfc6ffc77354c7917d0a5d29d30df1d83ac))
- **utils:** use getaddrinfo for hostname check to support ipv6 ([#21042](https://github.com/apache/superset/issues/21042)) ([2aa3bb6](https://github.com/apache/superset/commit/2aa3bb6c00fa4a86680622e714f818b46962155d))
- **utils:** use getaddrinfo response to support dual-stack port checks ([#21043](https://github.com/apache/superset/issues/21043)) ([38782bb](https://github.com/apache/superset/commit/38782bb98aa1ca85ef97c73ce9b7dea658ee047e))
- Validate required fields in sql_json API ([#21003](https://github.com/apache/superset/issues/21003)) ([a2b21b5](https://github.com/apache/superset/commit/a2b21b55be8941e1756bd6c10f5b3dd063a20ee3))
- various typo fixes in MD files ([#17309](https://github.com/apache/superset/issues/17309)) ([6b1de57](https://github.com/apache/superset/commit/6b1de57207c38ade4a3bb5700e95066cc14f70ee))
- Verify when null value should be undefined in Select ([#17013](https://github.com/apache/superset/issues/17013)) ([a57ae35](https://github.com/apache/superset/commit/a57ae350111586382ea076a98a855ee7e3952202))
- **VERSIONED_EXPORTS:** Ensure dashboards and charts adher to the VERSIONED_EXPORTS feature flag ([#20368](https://github.com/apache/superset/issues/20368)) ([c3fdd52](https://github.com/apache/superset/commit/c3fdd526977318107685e9b9b28540f2eb89227d))
- **ViewQuery-Modal:** Copy icon is out of box when resize query modal ([#21243](https://github.com/apache/superset/issues/21243)) ([1cc2148](https://github.com/apache/superset/commit/1cc214853864760de5bfec409fe5934635711d70))
- **views/core:** iteration over None type ([#14305](https://github.com/apache/superset/issues/14305)) ([c54027a](https://github.com/apache/superset/commit/c54027a0f92251c0f6d18d7277309208360c0b9c))
- Visualizations don't load when using keyboard shortcuts ([#17542](https://github.com/apache/superset/issues/17542)) ([a959e6d](https://github.com/apache/superset/commit/a959e6df453d204b074440c1127d2b30930adfaa))
- **viz-gallery:** respect denylist in viz gallery ([#22658](https://github.com/apache/superset/issues/22658)) ([08f45ef](https://github.com/apache/superset/commit/08f45ef207fb159bf0de49dd0a90f423c77965a7))
- **viz:** BigQuery time grain 'minute'/'second' throws an error ([#20350](https://github.com/apache/superset/issues/20350)) ([5afeba3](https://github.com/apache/superset/commit/5afeba34bd72526844d0f71764309a6669d96c5a))
- **viz:** Header scrolling for Time Table in dashboard ([#20874](https://github.com/apache/superset/issues/20874)) ([99085d5](https://github.com/apache/superset/commit/99085d583ddadf8e092f6648195cde29efef6976))
- **webdriver:** default WEBDRIVER_OPTION_ARGS and update Firefox deps ([#23388](https://github.com/apache/superset/issues/23388)) ([b92e4fb](https://github.com/apache/superset/commit/b92e4fb49ea8756dbedff17cc20d5f746ea5df1f))
- **websocket:** bump ts-node to fix startup error ([#22563](https://github.com/apache/superset/issues/22563)) ([7df1d70](https://github.com/apache/superset/commit/7df1d70a9512bfed146b4026d1e0d6f69165804a))
- weight tooltip issue ([#19397](https://github.com/apache/superset/issues/19397)) ([f6d550b](https://github.com/apache/superset/commit/f6d550b7fc3643350483850064e65dbd3d026dc4))
- welcome page user authentication check ([#20605](https://github.com/apache/superset/issues/20605)) ([92bf1b8](https://github.com/apache/superset/commit/92bf1b8ef6b42c9624876a2433077173818795b6))
- word cloud import bug ([#65](https://github.com/apache/superset/issues/65)) ([381d51d](https://github.com/apache/superset/commit/381d51d8a40723e0938ba5d9b96e572234434461))
- Workaround for sqlparse issue [#652](https://github.com/apache/superset/issues/652) ([#17995](https://github.com/apache/superset/issues/17995)) ([63ca09e](https://github.com/apache/superset/commit/63ca09e345ef8a474625d7baae4f0c4f0a44c0d1))
- World Map right-click value ([#21209](https://github.com/apache/superset/issues/21209)) ([d41f44f](https://github.com/apache/superset/commit/d41f44fcdf387072bc5d7700a5e8871c6594baef))
- **world-map:** remove categorical color option ([#19781](https://github.com/apache/superset/issues/19781)) ([5e468f7](https://github.com/apache/superset/commit/5e468f7a4cccc496ccafa52f9aba5b7688145fe4))
- wrong type for filters field ([#183](https://github.com/apache/superset/issues/183)) ([3d6d622](https://github.com/apache/superset/commit/3d6d622b18da74c38b45bbe8f08c8513e4cca9f1))
- X Axis should be called Y Axis when using the Bar Chart V2 on Horizontal mode ([#20659](https://github.com/apache/superset/issues/20659)) ([c29261b](https://github.com/apache/superset/commit/c29261b63dee723f108b3404e29a498ecf8421f8))
- y axis bounds when input are nan ([#22](https://github.com/apache/superset/issues/22)) ([532feac](https://github.com/apache/superset/commit/532feac81a9ce2fd46c92fbaac5c0bacbb25ce48))
- y-axis bounds for stacked viz types ([#45](https://github.com/apache/superset/issues/45)) ([dde88df](https://github.com/apache/superset/commit/dde88df4e02797c330754a5ec199cb61bf71137e))

### Code Refactoring

- **chart:** remove and rename fields in ChartProps ([#174](https://github.com/apache/superset/issues/174)) ([3df26ae](https://github.com/apache/superset/commit/3df26ae76da8e2945d6416bb8a61176191410804))
- make @superset-ui/core peer dependency ([#111](https://github.com/apache/superset/issues/111)) ([ca04f8c](https://github.com/apache/superset/commit/ca04f8ce85e2b4dd1153a862c0788f013c797ba1))

- Add overwritePolicy for Registry (#37) ([307ce86](https://github.com/apache/superset/commit/307ce86ecefd52219a78a53ae7231468d7e7d24e)), closes [#37](https://github.com/apache/superset/issues/37)
- Rename `D3Formatter` to `D3NumberFormatter` (#36) ([f6ea69b](https://github.com/apache/superset/commit/f6ea69b7b275ea65cce5344573921472bf8bd5c5)), closes [#36](https://github.com/apache/superset/issues/36)
- Rename ColorScheme field 'name' to 'id' (#35) ([4e39bf7](https://github.com/apache/superset/commit/4e39bf7f6eadbef19aaed48aec10cba6eeaf9164)), closes [#35](https://github.com/apache/superset/issues/35)
- Make CategoricalColorScale instance a function and remove .toFunction() (#33) ([af725ce](https://github.com/apache/superset/commit/af725ce874563b9c02af1e9248ed751074c352b8)), closes [#33](https://github.com/apache/superset/issues/33)

### Features

- add tableselector to dataset creation page ([#21075](https://github.com/apache/superset/issues/21075)) ([8c2719b](https://github.com/apache/superset/commit/8c2719b11cebe451c5ba68193cf8dd51e4dce8e3))
- 🎸 add .clone() function to ChartMetadata ([#112](https://github.com/apache/superset/issues/112)) ([9454aed](https://github.com/apache/superset/commit/9454aed59f43d7bc634c174f9784c49c0c7f2560))
- 🎸 Improved QueryObject to handle more fields ([#116](https://github.com/apache/superset/issues/116)) ([86c0c26](https://github.com/apache/superset/commit/86c0c262130e384d4379b93110349226eff5ca95))
- 🎸 line chart makes first appearance ([7d3e683](https://github.com/apache/superset/commit/7d3e6835c8ad85560d93049c949236f3646053f6))
- 🚀 Docs V2 CI Script ([#18560](https://github.com/apache/superset/issues/18560)) ([9c3205b](https://github.com/apache/superset/commit/9c3205b5733a10ba9464f86674d23e61a0cf77e3))
- 10/15/30 min grain to Pinot ([#19724](https://github.com/apache/superset/issues/19724)) ([a6f4601](https://github.com/apache/superset/commit/a6f46013d966b243fbdca072e7898cdbf2a2f3d6))
- a simple LRUCache in frontend ([#20842](https://github.com/apache/superset/issues/20842)) ([55a89df](https://github.com/apache/superset/commit/55a89dfac93f9855dbf1beb2ee0c0f21da54095b))
- add 'dashboard.nav.right' extension to registry ([#20835](https://github.com/apache/superset/issues/20835)) ([226712d](https://github.com/apache/superset/commit/226712d831a80cc44213c5ce8ed921518ea0397c))
- add @superset-ui/superset-ui package as one-stop install ([#255](https://github.com/apache/superset/issues/255)) ([4274520](https://github.com/apache/superset/commit/42745207811a84e5ee79db208f03c2b1b1e7c1ad))
- Add 3 new extension points for inserting custom icons ([#22027](https://github.com/apache/superset/issues/22027)) ([c870fbe](https://github.com/apache/superset/commit/c870fbe9e290e9305e6019bb4e9932bbd736b6dc))
- add a `where_in` filter for Jinja2 ([#19574](https://github.com/apache/superset/issues/19574)) ([83c3779](https://github.com/apache/superset/commit/83c3779a6c3f7cc371dd8b8bf70519ec473954db))
- add a config to enable retina quality images in screenshots ([#17409](https://github.com/apache/superset/issues/17409)) ([3ee9e11](https://github.com/apache/superset/commit/3ee9e11ce1bfc2f74ef8bfcd2ee0cc6a3f2249ef))
- Add a new database driver for Amazon DynamoDB ([#22077](https://github.com/apache/superset/issues/22077)) ([b32de3d](https://github.com/apache/superset/commit/b32de3dd9eba41dd850fafb35f24d276bd48c32f))
- add Advanced Analytics into mixed time series chart ([#19851](https://github.com/apache/superset/issues/19851)) ([f5e9f0e](https://github.com/apache/superset/commit/f5e9f0eb3b2045a9d441f59cb3a6109892e6aea9))
- add basic functionality for icicle chart to display static data ([#165](https://github.com/apache/superset/issues/165)) ([53a9943](https://github.com/apache/superset/commit/53a994321587e0e11a7904661af43eb0d27854bc))
- add BE pagination to table with pages ([#985](https://github.com/apache/superset/issues/985)) ([103f8e4](https://github.com/apache/superset/commit/103f8e41d9d969217821ef738e8f421b54aa011e))
- add box plot ([#78](https://github.com/apache/superset/issues/78)) ([6c7533b](https://github.com/apache/superset/commit/6c7533b565ad13fe3004e7448072f5a2013d003c))
- add calendar package and storybook ([#356](https://github.com/apache/superset/issues/356)) ([a8f3923](https://github.com/apache/superset/commit/a8f39238516cd48247812f8b91791e164b8876d3))
- add certification icon to metrics ([#748](https://github.com/apache/superset/issues/748)) ([3fa7675](https://github.com/apache/superset/commit/3fa767582c3d1a4b61813bd9c8808fb0f7a54efa))
- Add Certified filter to Datasets ([#20136](https://github.com/apache/superset/issues/20136)) ([f8ea778](https://github.com/apache/superset/commit/f8ea7788a90d679ab2e086289ebf6857ca1d2915))
- add certified icon to columoption ([#1330](https://github.com/apache/superset/issues/1330)) ([b9504ed](https://github.com/apache/superset/commit/b9504ed71375b6820b38da17d7a9791e23531224))
- Add channel encoder ([#224](https://github.com/apache/superset/issues/224)) ([937a7ec](https://github.com/apache/superset/commit/937a7ecb100865329a2de00ba112f5ba105b4cf5))
- add chart companion components ([#139](https://github.com/apache/superset/issues/139)) ([e5e09f9](https://github.com/apache/superset/commit/e5e09f9f267416d75f0b85887590c1ab09508eaa))
- add chart description in info tooltip ([#17207](https://github.com/apache/superset/issues/17207)) ([22896f2](https://github.com/apache/superset/commit/22896f28037c377e40d833e5c7ab2de8418d6c17))
- Add Chromatic publishing to superset-frontend storybook ([#21095](https://github.com/apache/superset/issues/21095)) ([6a0b7e5](https://github.com/apache/superset/commit/6a0b7e5598f18262cb83579bacd2440faaf5717b))
- add classNames for apply and clearAll buttons for superset filters ([#17554](https://github.com/apache/superset/issues/17554)) ([4cf429c](https://github.com/apache/superset/commit/4cf429c1545fd3d8e465d8591b9c9052920c9459))
- add color pallettes defined in SIP-34 ([#597](https://github.com/apache/superset/issues/597)) ([2d31777](https://github.com/apache/superset/commit/2d317774d6c3a1803ab6049b2140829a48ea86f5))
- add control grouping functionality ([#485](https://github.com/apache/superset/issues/485)) ([54b0df5](https://github.com/apache/superset/commit/54b0df5421923c2260163b878009fa30045977ce))
- add control panel support to chart plugin ([#203](https://github.com/apache/superset/issues/203)) ([a7a12c7](https://github.com/apache/superset/commit/a7a12c79a2732a643e353cc56b8cf0ad9b16983f))
- add country map of bulgaria in superset-ui-legacy-plugin-chart-country-map ([#2](https://github.com/apache/superset/issues/2)) ([3e05f6f](https://github.com/apache/superset/commit/3e05f6f143f43a49068b655d34a6272e53e0c35c))
- add databricks form ([#21573](https://github.com/apache/superset/issues/21573)) ([5c77f1a](https://github.com/apache/superset/commit/5c77f1ad2a317254e476c718b74de639c9fc943a))
- Add dataset tagging to the back-end ([#20892](https://github.com/apache/superset/issues/20892)) ([2e56489](https://github.com/apache/superset/commit/2e564897f860192c3e3ecbe41cfbac6b3e557b35))
- Add dataset visuals for when a table is selected ([#21893](https://github.com/apache/superset/issues/21893)) ([175ec85](https://github.com/apache/superset/commit/175ec854b9a509726dbe2ae8647a9da889fe0041))
- add deckgl files ([ad74e60](https://github.com/apache/superset/commit/ad74e60e99485a3b3105fe9f1a01b98bf5508dad))
- add default series_limit ([#1033](https://github.com/apache/superset/issues/1033)) ([75ef664](https://github.com/apache/superset/commit/75ef664c5d1f66b06241a140b708d022bf3e6323))
- add denylist for db engines ([#21486](https://github.com/apache/superset/issues/21486)) ([f58227a](https://github.com/apache/superset/commit/f58227a9124866d1db0dcb20947e9bee287ba0fc))
- add dimension type ([#117](https://github.com/apache/superset/issues/117)) ([ac241aa](https://github.com/apache/superset/commit/ac241aa59962e16231e1934c217c6149906ba8a7))
- add drag and drop column rearrangement for table viz ([#19381](https://github.com/apache/superset/issues/19381)) ([7e9b85f](https://github.com/apache/superset/commit/7e9b85f76ca8cae38c38e11f857634216b1cd71c))
- add dropGroupByControl ([#967](https://github.com/apache/superset/issues/967)) ([89c7d1d](https://github.com/apache/superset/commit/89c7d1d1aed19284345024756c9319f31c5014db))
- add duckdb as DataSource - Fixes [#14563](https://github.com/apache/superset/issues/14563) ([#19317](https://github.com/apache/superset/issues/19317)) ([202e34a](https://github.com/apache/superset/commit/202e34a259eda2619fc08b653df866c0f13c3e58))
- add duration formatter ([#209](https://github.com/apache/superset/issues/209)) ([dc9d0a0](https://github.com/apache/superset/commit/dc9d0a0d40d971e8e4a3a87ff701874542e8f5c4))
- Add ECharts Timeseries plugin ([#737](https://github.com/apache/superset/issues/737)) ([e916fd9](https://github.com/apache/superset/commit/e916fd9015fc976b0548954c4b8076c9681bfecc))
- add empty states to sqlab editor and select ([#19598](https://github.com/apache/superset/issues/19598)) ([06ec88e](https://github.com/apache/superset/commit/06ec88eb9934e90c93c9ee90a7871ceaf5abde06))
- add encodeable utilities for chart ([#15](https://github.com/apache/superset/issues/15)) ([2766975](https://github.com/apache/superset/commit/2766975ac54687eaa6c83fcc774e04e2e35e6fb7))
- Add Encoder ([#230](https://github.com/apache/superset/issues/230)) ([e11071c](https://github.com/apache/superset/commit/e11071cd9c4431428e6c6dd25c0a0d21d65d2266))
- add error boundary and responsiveness to SuperChart ([#175](https://github.com/apache/superset/issues/175)) ([34d475f](https://github.com/apache/superset/commit/34d475fac735474ce82bf1d04ef1d747f4fd30b1))
- Add excel export ([#22006](https://github.com/apache/superset/issues/22006)) ([6cf434e](https://github.com/apache/superset/commit/6cf434e5c16e8b4e387a79bbf7fca31bab9d96b8))
- add export_related flag ([#19215](https://github.com/apache/superset/issues/19215)) ([d01fdad](https://github.com/apache/superset/commit/d01fdad1d8da740af95e32adf2c9fc4bd1da7db5))
- add extension point for workspace home page ([#21033](https://github.com/apache/superset/issues/21033)) ([83dd851](https://github.com/apache/superset/commit/83dd85166f917a5cff8c94d2b4d2c298182494b9))
- add extension point to the right side of the menu bar ([#20514](https://github.com/apache/superset/issues/20514)) ([f2af81b](https://github.com/apache/superset/commit/f2af81b1c74a56e6854039cfe5f32e9b035ce262))
- add extension point to the top of welcome page ([#20575](https://github.com/apache/superset/issues/20575)) ([2389871](https://github.com/apache/superset/commit/2389871556cde32c61bc694f09b4e7dbc5432af5))
- add force option to report screenshots ([#17853](https://github.com/apache/superset/issues/17853)) ([2cd8054](https://github.com/apache/superset/commit/2cd80543581155225f2b538ad8cd5ebc7de5a9ff))
- add function for getting legend information ([#236](https://github.com/apache/superset/issues/236)) ([2923a93](https://github.com/apache/superset/commit/2923a9318de7e861d565847b27eeb29d8189d16a))
- add functions for parsing formatters from encoding ([#205](https://github.com/apache/superset/issues/205)) ([be65a04](https://github.com/apache/superset/commit/be65a04238f4b138ceff23025a45b9e31305fe53))
- add functions for parsing scales ([#207](https://github.com/apache/superset/issues/207)) ([024b318](https://github.com/apache/superset/commit/024b318dd249dba0087f4868b7794a0b91fe2b66))
- add getDomain to ChannelEncoder ([01264fd](https://github.com/apache/superset/commit/01264fdec124aecb31c04866fdb6141d9f515039))
- add header_data into emails ([#20903](https://github.com/apache/superset/issues/20903)) ([dda1dcf](https://github.com/apache/superset/commit/dda1dcf8ee217438acb45f2ad016ff1869c16112))
- Add Helm chart option for configOverrides through file ([#17811](https://github.com/apache/superset/issues/17811)) ([e3b44f4](https://github.com/apache/superset/commit/e3b44f482543b161cd2aabdc6b9dd7f3bde43da3))
- add hooks ([#158](https://github.com/apache/superset/issues/158)) ([eaa7851](https://github.com/apache/superset/commit/eaa785142861ff5ba44489f24912336b0cbd0171))
- add hooks on set_perm for new data permissions ([#20600](https://github.com/apache/superset/issues/20600)) ([f38dd1d](https://github.com/apache/superset/commit/f38dd1d42d2bb1da563367e4d054fe7eaa99eb04))
- add india to country_map visualization ([#182](https://github.com/apache/superset/issues/182)) ([b56b2bb](https://github.com/apache/superset/commit/b56b2bb1e2c64bf2b9a414cca5826c2a1784a54d))
- Add Iran to countries ([#306](https://github.com/apache/superset/issues/306)) ([b0a620e](https://github.com/apache/superset/commit/b0a620eee842f806006dda47fd32ba03114dee8a))
- add Korea(South) to Country Maps ([#230](https://github.com/apache/superset/issues/230)) ([bd84e26](https://github.com/apache/superset/commit/bd84e26a92bc0f3868c8835d588f978173d2078b))
- Add label and tooltip for the color schemes control ([#21040](https://github.com/apache/superset/issues/21040)) ([756ed0e](https://github.com/apache/superset/commit/756ed0e36acead74944112a8b678a7151319c26f))
- add labels to color scheme ([#125](https://github.com/apache/superset/issues/125)) ([c9b9935](https://github.com/apache/superset/commit/c9b99355518c36d49f5fb8839e0913ae06305e01))
- add Liechtenstein to country map chart ([#263](https://github.com/apache/superset/issues/263)) ([8392ad8](https://github.com/apache/superset/commit/8392ad83ef22a5850957f6981fd9a51bdafd0973))
- Add logging for ssh tunneling test_connection attempts ([#22625](https://github.com/apache/superset/issues/22625)) ([2de19f1](https://github.com/apache/superset/commit/2de19f1d6609aaa5496970ac6fd516c6d8c5915c))
- add main datetime column to dataset editor ([#17739](https://github.com/apache/superset/issues/17739)) ([63d9693](https://github.com/apache/superset/commit/63d9693f21786431ba7e2ec11d6658bcd3a1f9e9))
- add mergeMargin() function ([#114](https://github.com/apache/superset/issues/114)) ([e5d7e50](https://github.com/apache/superset/commit/e5d7e50ee2d6ec799ac10ae650e0917a9562f283))
- add modfied col and timezone info to schedule col ([#20165](https://github.com/apache/superset/issues/20165)) ([6f0d53e](https://github.com/apache/superset/commit/6f0d53eed8eaf085a6d0a76f68e50c7733754a3d))
- add monorepo config ([41f551e](https://github.com/apache/superset/commit/41f551edfc75009cdda276392f461edb20774c79))
- add more support for undefined format to number and time formatters ([#308](https://github.com/apache/superset/issues/308)) ([5966ff1](https://github.com/apache/superset/commit/5966ff10be7a3e53f0512d672109a3f2ec3c3937))
- add name, description and non null tables to RLS ([#20432](https://github.com/apache/superset/issues/20432)) ([60eb109](https://github.com/apache/superset/commit/60eb1094a4f270ba8931f3c2e1656bd257a948fb))
- add NoResultsComponent to charts ([#305](https://github.com/apache/superset/issues/305)) ([06d7ad5](https://github.com/apache/superset/commit/06d7ad571ad4c4fc6002000f8b4d2b4fdd9f22be))
- Add oneLine mode to AsyncSelect ([#22379](https://github.com/apache/superset/issues/22379)) ([a5a0cf9](https://github.com/apache/superset/commit/a5a0cf9ffb3036568a1144245665daaf00dc80b1))
- add orderby shared control ([#1122](https://github.com/apache/superset/issues/1122)) ([6675e60](https://github.com/apache/superset/commit/6675e60280f3cb8deb86d439865eb2d119e07fad))
- add parseLength function to @superset-ui/dimension ([#171](https://github.com/apache/superset/issues/171)) ([5a79a70](https://github.com/apache/superset/commit/5a79a7000f3f48237d0d96c60ab5042d50f9bc0c))
- add permalink to dashboard and explore ([#19078](https://github.com/apache/superset/issues/19078)) ([b7a0559](https://github.com/apache/superset/commit/b7a0559aaf5ff4266baf5069b93379fbecfb4a00))
- add plugin for Kepler ([#2](https://github.com/apache/superset/issues/2)) ([cac4e07](https://github.com/apache/superset/commit/cac4e07bfeb591719cf6a7122ee2934d27ecca17))
- add possibility to set ingress class name in Helm chart ([#17252](https://github.com/apache/superset/issues/17252)) ([37909aa](https://github.com/apache/superset/commit/37909aace0b8968475c2c731891cd9dc52f8de85))
- Add prettier to pre-commit workflow ([#17134](https://github.com/apache/superset/issues/17134)) ([cd9e994](https://github.com/apache/superset/commit/cd9e99402d29bfed6a897a7371144b096ee5249c))
- add promiseTimeout ([#223](https://github.com/apache/superset/issues/223)) ([c0c45c2](https://github.com/apache/superset/commit/c0c45c2d3c4a3cda3e453d1d1c40a7451887797d))
- add prop to `setDBEngine` in DatabaseModal ([#18653](https://github.com/apache/superset/issues/18653)) ([78e20e2](https://github.com/apache/superset/commit/78e20e21abe3f264701e796d36b900246b39c22b))
- add properties for font sizing ([#10](https://github.com/apache/superset/issues/10)) ([49cd2fe](https://github.com/apache/superset/commit/49cd2fedfb7262920a905067133318ca93f3eb8a))
- add pyproject.toml file to project ([#20291](https://github.com/apache/superset/issues/20291)) ([8466eec](https://github.com/apache/superset/commit/8466eec2283a30a5cf891b4f808d4c519aea84fa))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- add resample operator to advanced analytic ([#1349](https://github.com/apache/superset/issues/1349)) ([c7744d4](https://github.com/apache/superset/commit/c7744d472014cfa37277fecd5d27ecd8c1133b5b))
- Add resize drag handle to Dataset SQL fields ([#20670](https://github.com/apache/superset/issues/20670)) ([dd353ca](https://github.com/apache/superset/commit/dd353ca86a93aed4189cdefddffcd425b6cbdcb5))
- add retry to callApi ([#384](https://github.com/apache/superset/issues/384)) ([b711d3e](https://github.com/apache/superset/commit/b711d3eba7e8a946fb82904c5a9f958471c0b284))
- add risingwave.py in db engine specs ([#22123](https://github.com/apache/superset/issues/22123)) ([e80e10e](https://github.com/apache/superset/commit/e80e10ec06472deb1156b229eb61522bb5fe6706))
- add rison request type to makeApi ([#843](https://github.com/apache/superset/issues/843)) ([c527f55](https://github.com/apache/superset/commit/c527f55e99784adf4ea3ed12758f7d37e82f840d))
- add samples endpoint ([#20170](https://github.com/apache/superset/issues/20170)) ([40abb44](https://github.com/apache/superset/commit/40abb44ba1376b37414bbedbd05ddca44c4f7450))
- add sankey chart with loops ([#77](https://github.com/apache/superset/issues/77)) ([c0920f6](https://github.com/apache/superset/commit/c0920f63971e80a9f2b1cfba976d615bb9588b70))
- Add Saudi Arabia country map ([#1416](https://github.com/apache/superset/issues/1416)) ([28dff9b](https://github.com/apache/superset/commit/28dff9b3950dd8ec14f32171ca88fdfc62a225cc))
- add scatter plot ([#90](https://github.com/apache/superset/issues/90)) ([3a0dd27](https://github.com/apache/superset/commit/3a0dd2741d868b3016ff1345698697eb9105c4b2))
- Add single select and inverse selection to numeric range ([#16722](https://github.com/apache/superset/issues/16722)) ([#17372](https://github.com/apache/superset/issues/17372)) ([54b56fe](https://github.com/apache/superset/commit/54b56fe12f18c034b301289cecb935342c0e3f5a))
- Add SMART_NUMBER formatter and make it default ([#109](https://github.com/apache/superset/issues/109)) ([0cde8a2](https://github.com/apache/superset/commit/0cde8a288495e21937196398b93463bfe234b349))
- add snowflake keypair authentication ([#21322](https://github.com/apache/superset/issues/21322)) ([9fdd75b](https://github.com/apache/superset/commit/9fdd75b9234490a971bb11a295209dadad8e3d1e))
- add sort by metric for charts with multiple metrics ([#952](https://github.com/apache/superset/issues/952)) ([b3f84f5](https://github.com/apache/superset/commit/b3f84f56578c414361d265d4cce10a2ec6b07a0b))
- add Spark Sql DB engine spec and support Spark 3.x ([#20462](https://github.com/apache/superset/issues/20462)) ([c4d2238](https://github.com/apache/superset/commit/c4d2238a1629851b0c044dba3f20c3af4c0a9031))
- add ssh tunneling to dynamic form for Database Connection UI ([#22689](https://github.com/apache/superset/issues/22689)) ([b9686fe](https://github.com/apache/superset/commit/b9686fe6fa808e11ee5c54c67929ccaf84e9435a))
- add statsd metrics for notifications ([#20158](https://github.com/apache/superset/issues/20158)) ([77ccec5](https://github.com/apache/superset/commit/77ccec50cc0b97057b074126e57697c6fd00c2c0))
- add storybook for missing chart and fix broken treemap ([#1427](https://github.com/apache/superset/issues/1427)) ([46b4eca](https://github.com/apache/superset/commit/46b4eca280d8ceeda10252ee4aade5badb647fa1))
- add success message for database modal ([#18183](https://github.com/apache/superset/issues/18183)) ([ac564ea](https://github.com/apache/superset/commit/ac564ea6b7bd42a8a34fab338df417d2608e76cb))
- add success toast to alerts and reports ([#19482](https://github.com/apache/superset/issues/19482)) ([44e3103](https://github.com/apache/superset/commit/44e3103fc9029edd4c7fd1c8402607eecebeb1b3))
- Add support for Azure Data Explorer (Kusto) db engine spec ([#17898](https://github.com/apache/superset/issues/17898)) ([d2d4f8e](https://github.com/apache/superset/commit/d2d4f8eb447c40a76e619d4cd6dec5ba21a9ea27))
- add support for comments in adhoc clauses ([#19248](https://github.com/apache/superset/issues/19248)) ([f341025](https://github.com/apache/superset/commit/f341025d80aacf7345e7c20f8463231b9197ea58))
- add support for conditional get requests ([#119](https://github.com/apache/superset/issues/119)) ([a63f947](https://github.com/apache/superset/commit/a63f947ff52cb96e52dc526c4b9b910af0cf82bc))
- add syria to Country Maps ([#1000](https://github.com/apache/superset/issues/1000)) ([5da7a6c](https://github.com/apache/superset/commit/5da7a6c778c5b2cea75a822cfe13597a18543a86))
- add tabs to edit dataset page ([#22043](https://github.com/apache/superset/issues/22043)) ([c05871e](https://github.com/apache/superset/commit/c05871eb378344e340ed7841e6db13eaa5efcf95))
- Add toast for successful table or schema refreshes in Sqllab ([#18169](https://github.com/apache/superset/issues/18169)) ([e6bb0fc](https://github.com/apache/superset/commit/e6bb0fc7ad61dc314156b283dcfbbd991ddaff9a))
- add tooltip and layout components for charts ([#13](https://github.com/apache/superset/issues/13)) ([4013721](https://github.com/apache/superset/commit/4013721e6103ef97aabca5f29629f96c898db846))
- add tooltip for full metric names ([#1066](https://github.com/apache/superset/issues/1066)) ([cc25094](https://github.com/apache/superset/commit/cc25094b85d713ee7c28717c721318bcb492e2d9))
- Add Türkiye Map to Country Map ([#20801](https://github.com/apache/superset/issues/20801)) ([4ffa3c2](https://github.com/apache/superset/commit/4ffa3c22d17b189a384f43a0e352b137900b10bc))
- Add types and type guards for encodeable ([#201](https://github.com/apache/superset/issues/201)) ([cb9e617](https://github.com/apache/superset/commit/cb9e617d90c225dfde7b4ed744ee32a08662309c))
- add types to published list ([297b723](https://github.com/apache/superset/commit/297b723e7ffc8a6d05b8ef931810117bb528d96b))
- add typescript declaration for external packages ([#12](https://github.com/apache/superset/issues/12)) ([4215a80](https://github.com/apache/superset/commit/4215a80aa8a35432e49d78bfe0e7c8d38bb354be))
- add validator package ([#322](https://github.com/apache/superset/issues/322)) ([dbc9860](https://github.com/apache/superset/commit/dbc98609a5f9b4a31fc92b8e64ca97c65ea78da7))
- add validator to umbrella package ([#327](https://github.com/apache/superset/issues/327)) ([6ffcfec](https://github.com/apache/superset/commit/6ffcfec6e7d65702f11e101ed1b1db121197694e))
- add Wrapper support and bounding box for dynamic width/height ([#215](https://github.com/apache/superset/issues/215)) ([095c183](https://github.com/apache/superset/commit/095c1839b2aa760cb4ff21d7112b228f867091ca))
- added Highly-used tag ([#1229](https://github.com/apache/superset/issues/1229)) ([5614683](https://github.com/apache/superset/commit/56146830f43cf3d380065490b0d1f992980a3e78))
- added italian regions country map ([#1319](https://github.com/apache/superset/issues/1319)) ([a783131](https://github.com/apache/superset/commit/a783131d7dfa8c992a4b0049a0c763d84648daaa))
- Added latin america countries to country map ([#21352](https://github.com/apache/superset/issues/21352)) ([f83af88](https://github.com/apache/superset/commit/f83af88fc7922774b4c1a7792f0602edcb80763d))
- added option to set pod annotations on init-db pod to Helm chart. ([#17581](https://github.com/apache/superset/issues/17581)) ([95177d7](https://github.com/apache/superset/commit/95177d72b631d1666f10ad3577b8e972f5aa1a8d))
- **added search bar:** added search bar ([3d8cbd5](https://github.com/apache/superset/commit/3d8cbd52eeda85cfb3a0da0a87f7efb0cc86a72f))
- Added success toasts for database, dataset, chart, dashboard, and query imports ([#18190](https://github.com/apache/superset/issues/18190)) ([c40b337](https://github.com/apache/superset/commit/c40b337978717b149984ed00c5359cf2c2394254))
- adding Canada into the list of country map choices ([#48](https://github.com/apache/superset/issues/48)) ([bbecb6d](https://github.com/apache/superset/commit/bbecb6dc8432f4b4f61e0033111db79b2dd1298f))
- adding to feature flag enum ([#1142](https://github.com/apache/superset/issues/1142)) ([47a5f34](https://github.com/apache/superset/commit/47a5f349626e469fe97d305951161f76bffda5ad))
- adding truncate metric control on timeseries charts ([#20373](https://github.com/apache/superset/issues/20373)) ([7c252d7](https://github.com/apache/superset/commit/7c252d75240559d0bba9be3be8419b65b86967df))
- adding XAxis to BigNumberTrend ([#21577](https://github.com/apache/superset/issues/21577)) ([f4646f8](https://github.com/apache/superset/commit/f4646f8edba396dba24e6ff4fbc054d073d77fd7))
- Adds a Content Security Policy (CSP) check for production environments ([#21874](https://github.com/apache/superset/issues/21874)) ([f4da74c](https://github.com/apache/superset/commit/f4da74ce8d6902be1ac3b881fb4a7bc521ec366f))
- Adds a helper text option to the Select component ([#21269](https://github.com/apache/superset/issues/21269)) ([fbe9807](https://github.com/apache/superset/commit/fbe980779e38f5fa8a9bd148e280f85ec8b0ec16))
- Adds a key-value endpoint to store charts form data ([#17882](https://github.com/apache/superset/issues/17882)) ([959b15e](https://github.com/apache/superset/commit/959b15eeca0a1e2e93c1a8688f8629d0f6ee5776))
- Adds a key-value endpoint to store the state of dashboard filters ([#17536](https://github.com/apache/superset/issues/17536)) ([2f2e8fe](https://github.com/apache/superset/commit/2f2e8fe412296b76cb17094a4c22fe5c3f8bc504))
- Adds a separator to Select All option ([#22776](https://github.com/apache/superset/issues/22776)) ([1fe4a71](https://github.com/apache/superset/commit/1fe4a71f5be10f182277b6008d212c7f40ced2e4))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds drill to detail context menu to Table ([#21168](https://github.com/apache/superset/issues/21168)) ([68fa4d2](https://github.com/apache/superset/commit/68fa4d2665cc0742b2194533271ce562a3ebbf14))
- Adds drill to detail context menu to World Map ([#21150](https://github.com/apache/superset/issues/21150)) ([4ca4a5c](https://github.com/apache/superset/commit/4ca4a5c7cb185ac7d318ef5349fbb23cd7ce1fd1))
- Adds MetadataBar to Drill to Detail modal ([#21343](https://github.com/apache/superset/issues/21343)) ([8ebf4ed](https://github.com/apache/superset/commit/8ebf4ed3ffc8cf5b7056c4d296667204b9cb5ac6))
- Adds more customization properties to DropdownContainer ([#22031](https://github.com/apache/superset/issues/22031)) ([b040211](https://github.com/apache/superset/commit/b040211970e456337455e44ba17bf78f11650097))
- Adds overflow to the DropdownContainer popover ([#22250](https://github.com/apache/superset/issues/22250)) ([afc10a2](https://github.com/apache/superset/commit/afc10a247b1ab736ffb888047ec3c3a3b995ecc0))
- Adds plugin-chart-handlebars ([#17903](https://github.com/apache/superset/issues/17903)) ([e632b82](https://github.com/apache/superset/commit/e632b82395bd379e2c4d42cb581972e6fe690a50))
- Adds support for clearing the Select cache ([#20397](https://github.com/apache/superset/issues/20397)) ([ca526e6](https://github.com/apache/superset/commit/ca526e63c8211fe308049f5d003a9826f5ebb50e))
- Adds support to multiple dependencies to the native filters ([#18793](https://github.com/apache/superset/issues/18793)) ([06e1e42](https://github.com/apache/superset/commit/06e1e4285ea52d27f9b7b7dfea59f9652ee0dcfe))
- Adds the /explore endpoint to the v1 API ([#20399](https://github.com/apache/superset/issues/20399)) ([2016336](https://github.com/apache/superset/commit/20163361b9d947c1bf5b7f8331bdc64c9aac1169))
- Adds the CROSS_REFERENCE feature flag ([#21708](https://github.com/apache/superset/issues/21708)) ([1cbf066](https://github.com/apache/superset/commit/1cbf0664152cef5d47720e1acffb955c328e291e))
- Adds the DropdownContainer component ([#21974](https://github.com/apache/superset/issues/21974)) ([97e3e79](https://github.com/apache/superset/commit/97e3e790a3627ff7e291865807bbe3634cc3a291))
- Adds the ECharts Sunburst chart ([#22833](https://github.com/apache/superset/issues/22833)) ([30abefb](https://github.com/apache/superset/commit/30abefb519978e2760a492de51dc0d19803edf3a))
- Adds the HORIZONTAL_FILTER_BAR feature flag ([#21935](https://github.com/apache/superset/issues/21935)) ([779d9f7](https://github.com/apache/superset/commit/779d9f75336ce38ab346e27dcb6a77e5a68cf823))
- Adds the MetadataBar component ([#21090](https://github.com/apache/superset/issues/21090)) ([1517956](https://github.com/apache/superset/commit/151795663bbdc8f52ab046a2dc4aa148b2efba51))
- Adds the MetadataBar to the Explore header ([#21560](https://github.com/apache/superset/issues/21560)) ([0dda5fe](https://github.com/apache/superset/commit/0dda5fe1cf04aec5b27b63f8bbb3173a13e02ebc))
- adds the option to show values for mixed time-series ([#1435](https://github.com/apache/superset/issues/1435)) ([8666f63](https://github.com/apache/superset/commit/8666f63c4a97ee01f1f96c2e3d26e0badb913c1c))
- adds TLS certificate validation option for SMTP ([#21272](https://github.com/apache/superset/issues/21272)) ([9fd7520](https://github.com/apache/superset/commit/9fd752057eb261b0e5db87636836fd30579ffce6))
- Adds virtualization option to antd based Table component ([#22135](https://github.com/apache/superset/issues/22135)) ([eba7b3d](https://github.com/apache/superset/commit/eba7b3d074350c3429778259baef19b7995f60ae))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- advanced analytics for timeseries in echart viz ([#1170](https://github.com/apache/superset/issues/1170)) ([f9d3a73](https://github.com/apache/superset/commit/f9d3a73e93e7f85ad246fd99520bc46ec31a3072))
- **advanced analytics:** support groupby in resample ([#18045](https://github.com/apache/superset/issues/18045)) ([0c7f728](https://github.com/apache/superset/commit/0c7f7288d8cded5dc73d49d1e0be397e748d4f10))
- **alerts:** Column for select tabs to send ([#17604](https://github.com/apache/superset/issues/17604)) ([1377465](https://github.com/apache/superset/commit/1377465a7d9f374500576b35683763c2cc29afe8))
- **alerts:** Select tabs to send backend ([#17749](https://github.com/apache/superset/issues/17749)) ([bdc35a2](https://github.com/apache/superset/commit/bdc35a221445d9ba62a4cfabc2f5561dc712084c))
- align metrics title to the right ([#721](https://github.com/apache/superset/issues/721)) ([835335d](https://github.com/apache/superset/commit/835335d3e4b48987adbbac3bfaa55ac05ba3d307))
- allow adding pod labels ([#18848](https://github.com/apache/superset/issues/18848)) ([dafc841](https://github.com/apache/superset/commit/dafc841e223c0f01092a2e116888a3304142e1b8))
- allow assets to be managed externally ([#18093](https://github.com/apache/superset/issues/18093)) ([1c0b141](https://github.com/apache/superset/commit/1c0b141e2de700f889fc04d5f77d91bc7305a858))
- allow boolean as axis config ([4259e44](https://github.com/apache/superset/commit/4259e4402bc64f33d688b490a205bd409d100933))
- allow chart plugin to be unregistered ([#168](https://github.com/apache/superset/issues/168)) ([09f9405](https://github.com/apache/superset/commit/09f94053349d77bae4ae24403f00e1cfa10e782a))
- allow legend overrides at multiple levels ([#81](https://github.com/apache/superset/issues/81)) ([ff7ef2b](https://github.com/apache/superset/commit/ff7ef2b2b3ffc5f77d7b242301591d914fbee21a))
- allow more HTML tags in report description ([#20908](https://github.com/apache/superset/issues/20908)) ([e739ff5](https://github.com/apache/superset/commit/e739ff507671cfd1892aad2e22fae83425c31851))
- allow overriding ChartLegend, its style and LegendGroup style ([#112](https://github.com/apache/superset/issues/112)) ([d7a5d8a](https://github.com/apache/superset/commit/d7a5d8ab85f0e5c75f6f4153839ad3372e1f8b9e))
- allow reactify callbacks to access props ([#200](https://github.com/apache/superset/issues/200)) ([f0204ea](https://github.com/apache/superset/commit/f0204ea9bdd4a8c565518eb243a3fddf5432cd4c))
- allow setting db UUID ([#20412](https://github.com/apache/superset/issues/20412)) ([998624b](https://github.com/apache/superset/commit/998624b1a5a498343bd7f37b5ca80402ba08e305))
- allow toggling of table viz's bar chart backgrounds ([#352](https://github.com/apache/superset/issues/352)) ([98848b3](https://github.com/apache/superset/commit/98848b361abc447c77928442a3aca7a4750aafd1))
- allow uploads in crud view ([#18953](https://github.com/apache/superset/issues/18953)) ([d771ddb](https://github.com/apache/superset/commit/d771ddbb94c8a5692ca4f167422b7c100b1b0093))
- Allow users to bust cache in report dashboard + alerts charts + alert dashboards ([#18795](https://github.com/apache/superset/issues/18795)) ([8c52fe3](https://github.com/apache/superset/commit/8c52fe347699b4d529997ea7600c72874d49f905))
- **annotation:** add toast feedback to annotation templates ([#18116](https://github.com/apache/superset/issues/18116)) ([9fa2812](https://github.com/apache/superset/commit/9fa2812343a573fd557ca704ec32a8ecd4a1e294))
- API for asset sync ([#19220](https://github.com/apache/superset/issues/19220)) ([b05e7db](https://github.com/apache/superset/commit/b05e7dbf2aa513cd50a20847a858625916579dcb))
- **api:** Add option to enable sync on import ([#20312](https://github.com/apache/superset/issues/20312)) ([a5ff094](https://github.com/apache/superset/commit/a5ff0949a65c9aedabb2c97a2843ff425534ecaf))
- **api:** Added "kind" to dataset/<pk> endpoint ([#20113](https://github.com/apache/superset/issues/20113)) ([11b33de](https://github.com/apache/superset/commit/11b33de61b5b28966164daddb30f5661bd109467))
- Applitools Cypress workflow ([#19956](https://github.com/apache/superset/issues/19956)) ([d0b8b1e](https://github.com/apache/superset/commit/d0b8b1e97d1280bff0506b2c8cc2325041f79df2))
- apply d3NumberFormat to table reports ([#17336](https://github.com/apache/superset/issues/17336)) ([03a2c6e](https://github.com/apache/superset/commit/03a2c6ee8aab94a85e10768e09ffa110bb008cfd))
- apply standardized form data to deckgl ([#20579](https://github.com/apache/superset/issues/20579)) ([290b89c](https://github.com/apache/superset/commit/290b89c7b4ae702c55f611bfac9cedb245ea8bd8))
- apply standardized form data to tier 2 charts ([#20530](https://github.com/apache/superset/issues/20530)) ([de524bc](https://github.com/apache/superset/commit/de524bc59f011fd361dcdb7d35c2cb51f7eba442))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Area viz migration ([#20359](https://github.com/apache/superset/issues/20359)) ([4e6e87f](https://github.com/apache/superset/commit/4e6e87f62ee749e8326fa734225dde955c4d0025))
- auto select schema ([#22160](https://github.com/apache/superset/issues/22160)) ([17c2bd8](https://github.com/apache/superset/commit/17c2bd89a6ecc480851801d58fadbf130704f784))
- Automatically closes the DropdownContainer when scrolling outside of the component ([#22287](https://github.com/apache/superset/issues/22287)) ([8cf5728](https://github.com/apache/superset/commit/8cf572858ce2f0ec2a7765b31efbcf08d189e67b))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **big-number:** allow fallback to last available value and fix time range for trend lines ([#403](https://github.com/apache/superset/issues/403)) ([80b6e06](https://github.com/apache/superset/commit/80b6e066ebdf66a08b0ba76f7c70663d8d2b6bbd))
- **big-number:** format datetime according to granularity ([#402](https://github.com/apache/superset/issues/402)) ([cb3206b](https://github.com/apache/superset/commit/cb3206b5833a0d68c1284b677e5a4f522957be28))
- **bigquery:** Custom message when Service Account doesnt have the correct Roles and Permissions ([#21838](https://github.com/apache/superset/issues/21838)) ([203b289](https://github.com/apache/superset/commit/203b289021be1dc720126ac57e33ad933fd39b36))
- blankstate metrics columns ([#20755](https://github.com/apache/superset/issues/20755)) ([2f3e11d](https://github.com/apache/superset/commit/2f3e11db668327ce55466a23fe6866458d2e08cc))
- bring lazy import back ([#84](https://github.com/apache/superset/issues/84)) ([68ebb11](https://github.com/apache/superset/commit/68ebb111f1fc880607b5b65695a20fbdd7af26b8))
- bump data-ui/xy-chart version ([70ecef2](https://github.com/apache/superset/commit/70ecef2a6d70c69e0c33b4747d0bed70bef1c580))
- bump dependencies ([492b19c](https://github.com/apache/superset/commit/492b19cad532d7fd80497b8443949205748f68a0))
- **business-types:** initial implementation of SIP-78 ([#18794](https://github.com/apache/superset/issues/18794)) ([ddc01ea](https://github.com/apache/superset/commit/ddc01ea7813ef7c02cfc2aee7cbf554a45628f25))
- bypass cache on screenshots for alerts ([#17695](https://github.com/apache/superset/issues/17695)) ([b7707e8](https://github.com/apache/superset/commit/b7707e8ff7ed9369f8902d15471a93226c9aab7c))
- callback hooks for Reactified components ([#131](https://github.com/apache/superset/issues/131)) ([2ac3c08](https://github.com/apache/superset/commit/2ac3c082abf199bee398124d511ed380df31f502))
- Certify Charts and Dashboards ([#17335](https://github.com/apache/superset/issues/17335)) ([83e49fc](https://github.com/apache/superset/commit/83e49fc9eee8da5ce5e2347722fedf1248d242d5))
- change bundle to target modern browser ([#10](https://github.com/apache/superset/issues/10)) ([8a4e141](https://github.com/apache/superset/commit/8a4e141448f5816d2ec7df1a57e2a5ad4d010938))
- change font size on responsive for sankey and sunburst chart ([#977](https://github.com/apache/superset/issues/977)) ([2625698](https://github.com/apache/superset/commit/2625698f1fb5dd87e5845f521dac37d58b006214))
- channels can take array of definitions ([c469e58](https://github.com/apache/superset/commit/c469e5854adc322e7da01cbc84b7377fdc38f12f))
- **chart & legend:** make to enable show legend by default ([#19927](https://github.com/apache/superset/issues/19927)) ([7b3d0f0](https://github.com/apache/superset/commit/7b3d0f040b050905f7d0901d0227f1cd6b761b56))
- **chart-controls:** d3 formatting with .2% [#1274](https://github.com/apache/superset/issues/1274) ([#1275](https://github.com/apache/superset/issues/1275)) ([15fbe4a](https://github.com/apache/superset/commit/15fbe4a72a7d437922084a50d92f8e818637e7ad))
- **chart-controls:** dnd version of time column ([#1226](https://github.com/apache/superset/issues/1226)) ([a94ef9f](https://github.com/apache/superset/commit/a94ef9ff0086b5daac4f88647a8352171cdc816b))
- **chart-controls:** implement color formatters utils ([#1215](https://github.com/apache/superset/issues/1215)) ([3bfa709](https://github.com/apache/superset/commit/3bfa70919747e4f205038aed08299ee4f584bef0))
- **chart-controls:** implement dnd controls for all charts ([#33](https://github.com/apache/superset/issues/33)) ([5e6af31](https://github.com/apache/superset/commit/5e6af313e2ff62dbd0e5049e0ef2cb55c4f0d12c))
- **chart-controls:** implement drag&drop controls for all charts ([#1127](https://github.com/apache/superset/issues/1127)) ([c461abb](https://github.com/apache/superset/commit/c461abbdeb780a0ba2aec338b2a8c1c9cf5eaced))
- **chart-controls:** move cross-filtering control to data panel ([#1248](https://github.com/apache/superset/issues/1248)) ([9fe5865](https://github.com/apache/superset/commit/9fe5865e056fe0ad9fe45f7a70aeb09971c0f263))
- **chart-data-api:** download multiple csvs as zip ([#18618](https://github.com/apache/superset/issues/18618)) ([125be78](https://github.com/apache/superset/commit/125be78ee6681b702ce5288657aba5ce190e7fce))
- **chart:** Add `<ChartDataProvider />` ([#120](https://github.com/apache/superset/issues/120)) ([061faab](https://github.com/apache/superset/commit/061faab818b925637e3fd5822ed9a063fcfd4ede))
- **chart:** add feature flag that displays the data pane closes by default ([#21649](https://github.com/apache/superset/issues/21649)) ([ebd7536](https://github.com/apache/superset/commit/ebd75366c0c7acd6d4619996c4f209b51af518e2))
- **chart:** add Mexico to country map viz ([#18007](https://github.com/apache/superset/issues/18007)) ([f451081](https://github.com/apache/superset/commit/f45108116673d5810c238bb911058dc8ed05b75a))
- **chart:** add shared plugin controls utilities ([#389](https://github.com/apache/superset/issues/389)) ([fb46642](https://github.com/apache/superset/commit/fb4664235bf3bb5dda2b332e59a74fbf8c9f702e))
- **chart:** Added Latvia to countries map ([#22220](https://github.com/apache/superset/issues/22220)) ([9578a44](https://github.com/apache/superset/commit/9578a443ef713f01f4cc9cd3a8616b819a7a7a65))
- **chart:** Added Papua New Guinea to countries map ([#22589](https://github.com/apache/superset/issues/22589)) ([b352947](https://github.com/apache/superset/commit/b3529479ab39fcc273189bf4db4a0f1fd8b1cc0c))
- **chart:** adjust chartclient to point to new endpoints ([#551](https://github.com/apache/superset/issues/551)) ([bdb0f50](https://github.com/apache/superset/commit/bdb0f50874daa34671185f51b0f850c6f7dd33bc))
- **chart:** Enable caching per user when user impersonation is enabled ([#20114](https://github.com/apache/superset/issues/20114)) ([68af598](https://github.com/apache/superset/commit/68af5980ea5ae98978c809f308891e2e27bed220))
- **charts:** allow query mutator to update queries after splitting original sql ([#21645](https://github.com/apache/superset/issues/21645)) ([cf00970](https://github.com/apache/superset/commit/cf00970cde573011bb3d8fcdfc43258963f45bdf))
- **CI:** clean up Python tests output ([#19489](https://github.com/apache/superset/issues/19489)) ([ea70816](https://github.com/apache/superset/commit/ea708162a559a426c1c44f035883d709fc5dac50))
- **code refactoring:** code refactoring ([c87a748](https://github.com/apache/superset/commit/c87a74841ea1ad05e4041748cfed3a45749e1085))
- **color:** add official ECharts color schemes ([#751](https://github.com/apache/superset/issues/751)) ([9f1aafa](https://github.com/apache/superset/commit/9f1aafa628e4c6632039367416574152c49f9dfc))
- **color:** color consistency enhancements ([#21507](https://github.com/apache/superset/issues/21507)) ([7a7181a](https://github.com/apache/superset/commit/7a7181a2449598b09298f3a113849caeb3309186))
- **color:** support analogous colors to prevent color conflict ([#19325](https://github.com/apache/superset/issues/19325)) ([90c9dae](https://github.com/apache/superset/commit/90c9daea08cd59ba7261c13e1ce4e80a72f84b48))
- **color:** support better color interpolation for sequential schemes ([#547](https://github.com/apache/superset/issues/547)) ([f2a053b](https://github.com/apache/superset/commit/f2a053b0345b219bc3228f02c3720617144caf3d))
- **config:** Add none force-refresh option for auto refresh ([#17039](https://github.com/apache/superset/issues/17039)) ([7a2e394](https://github.com/apache/superset/commit/7a2e39449a2844455950b894e00e8c710340b209))
- configure force_screenshot ([#17855](https://github.com/apache/superset/issues/17855)) ([9baeafe](https://github.com/apache/superset/commit/9baeafec9308ddafd3f962dbf609958e9b1963ab))
- **connection:** allow developer to get supersetclient instance ([#552](https://github.com/apache/superset/issues/552)) ([0a48d6e](https://github.com/apache/superset/commit/0a48d6e774af102ada64c2119558918ce215f70a))
- **connection:** easier API for json payload ([#634](https://github.com/apache/superset/issues/634)) ([ddd9fb4](https://github.com/apache/superset/commit/ddd9fb46c76656156de502f545ba6d9f4cdcc363))
- **connection:** optimize typing and API for SupersetClient ([#635](https://github.com/apache/superset/issues/635)) ([ba8c619](https://github.com/apache/superset/commit/ba8c619c2e8ca9f7726b0bb879b0ede0ef9582a2))
- **control-utils:** add infotooltipwithtrigger ([#442](https://github.com/apache/superset/issues/442)) ([307fb23](https://github.com/apache/superset/commit/307fb23bd64e742cb203525805e3238b79a2a14c))
- **control-utils:** add packages control-utils ([#417](https://github.com/apache/superset/issues/417)) ([2be7b4b](https://github.com/apache/superset/commit/2be7b4ba0a5b30e6684fd036dd7e1f76165de390))
- **control-utils:** add shared controls + dependencies, convert to typescript ([#459](https://github.com/apache/superset/issues/459)) ([28de288](https://github.com/apache/superset/commit/28de28864b84ad12c784ae790f31827bfe3332d0))
- **control-utils:** better typing for control configs ([#595](https://github.com/apache/superset/issues/595)) ([64ffc17](https://github.com/apache/superset/commit/64ffc1782ef433006ce4d2c9674cea72fe4654ee))
- convert dataframe tests ([#17655](https://github.com/apache/superset/issues/17655)) ([3873cdf](https://github.com/apache/superset/commit/3873cdff4de9ccd5170cb0b10212bc34998bb3d0))
- **core:** add applied_time_extras to QueryObject ([#809](https://github.com/apache/superset/issues/809)) ([88c98cf](https://github.com/apache/superset/commit/88c98cf1a8bdb84495f441024a61460e898750e5))
- **core:** add custom_params to form_data ([#929](https://github.com/apache/superset/issues/929)) ([b45cc00](https://github.com/apache/superset/commit/b45cc00c227c54b5422fda26af18ebd4ff9c4e1f))
- **core:** add extra form data fields for native filters ([#992](https://github.com/apache/superset/issues/992)) ([a1093df](https://github.com/apache/superset/commit/a1093df02165bec03a781637ef6c6605cd7eb4e0))
- **core:** add new feature flags ([#1133](https://github.com/apache/superset/issues/1133)) ([0a7e2da](https://github.com/apache/superset/commit/0a7e2da8cc80a3b32b67302d3b9643661901c7e4))
- **core:** add orderby to extractQueryFields ([#919](https://github.com/apache/superset/issues/919)) ([1846be0](https://github.com/apache/superset/commit/1846be099bbc6e7dff175ca2080c03011757c1b9))
- **core:** add support for adhoc columns ([#1342](https://github.com/apache/superset/issues/1342)) ([e16a836](https://github.com/apache/superset/commit/e16a83673176e8fbdc0af8c0f43f671ff7d06ddf))
- **core:** add support for annotations and url params ([#812](https://github.com/apache/superset/issues/812)) ([757854b](https://github.com/apache/superset/commit/757854b6a931fd0de60dfed386005505da483572))
- **core:** add support for case insensitive LIKE operator ([#1129](https://github.com/apache/superset/issues/1129)) ([a6cfaff](https://github.com/apache/superset/commit/a6cfaffa35e2b3b4d4d1d512783f0f2e01129c6a))
- **core:** add support for empty results and refresh indicator ([#1121](https://github.com/apache/superset/issues/1121)) ([c2c84da](https://github.com/apache/superset/commit/c2c84da6f0303c943bd5e34cf44dda2fcfd4e34e))
- **core:** add support for non-temporal series limit ([#1356](https://github.com/apache/superset/issues/1356)) ([614e06d](https://github.com/apache/superset/commit/614e06dede4bb6db76c16b7fe8516ae6001e2353))
- **core:** copy feature flags from main repo ([#982](https://github.com/apache/superset/issues/982)) ([0f8df43](https://github.com/apache/superset/commit/0f8df43a9b4f2eda91c920cebb8bbeae704eeb79))
- **core:** expand native filter hook and add chart metadata fields ([#943](https://github.com/apache/superset/issues/943)) ([25a98fb](https://github.com/apache/superset/commit/25a98fba97937b990880a1a5052718593a2b1698))
- **core:** Registry listeners ([#1191](https://github.com/apache/superset/issues/1191)) ([29df573](https://github.com/apache/superset/commit/29df573a94122197c6082eb7b8df4dc0b643709e))
- **core:** remove defaults for time range filter and Metrics ([#1114](https://github.com/apache/superset/issues/1114)) ([1a4e3e8](https://github.com/apache/superset/commit/1a4e3e8cc62d4d9ce25d68e90ec2cd323e3f0dce))
- **country-map:** added new countries in country-chart-map ([#18081](https://github.com/apache/superset/issues/18081)) ([0cec0c9](https://github.com/apache/superset/commit/0cec0c9a68c9489c54bea8d10ea7b28c1729e2dc))
- Create Chart onClick Functionality ([#20809](https://github.com/apache/superset/issues/20809)) ([7495cdb](https://github.com/apache/superset/commit/7495cdbfe0e3d8ef79b6500581d03ba74684a3a2))
- Create dataset blank state ([#21058](https://github.com/apache/superset/issues/21058)) ([6094274](https://github.com/apache/superset/commit/6094274f0b017b4a456cd78c3039a57be2d63fc5))
- Create dataset header component ([#21189](https://github.com/apache/superset/issues/21189)) ([6e8cad3](https://github.com/apache/superset/commit/6e8cad3e160f0ca7f7dd330861f050ed82a1053b))
- create function for get_sqla_engine with context ([#21790](https://github.com/apache/superset/issues/21790)) ([7600da8](https://github.com/apache/superset/commit/7600da80412186d0f5d0c85e6cd831fbae2e9d9e))
- create reusable selector factory for Encoder ([852b9e6](https://github.com/apache/superset/commit/852b9e609d291c97b1ed4c3d1724c55594cbe732))
- create table component based on ant design Table ([#21520](https://github.com/apache/superset/issues/21520)) ([736b534](https://github.com/apache/superset/commit/736b53418a3b3394dc967458d03d4c0ebcadabdd))
- Creating dataset/add route ([#20869](https://github.com/apache/superset/issues/20869)) ([460b213](https://github.com/apache/superset/commit/460b2130577f85d1996b547fb77b69a00f4ba28e))
- Cross-referenced Dashboards in Chart list (Column + Filter) ([#21760](https://github.com/apache/superset/issues/21760)) ([49b48ee](https://github.com/apache/superset/commit/49b48eeca484fafa2f1c5ef2520694b1bdf5c522))
- **CRUD:** add new empty state ([#19310](https://github.com/apache/superset/issues/19310)) ([d49fd01](https://github.com/apache/superset/commit/d49fd01ff3e3ee153e5e50352ec2151f028a5456))
- **css:** adds `chartId`-based class to dashboard chart holder ([#19873](https://github.com/apache/superset/issues/19873)) ([60188ef](https://github.com/apache/superset/commit/60188ef65476c534647db813c35add3236076cec))
- CSV File Upload form updates ([#21922](https://github.com/apache/superset/issues/21922)) ([6bb4d87](https://github.com/apache/superset/commit/6bb4d87deb95c6230223860fedde07073913d780))
- CSV File Upload form updates (Grouping with Collapse/Expand) ([#21992](https://github.com/apache/superset/issues/21992)) ([2fd0a61](https://github.com/apache/superset/commit/2fd0a6146ed458a47e1a1e07f91d373dda93d290))
- Custom filters control ([#17006](https://github.com/apache/superset/issues/17006)) ([eebc953](https://github.com/apache/superset/commit/eebc953dd599ed13a4893e9c9c726bddb19f7666))
- customize no data message in nvd3 charts ([#330](https://github.com/apache/superset/issues/330)) ([d350dd2](https://github.com/apache/superset/commit/d350dd2f0abdfe1d249aea8d3544839814fe642e))
- customize recent activity access ([#17589](https://github.com/apache/superset/issues/17589)) ([c4b0495](https://github.com/apache/superset/commit/c4b04952d0e446b2347d2e6928478e2207102567))
- **dashboard:** Add create chart button in dashboard edit mode ([#20126](https://github.com/apache/superset/issues/20126)) ([b2a7fad](https://github.com/apache/superset/commit/b2a7fadba951c09fad5867676aaa0470404856df))
- **dashboard:** Add description to the native filter ([#17025](https://github.com/apache/superset/issues/17025)) ([65f1644](https://github.com/apache/superset/commit/65f1644208d499dd52dfd1437f74ec0c228acd9b))
- **dashboard:** Add divider component in native filters ([#17410](https://github.com/apache/superset/issues/17410)) ([9576478](https://github.com/apache/superset/commit/9576478a5dbbfa2e6d057ce16ac19ec9b6ad6940))
- **dashboard:** Add Drill to Detail modal w/ chart menu + right-click support ([#20728](https://github.com/apache/superset/issues/20728)) ([52648ec](https://github.com/apache/superset/commit/52648ecd7f6158473ec198e1ade9a5a69008b752))
- **dashboard:** Add edit button to dashboard native filters filter cards ([#22364](https://github.com/apache/superset/issues/22364)) ([3b45ad8](https://github.com/apache/superset/commit/3b45ad8b97ff7a72ac4d57cfbd2289bf38022cfc))
- **dashboard:** Add thumbnails to dashboard edit draggable chart list ([#20528](https://github.com/apache/superset/issues/20528)) ([d50784d](https://github.com/apache/superset/commit/d50784dd808cf908567e2c7f9fa67188202c59b9))
- **dashboard:** add toast feedback to dashboard actions ([#18114](https://github.com/apache/superset/issues/18114)) ([d9eef8e](https://github.com/apache/superset/commit/d9eef8ec2f15d81309860865319a578f6f5906a5))
- **dashboard:** Chart title click redirects to Explore ([#20111](https://github.com/apache/superset/issues/20111)) ([b746e6f](https://github.com/apache/superset/commit/b746e6f844d457d9a8c81d64e9154f315a61a29d))
- **dashboard:** confirm overwrite to prevent unintended changes ([#21819](https://github.com/apache/superset/issues/21819)) ([ef6b9a9](https://github.com/apache/superset/commit/ef6b9a97d594f748ab710e27281d41ee5250d33a))
- **dashboard:** Display a loading spinner while dashboard is being saved ([#22588](https://github.com/apache/superset/issues/22588)) ([399f6e3](https://github.com/apache/superset/commit/399f6e3ddc8bb21fd7b39cdf850510b2692fbe12))
- **dashboard:** Implement empty states for dashboard ([#18712](https://github.com/apache/superset/issues/18712)) ([f8b3ece](https://github.com/apache/superset/commit/f8b3ece27bea68bc237f61123d2400ee2e1bca44))
- **dashboard:** Implement empty states for empty tabs ([#19408](https://github.com/apache/superset/issues/19408)) ([fc8cb22](https://github.com/apache/superset/commit/fc8cb223761ef78f888d5d4dbf038caa1028b277))
- **dashboard:** Let users re-arrange native filters ([#16154](https://github.com/apache/superset/issues/16154)) ([9e6d5fc](https://github.com/apache/superset/commit/9e6d5fc7752667bbd0df740b0ee50487cecc6c3c))
- **dashboard:** Make FilterBar width resizable ([#20778](https://github.com/apache/superset/issues/20778)) ([1debaca](https://github.com/apache/superset/commit/1debacaaca156c6d63606f3c4aabce8adf13a837))
- **dashboard:** make permalink deterministic ([#20632](https://github.com/apache/superset/issues/20632)) ([c3ac612](https://github.com/apache/superset/commit/c3ac61271ab0b5637b3b199b43fa69be1cfd3bae))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- **dashboard:** Move dashboard auto refresh intervals options to config ([#21924](https://github.com/apache/superset/issues/21924)) ([edce579](https://github.com/apache/superset/commit/edce57904728156312b795923019a1520147d045))
- **dashboard:** Rearrange items in chart header controls dropdown ([#20049](https://github.com/apache/superset/issues/20049)) ([3043a54](https://github.com/apache/superset/commit/3043a54bfc1198bdef8128ec88c8e571d9640cff))
- **dashboard:** Support changing filter bar location ([#22004](https://github.com/apache/superset/issues/22004)) ([68e8b00](https://github.com/apache/superset/commit/68e8b00cdec21db491995567be0aedbe26ea9482))
- **dashboard:** Transition to Explore with React Router ([#20606](https://github.com/apache/superset/issues/20606)) ([de4f7db](https://github.com/apache/superset/commit/de4f7db57ec33c497be9c880fde534a1f026241f))
- **database:** Add user_id and dttm composite index to Log model. ([#19532](https://github.com/apache/superset/issues/19532)) ([d16f274](https://github.com/apache/superset/commit/d16f274991537ef8183eff4636792d2d186d4e16))
- Databricks native driver ([#20320](https://github.com/apache/superset/issues/20320)) ([ec331e6](https://github.com/apache/superset/commit/ec331e683e03e2422e956729f3f32a2442f7d82c))
- Dataset Creation Footer Component ([#21241](https://github.com/apache/superset/issues/21241)) ([c4638fa](https://github.com/apache/superset/commit/c4638fa2b9f9d66ac204b89d24bde7d57e06ebb9))
- **datasets:** Change in API to create virtual datasets ([#21840](https://github.com/apache/superset/issues/21840)) ([decb2fb](https://github.com/apache/superset/commit/decb2fb59190108edd4e3fd3099158dd944aec94))
- **datasets:** Populate Usage tab in Edit Dataset view ([#22670](https://github.com/apache/superset/issues/22670)) ([32fac77](https://github.com/apache/superset/commit/32fac77b5ffd39f693634ee09bcdb205860cb788))
- datasource access to allow more granular access to tables on SQL Lab ([#18064](https://github.com/apache/superset/issues/18064)) ([5ee070c](https://github.com/apache/superset/commit/5ee070c40228d6abbb30e4a8f7888886cf35d7f1))
- **datatable:** render html correctly ([#199](https://github.com/apache/superset/issues/199)) ([a937a2a](https://github.com/apache/superset/commit/a937a2a00ea386896252c7e2188d57c3c55a8033))
- **db_engine_specs:** big query cost estimation ([#21325](https://github.com/apache/superset/issues/21325)) ([001100d](https://github.com/apache/superset/commit/001100ddf02db7be1ea94a1cac16475d00436b78))
- DBC UI Snowflake Form ([#16856](https://github.com/apache/superset/issues/16856)) ([40b88f0](https://github.com/apache/superset/commit/40b88f04f6d360d66fcab7206e2e481d71ddf884)), closes [#16861](https://github.com/apache/superset/issues/16861) [#16875](https://github.com/apache/superset/issues/16875) [#16934](https://github.com/apache/superset/issues/16934) [#17022](https://github.com/apache/superset/issues/17022)
- DBC-UI Globally available across the app 🌎 ([#18722](https://github.com/apache/superset/issues/18722)) ([209e3f4](https://github.com/apache/superset/commit/209e3f45548ae8d0b3ac63d2c393883b733d2b22))
- **deck.gl:** add color range for deck.gl 3D ([#19520](https://github.com/apache/superset/issues/19520)) ([c0a00fd](https://github.com/apache/superset/commit/c0a00fd302ec66fbe0ca766cf73978c99ba00d82))
- **demo:** add helpers for resizable chart demo ([#557](https://github.com/apache/superset/issues/557)) ([5adb9aa](https://github.com/apache/superset/commit/5adb9aaa4332f0586e7c405134f1bf526e3f5478))
- deprecate /superset/extra_table_metadata migrate to api v1 ([#19921](https://github.com/apache/superset/issues/19921)) ([4fdf230](https://github.com/apache/superset/commit/4fdf230a568b014309357b9d691c30fe1a50b32f))
- deprecate /superset/testconn and migrate to api v1 ([#20002](https://github.com/apache/superset/issues/20002)) ([7b7de95](https://github.com/apache/superset/commit/7b7de9592b1852e1582f5be84e4d954e3f55f011))
- deprecate /superset/validate_sql_json migrate to api v1 ([#19935](https://github.com/apache/superset/issues/19935)) ([87a4379](https://github.com/apache/superset/commit/87a4379d0ac1d6bd1b7c91e22742393271929ed5))
- deprecate created_slices API endpoint ([#21664](https://github.com/apache/superset/issues/21664)) ([3057e42](https://github.com/apache/superset/commit/3057e4270cd76232271072b74ad13e7301bd3a79))
- deprecate old API and create new API for dashes created by me ([#19434](https://github.com/apache/superset/issues/19434)) ([d6d2777](https://github.com/apache/superset/commit/d6d2777ada0768682fde7f32cd7e49ec6b0203f2))
- deprecate old API on core superset fave_dashboards ([#19754](https://github.com/apache/superset/issues/19754)) ([85b0ef8](https://github.com/apache/superset/commit/85b0ef8526f9f672306120fc1fda8f9d4661bc80))
- deprecate old SuperChart API that accepts chartProps ([#202](https://github.com/apache/superset/issues/202)) ([0fb91c0](https://github.com/apache/superset/commit/0fb91c0e6bb8396ed423324b05595b67e006d72e))
- derived metrics use different line style ([#20242](https://github.com/apache/superset/issues/20242)) ([7faf874](https://github.com/apache/superset/commit/7faf874c1b9613258606fb10f5800a185c30c81e))
- disable edits on external assets ([#19344](https://github.com/apache/superset/issues/19344)) ([d304849](https://github.com/apache/superset/commit/d304849b46b39bb6a261b735b7ca658962bc31e0))
- Disables HTML rendering in Toast by default ([#21853](https://github.com/apache/superset/issues/21853)) ([47b1e0c](https://github.com/apache/superset/commit/47b1e0ca9dfdea153e133442bee676ba9a73aba0))
- **docker-compose:** add TAG option ([#18214](https://github.com/apache/superset/issues/18214)) ([0a91a68](https://github.com/apache/superset/commit/0a91a6880a0769ace79224b9a967eec6a685d03d))
- **docker:** Build multiple python version images ([#22770](https://github.com/apache/superset/issues/22770)) ([931b01e](https://github.com/apache/superset/commit/931b01ee85702aabe7632a278e0f13837087b5a1))
- don't ask for password when DB exists ([#17776](https://github.com/apache/superset/issues/17776)) ([73ae892](https://github.com/apache/superset/commit/73ae892066ca719c5ff1ecf6dfe2d237fef41934))
- Drill ODBC/JDBC Impersonation feature ([#17353](https://github.com/apache/superset/issues/17353)) ([333b137](https://github.com/apache/superset/commit/333b1371f75437e213f1319e506183690bba0705))
- drop missing columns control ([#20586](https://github.com/apache/superset/issues/20586)) ([309327d](https://github.com/apache/superset/commit/309327dcbdec954283ef6cd03fccf264a830e4a5))
- Dynamic dashboard component ([#17208](https://github.com/apache/superset/issues/17208)) ([bcad1ac](https://github.com/apache/superset/commit/bcad1acec27823756dc403f6e982f5e59ec6d6cf))
- echarts gauge chart ([#993](https://github.com/apache/superset/issues/993)) ([9070ac9](https://github.com/apache/superset/commit/9070ac954eb4988d4a6ab7ded7bd03d9ca102484))
- editable title xl certified badge ([#18626](https://github.com/apache/superset/issues/18626)) ([00eb6b1](https://github.com/apache/superset/commit/00eb6b1f5711e1af0b8dcfc05346ad0dacadddda))
- embedded dashboard ([#18561](https://github.com/apache/superset/issues/18561)) ([1fbdabd](https://github.com/apache/superset/commit/1fbdabd2cf88ce4da0b99897ce00afd03ae47d27))
- Embedded dashboard configuration ([#19364](https://github.com/apache/superset/issues/19364)) ([8e29ec5](https://github.com/apache/superset/commit/8e29ec5a6685867ffc035d20999c54c2abe36fb1))
- embedded dashboard core ([#17530](https://github.com/apache/superset/issues/17530)) ([4ad5ad0](https://github.com/apache/superset/commit/4ad5ad045a9adb506d14b2c02fdbefc564d25bdb)), closes [#17175](https://github.com/apache/superset/issues/17175) [#17450](https://github.com/apache/superset/issues/17450) [#17517](https://github.com/apache/superset/issues/17517) [#17529](https://github.com/apache/superset/issues/17529) [#17757](https://github.com/apache/superset/issues/17757) [#17836](https://github.com/apache/superset/issues/17836)
- Embedded SDK ([#18250](https://github.com/apache/superset/issues/18250)) ([1c2936b](https://github.com/apache/superset/commit/1c2936ba7b3e54d65f6607b14cd0b341f83d9b91))
- **embedded-dashboard:** Share Switchboard State for Sending Events from Plugins ([#21319](https://github.com/apache/superset/issues/21319)) ([20b9dc8](https://github.com/apache/superset/commit/20b9dc84449969706efb94210bc11b2e43cc9a0f))
- **embedded-SDK:** enable CSV download ([#20416](https://github.com/apache/superset/issues/20416)) ([655646d](https://github.com/apache/superset/commit/655646d35bea8f52d805d1bcc36e58d10fb8a6d5))
- **embedded:** +2 functions: getDashboardPermalink, getActiveTabs ([#21444](https://github.com/apache/superset/issues/21444)) ([b787c3f](https://github.com/apache/superset/commit/b787c3fef4655c1142da3d827fe6766c853ffe72))
- **embedded:** add optional dashboard ui configuration ([#19031](https://github.com/apache/superset/issues/19031)) ([124cb0d](https://github.com/apache/superset/commit/124cb0dc669756f0cec1b1a82cdaddf35520282e))
- **embedded:** API get embedded dashboard config by uuid ([#19650](https://github.com/apache/superset/issues/19650)) ([224769b](https://github.com/apache/superset/commit/224769bd452b831ae4ab4d7fc658b61805970b62))
- **embedded:** aud claim and type for guest token ([#18651](https://github.com/apache/superset/issues/18651)) ([e6ea197](https://github.com/apache/superset/commit/e6ea197e9f2a1ea513c40afb0ae1c27ef7a5aa13))
- **embedded:** enforce allow domains ([#20251](https://github.com/apache/superset/issues/20251)) ([f53018c](https://github.com/apache/superset/commit/f53018c7c5ebbec04ffd879e1b09fb4a3ffa5609))
- **embedded:** make guest token JWT audience callable or str ([#18748](https://github.com/apache/superset/issues/18748)) ([b2613f6](https://github.com/apache/superset/commit/b2613f648c9674e80e1bca885ee79ddd2805a21c))
- **embedded:** provides filter bar visibility setting on embedded dashboard ([#21069](https://github.com/apache/superset/issues/21069)) ([#21070](https://github.com/apache/superset/issues/21070)) ([eb80568](https://github.com/apache/superset/commit/eb805682e2d9b8ff6c4bda446e665d1045afe55f))
- Enable new dataset creation flow ([#22610](https://github.com/apache/superset/issues/22610)) ([c87f654](https://github.com/apache/superset/commit/c87f654901f5a975fa2f348c2893b2aa78db5707))
- Enable new dataset creation flow II ([#22835](https://github.com/apache/superset/issues/22835)) ([260ac40](https://github.com/apache/superset/commit/260ac40b23e99a49be70781e56bc037e5f952090))
- Enabling source maps full time ([#19710](https://github.com/apache/superset/issues/19710)) ([34008f7](https://github.com/apache/superset/commit/34008f78c9456bd40c0893dd8e239b5c47b612e4))
- **encodable:** add function for setting domain ([#256](https://github.com/apache/superset/issues/256)) ([1772b67](https://github.com/apache/superset/commit/1772b671cf63c860a0584e3975c8dd3c75e9ed85))
- **encodable:** fill missing fields in user-specified channel definition ([#222](https://github.com/apache/superset/issues/222)) ([1978d9b](https://github.com/apache/superset/commit/1978d9bc2e5fb717432e45fa32feb8e6ea47efce))
- **encodable:** handle edge cases when making domain includes zero ([#257](https://github.com/apache/superset/issues/257)) ([e719c19](https://github.com/apache/superset/commit/e719c1936525df7a601bfca52420f4cbbb3e3667))
- **encodable:** implement axis functions for ChannelEncoder ([#247](https://github.com/apache/superset/issues/247)) ([9ef8318](https://github.com/apache/superset/commit/9ef831829b9630593f7320ca840813a2d8a91df1))
- **encodable:** make applyDomain() able to handle domain from dataset ([#254](https://github.com/apache/superset/issues/254)) ([f5f944b](https://github.com/apache/superset/commit/f5f944b40500181c5e4beb8c4f0d55ddb6ddc51f))
- **encodable:** only set scale domain if both bounds are defined ([#250](https://github.com/apache/superset/issues/250)) ([b672373](https://github.com/apache/superset/commit/b6723737a33f2d544b5cd5d3f06c2dfb8583df7e))
- Environment tag ([#20295](https://github.com/apache/superset/issues/20295)) ([25cc789](https://github.com/apache/superset/commit/25cc7897b1ac0ba3294d437b16e7eae5a0bc78c9))
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- Explore popovers should close on escape ([#19902](https://github.com/apache/superset/issues/19902)) ([dbc653d](https://github.com/apache/superset/commit/dbc653d442e48078546210a76df5eb216b30b707))
- **explore-popover:** Show disabled 'Save' button in explore popover ([#21318](https://github.com/apache/superset/issues/21318)) ([0dbaaad](https://github.com/apache/superset/commit/0dbaaad83d9a80b1c3ea46af7859f7f4f7d677e0))
- **explore:** add config for default time filter ([#21879](https://github.com/apache/superset/issues/21879)) ([9a063ab](https://github.com/apache/superset/commit/9a063abb3b28e32b1107950942571d564bb283f8))
- **explore:** Add empty state to annotations ([#20160](https://github.com/apache/superset/issues/20160)) ([0ee1f49](https://github.com/apache/superset/commit/0ee1f492a799f339e1adf3b260a95ff541c331de))
- **explore:** adhoc column expressions [ID-3] ([#17379](https://github.com/apache/superset/issues/17379)) ([e2a429b](https://github.com/apache/superset/commit/e2a429b0c8042ba867f834f5dc5561d1e402289b)), closes [#16531](https://github.com/apache/superset/issues/16531) [#16570](https://github.com/apache/superset/issues/16570) [#16559](https://github.com/apache/superset/issues/16559) [#16412](https://github.com/apache/superset/issues/16412) [#16573](https://github.com/apache/superset/issues/16573) [#16568](https://github.com/apache/superset/issues/16568) [#16535](https://github.com/apache/superset/issues/16535) [#16548](https://github.com/apache/superset/issues/16548) [#16595](https://github.com/apache/superset/issues/16595) [#16594](https://github.com/apache/superset/issues/16594) [#16601](https://github.com/apache/superset/issues/16601)
- **explore:** Allow using time formatter on temporal columns in data table ([#18569](https://github.com/apache/superset/issues/18569)) ([830f2e7](https://github.com/apache/superset/commit/830f2e71d3328ffa0a50af353ad9eb656e0812ed))
- **explore:** Apply denormalization to tier 2 charts form data ([#20524](https://github.com/apache/superset/issues/20524)) ([e12ee59](https://github.com/apache/superset/commit/e12ee59b13822241dca8d8015f1222c477edd4f3))
- **explore:** Dataset panel option tooltips ([#19259](https://github.com/apache/superset/issues/19259)) ([45c28c8](https://github.com/apache/superset/commit/45c28c8046c56d4ebe1dfaf0235783fe864ae75f))
- **explore:** Dataset Panel Options when Source = Query II ([#20299](https://github.com/apache/superset/issues/20299)) ([c842c9e](https://github.com/apache/superset/commit/c842c9e2d8d2b579e514fb291def3f3b0a5860e3))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- **explore:** Don't discard controls with custom sql when changing datasource ([#20934](https://github.com/apache/superset/issues/20934)) ([cddc361](https://github.com/apache/superset/commit/cddc361adc483ed605857a2eb39c5efffa089076))
- **explore:** export csv data pivoted for Pivot Table [ID-9] ([#17512](https://github.com/apache/superset/issues/17512)) ([07e8837](https://github.com/apache/superset/commit/07e8837093b79b08e18224dd6765a2fc15a0e770))
- **explore:** Fill dashboard name when adding new chart from dashboard view ([#20129](https://github.com/apache/superset/issues/20129)) ([3e3fbcc](https://github.com/apache/superset/commit/3e3fbccdcb03faaf484b5077827fa48d3183f629))
- **explore:** Frontend implementation of dataset creation from infobox ([#19855](https://github.com/apache/superset/issues/19855)) ([ba0c37d](https://github.com/apache/superset/commit/ba0c37d3df85b1af39404af1d578daeb0ff2d278))
- **explore:** Implement chart empty states ([#18678](https://github.com/apache/superset/issues/18678)) ([167e18e](https://github.com/apache/superset/commit/167e18e806799dede3aa56da98be11f4751f0272))
- **explore:** Implement data panel redesign ([#19751](https://github.com/apache/superset/issues/19751)) ([594523e](https://github.com/apache/superset/commit/594523e895a8fa455ba6db5d6cc4df80d20179a1))
- **explore:** Implement data table empty states ([#18679](https://github.com/apache/superset/issues/18679)) ([42d97fb](https://github.com/apache/superset/commit/42d97fb078a50bca9ecb815f508a198ff5231487))
- **explore:** Implement metrics and columns popovers empty states ([#18681](https://github.com/apache/superset/issues/18681)) ([c1205b5](https://github.com/apache/superset/commit/c1205b5279e891af8c3276ee2dd7343623e8cbb3))
- **explore:** Implement viz switcher redesign ([#20248](https://github.com/apache/superset/issues/20248)) ([86f146e](https://github.com/apache/superset/commit/86f146e217ddb7c2ebd499acddaa5e8c3b3ab560))
- **explore:** improve UI in the control panel ([#19748](https://github.com/apache/superset/issues/19748)) ([e3a54aa](https://github.com/apache/superset/commit/e3a54aa3c15bdd0c970aa73f898288a408205c97))
- **explore:** Keep or reset chart config after datasource change ([#18215](https://github.com/apache/superset/issues/18215)) ([7096982](https://github.com/apache/superset/commit/70969821de07bbeac880c476202e5dd3d7a962e8))
- **explore:** More explicit labels of adhoc filter operators ([#19691](https://github.com/apache/superset/issues/19691)) ([b81982d](https://github.com/apache/superset/commit/b81982d8f3ae5dea8a70b20406a77f81393c578f))
- **explore:** more toast feedback on user actions in Explore ([#18108](https://github.com/apache/superset/issues/18108)) ([e632193](https://github.com/apache/superset/commit/e632193eb00803594a1bbc20c2f6cb6fb29deb1f))
- **explore:** Move chart actions into dropdown ([#19446](https://github.com/apache/superset/issues/19446)) ([1a1322d](https://github.com/apache/superset/commit/1a1322d3d92960416a4874997b53aec3bd59eff6))
- **explore:** Move chart header to top of the page ([#19529](https://github.com/apache/superset/issues/19529)) ([602afba](https://github.com/apache/superset/commit/602afbaa31d72eefd213d85649eee494e72add7a))
- **explore:** Move timer, row counter and cached pills to chart container ([#19458](https://github.com/apache/superset/issues/19458)) ([03d3eaa](https://github.com/apache/superset/commit/03d3eaacafc6ebdad7fdbcef6efa4df553468ba1))
- **explore:** Redesign of Run/Save buttons ([#19558](https://github.com/apache/superset/issues/19558)) ([c8304a2](https://github.com/apache/superset/commit/c8304a2821cc86d01e3e3c01ee597c94b1fb64e9))
- **explore:** Replace overlay with alert banner when chart controls change ([#19696](https://github.com/apache/superset/issues/19696)) ([6f4480a](https://github.com/apache/superset/commit/6f4480a06cf4b48f7ab69a55016a0c9ad2c3790b))
- **explore:** Show confirmation modal if user exits Explore without saving changes ([#19993](https://github.com/apache/superset/issues/19993)) ([ca9766c](https://github.com/apache/superset/commit/ca9766c109ae0849748e791405554f54e5d13249))
- **explore:** SQL popover in datasource panel ([#19308](https://github.com/apache/superset/issues/19308)) ([60dcd65](https://github.com/apache/superset/commit/60dcd651f44b7e1aa1b030e0cd5c64334a346e60))
- **explore:** standardized controls for time pivot chart ([#21321](https://github.com/apache/superset/issues/21321)) ([79525df](https://github.com/apache/superset/commit/79525dfaf29b810af668e3b6c5a56cd866370d92))
- **explore:** support show annotation label [ID-8] ([#17307](https://github.com/apache/superset/issues/17307)) ([a3cce57](https://github.com/apache/superset/commit/a3cce5705dfe21ad76b8edc22e6418620a463eb1))
- **explore:** UI changes in dataset panel on Explore page ([#19394](https://github.com/apache/superset/issues/19394)) ([a076ae6](https://github.com/apache/superset/commit/a076ae6d9913a62d353d1cc2d4ed09e27ce9f6e2))
- **explore:** UX changes in fast viz switcher ([#20848](https://github.com/apache/superset/issues/20848)) ([5c2c2e8](https://github.com/apache/superset/commit/5c2c2e804064ba674ae18abe5aec495454b7ff21))
- export/import `allow_dml` flag ([#22806](https://github.com/apache/superset/issues/22806)) ([6f0fed7](https://github.com/apache/superset/commit/6f0fed77cfe737122cec98374dc6774240cd6396))
- expose form_data to datasourceControl ([#1148](https://github.com/apache/superset/issues/1148)) ([6b4480b](https://github.com/apache/superset/commit/6b4480b63f842987d7f30b38c29fd3983077e21f))
- external management flags in CRUD ([#19318](https://github.com/apache/superset/issues/19318)) ([9766726](https://github.com/apache/superset/commit/9766726b26e780c9e0d68eb8e8f9c27332c7a9d2))
- extra_jwt support to be used in dashboard_rbac ([#1021](https://github.com/apache/superset/issues/1021)) ([e71d929](https://github.com/apache/superset/commit/e71d929034ad15e359e04536ad3252d8d9200b90))
- **feature-flag:** add ALERTS_ATTACH_REPORTS feature flag ([#1042](https://github.com/apache/superset/issues/1042)) ([803fd44](https://github.com/apache/superset/commit/803fd44dac513ce100df209dfc17e2a775d1d431))
- file skeleton necessary for icicle chart visualization ([#162](https://github.com/apache/superset/issues/162)) ([4760af2](https://github.com/apache/superset/commit/4760af293ecac9436451c1500f0d9dd58bc7d03a))
- filter parameters from DB API ([#21248](https://github.com/apache/superset/issues/21248)) ([34a79ad](https://github.com/apache/superset/commit/34a79add04d4525c164699248c30c9d6588c876d))
- filter with created_by for charts and dashboards ([#21199](https://github.com/apache/superset/issues/21199)) ([05354a9](https://github.com/apache/superset/commit/05354a96bfaeacaa39974977b4502cd26bef8413))
- **Filter-sets:** connect to api ([#17055](https://github.com/apache/superset/issues/17055)) ([37944e1](https://github.com/apache/superset/commit/37944e18d6dccb04a5a768134b6fc1f4a2e625a3))
- **filters:** add onFilterUpdate handler to list view filters ([#21443](https://github.com/apache/superset/issues/21443)) ([f27e20e](https://github.com/apache/superset/commit/f27e20e30dc90b068887cb79cb030eb020f8ea6d))
- Flow for tables that already have a dataset ([#22136](https://github.com/apache/superset/issues/22136)) ([04b7a26](https://github.com/apache/superset/commit/04b7a26365edac524cbeb7336bd64898cdf52835))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- generate label map on the backend ([#21124](https://github.com/apache/superset/issues/21124)) ([11bf7b9](https://github.com/apache/superset/commit/11bf7b9125eefd93796a46d964c3f027fbc9ce4d))
- **generator-superset:** add scaffolder for chart plugin ([#456](https://github.com/apache/superset/issues/456)) ([dfa166c](https://github.com/apache/superset/commit/dfa166ca819b1c93957af25db5365467c1fa3d7a))
- Generic X-axis improvements ([#22707](https://github.com/apache/superset/issues/22707)) ([af73c59](https://github.com/apache/superset/commit/af73c59b0a436ae88f64f12d4d40e4abf5fb54e8))
- getter function to return color mapping ([#124](https://github.com/apache/superset/issues/124)) ([9dd30b0](https://github.com/apache/superset/commit/9dd30b0350baa22943578f93027cc182de109b9b))
- groupby filter ([#1064](https://github.com/apache/superset/issues/1064)) ([2bb19f1](https://github.com/apache/superset/commit/2bb19f16ee6480d5538db8bac7f29d46e2aa6bc7))
- hack db connection modal ctabtns ([#20017](https://github.com/apache/superset/issues/20017)) ([9da7c1f](https://github.com/apache/superset/commit/9da7c1f7b83abea20e3620d5461a47dc4a2ab019))
- **handlebars plugin:** adding handlebars helpers for common math operations ([#20648](https://github.com/apache/superset/issues/20648)) ([9856d88](https://github.com/apache/superset/commit/9856d88c03c78a97f6037077e0d0e1e2bac491fe))
- have user go to explore after dataset creation ([#19965](https://github.com/apache/superset/issues/19965)) ([c795dc2](https://github.com/apache/superset/commit/c795dc23b96a0af3be4bcf1b287137de261b18ca))
- Helm - custom service account creation and management ([#17880](https://github.com/apache/superset/issues/17880)) ([6991417](https://github.com/apache/superset/commit/699141745aca5bbfb929f4166c9f599be8d27974))
- **Helm Chart:** Support resource limits and requests for each component ([#20052](https://github.com/apache/superset/issues/20052)) ([259e03e](https://github.com/apache/superset/commit/259e03ee12b0c82d801a0ad5765de4456a9646c5))
- **helm:** add `metadata namespace` ([#22020](https://github.com/apache/superset/issues/22020)) ([53ed8f2](https://github.com/apache/superset/commit/53ed8f2d5a64a655cf508d38f1b617df435d3628))
- **helm:** Add ability to customize affinity per deployment ([#22827](https://github.com/apache/superset/issues/22827)) ([b132451](https://github.com/apache/superset/commit/b132451581e456d202881991f675cb7665af0eb1))
- **helm:** add annotations on ServiceAccount ([#21536](https://github.com/apache/superset/issues/21536)) ([8ee34e1](https://github.com/apache/superset/commit/8ee34e175d9c2ee2d77ca9eb7406f8d06e790c7d))
- **helm:** add deploymentLabels variable ([#22541](https://github.com/apache/superset/issues/22541)) ([d6bce09](https://github.com/apache/superset/commit/d6bce09ac32d3146d22a14d205139551637170af))
- **helm:** add liveness and readiness for deployment webserver ([#20567](https://github.com/apache/superset/issues/20567)) ([554ed64](https://github.com/apache/superset/commit/554ed6495e33f57ea5e4f5834c01e0e51c6a8e73))
- **helm:** add RollingUpdate parameters ([#20931](https://github.com/apache/superset/issues/20931)) ([3f8e9a5](https://github.com/apache/superset/commit/3f8e9a567aa500c707dd024676cc3f6b721e0c71))
- **helm:** Add schema of values in Helm Chart ([#18161](https://github.com/apache/superset/issues/18161)) ([6200977](https://github.com/apache/superset/commit/62009773a63b9a149b259135d762102aedaae2b3))
- **helm:** Added env variable SERVER_WORKER_AMOUNT ([#21236](https://github.com/apache/superset/issues/21236)) ([05bdaf2](https://github.com/apache/superset/commit/05bdaf23765b90bf072f23250049174cc2ba5047))
- **helm:** allow persisting nodePort for services ([#22713](https://github.com/apache/superset/issues/22713)) ([a307223](https://github.com/apache/superset/commit/a307223857a3888931c2a876ba6e9d5b31a85add))
- **helm:** allow to customize init image ([#18649](https://github.com/apache/superset/issues/18649)) ([4db70b5](https://github.com/apache/superset/commit/4db70b5c18fc7d66ae05bfa24badf7659d4319d7))
- **HelmChart:** Add securityContext on pod level ([#20666](https://github.com/apache/superset/issues/20666)) ([ae306d6](https://github.com/apache/superset/commit/ae306d6d1f76d6437e640c649e6a4c4e8b3060cb))
- **HelmChart:** Configurable securityContext in Pods ([#20509](https://github.com/apache/superset/issues/20509)) ([1a80668](https://github.com/apache/superset/commit/1a806687fc75c5ed4f561ece1264149e37dd7df3))
- **helm:** Make Chart.AppVersion default value for image tag ([#22854](https://github.com/apache/superset/issues/22854)) ([ede18be](https://github.com/apache/superset/commit/ede18be08e74f1798e9af10706c3cfeaa08067ad))
- **Helm:** Redis with password supported in helm charts and redis chart version updated ([#18642](https://github.com/apache/superset/issues/18642)) ([33d1c96](https://github.com/apache/superset/commit/33d1c967649890500fb788678e8a10afc08bc99a))
- **helm:** support different replicaCount ([#20883](https://github.com/apache/superset/issues/20883)) ([8e0f16f](https://github.com/apache/superset/commit/8e0f16fade43ac0e819fff1d64273eb003ad675d))
- **helm:** Support for flower and websocket containers ([#21806](https://github.com/apache/superset/issues/21806)) ([06da7bf](https://github.com/apache/superset/commit/06da7bf65c5d7aaa2247faf826fa9e46653e82ad))
- helper functions for RLS ([#19055](https://github.com/apache/superset/issues/19055)) ([8234395](https://github.com/apache/superset/commit/8234395466d0edaead3c36b57fd0b81621cc1c5c))
- Hide nav create with RBAC ([#17157](https://github.com/apache/superset/issues/17157)) ([b5246b2](https://github.com/apache/superset/commit/b5246b29dfb5fe104674dac83996dada8031852a))
- Horizontal filter bar states ([#22064](https://github.com/apache/superset/issues/22064)) ([25114a7](https://github.com/apache/superset/commit/25114a7b97ca96341cdb2d5e6fceceddf6ebc3c4))
- implement ECharts pie chart ([#772](https://github.com/apache/superset/issues/772)) ([2169a0b](https://github.com/apache/superset/commit/2169a0b37e48b122d0babfb3f4242af362ecba72))
- Implement EmptyState components ([#18676](https://github.com/apache/superset/issues/18676)) ([a7d505d](https://github.com/apache/superset/commit/a7d505db4136d94ffd93c93c3f1a553c22f9081e))
- implement Filter dnd ([#978](https://github.com/apache/superset/issues/978)) ([b202007](https://github.com/apache/superset/commit/b2020076dac3d55d0007f2bd88630681f96d01d1))
- implement labelFlush behavior for continuous axes ([#117](https://github.com/apache/superset/issues/117)) ([c691415](https://github.com/apache/superset/commit/c691415702a61d8579c7c943f03b867d21570699))
- implement Metrics dnd ([#1004](https://github.com/apache/superset/issues/1004)) ([7c023cf](https://github.com/apache/superset/commit/7c023cfc87b77e10673daca37674fb783cfde22a))
- import external management columns ([#19315](https://github.com/apache/superset/issues/19315)) ([c7f9060](https://github.com/apache/superset/commit/c7f9060a2fcf84cc2b73af692b15c864676ed557))
- import theme colors ([#601](https://github.com/apache/superset/issues/601)) ([8cc4399](https://github.com/apache/superset/commit/8cc4399815dd432c7b9fe98413f63d81f22b3d37))
- import/export assets commands ([#19217](https://github.com/apache/superset/issues/19217)) ([51061f0](https://github.com/apache/superset/commit/51061f0d672abca29f84943acb16a37403f25c2e))
- improve adhoc SQL validation ([#19454](https://github.com/apache/superset/issues/19454)) ([6828624](https://github.com/apache/superset/commit/6828624f61fff21485b0b2e91ac53701d43cb0d7))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- improve line chart margin/axis and add buildquery ([#66](https://github.com/apache/superset/issues/66)) ([1f33026](https://github.com/apache/superset/commit/1f33026b380c34133ab75ecad84f5806245d8cf1))
- improve logic in is_select ([#17329](https://github.com/apache/superset/issues/17329)) ([93bafa0](https://github.com/apache/superset/commit/93bafa0e6ae02cef068419ac7d350d2446a1e82a))
- improve margin merging ([#159](https://github.com/apache/superset/issues/159)) ([aedc1b4](https://github.com/apache/superset/commit/aedc1b405d69a4c8b13e25264aac6b2014bb0b70))
- Improve state key generation for dashboards and charts ([#18576](https://github.com/apache/superset/issues/18576)) ([48a8095](https://github.com/apache/superset/commit/48a80950de06dee1d0af5b11b33401108395f04d))
- improve table performance ([#246](https://github.com/apache/superset/issues/246)) ([b785b20](https://github.com/apache/superset/commit/b785b20b970f8839c45781e99f4808718871268e))
- improve the tooltip for the time pivot chart ([#30](https://github.com/apache/superset/issues/30)) ([ec2c194](https://github.com/apache/superset/commit/ec2c1946c8be328a03be41cc117f86f4f95f6c6d))
- improve world map colors ([#711](https://github.com/apache/superset/issues/711)) ([4317795](https://github.com/apache/superset/commit/43177957ca3c319f957549e3d82344c1af80fba4))
- Improves key expiration handling in Explore ([#18624](https://github.com/apache/superset/issues/18624)) ([f03b4db](https://github.com/apache/superset/commit/f03b4dbedb29087c6958804aa803b5fb3200c7bb))
- Improves SafeMarkdown HTML sanitization ([#21895](https://github.com/apache/superset/issues/21895)) ([7d1df3b](https://github.com/apache/superset/commit/7d1df3b78d5d7147dd9d627317e3f9f10d279ae0))
- increment the version number ([#44](https://github.com/apache/superset/issues/44)) ([5a643dd](https://github.com/apache/superset/commit/5a643dd047408e36bdd9b39daacf718099092f0a))
- Increments charts endpoint with related dashboards ([#21518](https://github.com/apache/superset/issues/21518)) ([2ec744d](https://github.com/apache/superset/commit/2ec744da21c33c49cada569aaf3c5b5d9d7562f1))
- Integrate ant d table component into DatasetPanel ([#21948](https://github.com/apache/superset/issues/21948)) ([defe5c8](https://github.com/apache/superset/commit/defe5c8ba71851d6870985bbbc1c6c0650aa87b8))
- integrate line chart with build query and update typings ([#73](https://github.com/apache/superset/issues/73)) ([23c4aa3](https://github.com/apache/superset/commit/23c4aa3d1e4c0bc35ce07f7441d9f21bb06cb6e9))
- Introduce a library for embedded iframe <-> host communication ([#18652](https://github.com/apache/superset/issues/18652)) ([225015f](https://github.com/apache/superset/commit/225015fd5a94c1a92cc9b110e3e3db5cd532d47b))
- introduce hashids permalink keys ([#19324](https://github.com/apache/superset/issues/19324)) ([f4b71ab](https://github.com/apache/superset/commit/f4b71abb2279be4720e8a66999ace62b630fedf3))
- introduce shared modules logic ([#871](https://github.com/apache/superset/issues/871)) ([e794063](https://github.com/apache/superset/commit/e794063a3a5f361d92da7d7933b9b19c95ee1c8e))
- **key-value:** add superset metastore cache ([#19232](https://github.com/apache/superset/issues/19232)) ([72b9a7f](https://github.com/apache/superset/commit/72b9a7fa5b1a0c1d5f9769778280b32501356570))
- **legacy-plugin-chart-big-number:** add control panel config for the BigNumber charts ([#419](https://github.com/apache/superset/issues/419)) ([9c2495c](https://github.com/apache/superset/commit/9c2495c03ca6df4f3bd5e5b98ce7a71eeeba18bf))
- **legacy-plugin-chart-calendar:** increase the contrast of calendar heatmap color and label ([#1452](https://github.com/apache/superset/issues/1452)) ([a71d3ca](https://github.com/apache/superset/commit/a71d3caa6c095e92abb42c77c557a7e27ffb82f8))
- **legacy-plugin-chart-chord:** control panel ([#481](https://github.com/apache/superset/issues/481)) ([d76cd6b](https://github.com/apache/superset/commit/d76cd6b46e86a17e24fd93620211b623b104cc35))
- **legacy-plugin-chart-country-map:** add Australia geojson file ([#1268](https://github.com/apache/superset/issues/1268)) ([f0b5398](https://github.com/apache/superset/commit/f0b53989d070cb06a677336965982ce1d252c22c))
- **legacy-plugin-chart-country-map:** add peru country map ([#1424](https://github.com/apache/superset/issues/1424)) ([e494f00](https://github.com/apache/superset/commit/e494f0065c8f9b452ae9b9776b31c95530e7ed77))
- **legacy-plugin-chart-country-map:** add six new maps ([#1327](https://github.com/apache/superset/issues/1327)) ([884b8ec](https://github.com/apache/superset/commit/884b8ec098a664a259e1aa383698e007ca97dfa5))
- **legacy-plugin-chart-country-map:** Add Slovenia map ([#1054](https://github.com/apache/superset/issues/1054)) ([8295e7a](https://github.com/apache/superset/commit/8295e7a428c3094395479cdcc6be639b684f0314))
- **legacy-plugin-chart-country-map:** add Switzerland to country map chart ([#260](https://github.com/apache/superset/issues/260)) ([bdf5a60](https://github.com/apache/superset/commit/bdf5a601aeb9d7554a9da51c01cbc5c1b9f84a7d))
- **legacy-plugin-chart-country-map:** Add Uruguay map ([#944](https://github.com/apache/superset/issues/944)) ([af68270](https://github.com/apache/superset/commit/af6827018df906c8ef9ab2784caa66a95792b424))
- **legacy-plugin-chart-country-map:** add Vietnam map ([#1334](https://github.com/apache/superset/issues/1334)) ([d237bb6](https://github.com/apache/superset/commit/d237bb6e074d392cb903e44bea6e34b5d45d10fe))
- **legacy-plugin-chart-country-map:** added finland map ([#1258](https://github.com/apache/superset/issues/1258)) ([e693381](https://github.com/apache/superset/commit/e69338102931aad86b3ed5368ff5656aac8a7e89))
- **legacy-plugin-chart-country-map:** added indonesia map ([#1088](https://github.com/apache/superset/issues/1088)) ([ac7dfad](https://github.com/apache/superset/commit/ac7dfada0e00e83807fee831cb8c08c71433706f))
- **legacy-plugin-chart-country-map:** migrate and replace india map ([#376](https://github.com/apache/superset/issues/376)) ([8dd02b3](https://github.com/apache/superset/commit/8dd02b36339462e1c0ac3885929d31f419d00f69))
- **legacy-plugin-chart-event-flow:** control panel ([#501](https://github.com/apache/superset/issues/501)) ([53e8a4f](https://github.com/apache/superset/commit/53e8a4ff5b959442c5b3faeb03ac1ebcf525379a))
- **legacy-plugin-chart-event-flow:** migrate package ([#514](https://github.com/apache/superset/issues/514)) ([ae6a1bb](https://github.com/apache/superset/commit/ae6a1bbefb8e420cf04408408bc42cc6c35a39d2))
- **legacy-plugin-chart-force-directed:** control panel ([#502](https://github.com/apache/superset/issues/502)) ([081e223](https://github.com/apache/superset/commit/081e2237f8efdb35366627451bc01b55f632fb0d))
- **legacy-plugin-chart-heatmap:** control panel ([#503](https://github.com/apache/superset/issues/503)) ([aee724b](https://github.com/apache/superset/commit/aee724b1ad29beb4b024fb8f74dba6afe9921638))
- **legacy-plugin-chart-histogram:** control panel ([#504](https://github.com/apache/superset/issues/504)) ([6e4dd8e](https://github.com/apache/superset/commit/6e4dd8ef1959d2f85ce677c17392144068bee7d3))
- **legacy-plugin-chart-histogram:** cumulative histogram option ([#1381](https://github.com/apache/superset/issues/1381)) ([98e2f74](https://github.com/apache/superset/commit/98e2f744b32550a1ff75a943365e4b36b8bcfd52))
- **legacy-plugin-chart-histogram:** subject Add legend option to histogram chart ([#905](https://github.com/apache/superset/issues/905)) ([f059610](https://github.com/apache/superset/commit/f0596103a86ec6a2d8496cdd526039674569c708))
- **legacy-plugin-chart-horizon:** control panel ([#505](https://github.com/apache/superset/issues/505)) ([39655ff](https://github.com/apache/superset/commit/39655ff1b208e6647da06aa24010c197c070c824))
- **legacy-plugin-chart-iframe:** control panel ([#506](https://github.com/apache/superset/issues/506)) ([ffb9e87](https://github.com/apache/superset/commit/ffb9e8718f1d080ef1db76da48add62855a00429))
- **legacy-plugin-chart-map-box:** control panel ([#507](https://github.com/apache/superset/issues/507)) ([2cd7891](https://github.com/apache/superset/commit/2cd7891c9af3df238447c77dee4af663c074e6dd))
- **legacy-plugin-chart-map-box:** show all points in mapbox chart ([#960](https://github.com/apache/superset/issues/960)) ([978af22](https://github.com/apache/superset/commit/978af22b3e405d54237428ef79753e947ad1917c))
- **legacy-plugin-chart-markup:** add controls to markup chart ([#479](https://github.com/apache/superset/issues/479)) ([66fea8c](https://github.com/apache/superset/commit/66fea8c66b0c89a5f0ce1ba5ab42ed0d578eed08))
- **legacy-plugin-chart-nvd3:** add control panels ([#469](https://github.com/apache/superset/issues/469)) ([8281ac9](https://github.com/apache/superset/commit/8281ac92fa155aff1bda66674ee78e47c8fa5bd4))
- **legacy-plugin-chart-parallel-coordinates:** add control panels ([#510](https://github.com/apache/superset/issues/510)) ([27bc742](https://github.com/apache/superset/commit/27bc742547ee889625795643af006a65f75cbf4c))
- **legacy-plugin-chart-partition:** add control panel ([#470](https://github.com/apache/superset/issues/470)) ([8f5fb6a](https://github.com/apache/superset/commit/8f5fb6a6042ee598128cc37208b4fa4a1fb4aab9))
- **legacy-plugin-chart-pivot-table:** add support for timestamp format ([#734](https://github.com/apache/superset/issues/734)) ([baf2b68](https://github.com/apache/superset/commit/baf2b68356519c7f6b8ad7224e53bbd73bc72796))
- **legacy-plugin-chart-rose:** add time grain ([#696](https://github.com/apache/superset/issues/696)) ([79c4f3f](https://github.com/apache/superset/commit/79c4f3f2ab9496a2bb1bc09e18dbe915221ff7d7))
- **legacy-plugin-chart-sankey:** allow sort by metric ([#831](https://github.com/apache/superset/issues/831)) ([5f5e275](https://github.com/apache/superset/commit/5f5e27527990335acf8a6c6084e54bea7408bdd6))
- **legacy-plugin-chart-sunburst:** add linear color scheme ([#714](https://github.com/apache/superset/issues/714)) ([5908582](https://github.com/apache/superset/commit/5908582d00a056e62f78868a8cbf40fefff6af42))
- **legacy-preset-big-number:** use emotion styling ([#455](https://github.com/apache/superset/issues/455)) ([b6931fb](https://github.com/apache/superset/commit/b6931fbcd6b662b0bacd3c380eb2ecb0aa5996ab))
- **legacy-preset-chart-big-number:** add timestamp above number ([#1278](https://github.com/apache/superset/issues/1278)) ([c4bc66a](https://github.com/apache/superset/commit/c4bc66a1bf40fa3c8a9c9cccd43d49508c1d7a35))
- **legacy-preset-chart-deckgl:** Add ,.1f and ,.2f value formats to deckgl charts ([#18945](https://github.com/apache/superset/issues/18945)) ([c56dc8e](https://github.com/apache/superset/commit/c56dc8eace6a71b45240d1bb6768d75661052a2e))
- **legacy-preset-chart-nvd3:** add a new label type to pie chart ([#699](https://github.com/apache/superset/issues/699)) ([d9a2808](https://github.com/apache/superset/commit/d9a2808fe31b2f55bea9d01204371f9aca43384e))
- **legacy-preset-chart-nvd3:** add richtooltip in nvd3 bar chart ([#17615](https://github.com/apache/superset/issues/17615)) ([72f3215](https://github.com/apache/superset/commit/72f3215ffc74ead33dba57196aeaf4e1db63fd6c))
- **legacy-preset-chart-nvd3:** show negative values on bars ([#8](https://github.com/apache/superset/issues/8)) ([53ab714](https://github.com/apache/superset/commit/53ab7147cf7dfdf59323eaad45ebae0a91cd3274))
- **legacy-preset-chart-nvd3:** subject Add legend option to nvd3 chart ([#904](https://github.com/apache/superset/issues/904)) ([d02f17c](https://github.com/apache/superset/commit/d02f17c098e69af00e13aa144909ecb7c9e61356))
- **legacy-preset-chart-nvd3:** subject Add Y bounds for nvd3 charts ([#908](https://github.com/apache/superset/issues/908)) ([d58984a](https://github.com/apache/superset/commit/d58984aeb60257845f17e851bf782985ee8c0240))
- **legacy-preset-chart-nvd3:** subject NVD3 Bar chart sort by ([#947](https://github.com/apache/superset/issues/947)) ([afa98bf](https://github.com/apache/superset/commit/afa98bf41e1eb5a8495ccf18779b0c1eef689cff))
- **legacy-table-chart:** add query mode switch ([#609](https://github.com/apache/superset/issues/609)) ([aade5ef](https://github.com/apache/superset/commit/aade5ef42c1a8e0896bcb4c1aa5f60bb411f83c7))
- **legacy-time-table:** add time table to storybook ([#680](https://github.com/apache/superset/issues/680)) ([4b6aa11](https://github.com/apache/superset/commit/4b6aa112ba6ebb9bc08420a1aff43a5b38e72581))
- line chart with revised encodeable utilities ([#26](https://github.com/apache/superset/issues/26)) ([049b40b](https://github.com/apache/superset/commit/049b40bc80e71728227177d7a97589db3058e015))
- linear imputation in Resample ([#19393](https://github.com/apache/superset/issues/19393)) ([a39dd44](https://github.com/apache/superset/commit/a39dd4493e8b40cc142451bc71e4d1d4f2705d3f))
- **linting:** restrict direct use of supersetTheme in favor of ThemeProvider ([#17001](https://github.com/apache/superset/issues/17001)) ([5f73ca8](https://github.com/apache/superset/commit/5f73ca85d5c7b0ba34eae251addbc77fd7bdec61))
- log decorator util - adding automatic logs out of the box ([#18620](https://github.com/apache/superset/issues/18620)) ([41f3c95](https://github.com/apache/superset/commit/41f3c9534518f032ab71522d33508b923eeae1d7))
- logger supports console.table, with console.log fallback ([#738](https://github.com/apache/superset/issues/738)) ([86eedab](https://github.com/apache/superset/commit/86eedab4d0d33bfa6ee37db3cd72dfec28f28208))
- make all deckgl charts handle their own tooltips ([#13](https://github.com/apache/superset/issues/13)) ([8fbeba1](https://github.com/apache/superset/commit/8fbeba101c9563c3c209f881e1cdf3bfb3af3e89))
- make CategoricalScale compatible with D3 ScaleOrdinal ([#357](https://github.com/apache/superset/issues/357)) ([735e8b2](https://github.com/apache/superset/commit/735e8b2dd60ec9ee0f74c857485faea8fee585d4))
- make CTA text in Alerts & Reports mails configurable ([#19779](https://github.com/apache/superset/issues/19779)) ([0b22287](https://github.com/apache/superset/commit/0b22287ad9f3908ce62f51e2a17de8975beafed2))
- Make filters and dividers display horizontally in horizontal native filters filter bar ([#22169](https://github.com/apache/superset/issues/22169)) ([64939f2](https://github.com/apache/superset/commit/64939f2872a16b708d315693f9f9810604788aff))
- make formatTime and formatNumber handle undefined format ([#307](https://github.com/apache/superset/issues/307)) ([83a1901](https://github.com/apache/superset/commit/83a1901a355d8150f9e84e7c8cc66a339993b35d))
- make GET request work for fetchExploreJson, closes [#668](https://github.com/apache/superset/issues/668) ([#777](https://github.com/apache/superset/issues/777)) ([6ac6880](https://github.com/apache/superset/commit/6ac6880fd9532d361d221925c6bd45d25f6e14b9))
- Make Jinja template applied in timestamp columns ([#17237](https://github.com/apache/superset/issues/17237)) ([5aaa333](https://github.com/apache/superset/commit/5aaa3330a66c90047da3dcc557970cf9383d4933))
- make polygon support geojson feature and fix autozoom ([#11](https://github.com/apache/superset/issues/11)) ([940e449](https://github.com/apache/superset/commit/940e449bbe8fff732dd14f8ac86d8e535da0123a))
- make time formatter handle number and fix formatters type warnings ([#358](https://github.com/apache/superset/issues/358)) ([aa84115](https://github.com/apache/superset/commit/aa84115ca48edf45f1a6bffb29d5c09268d5d133))
- Making bar graphs in Table viz from fixed-size divs instead of calculated gradients ([#21482](https://github.com/apache/superset/issues/21482)) ([135909f](https://github.com/apache/superset/commit/135909f814e989c2314ddbb5da90e5364cd36d17))
- **metrics:** Provide override for disabling ad-hoc metrics ([#17202](https://github.com/apache/superset/issues/17202)) ([561d1ac](https://github.com/apache/superset/commit/561d1ac9f2f3861619e319cf69befb57d6559485))
- migrate chart plugins ([#375](https://github.com/apache/superset/issues/375)) ([81ca3b9](https://github.com/apache/superset/commit/81ca3b980188f14f08c9eea7b16dbaccc7b11095))
- migrate heatmap, horizon, iframe and markup ([#367](https://github.com/apache/superset/issues/367)) ([12bf14b](https://github.com/apache/superset/commit/12bf14b7cd1ae5321ffed724867a4233197dd44c))
- migrate legacy-plugin-chart-chord ([#365](https://github.com/apache/superset/issues/365)) ([d36b36e](https://github.com/apache/superset/commit/d36b36ecfc280f8650734e22c0847c5b05623b51))
- migrate xy-chart to use encodable ([#438](https://github.com/apache/superset/issues/438)) ([493df5c](https://github.com/apache/superset/commit/493df5c8088ad5f863427c757b9d6437d98266b9)), closes [#420](https://github.com/apache/superset/issues/420) [#421](https://github.com/apache/superset/issues/421) [#427](https://github.com/apache/superset/issues/427) [#430](https://github.com/apache/superset/issues/430) [#432](https://github.com/apache/superset/issues/432) [#433](https://github.com/apache/superset/issues/433) [#436](https://github.com/apache/superset/issues/436)
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- Move Database Import option into DB Connection modal ([#19314](https://github.com/apache/superset/issues/19314)) ([d52e386](https://github.com/apache/superset/commit/d52e3867acbcb1d31d1e7f6c1215123f91f9f313))
- multiple results pane on explore and dashboard ([#20277](https://github.com/apache/superset/issues/20277)) ([fd12987](https://github.com/apache/superset/commit/fd129873ceeb74dc2e59d9b94ed1c9d006f1386c))
- native filter components ([#840](https://github.com/apache/superset/issues/840)) ([a52cd69](https://github.com/apache/superset/commit/a52cd691f0404169c5e687f4181c0de93c5987a7))
- **native_filter_migration:** add transition mode ([#16992](https://github.com/apache/superset/issues/16992)) ([7d22c9c](https://github.com/apache/superset/commit/7d22c9ce170d0bd6ad31c680d007881b61dd378f))
- **native-filters:** add AppSection type ([#1038](https://github.com/apache/superset/issues/1038)) ([05bd319](https://github.com/apache/superset/commit/05bd319e2773fcf703216234899b3a610f4d1abd))
- **native-filters:** Adjust filter components for horizontal mode ([#22273](https://github.com/apache/superset/issues/22273)) ([eb6045a](https://github.com/apache/superset/commit/eb6045adfa77e06c8aaf3de217719ca59d4328e1))
- **native-filters:** Don't scroll main window when scrolling filter bar ([#18876](https://github.com/apache/superset/issues/18876)) ([e5c7478](https://github.com/apache/superset/commit/e5c74780268c78355e21bc0f7af0069a59bed41e))
- **native-filters:** Implement filter cards ([#18874](https://github.com/apache/superset/issues/18874)) ([0922c3f](https://github.com/apache/superset/commit/0922c3ff2dd79e68e633ea5fe1c17fa16307fd8a))
- **native-filters:** Re-arrange controls in FilterBar ([#18784](https://github.com/apache/superset/issues/18784)) ([9d5c050](https://github.com/apache/superset/commit/9d5c0505cf9bf67be499abd4829195adf6ad17d5))
- **nav:** Update Tabbed Nav on CRUD Pages ([#21213](https://github.com/apache/superset/issues/21213)) ([fb835d1](https://github.com/apache/superset/commit/fb835d143705a94ca229c651a4c7f7dbc1675ed2))
- new config to filter specific users from dropdown lists ([#21515](https://github.com/apache/superset/issues/21515)) ([ab7cfec](https://github.com/apache/superset/commit/ab7cfec975b3f06eb386e14532d42bc6a02a0687))
- new dataset/table/column models ([#17543](https://github.com/apache/superset/issues/17543)) ([00c99c9](https://github.com/apache/superset/commit/00c99c91ec302a13978c5fd3a1099d6f4648a20e))
- New time range label ([#22317](https://github.com/apache/superset/issues/22317)) ([2d30e9c](https://github.com/apache/superset/commit/2d30e9cbe9e22fe5e09ca9f06e68c8563d9c741a))
- Normalize orderby clause ([#1206](https://github.com/apache/superset/issues/1206)) ([e96428e](https://github.com/apache/superset/commit/e96428e6c8fce496e3e601dfe05498e6b42ae464))
- **number-format:** bump pretty-ms to 5.1.0 ([#262](https://github.com/apache/superset/issues/262)) ([7212d12](https://github.com/apache/superset/commit/7212d1240b038ad3c2b3065a77ce6d9de9ffe009))
- On window focus, redirect to login if the user has been logged out ([#18773](https://github.com/apache/superset/issues/18773)) ([da3bc48](https://github.com/apache/superset/commit/da3bc48803e2653be127f948e259a762fa0f9718))
- only show active user for chart/dashboard/datasource owner drop… ([#20837](https://github.com/apache/superset/issues/20837)) ([9be4870](https://github.com/apache/superset/commit/9be4870c7f855f086671f281875d165fe27d8d13))
- optimize functions for getting text dimension ([#199](https://github.com/apache/superset/issues/199)) ([77e7a53](https://github.com/apache/superset/commit/77e7a5319ac59b55083d6d1498ede1f96ec215a2))
- Pass dashboard context to explore through local storage ([#20743](https://github.com/apache/superset/issues/20743)) ([0945d4a](https://github.com/apache/superset/commit/0945d4a2f46667aebb9b93d0d7685215627ad237))
- per-db add metrics ([#20990](https://github.com/apache/superset/issues/20990)) ([bb3871d](https://github.com/apache/superset/commit/bb3871ddaf8835c67d9cb498a2ca99a9a48a1ec3))
- Persist SQL Lab autocomplete setting across tabs and visits ([#17708](https://github.com/apache/superset/issues/17708)) ([5b0aa27](https://github.com/apache/superset/commit/5b0aa27f2bb3e9570241500132b9e09f9dd1f5a3))
- **plugin-chart-boxplot:** add control panel ([#464](https://github.com/apache/superset/issues/464)) ([dc3f219](https://github.com/apache/superset/commit/dc3f2198484b44877687ecd2083c2c0ab096090d))
- **plugin-chart-choropleth-map:** add package ([#560](https://github.com/apache/superset/issues/560)) ([72c2b7a](https://github.com/apache/superset/commit/72c2b7afc06810813ee4e179aabe4db8e78b4cdb)), closes [#527](https://github.com/apache/superset/issues/527) [#529](https://github.com/apache/superset/issues/529) [#528](https://github.com/apache/superset/issues/528) [#541](https://github.com/apache/superset/issues/541) [#548](https://github.com/apache/superset/issues/548)
- **plugin-chart-echart:** New Tree chart ([#1018](https://github.com/apache/superset/issues/1018)) ([d1312ab](https://github.com/apache/superset/commit/d1312ab2a8d6c09579aa5302962527af1d84521f))
- **plugin-chart-echarts:** [feature-parity] support double clicking legend and series to view single selected series ([#1324](https://github.com/apache/superset/issues/1324)) ([ff8979b](https://github.com/apache/superset/commit/ff8979b46e5a2c59baa367a67b8c79406274f9f0))
- **plugin-chart-echarts:** [feature-parity] support extra control for the area chart V2 ([#16493](https://github.com/apache/superset/issues/16493)) ([eab0009](https://github.com/apache/superset/commit/eab0009101a295acf4d8d31df8a57f8fe0deb517))
- **plugin-chart-echarts:** able to sort bar on the bar chart V2 ([#21356](https://github.com/apache/superset/issues/21356)) ([59437ea](https://github.com/apache/superset/commit/59437ea6e7ec02267c6e03e174be39a6cae48893))
- **plugin-chart-echarts:** add aggregate total for the Pie/Donuct chart ([#19622](https://github.com/apache/superset/issues/19622)) ([a6bf041](https://github.com/apache/superset/commit/a6bf041eddcde0247461f35c806414df00ef105e))
- **plugin-chart-echarts:** add BoxPlot chart ([#801](https://github.com/apache/superset/issues/801)) ([88acb6b](https://github.com/apache/superset/commit/88acb6ba9d6e8ef948d90d97f514047599cf3735))
- **plugin-chart-echarts:** Add cross filter for timeseries ([#1016](https://github.com/apache/superset/issues/1016)) ([9fdc8c3](https://github.com/apache/superset/commit/9fdc8c3f6e73e0becdbcb42b12c19735b7a06ad2))
- **plugin-chart-echarts:** add graph echart ([#918](https://github.com/apache/superset/issues/918)) ([d47f6ce](https://github.com/apache/superset/commit/d47f6ceeae906fefe9db6d53105f121cb4e534d4))
- **plugin-chart-echarts:** add label date format for piechart and boxplot ([#973](https://github.com/apache/superset/issues/973)) ([1c40ac5](https://github.com/apache/superset/commit/1c40ac56c7d3031f82bcc0cc97a0ec9fb9992c99))
- **plugin-chart-echarts:** add legend customization options ([#833](https://github.com/apache/superset/issues/833)) ([54948a0](https://github.com/apache/superset/commit/54948a091d95e30c2193207f30bce5e03f985ece))
- **plugin-chart-echarts:** add mixed timeseries chart ([#1027](https://github.com/apache/superset/issues/1027)) ([7670a90](https://github.com/apache/superset/commit/7670a90836429394163e5d7da56f28fe8ed07642))
- **plugin-chart-echarts:** add more robust formatting for series ([#783](https://github.com/apache/superset/issues/783)) ([66e681c](https://github.com/apache/superset/commit/66e681cbab57ef41ca90639caa14530ac9396453))
- **plugin-chart-echarts:** add only_total control to ts chart ([#1313](https://github.com/apache/superset/issues/1313)) ([471f245](https://github.com/apache/superset/commit/471f2451819564537f20d472031fdfcebe92e549))
- **plugin-chart-echarts:** add orderby on Radar chart ([#1112](https://github.com/apache/superset/issues/1112)) ([32ebeff](https://github.com/apache/superset/commit/32ebeff93b3c998b45a7469f846361ffe5fea6bd))
- **plugin-chart-echarts:** add support for custom forecasts ([#1389](https://github.com/apache/superset/issues/1389)) ([f1613fd](https://github.com/apache/superset/commit/f1613fd17e2115c45c494b1cb237de53bfccb2d3))
- **plugin-chart-echarts:** add support for formula annotations ([#817](https://github.com/apache/superset/issues/817)) ([06ef549](https://github.com/apache/superset/commit/06ef5491223bb531afe736756a864aba7aad23f6))
- **plugin-chart-echarts:** add support for generic axis to mixed chart ([#20097](https://github.com/apache/superset/issues/20097)) ([d5c5e58](https://github.com/apache/superset/commit/d5c5e58583771a35d8870ce3694b2a3f1b688159))
- **plugin-chart-echarts:** Add support for series values to ECharts timeseries charts ([#1279](https://github.com/apache/superset/issues/1279)) ([f68d465](https://github.com/apache/superset/commit/f68d46525970975de76e69c8f5a740adf631335c))
- **plugin-chart-echarts:** add x and y label support for 9 charts ([#1351](https://github.com/apache/superset/issues/1351)) ([e149c53](https://github.com/apache/superset/commit/e149c537ee0c547dc3a8fa6a3b14222ee81d8c77)), closes [#16512](https://github.com/apache/superset/issues/16512)
- **plugin-chart-echarts:** add x-filtering in gauge chart ([#1203](https://github.com/apache/superset/issues/1203)) ([4333a68](https://github.com/apache/superset/commit/4333a683f0eb9b62c4025c88e3fede16655d186a))
- **plugin-chart-echarts:** add x-filtering to treemap ([#1115](https://github.com/apache/superset/issues/1115)) ([3d3c873](https://github.com/apache/superset/commit/3d3c873f3cfee2def4db08af55087b4c5d2df16e))
- **plugin-chart-echarts:** Add xAxis label format && showMin and showMax labels ([#894](https://github.com/apache/superset/issues/894)) ([bee49e7](https://github.com/apache/superset/commit/bee49e7d4bdaa5b6973883b7428b3a6ec352fc80))
- **plugin-chart-echarts:** arrange legend and zoom ([#920](https://github.com/apache/superset/issues/920)) ([d142881](https://github.com/apache/superset/commit/d142881fc99b171900d4bd4fee7fe1f53393bddc))
- **plugin-chart-echarts:** bump to version 5.0 ([#852](https://github.com/apache/superset/issues/852)) ([8c4c4ef](https://github.com/apache/superset/commit/8c4c4ef0206eac06a3c9d9b2a17e88723c186937)), closes [#11854](https://github.com/apache/superset/issues/11854)
- **plugin-chart-echarts:** create separate entry points for timeseries (2nd) ([#1262](https://github.com/apache/superset/issues/1262)) ([7441009](https://github.com/apache/superset/commit/74410090986867b9e3e895954725d24783fdfd84))
- **plugin-chart-echarts:** crossfilter with single selection in the funnel chart ([#1211](https://github.com/apache/superset/issues/1211)) ([178986a](https://github.com/apache/superset/commit/178986a5fa85ccec1a21803df6339747736f8651))
- **plugin-chart-echarts:** echarts funnel chart ([#1006](https://github.com/apache/superset/issues/1006)) ([639c8ba](https://github.com/apache/superset/commit/639c8bac7425f962c9b2eb5176e0ddf771541d6a))
- **plugin-chart-echarts:** Echarts Treemap ([#1094](https://github.com/apache/superset/issues/1094)) ([012e5dc](https://github.com/apache/superset/commit/012e5dcbc0b536e66537ee5dd0982262ad4cdea3))
- **plugin-chart-echarts:** Emit cross filters for pie and boxplot ([#1010](https://github.com/apache/superset/issues/1010)) ([acd23f3](https://github.com/apache/superset/commit/acd23f3ba36cebc8785bddd66218979d39d39c6e))
- **plugin-chart-echarts:** Enhancements of treemap tooltip ([#1103](https://github.com/apache/superset/issues/1103)) ([2fa01f7](https://github.com/apache/superset/commit/2fa01f7975455bada71845b29002e3769c028134))
- **plugin-chart-echarts:** hide/show dependent controls ([#1097](https://github.com/apache/superset/issues/1097)) ([902fcf4](https://github.com/apache/superset/commit/902fcf42ce73db53fb4af287144318e2b4b5b6be))
- **plugin-chart-echarts:** implement cross filter in mixd-timeseries chart ([#1256](https://github.com/apache/superset/issues/1256)) ([e54ae04](https://github.com/apache/superset/commit/e54ae04906f16d4d1b1c4c995713ae07383b3c50))
- **plugin-chart-echarts:** implement event interval and timeseries annotations ([#828](https://github.com/apache/superset/issues/828)) ([8bfaf4e](https://github.com/apache/superset/commit/8bfaf4eb0ecaad0cd83132132b1ef41b4299b791))
- **plugin-chart-echarts:** implement x-filter opacity in ts chart ([#1244](https://github.com/apache/superset/issues/1244)) ([5bff9a4](https://github.com/apache/superset/commit/5bff9a4dd0c55c9f35741f50041412ad7698622d))
- **plugin-chart-echarts:** make groupby optional ([#820](https://github.com/apache/superset/issues/820)) ([387c863](https://github.com/apache/superset/commit/387c863682337a0fa4be7c499e9b0b6a952e3b59))
- **plugin-chart-echarts:** Radar chart POC ([#1029](https://github.com/apache/superset/issues/1029)) ([18b1ef0](https://github.com/apache/superset/commit/18b1ef008daafdd559a4b624ebd63cb3c4a91165))
- **plugin-chart-echarts:** remove loading from timeseries tooltip ([#787](https://github.com/apache/superset/issues/787)) ([e918c04](https://github.com/apache/superset/commit/e918c04090bcd97ce1068d86ddcafba05da6cf4f))
- **plugin-chart-echarts:** rich tooltip in ts chart supports scroll and highlighted ([#1304](https://github.com/apache/superset/issues/1304)) ([10238c3](https://github.com/apache/superset/commit/10238c38057d87849bf01c6e19c8c576beab5d9d))
- **plugin-chart-echarts:** single select by default for pie chart ([#1204](https://github.com/apache/superset/issues/1204)) ([4c6017e](https://github.com/apache/superset/commit/4c6017eaa4506a20d28f3c5103fc6768c182296a))
- **plugin-chart-echarts:** sort by metric checkbox check by default ([#1111](https://github.com/apache/superset/issues/1111)) ([f73b9a4](https://github.com/apache/superset/commit/f73b9a4cf83e95772c84188439c534629c57925c))
- **plugin-chart-echarts:** subject Add option to rotate label defaul 45 ([#921](https://github.com/apache/superset/issues/921)) ([df47d95](https://github.com/apache/superset/commit/df47d95f5ec2fd45dadff2bb60a3b6aff88dc27f))
- **plugin-chart-echarts:** subject Add rich tooltip ([#906](https://github.com/apache/superset/issues/906)) ([3f9a5d2](https://github.com/apache/superset/commit/3f9a5d26c26f253bcd8b3297afeba93334eb599c))
- **plugin-chart-echarts:** subject add sort by metric for Pie Chart ([#946](https://github.com/apache/superset/issues/946)) ([ab2e6f3](https://github.com/apache/superset/commit/ab2e6f31a5f6ad3feb95e89fee9bcdfd48ea3636))
- **plugin-chart-echarts:** subject Add time formatter on the tooltip title ([#912](https://github.com/apache/superset/issues/912)) ([2345e34](https://github.com/apache/superset/commit/2345e342cba46d273107f59e2290c10f852e2a53))
- **plugin-chart-echarts:** subject fix tooltip format title ([#956](https://github.com/apache/superset/issues/956)) ([f11f2eb](https://github.com/apache/superset/commit/f11f2eb4867f688ef9771002ffd1812d4062f02c))
- **plugin-chart-echarts:** subject Update echarts to v5.0.1 ([#928](https://github.com/apache/superset/issues/928)) ([d3d343d](https://github.com/apache/superset/commit/d3d343d6c48b4d3de61d21bf784e8c424f006c01))
- **plugin-chart-echarts:** support always show annotation label ([#1449](https://github.com/apache/superset/issues/1449)) ([259ff67](https://github.com/apache/superset/commit/259ff67ef78b56eb3403ee19559868ce2d8712b7))
- **plugin-chart-echarts:** support horizontal bar chart ([#19918](https://github.com/apache/superset/issues/19918)) ([9854d2d](https://github.com/apache/superset/commit/9854d2d0e8f849366b264353819c6fdf4b0d804d))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- **plugin-chart-echarts:** Support stacking negative and positive values ([#20408](https://github.com/apache/superset/issues/20408)) ([c959d92](https://github.com/apache/superset/commit/c959d92dd17499e3fb7a0f4f02f3781516f3d3e6))
- **plugin-chart-echarts:** supports sunburst chart v2 [WIP] ([#21625](https://github.com/apache/superset/issues/21625)) ([b53941f](https://github.com/apache/superset/commit/b53941fb3eef7ab3936a0a3f16e22c921d946f53))
- **plugin-chart-echarts:** Treemap improvements ([#1125](https://github.com/apache/superset/issues/1125)) ([78c915c](https://github.com/apache/superset/commit/78c915c46441ba2027895d31115bed5484e1c823))
- **plugin-chart-echarts:** x-filtering improvement in radar chart ([#1205](https://github.com/apache/superset/issues/1205)) ([6d52c44](https://github.com/apache/superset/commit/6d52c44ab7438c674a982d7140b861d164a61fd9))
- **plugin-chart-graph:** add node/edge size and edge symbol control ([#1084](https://github.com/apache/superset/issues/1084)) ([8531910](https://github.com/apache/superset/commit/85319109a5a40de5b61978f5d1fd78c798b74137))
- **plugin-chart-pivot-table:** add automatic conditional formatter ([#1264](https://github.com/apache/superset/issues/1264)) ([a109dc2](https://github.com/apache/superset/commit/a109dc2313820c366adddf8fe275d69805511e48))
- **plugin-chart-pivot-table:** add sort by result to data pane ([#1243](https://github.com/apache/superset/issues/1243)) ([5a235ca](https://github.com/apache/superset/commit/5a235ca676aa2ade461975b6c2a19c984b635d1d))
- **plugin-chart-pivot-table:** column, date and conditional formatting ([#1217](https://github.com/apache/superset/issues/1217)) ([fe5f9b0](https://github.com/apache/superset/commit/fe5f9b093e1bddba0366501c19ff49f0b817d1f5))
- **plugin-chart-pivot-table:** enable cross filtering ([#1083](https://github.com/apache/superset/issues/1083)) ([139a067](https://github.com/apache/superset/commit/139a067c66e19afc9f56f465071ad30155f3ef61))
- **plugin-chart-pivot-table:** enable metrics to be used as row groups ([#1172](https://github.com/apache/superset/issues/1172)) ([cb5e908](https://github.com/apache/superset/commit/cb5e9084aae84b1289944e7d2e460812733fbb43))
- **plugin-chart-pivot-table:** implement barchart highlight ([#1089](https://github.com/apache/superset/issues/1089)) ([bce9e39](https://github.com/apache/superset/commit/bce9e39f814824328a3490a2f6ffb5b5efdf2474))
- **plugin-chart-pivot-table:** multiple improvements ([#1232](https://github.com/apache/superset/issues/1232)) ([0433df8](https://github.com/apache/superset/commit/0433df8e423b68e47e2e772d8b4226abe2592d4f))
- **plugin-chart-pivot-table:** sort by metric ([#1240](https://github.com/apache/superset/issues/1240)) ([8d54c69](https://github.com/apache/superset/commit/8d54c69e57dc8877da522318372e327d60010974))
- **plugin-chart-pivot-table:** support series limit ([#17803](https://github.com/apache/superset/issues/17803)) ([2c3f39f](https://github.com/apache/superset/commit/2c3f39f3f2a4369bf03403c452d124c24c521e7d))
- **plugin-chart-sunburst:** migrate control panel from incubator-superset ([#443](https://github.com/apache/superset/issues/443)) ([9d946f0](https://github.com/apache/superset/commit/9d946f0a04ad3eb64c99d1e0c988f38b53182ad0))
- **plugin-chart-table:** add column config control ([#1019](https://github.com/apache/superset/issues/1019)) ([a101117](https://github.com/apache/superset/commit/a101117f9e78527e90e73ed7dd5d419de3107961))
- **plugin-chart-table:** add small number formatter ([#1028](https://github.com/apache/superset/issues/1028)) ([090e3b1](https://github.com/apache/superset/commit/090e3b1e914af8c654069dcb2d4c302c89e2ae0f))
- **plugin-chart-table:** add support for temporal x-filter ([#1281](https://github.com/apache/superset/issues/1281)) ([7040050](https://github.com/apache/superset/commit/7040050cec865d5bea927f55f69e3bdafcbf67f6))
- **plugin-chart-table:** add tooltip about multiple sort ([#958](https://github.com/apache/superset/issues/958)) ([b5627c7](https://github.com/apache/superset/commit/b5627c73ea262653d97aa92ac51a4e25f6ca5910))
- **plugin-chart-table:** added emit target name ([#1157](https://github.com/apache/superset/issues/1157)) ([094f35f](https://github.com/apache/superset/commit/094f35fa0b4f3ef590e35dacad5bf634d594749a))
- **plugin-chart-table:** disable show_totals by default ([#1078](https://github.com/apache/superset/issues/1078)) ([08a0d0a](https://github.com/apache/superset/commit/08a0d0a324cad6ee9931d7a5ed6964d162b176b2))
- **plugin-chart-table:** enable emitting cross-filters ([#1041](https://github.com/apache/superset/issues/1041)) ([fcd11cd](https://github.com/apache/superset/commit/fcd11cde42b4c30be1f9cee2e3130675bfc80408))
- **plugin-chart-table:** implement conditional formatting ([#1218](https://github.com/apache/superset/issues/1218)) ([18e5ab2](https://github.com/apache/superset/commit/18e5ab2ccbf7283182486c1a27477906309d781e))
- **plugin-chart-table:** Implement showing totals ([#1034](https://github.com/apache/superset/issues/1034)) ([f4eeebf](https://github.com/apache/superset/commit/f4eeebf368c21ca88a5369394341014ccc9befb9))
- **plugin-chart-table:** rewrite with react-table ([#623](https://github.com/apache/superset/issues/623)) ([92ac471](https://github.com/apache/superset/commit/92ac4712163497482b3d4f1546a8061d9e78ff1d))
- **plugin-chart-table:** table x-filtering supports single select ([#1220](https://github.com/apache/superset/issues/1220)) ([631c867](https://github.com/apache/superset/commit/631c867c467f6cdcb350cf4e7d1caf2f4566ba80))
- **plugin-chart-treemap:** add control panel ([#461](https://github.com/apache/superset/issues/461)) ([07dc493](https://github.com/apache/superset/commit/07dc49366b27497ae7b94837d4a49512ebb61933))
- **plugin-chart-word-cloud:** add control panel ([#454](https://github.com/apache/superset/issues/454)) ([49f4044](https://github.com/apache/superset/commit/49f4044cbe93c2db855a176739d35630d6ede77a))
- **plugin-chart-word-cloud:** allow minimum size ([#487](https://github.com/apache/superset/issues/487)) ([3364f0f](https://github.com/apache/superset/commit/3364f0f6da9d4d832bda97d88216793b7998a732))
- **plugin-chart-word-cloud:** convert word cloud to use encodable ([#258](https://github.com/apache/superset/issues/258)) ([b6e3fdf](https://github.com/apache/superset/commit/b6e3fdffa649fbce48fc01e8bf98c6605524cc0d))
- **plugin-chart-word-cloud:** subject Add order by desc on metric ([#939](https://github.com/apache/superset/issues/939)) ([bf2a80c](https://github.com/apache/superset/commit/bf2a80ca7b884840c0870814738dc21762bfa1bc))
- **plugin-chart-world-map:** add control panel ([#462](https://github.com/apache/superset/issues/462)) ([3102d93](https://github.com/apache/superset/commit/3102d932834e55fc982e6643e85c80f9be4e66c2))
- **plugin-word-cloud:** change how wordcloud is exported ([#418](https://github.com/apache/superset/issues/418)) ([91d00ac](https://github.com/apache/superset/commit/91d00ac8b11298f759e12bf916723d04b91ce23c))
- **preset-chart-nvd3:** migration from plugins repo ([#399](https://github.com/apache/superset/issues/399)) ([587e6e1](https://github.com/apache/superset/commit/587e6e1a7739165b146ed84e8cf295f953be4c58))
- **preset-chart-xy:** migrate from plugins repo ([#377](https://github.com/apache/superset/issues/377)) ([afed1a0](https://github.com/apache/superset/commit/afed1a0818b56fe96c276c75d3dfbdf61e5644ee))
- print comment for chromatic storybook link ([#21170](https://github.com/apache/superset/issues/21170)) ([cda7d70](https://github.com/apache/superset/commit/cda7d705650fd36b7051c1002ab8f152017c9a70))
- Programmatically open "more filters" dropdown in Horizontal Filter Bar ([#22276](https://github.com/apache/superset/issues/22276)) ([df91664](https://github.com/apache/superset/commit/df91664217b5369d1f742ce03596a366e18cd4b9))
- properly translate the table chart ([#724](https://github.com/apache/superset/issues/724)) ([6def6b4](https://github.com/apache/superset/commit/6def6b4c0b01fafdc8c17156ba2ca7c566dbbe88))
- **prophet:** enable confidence intervals and y_hat without forecast ([#17658](https://github.com/apache/superset/issues/17658)) ([cd88b8e](https://github.com/apache/superset/commit/cd88b8e81ea3721f93d0cfdd0329f380a2c3d061))
- query datasets from SQL Lab ([#15241](https://github.com/apache/superset/issues/15241)) ([05a138a](https://github.com/apache/superset/commit/05a138a191cb0e22cf7b6b9cce6fa985843d1809))
- **query:** add `makeApi` API generator ([#666](https://github.com/apache/superset/issues/666)) ([18dfdd2](https://github.com/apache/superset/commit/18dfdd2a5a71c779d7488b815bf9102df6867037))
- **query:** Add force to QueryContext ([#445](https://github.com/apache/superset/issues/445)) ([4322d1c](https://github.com/apache/superset/commit/4322d1cd398e5f69e9ad0b43cf78804aeec41cd9))
- **query:** add functions to wrap api calls with typings ([#555](https://github.com/apache/superset/issues/555)) ([9a53bdf](https://github.com/apache/superset/commit/9a53bdfb681bdab00023df868a9944f1603acc1e))
- **query:** add more query wrappers ([#570](https://github.com/apache/superset/issues/570)) ([d277421](https://github.com/apache/superset/commit/d2774211240e547f1a08f693843dd5d75840fb5f))
- **query:** add new fields to QueryContext and QueryObject ([#583](https://github.com/apache/superset/issues/583)) ([9955156](https://github.com/apache/superset/commit/9955156265fca962fe79822e7443b701d70daa5a))
- **query:** remove redundant metric label truncation ([#492](https://github.com/apache/superset/issues/492)) ([dfb5ac4](https://github.com/apache/superset/commit/dfb5ac42ddec9c5d5d544f7c6797207ff7171d8a))
- **rbac:** add customizable related filters ([#22526](https://github.com/apache/superset/issues/22526)) ([037deb9](https://github.com/apache/superset/commit/037deb9a1d0170a7c10f9f47aad9474050fca31f))
- re-export types from @superset-ui/dimension ([#115](https://github.com/apache/superset/issues/115)) ([a98cde6](https://github.com/apache/superset/commit/a98cde6b3e6ddec97cdc06baa9513f892b053a42))
- refactor all `get_sqla_engine` to use contextmanager in codebase ([#21943](https://github.com/apache/superset/issues/21943)) ([e23efef](https://github.com/apache/superset/commit/e23efefc462fcc6f76a456f52f57f81e0c241a0a))
- remove children from XYChartLayout parameter ([28ef524](https://github.com/apache/superset/commit/28ef524596dd2b99c626c92eaec7947021e19248))
- Remove legacy sql alchemy db connection link from G Sheet connection ([#19450](https://github.com/apache/superset/issues/19450)) ([9407598](https://github.com/apache/superset/commit/94075983f8abfcc7749cede5af9e24d2a9f1abe0))
- remove loading indicator when typing in select ([#18799](https://github.com/apache/superset/issues/18799)) ([5a8eb09](https://github.com/apache/superset/commit/5a8eb09afba377375c1f92b9eec180d0e503edf2))
- remove the default Y-axis truncate in bar chart ([#1450](https://github.com/apache/superset/issues/1450)) ([4359ed0](https://github.com/apache/superset/commit/4359ed0e727057ea0ec039941406599d0c7ead33))
- **remove unused package:** remove corejs and other unused package ([7522f28](https://github.com/apache/superset/commit/7522f28ece0e481a3039dff6a3a6d684b0463313))
- Renders Explore in SPA ([#20572](https://github.com/apache/superset/issues/20572)) ([662bab1](https://github.com/apache/superset/commit/662bab1e6d1b502a77a117f8ab7e82d3029151c0))
- **report:** capture dashboard reports in specific states ([#20552](https://github.com/apache/superset/issues/20552)) ([4d192e6](https://github.com/apache/superset/commit/4d192e6e4d74157c1eb8fed63df7ddaee4c8ecf7))
- **reports:** execute as other than selenium user ([#21931](https://github.com/apache/superset/issues/21931)) ([a02a778](https://github.com/apache/superset/commit/a02a778cc3d0fdf2036884376b53b33444d15c03))
- responsive heatmap ([#989](https://github.com/apache/superset/issues/989)) ([e67064e](https://github.com/apache/superset/commit/e67064e9521680ce3da7857fcf25cd19c936cd32))
- Reuse Dashboard redux data in Explore ([#20668](https://github.com/apache/superset/issues/20668)) ([ff5b4bc](https://github.com/apache/superset/commit/ff5b4bc0e47f057e0660d453a9e53f939613356b))
- **rightmenu:** Add Datasets to + Menu and Hide Databases when one has been connected ([#21530](https://github.com/apache/superset/issues/21530)) ([c19708b](https://github.com/apache/superset/commit/c19708b4329b8239bbf2b34f02ece8c84001870b))
- RLS for SQL Lab ([#19999](https://github.com/apache/superset/issues/19999)) ([f2881e5](https://github.com/apache/superset/commit/f2881e5bbd6a3efbf3e9c1d62a60cee39c2fa028))
- **RLS:** RESTful apis and react view for RLS ([#22325](https://github.com/apache/superset/issues/22325)) ([159dcd7](https://github.com/apache/superset/commit/159dcd7e62e9466e2da4ad81cd25c06770fb4a5e))
- root context provider extension point ([#22188](https://github.com/apache/superset/issues/22188)) ([aa97ba4](https://github.com/apache/superset/commit/aa97ba4509431a82922f2fa6930928093c876d6f))
- Run Applitools on public Storybook ([#19852](https://github.com/apache/superset/issues/19852)) ([c3ba86e](https://github.com/apache/superset/commit/c3ba86ecc5b687c10403d5b37fce2e398dea610d))
- save active tabs in dashboard permalink ([#19983](https://github.com/apache/superset/issues/19983)) ([cadd259](https://github.com/apache/superset/commit/cadd259788c99415862cef7e8a5da9aaf4ed12cd))
- Save column data into json_metadata for all Query executions ([#20059](https://github.com/apache/superset/issues/20059)) ([660af40](https://github.com/apache/superset/commit/660af409a426806ead2d21fe80bff60c5480c264))
- scroll to bottom when adding a new native filter and the page is filled ([#19053](https://github.com/apache/superset/issues/19053)) ([cfb967f](https://github.com/apache/superset/commit/cfb967f430a75d363693d79494239b1686fd6e5d))
- Select all for synchronous select ([#22084](https://github.com/apache/superset/issues/22084)) ([02c9242](https://github.com/apache/superset/commit/02c9242d680a67dca18ae05b2ca585c0cf385ad0))
- **select filter:** add CRLF separator for Windows ([#21867](https://github.com/apache/superset/issues/21867)) ([7c4102c](https://github.com/apache/superset/commit/7c4102c20e8391f5174486afdaadfcd402e0dc60))
- Selectable dropdown triggered by icon component ([#21955](https://github.com/apache/superset/issues/21955)) ([5c27aaf](https://github.com/apache/superset/commit/5c27aafc0b62a57148111b2756a3f4c0192fa8a1))
- **select:** keep options order when in single mode ([#19085](https://github.com/apache/superset/issues/19085)) ([ae13d83](https://github.com/apache/superset/commit/ae13d8313b5687374f5b24e02bccdcc717ba19eb))
- **select:** sort exact and startsWith match to first ([#18856](https://github.com/apache/superset/issues/18856)) ([c75f233](https://github.com/apache/superset/commit/c75f233109008eee60cce6fea4f7f2d9256d53ef))
- **self-trigger:** add backend pagination for the table ([#959](https://github.com/apache/superset/issues/959)) ([0e0f67a](https://github.com/apache/superset/commit/0e0f67a778c4e2495bc1335cfe45bfe91517d0c7))
- Set default for Accept field in header to take application/json ([#1413](https://github.com/apache/superset/issues/1413)) ([67f1083](https://github.com/apache/superset/commit/67f1083af66c487e562bef42bdb1df7592e2ef8a))
- setting limit value when Pie chart switches ([#20392](https://github.com/apache/superset/issues/20392)) ([0a50a9b](https://github.com/apache/superset/commit/0a50a9b3804837ea7130f91bfcfcca57ab50129f))
- shorter timeout on test_connection ([#18001](https://github.com/apache/superset/issues/18001)) ([51090c3](https://github.com/apache/superset/commit/51090c3f1b4068552d5c4dc18d51b5f03fba1860))
- show user email in dashboard API ([#19004](https://github.com/apache/superset/issues/19004)) ([be88cb9](https://github.com/apache/superset/commit/be88cb9ba00a706dc5402e0b5311975bb013972a))
- showing results pane in dashboard ([#20144](https://github.com/apache/superset/issues/20144)) ([41f33a3](https://github.com/apache/superset/commit/41f33a38bce11b81e40a65aaa3487e9562766ef4))
- Shows related dashboards in Explore ([#21685](https://github.com/apache/superset/issues/21685)) ([200bed6](https://github.com/apache/superset/commit/200bed6f7ea6f4e7e1a1f2a2b74d2dcbcd689c02))
- simplify Encoder creation ([52d120a](https://github.com/apache/superset/commit/52d120a05b7ad6d41f2ab92ed56831a4b746b901))
- simplify memoized_func ([#19905](https://github.com/apache/superset/issues/19905)) ([aff10a7](https://github.com/apache/superset/commit/aff10a7fad0b6a48c578e70d2746d04bdf4d753c))
- simplify SQLite time grain ([#19745](https://github.com/apache/superset/issues/19745)) ([90130e4](https://github.com/apache/superset/commit/90130e4b4f8533c798484711794635d707fc3027))
- simply the data processing logic ([aa7ef1a](https://github.com/apache/superset/commit/aa7ef1ad9067a531ed94006c4f5db153e8598d97))
- Single metric sort ([#953](https://github.com/apache/superset/issues/953)) ([4313a51](https://github.com/apache/superset/commit/4313a517dfbe6b73d6f90ac9fc87ebc42372d083))
- **sip-68:** Add DatasourceDAO class to manage querying different datasources easier ([#20030](https://github.com/apache/superset/issues/20030)) ([21c5b26](https://github.com/apache/superset/commit/21c5b26fc819aa6531b17d6fc83cc3cc849389a8))
- smart tooltip in datasourcepanel ([#18080](https://github.com/apache/superset/issues/18080)) ([aa21a96](https://github.com/apache/superset/commit/aa21a963a6137a1d29ad422c6d7bf79839bc7078))
- split superset-ui/query from superset-ui/chart ([#178](https://github.com/apache/superset/issues/178)) ([9decd81](https://github.com/apache/superset/commit/9decd815ec5ba36b7267da6402435fd2d9ae2e5f))
- **sql lab:** display presto and trino tracking url ([#20799](https://github.com/apache/superset/issues/20799)) ([77db065](https://github.com/apache/superset/commit/77db0651d819f4bda367fc59a4e95954cb0929e1))
- **sql lab:** enable ACE editor search in SQL editors ([#19328](https://github.com/apache/superset/issues/19328)) ([eab9388](https://github.com/apache/superset/commit/eab9388f7cdaca20588d4c94c929225fd9d59870))
- **SQL Lab:** Make SQL Lab explore use the default viz from the config file ([#20056](https://github.com/apache/superset/issues/20056)) ([daded10](https://github.com/apache/superset/commit/daded1099262a694d7cc861a8a798dba4102d5e8))
- **sqllab:** Add a configuration option to disable data preview ([#19104](https://github.com/apache/superset/issues/19104)) ([02ef9ca](https://github.com/apache/superset/commit/02ef9ca4cd60d0d05f0afd2cebc1cabb83dfd4df))
- **sqllab:** Add event logger ([#23040](https://github.com/apache/superset/issues/23040)) ([4980621](https://github.com/apache/superset/commit/4980621902716205c2d531a36850d201ebb3a79c))
- **SqlLab:** Change Save Dataset Button to Split Save Query Button IV ([#20852](https://github.com/apache/superset/issues/20852)) ([8a04536](https://github.com/apache/superset/commit/8a04536f9d417fcaa926ee43f65b1c870277eea9))
- **sqllab:** Make LeftBar width resizable ([#21300](https://github.com/apache/superset/issues/21300)) ([2d70ef6](https://github.com/apache/superset/commit/2d70ef670ef81179916d9ab558a7ce6e4b84b82e))
- **sqllab:** save query parameters in database ([#21682](https://github.com/apache/superset/issues/21682)) ([61319fd](https://github.com/apache/superset/commit/61319fd759b336992259a4e84f1459a134d55df0))
- **ssh_tunnel:** Add feature flag to SSH Tunnel API ([#22805](https://github.com/apache/superset/issues/22805)) ([d6a4a5d](https://github.com/apache/superset/commit/d6a4a5da7976070cb949409763b22519a0d3f379))
- **ssh_tunnel:** Rename allow_ssh_tunneling and change the default value to False ([#22723](https://github.com/apache/superset/issues/22723)) ([ad758c0](https://github.com/apache/superset/commit/ad758c080259970c9ea587fd8dd3f56d1dab7722))
- **ssh_tunnel:** SQLAlchemy Form UI ([#22513](https://github.com/apache/superset/issues/22513)) ([5399365](https://github.com/apache/superset/commit/539936522fbbda46ebb39b65ed298f6e251a548f))
- **ssh_tunnel:** SSH Tunnel Switch extension ([#22967](https://github.com/apache/superset/issues/22967)) ([cf395ac](https://github.com/apache/superset/commit/cf395ac2d8e04782cffc93e8a0a0b28678c407fe))
- **ssh-tunnelling:** Setup SSH Tunneling Commands for Database Connections ([#21912](https://github.com/apache/superset/issues/21912)) ([ebaad10](https://github.com/apache/superset/commit/ebaad10d6ce72fa9d939833720b44880d5139bb9))
- **standardized form data:** keep all columns and metrics ([#20377](https://github.com/apache/superset/issues/20377)) ([bbbe102](https://github.com/apache/superset/commit/bbbe102887a524b1ee0ffd4ada8481078dbe5496))
- standardized form_data ([#20010](https://github.com/apache/superset/issues/20010)) ([dd4b581](https://github.com/apache/superset/commit/dd4b581fb55d920fc3b709fc044cea5339802ee2))
- store reference to container and update bindings ([#180](https://github.com/apache/superset/issues/180)) ([9f8461b](https://github.com/apache/superset/commit/9f8461b9659240e80099a167b998f4934b969870))
- style package for theming and styled components ([#362](https://github.com/apache/superset/issues/362)) ([11dbae7](https://github.com/apache/superset/commit/11dbae71a6dd0a69e81e49f98aa33bb1b352c546))
- style pkg exports emotion's css module ([#718](https://github.com/apache/superset/issues/718)) ([4e5f69b](https://github.com/apache/superset/commit/4e5f69b24ff1bd7bf9bbe98c8a76c2b0cbec7c96))
- **style:** add style to umbrella package ([#366](https://github.com/apache/superset/issues/366)) ([f2cf0a2](https://github.com/apache/superset/commit/f2cf0a2a7f037e3bb523a48dd8403ed6660cda01))
- **style:** adding typographic variables to theme ([#463](https://github.com/apache/superset/issues/463)) ([761b1d7](https://github.com/apache/superset/commit/761b1d7b02f67e02f14527b1663bca7cb7163df9))
- **superset-ui-connection:** Allow PUT and PATCH in call API ([3c53885](https://github.com/apache/superset/commit/3c53885abac8a24eaac4c280ee1c7fd302da2918))
- **superset-ui-core:** add feature flag for the analogous colors ([#19987](https://github.com/apache/superset/issues/19987)) ([80b5578](https://github.com/apache/superset/commit/80b55786809310e28566d745308b167f0e74b144))
- **superset-ui-style:** export ThemeProvider and useTheme ([#553](https://github.com/apache/superset/issues/553)) ([a39a058](https://github.com/apache/superset/commit/a39a058919a25bf13521f461e16abdbfef6c7f65))
- **superset-ui-style:** export ThemeProvider and useTheme from emotion-theming ([87f0090](https://github.com/apache/superset/commit/87f00900ca2f3e8d2d1a722583cbb9d2c0d01127))
- **superset-ui:** include control utils in the umbrella package ([#421](https://github.com/apache/superset/issues/421)) ([7cce8f0](https://github.com/apache/superset/commit/7cce8f008187d61105c4b734ea21f397cd793489))
- SupersetClient config to override 401 behavior ([#19144](https://github.com/apache/superset/issues/19144)) ([96a123f](https://github.com/apache/superset/commit/96a123f553f80ae7454daaf139b33e1397d9e3f7))
- support custom tooltip for scatterplot and box plot ([c01f2a9](https://github.com/apache/superset/commit/c01f2a9bfc681061a727e2bef0472ade434e9bf0))
- support disabling domain sharding with a query param ([#17177](https://github.com/apache/superset/issues/17177)) ([80a459f](https://github.com/apache/superset/commit/80a459f43bf27b29ce71f343f98e189d283cc52b))
- support line strokeWidth ([#105](https://github.com/apache/superset/issues/105)) ([a2c1d69](https://github.com/apache/superset/commit/a2c1d69c2ca03c701b8b14871ed78154e8c7c9f9))
- support locale in number and time format ([#182](https://github.com/apache/superset/issues/182)) ([3fc8551](https://github.com/apache/superset/commit/3fc855101404e9932b055f9a4c8167be46dcd9db))
- support mulitple temporal filters in AdhocFilter and move the Time Section away ([#21767](https://github.com/apache/superset/issues/21767)) ([a9b229d](https://github.com/apache/superset/commit/a9b229dd1dd9cb9dc8166b1392179fcccb4da138))
- support multi queries request ([#846](https://github.com/apache/superset/issues/846)) ([250589f](https://github.com/apache/superset/commit/250589fa2741c0f814bfd77e61a1fec2e6274981))
- support multiple columns with time grain in Table Chart ([#21547](https://github.com/apache/superset/issues/21547)) ([d67b046](https://github.com/apache/superset/commit/d67b04683c5e671a8e0278994fb36b23978c1ff4))
- support multiple time columns with time grain in Pivot Table v2 ([#21537](https://github.com/apache/superset/issues/21537)) ([e671d80](https://github.com/apache/superset/commit/e671d8020982111e117e7415dee41672cc32d780))
- support no data within BigNumber viz ([#327](https://github.com/apache/superset/issues/327)) ([4613183](https://github.com/apache/superset/commit/4613183946fea17628d5bf595561aa070a22a1ce))
- support None operand in EQUAL operator ([#21713](https://github.com/apache/superset/issues/21713)) ([05648eb](https://github.com/apache/superset/commit/05648eb489a7b5eec1c452cf1f037566dd942505))
- support polygon tooltip independently from superset app ([#12](https://github.com/apache/superset/issues/12)) ([abc4a04](https://github.com/apache/superset/commit/abc4a04294af6c116c1ad4299aca1eeb3e7f33c8))
- support sort the rich tooltip by metric desc ([#1445](https://github.com/apache/superset/issues/1445)) ([7193572](https://github.com/apache/superset/commit/71935725c3a807fd2ca08449f2340718a918b09f))
- support tooltip and legend overrides ([#101](https://github.com/apache/superset/issues/101)) ([97a95ff](https://github.com/apache/superset/commit/97a95ffcda35df79a00bd483044507fe64cfe421))
- support warning_markdown on metrics ([#1011](https://github.com/apache/superset/issues/1011)) ([9993b33](https://github.com/apache/superset/commit/9993b336ffa2ce8900e2d430ac804d800ebca75a))
- supports mulitple filters in samples endpoint ([#21008](https://github.com/apache/superset/issues/21008)) ([802b69f](https://github.com/apache/superset/commit/802b69f97bb9fd35fe8aed225cfd6a03875cf747))
- switch from `sqlalchemy-trino` to `trino` python client ([#19957](https://github.com/apache/superset/issues/19957)) ([58e65ad](https://github.com/apache/superset/commit/58e65ad5bb2178583dec0a33605580fc7af81d96))
- **table:** enable table filter and better typing ([#344](https://github.com/apache/superset/issues/344)) ([9b009e7](https://github.com/apache/superset/commit/9b009e71987b225915222d4d1b368f2f2b3b6830))
- **tablevis:** this pr is to add a new tablevis plguin to the system ([11a6929](https://github.com/apache/superset/commit/11a692940b5a59733a38a1b02ed245ec7dafcfcb))
- the samples endpoint supports filters and pagination ([#20683](https://github.com/apache/superset/issues/20683)) ([f011aba](https://github.com/apache/superset/commit/f011abae2b1bbcffc4eddb1a88872dea622693fb))
- **thumbnails:** add support for user specific thumbs ([#22328](https://github.com/apache/superset/issues/22328)) ([aa0cae9](https://github.com/apache/superset/commit/aa0cae9b490405ede604804877304b1df6dd08c1))
- **time-format:** add full-date to weekly time formatter ([#486](https://github.com/apache/superset/issues/486)) ([868ebbe](https://github.com/apache/superset/commit/868ebbe09dd0c067f3f8383724e596222803c9e3))
- **time-format:** bump d3-time-format ([#244](https://github.com/apache/superset/issues/244)) ([9b0d77a](https://github.com/apache/superset/commit/9b0d77adea6bf01d339d062535494a8724f56e4f))
- **time-format:** improve support for formatting with granularity in mind ([#509](https://github.com/apache/superset/issues/509)) ([17075ae](https://github.com/apache/superset/commit/17075ae02179951da9bde15352b148fc8d20895d))
- **timeseries-chart:** add percentage threshold input control ([#17758](https://github.com/apache/superset/issues/17758)) ([6bd4dd2](https://github.com/apache/superset/commit/6bd4dd257a6089a093bae3f251cf9f0976d353e6))
- **TimeTableViz:** sort by first metric ([#18896](https://github.com/apache/superset/issues/18896)) ([760dab9](https://github.com/apache/superset/commit/760dab9abdb2199b50006e01cb1e9cc0743cf966))
- TreeMap migration ([#20346](https://github.com/apache/superset/issues/20346)) ([7626c31](https://github.com/apache/superset/commit/7626c3137234d76b065559913705e19c3f59cf7f))
- Trino Authentications ([#17593](https://github.com/apache/superset/issues/17593)) ([0b67fe1](https://github.com/apache/superset/commit/0b67fe1beb0a9b0b56f0fcbb7e80c3e7ea3a1fac))
- trino support server-cert ([#16346](https://github.com/apache/superset/issues/16346)) ([ebb3419](https://github.com/apache/superset/commit/ebb34196f29ff9e826ab572d45f71056db5bb403))
- **trino:** add query cancellation ([#21035](https://github.com/apache/superset/issues/21035)) ([5113b01](https://github.com/apache/superset/commit/5113b01031705128df2064068a0809f07019c8ae))
- **trino:** support early cancellation of queries ([#22498](https://github.com/apache/superset/issues/22498)) ([b6d39d1](https://github.com/apache/superset/commit/b6d39d194c90dbbf0050bb3d32d2e1a513dfc0a6))
- truncate long values in table viz, a per-column setting ([#19383](https://github.com/apache/superset/issues/19383)) ([7e504ff](https://github.com/apache/superset/commit/7e504ff680698106cf9008b4c2814b01fcac90bb))
- UI override registry ([#19671](https://github.com/apache/superset/issues/19671)) ([4927685](https://github.com/apache/superset/commit/4927685c3059c0207713bceeea7c60f1f3b75ec3))
- **ui:** Adding manifest prefix config ([#19141](https://github.com/apache/superset/issues/19141)) ([4b34817](https://github.com/apache/superset/commit/4b34817b195fe93aa0bffd211bc978966a4aee4e))
- update ChartFormData and QueryObject to support filters. ([#164](https://github.com/apache/superset/issues/164)) ([c9e3e73](https://github.com/apache/superset/commit/c9e3e73f2ed24bbc8919e94662737305c6f4c9c8))
- update data format returned from query api and add getGroupBys ([#72](https://github.com/apache/superset/issues/72)) ([8273942](https://github.com/apache/superset/commit/827394261ae35105240b75d7af81839c08a97a53))
- update dependencies to 0.13 ([46db778](https://github.com/apache/superset/commit/46db778baabe267c298f74aee1eda5cf595026ba))
- update dependencies to 0.13 ([8256d99](https://github.com/apache/superset/commit/8256d99cd1b5530b64451d1a788fcb396a5073d1))
- update dependencies to make plugins compatible with 0.11 ([#38](https://github.com/apache/superset/issues/38)) ([ad67c39](https://github.com/apache/superset/commit/ad67c39ab7204d3e8076344e73e661c24114b8e4))
- update line chart thumbnail and scale extraction ([#61](https://github.com/apache/superset/issues/61)) ([1a3b10e](https://github.com/apache/superset/commit/1a3b10e18073f96f21a2a904219b94850cb44865))
- Update makefile with frontend build ([#17734](https://github.com/apache/superset/issues/17734)) ([215ee08](https://github.com/apache/superset/commit/215ee08a475c1ba0e49e58213ce2dbec14bf1b16))
- Update nav bar with new data information architecture for SQL Lab + SQL ([#21245](https://github.com/apache/superset/issues/21245)) ([b302818](https://github.com/apache/superset/commit/b3028185225fdc8ee3eb8b9058f3867d1a28ea86))
- Update query states to use spinner vs. progress bar ([#17804](https://github.com/apache/superset/issues/17804)) ([9e69940](https://github.com/apache/superset/commit/9e699401713460a46b28e6fed19f6ebd6cd228ca))
- Update ShortKey for stop query running in SqlLab editor ([#19692](https://github.com/apache/superset/issues/19692)) ([60e06c1](https://github.com/apache/superset/commit/60e06c1692651d5434b69427843e2539f13f4431))
- update time comparison choices (again) ([#17968](https://github.com/apache/superset/issues/17968)) ([05d9cde](https://github.com/apache/superset/commit/05d9cde203b99f8c63106446f0be58668cc9f0c9))
- update time comparison choices (again) ([#22458](https://github.com/apache/superset/issues/22458)) ([9e81c3a](https://github.com/apache/superset/commit/9e81c3a1192a18226d505178d16e1e395917a719))
- update time_compare description and choices ([#818](https://github.com/apache/superset/issues/818)) ([85f9cda](https://github.com/apache/superset/commit/85f9cdad0a0bd159dd00a120c90afdf7c9670ba5))
- update tooltip and use selector ([#31](https://github.com/apache/superset/issues/31)) ([818f462](https://github.com/apache/superset/commit/818f4628f73632e30ae65ae8a6d925e20cbb790a))
- update type for line chart series ([#175](https://github.com/apache/superset/issues/175)) ([bb501ad](https://github.com/apache/superset/commit/bb501adda57cfe3099ab6e73bd03a73e86900848))
- updated viz plugin generator ([#636](https://github.com/apache/superset/issues/636)) ([fb69984](https://github.com/apache/superset/commit/fb69984857238b935e56e5c39151e34ecc7b392c))
- Updates button styles of Modal pre-defined functions ([#22737](https://github.com/apache/superset/issues/22737)) ([d2a355b](https://github.com/apache/superset/commit/d2a355b2fba8b3b4e8ec1fe5a58a3c1d00f6dd23))
- upgrade [@superset-ui](https://github.com/superset-ui) to v0.12 ([#183](https://github.com/apache/superset/issues/183)) ([9e47ea8](https://github.com/apache/superset/commit/9e47ea8a962f18cb57abc67859efc37722323732))
- Upgrade documentation V2 ([#17411](https://github.com/apache/superset/issues/17411)) ([ac2545e](https://github.com/apache/superset/commit/ac2545e357bff22697fb91aa6ce73eded1f12750)), closes [#17714](https://github.com/apache/superset/issues/17714) [#17736](https://github.com/apache/superset/issues/17736) [#17990](https://github.com/apache/superset/issues/17990) [#17929](https://github.com/apache/superset/issues/17929) [#18036](https://github.com/apache/superset/issues/18036) [#18115](https://github.com/apache/superset/issues/18115) [#18128](https://github.com/apache/superset/issues/18128) [#18092](https://github.com/apache/superset/issues/18092) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18041](https://github.com/apache/superset/issues/18041) [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051) [#17593](https://github.com/apache/superset/issues/17593) [#18058](https://github.com/apache/superset/issues/18058) [#18059](https://github.com/apache/superset/issues/18059) [#18027](https://github.com/apache/superset/issues/18027) [#18045](https://github.com/apache/superset/issues/18045) [#18048](https://github.com/apache/superset/issues/18048) [#18073](https://github.com/apache/superset/issues/18073) [#17771](https://github.com/apache/superset/issues/17771) [#18060](https://github.com/apache/superset/issues/18060) [#17207](https://github.com/apache/superset/issues/17207) [#18087](https://github.com/apache/superset/issues/18087) [#18086](https://github.com/apache/superset/issues/18086) [#18082](https://github.com/apache/superset/issues/18082) [#18097](https://github.com/apache/superset/issues/18097) [#17807](https://github.com/apache/superset/issues/17807) [#18089](https://github.com/apache/superset/issues/18089) [#18100](https://github.com/apache/superset/issues/18100) [#18101](https://github.com/apache/superset/issues/18101) [#18105](https://github.com/apache/superset/issues/18105) [#18111](https://github.com/apache/superset/issues/18111) [#18083](https://github.com/apache/superset/issues/18083) [#17882](https://github.com/apache/superset/issues/17882) [#17843](https://github.com/apache/superset/issues/17843) [#17917](https://github.com/apache/superset/issues/17917) [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18081](https://github.com/apache/superset/issues/18081) [#18100](https://github.com/apache/superset/issues/18100) [#18133](https://github.com/apache/superset/issues/18133) [#18100](https://github.com/apache/superset/issues/18100) [#18116](https://github.com/apache/superset/issues/18116) [#18114](https://github.com/apache/superset/issues/18114) [#18108](https://github.com/apache/superset/issues/18108) [#18125](https://github.com/apache/superset/issues/18125) [#18152](https://github.com/apache/superset/issues/18152) [#18093](https://github.com/apache/superset/issues/18093) [#18130](https://github.com/apache/superset/issues/18130) [#18151](https://github.com/apache/superset/issues/18151)
- use a new official CH driver: clickhouse-connect ([#22039](https://github.com/apache/superset/issues/22039)) ([38a3fbd](https://github.com/apache/superset/commit/38a3fbdc33292204bcb28f3e433fda7561035fb6))
- Use SPA navigation between AddSlice and Dataset list pages ([#21683](https://github.com/apache/superset/issues/21683)) ([2907869](https://github.com/apache/superset/commit/2907869c2694ef28b27e672ff143b323e174fa2c))
- Use SPA navigation from datasets list to Explore ([#20890](https://github.com/apache/superset/issues/20890)) ([6ec164e](https://github.com/apache/superset/commit/6ec164e6a901fae1c88b03227e627fd8a4619400))
- Uses new table component in Drill to Detail ([#22173](https://github.com/apache/superset/issues/22173)) ([3ffe782](https://github.com/apache/superset/commit/3ffe7828a75eeb16af88798ab6ae01bbb835d770))
- Virtual dataset duplication ([#20309](https://github.com/apache/superset/issues/20309)) ([16032ed](https://github.com/apache/superset/commit/16032ed3e2b474ac6fba1510f82e6a7e640ce1d1))
- Visualize SqlLab.Query model data in Explore 📈 ([#20281](https://github.com/apache/superset/issues/20281)) ([e5e8867](https://github.com/apache/superset/commit/e5e886739460c011a885a13b873665410045a19c))
- **viz-gallery:** add 'feature' tag and fuzzy search weighting ([#18662](https://github.com/apache/superset/issues/18662)) ([7524e1e](https://github.com/apache/superset/commit/7524e1e3c86f3de2b3b0343c3ec5efc0b345937a))
- **viz-gallery:** add search weight for viz-name ([#19581](https://github.com/apache/superset/issues/19581)) ([e625c03](https://github.com/apache/superset/commit/e625c03cd50e57e26b04d3f5de28be307fa74029))
- **vizgallery:** Double-click viz type to submit form ([#20513](https://github.com/apache/superset/issues/20513)) ([280b4be](https://github.com/apache/superset/commit/280b4be4498bdf811d9be83d6ce6514bc5832b87))
- **viz:** Pivot table chart POC ([#1023](https://github.com/apache/superset/issues/1023)) ([9b6f23d](https://github.com/apache/superset/commit/9b6f23d3a7387d700485f1221f46fc0c4d982e93))
- **welcome:** make examples tab customizable ([#22302](https://github.com/apache/superset/issues/22302)) ([b954f8f](https://github.com/apache/superset/commit/b954f8f56080270fa7f1f68aa962c9e789e96728))
- When editing the label/title in the Metrics popover, hitting Enter should save what you've typed ([#19898](https://github.com/apache/superset/issues/19898)) ([5bfc95e](https://github.com/apache/superset/commit/5bfc95e79e89961967ba4acc8d24131157ccd16b))
- Word cloud typography update ([#518](https://github.com/apache/superset/issues/518)) ([72cc39b](https://github.com/apache/superset/commit/72cc39b4e0257b8a5672b66c42029ff0ed9a0b87))
- **world-map:** support color by metric or country column ([#19881](https://github.com/apache/superset/issues/19881)) ([766f737](https://github.com/apache/superset/commit/766f737728c273d39a35dfa281e874a0efeabec3))

### Performance Improvements

- **dashboard:** Improve performance of complex dashboards ([#19064](https://github.com/apache/superset/issues/19064)) ([3c1fb94](https://github.com/apache/superset/commit/3c1fb944c1f28635ed032ae87385201da4b6faa7))
- **dashboard:** Send chart requests before native filter requests ([#19077](https://github.com/apache/superset/issues/19077)) ([b8091e3](https://github.com/apache/superset/commit/b8091e33a93cad079e2fb7b57e3cf0f9688332c4))
- **dashboard:** Virtualization POC ([#21438](https://github.com/apache/superset/issues/21438)) ([406e44b](https://github.com/apache/superset/commit/406e44bba11f6b233c3b07d29efd158b8cfc9615))
- faster legacy table chart ([#385](https://github.com/apache/superset/issues/385)) ([2973c10](https://github.com/apache/superset/commit/2973c101973f17e83650a8b8abe8e7821f13b0c4)), closes [/github.com/DataTables/DataTables/blob/83657a29e33ce93ee940ce25684940eb3acb2913/media/js/jquery.dataTables.js#L3113-L3117](https://github.com//github.com/DataTables/DataTables/blob/83657a29e33ce93ee940ce25684940eb3acb2913/media/js/jquery.dataTables.js/issues/L3113-L3117)
- Implement model specific lookups by id to improve performance ([#20974](https://github.com/apache/superset/issues/20974)) ([17b5803](https://github.com/apache/superset/commit/17b58037f85dfb9db68167484d6afe5bda8f4f1c))
- improve perf in SIP-68 migration ([#19416](https://github.com/apache/superset/issues/19416)) ([63b5e2e](https://github.com/apache/superset/commit/63b5e2e4fa0a1f12450a108793896db4fbd43c6d))
- Memoize the common_bootstrap_payload and include user param ([#21018](https://github.com/apache/superset/issues/21018)) ([#21439](https://github.com/apache/superset/issues/21439)) ([44654e5](https://github.com/apache/superset/commit/44654e5abcc70d1fd934529dc82d7fe1d1bb20ef))
- **native-filters:** Decrease number of unnecessary rerenders in native filters ([#17115](https://github.com/apache/superset/issues/17115)) ([2ad9101](https://github.com/apache/superset/commit/2ad9101d1e7284d0a4d4cf649dfab76315920ffa))
- **native-filters:** improve native filter modal form performance ([#21821](https://github.com/apache/superset/issues/21821)) ([bf00193](https://github.com/apache/superset/commit/bf001931c8c7e58a211e411fa74ca4991c6aa2a8))
- **native-filters:** reduce the re-rendering of native filter modal ([#21781](https://github.com/apache/superset/issues/21781)) ([66f166b](https://github.com/apache/superset/commit/66f166be0f5485b9a51c80aef703b9d8d0fd93d5))
- **plugin-chart-table:** Add memoization to avoid rerenders ([#19976](https://github.com/apache/superset/issues/19976)) ([0f68dee](https://github.com/apache/superset/commit/0f68deedf105300c8bd2536bd205d128799c0381))
- Prevent rerendering and re-querying metadata of filters in horizontal bar ([#22389](https://github.com/apache/superset/issues/22389)) ([605cfa0](https://github.com/apache/superset/commit/605cfa045a8b774713f8ddf57abb1f2825c645cf))
- refactor SIP-68 db migrations with INSERT SELECT FROM ([#19421](https://github.com/apache/superset/issues/19421)) ([231716c](https://github.com/apache/superset/commit/231716cb50983b04178602b86c846b7673f9d8c3))
- speed up db migration for deprecating time_range_endpoints ([#19495](https://github.com/apache/superset/issues/19495)) ([90dbe8d](https://github.com/apache/superset/commit/90dbe8d340f227e3ffe374984a202516d779d5d8))
- **sqllab:** Rendering perf improvement using immutable state ([#20877](https://github.com/apache/superset/issues/20877)) ([f77b910](https://github.com/apache/superset/commit/f77b910e2cc9f1bd90ac0f3a9097ec5d394b582d))
- **word-cloud:** reduce render to improve performance ([#21504](https://github.com/apache/superset/issues/21504)) ([94a724e](https://github.com/apache/superset/commit/94a724e49bd8887d3c3bba1551f6f7415c64eb0a))

### Reverts

- Revert "ok (#21116)" (#21247) ([f2d67f7](https://github.com/apache/superset/commit/f2d67f75d013b8f9469fec474d7f6203007cd633)), closes [#21116](https://github.com/apache/superset/issues/21116) [#21247](https://github.com/apache/superset/issues/21247)
- Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (#20689) ([5317462](https://github.com/apache/superset/commit/5317462b49d050d93d91eee5e97ec56e15f9f298)), closes [#20668](https://github.com/apache/superset/issues/20668) [#20689](https://github.com/apache/superset/issues/20689)
- Revert "feat(plugin-chart-echarts): Support stacking negative and positive values (#20408)" (#20571) ([f5f8dde](https://github.com/apache/superset/commit/f5f8ddec3e5c947896521003295e1acd93851674)), closes [#20408](https://github.com/apache/superset/issues/20408) [#20571](https://github.com/apache/superset/issues/20571)
- Revert "feat(explore): Show confirmation modal if user exits Explore without saving changes (#19993)" (#20092) ([9cdaa28](https://github.com/apache/superset/commit/9cdaa280429ec297db16d56c94fd77b5d2aff107)), closes [#19993](https://github.com/apache/superset/issues/19993) [#20092](https://github.com/apache/superset/issues/20092)
- Revert "chore(deps): bump d3-svg-legend in /superset-frontend (#19846)" (#19972) ([f144de4](https://github.com/apache/superset/commit/f144de4ee2bf213bb7e17f903bd3975d504c4136)), closes [#19846](https://github.com/apache/superset/issues/19846) [#19972](https://github.com/apache/superset/issues/19972)
- Revert "fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode (#19362)" (#19906) ([1fa841e](https://github.com/apache/superset/commit/1fa841ee29cb502aa9d9e12e32a90558929b088a)), closes [#19362](https://github.com/apache/superset/issues/19362) [#19906](https://github.com/apache/superset/issues/19906)
- Revert "Update superset-e2e.yml (#18041)" (#18051) ([5da3c45](https://github.com/apache/superset/commit/5da3c45fc64b27d0f732cc9e26bf24f1ef9afa90)), closes [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051)
- Revert "fix(Dashboard): Only apply changes when editing properties (#17392)" (#17618) ([8963cca](https://github.com/apache/superset/commit/8963cca265ee6457542eeb22c33e31e1858e664c)), closes [#17392](https://github.com/apache/superset/issues/17392) [#17618](https://github.com/apache/superset/issues/17618)
- Revert "chore: isolate the one actual jquery dependency (#1339)" (#1355) ([e1944cf](https://github.com/apache/superset/commit/e1944cfb43276b44873b22d2fc2f86018c14147c)), closes [#1339](https://github.com/apache/superset/issues/1339) [#1355](https://github.com/apache/superset/issues/1355)
- Revert "chore: remove V2 and add Deprecated (#1250)" (#1253) ([f083d28](https://github.com/apache/superset/commit/f083d2897a9157a785f57c899c733d4a700355b8)), closes [#1250](https://github.com/apache/superset/issues/1250) [#1253](https://github.com/apache/superset/issues/1253)
- Revert "feat(superset-ui-style): export ThemeProvider and useTheme from emotion-theming" ([be31aa4](https://github.com/apache/superset/commit/be31aa49979b1ab927914d89898b4e74be3be37b))
- Revert "build: try to merge superset-ui-plugins" ([4d0d05f](https://github.com/apache/superset/commit/4d0d05f71f936963e381cfc901ca78f252b85c2b))
- Revert "build: clean up tsbuild.info, too" ([6f42844](https://github.com/apache/superset/commit/6f4284436614f71f6eff93d083068b9a70486058))
- Revert "Handle BigNumber conversions in JSON properly (without loss of precision) (#71)" (#126) ([f71180e](https://github.com/apache/superset/commit/f71180e251cc154370eef6d291be8270a1480e74)), closes [#71](https://github.com/apache/superset/issues/71) [#126](https://github.com/apache/superset/issues/126) [#71](https://github.com/apache/superset/issues/71)
- Revert "[Chart]Unify Metric format (#63)" (#65) ([908f969](https://github.com/apache/superset/commit/908f9693f0452a02cd98183aad3365dab1d32060)), closes [#63](https://github.com/apache/superset/issues/63) [#65](https://github.com/apache/superset/issues/65)
- Revert "fix(native-filters): Fix update ownState (#17181)" (#17311) ([7c6d6f4](https://github.com/apache/superset/commit/7c6d6f47bf71dce15e049f37fe82076bf7cb9c63)), closes [#17181](https://github.com/apache/superset/issues/17181) [#17311](https://github.com/apache/superset/issues/17311)
- Revert "fix: the calculated columns explicit type convert into date (#14813)" (#16950) ([b7e7ef2](https://github.com/apache/superset/commit/b7e7ef283150837c2c1d78719c11e20424c67d87)), closes [#14813](https://github.com/apache/superset/issues/14813) [#16950](https://github.com/apache/superset/issues/16950)
- Partial revert of 17236 ([#17383](https://github.com/apache/superset/issues/17383)) ([675ffaf](https://github.com/apache/superset/commit/675ffaf8df98b9f16be30a8e46deea0c61a0c238))

### BREAKING CHANGES

- **chart:** ChartProps fields are removed and renamed.

- test: update tests

- fix: unit tests

- fix: type
- No longer accept chartProps as a single prop in <SuperChart>. Developers must specify each field in chartProps individually.
- some api and types are removed from @superset-ui/chart and moved to /query

- feat: split superset-ui/query from superset-ui/chart

- fix: update references

- test: fix broken tests

- refactor: rename ChartFormData to QueryFormData

- fix: rename file

- fix: remove annotation layer from query package
- @superset-ui/core becomes peer dependency
- NumberFormat.xxx are renamed

- feat: Make smart number default formatter

- fix: add unit test

- refactor: move formatters outside
- Change Registry constructor API to take object instead of single string name.
  feat: Add overwritePolicy for Registry so developer can customize whether overwriting is ALLOW, WARN or PROHIBIT.
- rename D3Formatter to D3NumberFormatter
- Rename ColorScheme field 'name' to 'id'
- Remove categoricalColorScale.toFunction().
- The color scale no longer convert input to lowercase before finding color.
- Fix: Also transform input value before setting color.

# [0.19.0](https://github.com/apache/superset/compare/v2021.41.0...v0.19.0) (2023-04-18)

### Bug Fixes

- add timegrains to data payload ([#20938](https://github.com/apache/superset/issues/20938)) ([6e5036d](https://github.com/apache/superset/commit/6e5036d87fcb444eaf01d7a8a1f274426597a69f))
- dashboard full screen layout ([#17985](https://github.com/apache/superset/issues/17985)) ([c139312](https://github.com/apache/superset/commit/c139312bb3cc849bfd26141d719612306fe46156))
- dashboard reload crash ([#17992](https://github.com/apache/superset/issues/17992)) ([3d829fc](https://github.com/apache/superset/commit/3d829fc3c838358dd8c798ecaeefd34c502edca0))
- "Refresh Dashboard" only refreshes active tab ([#20688](https://github.com/apache/superset/issues/20688)) ([558201c](https://github.com/apache/superset/commit/558201c8653dfb2ee5f011662ee0e0a79f4b281d))
- "Week Staring Monday" time grain for BigQuery ([#20091](https://github.com/apache/superset/issues/20091)) ([694f75d](https://github.com/apache/superset/commit/694f75d37657a554831fe9747e5baef36339ed88))
- (dashboard) Adds optional chaining to avoid runtime error ([#22213](https://github.com/apache/superset/issues/22213)) ([1831e8c](https://github.com/apache/superset/commit/1831e8c9273275f45ac174a301f21d3c2b11cc16))
- [alert] allow decimal for alert threshold value ([#17751](https://github.com/apache/superset/issues/17751)) ([c5af7a4](https://github.com/apache/superset/commit/c5af7a48df24207839913a61d9aed31148697ee2))
- [alert] should run alert query from report account ([#17499](https://github.com/apache/superset/issues/17499)) ([a01c4c9](https://github.com/apache/superset/commit/a01c4c95db9bd099758b5cf49119e4ad536613e8))
- [explore][mixed time series chart] when user change size of view query window, query B part will disappear ([#20750](https://github.com/apache/superset/issues/20750)) ([6e0ddcf](https://github.com/apache/superset/commit/6e0ddcf84839eecb19c694f66460ffb8aa5453dd))
- [sc-54864] Adds safety check to provide near term fix to save query ([#21034](https://github.com/apache/superset/issues/21034)) ([ab6ec89](https://github.com/apache/superset/commit/ab6ec89f680dbf022a39ed568c6fcdce0439b2dd))
- 🐛 broken unit test due to missing babel-polyfill ([896657e](https://github.com/apache/superset/commit/896657e1474260245c16a9df52c0e3fe878be3f4))
- 🐛 Fixed type definition for chart plugin ([#123](https://github.com/apache/superset/issues/123)) ([fdd10fa](https://github.com/apache/superset/commit/fdd10fa062d48a93a76f79c30855a1d0016a7cad))
- 0 indicator on radar viz ([#1282](https://github.com/apache/superset/issues/1282)) ([353d7f4](https://github.com/apache/superset/commit/353d7f4a346192206c60f0154a7e30c7da08befe))
- **20428:** Address-Presto/Trino-Poll-Issue-Refactor ([#20434](https://github.com/apache/superset/issues/20434)) ([8b7262f](https://github.com/apache/superset/commit/8b7262fa9040b6bc956dfa2c191953fe3b65bea6))
- A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button ([#19967](https://github.com/apache/superset/issues/19967)) ([8345eb4](https://github.com/apache/superset/commit/8345eb4644947180e3c84ed26498abb7fa194de9))
- A newly connected database doesn't appear in the databases list if user connected database using the 'plus' button ([#20363](https://github.com/apache/superset/issues/20363)) ([ead1040](https://github.com/apache/superset/commit/ead10401e7f5344d821ee3086c191fedb5d6ee4b))
- accept headers on import ([#17080](https://github.com/apache/superset/issues/17080)) ([40e9add](https://github.com/apache/superset/commit/40e9add641483a1c3a8bc87efa0d8e525d4cfd0d))
- accept old database payload ([#21923](https://github.com/apache/superset/issues/21923)) ([1388f21](https://github.com/apache/superset/commit/1388f21ee34251b6ef83beb009ba0901e4067848))
- accept only JSON credentials ([#22040](https://github.com/apache/superset/issues/22040)) ([cd1b379](https://github.com/apache/superset/commit/cd1b379bdf323f78c2e7d574525a55898c920942))
- Adaptive formatting spelling ([#19359](https://github.com/apache/superset/issues/19359)) ([dc769a9](https://github.com/apache/superset/commit/dc769a9a34e9b6417447ee490ecd203ace0941d9))
- adaptive formatting typo in explore dropdowns ([#19312](https://github.com/apache/superset/issues/19312)) ([0363e55](https://github.com/apache/superset/commit/0363e55b810df1980c3dc2381aedcd90e8706b32))
- add **init**.py to key_value ([#17730](https://github.com/apache/superset/issues/17730)) ([ec24256](https://github.com/apache/superset/commit/ec24256407dc0a0122f746cd3354c3647ccaddb5))
- add `get_column` function for Query obj ([#21691](https://github.com/apache/superset/issues/21691)) ([51c54b3](https://github.com/apache/superset/commit/51c54b3c9bc69273bb5da004b8f9a7ae202de8fd))
- add advanced analytics to all of timeseries viz ([#1308](https://github.com/apache/superset/issues/1308)) ([4de4fc3](https://github.com/apache/superset/commit/4de4fc37fc84cad5aa4bae7dcd27efb380b2966c))
- add back custom sql filtering with Query as source ([#21190](https://github.com/apache/superset/issues/21190)) ([c61a507](https://github.com/apache/superset/commit/c61a507e14491b400c8d5155317960a8671ab3e2))
- add back database lookup from sip 68 revert ([#22129](https://github.com/apache/superset/issues/22129)) ([6f6cb18](https://github.com/apache/superset/commit/6f6cb1839e8c688a929639dca7d0754e868ebfbf))
- add back nvd3 missing css ([#776](https://github.com/apache/superset/issues/776)) ([104c1b5](https://github.com/apache/superset/commit/104c1b597a45b6127c68e9c75b73bdd1688284dc))
- add back view for report reload error ([#19522](https://github.com/apache/superset/issues/19522)) ([79abd23](https://github.com/apache/superset/commit/79abd23f48bcad15f3c879b2ec0713648f066849))
- add columns back into SQL Lab to Explore Flow ([#22320](https://github.com/apache/superset/issues/22320)) ([5e1b817](https://github.com/apache/superset/commit/5e1b8170ca9e6093ecde0852c92bd050c31e9c30))
- add complex type to pydruid ([#20834](https://github.com/apache/superset/issues/20834)) ([672266c](https://github.com/apache/superset/commit/672266ca588b14975cb7adc31edd49f36b6d80c7))
- add container css for interval type annotation ([#372](https://github.com/apache/superset/issues/372)) ([2277583](https://github.com/apache/superset/commit/227758355765e31d570d55768dc3a199a70f550e))
- Add cypress test for report page direct link issue ([#20099](https://github.com/apache/superset/issues/20099)) ([6244728](https://github.com/apache/superset/commit/62447282561b114b46be9e704c4ae8a7f02b9e34))
- Add database search in available charts on dashboard. ([#19244](https://github.com/apache/superset/issues/19244)) ([9622520](https://github.com/apache/superset/commit/962252030bb320ed0a798e732473d8b0eda3a848))
- add disallowed query params for engines specs ([#23217](https://github.com/apache/superset/issues/23217)) ([2f37582](https://github.com/apache/superset/commit/2f3758278fe42cfdd3789c7c93448bc1e5a5a9fe))
- add fallback and validation for report and cron timezones ([#17338](https://github.com/apache/superset/issues/17338)) ([f10bc6d](https://github.com/apache/superset/commit/f10bc6d8fe7f3fa4056db2aaff8256f9c3e1550b))
- add fetchRetryOptions in SupersetClientClass.request method ([#867](https://github.com/apache/superset/issues/867)) ([b96586b](https://github.com/apache/superset/commit/b96586b0a973b058d2b36e46ae20cfd28f165132))
- add form data for empty state control to save dataset ([#21944](https://github.com/apache/superset/issues/21944)) ([d3f930a](https://github.com/apache/superset/commit/d3f930a5575f03bc5f4f468b8bf37e834bf2aa4d))
- Add french translation missing ([#20061](https://github.com/apache/superset/issues/20061)) ([944808a](https://github.com/apache/superset/commit/944808a0ce6f094071bff5b3b789e63157a8b8f7))
- Add locale for DatePicker component ([#20063](https://github.com/apache/superset/issues/20063)) ([c382d53](https://github.com/apache/superset/commit/c382d53478c7292e6aa21ba081eb055886477d18))
- add logging to alerts and reports to find non-triggering issues ([#21684](https://github.com/apache/superset/issues/21684)) ([84c3cf6](https://github.com/apache/superset/commit/84c3cf66ea0858f7dd7ae1a1fca7260cec076bf6))
- Add mexico back to country map ([#18219](https://github.com/apache/superset/issues/18219)) ([7f3453f](https://github.com/apache/superset/commit/7f3453f3ea4d5185c3a5f2c1d8738f474817600f))
- Add migration to add created_by_fk as explicit owner for charts and datasets ([#20617](https://github.com/apache/superset/issues/20617)) ([e1094e2](https://github.com/apache/superset/commit/e1094e2198d9e5714714f3f276ed3cc4fa28dfd5))
- add missing init on python pkg key_value ([#19428](https://github.com/apache/superset/issues/19428)) ([fa35109](https://github.com/apache/superset/commit/fa35109bf2a416462e3c83f527aa82c20b67818d))
- add new config to allow for specific import data urls ([#22942](https://github.com/apache/superset/issues/22942)) ([7a0f350](https://github.com/apache/superset/commit/7a0f350028817e9980abcc1afcf5672d04af3e8b))
- Add perm for showing DBC-UI in Global Nav ([#19023](https://github.com/apache/superset/issues/19023)) ([c337491](https://github.com/apache/superset/commit/c337491d0ebd10f83ca502779cbebe5cb6570049))
- add plain postgres alias ([#21045](https://github.com/apache/superset/issues/21045)) ([4f1996d](https://github.com/apache/superset/commit/4f1996dba8e35ee958048b726750247ec8e518aa))
- add primary button loading state to modals ([#20018](https://github.com/apache/superset/issues/20018)) ([63702c4](https://github.com/apache/superset/commit/63702c48ab77ee73b7e304c92fc74ce02748107e))
- Add scrollTopOnPagination property to Table ([#22115](https://github.com/apache/superset/issues/22115)) ([896c832](https://github.com/apache/superset/commit/896c8326494b512743aa6194b015b5e9dfe0c487))
- Add serviceAccountName to celerybeat pods. ([#19670](https://github.com/apache/superset/issues/19670)) ([1918dc0](https://github.com/apache/superset/commit/1918dc04559fcc6df369f3bf09d165561a29176e))
- add timeout value to error details in rejectAfterTimeout ([#715](https://github.com/apache/superset/issues/715)) ([c244286](https://github.com/apache/superset/commit/c24428643ddc6abfd12d79ce1c4d3c6a3d33c08f))
- Add tooltip to dropdown trigger in horizontal filter bar ([#22373](https://github.com/apache/superset/issues/22373)) ([de4f509](https://github.com/apache/superset/commit/de4f50909e20608ca143d7f85e42971be6bce495))
- add typings for @storybook/react ([#203](https://github.com/apache/superset/issues/203)) ([a2a02ef](https://github.com/apache/superset/commit/a2a02ef93284351f463c763f8d60245b75a86420))
- add/find owners from report/alert modal ([#18971](https://github.com/apache/superset/issues/18971)) ([7e336d1](https://github.com/apache/superset/commit/7e336d1230ca8333afc3e5be7780bc962cbf8478))
- adding extraConfig to celery beat deployment ([#22586](https://github.com/apache/superset/issues/22586)) ([db20180](https://github.com/apache/superset/commit/db201804aeaba232cb2eef4e3554278567032513))
- adding extraConfig to worker deployment [#20828](https://github.com/apache/superset/issues/20828) ([#20829](https://github.com/apache/superset/issues/20829)) ([3f943ff](https://github.com/apache/superset/commit/3f943ffadb92632489e275ba2103a1531f4dc790))
- adding missing examples for bubble chart, bullet chart, calendar heatmap chart and country map chart in the gallery ([#22523](https://github.com/apache/superset/issues/22523)) ([839ec7c](https://github.com/apache/superset/commit/839ec7ceacc66c65928fd0ddead2b014db3d5563))
- Address performance regression introduced in [#11785](https://github.com/apache/superset/issues/11785) ([#20893](https://github.com/apache/superset/issues/20893)) ([50d2e5a](https://github.com/apache/superset/commit/50d2e5a15d83b4759cdbbcce363a83f6fe12c6bb))
- Address regression in main_dttm_col for non-dnd ([#20712](https://github.com/apache/superset/issues/20712)) ([a6abcd9](https://github.com/apache/superset/commit/a6abcd9ea8fac4a477b824adb367b4b5206a5d27))
- Address regression introduced in [#21284](https://github.com/apache/superset/issues/21284) ([#21470](https://github.com/apache/superset/issues/21470)) ([8c16806](https://github.com/apache/superset/commit/8c16806f5759ecc53ecef88a2e96e2e0964bffc6))
- Adds logging for SPA route navigation with React router ([#21960](https://github.com/apache/superset/issues/21960)) ([d1807db](https://github.com/apache/superset/commit/d1807db0410642d6bfb5faf37c2a9bf4ef5c9f3e))
- Adds time grain to Pivot Table v2 ([#22170](https://github.com/apache/superset/issues/22170)) ([9a2cb43](https://github.com/apache/superset/commit/9a2cb431ce9b82d656838d70c088bc00f3e4bd5e))
- Adhere to series limit ordering for prequery ([#17388](https://github.com/apache/superset/issues/17388)) ([ce614ea](https://github.com/apache/superset/commit/ce614ea815db492cd88f53918daea6dcdd7ddedc))
- adhoc column in legacy chart ([#19234](https://github.com/apache/superset/issues/19234)) ([b5e9fad](https://github.com/apache/superset/commit/b5e9fad11a2146c471c7f27d88cc425d928f94dd))
- adjust timeseries grid right offset to match the rest ([#20933](https://github.com/apache/superset/issues/20933)) ([fe581a3](https://github.com/apache/superset/commit/fe581a36404ec1cfe689995b61a43164cb1988df))
- **adjusted upstream break change:** adjusted upstream break change ([ad02316](https://github.com/apache/superset/commit/ad023162e19ed032fb5fd6b86fc67e6b4f124cca))
- advanced data type API spec and permission name ([#20128](https://github.com/apache/superset/issues/20128)) ([d8117f7](https://github.com/apache/superset/commit/d8117f7e377a2c231ea3fb17fb3b4f96408b58fe))
- **alembic:** Making Alembic logger config optional ([#17774](https://github.com/apache/superset/issues/17774)) ([b3db614](https://github.com/apache/superset/commit/b3db6140c88106fedebe91db0ca817eca4234dc8))
- **alert & report:** make to fix the issue when recreate report ([#19419](https://github.com/apache/superset/issues/19419)) ([68ed39b](https://github.com/apache/superset/commit/68ed39bcd34f8cc3c10b37121fa717dfe4ad3cce))
- alert & reports active toggle optimistic update ([#20402](https://github.com/apache/superset/issues/20402)) ([4dc3044](https://github.com/apache/superset/commit/4dc30441b7e38aa43db9aa5eda3f8a52322e46b1))
- alert modal bug fix ([#22688](https://github.com/apache/superset/issues/22688)) ([5a422b3](https://github.com/apache/superset/commit/5a422b31c5d1ee3059c7659b376e3b8e1eeb257b))
- alert/report created by filter inconsistency with table display ([#19518](https://github.com/apache/superset/issues/19518)) ([a05ff5e](https://github.com/apache/superset/commit/a05ff5e5983632809518995b7b50b985845fba88))
- **AlertReportModal:** Text Area Change ([#17176](https://github.com/apache/superset/issues/17176)) ([5948a9f](https://github.com/apache/superset/commit/5948a9fd0246b9d67fd2074a613f081e53a19670))
- **alerts:** cron picker alignment issues ([#22274](https://github.com/apache/superset/issues/22274)) ([09bb1cc](https://github.com/apache/superset/commit/09bb1cc3b589464acfaaecf05b99b78aa1dbb5b4))
- **alerts:** execute query as report executor ([#22167](https://github.com/apache/superset/issues/22167)) ([c3f9f0b](https://github.com/apache/superset/commit/c3f9f0bf691df6923bf44df0457de718728c3e7b))
- **alerts:** restrict list view and gamma perms ([#21765](https://github.com/apache/superset/issues/21765)) ([4c1777f](https://github.com/apache/superset/commit/4c1777f20d6ca3a91383ba7fc042f20c286a7795))
- allow adhoc columns in non-aggregate query ([#21729](https://github.com/apache/superset/issues/21729)) ([d1a6f0e](https://github.com/apache/superset/commit/d1a6f0ebc4e2dd092580ad49da7c724c577e6ece))
- Allow clickhouse dbs with timestamps to visualize queries ([#21446](https://github.com/apache/superset/issues/21446)) ([4d0c2ba](https://github.com/apache/superset/commit/4d0c2ba6ef3f8ca7479cf46383ddac9470aa3329))
- Allow comma in Number Format ([#21817](https://github.com/apache/superset/issues/21817)) ([383dc29](https://github.com/apache/superset/commit/383dc29ad1fb921ee618ed80b847316d77247886))
- allow CSV upload in Other db ([#22807](https://github.com/apache/superset/issues/22807)) ([3084763](https://github.com/apache/superset/commit/3084763eb70fa92899e932d8ec95b52cf36ade3d))
- Allow dataset owners to explore their datasets ([#20382](https://github.com/apache/superset/issues/20382)) ([f910958](https://github.com/apache/superset/commit/f9109583ce1ede0cb2b9f4ad09452bba552a55ce))
- Allow dataset owners to see their datasets ([#20135](https://github.com/apache/superset/issues/20135)) ([b0c6935](https://github.com/apache/superset/commit/b0c6935f0600f111f06ae7ff05f7fa902e9ad252))
- allow datasource imports on Windows ([#22264](https://github.com/apache/superset/issues/22264)) ([32ccb97](https://github.com/apache/superset/commit/32ccb97c9b94d9071bf5d52c7467d47c36ed70b2))
- Allow empty CSS in Handlebars ([#22422](https://github.com/apache/superset/issues/22422)) ([bb318cb](https://github.com/apache/superset/commit/bb318cb137acd27009ddbe63ba4f8e0c37b754ca))
- allow for multiple columns in pivot table report ([#17636](https://github.com/apache/superset/issues/17636)) ([13e1929](https://github.com/apache/superset/commit/13e19291f2aa7041b156f0284c17f70a06000d3c))
- allow POST chart/data request without CSRF token ([#17429](https://github.com/apache/superset/issues/17429)) ([aa8040e](https://github.com/apache/superset/commit/aa8040ec9b0033fab8301afea6fccfcf2a245260))
- allow subquery in ad-hoc SQL (WIP) ([#19242](https://github.com/apache/superset/issues/19242)) ([50902d5](https://github.com/apache/superset/commit/50902d51f56eac7813572178527ee83b429db284))
- allow to select <NULL> in a native filter single mode ([#19076](https://github.com/apache/superset/issues/19076)) ([19fcd03](https://github.com/apache/superset/commit/19fcd03c8962b5ae2d2bb5cd196b1ef07a27b9c3))
- Allow users to update database in Dataset Edit Modal ([#17265](https://github.com/apache/superset/issues/17265)) ([d0bad96](https://github.com/apache/superset/commit/d0bad96b1ab9065a5e1d313793da35089ee1f07c))
- allow_browser_login in import/export API ([#19656](https://github.com/apache/superset/issues/19656)) ([5c63df5](https://github.com/apache/superset/commit/5c63df522a6df73e58142a1b9db62155c6ec5cd4))
- **allow-db-explore:** make that the set the allow-db-explore option ([#19030](https://github.com/apache/superset/issues/19030)) ([62ad574](https://github.com/apache/superset/commit/62ad574c2405edca7107f4ceaf9c2358927219d3))
- **allow-db-explore:** make to check the allow virtual table explore option by default ([#19883](https://github.com/apache/superset/issues/19883)) ([ea6753d](https://github.com/apache/superset/commit/ea6753d27df81f57d691593a7ec131bcfaf1e7ea))
- Allows PUT and DELETE only for owners of dashboard filter state ([#17644](https://github.com/apache/superset/issues/17644)) ([2ae83fa](https://github.com/apache/superset/commit/2ae83fac8623acd20f92e9f441ce03793354e0a1))
- Alpha are unable to perform a second modification to a Dataset when in Explore ([#20296](https://github.com/apache/superset/issues/20296)) ([b6c11f2](https://github.com/apache/superset/commit/b6c11f2b971abd45281dafa0ac0b105e9d3ba6db))
- Alpha should not be able to edit datasets that they don't own ([#19854](https://github.com/apache/superset/issues/19854)) ([8b15b68](https://github.com/apache/superset/commit/8b15b68979bf033979fe7014ef2730095ae85120))
- **altered-modal:** displayed the metric value in altered modal correctly ([#18813](https://github.com/apache/superset/issues/18813)) ([3c17c60](https://github.com/apache/superset/commit/3c17c609c98a9702dcb5e69bee7cc925140e98f8))
- **altered-modal:** make specified text fields wrap in table ([#18822](https://github.com/apache/superset/issues/18822)) ([220c461](https://github.com/apache/superset/commit/220c46131e2e6e97496429fa946b0e1a89969f7e))
- always create parameter json field ([#19899](https://github.com/apache/superset/issues/19899)) ([0501ad2](https://github.com/apache/superset/commit/0501ad25e8437757b0ac611026734f2460796e1b))
- Always use temporal type for dttm columns [ID-2] ([#17458](https://github.com/apache/superset/issues/17458)) ([1f8eff7](https://github.com/apache/superset/commit/1f8eff72defe7d0b42058b799a8945c59756f730))
- **annotataion:** handle required fields properly ([#17234](https://github.com/apache/superset/issues/17234)) ([4316fe6](https://github.com/apache/superset/commit/4316fe6ae64522ff5ac31383b378b94be786ad60))
- annotation broken ([#20651](https://github.com/apache/superset/issues/20651)) ([7f918a4](https://github.com/apache/superset/commit/7f918a4ec0e162be13bf3fc0e2f15aaaa5450cec))
- **Annotation Layers:** Error when render options with renamed columns ([#22453](https://github.com/apache/superset/issues/22453)) ([5da09bf](https://github.com/apache/superset/commit/5da09bf341cbad437f653d4ca698c585be840d8a))
- annotation PropType for formula annotations ([#594](https://github.com/apache/superset/issues/594)) ([794c76b](https://github.com/apache/superset/commit/794c76bcd25580cdb0faeba942684ccb2e8fe3ac))
- API logger output ([#17981](https://github.com/apache/superset/issues/17981)) ([3a58424](https://github.com/apache/superset/commit/3a58424e62592ead7d05eb64a351c21f8305e6ab))
- **api:** incorrect api schema definitions ([#17620](https://github.com/apache/superset/issues/17620)) ([0544bee](https://github.com/apache/superset/commit/0544bee74eb1cb36aa2a12847aaa6ac4ff082f90))
- Apply border radius and fix height for MetadataBar ([#22010](https://github.com/apache/superset/issues/22010)) ([389e44e](https://github.com/apache/superset/commit/389e44e1c5d33b162ff20e1568490259c403329c))
- apply margins in nvd3 ([#283](https://github.com/apache/superset/issues/283)) ([929c546](https://github.com/apache/superset/commit/929c546ebc8b88789952e1e210459843da00a386))
- **assets api:** import replaces dashboard ([#22208](https://github.com/apache/superset/issues/22208)) ([7d8fff8](https://github.com/apache/superset/commit/7d8fff87b55a2276b7e287772a654c3c63f5b2ce))
- Assign an owner when creating a dataset from a csv, excel or tabular ([#17986](https://github.com/apache/superset/issues/17986)) ([8b83c7f](https://github.com/apache/superset/commit/8b83c7fe0a5c144295007211cc614cc3379e4c54))
- **async-queries:** make global async. queries cookie SameSite option configurable ([#21185](https://github.com/apache/superset/issues/21185)) ([80b3113](https://github.com/apache/superset/commit/80b31130b4e639028d1bc613ce93fd4c4f5ad58f))
- Athena timestamp literal format ([#19970](https://github.com/apache/superset/issues/19970)) ([8531546](https://github.com/apache/superset/commit/85315460cbc23cae6ada309012f6d9057f23019d)), closes [#19969](https://github.com/apache/superset/issues/19969)
- auto refresh interval won't be updated ([#17112](https://github.com/apache/superset/issues/17112)) ([35cbcc4](https://github.com/apache/superset/commit/35cbcc46438c8fec06cf1e5f2c36aa5e0dcb46d7))
- auto-complete of tables and names are not working in SQL lab ([#19152](https://github.com/apache/superset/issues/19152)) ([3b427b2](https://github.com/apache/superset/commit/3b427b2029cbeb5c656d20f4201ea4eada069a25))
- avoid escaping bind-like params containing colons ([#17419](https://github.com/apache/superset/issues/17419)) ([ad8a7c4](https://github.com/apache/superset/commit/ad8a7c42f9da8ce6092b368d7081c3e06b797f8d))
- avoid filters containing null value ([#17168](https://github.com/apache/superset/issues/17168)) ([4c708af](https://github.com/apache/superset/commit/4c708af71081eef3454e7f0ac2bba5d0588bfa87))
- avoid unnecessary rerenders caused by ownState ([#1096](https://github.com/apache/superset/issues/1096)) ([cb76b9d](https://github.com/apache/superset/commit/cb76b9dac1555e1028b32ef15d1fae2237a44b48))
- avoid while cycle in computeMaxFontSize for big Number run forever when css rule applied ([#20173](https://github.com/apache/superset/issues/20173)) ([365acee](https://github.com/apache/superset/commit/365acee663f7942ba7d8dfd0e4cf72c4cecb7a2d))
- Bad date type in email text report for table chart ([#20119](https://github.com/apache/superset/issues/20119)) ([e7b965a](https://github.com/apache/superset/commit/e7b965a3b2bb22da75b42d64cf4856073ecc026d))
- bar label for many bars and long labels ([#21](https://github.com/apache/superset/issues/21)) ([a2209f2](https://github.com/apache/superset/commit/a2209f2876d96eb890e3ec84007b3b49bb08909b))
- **bar-chart-v2:** remove marker from bar chart V2 ([#20409](https://github.com/apache/superset/issues/20409)) ([b32288f](https://github.com/apache/superset/commit/b32288fddfc077d941452245a4e8002335746ba4))
- better logic to extract errors on databricks ([#22792](https://github.com/apache/superset/issues/22792)) ([d091a68](https://github.com/apache/superset/commit/d091a6890996997080c7a1d10e2937157393d8ac))
- big number with trendline can't calculate cumsum ([#19542](https://github.com/apache/superset/issues/19542)) ([2daa071](https://github.com/apache/superset/commit/2daa07163326b8555488dab523c5479cf92821cf))
- big number with trendline fix ([#34](https://github.com/apache/superset/issues/34)) ([66a5a5e](https://github.com/apache/superset/commit/66a5a5e56596868443db4c6c68dbc25e1ec4551c))
- **big number:** time grain control is useless in BigNumber Viz ([#21372](https://github.com/apache/superset/issues/21372)) ([b80f659](https://github.com/apache/superset/commit/b80f6591018858b709194687fe7ea3d244131761))
- **big-number:** big number gets cut off on a Dashboard ([#20488](https://github.com/apache/superset/issues/20488)) ([24a53c3](https://github.com/apache/superset/commit/24a53c38c68108c47af9f7685542fcb8378915bf))
- **big-number:** Big Number with Trendline Chart is not working if Time Grain is set to Month ([#19043](https://github.com/apache/superset/issues/19043)) ([c32eaf4](https://github.com/apache/superset/commit/c32eaf47e50f5fc0cb7630cbf38819cd03b5294b))
- BIGINT rendering regression in chartAction ([#21937](https://github.com/apache/superset/issues/21937)) ([4002406](https://github.com/apache/superset/commit/40024064ae35e596215a79d98ed8d0b4a90847f2))
- bignumber format by time formatter ([#1307](https://github.com/apache/superset/issues/1307)) ([03b1db9](https://github.com/apache/superset/commit/03b1db93c2dfbfb34498845de69105bc7b9fad54))
- BigQuery cannot accept Time Grain ([#21489](https://github.com/apache/superset/issues/21489)) ([33509ab](https://github.com/apache/superset/commit/33509ab7da384144d42d67dd8c6233b1be9c9fa0))
- BigQuery get_parameters_from_uri ([#20966](https://github.com/apache/superset/issues/20966)) ([7e501cd](https://github.com/apache/superset/commit/7e501cd816937608cddcd513bea9e7ea11bd3add))
- **bigquery:** calculated column cannot orderby in BigQuery ([#17196](https://github.com/apache/superset/issues/17196)) ([bedb8f4](https://github.com/apache/superset/commit/bedb8f4dffb824a0f6c252b11890969577df132b))
- **bigquery:** Properly display errors for BigQuery DBs ([#22349](https://github.com/apache/superset/issues/22349)) ([60a617e](https://github.com/apache/superset/commit/60a617eabab42acb3adad166c01af3965dafac18))
- **bootstrap-data:** always check flashes ([#22659](https://github.com/apache/superset/issues/22659)) ([73e53fa](https://github.com/apache/superset/commit/73e53fab7a5141881711a0269740627fd0527d30))
- bootstraping frontend ([#22720](https://github.com/apache/superset/issues/22720)) ([91850eb](https://github.com/apache/superset/commit/91850ebc571e31996d6670aceb00b2e0c92c4c91))
- both the CSS and className were expecting true/false strings ([#286](https://github.com/apache/superset/issues/286)) ([64c7937](https://github.com/apache/superset/commit/64c7937ac493de2eb6035b47d174920f63deee13))
- Box Plot Chart throws an error when the average (AVG) / SUM is being calculated on the Metrics ([#20235](https://github.com/apache/superset/issues/20235)) ([8638f59](https://github.com/apache/superset/commit/8638f59b4c7ebe954afe46bbfbd5880f1ae6afda))
- broken build due to failing unit tests ([#141](https://github.com/apache/superset/issues/141)) ([d6f3933](https://github.com/apache/superset/commit/d6f39335d82d0a3b7b71e8ae7ef08b074228139e))
- broken build due to file rename in vega-lite ([#37](https://github.com/apache/superset/issues/37)) ([1b4d911](https://github.com/apache/superset/commit/1b4d9117a8b202af9bb21140f9543a2d4c75ea61))
- broken build due to vega type ([#96](https://github.com/apache/superset/issues/96)) ([b652510](https://github.com/apache/superset/commit/b65251076504a39751997fde998e06d547d7be1a))
- Broken effect in useCSSTextTruncation hook ([#22324](https://github.com/apache/superset/issues/22324)) ([2731cba](https://github.com/apache/superset/commit/2731cbacbf5ce7220d114ac85186e27136926deb))
- bug due to name mangle when minifying ([46384d7](https://github.com/apache/superset/commit/46384d790a9d6314cb26b52bb44fb98f7321e471))
- build error ([#235](https://github.com/apache/superset/issues/235)) ([ac99cd0](https://github.com/apache/superset/commit/ac99cd0efbc92130484d4ac625faccd8d371a016))
- Build scripts ([#18201](https://github.com/apache/superset/issues/18201)) ([74a9fc1](https://github.com/apache/superset/commit/74a9fc14697c6cc077b3b9b1cfa3f7cbb22ca73a)), closes [#17714](https://github.com/apache/superset/issues/17714) [#17736](https://github.com/apache/superset/issues/17736) [#17990](https://github.com/apache/superset/issues/17990) [#17929](https://github.com/apache/superset/issues/17929) [#18036](https://github.com/apache/superset/issues/18036) [#18115](https://github.com/apache/superset/issues/18115) [#18128](https://github.com/apache/superset/issues/18128) [#18092](https://github.com/apache/superset/issues/18092) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18041](https://github.com/apache/superset/issues/18041) [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051) [#17593](https://github.com/apache/superset/issues/17593) [#18058](https://github.com/apache/superset/issues/18058) [#18059](https://github.com/apache/superset/issues/18059) [#18027](https://github.com/apache/superset/issues/18027) [#18045](https://github.com/apache/superset/issues/18045) [#18048](https://github.com/apache/superset/issues/18048) [#18073](https://github.com/apache/superset/issues/18073) [#17771](https://github.com/apache/superset/issues/17771) [#18060](https://github.com/apache/superset/issues/18060) [#17207](https://github.com/apache/superset/issues/17207) [#18087](https://github.com/apache/superset/issues/18087) [#18086](https://github.com/apache/superset/issues/18086) [#18082](https://github.com/apache/superset/issues/18082) [#18097](https://github.com/apache/superset/issues/18097) [#17807](https://github.com/apache/superset/issues/17807) [#18089](https://github.com/apache/superset/issues/18089) [#18100](https://github.com/apache/superset/issues/18100) [#18101](https://github.com/apache/superset/issues/18101) [#18105](https://github.com/apache/superset/issues/18105) [#18111](https://github.com/apache/superset/issues/18111) [#18083](https://github.com/apache/superset/issues/18083) [#17882](https://github.com/apache/superset/issues/17882) [#17843](https://github.com/apache/superset/issues/17843) [#17917](https://github.com/apache/superset/issues/17917) [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18081](https://github.com/apache/superset/issues/18081) [#18100](https://github.com/apache/superset/issues/18100) [#18133](https://github.com/apache/superset/issues/18133) [#18100](https://github.com/apache/superset/issues/18100) [#18116](https://github.com/apache/superset/issues/18116) [#18114](https://github.com/apache/superset/issues/18114) [#18108](https://github.com/apache/superset/issues/18108) [#18125](https://github.com/apache/superset/issues/18125) [#18152](https://github.com/apache/superset/issues/18152) [#18093](https://github.com/apache/superset/issues/18093) [#18130](https://github.com/apache/superset/issues/18130) [#18151](https://github.com/apache/superset/issues/18151)
- **build:** update webpack jsx paths ([#18685](https://github.com/apache/superset/issues/18685)) ([09141d2](https://github.com/apache/superset/commit/09141d2a8f8cb0096c9ff9d079786f056fb4de8c))
- Bulk update Spanish translations ([#16799](https://github.com/apache/superset/issues/16799)) ([0f3b630](https://github.com/apache/superset/commit/0f3b6304549c52dee6b6614446ba3ae09548f526))
- bump expected npm version in superset-websocket ([#21973](https://github.com/apache/superset/issues/21973)) ([3ea8f20](https://github.com/apache/superset/commit/3ea8f20f710ceb5e37e7c2147332536d4df31333))
- Bump FAB to 3.3.4 ([#17113](https://github.com/apache/superset/issues/17113)) ([d944503](https://github.com/apache/superset/commit/d94450387366647766840503feedf3487bab8c2c))
- bump FAB to 4.1.2 ([#20483](https://github.com/apache/superset/issues/20483)) ([c56e37c](https://github.com/apache/superset/commit/c56e37cda24ba70819d58501d1bfccc12db585cc))
- bump FAB to 4.3.0 ([#23184](https://github.com/apache/superset/issues/23184)) ([0082cf6](https://github.com/apache/superset/commit/0082cf6a020c0288e87d9d24ccfc60bc33a540c0))
- bump gecko and mozilla in Dockerfile ([#21995](https://github.com/apache/superset/issues/21995)) ([25be9ab](https://github.com/apache/superset/commit/25be9ab4bcce9c9dcec6a67366c70cf590de28ff))
- bump Helm chart release version ([#18751](https://github.com/apache/superset/issues/18751)) ([4ab0786](https://github.com/apache/superset/commit/4ab0786ab3917f601e2f33e0592517410d5328b1))
- bump Helm chart release version ([#18751](https://github.com/apache/superset/issues/18751)) ([#18758](https://github.com/apache/superset/issues/18758)) ([0994217](https://github.com/apache/superset/commit/099421770c8b6513d220b8d49333d0b9e7c025a8))
- bump isort to fix pre-commit CI ([#22907](https://github.com/apache/superset/issues/22907)) ([c9b7507](https://github.com/apache/superset/commit/c9b750793153cc29004cf5b40655e9e9a8a4d05e))
- **bump lunar version of datatable:** bump lunar version of datatable ([f814882](https://github.com/apache/superset/commit/f81488255003409f31a782a8ef22ccce6651874a))
- bump min version of elastic search ([#21274](https://github.com/apache/superset/issues/21274)) ([9c4ae2a](https://github.com/apache/superset/commit/9c4ae2ab7e323a71f44507259c9058faecdd725d))
- bump peer dependencies ([82503ce](https://github.com/apache/superset/commit/82503cedf3dd9f2d1d1a490419f83958ad45d602))
- bump peer dependencies ([#136](https://github.com/apache/superset/issues/136)) ([99c2e4c](https://github.com/apache/superset/commit/99c2e4c875091e2e656fdea539b76eae5eced571))
- Button resizing in horizontal filter bar ([#22365](https://github.com/apache/superset/issues/22365)) ([3a442e0](https://github.com/apache/superset/commit/3a442e09bf102a07e242554ee802b70c2de71ee0))
- cache key with guest token rls ([#19110](https://github.com/apache/superset/issues/19110)) ([2726816](https://github.com/apache/superset/commit/27268169e4c939fe34393f446d706e475277430b))
- cache warmup solution non legacy charts. ([#23012](https://github.com/apache/superset/issues/23012)) ([e755b4f](https://github.com/apache/superset/commit/e755b4f4171f8b6c45b93c8882f226c4d9f8df6d))
- cached common bootstrap Revert ([#21018](https://github.com/apache/superset/issues/21018)) ([#21419](https://github.com/apache/superset/issues/21419)) ([094400c](https://github.com/apache/superset/commit/094400c308b7e16fbabc9c4287054c298ff95899))
- **cache:** only warn about fallback cache for non-debug mode ([#19305](https://github.com/apache/superset/issues/19305)) ([7ca10fb](https://github.com/apache/superset/commit/7ca10fb770934f78f3df1cc3f47a6613c4c62c13))
- **cache:** respect default cache timeout on v1 chart data requests ([#21441](https://github.com/apache/superset/issues/21441)) ([05b97ff](https://github.com/apache/superset/commit/05b97fff4dd56a480405b4ada65de712b3028ecc))
- **caching:** support metastore cache for non-required caches ([#19369](https://github.com/apache/superset/issues/19369)) ([02308a6](https://github.com/apache/superset/commit/02308a6f78321e381502bbdfe49e20c5a8b47f11))
- can not correctly set force in store ([#19932](https://github.com/apache/superset/issues/19932)) ([24e4ab6](https://github.com/apache/superset/commit/24e4ab6a1fb8f3e2a17e355a4cbeea6969e72728))
- can't save dataset modal ([#19452](https://github.com/apache/superset/issues/19452)) ([6b136c2](https://github.com/apache/superset/commit/6b136c2bc9a6c9756e5319b045e3c42da06243cb))
- can't show duckdb table names in the "SEE TABLE SCHEMA" dropdown list ([#21495](https://github.com/apache/superset/issues/21495)) ([fdb4702](https://github.com/apache/superset/commit/fdb470233282730c87d17d1b1ab094d9980a21a2))
- can't sync temporal flag on virtual table ([#19366](https://github.com/apache/superset/issues/19366)) ([d954c3d](https://github.com/apache/superset/commit/d954c3df8604dc4b6a2459a17dd39450a1d57638))
- can't update package-lock.json ([#1442](https://github.com/apache/superset/issues/1442)) ([7f5249e](https://github.com/apache/superset/commit/7f5249eda0c8171792f203fe8a9fa27021398384))
- cannot delete a database if team member has SQL editor tab that uses that db ([#19243](https://github.com/apache/superset/issues/19243)) ([350f21d](https://github.com/apache/superset/commit/350f21d9d34525ae47d4b95a8b95918afa891f01))
- Cannot re-order metrics by drag and drop ([#19876](https://github.com/apache/superset/issues/19876)) ([e4fca89](https://github.com/apache/superset/commit/e4fca89217fc52a31053470f1b4c91a56ed3f4e9))
- catch error when masking encrypted extra is none ([#21570](https://github.com/apache/superset/issues/21570)) ([ef78ec6](https://github.com/apache/superset/commit/ef78ec6b30ece829e6fcf0a73d35dac343dcd70c))
- catch some potential errors on dual write ([#20351](https://github.com/apache/superset/issues/20351)) ([5a13782](https://github.com/apache/superset/commit/5a137820d0fd192fe8466e9448a59e327d13eeb5))
- categorical x-axis can't apply the label of column ([#21869](https://github.com/apache/superset/issues/21869)) ([9aa804e](https://github.com/apache/superset/commit/9aa804e070d9361df5e7dcde326ef16a769ac322))
- **celery cache warmup:** add auth and use warm_up_cache endpoint ([#21076](https://github.com/apache/superset/issues/21076)) ([04dd8d4](https://github.com/apache/superset/commit/04dd8d414db6a3cddcd073ad74acb2a4b7a53b0b))
- Ch31968query context ([#17600](https://github.com/apache/superset/issues/17600)) ([d7e3a60](https://github.com/apache/superset/commit/d7e3a601b6b06b81e109c1b222ece009c7be5193))
- change 401 response to a 403 for Security Exceptions ([#17768](https://github.com/apache/superset/issues/17768)) ([3aa1161](https://github.com/apache/superset/commit/3aa11614b552b439dbfdc6261413b3ac8ae0131a))
- change database database selector ([#18609](https://github.com/apache/superset/issues/18609)) ([9c08bc0](https://github.com/apache/superset/commit/9c08bc0ffc51f5fa779ff90ca061668b7b332ad7))
- Change dataset name affect data access role set to this dataset ([#20574](https://github.com/apache/superset/issues/20574)) ([9291ad5](https://github.com/apache/superset/commit/9291ad5d4ce1fb9a7d5301c06cf62efb1c355092))
- Change datatype of column type in BaseColumn to allow larger datatype names for complexed columns ([#17360](https://github.com/apache/superset/issues/17360)) ([e6db62c](https://github.com/apache/superset/commit/e6db62c469b9dcf391015e7bb768a73316d9efbc))
- Change default SECRET_KEY, improve docs and banner warning ([#17984](https://github.com/apache/superset/issues/17984)) ([412189f](https://github.com/apache/superset/commit/412189fcb73268ddd4829d2fdb8381c5e47595ce))
- Change downloadAsImage to use Superset theme ([#22011](https://github.com/apache/superset/issues/22011)) ([ba65f66](https://github.com/apache/superset/commit/ba65f668972666dcd32602b718c858622c87dab6))
- Change dropdown in Alert/Report modal to use javascript for conditional rendering instead of css ([#22360](https://github.com/apache/superset/issues/22360)) ([49f1cfc](https://github.com/apache/superset/commit/49f1cfc3f99478a3394fccddc50ab9bf7f5c4ae4))
- change example comment to match type ([#21772](https://github.com/apache/superset/issues/21772)) ([af34e45](https://github.com/apache/superset/commit/af34e454be5008de1113189f023990637ccbc224))
- change order of webdriver timeout checks ([#22698](https://github.com/apache/superset/issues/22698)) ([0a2fc9c](https://github.com/apache/superset/commit/0a2fc9cdde48b59dc177beecca26d5a6d4e15671))
- Change timer font to monospace ([#21876](https://github.com/apache/superset/issues/21876)) ([28c7636](https://github.com/apache/superset/commit/28c7636c591f39547f1201ff02da822e4a1bdf88))
- change type of slack error ([#22443](https://github.com/apache/superset/issues/22443)) ([7591acb](https://github.com/apache/superset/commit/7591acba548c7e501a1722a7a32660a1b6c619f7))
- change world map color scheme ([#215](https://github.com/apache/superset/issues/215)) ([bab5aeb](https://github.com/apache/superset/commit/bab5aeb97578ac8a49e2b51e129e0954926b335d))
- Changes the return type of get_permissions to be JSON friendly ([#20472](https://github.com/apache/superset/issues/20472)) ([a169b60](https://github.com/apache/superset/commit/a169b6071209c4f6681c95486127fc43884ff6d1))
- **chart & alert:** make to show metrics properly ([#19939](https://github.com/apache/superset/issues/19939)) ([55aef4d](https://github.com/apache/superset/commit/55aef4db3c85d54064498a0828a55afe97fa2b85))
- **chart & explore:** Show labels for `SliderControl` ([#19765](https://github.com/apache/superset/issues/19765)) ([dfbaba9](https://github.com/apache/superset/commit/dfbaba97c61c28ecde8ce134a1f6ec385467c383))
- **chart & filters:** make to padding between textarea and buttons ([#20026](https://github.com/apache/superset/issues/20026)) ([26c81a7](https://github.com/apache/superset/commit/26c81a70e7574e34c8351c825385dee272abe0cb))
- **chart & gallery:** make to add mixed time-series into recommended charts ([#20064](https://github.com/apache/superset/issues/20064)) ([f43dbc0](https://github.com/apache/superset/commit/f43dbc0dfdbd9ee21267229b566dfab8f59cd0db))
- **chart & heatmap:** make to fix that y label is rendering out of bounds ([#20011](https://github.com/apache/superset/issues/20011)) ([56e9695](https://github.com/apache/superset/commit/56e96950c17ec65ef18cedfb2ed6591796a96cfc))
- **chart & table:** make to allow highlight in case of numeric column ([#19938](https://github.com/apache/superset/issues/19938)) ([902ac05](https://github.com/apache/superset/commit/902ac053722ada89f817156a0af38ec03f27376c))
- **chart & table:** make to prevent dates from wrapping ([#20384](https://github.com/apache/superset/issues/20384)) ([1ae9353](https://github.com/apache/superset/commit/1ae935379fa8f1f5043205f218d7c1af93fae053))
- Chart download as image issue ([#19885](https://github.com/apache/superset/issues/19885)) ([c2999fd](https://github.com/apache/superset/commit/c2999fdc2217372f5b5499530cf25a08ca1ff945))
- chart empty state & result panel when multiple queries are executed display incorrectly ([#20816](https://github.com/apache/superset/issues/20816)) ([279ab95](https://github.com/apache/superset/commit/279ab954b1977f7729442733a31c67715476a620))
- chart id mapping in dashboard api ([#22179](https://github.com/apache/superset/issues/22179)) ([ac0ff78](https://github.com/apache/superset/commit/ac0ff78616119bd5d8bebbb2781e0ef3486c4d19))
- chart import error with virtual dataset ([#19782](https://github.com/apache/superset/issues/19782)) ([36d45d9](https://github.com/apache/superset/commit/36d45d9b98d57493ad9a29efb6a349902383897a))
- **chart-controls:** add a tooltip to span in ColumnOption, refactor RB Tooltips to Antd ([#914](https://github.com/apache/superset/issues/914)) ([83c0efe](https://github.com/apache/superset/commit/83c0efe0bc56eaeea7606afdb2500cf052c6b889))
- **chart-controls:** export/import DTTM_ALIAS properly ([#1035](https://github.com/apache/superset/issues/1035)) ([cd5a957](https://github.com/apache/superset/commit/cd5a95763dcbc49802903dd820b575c027fb187e))
- **chart-controls:** expose datasource for some controls ([#969](https://github.com/apache/superset/issues/969)) ([61c2f0d](https://github.com/apache/superset/commit/61c2f0d97dc486dbf2a979532a5f51efe8b35ed2))
- **chart-controls:** lower minOpacity in conditional formatting ([#1284](https://github.com/apache/superset/issues/1284)) ([128ec7e](https://github.com/apache/superset/commit/128ec7e0757725d4dca15ed2206b62e70479f055))
- **chart-controls:** temporal col placeholder for hybrid dnd ([#1317](https://github.com/apache/superset/issues/1317)) ([1411bee](https://github.com/apache/superset/commit/1411bee4221b7b1a3003bba5b89a0023c866adc1))
- **chart-controls:** transform emotion css prop ([#1036](https://github.com/apache/superset/issues/1036)) ([6f3f377](https://github.com/apache/superset/commit/6f3f377b43c9d13085cb70ec7474f3d05dcfb1f8))
- **chart-crud:** make to update Viz type Filter label to Chart type ([#19140](https://github.com/apache/superset/issues/19140)) ([b888341](https://github.com/apache/superset/commit/b8883410905a8212b9863a652c4d5a775e2a703b))
- **chart-list:** Hide 'Dashboards added to' column. ([#22475](https://github.com/apache/superset/issues/22475)) ([7a94f3a](https://github.com/apache/superset/commit/7a94f3afc611993324cb507b23a8f8c320ac76cd))
- **chart-table:** Scrollbar causing header + footer overflow ([#21064](https://github.com/apache/superset/issues/21064)) ([2679ee2](https://github.com/apache/superset/commit/2679ee2e46edf53ab07c19e1186ce2877e159303))
- **chart:** chart gets cut off on the dashboard ([#20315](https://github.com/apache/superset/issues/20315)) ([07b4a71](https://github.com/apache/superset/commit/07b4a7159dd293061b83c671ad64cc51c928a199))
- **chart:** deprecate persisting url_params ([#18960](https://github.com/apache/superset/issues/18960)) ([bd63a1b](https://github.com/apache/superset/commit/bd63a1bd98c1faf152205b3b862119a1c59b2f05))
- **chart:** ensure samples data is displayed ([#16900](https://github.com/apache/superset/issues/16900)) ([e6ff25c](https://github.com/apache/superset/commit/e6ff25c9802d5a8b523a966a66168b739a97b476))
- **chart:** import types from package, not monorepo ([#122](https://github.com/apache/superset/issues/122)) ([12ce877](https://github.com/apache/superset/commit/12ce87753038205580f07dc5323afdf70791dfd9))
- **charts list:** do not trigger ListViewError exception for anonymous users [#18210](https://github.com/apache/superset/issues/18210) ([#20171](https://github.com/apache/superset/issues/20171)) ([a813528](https://github.com/apache/superset/commit/a8135289584df2a816a98ccc1a4e1963fe3824e5))
- charts rerender with zero-height during tab switch ([#703](https://github.com/apache/superset/issues/703)) ([33d2fa1](https://github.com/apache/superset/commit/33d2fa155fbc0b3ead5c27c6f687a060ac8a56b3))
- **charts:** Hide Values greater than Max Y Axis Bound on Mixed Time Series with Bar series ([#21015](https://github.com/apache/superset/issues/21015)) ([bdcc0a9](https://github.com/apache/superset/commit/bdcc0a9bcfff476bcd43edc84f08423d8f415d50))
- **chart:** Time Series set showMaxLabel as null for time xAxis ([#20627](https://github.com/apache/superset/issues/20627)) ([9362e27](https://github.com/apache/superset/commit/9362e27ce2ace1803a975ab289fe2024fd195367))
- check embedded feature flag in request loader ([#18628](https://github.com/apache/superset/issues/18628)) ([e86f6bb](https://github.com/apache/superset/commit/e86f6bbabcc85f7005b6af85aabdfcf93acc6e82))
- check that imports are ZIPs ([#21875](https://github.com/apache/superset/issues/21875)) ([a88dfe2](https://github.com/apache/superset/commit/a88dfe24c77a07152837094d0a3063cb2702b988))
- check type of url before performing string actions ([#19569](https://github.com/apache/superset/issues/19569)) ([aa419b8](https://github.com/apache/superset/commit/aa419b811951a5d667fa721f295f7706bfad4680))
- CI is blocked by mypy checking ([#17213](https://github.com/apache/superset/issues/17213)) ([31085e3](https://github.com/apache/superset/commit/31085e34ce3d710ba1f143b3686ecf272b93c772))
- clean up chart metadata config ([#19143](https://github.com/apache/superset/issues/19143)) ([3d66912](https://github.com/apache/superset/commit/3d66912d89851f03c38803b29128a45d66b34cb6))
- Clean up custom css when dashboard unmounted ([#19342](https://github.com/apache/superset/issues/19342)) ([a88fa89](https://github.com/apache/superset/commit/a88fa8910d8da21748f6bf9fc43b07e802a36662))
- clean up unneeded Promise.resolves() ([#185](https://github.com/apache/superset/issues/185)) ([e1c635d](https://github.com/apache/superset/commit/e1c635d9e2f88f5bdc546357d87d61382c858b6b))
- clear 'delete' confirmation ([#17345](https://github.com/apache/superset/issues/17345)) ([43f4ab8](https://github.com/apache/superset/commit/43f4ab845a9d0c5b70a58b1596319b638081ce54))
- clear modal state after adding dataset ([#17044](https://github.com/apache/superset/issues/17044)) ([16a1df7](https://github.com/apache/superset/commit/16a1df75fcb5b2d0916abe648b717add36c43b3e))
- **clickhouse:** add clickhouse connect driver ([#23185](https://github.com/apache/superset/issues/23185)) ([7d014ad](https://github.com/apache/superset/commit/7d014ad9dd41a946bd730a0de71e9e33cbb812b9))
- **clickhouse:** add missing default format ([#23192](https://github.com/apache/superset/issues/23192)) ([a94e672](https://github.com/apache/superset/commit/a94e67243b3a7c5ad46a6216ae874fe44991a0e5))
- **cli:** fail CLI script on failed import/export ([#16976](https://github.com/apache/superset/issues/16976)) ([f0c0ef7](https://github.com/apache/superset/commit/f0c0ef70483ca8f45c9a15d8fd774cb37f7f95e3)), closes [#16956](https://github.com/apache/superset/issues/16956)
- **codecov:** improve core code coverage ([#20274](https://github.com/apache/superset/issues/20274)) ([5425504](https://github.com/apache/superset/commit/54255042310b9810c09fee25d475a4a1bc8f75de))
- Color consistency ([#1406](https://github.com/apache/superset/issues/1406)) ([57e90b1](https://github.com/apache/superset/commit/57e90b1c4bb5a7f48046b08c1be583bba88ce4fd))
- Color consistency ([#17089](https://github.com/apache/superset/issues/17089)) ([59a6502](https://github.com/apache/superset/commit/59a6502efe69feee587eaa97782935a2b857ae6c))
- column extra in import/export ([#17738](https://github.com/apache/superset/issues/17738)) ([37cc2c4](https://github.com/apache/superset/commit/37cc2c4d1568ac35d145a88ce8e27d8d2d108478))
- **column-header-tooltip:** make that hide the tooltip when the cloum… ([#18988](https://github.com/apache/superset/issues/18988)) ([741033e](https://github.com/apache/superset/commit/741033e87da40331d34257fbb38c0233f2a5a1ed))
- columns are lost when dashboard to explore ([#20699](https://github.com/apache/superset/issues/20699)) ([6b0bb80](https://github.com/apache/superset/commit/6b0bb80a6d3a423104f6802f767b27d382bb8f4b))
- Columns not passing properly from SQL Lab to Explore ([#20975](https://github.com/apache/superset/issues/20975)) ([d42cf4e](https://github.com/apache/superset/commit/d42cf4e4c92e44d8ae74993780ba22807979d9bd))
- commit yarn lock change for release ([800b8eb](https://github.com/apache/superset/commit/800b8ebd9896a08bfc47616d6e7154da534e14d1))
- compatible with window ([#426](https://github.com/apache/superset/issues/426)) ([2aae804](https://github.com/apache/superset/commit/2aae804ae534f17d9e15e4c615c0ec8ad550754d))
- **connection:** disable caching when on an insecure connection ([#194](https://github.com/apache/superset/issues/194)) ([fb4a3c2](https://github.com/apache/superset/commit/fb4a3c2ec55c8eade4f3a8a77d2afcb8e8a5c7b8)), closes [#193](https://github.com/apache/superset/issues/193)
- contribution operator meets nan value ([#18782](https://github.com/apache/superset/issues/18782)) ([987740a](https://github.com/apache/superset/commit/987740aa8dfff4bf771b587a40f1e12811453660))
- controls validator glitch ([#20623](https://github.com/apache/superset/issues/20623)) ([34e1336](https://github.com/apache/superset/commit/34e1336bca39b36f4cdbea143c5e0432b3072456))
- convert <NA> values to None instead of stringifying ([#22321](https://github.com/apache/superset/issues/22321)) ([1c20206](https://github.com/apache/superset/commit/1c202060573e1bf3b4ff02f38d00c9da951f35ed))
- convert scale config to data-ui's config correctly ([#115](https://github.com/apache/superset/issues/115)) ([0dfaff8](https://github.com/apache/superset/commit/0dfaff8c2a5df28b5521e8f379edaa87fbe08092))
- Convert TIMESTAMP\_\* to TIMESTAMP in Snowflake ([#22872](https://github.com/apache/superset/issues/22872)) ([3fd4718](https://github.com/apache/superset/commit/3fd4718ecb8be2012429bac8a6132f18d8ab7d4a))
- copying controls from Sankey to Sankey Loop ([#797](https://github.com/apache/superset/issues/797)) ([3c7320e](https://github.com/apache/superset/commit/3c7320eb100efc83ebd1c03585a6505352610d63))
- core coverage and add a coverage step in workflow ([#20784](https://github.com/apache/superset/issues/20784)) ([9c7bcfc](https://github.com/apache/superset/commit/9c7bcfceadb1101899d6c09330aa8e79330d656f))
- **core:** 'AND undefined' error in sql query ([#886](https://github.com/apache/superset/issues/886)) ([c0e4d82](https://github.com/apache/superset/commit/c0e4d82fe7cb158149753d04d2223ba3f6544f8e))
- **core:** clean up datatype logic ([#1102](https://github.com/apache/superset/issues/1102)) ([a622b1d](https://github.com/apache/superset/commit/a622b1d70e4d2fcae6eb5f57408ffa1484aa828e))
- **core:** don't add metrics to query object when in raw records mode ([#995](https://github.com/apache/superset/issues/995)) ([bc30636](https://github.com/apache/superset/commit/bc30636c917e38ce9bbaf15aa7a67887971b6e8d))
- **core:** missing translation ([#1144](https://github.com/apache/superset/issues/1144)) ([9227b1e](https://github.com/apache/superset/commit/9227b1e8489b74151d721a37abcabfd97d0aad09))
- **core:** remove height and width requirement on SuperChart ([#1176](https://github.com/apache/superset/issues/1176)) ([1bd2ff6](https://github.com/apache/superset/commit/1bd2ff6abdfd1dfbc9829ae0626e4adade5fea6b))
- correct exception level in log and add error message ([#22381](https://github.com/apache/superset/issues/22381)) ([c3a6327](https://github.com/apache/superset/commit/c3a6327ff05d63c1791a5fe99fc84878e426a346))
- Correct Ukraine map ([#19528](https://github.com/apache/superset/issues/19528)) ([cccec9a](https://github.com/apache/superset/commit/cccec9a6ab8eadea2ecaac6ee2094c8eb7d6b1f4))
- correction from mmsql to mssql in setup.py ([#20493](https://github.com/apache/superset/issues/20493)) ([5a2abfa](https://github.com/apache/superset/commit/5a2abfab65f5eac95a4376ab2319528ba82975f1))
- **cosmetic:** cannot find m-r-10 class in superset.less ([#20276](https://github.com/apache/superset/issues/20276)) ([f6f93aa](https://github.com/apache/superset/commit/f6f93aad37e6258ec27af1b39335d0de9163210d))
- **cosmetic:** Fix Datasource Modal Out Of Box ([#20237](https://github.com/apache/superset/issues/20237)) ([5c02ab7](https://github.com/apache/superset/commit/5c02ab7aafd3909cf341ad38c70a69076fb50d03))
- **cosmetic:** Limiting modal height ([#20147](https://github.com/apache/superset/issues/20147)) ([c8fe518](https://github.com/apache/superset/commit/c8fe518a7b55fe48545228dca6cf4f7c400f04e6))
- count(distinct column_name) in metrics ([#19842](https://github.com/apache/superset/issues/19842)) ([25e572a](https://github.com/apache/superset/commit/25e572a56e8cca1c9dd466fcd64ad610e86a385c))
- **cpq:** Add `schema` to Query.data() payload ([#22791](https://github.com/apache/superset/issues/22791)) ([88a5d98](https://github.com/apache/superset/commit/88a5d987da331e96dd94dee42937847dc0cfb0d4))
- Crash caused by numpy.vectorize ([#21936](https://github.com/apache/superset/issues/21936)) ([059e53a](https://github.com/apache/superset/commit/059e53a39f8c46051efba56d0866b25285fd6623))
- Create dataset polish/bug fix ([#22262](https://github.com/apache/superset/issues/22262)) ([6b20e74](https://github.com/apache/superset/commit/6b20e7444205498077014c0382dcccb485c49bf2))
- create property for schema_perm for `Query` ([#20871](https://github.com/apache/superset/issues/20871)) ([35184b2](https://github.com/apache/superset/commit/35184b299478edd44ee1c9d970f0d53ddc93ac86))
- create virtual table with exotic type ([#19714](https://github.com/apache/superset/issues/19714)) ([2b17ce2](https://github.com/apache/superset/commit/2b17ce2bd0d646196261dd02fd23080a6563e499))
- create-admin command in Makefile ([#17471](https://github.com/apache/superset/issues/17471)) ([7b68002](https://github.com/apache/superset/commit/7b68002eb143c6982870c12a153fdb2284faf172))
- **CRUD/listviews:** Errors with rison and search strings using special characters ([#18056](https://github.com/apache/superset/issues/18056)) ([c8df849](https://github.com/apache/superset/commit/c8df84985cf4f16f66287c493ba616b7d47a7c63))
- **CRUD:** make to fix the dancing when crud view is on hover ([#20051](https://github.com/apache/superset/issues/20051)) ([1c3c3ae](https://github.com/apache/superset/commit/1c3c3ae2ea1541b3719f303dd211e159adee3792))
- css template API response, less data ([#17980](https://github.com/apache/superset/issues/17980)) ([d35da1f](https://github.com/apache/superset/commit/d35da1fc733547533ceb883a35e7142069b3da26))
- css template permissions for gamma role ([#23083](https://github.com/apache/superset/issues/23083)) ([c39cf36](https://github.com/apache/superset/commit/c39cf36d2718133a57bbd37f54832d6cecfda414))
- **css:** transparent linear gradient not working in safari ([#20086](https://github.com/apache/superset/issues/20086)) ([ce01ce9](https://github.com/apache/superset/commit/ce01ce9e2f6859b3435e6ffb5425d1c29144442c))
- **csv-export:** pivot v2 with verbose names ([#18633](https://github.com/apache/superset/issues/18633)) ([fdbcbb5](https://github.com/apache/superset/commit/fdbcbb5c84f998666fd325ac14bc10d2cbdb2288))
- **csv:** Do not coerce persisted data integer columns to float ([#20760](https://github.com/apache/superset/issues/20760)) ([e1fd906](https://github.com/apache/superset/commit/e1fd90697c1ed4f72e7982629779783ad9736a47))
- **csv:** Ensure df_to_escaped_csv handles NULL ([#20151](https://github.com/apache/superset/issues/20151)) ([97ce920](https://github.com/apache/superset/commit/97ce920d493d126ddcff93b9e46cdde1c5c8bb69))
- custom SQL in Sort By Breaks Bar Chart ([#19069](https://github.com/apache/superset/issues/19069)) ([4f0074a](https://github.com/apache/superset/commit/4f0074a4aec7bf0868c3032ef00c4eb92930422a))
- custom SQL in the XAxis ([#21847](https://github.com/apache/superset/issues/21847)) ([0a4ecca](https://github.com/apache/superset/commit/0a4ecca9f259e2ee9cff27a879f2a889f876c7d7))
- **CustomFrame:** Resolves issue [#21731](https://github.com/apache/superset/issues/21731) where date range in explore throws runtime error ([#21776](https://github.com/apache/superset/issues/21776)) ([2258fbf](https://github.com/apache/superset/commit/2258fbf8789439f3223a67ecac24722bac415408))
- customize tab on heatmap chart is blank ([#23243](https://github.com/apache/superset/issues/23243)) ([d670cb6](https://github.com/apache/superset/commit/d670cb6a7f9f9777c4c63ea9796c1963bd79c97c))
- Cypress tests reliability improvements ([#19800](https://github.com/apache/superset/issues/19800)) ([3f0413b](https://github.com/apache/superset/commit/3f0413b8cbf54bac94ea52dd9d49f07f835e6f0a))
- **cypress:** disable flaky tests ([#22512](https://github.com/apache/superset/issues/22512)) ([630c129](https://github.com/apache/superset/commit/630c129e3e3e8a48c22d754e5d9943583ac0dae4))
- **cypress:** Fix failing/flaky E2E tests ([#22460](https://github.com/apache/superset/issues/22460)) ([21b56b2](https://github.com/apache/superset/commit/21b56b2d4993e2556e27a0849c91c570adf68d6c))
- **cypress:** flake cypress test case ([#17918](https://github.com/apache/superset/issues/17918)) ([eff4d38](https://github.com/apache/superset/commit/eff4d387de1501d21b4bd51e3a77541b425e79cc))
- **cypress:** make test chart time range deterministic ([#22567](https://github.com/apache/superset/issues/22567)) ([38d02a1](https://github.com/apache/superset/commit/38d02a10b5abbe325dfac4ecc227d6a2b5db5aaa))
- d3 scale types ([#246](https://github.com/apache/superset/issues/246)) ([f8bd7c6](https://github.com/apache/superset/commit/f8bd7c60651f5ce20aa98906cdab353bdc0a0135))
- **dao:** use explicit id filter ([#23246](https://github.com/apache/superset/issues/23246)) ([a336e68](https://github.com/apache/superset/commit/a336e685cd36bc985c1accb68da6d70cfbfc60c8))
- dashbaord unable to refresh ([#20220](https://github.com/apache/superset/issues/20220)) ([3d5ae62](https://github.com/apache/superset/commit/3d5ae6226bc5035fc86d3d3aa2cbc0202bede363))
- Dashboad export loading indicator ([#17613](https://github.com/apache/superset/issues/17613)) ([76cd7b0](https://github.com/apache/superset/commit/76cd7b048133989a6fb9777de53e2420af867df1))
- Dashboard access when DASHBOARD_RBAC is disabled ([#17511](https://github.com/apache/superset/issues/17511)) ([7602431](https://github.com/apache/superset/commit/76024313c6677824394813ba107bf442ac65974b))
- dashboard api cache decorator ([#21964](https://github.com/apache/superset/issues/21964)) ([c9470ca](https://github.com/apache/superset/commit/c9470cac91943599972d2854db747e3f4d25c206))
- Dashboard API flaky test ([#17611](https://github.com/apache/superset/issues/17611)) ([78c5d9a](https://github.com/apache/superset/commit/78c5d9ac277a3c9ba2ac72c0af30b15842e1fa4b))
- Dashboard Edit View Tab Headers Hidden when Dashboard Name is Long ([#19472](https://github.com/apache/superset/issues/19472)) ([154f1ea](https://github.com/apache/superset/commit/154f1ea8c92e38ba46a906d2121a85a1c9fac310))
- dashboard filter value is cleared when 2 similar dashboards opened in succession ([#21461](https://github.com/apache/superset/issues/21461)) ([59ca786](https://github.com/apache/superset/commit/59ca7861c0ec47a574c9f033a843ea1b726752f2))
- dashboard get by id or slug access filter ([#22358](https://github.com/apache/superset/issues/22358)) ([3761694](https://github.com/apache/superset/commit/3761694d72ba77332d9af68ec67fb178a25b1292))
- Dashboard import holding issue ([#19112](https://github.com/apache/superset/issues/19112)) ([e118b4d](https://github.com/apache/superset/commit/e118b4d733c6355127b6a1713c50a423168b5f42))
- **dashboard list:** do not show favorite star for anonymous users [#18210](https://github.com/apache/superset/issues/18210) ([#19409](https://github.com/apache/superset/issues/19409)) ([b8891ac](https://github.com/apache/superset/commit/b8891acf4a478da8883bd168272715023d6a3351))
- Dashboard report creation error handling ([#19859](https://github.com/apache/superset/issues/19859)) ([ad878b0](https://github.com/apache/superset/commit/ad878b07e48edb4059fbc6620accd2f7b993ae4b))
- dashboard standalone class not added when parameter set ([#16619](https://github.com/apache/superset/issues/16619)) ([5134c63](https://github.com/apache/superset/commit/5134c63ae289a583e52ddd692848461f227aec50))
- dashboard top level tabs edit ([#19722](https://github.com/apache/superset/issues/19722)) ([1c5d3b7](https://github.com/apache/superset/commit/1c5d3b73df3553d481fc59d89f94ad15193f5775))
- **dashboard-css:** make to load saved css template ([#19840](https://github.com/apache/superset/issues/19840)) ([4a835a4](https://github.com/apache/superset/commit/4a835a4299bbe90def232e376f919bc494b2d0a1))
- **dashboard-css:** make to stay custom css when reload ([#19084](https://github.com/apache/superset/issues/19084)) ([30c97ad](https://github.com/apache/superset/commit/30c97ad5bfe1dc9b074efc294c647c32fdd05fe0))
- **dashboard:** Add correct icon, label and badge to horizontal native filters dropdown button ([#22211](https://github.com/apache/superset/issues/22211)) ([435926b](https://github.com/apache/superset/commit/435926b89e08395f3017a32ea00f3de252fd4fb7))
- **dashboard:** Add runtime safety checks and improved tests ([#22457](https://github.com/apache/superset/issues/22457)) ([fad873c](https://github.com/apache/superset/commit/fad873c100cb35912308a5c700a2d49831506e3a))
- **dashboard:** Add safety checks to areas that throw runtime errors in dashboard filters ([#22648](https://github.com/apache/superset/issues/22648)) ([02e8511](https://github.com/apache/superset/commit/02e8511563767aa88fe83facbdaaba9a363ec1b8))
- **dashboard:** add toast if JSON metadata is invalid ([#20823](https://github.com/apache/superset/issues/20823)) ([557cf4b](https://github.com/apache/superset/commit/557cf4b739a8a7933f947a034812e295a0ae95cb))
- **dashboard:** Change horizontal filter bar divider truncation logic ([#22252](https://github.com/apache/superset/issues/22252)) ([91d1905](https://github.com/apache/superset/commit/91d19056cf236e78230228e26b3358060e626499))
- **dashboard:** Change text and icons in dashboard editmode ([#21305](https://github.com/apache/superset/issues/21305)) ([1d70079](https://github.com/apache/superset/commit/1d70079f7162fe42f83914fc0e63a265e5ac35bf))
- **dashboard:** chart doesn't resize when tab switch ([#22009](https://github.com/apache/superset/issues/22009)) ([309c064](https://github.com/apache/superset/commit/309c064cc808e7402cf1ec8370652045bab8fb43))
- **dashboard:** Chart stuck in loading state when when datasets request and chart request fail ([#19327](https://github.com/apache/superset/issues/19327)) ([a08f83b](https://github.com/apache/superset/commit/a08f83bc608f02ab29a2f1eb433d0405eea6f721))
- **dashboard:** Charts crashing when cross filter on adhoc column is applied ([#23238](https://github.com/apache/superset/issues/23238)) ([224f962](https://github.com/apache/superset/commit/224f962e4641bbfe6eff807745262fc03a0f9b92))
- **dashboard:** commit update once ([#17781](https://github.com/apache/superset/issues/17781)) ([3657cbe](https://github.com/apache/superset/commit/3657cbea7f5c37ccc06280b6c5230c1fdad76f9e))
- **Dashboard:** Copy dashboard with duplicating charts 500 error ([#17707](https://github.com/apache/superset/issues/17707)) ([dad8c20](https://github.com/apache/superset/commit/dad8c20af78f237cd068e29e1bbe6bbf37a238eb))
- **dashboard:** copy permalink to dashboard chart ([#19772](https://github.com/apache/superset/issues/19772)) ([e061955](https://github.com/apache/superset/commit/e061955fd077a9eab6f22f081aa02690801bfd3e))
- **dashboard:** dashboard actions fail when bad component id exists in children array ([#22323](https://github.com/apache/superset/issues/22323)) ([92bc641](https://github.com/apache/superset/commit/92bc6410671d3512e66303e80ce43a77a687adab))
- **dashboard:** dashboard doesn't load properly if it has tabs ([#21576](https://github.com/apache/superset/issues/21576)) ([24412e2](https://github.com/apache/superset/commit/24412e282d60fe2089fdc78d5d7b91f37344c41d))
- **dashboard:** Dashboard header overflowing in edit mode ([#21100](https://github.com/apache/superset/issues/21100)) ([d3684c0](https://github.com/apache/superset/commit/d3684c0937cf3f10654d8bba6a859e95d7dba7d8))
- **dashboard:** Don't show cross filters checkbox to users without write permissions ([#23237](https://github.com/apache/superset/issues/23237)) ([bac5bab](https://github.com/apache/superset/commit/bac5babff80c6aff49d68c0550517038c78bfe74))
- **dashboard:** don't show report modal for anonymous user ([#17106](https://github.com/apache/superset/issues/17106)) ([8756c90](https://github.com/apache/superset/commit/8756c9089ea765454cebcb8ab76fffddb86f916a))
- **dashboard:** drag preview not working ([#21432](https://github.com/apache/superset/issues/21432)) ([99628d3](https://github.com/apache/superset/commit/99628d3e84930e1a3751e9e8c9648a82d4f7ec1b))
- **dashboard:** Empty states overflowing small chart containers ([#19095](https://github.com/apache/superset/issues/19095)) ([70081a6](https://github.com/apache/superset/commit/70081a698fd423ab953d0943fc15ce88c24311ae))
- **dashboard:** Ensure correct positioning of "Drill to detail by" submenu ([#21894](https://github.com/apache/superset/issues/21894)) ([40f8254](https://github.com/apache/superset/commit/40f82545abf385f24a8681b6655ceb5042e1f3a7))
- **dashboard:** export & import chart description and certification details ([#22471](https://github.com/apache/superset/issues/22471)) ([efe6d22](https://github.com/apache/superset/commit/efe6d22d4a9c789d4262f197d01709a820332cf0))
- **dashboard:** Fix BigNumber causing dashboard to crash when overflowing ([#19688](https://github.com/apache/superset/issues/19688)) ([ee85466](https://github.com/apache/superset/commit/ee85466f2ed45d3f51a7609ef4e30cf087c033e4))
- **Dashboard:** Fix blinking native filters on zoom ([#18717](https://github.com/apache/superset/issues/18717)) ([db33953](https://github.com/apache/superset/commit/db339534ca4764d8c32934737a7fc54d82a4c775))
- **dashboard:** Fix dashboard's left side being cut off ([#22319](https://github.com/apache/superset/issues/22319)) ([b2d909f](https://github.com/apache/superset/commit/b2d909f529bb18f87dac88e8f4eccf6bb88de693))
- **dashboard:** fix default filter bar visibility + add docs ([#18741](https://github.com/apache/superset/issues/18741)) ([b7ecb14](https://github.com/apache/superset/commit/b7ecb14230383da679a3f61e38faa33cdb5014f7))
- **dashboard:** Fix filter card positioning for horizontal native filters ([#22212](https://github.com/apache/superset/issues/22212)) ([4b96474](https://github.com/apache/superset/commit/4b96474d6c9d405bc2dbf8e899d2b7486bf5f213))
- **dashboard:** Fix FilterWithDataMask typing and add null check ([#22260](https://github.com/apache/superset/issues/22260)) ([a642d12](https://github.com/apache/superset/commit/a642d126f8019d8f96cc206abfeda7ddc19eda7f))
- **dashboard:** Fix hover labels for horizontal overflow native filter dividers ([#22210](https://github.com/apache/superset/issues/22210)) ([93158ea](https://github.com/apache/superset/commit/93158ea6495d86950eb7faf7ad7c0968846fd96a))
- **dashboard:** fix Pivot Table V2 dragPreview in the dashboard ([#21539](https://github.com/apache/superset/issues/21539)) ([ab53d77](https://github.com/apache/superset/commit/ab53d77abacaf03e67c5a922c1e9dbd9a62fedbf))
- **dashboard:** Fix scroll behaviour in DashboardBuilderSidepane ([#20969](https://github.com/apache/superset/issues/20969)) ([6f3a555](https://github.com/apache/superset/commit/6f3a555e589cd8caee7ef6d5e667531b5e7ac43d))
- **dashboard:** Fix scrolling on "View as table" modal ([#21282](https://github.com/apache/superset/issues/21282)) ([875e9f8](https://github.com/apache/superset/commit/875e9f8a04464b0e79cfbda21d1e1ac7895970a5))
- **dashboard:** Focusing charts and native filters from filters badge ([#23190](https://github.com/apache/superset/issues/23190)) ([22bab71](https://github.com/apache/superset/commit/22bab714d6de0d3bb7e806dbec5187c96db37bf3))
- **dashboard:** Force native filters into vertical orientation when FF off ([#22265](https://github.com/apache/superset/issues/22265)) ([969c963](https://github.com/apache/superset/commit/969c9634f6a370cde8f0036af61d96375ec5c4c8))
- **dashboard:** import handle missing excluded charts ([#19088](https://github.com/apache/superset/issues/19088)) ([999c2c6](https://github.com/apache/superset/commit/999c2c68264cf7092aa1e98eef16f0a74b90cb64))
- **dashboard:** incorrect chart error with slow dataset api request ([#18852](https://github.com/apache/superset/issues/18852)) ([cdd4fa5](https://github.com/apache/superset/commit/cdd4fa58d0eea1aa27a00c4d2f2e94aa9e229fd9))
- **dashboard:** Incorrect scopes of cross filters ([#20927](https://github.com/apache/superset/issues/20927)) ([90e2d82](https://github.com/apache/superset/commit/90e2d82a38508938c7dcc92bad0087b529489fce))
- **dashboard:** Infinite load when filter with default first value is out of scope ([#23299](https://github.com/apache/superset/issues/23299)) ([81a1318](https://github.com/apache/superset/commit/81a13189b0407acdaae94e8fb4e037131c85c11f))
- **dashboard:** JS error when editing charts ([#21422](https://github.com/apache/superset/issues/21422)) ([1084bde](https://github.com/apache/superset/commit/1084bde2cc9600ec400505f7c11fac7d70f2f0c2))
- **dashboard:** make to filter the correct certified or non-certified… ([#19429](https://github.com/apache/superset/issues/19429)) ([3ccfa56](https://github.com/apache/superset/commit/3ccfa564d710480b55898d6e3ac42ccdd4ccdbcf))
- **dashboard:** make to show the correct owned objects ([#19223](https://github.com/apache/superset/issues/19223)) ([29cba2b](https://github.com/apache/superset/commit/29cba2b00cc4a68bf89740e34e3b107384616380))
- **dashboard:** make to show the correct owned objects ([#19372](https://github.com/apache/superset/issues/19372)) ([6d89ffb](https://github.com/apache/superset/commit/6d89ffbcb7533dc04093a66852aab26db0b5bc11))
- **dashboard:** Native filter on the dashboard with multiple tabs is displayed as out of scope ([#20693](https://github.com/apache/superset/issues/20693)) ([effa7d9](https://github.com/apache/superset/commit/effa7d9f5822c8b837877b23d4866d6d30de6267))
- **dashboard:** new created chart did not have high lighted effect when using the permalink of chart share in dashboard ([#20411](https://github.com/apache/superset/issues/20411)) ([c2f01a6](https://github.com/apache/superset/commit/c2f01a676c5e5eb53b98a6a609674c8342f8a0ac))
- **Dashboard:** Only apply changes when editing properties ([#17392](https://github.com/apache/superset/issues/17392)) ([0712be4](https://github.com/apache/superset/commit/0712be4c124ff90152d80c8bb11444415db4a7c7))
- **dashboard:** padding between rows within tabs ([#21323](https://github.com/apache/superset/issues/21323)) ([d994bab](https://github.com/apache/superset/commit/d994babe754a0a8fcf54d239cb4c558ccdf84b23))
- **dashboard:** Prevent XSS attack vector ([#21822](https://github.com/apache/superset/issues/21822)) ([ec20c01](https://github.com/apache/superset/commit/ec20c0104e6913cd9b2ab8bacae22eb25ae4cce1))
- **dashboard:** race condition between hydrating dashboard and set active tabs ([#17084](https://github.com/apache/superset/issues/17084)) ([3ad7483](https://github.com/apache/superset/commit/3ad7483dc19b75afe40df80eab10523c9a13485f))
- **dashboard:** Race condition when setting activeTabs with nested tabs ([#17007](https://github.com/apache/superset/issues/17007)) ([45908ff](https://github.com/apache/superset/commit/45908ff104efbd881fa1221278fba78989b43a52))
- **dashboard:** Remove bar at bottom of dashboard edit sidebar ([#21807](https://github.com/apache/superset/issues/21807)) ([95b4323](https://github.com/apache/superset/commit/95b43238a04e2b5c27bd6ab45dccfc23fab624a2))
- **dashboard:** Return columns and verbose_map for groupby values of Pivot Table v2 [ID-7] ([#17287](https://github.com/apache/superset/issues/17287)) ([fa51b32](https://github.com/apache/superset/commit/fa51b3234ed83a5f2910951f4cd2b1676a7b7d6d))
- **Dashboard:** Save empty label_colors in json_metadata ([#17462](https://github.com/apache/superset/issues/17462)) ([b2363e4](https://github.com/apache/superset/commit/b2363e4151f7a79d7235954366142db90f54c3c8))
- **dashboard:** scope of nativefilter not update ([#18048](https://github.com/apache/superset/issues/18048)) ([3b64563](https://github.com/apache/superset/commit/3b64563f3f9427e1d8f6f5f670f05e19bf9cb705))
- **dashboard:** scope status of filter not update in dashboard metadata ([#17945](https://github.com/apache/superset/issues/17945)) ([bd9e123](https://github.com/apache/superset/commit/bd9e1235a9e5b798ec1ba3a4d9c0660187bedeed))
- **dashboard:** scrolling table viz overlaps next chart ([#19121](https://github.com/apache/superset/issues/19121)) ([74910f9](https://github.com/apache/superset/commit/74910f99d8e1fe0c054780848927b4b54554cec9))
- **dashboard:** show correct roles for dashboard access dropdown ([#21549](https://github.com/apache/superset/issues/21549)) ([73429c6](https://github.com/apache/superset/commit/73429c6b2a63edc5a119eceafebdae2bc7431cd4))
- **Dashboard:** Sidepanel positioning ([#17200](https://github.com/apache/superset/issues/17200)) ([a2a457b](https://github.com/apache/superset/commit/a2a457b7efdd586af348c40bf9f099dcf6e1f20d))
- **dashboard:** Stop updating chart owners for charts removed from dashboard ([#21720](https://github.com/apache/superset/issues/21720)) ([684b888](https://github.com/apache/superset/commit/684b8888b1f60b5e9d440cdd07ecc6c116fcd542))
- **dashboard:** support input undo when editing chart title ([#18137](https://github.com/apache/superset/issues/18137)) ([a2bad75](https://github.com/apache/superset/commit/a2bad7551e4c17f7d7f6677d30e72caf0fe7667a))
- **dashboard:** update native filter info in metadata is not updated ([#17842](https://github.com/apache/superset/issues/17842)) ([ec48dd5](https://github.com/apache/superset/commit/ec48dd5c4083c6d0ad80a54bc382678f688677e2))
- **dashboard:** Update owners of dashboard list after editing ([#22383](https://github.com/apache/superset/issues/22383)) ([9f3c43f](https://github.com/apache/superset/commit/9f3c43f839f4f57981839151ce0a416973b3394d))
- **dashobard-edge-cutting:** make to be not cut without Filter ([#19080](https://github.com/apache/superset/issues/19080)) ([158396f](https://github.com/apache/superset/commit/158396fb6cce49a146d2c73b34c8eb3946163a90))
- **data-upload:** make to change err message ([#19430](https://github.com/apache/superset/issues/19430)) ([5fc0651](https://github.com/apache/superset/commit/5fc0651aaba9f2d7ed6605bea9cc44254cd6e02f))
- database modal crashed when use SQLAlchemy URI string ([#21342](https://github.com/apache/superset/issues/21342)) ([d130b4a](https://github.com/apache/superset/commit/d130b4a24f67a6440101f267d2d3640e34f4a154))
- database permissions on update and delete (avoid orphaned perms) ([#20081](https://github.com/apache/superset/issues/20081)) ([bfd2a3d](https://github.com/apache/superset/commit/bfd2a3d79f3d6d9c1da616d6d7904b48eccee28c))
- database schema selector on import data ([#21759](https://github.com/apache/superset/issues/21759)) ([91f0de0](https://github.com/apache/superset/commit/91f0de0c5dc81b1d644265c829d3b486fc1ba951))
- Database selector overflow ([#17369](https://github.com/apache/superset/issues/17369)) ([ed4a628](https://github.com/apache/superset/commit/ed4a628861728a6366bc165b291759986c843b76))
- **database-api:** allow search for all columns ([#19662](https://github.com/apache/superset/issues/19662)) ([3a231f6](https://github.com/apache/superset/commit/3a231f6b871cdab00b9dfb6192af76cf4cf9832a))
- **database-list:** hidden upload file button if no permission ([#21216](https://github.com/apache/superset/issues/21216)) ([0c43190](https://github.com/apache/superset/commit/0c43190e04edc182f8787cc88d9a6fcf7f86a9f7))
- **database-modal:** 'CTAS & CVAS SCHEMA' getting cut off ([#21004](https://github.com/apache/superset/issues/21004)) ([5c2a1f8](https://github.com/apache/superset/commit/5c2a1f85ffe675d36ddb906b4532428736235f02))
- **database-modal:** forms in database modal will be effected by external form values ([#20487](https://github.com/apache/superset/issues/20487)) ([932e304](https://github.com/apache/superset/commit/932e304ffbd14c46b2d816743c50c6aa7832fca2))
- **database-modal:** Refresh Data when importing ([#20523](https://github.com/apache/superset/issues/20523)) ([850f5fa](https://github.com/apache/superset/commit/850f5fa136aa2043a146fed0d5f58f6b2a9de96b))
- **database-modal:** Show a different placeholder text in Snowflake connection form ([#21172](https://github.com/apache/superset/issues/21172)) ([da3401a](https://github.com/apache/superset/commit/da3401a6987538fa69e791cd1096a4400972a424))
- **database:** Handle String errors in DatabaseModal ([#21709](https://github.com/apache/superset/issues/21709)) ([97273f5](https://github.com/apache/superset/commit/97273f59f867a9b329370b903e3616c24b43a5bc))
- **database:** make to allow the expose db as default in sqlalchemy form db ([#19337](https://github.com/apache/superset/issues/19337)) ([5ae7e54](https://github.com/apache/superset/commit/5ae7e5499966c9e01d5e42a61edf1ce94dd346fa))
- **database:** make to display validation error msg when all cases ([#20095](https://github.com/apache/superset/issues/20095)) ([d568999](https://github.com/apache/superset/commit/d568999592bb687d862dcfbf6f76c7ff7ee5610d))
- **databases:** GSheets and Clickhouse DBs are not allowed to upload files ([#21065](https://github.com/apache/superset/issues/21065)) ([b36bd3f](https://github.com/apache/superset/commit/b36bd3f083d0b2c125f472c23caa39b035ee5f27))
- Databricks views showing up as tables ([#20674](https://github.com/apache/superset/issues/20674)) ([2c5201f](https://github.com/apache/superset/commit/2c5201fa4bf31091d4fe4ce31f81b4a354f0cbfe))
- dataset after insert when db relation does not exist ([#21492](https://github.com/apache/superset/issues/21492)) ([7e2e8b8](https://github.com/apache/superset/commit/7e2e8b8ad95e868e40b6692653ead5a7e1d75b13))
- Dataset creation header is now uneditable and holds proper default values ([#21557](https://github.com/apache/superset/issues/21557)) ([df3b5a8](https://github.com/apache/superset/commit/df3b5a8305bc5339e094bf30025801e48c78951e))
- Dataset duplication fatal error ([#21358](https://github.com/apache/superset/issues/21358)) ([e3ddd0b](https://github.com/apache/superset/commit/e3ddd0bdd5f8f976e0a1733f6da29e33a2545c27))
- dataset exists error in save Dataset modal ([#21244](https://github.com/apache/superset/issues/21244)) ([a7fe485](https://github.com/apache/superset/commit/a7fe4850edef65128d12e20469e8a9b86ef08408))
- dataset extra import/export ([#17740](https://github.com/apache/superset/issues/17740)) ([c49545a](https://github.com/apache/superset/commit/c49545aec1ecddc6ee0e6a55597d8f26c2680009))
- dataset import error message ([#23025](https://github.com/apache/superset/issues/23025)) ([7bb9b81](https://github.com/apache/superset/commit/7bb9b810ee7dc9292b375cab28d8a559d030f87c))
- Dataset left panel now uses client side search ([#21770](https://github.com/apache/superset/issues/21770)) ([8f4415b](https://github.com/apache/superset/commit/8f4415bc831d234965001a476acc0c123448aee9))
- dataset modal doesn't work in dev mode ([#18658](https://github.com/apache/superset/issues/18658)) ([8212975](https://github.com/apache/superset/commit/82129753b07730a439fd88f26332a48692137044))
- dataset name change and permission change ([#21161](https://github.com/apache/superset/issues/21161)) ([3f2e894](https://github.com/apache/superset/commit/3f2e894af3dbb7a5c714de46240243b91d3d579c))
- Dataset search when creating a chart ([#19065](https://github.com/apache/superset/issues/19065)) ([fd154f7](https://github.com/apache/superset/commit/fd154f7ba63d41eae7a6774d72e85cd42e0d8a22))
- Dataset timeout ([#21516](https://github.com/apache/superset/issues/21516)) ([94ed427](https://github.com/apache/superset/commit/94ed4279c7d69a4f72fd5db5fe69eb27a55d24c9))
- **dataset:** avoid crash if database missing ([#19582](https://github.com/apache/superset/issues/19582)) ([db21351](https://github.com/apache/superset/commit/db2135109a2b41240547653c845854422adaa92b))
- **dataset:** handle missing database in migration ([#18948](https://github.com/apache/superset/issues/18948)) ([2bacedd](https://github.com/apache/superset/commit/2baceddbf16f087ae9247406f23579a6c6664fb6))
- **dataset:** handle missing python_type gracefully ([#19553](https://github.com/apache/superset/issues/19553)) ([d9343a4](https://github.com/apache/superset/commit/d9343a463980cf8b09ed394554fb54200027cc70))
- **dataset:** handle missing sqla uri in migration ([#20073](https://github.com/apache/superset/issues/20073)) ([4435e53](https://github.com/apache/superset/commit/4435e53901df4d64992a540694fbd3d5489c2220))
- **dataset:** modal sql editor error ([#17612](https://github.com/apache/superset/issues/17612)) ([b5d13d7](https://github.com/apache/superset/commit/b5d13d72f209132b6a334bf1978e96cbc06026d9))
- **datasets:** Fix property selection on JSON response ([#22944](https://github.com/apache/superset/issues/22944)) ([b410dbb](https://github.com/apache/superset/commit/b410dbb5dd510f1ed1dce6b2d0e114dda263eedb))
- **datasets:** Include expression and description in duplicated dataset columns ([#22943](https://github.com/apache/superset/issues/22943)) ([4b05a1e](https://github.com/apache/superset/commit/4b05a1eddd9d71811f0169d7b122cff26f7cc923))
- **datasets:** Stop showing alert when saving from query ([#21442](https://github.com/apache/superset/issues/21442)) ([605b692](https://github.com/apache/superset/commit/605b6920a65e0ef152a4c3f3d09246e5c596437d))
- datasource save, improve data validation ([#22038](https://github.com/apache/superset/issues/22038)) ([e33a086](https://github.com/apache/superset/commit/e33a08693bf789284d21f493074263712f17116f))
- datasourcedao datasource not found error ([#20725](https://github.com/apache/superset/issues/20725)) ([1d9d505](https://github.com/apache/superset/commit/1d9d505a6efa458d8b3b8a5743489bc1d03e1181))
- datatable crash when column is empty string ([#17303](https://github.com/apache/superset/issues/17303)) ([1f2a7a4](https://github.com/apache/superset/commit/1f2a7a40c4e64063c12dfe95bb39e2b6e06c3ec2))
- **datatable:** adding the consideration of padding ([#198](https://github.com/apache/superset/issues/198)) ([ddbd50f](https://github.com/apache/superset/commit/ddbd50f4feabe3da900050d5dc7a0a902ee5d6cd))
- datatype tracking issue on virtual dataset ([#20088](https://github.com/apache/superset/issues/20088)) ([74c5479](https://github.com/apache/superset/commit/74c5479926d89cebe5bad193123d8ecaff65f360))
- Dates alignment in Table viz ([#19668](https://github.com/apache/superset/issues/19668)) ([ed1309e](https://github.com/apache/superset/commit/ed1309e6bd9e8c0365794cf12bf4a272e540bbbd))
- datetime value should be seconds in sqlite ([#21113](https://github.com/apache/superset/issues/21113)) ([1afcdfb](https://github.com/apache/superset/commit/1afcdfb9fa47184f4ee54a57fa9d1985bb2ec6df))
- datetime.data in series ([#20618](https://github.com/apache/superset/issues/20618)) ([414cc99](https://github.com/apache/superset/commit/414cc99ca20a314f32c8796895955cf0a98b9785))
- **db & connection:** make to show/hide the password when only creating db connection ([#19694](https://github.com/apache/superset/issues/19694)) ([1d043e5](https://github.com/apache/superset/commit/1d043e53d09f444f15a083ebb961faff092147a5))
- DB connection modal connect bug ([#21299](https://github.com/apache/superset/issues/21299)) ([99a4f05](https://github.com/apache/superset/commit/99a4f05069d4b9de0b266a035423e3165408b4c3))
- **db-migration:** new_dataset_models_take_2 error on postgres ([#21417](https://github.com/apache/superset/issues/21417)) ([2e5270c](https://github.com/apache/superset/commit/2e5270cdb0486391037d225e808987c4b0573d2f))
- **db:** make to allow to show/hide the password when only creating ([#20186](https://github.com/apache/superset/issues/20186)) ([95b28fc](https://github.com/apache/superset/commit/95b28fc1346939017f8f6d867abeb12c7704d846))
- dbmodal test connection error timeout ([#20068](https://github.com/apache/superset/issues/20068)) ([5111011](https://github.com/apache/superset/commit/5111011de9de614e68c3c373dc9e938a9df3791f))
- **dbs-dropdown:** make to allow the search in supported db dropdown ([#19125](https://github.com/apache/superset/issues/19125)) ([8e7af79](https://github.com/apache/superset/commit/8e7af79aa9eadafe5def8dd7bac593f0b5f55776))
- **db:** set slices.query_context to MEDIUMTEXT for mysql ([#20779](https://github.com/apache/superset/issues/20779)) ([a64cdec](https://github.com/apache/superset/commit/a64cdec8c299cd572c12a271b695b1a83c521cee))
- **db:** Show the only db install guide when the db is already installed and error is existed while importing file. ([#20442](https://github.com/apache/superset/issues/20442)) ([23e62d3](https://github.com/apache/superset/commit/23e62d3782e75f1ed6c7baf0d511b4464249dbf3))
- **db:** use paginated_update for area chart migration ([#20761](https://github.com/apache/superset/issues/20761)) ([e2d3ea8](https://github.com/apache/superset/commit/e2d3ea831a7c634aeb2364a469a142c3514e4cf3))
- deactivate embedding on a dashboard ([#19626](https://github.com/apache/superset/issues/19626)) ([ae70212](https://github.com/apache/superset/commit/ae70212df31e4e483a9c316898419a55389fe619))
- deck.gl GeoJsonLayer Autozoom & fill/stroke options ([#19778](https://github.com/apache/superset/issues/19778)) ([d65b77e](https://github.com/apache/superset/commit/d65b77ec7dac4c2368fcaa1fe6e98db102966198))
- **deck.gl:** multiple layers map size is shrunk ([#18939](https://github.com/apache/superset/issues/18939)) ([2cb3635](https://github.com/apache/superset/commit/2cb3635256ee8e91f0bac2f3091684673c04ff2b))
- **deck.gl:** update view state on property changes ([#17720](https://github.com/apache/superset/issues/17720)) ([#17826](https://github.com/apache/superset/issues/17826)) ([97d918b](https://github.com/apache/superset/commit/97d918b6927f572dca3b33c61b89c8b3ebdc4376))
- **deckgl:** deckgl unable to load map ([#17851](https://github.com/apache/superset/issues/17851)) ([52f5dcb](https://github.com/apache/superset/commit/52f5dcb58eec7b188f4387b8781dcda4252a5680))
- Default temporal column in Datasource ([#21857](https://github.com/apache/superset/issues/21857)) ([fa67315](https://github.com/apache/superset/commit/fa67315f5b4769b2d739da23ef253fd504d610d9))
- **delete-modal:** Changed the color of the help text with grayScale.dark1 in DeleteModal ([#18786](https://github.com/apache/superset/issues/18786)) ([2d67d2f](https://github.com/apache/superset/commit/2d67d2f14e8143e2e1589d2e3cd9218fb06562ec))
- **demo:** add antd css and implement action hook ([#851](https://github.com/apache/superset/issues/851)) ([a6d8f57](https://github.com/apache/superset/commit/a6d8f57bceefe7cfbd8ff041960958d5a63a6e2c))
- **dependency:** update cryptography import ([#22744](https://github.com/apache/superset/issues/22744)) ([e18bf3f](https://github.com/apache/superset/commit/e18bf3f4496a387e86cb0ed8a685be4e5fa587e2))
- deprecate approve and request_access endpoint ([#22022](https://github.com/apache/superset/issues/22022)) ([358a4ec](https://github.com/apache/superset/commit/358a4ecedd13a20b3491ca9f536d773d87b6ca65))
- **dev-server run:** Check for environment tag not being undefined ([#21232](https://github.com/apache/superset/issues/21232)) ([b354f22](https://github.com/apache/superset/commit/b354f2265aab1e5569315364ecbcc314049aae5d))
- dict bug on QueryContextFactory ([#23093](https://github.com/apache/superset/issues/23093)) ([21dd160](https://github.com/apache/superset/commit/21dd1601bf2d59781b7540ef8dc1005819d588a2))
- **dimension:** set 0 width/height in createHiddenSvgNode ([#261](https://github.com/apache/superset/issues/261)) ([d6a46c1](https://github.com/apache/superset/commit/d6a46c1265c4558d9e09c579b3b708b65c4662ff))
- Direct link issue on report/list ([#20033](https://github.com/apache/superset/issues/20033)) ([9cf9f97](https://github.com/apache/superset/commit/9cf9f97a0cee74bc642e297a3bdb089e70fffe57))
- Disable filtering on wide result sets ([#18021](https://github.com/apache/superset/issues/18021)) ([343d3f8](https://github.com/apache/superset/commit/343d3f8f7a3bfb083164fba6afce40daec26fcaa))
- disable lazy import for line chart and box plot ([#82](https://github.com/apache/superset/issues/82)) ([f1164ae](https://github.com/apache/superset/commit/f1164aece052bcac7971f3098fcb62c5bb7b80bd))
- disable lint error ([#150](https://github.com/apache/superset/issues/150)) ([fa11638](https://github.com/apache/superset/commit/fa11638a80fb74c740d5e4890552d93fbb8a417e))
- disallow users from viewing other user's profile on config ([#21302](https://github.com/apache/superset/issues/21302)) ([c3f8417](https://github.com/apache/superset/commit/c3f841713989634ef4ba522b6a89e04ff89e2c0d))
- Display Error Messages in DB Connection Modal ([#22200](https://github.com/apache/superset/issues/22200)) ([aafb993](https://github.com/apache/superset/commit/aafb993ee2aa66398a693a68acf8b79e271ddeeb))
- dist bar will render value multi times ([#713](https://github.com/apache/superset/issues/713)) ([12bfdb2](https://github.com/apache/superset/commit/12bfdb2767d6f51ba3ebcf7626227afd63f7c558))
- **dnd&column:** make to fix the blank state issue when only one column select ([#19651](https://github.com/apache/superset/issues/19651)) ([c320c29](https://github.com/apache/superset/commit/c320c295dcf73f2575d371eaf0c2ba9f9eef6141))
- do not show migration toast if user not enable dashboard filter components ([#17440](https://github.com/apache/superset/issues/17440)) ([9f1bf1c](https://github.com/apache/superset/commit/9f1bf1cbd5cf5d58b72e2c686cecb59d006445cf))
- docker links ([#21797](https://github.com/apache/superset/issues/21797)) ([54f6fd6](https://github.com/apache/superset/commit/54f6fd6a82d0d66248bb4067f8811ebdcc01e0f9))
- **docker:** add ecpg to docker image ([#16566](https://github.com/apache/superset/issues/16566)) ([9cfce64](https://github.com/apache/superset/commit/9cfce649594ddddf25be1ef37ec3f37f155d67b0))
- **dockerfile:** fix "unhealthy" container state ([#22663](https://github.com/apache/superset/issues/22663)) ([1e3746b](https://github.com/apache/superset/commit/1e3746be215e5c2060b00d4c3196518f7c71697a))
- **docker:** Fixing ws docker push ([#22303](https://github.com/apache/superset/issues/22303)) ([2bdf22b](https://github.com/apache/superset/commit/2bdf22b21510861093ff63fb48c3e8b0b8148f88))
- **docker:** Make Gunicorn Keepalive Adjustable ([#20348](https://github.com/apache/superset/issues/20348)) ([86368dd](https://github.com/apache/superset/commit/86368dd406b9e828f31186a4b6179d24758a7d87))
- **docs:** add missing static files to build ([#18920](https://github.com/apache/superset/issues/18920)) ([1638090](https://github.com/apache/superset/commit/16380906d1ba0f98b486cfec4b4b16ebed5b8a14))
- **docs:** added missing timescale.png ([#21542](https://github.com/apache/superset/issues/21542)) ([e438c96](https://github.com/apache/superset/commit/e438c967c9fd3452d8f5aa811a43bce6ae8ffbd2))
- **docs:** bump broken packages ([#17800](https://github.com/apache/superset/issues/17800)) ([f396818](https://github.com/apache/superset/commit/f39681861615f592abb99f792d5d67523b12f0c9))
- **docs:** fix path of image for "Create New Chart" ([#18089](https://github.com/apache/superset/issues/18089)) ([5ce79ff](https://github.com/apache/superset/commit/5ce79ff8563b0610e21b2f11275438b23a74a81f))
- **docs:** prevent some symbols from being copied with ([#20480](https://github.com/apache/superset/issues/20480)) ([aa40680](https://github.com/apache/superset/commit/aa4068048a779359b21d2fa3e2c0328a0dd754ad))
- Don't allow duplicated tag values in the Select ([#19283](https://github.com/apache/superset/issues/19283)) ([d3ce398](https://github.com/apache/superset/commit/d3ce3984485de1cf16dbb214aa0063e5ac31b949))
- don't stringify extraJson in form ([#22171](https://github.com/apache/superset/issues/22171)) ([78a4bd6](https://github.com/apache/superset/commit/78a4bd6bb28ec895ee2df930fc3bb962fb7042ae))
- Drill to detail blocked by tooltip ([#22082](https://github.com/apache/superset/issues/22082)) ([3bc0865](https://github.com/apache/superset/commit/3bc0865d9071cdf32d268ee8fee4c4ad93680429))
- Drill to detail formatted val on TableChart ([#21719](https://github.com/apache/superset/issues/21719)) ([eb2a134](https://github.com/apache/superset/commit/eb2a1345a87dae968d1357279e6056a76988bd01))
- Drill to detail on values with comma ([#21151](https://github.com/apache/superset/issues/21151)) ([0bf4e56](https://github.com/apache/superset/commit/0bf4e56dc3e129d2b9239f055212249ba95521e4))
- drilling on the categorical xaxis on the mixed chart ([#21845](https://github.com/apache/superset/issues/21845)) ([f381154](https://github.com/apache/superset/commit/f38115489b09cb22bb77427bf73462784650cbaa))
- drilling on the categorical xaxis on the stacked barchart v2 ([#21844](https://github.com/apache/superset/issues/21844)) ([f41d0b0](https://github.com/apache/superset/commit/f41d0b0cbf47042bf510dc2b0b24b68e3fa11d37))
- **drill:** specify an SA URL parm of `impersonation_target` for drill+sadrill ([#19252](https://github.com/apache/superset/issues/19252)) ([85e330e](https://github.com/apache/superset/commit/85e330e94bc490d5a35fa0536f44e7189e299d20))
- drop the first level of MultiIndex ([#19716](https://github.com/apache/superset/issues/19716)) ([9425dd2](https://github.com/apache/superset/commit/9425dd2cac42f1a92f621848c469cadcc483e757))
- dropdown placement for cascading filters popover ([#17046](https://github.com/apache/superset/issues/17046)) ([824e62b](https://github.com/apache/superset/commit/824e62bd1f98c774d40ccf6f383ed67d13528b43))
- DropdownContainer items width calculation ([#22371](https://github.com/apache/superset/issues/22371)) ([1edfd7e](https://github.com/apache/superset/commit/1edfd7e1e154545381146fe46f29cbab7c6d1d85))
- DropdownContainer resize algorithm ([#22318](https://github.com/apache/superset/issues/22318)) ([aba3b81](https://github.com/apache/superset/commit/aba3b81e132cf2c92a79e5d381f01550481def9b))
- dual line chart color consistency for secondary y axis ([#18](https://github.com/apache/superset/issues/18)) ([7ea874c](https://github.com/apache/superset/commit/7ea874c9c0c8ec08465137d224498e83087d5c10))
- Duplicated numeric values in Select ([#21480](https://github.com/apache/superset/issues/21480)) ([b739e27](https://github.com/apache/superset/commit/b739e27f6dc4b159d766074e3e353a5546d00adb))
- Dynamic form to connect to Snowflake DB is not displaying authentication errors ([#19491](https://github.com/apache/superset/issues/19491)) ([634693b](https://github.com/apache/superset/commit/634693b2706e4f20479964e89da542661e9d4a77))
- edit pyarrow stringify to better handle emojis and accents ([#22881](https://github.com/apache/superset/issues/22881)) ([f2b61fc](https://github.com/apache/superset/commit/f2b61fca1537d0a80fafb5b313a365743cc41186))
- **elasticsearch:** time_zone setting does not work for cast datetime expressions ([#17048](https://github.com/apache/superset/issues/17048)) ([5a1c681](https://github.com/apache/superset/commit/5a1c68177ee68f78f8b31877f33f5bf93d5cc6c2))
- **embedded:** CSV download for chart ([#20261](https://github.com/apache/superset/issues/20261)) ([ab9f72f](https://github.com/apache/superset/commit/ab9f72f1a1359a59e64afd9e820d5823fd53b77b))
- **embedded:** download chart as image ([#19339](https://github.com/apache/superset/issues/19339)) ([0ad6925](https://github.com/apache/superset/commit/0ad692511ef998802cefe318f4488090ec344c44))
- **embedded:** Ensure guest token is passed to log endpoint ([#20647](https://github.com/apache/superset/issues/20647)) ([dfab521](https://github.com/apache/superset/commit/dfab521f50593b97fc778475498920552cad15dc))
- **embedded:** Referecing local variable response before initialization ([#20263](https://github.com/apache/superset/issues/20263)) ([2a45be3](https://github.com/apache/superset/commit/2a45be39968ad978748e541c08b8ab7c6daa1526))
- **embedded:** Retry when executing alert queries to avoid sending transient errors to users as alert failure notifications ([#20419](https://github.com/apache/superset/issues/20419)) ([818962c](https://github.com/apache/superset/commit/818962cc89aad34afdb8ea673908416d99631a06))
- **embedded:** third party cookies ([#20019](https://github.com/apache/superset/issues/20019)) ([3e36d4a](https://github.com/apache/superset/commit/3e36d4a0a1d9e1a1d2d009b6b8db1042d3d37d8b))
- **embed:** fix server error due to breaking change on flask-login ([#22462](https://github.com/apache/superset/issues/22462)) ([d5ecfbb](https://github.com/apache/superset/commit/d5ecfbb90147b7c22c816470e40e7b390f6ce65b))
- Empty Error Alert Modal ([#22186](https://github.com/apache/superset/issues/22186)) ([f885a18](https://github.com/apache/superset/commit/f885a18fecd38631ee5a8951620ce6b416a0edba))
- enable admin to edit dataset in explore ([#20613](https://github.com/apache/superset/issues/20613)) ([e1a918f](https://github.com/apache/superset/commit/e1a918f14112b257a470a0478fe77d2be3d795df))
- enable find text browser functionality inside SQL Lab editor ([#19061](https://github.com/apache/superset/issues/19061)) ([fd757c4](https://github.com/apache/superset/commit/fd757c4aa4138ad7da7f80585e4ae34c9c9631bc))
- ensure column name in description is string ([#20340](https://github.com/apache/superset/issues/20340)) ([f3b289d](https://github.com/apache/superset/commit/f3b289d3c333fe2351e9fbac6fa85b875cb1897c))
- Ensure consistent rollback logic ([#20811](https://github.com/apache/superset/issues/20811)) ([7a1aa79](https://github.com/apache/superset/commit/7a1aa79c52c7f5b69c222b8528ddd91f9ce44879))
- Ensure data cleanup in Cypress ([#21921](https://github.com/apache/superset/issues/21921)) ([a36ab71](https://github.com/apache/superset/commit/a36ab71a2793bd9dc51f3234b502ab43b0d304a0))
- ensure validation for db modal for googlesheets ([#19018](https://github.com/apache/superset/issues/19018)) ([bb17dec](https://github.com/apache/superset/commit/bb17decb0652bd2cfc64dda15e88bbccec2b8065))
- error alert levels again ([#17027](https://github.com/apache/superset/issues/17027)) ([153469d](https://github.com/apache/superset/commit/153469dba952db76d0d4a3793e5eb218eff294f6))
- error alerts again ([#17026](https://github.com/apache/superset/issues/17026)) ([ea70038](https://github.com/apache/superset/commit/ea700384b3746bd56279f6115b79ed3fcce284ec))
- error alerts js crash ([#17015](https://github.com/apache/superset/issues/17015)) ([03cdbac](https://github.com/apache/superset/commit/03cdbac8bbfc3a67332135e0a5d67cd36ffd2346))
- Error Message is cut off in alerts & reports log page ([#19444](https://github.com/apache/superset/issues/19444)) ([156ac7d](https://github.com/apache/superset/commit/156ac7dd79105bca47138d8906b50d01dc4f1cb6))
- Error when saving datasource from Explore ([#20749](https://github.com/apache/superset/issues/20749)) ([92f3621](https://github.com/apache/superset/commit/92f3621c754a4f3ddb99285aad273296be26567e))
- error_parsing ([#21946](https://github.com/apache/superset/issues/21946)) ([33fc578](https://github.com/apache/superset/commit/33fc57854d3e3b0702511e8960a09128591a27ec))
- escape bind-like strings in virtual table query ([#17111](https://github.com/apache/superset/issues/17111)) ([434b576](https://github.com/apache/superset/commit/434b5767c910d984e2b39655999f96afd00b84a6))
- eslint issues ([#198](https://github.com/apache/superset/issues/198)) ([e48b445](https://github.com/apache/superset/commit/e48b445bfe2771863516d3a7bf99b9cca2f749b9))
- exception thrown for charts without a x-axis ([#36](https://github.com/apache/superset/issues/36)) ([77396af](https://github.com/apache/superset/commit/77396afc7c96bb703b3ac8f70fa6ecabe538c580))
- exclude node_modules from ts tracking ([#18117](https://github.com/apache/superset/issues/18117)) ([9900e5a](https://github.com/apache/superset/commit/9900e5a6891929876b8fb7b5d29c25cd5b042626))
- Exclude SUPERSET_DEFAULT from the list of available color schemes ([#17018](https://github.com/apache/superset/issues/17018)) ([14b7f6c](https://github.com/apache/superset/commit/14b7f6cdbaad3a97aa24d234768a47752b700a11))
- **explore comma:** make that the comma can be added by removing it from token separators… ([#18926](https://github.com/apache/superset/issues/18926)) ([e7355b9](https://github.com/apache/superset/commit/e7355b9610d1371d1d3fca51c17d1999ca3ecef3))
- Explore long URL problem ([#18181](https://github.com/apache/superset/issues/18181)) ([4b61c76](https://github.com/apache/superset/commit/4b61c767425911551d276b59f1386b39bf319c5d)), closes [#2](https://github.com/apache/superset/issues/2)
- Explore scrolled down when navigating from dashboard ([#20962](https://github.com/apache/superset/issues/20962)) ([e4fc556](https://github.com/apache/superset/commit/e4fc5564ced1e2ad2f475629ce082ededd063ba9))
- explore warnings cleanup ([#20864](https://github.com/apache/superset/issues/20864)) ([5d107b8](https://github.com/apache/superset/commit/5d107b86abd1712571861e92f922ace57fb622ba))
- **explore-sqllab:** make that Timestamp column keep the Is temporal flagged when overwriting ([#19010](https://github.com/apache/superset/issues/19010)) ([4463586](https://github.com/apache/superset/commit/446358642f9e3e8522e366ccdac66e369acd5f20))
- **explore:** Adhoc columns don't display correctly ([#20802](https://github.com/apache/superset/issues/20802)) ([af1bddf](https://github.com/apache/superset/commit/af1bddffad930efc0583b638716980db6747bfbc))
- **explore:** Change copy of cross filters checkbox ([#19646](https://github.com/apache/superset/issues/19646)) ([4a5dddf](https://github.com/apache/superset/commit/4a5dddf52d8191b002fa11add6baaee26bc3b1a7))
- **explore:** Chart header icon paddings ([#19534](https://github.com/apache/superset/issues/19534)) ([bb96029](https://github.com/apache/superset/commit/bb96029c9de26d2c581ae498d235956cba6a7fd2))
- **explore:** chart link is broken without localStorage ([#21707](https://github.com/apache/superset/issues/21707)) ([35d9cb3](https://github.com/apache/superset/commit/35d9cb38a80849cd90524a2dfa3995490e219940))
- **explore:** Chart save modal displays error instead of failing silently ([#21920](https://github.com/apache/superset/issues/21920)) ([9d25453](https://github.com/apache/superset/commit/9d254534255e8938f93a7f613d9d254431f470db))
- **explore:** clean data when hidding control ([#19039](https://github.com/apache/superset/issues/19039)) ([0e29871](https://github.com/apache/superset/commit/0e29871493171b6a70f974d26f41b6797e5b5d5c))
- **explore:** Dashboard list is unsorted in save modal ([#21317](https://github.com/apache/superset/issues/21317)) ([3edc656](https://github.com/apache/superset/commit/3edc656f20ad794be8b892dad1f14c4f7deeca40))
- **explore:** datasource_type typo ([#22543](https://github.com/apache/superset/issues/22543)) ([c2ace8d](https://github.com/apache/superset/commit/c2ace8dacb70ef7200640f47d6862bbc85cab489))
- **explore:** deck.gl Multiple chart broken ([#17703](https://github.com/apache/superset/issues/17703)) ([bdc4e7a](https://github.com/apache/superset/commit/bdc4e7a322dc0adc441ce7052619a291a319de2b))
- **explore:** disable resize bar when the results area is collapsed ([#21366](https://github.com/apache/superset/issues/21366)) ([d28909d](https://github.com/apache/superset/commit/d28909d56c21c160a0140b87c4f268b1c4ea90f1))
- **explore:** don't apply time range filter to Samples table ([#17711](https://github.com/apache/superset/issues/17711)) ([b5b6ceb](https://github.com/apache/superset/commit/b5b6ceb1b32db987197ff252a8c495623beaa7d3))
- **explore:** Double divider if no permissions for adding reports ([#19777](https://github.com/apache/superset/issues/19777)) ([3663a33](https://github.com/apache/superset/commit/3663a33f14ef4bc3792e0a4089c3edd244f158ff))
- **explore:** Enable saving metric after changing title ([#23020](https://github.com/apache/superset/issues/23020)) ([98bf878](https://github.com/apache/superset/commit/98bf878d6ea263d4747cf4b7c23bc52555b177e7))
- **explore:** Filters with custom SQL disappearing ([#21114](https://github.com/apache/superset/issues/21114)) ([55304b0](https://github.com/apache/superset/commit/55304b02cd599827359cd13e3fe6ccb8581e0fd2))
- **Explore:** Fix cache timeout field not being saved and unit tests ([#18738](https://github.com/apache/superset/issues/18738)) ([cf8b57e](https://github.com/apache/superset/commit/cf8b57e80d80adc7f85a689e173a9fcc16e956bf))
- **explore:** fix chart embed code modal glitch ([#17843](https://github.com/apache/superset/issues/17843)) ([b083b34](https://github.com/apache/superset/commit/b083b3421f9186a014b751d223e3b3d9b2e2becb))
- **explore:** fix chart save when dashboard deleted ([#21497](https://github.com/apache/superset/issues/21497)) ([6644a84](https://github.com/apache/superset/commit/6644a84f79385ab11fdf1314293ef1fb284431ec))
- **explore:** Fix chart standalone URL for report/thumbnail generation ([#20673](https://github.com/apache/superset/issues/20673)) ([84d4302](https://github.com/apache/superset/commit/84d4302628d18aa19c13cc5322e68abbc690ea4d))
- **explore:** Fix datasource switch for table chart ([#21544](https://github.com/apache/superset/issues/21544)) ([954fc89](https://github.com/apache/superset/commit/954fc89871d26d4041247739d37b4ae2988069f6))
- **explore:** Fix generic X-axis time grain disappearing ([#21484](https://github.com/apache/superset/issues/21484)) ([324e997](https://github.com/apache/superset/commit/324e9979fa968b07d0be2628cac9119c492dc9b6))
- **Explore:** Force different color for same metrics in Mixed Time-Series ([#18603](https://github.com/apache/superset/issues/18603)) ([f565230](https://github.com/apache/superset/commit/f565230d8d8342f7a51b263d2a0865122c8f756e))
- **explore:** handle null control sections ([#20142](https://github.com/apache/superset/issues/20142)) ([e766f8c](https://github.com/apache/superset/commit/e766f8cb571fda1cef9aa398b146800bdbfaaeb1))
- **explore:** ignore temporary controls in altered pill ([#19843](https://github.com/apache/superset/issues/19843)) ([2dafff1](https://github.com/apache/superset/commit/2dafff12ef78082b8a0448e4b9e26ea6d21745ca))
- **explore:** Incorrect conversion from simple bool filter to custom sql ([#21293](https://github.com/apache/superset/issues/21293)) ([076af60](https://github.com/apache/superset/commit/076af6003a4b71f8c21e8191a595503bc491b0e7))
- **explore:** make SORT-Descending visible if Sort-by has value ([#17726](https://github.com/apache/superset/issues/17726)) ([d5768ab](https://github.com/apache/superset/commit/d5768ab649a70fd4f541ad4982498f622160b220))
- **explore:** make to convert null to N/A in view results ([#19316](https://github.com/apache/superset/issues/19316)) ([468c5ca](https://github.com/apache/superset/commit/468c5ca29a42a1b602de75eb4a2f0aed70dfdf2e))
- **explore:** make to fix the issue of explore error broken when see more/less ([#20282](https://github.com/apache/superset/issues/20282)) ([1e5cacd](https://github.com/apache/superset/commit/1e5cacda8f939874bc05832234f24579b7400c3a))
- **explore:** make to show the null value as N/A in view result ([#19603](https://github.com/apache/superset/issues/19603)) ([34323f9](https://github.com/apache/superset/commit/34323f9b5fcb1768f172d634e166230b6689f0da))
- **explore:** Mark time range dashboard filter with warning icon ([#22984](https://github.com/apache/superset/issues/22984)) ([5d550f4](https://github.com/apache/superset/commit/5d550f449aa791b32ab8dffe764086d461531abe))
- **explore:** Metric control breaks when saved metric deleted from dataset ([#17503](https://github.com/apache/superset/issues/17503)) ([7353a2b](https://github.com/apache/superset/commit/7353a2bd75ae5c76458615443f530a688e78db1c))
- **explore:** Metrics disappearing after removing metric from dataset ([#17201](https://github.com/apache/superset/issues/17201)) ([fa44325](https://github.com/apache/superset/commit/fa44325a368dab45f24204c2f8241a1c7afa3d86))
- **explore:** Persist URL params to form-data ([#21792](https://github.com/apache/superset/issues/21792)) ([b1bf25e](https://github.com/apache/superset/commit/b1bf25e98ceb1a2d52f102d22ebc3631b5278e71))
- **explore:** Pie chart label formatting when series is temporal ([#18216](https://github.com/apache/superset/issues/18216)) ([37430d4](https://github.com/apache/superset/commit/37430d404436b3d3833bfd9cbae602718c26c4a8))
- **Explore:** Pivot table V2 sort by failure with D&D enabled ([#18835](https://github.com/apache/superset/issues/18835)) ([eafe0cf](https://github.com/apache/superset/commit/eafe0cfc6f040670a9b35ebcd27f5c83eabe068e))
- **explore:** Prevent infinite rerenders when editing dataset ([#22219](https://github.com/apache/superset/issues/22219)) ([d1e576c](https://github.com/apache/superset/commit/d1e576cbd14a0fcc9d5a0a6e6c01e19ac52c44bb))
- **explore:** Prevent shared controls from checking feature flags outside React render ([#21315](https://github.com/apache/superset/issues/21315)) ([2285ebe](https://github.com/apache/superset/commit/2285ebe72ec4edded6d195052740b7f9f13d1f1b))
- **explore:** Prevent unnecessary series limit subquery ([#21154](https://github.com/apache/superset/issues/21154)) ([0726840](https://github.com/apache/superset/commit/0726840fb70cbd8c75f3499f08aee557640fd717))
- **Explore:** Remove changes to the properties on cancel ([#17184](https://github.com/apache/superset/issues/17184)) ([5491a4d](https://github.com/apache/superset/commit/5491a4d13ca9f8c1fb87887f756e2752bf679f18))
- **explore:** remove unnecessary parameters from the explore url ([#17123](https://github.com/apache/superset/issues/17123)) ([57f869c](https://github.com/apache/superset/commit/57f869cf2232f00d68251622a09a8646300c7739))
- **explore:** Replace url search params only if current page is Explore ([#20972](https://github.com/apache/superset/issues/20972)) ([9350bba](https://github.com/apache/superset/commit/9350bbafeeef0f4f3fa43a2068e0ea87afa55fca))
- **explore:** Restore missing dataset states ([#22693](https://github.com/apache/superset/issues/22693)) ([f5c404f](https://github.com/apache/superset/commit/f5c404fc51e9bcdee23fd4ec269f6083b283f74b))
- **explore:** Save button incorrectly disabled when adding new metric with dnd ([#23000](https://github.com/apache/superset/issues/23000)) ([7d5c86b](https://github.com/apache/superset/commit/7d5c86b44cb0a80fe81bf4693e1eea13132eb83e))
- **explore:** simple tab content input problem ([#17872](https://github.com/apache/superset/issues/17872)) ([07998fe](https://github.com/apache/superset/commit/07998fea68c762660333f1b98c34412b93132da3))
- **explore:** Small changes in metadata bar copy and tooltip placement ([#21952](https://github.com/apache/superset/issues/21952)) ([3c7a081](https://github.com/apache/superset/commit/3c7a0812819c26b963effae189efb50dddca60b4))
- **explore:** support saving undefined time grain ([#22565](https://github.com/apache/superset/issues/22565)) ([a7a4561](https://github.com/apache/superset/commit/a7a4561550e06bad11ef6d5a50af1ae1af173790))
- **explore:** Time column label not formatted when GENERIC_X_AXES enabled ([#21294](https://github.com/apache/superset/issues/21294)) ([c3a00d4](https://github.com/apache/superset/commit/c3a00d43d055224d4a31ea9315934a59b556eea7))
- **explore:** Time comparison in Mixed Chart in GENERIC_CHART_AXES not working ([#22945](https://github.com/apache/superset/issues/22945)) ([ed7b353](https://github.com/apache/superset/commit/ed7b3533bcc119b2240a613ebc56ace33f1e1002))
- **explore:** timestamp format when copy datatable to clipboard ([#17166](https://github.com/apache/superset/issues/17166)) ([860e481](https://github.com/apache/superset/commit/860e481a97c0e9db024e50761f672a718b4d8666))
- **explore:** unable to update linked charts ([#22896](https://github.com/apache/superset/issues/22896)) ([ad1ffbd](https://github.com/apache/superset/commit/ad1ffbd723702cf356d0fcac1a719f1a861a8497))
- **Explore:** Undefined owners ([#17167](https://github.com/apache/superset/issues/17167)) ([f580f6b](https://github.com/apache/superset/commit/f580f6bcba15a20c12ead5b3e6eef643cc0aa1d6))
- **explore:** Value undefined and Unhashable type errors ([#22207](https://github.com/apache/superset/issues/22207)) ([1809d2b](https://github.com/apache/superset/commit/1809d2b957394290cc55666b6e56c838fc8841c9))
- export superset theme props ([#391](https://github.com/apache/superset/issues/391)) ([c21ad5c](https://github.com/apache/superset/commit/c21ad5cee42d7bead3fe15ad962161bd6bb83ee1))
- exporting CSV can't apply pagination [#17861](https://github.com/apache/superset/issues/17861) ([#20178](https://github.com/apache/superset/issues/20178)) ([d4f320f](https://github.com/apache/superset/commit/d4f320f2a0efbcd05b688fbeda4351749fd512f6))
- **external-link:** change the external link in creating chart dashboard ([#18982](https://github.com/apache/superset/issues/18982)) ([37752ce](https://github.com/apache/superset/commit/37752cea9b3832b763f8fcb31e8895857cbb1955))
- extra column in metrics ([#17784](https://github.com/apache/superset/issues/17784)) ([30c0459](https://github.com/apache/superset/commit/30c0459808f773f2315100a2670e7d2ebf0f4f75))
- extract tables doesn't work with reserved keywords ([#17654](https://github.com/apache/superset/issues/17654)) ([8c25f2f](https://github.com/apache/superset/commit/8c25f2f356e488120d7ce3ff852a4b6b9a049b3b))
- **fab:** Fix regression on FAB dropdowns ([#22889](https://github.com/apache/superset/issues/22889)) ([a35aeb9](https://github.com/apache/superset/commit/a35aeb9d6b704b674f22f7e9c63422314131ed2b))
- failed mypy ([#17886](https://github.com/apache/superset/issues/17886)) ([ef57bd1](https://github.com/apache/superset/commit/ef57bd19024e2e8bac64d5475e74b7d0c215872d))
- failed samples should throw exception ([#20228](https://github.com/apache/superset/issues/20228)) ([1530c34](https://github.com/apache/superset/commit/1530c3479237e0540fe5dda7bb14fbfc8291c88c))
- failed timezone selector UT ([#17370](https://github.com/apache/superset/issues/17370)) ([33a8e87](https://github.com/apache/superset/commit/33a8e875139afcf463f68ec48f46c6abf01a9670))
- feature flags typing ([#15254](https://github.com/apache/superset/issues/15254)) ([69f9ee8](https://github.com/apache/superset/commit/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b))
- **file_upload:** Fix columnar and Excel upload forms ([#22249](https://github.com/apache/superset/issues/22249)) ([fb3e717](https://github.com/apache/superset/commit/fb3e7175733978cb34c6fe87dde367ad38bec6da))
- Filter dependencies are not being applied in default values ([#19698](https://github.com/apache/superset/issues/19698)) ([7bc9123](https://github.com/apache/superset/commit/7bc9123fe569c47ebb9eb049c96ff833478f7ded))
- filter indicator pointing issue on popover ([#18853](https://github.com/apache/superset/issues/18853)) ([c1ee75d](https://github.com/apache/superset/commit/c1ee75dd8efc27dac85805720107703aa5916a9c))
- Filter throwing an error on Embedded Dashboard ([#21157](https://github.com/apache/superset/issues/21157)) ([604e30b](https://github.com/apache/superset/commit/604e30b3f089f9592bef03381b0dea5dd5b70f78))
- **filter-indicator:** show filters handled by jinja as applied ([#17140](https://github.com/apache/superset/issues/17140)) ([d7834f1](https://github.com/apache/superset/commit/d7834f17e3e0da1404130018fea968f3e1a4001e))
- **filter-sets:** 404 on dashboard load ([#17777](https://github.com/apache/superset/issues/17777)) ([961766e](https://github.com/apache/superset/commit/961766e83393826087e8f187e0e1a5f45a750b86))
- FilterBox date endpoints to use [inclusive, exclusive) ([#18857](https://github.com/apache/superset/issues/18857)) ([324601e](https://github.com/apache/superset/commit/324601e0bb5b8a030e701a785ecb51b1d50e6d3b))
- Filtering db names while creating dataset is not working ([#17023](https://github.com/apache/superset/issues/17023)) ([be21143](https://github.com/apache/superset/commit/be211437ded95fe66f9901d00e9a2500ee7df7f6))
- fine tune time pivot chart tooltip ([#33](https://github.com/apache/superset/issues/33)) ([fa0d4ea](https://github.com/apache/superset/commit/fa0d4ea6bce7869e432070a2f4f5498f86a21e2c))
- Fix auto-reversion of label/title in the Metrics popover ([#19889](https://github.com/apache/superset/issues/19889)) ([7b5ba39](https://github.com/apache/superset/commit/7b5ba390296a423c83c36b2658956fd4b6c6180b))
- Fix chart title truncating when Chrome is zoomed out ([#20847](https://github.com/apache/superset/issues/20847)) ([46deb79](https://github.com/apache/superset/commit/46deb79f50971775abbf10c3b4bf646a752c11c7))
- fix comment in Docker environment files ([#22421](https://github.com/apache/superset/issues/22421)) ([b55ef5b](https://github.com/apache/superset/commit/b55ef5b514b4db93e2e275e67de2fed270436e84))
- Fix console errors about feature flags when running tests ([#21275](https://github.com/apache/superset/issues/21275)) ([742dbdd](https://github.com/apache/superset/commit/742dbdd0a5c0f0f75d56101b3551077ec06cd53f))
- **fix issues in superset:** fix issues in superset ([db4863d](https://github.com/apache/superset/commit/db4863d14be0ace246b2618c5c3c0b3f08e45276))
- Fix migration for removing time_range_endpoints 3 ([#19767](https://github.com/apache/superset/issues/19767)) ([7e92340](https://github.com/apache/superset/commit/7e92340c7085358940de5ff199b9cc919b35111f))
- fix nvd3 and histogram regressions and migrate control panels to TS ([#875](https://github.com/apache/superset/issues/875)) ([146f9a4](https://github.com/apache/superset/commit/146f9a4dfd42a94ae56a7d4a1a58ebab044eec0e))
- fix React.Fragment complaining about width/height ([#219](https://github.com/apache/superset/issues/219)) ([885e4e9](https://github.com/apache/superset/commit/885e4e978526dd917679b44029cf190f6fed9300))
- Fix regression introduced in [#20893](https://github.com/apache/superset/issues/20893) ([#21743](https://github.com/apache/superset/issues/21743)) ([3936e9e](https://github.com/apache/superset/commit/3936e9ed5fc41272fcd2d46ce847bf97dc1e0249))
- **fix types:** fix types ([66ce93c](https://github.com/apache/superset/commit/66ce93c2139d85015688eec7ead9698ded218ff7))
- fix warning in ssh tunnel ([#22912](https://github.com/apache/superset/issues/22912)) ([16800cc](https://github.com/apache/superset/commit/16800cc14cf9c1be4fbab74fa6df2b8e52dbc319))
- fix word cloud randomness ([#19977](https://github.com/apache/superset/issues/19977)) ([2e31021](https://github.com/apache/superset/commit/2e31021ecd6cc390fbe29d2837c026c6ac43903b))
- Fixed spacing in alert modal ([#22066](https://github.com/apache/superset/issues/22066)) ([1bab5b9](https://github.com/apache/superset/commit/1bab5b9eba4fe4e8cec1ae6d40c520cb2725bc21))
- Fixes error caused by step id placed in wrong location ([#21226](https://github.com/apache/superset/issues/21226)) ([5f76ac9](https://github.com/apache/superset/commit/5f76ac9001f10307d4e7446ad10372ad0c980e86))
- Fixes metric control when changing viz type to tree chart ([#1116](https://github.com/apache/superset/issues/1116)) ([a60771f](https://github.com/apache/superset/commit/a60771f5092e5e7125b3b8fab50a323f1e03bc00))
- Fixes Tabs style ([#20050](https://github.com/apache/superset/issues/20050)) ([fff9ad0](https://github.com/apache/superset/commit/fff9ad05d4823c897117508bd37e5aec4bb9f739))
- Fixes the instructions to publish to PyPi ([#20710](https://github.com/apache/superset/issues/20710)) ([4495868](https://github.com/apache/superset/commit/4495868b441f5a910596c191efdfe4d8a6f261f6))
- fixing tooltip for expanded area chart ([#134](https://github.com/apache/superset/issues/134)) ([7bf3587](https://github.com/apache/superset/commit/7bf358750bc6b20ce939b0a7081c8643a4ada15a))
- Flaky E2E tests ([#22152](https://github.com/apache/superset/issues/22152)) ([e990690](https://github.com/apache/superset/commit/e990690dde9d3a5dbc6eeacde651a06e3a8d1ce7))
- flaky test for dashboard changed on ([#19483](https://github.com/apache/superset/issues/19483)) ([a2e921b](https://github.com/apache/superset/commit/a2e921bd035ff1af54c22ecc8e4203af68c6baa8))
- flaky test when sync metadata ([#21306](https://github.com/apache/superset/issues/21306)) ([f71ee2e](https://github.com/apache/superset/commit/f71ee2e7bc89860f51f599a4403808f65c7430dc))
- flash message on database data upload forms ([#21761](https://github.com/apache/superset/issues/21761)) ([ba3275a](https://github.com/apache/superset/commit/ba3275a4d08ec170762e44b89148978222778785))
- **fonts:** Show the all the A's in our workspace correctly, not funky ([#20361](https://github.com/apache/superset/issues/20361)) ([df8bb46](https://github.com/apache/superset/commit/df8bb46ee26807a06e168b3a234e43b02bf658e1))
- for series limit comparison on explore with chart = Query ([#20989](https://github.com/apache/superset/issues/20989)) ([be4fbaf](https://github.com/apache/superset/commit/be4fbaf951e3ef2ae510410c20ee3991ec1531ba))
- Force configuration for SafeMarkdown component in Handlebars ([#22417](https://github.com/apache/superset/issues/22417)) ([ebaa949](https://github.com/apache/superset/commit/ebaa94974b2fca41d21f1c0972c288e086525687))
- **force to publish new version:** force to publish new version ([9468cfb](https://github.com/apache/superset/commit/9468cfb1618fdcfd628dabb188a9f64cf2f2d445))
- force_screenshot migration ([#17928](https://github.com/apache/superset/issues/17928)) ([4479fc9](https://github.com/apache/superset/commit/4479fc9222af9a46abf1d02f670da43533bae185))
- Form data was not being passed to save/update slice ([#22989](https://github.com/apache/superset/issues/22989)) ([c9b9b74](https://github.com/apache/superset/commit/c9b9b7404a2440a4c9d3173f0c494ed40f7fa2bd))
- forwardRef warnings in selects ([#20970](https://github.com/apache/superset/issues/20970)) ([6650076](https://github.com/apache/superset/commit/665007622845cf4303b50e57d11549a162dbbb1b))
- generator-superset public access ([a546210](https://github.com/apache/superset/commit/a546210bda824c222901c03225656e5de27b6425))
- **generator-superset:** add fixes to viz plugin generator ([#803](https://github.com/apache/superset/issues/803)) ([f9c7d35](https://github.com/apache/superset/commit/f9c7d3594deda9c7f8337bd206c0967f2307fa50))
- **generator-superset:** update plugin template to 0.17 standards ([#1013](https://github.com/apache/superset/issues/1013)) ([6e7e02e](https://github.com/apache/superset/commit/6e7e02ec014c6a167c98239ff46b919eda15952b))
- **generator:** add lockfile and fix styling issues ([#18073](https://github.com/apache/superset/issues/18073)) ([5bfe2d4](https://github.com/apache/superset/commit/5bfe2d47b0d46d6f561fdae6e803d6929ffe840b))
- **generator:** more cleanup to plugin framework ([#18027](https://github.com/apache/superset/issues/18027)) ([8dea7f5](https://github.com/apache/superset/commit/8dea7f500bea194f55c15c9f1511a35b2c328cd6))
- **generic-axes:** apply contribution before flatten ([#20077](https://github.com/apache/superset/issues/20077)) ([d5802f7](https://github.com/apache/superset/commit/d5802f78964a5027184ff9e7f6b78c14b04fd988))
- **generic-chart-axes:** apply time filter on all target column types ([#22238](https://github.com/apache/superset/issues/22238)) ([940a175](https://github.com/apache/superset/commit/940a17514fcb933e0c44364767eab5db40d3d20e))
- **generic-chart-axes:** set x-axis if unset and ff is enabled ([#20107](https://github.com/apache/superset/issues/20107)) ([0b3d3dd](https://github.com/apache/superset/commit/0b3d3dd4caa7f4c31c1ba7229966a40ba0469e85))
- getting default value in run-server.sh ([#20736](https://github.com/apache/superset/issues/20736)) ([5990ea6](https://github.com/apache/superset/commit/5990ea639e4f94b54d3109d14b1918a6f9770f14))
- GH issue 8669 NVD3 tooltip overflow ([#278](https://github.com/apache/superset/issues/278)) ([7786a41](https://github.com/apache/superset/commit/7786a418671c9e67bc984ee783502f1d2172a4f1))
- got one color wrong when copy pasting ([#624](https://github.com/apache/superset/issues/624)) ([2a28128](https://github.com/apache/superset/commit/2a28128f55d0d8e14655e5a4d5d03a4071289f42))
- gradient not working when y axis title has space ([#98](https://github.com/apache/superset/issues/98)) ([012f516](https://github.com/apache/superset/commit/012f5165da3cc1ebf9d66d4662a43ef5fd4adb05))
- gridlines ([75d54d2](https://github.com/apache/superset/commit/75d54d28955108f69167bea2ed8213d49d3591af))
- gsheets editing with dynamic forms ([#21710](https://github.com/apache/superset/issues/21710)) ([882bfb6](https://github.com/apache/superset/commit/882bfb67aed076b638b15a8c277ad9acd27649dc))
- Gsheets takes 2 clicks to save ([#21740](https://github.com/apache/superset/issues/21740)) ([aef6217](https://github.com/apache/superset/commit/aef6217a80d8b7d30120efe6502505edc01eb8d3))
- handle null params in [#18936](https://github.com/apache/superset/issues/18936) migration ([#19474](https://github.com/apache/superset/issues/19474)) ([7f85da6](https://github.com/apache/superset/commit/7f85da6e5b677bc80b4956719dbfe98192bf0db3))
- handle null values in time-series table ([#18039](https://github.com/apache/superset/issues/18039)) ([26dc600](https://github.com/apache/superset/commit/26dc600aff9dac446c0458270a2e1dbde0736e21))
- handle TIME column serialization ([#16869](https://github.com/apache/superset/issues/16869)) ([0d77f36](https://github.com/apache/superset/commit/0d77f36679a5714ea7402085988d4fb9867dd913))
- Handles disabled options on Select All ([#22830](https://github.com/apache/superset/issues/22830)) ([5e64211](https://github.com/apache/superset/commit/5e64211bdb0302315ee8f8e64f7a95180da594ad))
- heatmap errors with null data ([bfc5178](https://github.com/apache/superset/commit/bfc5178ce4e5c1ab4dcb70f45835b9e4d7f8b308))
- **heatmap:** add detail descriptions for heatmap 'normalize across' ([#20566](https://github.com/apache/superset/issues/20566)) ([d925b0c](https://github.com/apache/superset/commit/d925b0c8835fb1773b80298a3de1bdc368c88850))
- **helm:** allows extra top-level properties ([#18174](https://github.com/apache/superset/issues/18174)) ([568b8e1](https://github.com/apache/superset/commit/568b8e160fc8f3d2965ec3ac8a6d0fd6f20a860f))
- **helm:** fix postgresql values ([#19835](https://github.com/apache/superset/issues/19835)) ([f198f9f](https://github.com/apache/superset/commit/f198f9f007741d5098f176d770b1ab3245969332))
- **helm:** Fix support for ingress.ingressClassName ([#18619](https://github.com/apache/superset/issues/18619)) ([11d71d6](https://github.com/apache/superset/commit/11d71d69feeb13acae309fed9ca48d02d620b7be))
- **helm:** Fixing up chart and linting ([#22590](https://github.com/apache/superset/issues/22590)) ([01671b9](https://github.com/apache/superset/commit/01671b9d1b3a15c264bcfb9eced1776c70e293b5))
- **helm:** pin correct psycopg2 version ([#17999](https://github.com/apache/superset/issues/17999)) ([cdcdf11](https://github.com/apache/superset/commit/cdcdf11d0736f223aaf2a594323be869e0860169))
- **helm:** remove config overrides for CSRF ([#22716](https://github.com/apache/superset/issues/22716)) ([85da86d](https://github.com/apache/superset/commit/85da86dc81cf9f5c4791a817befd3d7961ce97ac))
- **helm:** service account apiVersion indent ([#17920](https://github.com/apache/superset/issues/17920)) ([48d5dc1](https://github.com/apache/superset/commit/48d5dc12fc9283ca6a84b24643f91320b2c676f6))
- **hex:** restore control panel to functioning state ([#42](https://github.com/apache/superset/issues/42)) ([55b3c79](https://github.com/apache/superset/commit/55b3c7933df677d9aaa3f95d2e8c8c25dddd528a))
- Hide Safari default tooltip ([#1283](https://github.com/apache/superset/issues/1283)) ([50a5032](https://github.com/apache/superset/commit/50a50324a705a275c19ca8446d28e5fba98c98bc))
- hide time_grain when x_axis value is undefined ([#21464](https://github.com/apache/superset/issues/21464)) ([ae6d2cf](https://github.com/apache/superset/commit/ae6d2cf18dbf0fec78e577b0cad1881940796b50))
- hiding HiddenControl inputs for real, to reduce bootstrap space consumption ([#15182](https://github.com/apache/superset/issues/15182)) ([6d66963](https://github.com/apache/superset/commit/6d66963489162640ac0b3b872b70cf7311c53da1))
- **histogram:** display correct percentile value instead of formula ([#18084](https://github.com/apache/superset/issues/18084)) ([28e729b](https://github.com/apache/superset/commit/28e729b835d8195f3610f7131504441803e43406))
- **hive:** Fix regression from [#21943](https://github.com/apache/superset/issues/21943) ([#22431](https://github.com/apache/superset/issues/22431)) ([4f9c2c8](https://github.com/apache/superset/commit/4f9c2c8165ab5d875c14c7cd8e8585c78d45900f))
- **hive:** Regression in [#21794](https://github.com/apache/superset/issues/21794) ([#22794](https://github.com/apache/superset/issues/22794)) ([0b31b2c](https://github.com/apache/superset/commit/0b31b2cb877ce629c4f346ea434cd02c4a8a469b))
- **hive:** Update \_latest_partition_from_df in HiveEngineSpec to work on tables with multiple indexes ([#14302](https://github.com/apache/superset/issues/14302)) ([bc855f4](https://github.com/apache/superset/commit/bc855f404023f1c6c89d6fdadd87a1d7ad417ca8))
- **hive:** Workaround for Python 3.9 s3 transfer issue ([#19887](https://github.com/apache/superset/issues/19887)) ([fdf48c6](https://github.com/apache/superset/commit/fdf48c63f1220607b9390104b04ba1d9fae7bfcf))
- **homepage:** make to show indicator when tab is choosen ([#20048](https://github.com/apache/superset/issues/20048)) ([ded9122](https://github.com/apache/superset/commit/ded9122ceb671b3c80a7ff5b9c76d5dce38f567c))
- **home:** Show home page tabs as pills instead of links ([#20257](https://github.com/apache/superset/issues/20257)) ([a833674](https://github.com/apache/superset/commit/a833674a8d3fff5c813d8204efb9350c4c89f7b6))
- Horizontal filter bar resizing ([#22286](https://github.com/apache/superset/issues/22286)) ([ead2834](https://github.com/apache/superset/commit/ead2834a771d515600d1fac1e20bd108d83c5fb9))
- hundreds lint warning ([#447](https://github.com/apache/superset/issues/447)) ([67e15d0](https://github.com/apache/superset/commit/67e15d011a23200abea2e1884150c45eb0db4586))
- **i18n:** greatly optimize Chinese translation ([#22036](https://github.com/apache/superset/issues/22036)) ([b381c20](https://github.com/apache/superset/commit/b381c20d5253c900ab88ff5b4d9786c57235b95e))
- **i18n:** improve Russian translation ([#22939](https://github.com/apache/superset/issues/22939)) ([a7bb14e](https://github.com/apache/superset/commit/a7bb14e433907f11b5e487b43927d4fc32a11350))
- ignore disabled series in stacked bar values ([#116](https://github.com/apache/superset/issues/116)) ([5b5086b](https://github.com/apache/superset/commit/5b5086b96a2df60871e2e31caca3f2cacb4e9c9c))
- implement extra filter logic ([#688](https://github.com/apache/superset/issues/688)) ([ea72983](https://github.com/apache/superset/commit/ea729831c30aa5706cc351b19ca431a1afe89ecb))
- import dash with missing immune ID ([#17732](https://github.com/apache/superset/issues/17732)) ([fceabf6](https://github.com/apache/superset/commit/fceabf6bc5f9eacb082f321185aa2c1cbe657a40))
- import dashboard stale filter_scopes ([#17741](https://github.com/apache/superset/issues/17741)) ([2633bcc](https://github.com/apache/superset/commit/2633bcccc372f0059a23cd5a8367a983f388dcb2))
- import DB errors ([#17748](https://github.com/apache/superset/issues/17748)) ([2a6e5e5](https://github.com/apache/superset/commit/2a6e5e5e5c0d35eae1879fb8d07586262d61a3ca))
- import should accept old keys ([#17330](https://github.com/apache/superset/issues/17330)) ([cb34a22](https://github.com/apache/superset/commit/cb34a226840bfc7770a9e4ac769c8e4c8e552303))
- import typeddict from extensions ([#17823](https://github.com/apache/superset/issues/17823)) ([0199104](https://github.com/apache/superset/commit/01991044f3b002a7cee744922fac98c35051d2f5))
- **import_datasources:** --sync flag works correctly ([#18046](https://github.com/apache/superset/issues/18046)) ([2dd64f9](https://github.com/apache/superset/commit/2dd64f9a93bff7e96182bb27a547b21a0a6ef48e))
- **import:** Add the error alert on failed database import ([#19673](https://github.com/apache/superset/issues/19673)) ([a2d34ec](https://github.com/apache/superset/commit/a2d34ec4b8a89723e7468f194a98386699af0bd7))
- **import:** error with disable_data_preview field ([#20932](https://github.com/apache/superset/issues/20932)) ([6ce027d](https://github.com/apache/superset/commit/6ce027d2f80476b2586adccde80083b689de1d07))
- **import:** Show the error message with db install guide when exist the importing db issue ([#20573](https://github.com/apache/superset/issues/20573)) ([c992ff3](https://github.com/apache/superset/commit/c992ff3be472738a34491d6e8ba8ba10167b2f8c))
- Improve big number time format UX ([#1320](https://github.com/apache/superset/issues/1320)) ([3276a65](https://github.com/apache/superset/commit/3276a653e3d92f2ed3ac7ce8cef210b68bc39c2a))
- improve cypress flakiness ([#19044](https://github.com/apache/superset/issues/19044)) ([002bd6e](https://github.com/apache/superset/commit/002bd6ed0a179821a81e68170a94aa1cbdce57de))
- improve get_db_engine_spec_for_backend ([#21171](https://github.com/apache/superset/issues/21171)) ([8772e2c](https://github.com/apache/superset/commit/8772e2cdb3b5a500812e7df12c133f9c9f2e6bad))
- Improve performance of CSV download ([#22929](https://github.com/apache/superset/issues/22929)) ([98f4e90](https://github.com/apache/superset/commit/98f4e909444ec5a72b0a6ad20ca25032e300bd26))
- improve the alerts & reports modal layout on small screens ([#19294](https://github.com/apache/superset/issues/19294)) ([32239b0](https://github.com/apache/superset/commit/32239b04aa84657f0485925749f4d65999f68477))
- incorporating ScheduleQueries into featureFlags ([#1020](https://github.com/apache/superset/issues/1020)) ([9559a69](https://github.com/apache/superset/commit/9559a69d3f7295a123bb75cf28a951f4b5c942c8))
- incorrect commit message ([#1443](https://github.com/apache/superset/issues/1443)) ([2029b37](https://github.com/apache/superset/commit/2029b37f2ed846529efb24307311cce2ef0b2f0b))
- **init:** Initialize \_jwt_cookie_name in AsyncQueryManager **init** ([#22314](https://github.com/apache/superset/issues/22314)) ([a2a578a](https://github.com/apache/superset/commit/a2a578ad9bdac2b637d68654518ad95ba767b9b6))
- interactiveGroupBy can works regardless to queryMode ([c86ffd2](https://github.com/apache/superset/commit/c86ffd26c54bc76b9be28ff1a7ea34ecda93210c))
- invalid dataset schema ([#20826](https://github.com/apache/superset/issues/20826)) ([3fb5c79](https://github.com/apache/superset/commit/3fb5c79d77f5c7fce001605bc5ba5a725b833c88))
- invalid float number format by json-bigint ([#21968](https://github.com/apache/superset/issues/21968)) ([3bb9187](https://github.com/apache/superset/commit/3bb91877974650ab3fa82539a30dc0e2a7045dd7))
- invalid float number format by json-bigint ([#21996](https://github.com/apache/superset/issues/21996)) ([3a02339](https://github.com/apache/superset/commit/3a023392e6bfec9660449b7b739530574d2a8238))
- invalid margin breaking chart ([#102](https://github.com/apache/superset/issues/102)) ([6d8ebc8](https://github.com/apache/superset/commit/6d8ebc8ac56d82e6df1bfc67cedddd4dcdb473fc))
- invalid metric should raise an exception ([#20882](https://github.com/apache/superset/issues/20882)) ([718bc30](https://github.com/apache/superset/commit/718bc3062e99cc44afbb57f786b5ca228c5b13fb))
- issue with sorting by multiple columns in a table ([#19920](https://github.com/apache/superset/issues/19920)) ([a45d011](https://github.com/apache/superset/commit/a45d011e74be7a52fee9b0e580187dd6f25509db))
- javascript file suffixes to extract ([#17673](https://github.com/apache/superset/issues/17673)) ([3350076](https://github.com/apache/superset/commit/3350076eea7517c0a0996586cf6260713224a442))
- **jest:** add superset-frontend to testRegex ([#18601](https://github.com/apache/superset/issues/18601)) ([cebff83](https://github.com/apache/superset/commit/cebff83d0ca0b6f556fd761ec43f58415cff8ddb))
- JS exception: Cannot read property "dispatch" of undefined ([#287](https://github.com/apache/superset/issues/287)) ([e3da248](https://github.com/apache/superset/commit/e3da2483180be783d75a27e190b20ea62223a230))
- JSON serializers ([#22029](https://github.com/apache/superset/issues/22029)) ([6bbf4f8](https://github.com/apache/superset/commit/6bbf4f8718ce9054d6c4c75b532576184e1c3ef6))
- **key_value:** use longblob on mysql ([#19805](https://github.com/apache/superset/issues/19805)) ([a1bd5b2](https://github.com/apache/superset/commit/a1bd5b283cc3b766d54c7c61d6487b4bce7ce916))
- **key-value:** lost url_params after long-url feature ([#18846](https://github.com/apache/superset/issues/18846)) ([4c16586](https://github.com/apache/superset/commit/4c165860674d1746d99e3e38bc6f7aa849b1601c))
- lazily create metadata ([#74](https://github.com/apache/superset/issues/74)) ([ede2e92](https://github.com/apache/superset/commit/ede2e92d97f0eee8e23fc7fd4a0567d1e2b49029))
- **legacy-plugin-chart-calendar:** fix timestamp timezone in Calendar ([#17664](https://github.com/apache/superset/issues/17664)) ([e660ea2](https://github.com/apache/superset/commit/e660ea25331b092ecb5976254abfc45a413f07d5))
- **legacy-plugin-chart-country-map:** Add Syria to control panel selection ([#1025](https://github.com/apache/superset/issues/1025)) ([20aee01](https://github.com/apache/superset/commit/20aee01215eafa51a3387f8c05eb7786db4fcc54))
- **legacy-plugin-chart-country-map:** Correct ISO 3166-2 county codes for Estonia ([#1344](https://github.com/apache/superset/issues/1344)) ([3d3da9d](https://github.com/apache/superset/commit/3d3da9d134d8ce2a77962f8991a760a4fc98fc5c))
- **legacy-plugin-chart-country-map:** fix broken map of Finland ([#1321](https://github.com/apache/superset/issues/1321)) ([370f4c0](https://github.com/apache/superset/commit/370f4c0ec571b82374f5e52503b132b854ffac65))
- **legacy-plugin-chart-country-map:** higher quality geojson and re-arrange controls ([#1045](https://github.com/apache/superset/issues/1045)) ([cbaec13](https://github.com/apache/superset/commit/cbaec13962502786313de2bb8c3538456a2c87e9))
- **legacy-plugin-chart-histogram:** fixes legend overflow ([#863](https://github.com/apache/superset/issues/863)) ([e4ebd82](https://github.com/apache/superset/commit/e4ebd828fe597b67592530f9e25180e3e1e700b0))
- **legacy-plugin-chart-horizon:** error on missing groupby ([#1100](https://github.com/apache/superset/issues/1100)) ([8d45a17](https://github.com/apache/superset/commit/8d45a179237f4b8508f2d1568d5b1edc1a962f97))
- **legacy-plugin-chart-horizon:** horizon chart should scroll when overflowing ([#180](https://github.com/apache/superset/issues/180)) ([7019442](https://github.com/apache/superset/commit/7019442a55adce54a3994ddf81b3bcdf6fe3c88f))
- **legacy-plugin-chart-map-box:** fix downloading map as image ([#965](https://github.com/apache/superset/issues/965)) ([e903988](https://github.com/apache/superset/commit/e9039884fb2204a14e0d9aa0a4bcb0eba29c17cb))
- **legacy-plugin-chart-nvd3:** disable bad linting rule ([#488](https://github.com/apache/superset/issues/488)) ([caf9a40](https://github.com/apache/superset/commit/caf9a4000e2d12306aa880a60c06a1f26dd41500))
- **legacy-plugin-chart-paired-t-test:** fix paired t-test table chart ([#961](https://github.com/apache/superset/issues/961)) ([4db9249](https://github.com/apache/superset/commit/4db92492cf11e082308171cfe428f03000db39bb))
- **legacy-plugin-chart-pivot-table:** fix displaying image inside rows ([#954](https://github.com/apache/superset/issues/954)) ([9357d2b](https://github.com/apache/superset/commit/9357d2bd822d940f0a3e58912a4521bfb2f8fa33))
- **legacy-plugin-chart-pivot-table:** formatting non-numeric values ([#695](https://github.com/apache/superset/issues/695)) ([4306386](https://github.com/apache/superset/commit/4306386946a04c536c57048a56fe9259b9283036))
- **legacy-plugin-chart-pivot-table:** pivot table chart string aggregation empty values ([#880](https://github.com/apache/superset/issues/880)) ([d3bc089](https://github.com/apache/superset/commit/d3bc0894c50aed825f127f0d09e4be9faed7cd2b))
- **legacy-plugin-chart-pivot-table:** remove nulls from table ([#839](https://github.com/apache/superset/issues/839)) ([6a42164](https://github.com/apache/superset/commit/6a42164a57cc6ecf44580b366dc238cbb036438d))
- **legacy-plugin-chart-sankey-loop:** clear element before redrawing ([#1223](https://github.com/apache/superset/issues/1223)) ([a4bc5ba](https://github.com/apache/superset/commit/a4bc5bae61ffe99fe3e6302db519510374941074)), closes [apache/superset#254](https://github.com/apache/superset/issues/254)
- **legacy-plugin-chart-sankey:** ensure tooltip position is within chart ([#1092](https://github.com/apache/superset/issues/1092)) ([556cd1c](https://github.com/apache/superset/commit/556cd1cc1f8ac1a3b7af1baa5f3e2db62c705e8a))
- **legacy-plugin-chart-sunburst:** chart broken when secondary metric is remove ([#20223](https://github.com/apache/superset/issues/20223)) ([ad72ea5](https://github.com/apache/superset/commit/ad72ea53a1adf802b072235edc0ebb6e7d93e748))
- **legacy-plugin-chart-sunburst:** linear color scheme not work when secondary metric is provided ([#20221](https://github.com/apache/superset/issues/20221)) ([9646591](https://github.com/apache/superset/commit/9646591d240516a7eb1515e70cfb8768352e4f30))
- **legacy-plugin-chart-sunburst:** move color scheme controls to own row ([#1263](https://github.com/apache/superset/issues/1263)) ([ca44905](https://github.com/apache/superset/commit/ca44905adc775f257f138f6bfd53730b9535c9d9))
- **legacy-plugin-chart-table:** parse numeric pageLength ([#522](https://github.com/apache/superset/issues/522)) ([6d04279](https://github.com/apache/superset/commit/6d04279dafb677ffe4024e1b18a777a791aa07d9))
- **legacy-plugin-chart-table:** time column formating ([#340](https://github.com/apache/superset/issues/340)) ([21f82d2](https://github.com/apache/superset/commit/21f82d2e6851315e60a92f2a2b81700b30376c49))
- **legacy-plugin-chart-treemap:** incorrect template literal ([#693](https://github.com/apache/superset/issues/693)) ([4eff7f6](https://github.com/apache/superset/commit/4eff7f68bb6b86f07e5eec574302e30363cb1f25))
- **legacy-plugin-world-map:** set useLegacyApi to true by default ([#444](https://github.com/apache/superset/issues/444)) ([5ff9f22](https://github.com/apache/superset/commit/5ff9f2220a694799357d9684a4f7aa48616b4e0b))
- **legacy-preset-chart-big-number:** example images got mixed up ([#1196](https://github.com/apache/superset/issues/1196)) ([c160a4a](https://github.com/apache/superset/commit/c160a4abde0aa46beaf41a133845850f80994f32))
- **legacy-preset-chart-nvd3:** bar chart unexpected error ([#1276](https://github.com/apache/superset/issues/1276)) ([adff009](https://github.com/apache/superset/commit/adff00922afae1202f8043cf269dd5dccf3c2f06))
- **legacy-preset-chart-nvd3:** custom yAxisFormat for contribution ([#808](https://github.com/apache/superset/issues/808)) ([e5226c9](https://github.com/apache/superset/commit/e5226c9757dcbfe549307d4e4ac9140220eb84fa))
- **legacy-preset-chart-nvd3:** dual line dnd control missing ([#1259](https://github.com/apache/superset/issues/1259)) ([072e494](https://github.com/apache/superset/commit/072e4949e8af4519d2a6996671f71a5c89468eb5))
- **legacy-preset-chart-nvd3:** fix tokenizer input type ([#1049](https://github.com/apache/superset/issues/1049)) ([5b8f9ef](https://github.com/apache/superset/commit/5b8f9efa22449296db7c6ff8b3f503ff79aab0c1))
- **legacy-preset-chart-nvd3:** make deep copy of queryData ([#855](https://github.com/apache/superset/issues/855)) ([b5f5bd1](https://github.com/apache/superset/commit/b5f5bd1182ffbffdc06767df5f66c55491ca18cf))
- **legacy-preset-chart-nvd3:** make wide bar chart scrollable ([#903](https://github.com/apache/superset/issues/903)) ([3170f24](https://github.com/apache/superset/commit/3170f24aff3efcbf20bbcb1144f57c02f704897b))
- **legacy-preset-chart-nvd3:** redraw bar values after legend change ([#7](https://github.com/apache/superset/issues/7)) ([444bb03](https://github.com/apache/superset/commit/444bb039b8eb28fa6f7f9ac9a595d66bf96ac435))
- **legacy-preset-chart-nvd3:** redraw markers after legend interaction ([#6](https://github.com/apache/superset/issues/6)) ([8c382ad](https://github.com/apache/superset/commit/8c382ade40c1f4321d83ad68cc30c74c23d4772b))
- **legacy-preset-chart-nvd3:** remove data fetching from multiline chart ([#899](https://github.com/apache/superset/issues/899)) ([368e198](https://github.com/apache/superset/commit/368e19805d19566f7d97ef4dfc0e1b0b5eafd2a4))
- **legacy-preset-chart-nvd3:** remove unnecessary control override ([#767](https://github.com/apache/superset/issues/767)) ([68c5beb](https://github.com/apache/superset/commit/68c5beb1b581ca7fa4061566a08baec17b13ea3a))
- **legacy-preset-chart-nvd3:** stacked bar charts labels ([#40](https://github.com/apache/superset/issues/40)) ([06bf56f](https://github.com/apache/superset/commit/06bf56fd8306d5502da2380501f9fb3e6636a6dc))
- **legacy-preset-chart-nvd3:** time compare and stacked area tooltips ([#850](https://github.com/apache/superset/issues/850)) ([778a7a5](https://github.com/apache/superset/commit/778a7a58650b9955b0b4f295c862e1a9db58a822))
- **legacy-preset-chart-nvd3:** tooltip's disappearance and stickiness ([#1](https://github.com/apache/superset/issues/1)) ([0ecf719](https://github.com/apache/superset/commit/0ecf719391416ca4ac7d28395ac6d053968d2b5c))
- **legacy-table-chart:** when data is empty ([#397](https://github.com/apache/superset/issues/397)) ([b51674e](https://github.com/apache/superset/commit/b51674e172947d1aa7d3ad850ae0308e712ae57d))
- **legacy-table:** adjust sort icon position ([#399](https://github.com/apache/superset/issues/399)) ([f45ab69](https://github.com/apache/superset/commit/f45ab69462191287a3fb578ee8e29f6e6a2d3db8))
- **legacy-table:** avoid React DOM ([#392](https://github.com/apache/superset/issues/392)) ([51f7667](https://github.com/apache/superset/commit/51f7667e8313e2f9c366fec0015f115aa27921cc))
- **legacy-table:** container height on tall headers ([#398](https://github.com/apache/superset/issues/398)) ([182d112](https://github.com/apache/superset/commit/182d112d866cce277eb6f192de0edd3300dce44d))
- legend types ([1c9c3ad](https://github.com/apache/superset/commit/1c9c3adbb15fc95e2aa003d414bca008db84af6b))
- lerna can't update package-lock.json ([#1432](https://github.com/apache/superset/issues/1432)) ([2443df9](https://github.com/apache/superset/commit/2443df97dfdccdb1c72da1b05102a5bc960b1fac))
- letter format of sort chart in dashboard edit ([#17003](https://github.com/apache/superset/issues/17003)) ([6dc00b3](https://github.com/apache/superset/commit/6dc00b3e3fb34c908578021deb20c5a525191fc4))
- Line Chart Annotation Info Update ([#19001](https://github.com/apache/superset/issues/19001)) ([ac2c66c](https://github.com/apache/superset/commit/ac2c66ccf60fa809f0db749ffa955c5822129ea0))
- line chart does not handle temporal field correctly ([#68](https://github.com/apache/superset/issues/68)) ([2430aa1](https://github.com/apache/superset/commit/2430aa1dbe23c31dfdf3b040e776fd128b441a83))
- line chart tooltip should use full datetime format ([#24](https://github.com/apache/superset/issues/24)) ([4bd482d](https://github.com/apache/superset/commit/4bd482dbc4702030c2b79aae3676950ba1490805))
- line chart tooltip when there is only one lien ([#103](https://github.com/apache/superset/issues/103)) ([de4c481](https://github.com/apache/superset/commit/de4c4816855503d5cce167f6d4253387610e65c4))
- Line not hidden after legend selection ([#204](https://github.com/apache/superset/issues/204)) ([126d409](https://github.com/apache/superset/commit/126d409b65fb4b9ebb79f06b399c064eed69a739))
- **line-chart:** Formula Annotations on Line Charts are broken ([#20687](https://github.com/apache/superset/issues/20687)) ([acdb271](https://github.com/apache/superset/commit/acdb271422b937314d7175ac85eeeac5ead3bc16))
- lint ([b98fecd](https://github.com/apache/superset/commit/b98fecd1bec948e02d6d9edab3ec2e31aaf25c5a))
- lint ([b1074fc](https://github.com/apache/superset/commit/b1074fc872a9072b285f32db0ca8c6d0d2493f81))
- lint ([f01d32d](https://github.com/apache/superset/commit/f01d32d6d132572e227bc4fd7b2b78b576973609))
- lint ([6ca9d8f](https://github.com/apache/superset/commit/6ca9d8f56dad18a5c9550ea996a6a1ce34e582f6))
- lint ([45a3dfe](https://github.com/apache/superset/commit/45a3dfe5b8f090aa3ad0b1fcde03ebbae4cc46d5))
- lint ([#144](https://github.com/apache/superset/issues/144)) ([8028c73](https://github.com/apache/superset/commit/8028c73ccecf3733d9702aaa5b874bb07aa4f3f3))
- lint ([#79](https://github.com/apache/superset/issues/79)) ([eefb1cf](https://github.com/apache/superset/commit/eefb1cf1b72cdbe079da77cbeedfb1abd3fb799b))
- lint errors ([#420](https://github.com/apache/superset/issues/420)) ([62b2a50](https://github.com/apache/superset/commit/62b2a50faf6d85a8302e3c9384a80e4d4595f326))
- **lint:** fix unnecessary type ignore ([#17555](https://github.com/apache/superset/issues/17555)) ([7429282](https://github.com/apache/superset/commit/74292829726ae9c47ca00889907e9421e8dc2b56))
- lints (mostly disabled) ([096454e](https://github.com/apache/superset/commit/096454e9cff12c85f66b14fdbf2144079c28db10))
- list css as side effects ([#57](https://github.com/apache/superset/issues/57)) ([e2f32cb](https://github.com/apache/superset/commit/e2f32cbf0e7f949db3aa2f901d155303e60bee0d))
- **listview:** add nowrap to view mode container ([#18246](https://github.com/apache/superset/issues/18246)) ([8b0634c](https://github.com/apache/superset/commit/8b0634c9edb2919a9e4d03ae81c700368ac0e371))
- Loading indicator of table and schema selectors ([#17040](https://github.com/apache/superset/issues/17040)) ([7c1c89c](https://github.com/apache/superset/commit/7c1c89c94b900ffe3de75c9cb314a75a3b559801))
- local warning in the frontend development ([#17727](https://github.com/apache/superset/issues/17727)) ([142b5bc](https://github.com/apache/superset/commit/142b5bc506c81847e503e76e498c06e8321dffb1))
- **localization:** pybabel doesn't extract plural forms from frontend ([#22507](https://github.com/apache/superset/issues/22507)) ([64496e8](https://github.com/apache/superset/commit/64496e8c8881900c2bfd62f8a78aff1311bf05ac))
- logger message ([#20714](https://github.com/apache/superset/issues/20714)) ([c70d102](https://github.com/apache/superset/commit/c70d102b73704b301d1d2902680cfbf1c0dda605))
- logging warning on dataframe (don't use python's warnings) ([#18111](https://github.com/apache/superset/issues/18111)) ([5fb8b0a](https://github.com/apache/superset/commit/5fb8b0a13a3b50f279007d1934356dcc85298cb5))
- Logic for showing extension in Global Nav ([#19158](https://github.com/apache/superset/issues/19158)) ([181ecf4](https://github.com/apache/superset/commit/181ecf450990c5102c1e9a077dfe7455073fb70d))
- login button does not render ([#19685](https://github.com/apache/superset/issues/19685)) ([2ba484f](https://github.com/apache/superset/commit/2ba484fe43880ee09d6e61d778ad467ab7b0e459))
- Logo resizing on page load ([#19307](https://github.com/apache/superset/issues/19307)) ([d10a3d8](https://github.com/apache/superset/commit/d10a3d8bbad9efec53b372c1962cf8e1eab9d7ce))
- lost renameOperator in mixed timeseries chart ([#19802](https://github.com/apache/superset/issues/19802)) ([108a2a4](https://github.com/apache/superset/commit/108a2a4eafc3150f7b7c33ed734e843a5d5c9f62))
- make a new entrypoint for deprecated postgres dialect ([#20895](https://github.com/apache/superset/issues/20895)) ([4d29d16](https://github.com/apache/superset/commit/4d29d16b64c43bb40b8f399b90296a12e7f66426))
- make all filter operators uppercase ([#378](https://github.com/apache/superset/issues/378)) ([1917d84](https://github.com/apache/superset/commit/1917d84c7abb3efd00fcf75cb54e5921b3ddf98c))
- Make cte_alias a property of db engine spec ([#22947](https://github.com/apache/superset/issues/22947)) ([9dfaad7](https://github.com/apache/superset/commit/9dfaad772d2ac42c35519a55e7b3df27ca03b072))
- make database connection modal ace fields uncontrolled ([#22350](https://github.com/apache/superset/issues/22350)) ([608ffcb](https://github.com/apache/superset/commit/608ffcbfb9d91aa44cdca77cc1b08fcb610209b8))
- make line chart query operate in time series mode ([#71](https://github.com/apache/superset/issues/71)) ([911382f](https://github.com/apache/superset/commit/911382f152dd280b7d30379d4c99bc8a1f8a02a0))
- make max-requests and max-requests-jitter adjustable ([#20733](https://github.com/apache/superset/issues/20733)) ([8832410](https://github.com/apache/superset/commit/883241070f5dd717d188b69dd681af127656283b))
- make pivot table handle null string ([#23](https://github.com/apache/superset/issues/23)) ([d8e8dc4](https://github.com/apache/superset/commit/d8e8dc4111c7137584a29a03f1165e64c4e50349))
- make sure that gsheets db connection form loads properly ([#22361](https://github.com/apache/superset/issues/22361)) ([368e7e6](https://github.com/apache/superset/commit/368e7e6b0855b5335cf1f45d935daa794b4eae34))
- Make the scrollbar appear inside the table ([#1310](https://github.com/apache/superset/issues/1310)) ([fdcc079](https://github.com/apache/superset/commit/fdcc079e18c0e58098796ed635d0435e8f2c4870))
- make translation module type check correctly ([#140](https://github.com/apache/superset/issues/140)) ([a35f88a](https://github.com/apache/superset/commit/a35f88a69e78231411fadb325715edadf72e701d))
- Making chart update more truthful ([#19877](https://github.com/apache/superset/issues/19877)) ([35db7fb](https://github.com/apache/superset/commit/35db7fb6c52465f91452a6ac1f540f4d64413908))
- making crossFilter.chartsInScope optional ([#21030](https://github.com/apache/superset/issues/21030)) ([0042ade](https://github.com/apache/superset/commit/0042ade66f08530e31b7ded7143017ded46b3a3b))
- making location of sorting arrows in Table more consistent. ([#1124](https://github.com/apache/superset/issues/1124)) ([ade57cf](https://github.com/apache/superset/commit/ade57cf9910822ee3ed04435277da6a740c2adc4))
- Making viz components respect D3 Format from metric ([#280](https://github.com/apache/superset/issues/280)) ([652e430](https://github.com/apache/superset/commit/652e43021f9fb77de7a34de0f047001cbbb46671))
- memoize primitives ([#19930](https://github.com/apache/superset/issues/19930)) ([1ebdaac](https://github.com/apache/superset/commit/1ebdaac487ec1684050174957a1d5699912bf001))
- memoized decorator memory leak ([#23139](https://github.com/apache/superset/issues/23139)) ([b14e53e](https://github.com/apache/superset/commit/b14e53e492c5d77309d9a1ccb0080e79785b3398))
- **memorize filter in state:** memorize filter in state ([a71b9f2](https://github.com/apache/superset/commit/a71b9f23185669b3ee7a31d33a6a77aa0764a00f))
- Menu items are not disappearing when deleting a dashboard ([#23039](https://github.com/apache/superset/issues/23039)) ([17fbb2d](https://github.com/apache/superset/commit/17fbb2dbb2357417d81de01308264031606a661f))
- migration out-of-scope bind ([#17728](https://github.com/apache/superset/issues/17728)) ([0d2299c](https://github.com/apache/superset/commit/0d2299cb60b2b646a4280f648f1ca3a2ee44a9a2))
- migration revision order ([#20484](https://github.com/apache/superset/issues/20484)) ([b33c23e](https://github.com/apache/superset/commit/b33c23ef2529c8f6c1537bbd70af47a184ea3f76))
- migration revisions from [#19532](https://github.com/apache/superset/issues/19532) ([#20641](https://github.com/apache/superset/issues/20641)) ([4bfa622](https://github.com/apache/superset/commit/4bfa622d02819dc9d6f6dc252a7ddd2137d12397))
- **migration:** Catch DatabaseError to avoid migration crash with MySQL 8.0 ([#21679](https://github.com/apache/superset/issues/21679)) ([5da20f4](https://github.com/apache/superset/commit/5da20f449d70ffa669137f1513b76acd434a7137))
- **migration:** Ensure key_value LargeBinary is encoded as a MEDIUMBLOB as opposed to BLOB for MySQL ([#20385](https://github.com/apache/superset/issues/20385)) ([f5cb23e](https://github.com/apache/superset/commit/f5cb23e0a39a5d5160f5481ba07838ca48beebf7))
- **migration:** Ensure the paginated update is deterministic ([#21778](https://github.com/apache/superset/issues/21778)) ([88a89c9](https://github.com/apache/superset/commit/88a89c9fd683b50d8a81754199fba6dbb4c7bef3))
- **migrations:** Flask-Migrate output is not logged during alembic migrations [#17991](https://github.com/apache/superset/issues/17991) ([#22991](https://github.com/apache/superset/issues/22991)) ([a2c3ef8](https://github.com/apache/superset/commit/a2c3ef81303b90f36e0101834ddda77186f16f8c))
- **migrations:** reorder skipped 1.4 migrations ([#19543](https://github.com/apache/superset/issues/19543)) ([e1ef2ba](https://github.com/apache/superset/commit/e1ef2baad7bd2081e94af93b5487afe96a7b8292))
- **migrations:** sl_columns is_temporal mapping ([#19786](https://github.com/apache/superset/issues/19786)) ([9c20299](https://github.com/apache/superset/commit/9c20299039e5c2ad0136b6f1f0a9954a5a19116e))
- minor wordcloud update ([1c2b003](https://github.com/apache/superset/commit/1c2b003c3c131b331b9487de50393ff466a9bc84))
- miss-spelling on CONTRIBUTING.md line 1351 ([#17760](https://github.com/apache/superset/issues/17760)) ([71e4131](https://github.com/apache/superset/commit/71e41315a47ec6af4b7509f22e50cb94e515651b))
- missing **init** on module sqllab commands ([#23107](https://github.com/apache/superset/issues/23107)) ([4b03d25](https://github.com/apache/superset/commit/4b03d2553c465969049ff449673ea8a1e3eacb51))
- Missing applied filters indicator ([#22137](https://github.com/apache/superset/issues/22137)) ([e8a0a5e](https://github.com/apache/superset/commit/e8a0a5ee5c470b943b29c3a6f99d6cca41191eef))
- missing bracket, little linty things ([#517](https://github.com/apache/superset/issues/517)) ([2078602](https://github.com/apache/superset/commit/20786020cbbf029598f82a69531859cb973a7f22))
- missing groupby/dimension select options ([#21](https://github.com/apache/superset/issues/21)) ([667d56c](https://github.com/apache/superset/commit/667d56c0d1ebb1c1474ee6a9c09b3a23eb50a3a2))
- missing init on importexport pkg ([#19435](https://github.com/apache/superset/issues/19435)) ([2451937](https://github.com/apache/superset/commit/2451937097c0adfde34d735d9d85997d9340a20d))
- missing nan value in timeseries chart ([#1231](https://github.com/apache/superset/issues/1231)) ([db6b76a](https://github.com/apache/superset/commit/db6b76aa1735576a50b4afa6a2d67e8e6dd1e686))
- Missing spacing in adhoc filters popover ([#22346](https://github.com/apache/superset/issues/22346)) ([3a4131f](https://github.com/apache/superset/commit/3a4131ffc7630e4862f5f3451cbeec5ffc29a01f))
- Mistaken use of BootstrapUser type ([#21892](https://github.com/apache/superset/issues/21892)) ([e418694](https://github.com/apache/superset/commit/e4186941508476780323f67fa6a20332dec057eb))
- **Mixed Timeseries Chart:** Custom Metric Label ([#17649](https://github.com/apache/superset/issues/17649)) ([89d0d38](https://github.com/apache/superset/commit/89d0d38ed0eb211d44de8067bd091392a0f84f85))
- Monospacing errors in dashboards & charts ([#18796](https://github.com/apache/superset/issues/18796)) ([4923256](https://github.com/apache/superset/commit/4923256b01305bb327be5bd52eab26234baa174f))
- Most common flaky Cypress tests ([#21941](https://github.com/apache/superset/issues/21941)) ([7e3e133](https://github.com/apache/superset/commit/7e3e13321b2b86d3a7ef1af30b5863ea9edecf05))
- most Recently Selected Table Should Appear at the Top of the List on the Left Panel ([#19258](https://github.com/apache/superset/issues/19258)) ([4669b6c](https://github.com/apache/superset/commit/4669b6ce11dd74e5d1020a1f124e8696b801d730))
- move columns to datasource object for bootstrap data ([#20203](https://github.com/apache/superset/issues/20203)) ([9432c62](https://github.com/apache/superset/commit/9432c62ec168f449e4ba71112db3c6fc14365710))
- move eslint disable comment in reactify test ([#184](https://github.com/apache/superset/issues/184)) ([3d6ef61](https://github.com/apache/superset/commit/3d6ef61658df6ba970f9b14c8fcf98218cd0f739))
- move padding ([f889a4f](https://github.com/apache/superset/commit/f889a4fd3e0135c6d3b52c532c9ebc346bbc08ff))
- move react to table peerdependency ([#179](https://github.com/apache/superset/issues/179)) ([652d663](https://github.com/apache/superset/commit/652d663d7eb93379e99a56a856ed26c588d49f7e))
- move series in front of xy gridlines ([#119](https://github.com/apache/superset/issues/119)) ([58fce4b](https://github.com/apache/superset/commit/58fce4b6461060e44e01fcb233ed9515056d9612))
- **mssql:** support cte in virtual tables ([#18567](https://github.com/apache/superset/issues/18567)) ([b8aef10](https://github.com/apache/superset/commit/b8aef10098d9b58dff111455c9d45424a2c5b7fc)), closes [#8074](https://github.com/apache/superset/issues/8074) [#8074](https://github.com/apache/superset/issues/8074)
- **mssql:** support top syntax for limiting queries ([#18746](https://github.com/apache/superset/issues/18746)) ([7e51b20](https://github.com/apache/superset/commit/7e51b200b42f598c3344548f5f64521814a1d3cd))
- **mssql:** week time grain should respect datefirst setting ([#10811](https://github.com/apache/superset/issues/10811)) ([211b32a](https://github.com/apache/superset/commit/211b32a4cdb9f970333de7c745612f040d346224))
- native filter dropdown not attached to parent node ([#19399](https://github.com/apache/superset/issues/19399)) ([c5b0dc3](https://github.com/apache/superset/commit/c5b0dc3ea62aa98aa732e0c618e84e7cf68c4e54))
- native filter truncation rerendering loop on hover ([#20021](https://github.com/apache/superset/issues/20021)) ([cede148](https://github.com/apache/superset/commit/cede148d4609a9838b6efad9ab9ba26c91af0636))
- **native filters:** groupby filter issue ([#21084](https://github.com/apache/superset/issues/21084)) ([d79b0bf](https://github.com/apache/superset/commit/d79b0bfc744885f6e6f0b5e9a4128c63c1dea58d))
- **native-filter:** fix required filters of a dashboard won't load properly ([#18695](https://github.com/apache/superset/issues/18695)) ([0b1bc5b](https://github.com/apache/superset/commit/0b1bc5b5de4a71e332d9ea6deaca6c1967042406))
- **native-filters:** Add empty text node before OutPortal ([#22289](https://github.com/apache/superset/issues/22289)) ([ffff3e4](https://github.com/apache/superset/commit/ffff3e4bf4e7e92a1b8cec2be5aedfbb8e173a45))
- **native-filters:** apply default value correctly when it's set ([#17982](https://github.com/apache/superset/issues/17982)) ([35f4c33](https://github.com/apache/superset/commit/35f4c3324565fd0c8af92ca99c53bdd036a83c71))
- **native-filters:** Default value not shown in native filters ([#18963](https://github.com/apache/superset/issues/18963)) ([2072225](https://github.com/apache/superset/commit/2072225a8637299c23c337966c9d5aaaeaaa732b))
- **native-filters:** Don't include description icon in truncation calc ([#22941](https://github.com/apache/superset/issues/22941)) ([32d4977](https://github.com/apache/superset/commit/32d497785a0fa9bb37a88b694e2bc66d337cf163))
- **native-filters:** Ensure that time range filter loses focus after closing modal ([#22937](https://github.com/apache/superset/issues/22937)) ([eaf53db](https://github.com/apache/superset/commit/eaf53dbb27e486455e9b6d8433dac7efae5ad82b))
- **native-filters:** Fix update ownState ([#17181](https://github.com/apache/superset/issues/17181)) ([cf284ba](https://github.com/apache/superset/commit/cf284ba3c72550f64ddb19aeed44de2c5cf0b677))
- **native-filters:** Misc spacing fixes for horizontal and horizontal overflow filter bar items ([#22288](https://github.com/apache/superset/issues/22288)) ([04e0bb9](https://github.com/apache/superset/commit/04e0bb9f36b28a375e64fb84db2ed897691e3477))
- **native-filters:** panels are collapsed when switch native filters ([#21976](https://github.com/apache/superset/issues/21976)) ([9b6322b](https://github.com/apache/superset/commit/9b6322b640a12d5d680bb959414dc12d2277a094))
- **native-filters:** Range filter max/min default display value ([#21680](https://github.com/apache/superset/issues/21680)) ([f784455](https://github.com/apache/superset/commit/f784455264b9376a20f05760bf6d90d1dc1e7010))
- **native-filters:** values is not sorted when setting sort option ([#18145](https://github.com/apache/superset/issues/18145)) ([7c937ca](https://github.com/apache/superset/commit/7c937ca1828e0188da0c7610cced42152185af68))
- Navbar styles and Welcome page text ([#19586](https://github.com/apache/superset/issues/19586)) ([59dda1f](https://github.com/apache/superset/commit/59dda1fa05488c921cacc8791d761cd9f9b86e9c))
- **nav:** infinite redirect and upload dataset nav permissions ([#19708](https://github.com/apache/superset/issues/19708)) ([32a9265](https://github.com/apache/superset/commit/32a9265cc0cb850910e55b6f49a73169fc7ed377))
- **nav:** make doc and bug buttons customizable ([#22682](https://github.com/apache/superset/issues/22682)) ([7b15e6e](https://github.com/apache/superset/commit/7b15e6e3c789f82ce682b011d0904e818dfbadc3))
- **nested-tab-available:** make the another tabs into one tabs available ([#18877](https://github.com/apache/superset/issues/18877)) ([6fe2431](https://github.com/apache/superset/commit/6fe24316765af2e5e004c2daa2ef075e899e235a))
- new alert should have force_screenshot be true ([#18182](https://github.com/apache/superset/issues/18182)) ([a80efa6](https://github.com/apache/superset/commit/a80efa609c3c71bb1c6041148e4868b53041079c))
- new line at end ([8e8d1f7](https://github.com/apache/superset/commit/8e8d1f799d993a9589177a1acebaf1acbad28173))
- New Members per Month time range ([#17783](https://github.com/apache/superset/issues/17783)) ([d9acb28](https://github.com/apache/superset/commit/d9acb280c40a8d01c2098170a8ce7b4656298bdc))
- new welcome new users action ([#21662](https://github.com/apache/superset/issues/21662)) ([389fa31](https://github.com/apache/superset/commit/389fa31b89461c78015b3b3d9a7bbfe61a0b879f))
- No back button in save dataset modal ([#20964](https://github.com/apache/superset/issues/20964)) ([eb5369f](https://github.com/apache/superset/commit/eb5369f2a6f2dc238838119eb70194bf2b42b085))
- None dataset and schema permissions ([#20108](https://github.com/apache/superset/issues/20108)) ([b9a98aa](https://github.com/apache/superset/commit/b9a98aae79705b4db2dab94f1a5fafcf8b821a8b))
- Normalize prequery result type ([#17312](https://github.com/apache/superset/issues/17312)) ([36f489e](https://github.com/apache/superset/commit/36f489eea001cb7ffc8c1f8c7a75d1835aa380b2))
- npm exclude template files ([#34](https://github.com/apache/superset/issues/34)) ([ffcc272](https://github.com/apache/superset/commit/ffcc27270c4ea0289371c5ce9303e4466d53d068))
- npm registry connection set to ssl ([#1395](https://github.com/apache/superset/issues/1395)) ([b0a4f87](https://github.com/apache/superset/commit/b0a4f873d0647b7482f19536d3b51dda2bbe723f))
- null dates in table chart ([#17974](https://github.com/apache/superset/issues/17974)) ([1e544ce](https://github.com/apache/superset/commit/1e544ce5316fad4b2c65127426c8aaffaf71fad3))
- null schema issue in saved queries ([#18849](https://github.com/apache/superset/issues/18849)) ([79633ce](https://github.com/apache/superset/commit/79633ce673dd1cf62b6a5004be1b5bceeddd7597))
- null value and empty string in filter ([#18171](https://github.com/apache/superset/issues/18171)) ([20b4ae1](https://github.com/apache/superset/commit/20b4ae1ef90d311a8588ba164cd7e812220a1f2f))
- Null values on Explore filter ([#19341](https://github.com/apache/superset/issues/19341)) ([65c204b](https://github.com/apache/superset/commit/65c204b2882edd2e6c0f09c61992b58a28a07eef))
- Null values on Treemap right-click ([#21722](https://github.com/apache/superset/issues/21722)) ([0ff1e49](https://github.com/apache/superset/commit/0ff1e49e3c720ed229f6a08daaa70bf14a053dca))
- number format should editable when AA in time comparison ([#19351](https://github.com/apache/superset/issues/19351)) ([e15573d](https://github.com/apache/superset/commit/e15573d4453f8432e2da1db86f2e9417666fb8b5))
- nvd3 annotation tooltip ([#540](https://github.com/apache/superset/issues/540)) ([93212e9](https://github.com/apache/superset/commit/93212e97986e81e37e6f3df6957ac7f59a0db284))
- nvd3 charts break on stateChange dispatch ([#159](https://github.com/apache/superset/issues/159)) ([dd2af3f](https://github.com/apache/superset/commit/dd2af3faa855c0f89b5921f708c876b018ce3a3c))
- nvd3 line chart y axis bounds ([#17](https://github.com/apache/superset/issues/17)) ([54f15d7](https://github.com/apache/superset/commit/54f15d72cbc81cfbcdd742446e2e8338da194a6a))
- nvd3 tooltip bolding/non-linebreak on ONLY header row ([#291](https://github.com/apache/superset/issues/291)) ([7a9d72f](https://github.com/apache/superset/commit/7a9d72f3fe3df181387534f562e76ac05eb55a15))
- Only redirect to relative paths when authentication expires ([#18714](https://github.com/apache/superset/issues/18714)) ([8027f5f](https://github.com/apache/superset/commit/8027f5f0a63425c280121d671ae843e4c420793b))
- only remove tooltips relating to a single vis ([#167](https://github.com/apache/superset/issues/167)) ([f4d01bd](https://github.com/apache/superset/commit/f4d01bd914798a774b3e16742d4b0b353ee2dad7))
- OpenAPI docs small fixes ([#19936](https://github.com/apache/superset/issues/19936)) ([5dd3ea1](https://github.com/apache/superset/commit/5dd3ea154ba5393502671beca72cd5d100cf26b1))
- Order of Select items when unselecting ([#17169](https://github.com/apache/superset/issues/17169)) ([55be249](https://github.com/apache/superset/commit/55be249870251b4fa6186d2fa25177e77719335c))
- **other:** column name in created content on profile page ([#17029](https://github.com/apache/superset/issues/17029)) ([f2d41dc](https://github.com/apache/superset/commit/f2d41dc416da9daf7b4e51487a9c07bf06ba21d7))
- overwrite update override columns on PUT /dataset ([#20862](https://github.com/apache/superset/issues/20862)) ([bc435e0](https://github.com/apache/superset/commit/bc435e08d01b87efcf8774f29a7078cee8988e39))
- Owners selection in dataset edit UX ([#17063](https://github.com/apache/superset/issues/17063)) ([959fd76](https://github.com/apache/superset/commit/959fd763a8b22367e7de5d3438e457f3448c6ceb))
- package.json local file dependencies ([#17957](https://github.com/apache/superset/issues/17957)) ([79b6dc2](https://github.com/apache/superset/commit/79b6dc251e76b3e733f7b82d1ef171e9fb093c00))
- **packages:** Fixing users packages ([#18973](https://github.com/apache/superset/issues/18973)) ([5fc7adb](https://github.com/apache/superset/commit/5fc7adb55b364c2f0f72a7b37f73590038936bf4))
- pandas bug when data is blank on post-processing ([#20629](https://github.com/apache/superset/issues/20629)) ([c2be54c](https://github.com/apache/superset/commit/c2be54c335d14521afc1221749e8554ff23c215b))
- pass all props to transformProps in LineMulti chart ([#247](https://github.com/apache/superset/issues/247)) ([ade25f4](https://github.com/apache/superset/commit/ade25f4c2cef11721d87806f13a5f724324d2571))
- pass in slack error messages properly ([#22727](https://github.com/apache/superset/issues/22727)) ([c58dbf8](https://github.com/apache/superset/commit/c58dbf8b9c7c93f5c15b99557a2ec0c6294201e7))
- Pass slice_id in Explore get ([#21696](https://github.com/apache/superset/issues/21696)) ([f1fbaf8](https://github.com/apache/superset/commit/f1fbaf82449456c00536171612a546afb7bc8f0f))
- passing url params in sqllab ([#15246](https://github.com/apache/superset/issues/15246)) ([57c4d0f](https://github.com/apache/superset/commit/57c4d0f9a42d875d701e94044a5e0eee550d0ab7))
- peer dependencies ([5152708](https://github.com/apache/superset/commit/5152708e8389f63c1e54d80cb472d202841c2127))
- peer dependency version ([39be9ad](https://github.com/apache/superset/commit/39be9ad6f0f22441e22a113a3cfa964a3ecfd284))
- peerDependencies version ([#210](https://github.com/apache/superset/issues/210)) ([13ceb8d](https://github.com/apache/superset/commit/13ceb8dc70680e03486d33de54796da28b86569e))
- **permalink:** remove memoize on get salt func ([#19749](https://github.com/apache/superset/issues/19749)) ([cf51459](https://github.com/apache/superset/commit/cf5145918ba6da3b8b803bed86ad7ca22d50494a))
- permission sqlalchemy events ([#21454](https://github.com/apache/superset/issues/21454)) ([64d216a](https://github.com/apache/superset/commit/64d216adb3239959eea8bb4942114913bea3e194))
- pie chart orientation description error ([#21514](https://github.com/apache/superset/issues/21514)) ([c66205f](https://github.com/apache/superset/commit/c66205feac118a444e30cd6b6cb48d2c2e3d6411))
- Pivot Table Conditional Formatting Doesn't Show All Options ([#19071](https://github.com/apache/superset/issues/19071)) ([0e0bece](https://github.com/apache/superset/commit/0e0beceac173f765d8f9a0887732029b78603f6d))
- pivot-table-fixed ([#1360](https://github.com/apache/superset/issues/1360)) ([4352600](https://github.com/apache/superset/commit/43526009f333c02d812073e89ee75384ca78920e))
- **plugin-chart-echarts:** 'SORT BY METRIC' add checkbox to Gauge ([#1113](https://github.com/apache/superset/issues/1113)) ([62ec367](https://github.com/apache/superset/commit/62ec36745725b08db525203204abda9cb7d6a62c))
- **plugin-chart-echarts:** [feature parity] annotation line chart color not working ([#19758](https://github.com/apache/superset/issues/19758)) ([1156297](https://github.com/apache/superset/commit/11562971fb95a601d11b2902f1704b72409f302d))
- **plugin-chart-echarts:** [feature-parity] apply button of annotation layer doesn't work as expected ([#19761](https://github.com/apache/superset/issues/19761)) ([9f02ff6](https://github.com/apache/superset/commit/9f02ff656d63e537c06822657dcfc2ff46f70e67))
- **plugin-chart-echarts:** [feature-parity] display custom metrics ([#1337](https://github.com/apache/superset/issues/1337)) ([b7e49fc](https://github.com/apache/superset/commit/b7e49fc4db938a51920cc794482b3a31fb41c287))
- **plugin-chart-echarts:** [guage chart] filter indicator not shown ([#1326](https://github.com/apache/superset/issues/1326)) ([6b1b142](https://github.com/apache/superset/commit/6b1b1423b934bb2d8ece0faf8746432dc756c8fa))
- **plugin-chart-echarts:** [scatter-plot] remove contribution mode ([#1325](https://github.com/apache/superset/issues/1325)) ([18c0570](https://github.com/apache/superset/commit/18c05701ddc366bc51424674e09f478230cef01e))
- **plugin-chart-echarts:** [time-series][mixed timeseries] marker control does not work ([#1187](https://github.com/apache/superset/issues/1187)) ([360d4a5](https://github.com/apache/superset/commit/360d4a55f05869b5b18f1df0d035ac24c79708c1))
- **plugin-chart-echarts:** [treemap v2] the section color and disabling the zoom on the explore ([6d10d83](https://github.com/apache/superset/commit/6d10d8305ecf0fb923bcbf561939399b1df4b197))
- **plugin-chart-echarts:** add orderby to funnel chart ([#1099](https://github.com/apache/superset/issues/1099)) ([e994fc0](https://github.com/apache/superset/commit/e994fc08027cadcfdeee96e4e003bc82035819db))
- **plugin-chart-echarts:** add series deduplication ([#1046](https://github.com/apache/superset/issues/1046)) ([6377933](https://github.com/apache/superset/commit/637793342cf7698fb930c282c403c9214b1351ea))
- **plugin-chart-echarts:** Apply temporary filters to Query B in explore ([#18998](https://github.com/apache/superset/issues/18998)) ([9f834e8](https://github.com/apache/superset/commit/9f834e8317dca7c71470c89e2c86bb35ca7ca39f))
- **plugin-chart-echarts:** bar chart overflow ([#20805](https://github.com/apache/superset/issues/20805)) ([9bf7ed5](https://github.com/apache/superset/commit/9bf7ed58cdc1d5523d0cb661f8fdbf7df9b10fe7))
- **plugin-chart-echarts:** boxplot groupby incorrect ([#1448](https://github.com/apache/superset/issues/1448)) ([25da47c](https://github.com/apache/superset/commit/25da47c111b13fe31a77afec0ee3d50b73ede7cf))
- **plugin-chart-echarts:** boxplot throw error in the dashboard ([#21661](https://github.com/apache/superset/issues/21661)) ([61bd696](https://github.com/apache/superset/commit/61bd6962265d879e168f208854fc17b145b9e04d))
- **plugin-chart-echarts:** default to standard x-axis format ([#1043](https://github.com/apache/superset/issues/1043)) ([ed87d47](https://github.com/apache/superset/commit/ed87d473ee3b2f2503837629292af665dae61fa5))
- **plugin-chart-echarts:** disable pie chart animation ([#816](https://github.com/apache/superset/issues/816)) ([1d8f559](https://github.com/apache/superset/commit/1d8f559feb2ff4eefc3500f82436407506d7c965))
- **plugin-chart-echarts:** disabling dragging treemap on the dashboard ([#1109](https://github.com/apache/superset/issues/1109)) ([b6f2df9](https://github.com/apache/superset/commit/b6f2df958369d1071c3690c9e5f9ff92215933c7))
- **plugin-chart-echarts:** enable animation to clear old nodes ([#1200](https://github.com/apache/superset/issues/1200)) ([f27c2ee](https://github.com/apache/superset/commit/f27c2ee528f5dee55b90007dfbeb3aa0f53905ea))
- **plugin-chart-echarts:** fill missing values when stacked chart ([#1014](https://github.com/apache/superset/issues/1014)) ([e861c7b](https://github.com/apache/superset/commit/e861c7b153088289810da0b5ee623f9a66c5d5ef))
- **plugin-chart-echarts:** fix broken boxplot storybook example ([#823](https://github.com/apache/superset/issues/823)) ([7a8275e](https://github.com/apache/superset/commit/7a8275e08c396502344187e52b43803b67a0cd95))
- **plugin-chart-echarts:** fix customize margin ([#18958](https://github.com/apache/superset/issues/18958)) ([c4e3c45](https://github.com/apache/superset/commit/c4e3c45b3c24034205a1ceeb5387d63dc666a7fe))
- **plugin-chart-echarts:** fix default y axis bounds ([#810](https://github.com/apache/superset/issues/810)) ([fdd8067](https://github.com/apache/superset/commit/fdd806723b2220828574ea0f287a73c808dcd6a7))
- **plugin-chart-echarts:** fix forecasts on verbose metrics ([#18252](https://github.com/apache/superset/issues/18252)) ([2929bb1](https://github.com/apache/superset/commit/2929bb1680d29e5fd1d3b351e3e2f86971a60b44))
- **plugin-chart-echarts:** fix GraphViz crash with DnD control ([#991](https://github.com/apache/superset/issues/991)) ([3fd7593](https://github.com/apache/superset/commit/3fd75938dcbc4c5359b302bf9a0650ce5839aeb6))
- **plugin-chart-echarts:** fix incorrect groupby in buildQuery ([#800](https://github.com/apache/superset/issues/800)) ([5d70fd3](https://github.com/apache/superset/commit/5d70fd3946a715ffa55a7d8c16b2999082ec0b72))
- **plugin-chart-echarts:** fix legend margin in radar and ts chart ([#1470](https://github.com/apache/superset/issues/1470)) ([7f44a04](https://github.com/apache/superset/commit/7f44a0402d335b9ea22913a4024386a86f7339ae))
- **plugin-chart-echarts:** fix null labels on pie and funnel charts ([#1270](https://github.com/apache/superset/issues/1270)) ([5ed2ba1](https://github.com/apache/superset/commit/5ed2ba131c747b79121d07207c5553077ac97724))
- **plugin-chart-echarts:** fix opacity on area chart ([#1464](https://github.com/apache/superset/issues/1464)) ([e186adb](https://github.com/apache/superset/commit/e186adb62afaf0e617789ebc29834f87f8409e9e))
- **plugin-chart-echarts:** fix tick labels and tooltip ([#1447](https://github.com/apache/superset/issues/1447)) ([fb5e5af](https://github.com/apache/superset/commit/fb5e5af88a2cd62f0cb3d14b675044b827d7bd98))
- **plugin-chart-echarts:** fix time-series chart xAxisShowMin(Max)Label default value ([#1161](https://github.com/apache/superset/issues/1161)) ([2d408ce](https://github.com/apache/superset/commit/2d408ce6c2a1306a5f46f3723a80f712c0145b6d))
- **plugin-chart-echarts:** fix Time-series line x-filtering not working when not rich tooltip ([#1302](https://github.com/apache/superset/issues/1302)) ([c31892e](https://github.com/apache/superset/commit/c31892e905b596ef20785c25b9b9c75ade9348a7))
- **plugin-chart-echarts:** fix tooltip format in mixed ts chart ([#1143](https://github.com/apache/superset/issues/1143)) ([b9194ad](https://github.com/apache/superset/commit/b9194ad0510201ea321233b227955d64640afe39))
- **plugin-chart-echarts:** fix unnecessary chart clearing ([#1044](https://github.com/apache/superset/issues/1044)) ([53df21d](https://github.com/apache/superset/commit/53df21d7237d58da2897fc3a93e3922265ecdd2b))
- **plugin-chart-echarts:** fix unnecessary highlight ([#1052](https://github.com/apache/superset/issues/1052)) ([cca4b74](https://github.com/apache/superset/commit/cca4b74fd97f0af2940dc2e3d3d074272d21df5e))
- **plugin-chart-echarts:** funnel chart improvements ([#1110](https://github.com/apache/superset/issues/1110)) ([dab8a4b](https://github.com/apache/superset/commit/dab8a4be4bda6a208681073d2094c84bf82f718b))
- **plugin-chart-echarts:** gauge chart enhancements and fixes ([#21007](https://github.com/apache/superset/issues/21007)) ([b303d1e](https://github.com/apache/superset/commit/b303d1e156185d134927246004a4804931cd6bca))
- **plugin-chart-echarts:** improve ECharts visuals ([#806](https://github.com/apache/superset/issues/806)) ([adaa5f8](https://github.com/apache/superset/commit/adaa5f89e6e9a834f2665d7bb316024d337b5f12))
- **plugin-chart-echarts:** improve marksize range ([#1323](https://github.com/apache/superset/issues/1323)) ([d20e08e](https://github.com/apache/superset/commit/d20e08e7f81a511718b27dc548cdd260ab26b885))
- **plugin-chart-echarts:** improve yAxisBounds parsing ([#815](https://github.com/apache/superset/issues/815)) ([fb30d68](https://github.com/apache/superset/commit/fb30d687b7b17fddc78fd8e43237bfb2618b6ea2))
- **plugin-chart-echarts:** include label length in distance calculation ([#1056](https://github.com/apache/superset/issues/1056)) ([99866e7](https://github.com/apache/superset/commit/99866e70c5f2b98f97a3912fabf188def8fb7885))
- **plugin-chart-echarts:** invalid total label location for negative values in stacked bar chart ([#21032](https://github.com/apache/superset/issues/21032)) ([a8ba544](https://github.com/apache/superset/commit/a8ba544e609ad3af449239c1fb956bb18c7066c4))
- **plugin-chart-echarts:** label type and hover bugs ([#942](https://github.com/apache/superset/issues/942)) ([d3bb433](https://github.com/apache/superset/commit/d3bb433560fe72fa46045b3a8423635f0fc38b05))
- **plugin-chart-echarts:** layout broken when resizing ([#20783](https://github.com/apache/superset/issues/20783)) ([d90b973](https://github.com/apache/superset/commit/d90b97323584dbd1602cccaa0aea6ac25f466038))
- **plugin-chart-echarts:** make filtered pie slices semi-transparent ([#1239](https://github.com/apache/superset/issues/1239)) ([8e8a221](https://github.com/apache/superset/commit/8e8a221711392abf41dd9485eb23d6fe6c55348c))
- **plugin-chart-echarts:** make to allow the custome of x & y axis title margin i… ([#18947](https://github.com/apache/superset/issues/18947)) ([c79ee56](https://github.com/apache/superset/commit/c79ee568849761d9c5793ce88f5b7aba8d9e7ac9))
- **plugin-chart-echarts:** missing dnd control in tree chart ([#1260](https://github.com/apache/superset/issues/1260)) ([c2c6bb0](https://github.com/apache/superset/commit/c2c6bb0a35a1aa96f04caffdadd31d8e438bb529))
- **plugin-chart-echarts:** missing value format in mixed timeseries ([#21044](https://github.com/apache/superset/issues/21044)) ([2d1ba46](https://github.com/apache/superset/commit/2d1ba468441b113c574d6fcc5984e8e09ddbc1c6))
- **plugin-chart-echarts:** order by timeseries limit metric ([#1156](https://github.com/apache/superset/issues/1156)) ([2023dc0](https://github.com/apache/superset/commit/2023dc0a49302e61c0127154d6081650d9165fae))
- **plugin-chart-echarts:** radar legend control is duplicated ([#1180](https://github.com/apache/superset/issues/1180)) ([25ec1e3](https://github.com/apache/superset/commit/25ec1e3d491e5804a000e79f8f7b4cd16f65fe60))
- **plugin-chart-echarts:** remove columns from formData ([#901](https://github.com/apache/superset/issues/901)) ([1e8cb81](https://github.com/apache/superset/commit/1e8cb81531ff6d550c04e0aa259dc62dcea3e2c8))
- **plugin-chart-echarts:** remove label line if below threshold ([#1071](https://github.com/apache/superset/issues/1071)) ([31ca397](https://github.com/apache/superset/commit/31ca397c70696e6d118cc94729ee29c348fd0b17))
- **plugin-chart-echarts:** sanitize series from html tags ([#1126](https://github.com/apache/superset/issues/1126)) ([895d9d3](https://github.com/apache/superset/commit/895d9d325d65e083a4bca4a362f43347cd58d463))
- **plugin-chart-echarts:** show zero value in tooltip ([#21296](https://github.com/apache/superset/issues/21296)) ([1aeb8fd](https://github.com/apache/superset/commit/1aeb8fd6b78d5b53501d277f54b46a02f7067163))
- **plugin-chart-echarts:** single select in boxPlot x-filtering ([#1212](https://github.com/apache/superset/issues/1212)) ([0a56420](https://github.com/apache/superset/commit/0a56420066191b0761b6a150e5bb0b308d4e59ba))
- **plugin-chart-echarts:** support adhoc x-axis ([#20055](https://github.com/apache/superset/issues/20055)) ([b53daa9](https://github.com/apache/superset/commit/b53daa91ecf0e82fe219b498e907d0c3f3ca9ccb))
- **plugin-chart-echarts:** tooltip of big number truncated at then bottom ([#20029](https://github.com/apache/superset/issues/20029)) ([35e6e27](https://github.com/apache/superset/commit/35e6e2709c9dec3d9c08280489f42b5b6a8e632e))
- **plugin-chart-echarts:** tooltip overflow bug ([#22218](https://github.com/apache/superset/issues/22218)) ([2e650ea](https://github.com/apache/superset/commit/2e650eaebebc1197549636174f4c3945c55d4d5e))
- **plugin-chart-echarts:** tree graph tooltip polish ([#1182](https://github.com/apache/superset/issues/1182)) ([28003ad](https://github.com/apache/superset/commit/28003ad4dcccacd95cba267daaa6e9dbe3328e9e))
- **plugin-chart-echarts:** use verbose x-axis name when defined ([#18217](https://github.com/apache/superset/issues/18217)) ([cec4677](https://github.com/apache/superset/commit/cec467797187324269971d870520b360c56419f3))
- **plugin-chart-echarts:** xAxis scale is not correct when setting quarter time grain ([#19686](https://github.com/apache/superset/issues/19686)) ([059cb4e](https://github.com/apache/superset/commit/059cb4ec25855b844a9c35be9b6c462595e90a5c))
- **plugin-chart-handlebars:** fix overflow, debounce and control reset ([#19879](https://github.com/apache/superset/issues/19879)) ([d5ea537](https://github.com/apache/superset/commit/d5ea537b0eb3e102677d63811b99cf2c4b31a3ab))
- **plugin-chart-handlebars:** order by control not work ([#21005](https://github.com/apache/superset/issues/21005)) ([e70699f](https://github.com/apache/superset/commit/e70699fb433849e07af81ea1812f20aa271d028e))
- **plugin-chart-handlebars:** Update webpack/babel config to fix build/runtime warnings/errors ([#21779](https://github.com/apache/superset/issues/21779)) ([d5b4bde](https://github.com/apache/superset/commit/d5b4bdeb72e558e78d80e0fdb47249467cb14f03))
- **plugin-chart-pivot-table:** color weight of Conditional formatting metrics not work ([#20396](https://github.com/apache/superset/issues/20396)) ([1665403](https://github.com/apache/superset/commit/16654034849505109b638fd2a784dfb377238a0e))
- **plugin-chart-pivot-table:** cross filtering by adhoc column ([#1465](https://github.com/apache/superset/issues/1465)) ([2b8e4a1](https://github.com/apache/superset/commit/2b8e4a18dced0aee9535393b05d3220954f56416))
- **plugin-chart-pivot-table:** dont apply colors to subtotals ([#1269](https://github.com/apache/superset/issues/1269)) ([7a4ef38](https://github.com/apache/superset/commit/7a4ef386406516c9eaba66c864aedbbd94642729))
- **plugin-chart-pivot-table:** dont display nulls as 0 ([#1265](https://github.com/apache/superset/issues/1265)) ([635c182](https://github.com/apache/superset/commit/635c182c8cef35c89c4b17da83969d67341679d9))
- **plugin-chart-pivot-table:** fix displaying column labels ([#1132](https://github.com/apache/superset/issues/1132)) ([124cd34](https://github.com/apache/superset/commit/124cd34153bb82334705b1f23a467cf438912ab3))
- **plugin-chart-pivot-table:** Invalid Formats Date Fields ([#20909](https://github.com/apache/superset/issues/20909)) ([3f124d9](https://github.com/apache/superset/commit/3f124d9d67f194746da0a49ee2456a0530ec73f9))
- **plugin-chart-pivot-table:** make date formatting clearable ([#1261](https://github.com/apache/superset/issues/1261)) ([35f061a](https://github.com/apache/superset/commit/35f061a39d7626ae898373b3f9c2913370eca795))
- **plugin-chart-pivot-table:** pivot table supports single select ([#1221](https://github.com/apache/superset/issues/1221)) ([89474f8](https://github.com/apache/superset/commit/89474f84e5e1b86cdae012e3700535b11ada5174))
- **plugin-chart-table:** add text align to table header ([#1039](https://github.com/apache/superset/issues/1039)) ([79d561d](https://github.com/apache/superset/commit/79d561d67aa82f7f8576bb92c03e40e161ad0338))
- **plugin-chart-table:** always sort descending by first metric ([#935](https://github.com/apache/superset/issues/935)) ([ea63b7c](https://github.com/apache/superset/commit/ea63b7cf8e95a813a75de90ccfa2db2f11882776))
- **plugin-chart-table:** anchor should keep href ([#661](https://github.com/apache/superset/issues/661)) ([771cf48](https://github.com/apache/superset/commit/771cf48c6b040517ad862ca5ab44579e1e54920b))
- **plugin-chart-table:** apply correct date formatting for time grain ([#1315](https://github.com/apache/superset/issues/1315)) ([42d15c9](https://github.com/apache/superset/commit/42d15c9478427af49004b4e2fb9564f78a6d1f25))
- **plugin-chart-table:** better rendering for temporal columns ([#937](https://github.com/apache/superset/issues/937)) ([79f67fe](https://github.com/apache/superset/commit/79f67fe6c30b46fc1cfd31672bef042236872f82))
- **plugin-chart-table:** change default queryMode to null ([#659](https://github.com/apache/superset/issues/659)) ([c41a607](https://github.com/apache/superset/commit/c41a60726c4a6d912fe95577352aced4d5d5b06b))
- **plugin-chart-table:** check if control values are set ([#1095](https://github.com/apache/superset/issues/1095)) ([33198ab](https://github.com/apache/superset/commit/33198abcfb29b882c5d679e824fb16da72365be7))
- **plugin-chart-table:** chinesee translation improve ([#1189](https://github.com/apache/superset/issues/1189)) ([af43889](https://github.com/apache/superset/commit/af4388988757a8fec2cce5fdc013d1e98e49c418))
- **plugin-chart-table:** fix empty metrics ([#1047](https://github.com/apache/superset/issues/1047)) ([a0d60c0](https://github.com/apache/superset/commit/a0d60c066d6a698ec7f63c983a1dcfa4056d3ff8))
- **plugin-chart-table:** formatting non-numeric metrics ([#663](https://github.com/apache/superset/issues/663)) ([0e1ea12](https://github.com/apache/superset/commit/0e1ea1217c791e0e919873ec58bb3979da4f197f))
- **plugin-chart-table:** hide cell bar for group by fields ([#957](https://github.com/apache/superset/issues/957)) ([eb16861](https://github.com/apache/superset/commit/eb168618c134db7132fbb6be0af58ca84425569c))
- **plugin-chart-table:** hide column configs when no columns ([#1085](https://github.com/apache/superset/issues/1085)) ([679b82b](https://github.com/apache/superset/commit/679b82b491f7d439a0e5def80db68c7db1925b61))
- **plugin-chart-table:** ignore duplicate percent metrics ([#994](https://github.com/apache/superset/issues/994)) ([69a5c90](https://github.com/apache/superset/commit/69a5c9004bca1ad958bfc508f6bf109e1854e605))
- **plugin-chart-table:** metrics should be undefined ([#1005](https://github.com/apache/superset/issues/1005)) ([e03c4ee](https://github.com/apache/superset/commit/e03c4ee4950a489ea8ba9a8d47846d088d75eb59))
- **plugin-chart-table:** refine ordering logic ([#930](https://github.com/apache/superset/issues/930)) ([b011c79](https://github.com/apache/superset/commit/b011c7914b05a7be280ce060f64ce154900cac85))
- **plugin-chart-table:** Resetting controls when switching query mode ([#19792](https://github.com/apache/superset/issues/19792)) ([fcc8080](https://github.com/apache/superset/commit/fcc8080ff3b99e2f5f5cdbd48335d7ab83aba16a))
- **plugin-chart-table:** resize and totals formatting bug ([#1082](https://github.com/apache/superset/issues/1082)) ([6089bcf](https://github.com/apache/superset/commit/6089bcfd8973fe5efbf7bcc95386c2f33f93a7a4))
- **plugin-chart-table:** sort alphanumeric columns case insensitive ([#17765](https://github.com/apache/superset/issues/17765)) ([82b47ca](https://github.com/apache/superset/commit/82b47cacba9653c7837c361be65e10520e9068b3))
- **plugin-chart-table:** sort and search time column ([#669](https://github.com/apache/superset/issues/669)) ([142544c](https://github.com/apache/superset/commit/142544cd44aea5ad71bd08933cb2395ab246daa0))
- **plugin-chart-table:** table clear x-filtering highlighting ([#1222](https://github.com/apache/superset/issues/1222)) ([4051fda](https://github.com/apache/superset/commit/4051fda671b8b6d4b0a4f2ba8266d61cda73b916))
- **plugin-chart-table:** unnecessary post_processing in raw records mode ([#925](https://github.com/apache/superset/issues/925)) ([b4bee55](https://github.com/apache/superset/commit/b4bee55e9fb5371641a70911ecbb6e05caef1317))
- **plugin-chart-table:** Upgrade old color formats ([#21101](https://github.com/apache/superset/issues/21101)) ([8005b7f](https://github.com/apache/superset/commit/8005b7f8c77fa96e0ff32958830ba307db74abff))
- **plugin-chart-table:** value undefined when table name has dot ([#686](https://github.com/apache/superset/issues/686)) ([7b7c8a0](https://github.com/apache/superset/commit/7b7c8a0c1a8bd0af3473639578788bf70dc61975))
- **plugin-chart-word-cloud:** ensure top results are always displayed ([#841](https://github.com/apache/superset/issues/841)) ([b695fc2](https://github.com/apache/superset/commit/b695fc28153e97fe8df7c10ed8478fc8476ef1aa))
- **plugin-chart-word-cloud:** make colors schemes work ([#788](https://github.com/apache/superset/issues/788)) ([e71af2f](https://github.com/apache/superset/commit/e71af2f2b14e5a70fc3ef323a9b86f3e4d32d85a))
- **plugin-chart-word-cloud:** make wordcloud take current formdata ([#428](https://github.com/apache/superset/issues/428)) ([6190450](https://github.com/apache/superset/commit/619045048ffdfc64128d47665eb50c5210cb0900))
- point version badge to npm page ([#821](https://github.com/apache/superset/issues/821)) ([dc1f82d](https://github.com/apache/superset/commit/dc1f82dfce7a6596a63a7aa367bc3e42010dbf1a))
- pointing nvd3 package to nvd3-fork ([#615](https://github.com/apache/superset/issues/615)) ([b182b64](https://github.com/apache/superset/commit/b182b641f60834a82fc3da201843a76cddf634d0))
- Popovers in Explore not attached to the fields they are triggered by ([#19139](https://github.com/apache/superset/issues/19139)) ([0277ebc](https://github.com/apache/superset/commit/0277ebc225889006d9b07c2eedc2caeafdc4e8f8))
- Position of arrows in Table chart ([#18739](https://github.com/apache/superset/issues/18739)) ([a9a8929](https://github.com/apache/superset/commit/a9a892945e6058c92c6e4f63255d799790a9bfa8))
- **postgres:** remove redundant tz factory ([#17713](https://github.com/apache/superset/issues/17713)) ([6a7e649](https://github.com/apache/superset/commit/6a7e6490a9d386850c6b6c31b9bd8abf3caf3ba1))
- Preserve unknown URL params ([#21785](https://github.com/apache/superset/issues/21785)) ([11d7d6e](https://github.com/apache/superset/commit/11d7d6e078b75079c432d8d8028dac45678b2c37))
- **preset-chart-xy:** Pick LegendRenderer ([#118](https://github.com/apache/superset/issues/118)) ([06449c5](https://github.com/apache/superset/commit/06449c521e1ac449cf5f11ca99347e0ad2d43501))
- Presto \_show_columns return type ([#20757](https://github.com/apache/superset/issues/20757)) ([8c0ac90](https://github.com/apache/superset/commit/8c0ac9017f414c36c1b8110a48a242bca3688969))
- **presto,trino:** use correct literal dttm separator ([#20123](https://github.com/apache/superset/issues/20123)) ([e2f11d3](https://github.com/apache/superset/commit/e2f11d3680a8f8a0fba7746b13551e49cdca7fd6))
- **presto/trino:** Add TIME/TIMESTAMP WITH TIME ZONE ([#19263](https://github.com/apache/superset/issues/19263)) ([82a6811](https://github.com/apache/superset/commit/82a6811e7ef3b00e5abbead15377481298764891))
- **presto/trino:** Ensure get_table_names only returns real tables ([#21794](https://github.com/apache/superset/issues/21794)) ([9f7bd1e](https://github.com/apache/superset/commit/9f7bd1e63fbd4084b1dd1ad9b1dd718ff43c7e7c))
- **presto:** expand data with null item ([#17470](https://github.com/apache/superset/issues/17470)) ([8da982b](https://github.com/apache/superset/commit/8da982bc7cd4a0ffa03c58305715459c72803690))
- **presto:** use correct timespec for presto ([#20333](https://github.com/apache/superset/issues/20333)) ([41bbf62](https://github.com/apache/superset/commit/41bbf62e586933172bde4b4080a4f21fe1ccd290))
- prevent caching error pages ([#17100](https://github.com/apache/superset/issues/17100)) ([031f594](https://github.com/apache/superset/commit/031f594fa3624c7f11987a7bf67eef990137ed85))
- preventing sql lab None limit value ([#17155](https://github.com/apache/superset/issues/17155)) ([029ed90](https://github.com/apache/superset/commit/029ed90afb2f81204726cd161ef1eb7a0ac91e23)), closes [#17172](https://github.com/apache/superset/issues/17172) [#17173](https://github.com/apache/superset/issues/17173)
- Prevents last temporal filter removal ([#22982](https://github.com/apache/superset/issues/22982)) ([b63ea63](https://github.com/apache/superset/commit/b63ea6386fedecbacce68bfd552b144b79845cca))
- process color scheme configs correctly ([#17786](https://github.com/apache/superset/issues/17786)) ([de3d397](https://github.com/apache/superset/commit/de3d3973a249ab56b294d3f5d770a79fe8970abd))
- properly set `owners` to Sqlatable.owners_data inside payload ([#20794](https://github.com/apache/superset/issues/20794)) ([84b852c](https://github.com/apache/superset/commit/84b852c45751930fdf8850c519509bdb2e5a5e38))
- publish settings ([1feab46](https://github.com/apache/superset/commit/1feab468e50c48bb11cd0df568e72f05ed3e4ce3))
- Published Dashboard without charts don't show up for non admin users ([#20638](https://github.com/apache/superset/issues/20638)) ([8b354b4](https://github.com/apache/superset/commit/8b354b4b6999e5a2474fb94ffab6b8428c4d4e6e))
- Query execution time is displayed as invalid date ([#19605](https://github.com/apache/superset/issues/19605)) ([e3dbe8d](https://github.com/apache/superset/commit/e3dbe8d8af434f9095309638e1df0a905f7bbf29))
- query execution time is not fully displayed in bubble icon ([#20364](https://github.com/apache/superset/issues/20364)) ([e1532f6](https://github.com/apache/superset/commit/e1532f63aca5dfd1386dd1cbd811f382ab9b7f98))
- **query:** equals operator, duplicate filters and time range endpoints ([#700](https://github.com/apache/superset/issues/700)) ([0e16cbb](https://github.com/apache/superset/commit/0e16cbbeb9cc7d472fa87a6dc3ba2b225e958ef2))
- Race conditions with setupExtensions ([#21647](https://github.com/apache/superset/issues/21647)) ([de444d4](https://github.com/apache/superset/commit/de444d4de6a917af8f8efe2335fb1a26ac86e6d8))
- RBAC for export for dashboard viewers ([#17527](https://github.com/apache/superset/issues/17527)) ([2e29f36](https://github.com/apache/superset/commit/2e29f36e7885b693a0af2cf8b0b8ca86d2970f64))
- **rbac:** show objects accessible by database access perm ([#23118](https://github.com/apache/superset/issues/23118)) ([ae6e2a0](https://github.com/apache/superset/commit/ae6e2a00a029543159d8afb90064e0a8d33a7934))
- Re-add filter-box time granularity/column ([#20485](https://github.com/apache/superset/issues/20485)) ([661ab35](https://github.com/apache/superset/commit/661ab35bd07b22defe45c112f5e5230929b27681))
- Read MAPBOX_API_KEY from environment ([#16926](https://github.com/apache/superset/issues/16926)) ([0870a0b](https://github.com/apache/superset/commit/0870a0b04605e8397df7489d9d5a537ab38c1f1b))
- **readme:** link target and title ([#19576](https://github.com/apache/superset/issues/19576)) ([8610012](https://github.com/apache/superset/commit/861001251d48eb801863a48dd9182ed7504e176d))
- Redirect on 401 ([#17597](https://github.com/apache/superset/issues/17597)) ([46cdc77](https://github.com/apache/superset/commit/46cdc77ae64d0cc55a54719c748391b92a475a33))
- Redirect to full url on 401 ([#19357](https://github.com/apache/superset/issues/19357)) ([b8e5954](https://github.com/apache/superset/commit/b8e595413fa02b5f00c7b91df6283701a5f1b972))
- Redirects old Explore URLs to the new one ([#20812](https://github.com/apache/superset/issues/20812)) ([34278c2](https://github.com/apache/superset/commit/34278c2d56e3e3ac09660227b23fa4b107311ee5))
- Reduce bundle sizes from react-icons ([#1225](https://github.com/apache/superset/issues/1225)) ([4005789](https://github.com/apache/superset/commit/4005789244ce1f9dfb4e615560e0b2f2f66b4dc7))
- reenabling terser plugin for webpack ([#17205](https://github.com/apache/superset/issues/17205)) ([ef01cbb](https://github.com/apache/superset/commit/ef01cbb625f9171ab5d65c821298eee17bfce838))
- Refactor ownership checks and ensure consistency ([#20499](https://github.com/apache/superset/issues/20499)) ([f0ca158](https://github.com/apache/superset/commit/f0ca158989644b793719884b52d04f93c05de1ba))
- Refactor SQL username logic ([#19914](https://github.com/apache/superset/issues/19914)) ([449d08b](https://github.com/apache/superset/commit/449d08b25e5190e42863a2b7c7d95a63fd35a1be))
- refuse to start with default secret on non debug envs ([#23186](https://github.com/apache/superset/issues/23186)) ([c60ba87](https://github.com/apache/superset/commit/c60ba87d0ff6c89b734b6098d2b7c69d11f79bfc))
- regression in [#21766](https://github.com/apache/superset/issues/21766) ([#21782](https://github.com/apache/superset/issues/21782)) ([8f74e46](https://github.com/apache/superset/commit/8f74e46d45ca94f5656f7b881f1096c16657c829))
- Regression on Data and Alerts & Reports Headers ([#19850](https://github.com/apache/superset/issues/19850)) ([7645eac](https://github.com/apache/superset/commit/7645eac31f2cc583906f504e8896e4a119eee751))
- regression on Select component when handling null values ([#19326](https://github.com/apache/superset/issues/19326)) ([9e58916](https://github.com/apache/superset/commit/9e58916d935cf15c3fbe1949dd81f7acec2514c3))
- **releases:** docker build on M1 npm run build fails ([#20700](https://github.com/apache/superset/issues/20700)) ([e6b0141](https://github.com/apache/superset/commit/e6b0141c6769ed9d51dc9674014a559ef6f63a44))
- Remove .ts suffix from NVD3 imports ([#453](https://github.com/apache/superset/issues/453)) ([5e54132](https://github.com/apache/superset/commit/5e541322fdf81ec8538449f374c8e483beaab37c))
- remove & reimplement the tests for AlertReportCronScheduler component ([#19288](https://github.com/apache/superset/issues/19288)) ([7f22edf](https://github.com/apache/superset/commit/7f22edfd0600e14b0d23fe09fd87b28d1cc8363f))
- Remove button is broken for metrics on Explore ([#22940](https://github.com/apache/superset/issues/22940)) ([ebed50f](https://github.com/apache/superset/commit/ebed50fd12c78e523c102abccc38a8d89554f863))
- remove console.log from timeseries chart ([#1208](https://github.com/apache/superset/issues/1208)) ([d66ecb7](https://github.com/apache/superset/commit/d66ecb731335eb5a88b59e740ec9b746468e447e))
- remove deprecated ETagResponseMixin ([#21773](https://github.com/apache/superset/issues/21773)) ([75e6a04](https://github.com/apache/superset/commit/75e6a04269bf73c0c7160290333ded4e63421a4b))
- remove duplicated group by field ([#979](https://github.com/apache/superset/issues/979)) ([3930079](https://github.com/apache/superset/commit/39300798c3e3a59b5b783aa6337f4ec4f6f092bc))
- remove expose ([#19700](https://github.com/apache/superset/issues/19700)) ([57157c8](https://github.com/apache/superset/commit/57157c8b1580545b5ef4d25a4d9039006bc27548))
- remove extra < character in email report ([#18224](https://github.com/apache/superset/issues/18224)) ([987237b](https://github.com/apache/superset/commit/987237b9281243f3d932a2170c9b6b23ba224f23))
- remove extra line for link ([#20959](https://github.com/apache/superset/issues/20959)) ([fa416fa](https://github.com/apache/superset/commit/fa416fa130e2efe93ff0d55092530b4595113e9f))
- remove extras from all adhoc_filters controls ([#21450](https://github.com/apache/superset/issues/21450)) ([e1e9fda](https://github.com/apache/superset/commit/e1e9fda72b27f554a68a740c0f5e8d0b27437315))
- Remove gap from SQLLab results bottom ([#19138](https://github.com/apache/superset/issues/19138)) ([8947eb9](https://github.com/apache/superset/commit/8947eb968024e2eb18167b6fc18ce7f66f6cb90b))
- Remove horizontal scroll navigation from SQL Lab ([#17356](https://github.com/apache/superset/issues/17356)) ([f05a32e](https://github.com/apache/superset/commit/f05a32eeb92f24326d8e85d3d597a279995a4d1d))
- remove is_prequery and prequeries ([#208](https://github.com/apache/superset/issues/208)) ([bffc760](https://github.com/apache/superset/commit/bffc760ac87b5a967b9c9561d6a5baf8401c87a1))
- remove max-width from tooltip div ([#909](https://github.com/apache/superset/issues/909)) ([4db360c](https://github.com/apache/superset/commit/4db360c0a635c5ec8557d6a39ed1b393abe36c6a))
- remove npm logout ([#1433](https://github.com/apache/superset/issues/1433)) ([9565777](https://github.com/apache/superset/commit/95657773c688b3130b6e608ce3cba6d20a8fc349))
- remove package-lock.json ([#1426](https://github.com/apache/superset/issues/1426)) ([58d0246](https://github.com/apache/superset/commit/58d0246f9e0c2cb4ac0be5b412c522509730c7ef))
- remove padding in WithLegend ([70d210c](https://github.com/apache/superset/commit/70d210ca5d58e62e758530ed4f8fded62707e862))
- Remove positions from json_metadata ([#17766](https://github.com/apache/superset/issues/17766)) ([274fb37](https://github.com/apache/superset/commit/274fb37a917e78acd0711b754edf7b833f06911d))
- remove redundant target from sankey tooltip ([#193](https://github.com/apache/superset/issues/193)) ([79c755e](https://github.com/apache/superset/commit/79c755e85f942c38d7e2797f20a12fd9881cee27))
- remove standalone ([#18157](https://github.com/apache/superset/issues/18157)) ([fa11a97](https://github.com/apache/superset/commit/fa11a97585ffa692e097823f04e9d7aa10637286))
- remove sticky tooltip when query returns no data in explore view ([#42](https://github.com/apache/superset/issues/42)) ([8b4bb80](https://github.com/apache/superset/commit/8b4bb80738d8404473f864c86c3afac04cc2d562))
- remove storybook dependency ([#3](https://github.com/apache/superset/issues/3)) ([317f185](https://github.com/apache/superset/commit/317f185d36d8d04c55bc79d8336648dbe1fb287a))
- remove unnecessary divider ([#19048](https://github.com/apache/superset/issues/19048)) ([4d96393](https://github.com/apache/superset/commit/4d96393fafdbf0b2d29a299b4b605ce057daebe2))
- remove unneeded complexity in migration ([#19022](https://github.com/apache/superset/issues/19022)) ([50bb86d](https://github.com/apache/superset/commit/50bb86d6666953b0ceee49f385fd6c523a7b9f1b))
- remove unsupported REST API search col with dotted notation on c… ([#22440](https://github.com/apache/superset/issues/22440)) ([277f8e0](https://github.com/apache/superset/commit/277f8e04e23e4413be76877f909ddafb55d66d55))
- remove variables from styled component ([#17228](https://github.com/apache/superset/issues/17228)) ([9a4ab10](https://github.com/apache/superset/commit/9a4ab1026ed656541789973863a2b5ca1bbc1cec))
- remove whitespace from http_path for databricks ([#22671](https://github.com/apache/superset/issues/22671)) ([cd1f6d4](https://github.com/apache/superset/commit/cd1f6d469b34c7c211c7b990ccfbde8909ecbea4))
- Remove`time_range_endpoints` from query context object ([#19423](https://github.com/apache/superset/issues/19423)) ([129063d](https://github.com/apache/superset/commit/129063d544b0a1313640b3cc6e57f380b8fe27fe))
- removed redundant logger definition ([#17289](https://github.com/apache/superset/issues/17289)) ([4e9f812](https://github.com/apache/superset/commit/4e9f812dab7798d55eae1bd6f383e41d4d3039e5))
- Removes duplicated import in dashboard filter state tests ([#17887](https://github.com/apache/superset/issues/17887)) ([8ebec60](https://github.com/apache/superset/commit/8ebec6016ecd0b729ff149bf1bb051da808f3f95))
- Removes psycopg2 as a required dependency ([#20543](https://github.com/apache/superset/issues/20543)) ([cb3cd41](https://github.com/apache/superset/commit/cb3cd41dcd33af37b06e8ffc4d6d7ae1166d2d7f))
- Removetime_range_endpoints from query context object pt 2 ([#19728](https://github.com/apache/superset/issues/19728)) ([8664202](https://github.com/apache/superset/commit/86642025ba0bb555e6e5d6c058a74e98d997f2e8))
- removing pyproject.toml ([#23101](https://github.com/apache/superset/issues/23101)) ([75495d1](https://github.com/apache/superset/commit/75495d1601235b3d60519a0e6595e7f776c60e63))
- rename datasource->dataset in error message ([#21959](https://github.com/apache/superset/issues/21959)) ([72598a5](https://github.com/apache/superset/commit/72598a5b2ae6e25aa9e6cfb2d6d664ecea158a92))
- rename DnD types to match component names in Superset ([#988](https://github.com/apache/superset/issues/988)) ([93b0c18](https://github.com/apache/superset/commit/93b0c18ce446d101cc6acfd6dd4866ea39007ae7))
- rename file from js to ts ([#75](https://github.com/apache/superset/issues/75)) ([f17bb4a](https://github.com/apache/superset/commit/f17bb4a6c2283ca8e882fe9ba694e7241e578a24))
- rename to schemas_allowed_for_file_upload in dbs.extra ([#17323](https://github.com/apache/superset/issues/17323)) ([0ca4312](https://github.com/apache/superset/commit/0ca4312212ee58b9461106d704321e0907c59e57))
- Reordering native filters ignored by filter bar ([#22362](https://github.com/apache/superset/issues/22362)) ([da64fa2](https://github.com/apache/superset/commit/da64fa2525028d77557b3340edc7a12d2ec7cb90))
- reorganize role permissions ([#23096](https://github.com/apache/superset/issues/23096)) ([7a4cd44](https://github.com/apache/superset/commit/7a4cd44a5dd3faf0baca6b046499173827947588))
- replace absolute difference with difference in echart ([#1383](https://github.com/apache/superset/issues/1383)) ([b309c6b](https://github.com/apache/superset/commit/b309c6bbeac601e456994d405b3b86ec57837b55))
- replace absolute difference with difference in legacy charts ([#1384](https://github.com/apache/superset/issues/1384)) ([d1461c6](https://github.com/apache/superset/commit/d1461c684fa152d65f9183c84d00deff18d4bb13))
- replace datamask with key from new key value api ([#17680](https://github.com/apache/superset/issues/17680)) ([cfd851a](https://github.com/apache/superset/commit/cfd851aa13e1f9642cce014e84669293e65c38bb))
- Replace unsafe lifecycle methods ([#285](https://github.com/apache/superset/issues/285)) ([bce43cb](https://github.com/apache/superset/commit/bce43cb1f9169b99c7974ebcfafd1679912dabf3))
- report list search by created_by ([#18725](https://github.com/apache/superset/issues/18725)) ([59b811a](https://github.com/apache/superset/commit/59b811ac5bf6ea64da8e9343fed28676001b9015))
- Report screenshot cut off on left and right sides ([#22614](https://github.com/apache/superset/issues/22614)) ([0807875](https://github.com/apache/superset/commit/08078753b7e043c0c636c4d6c53ba5d0f287e7b7))
- **report-add:** make to add error toast message when already attached report is added again into dashboard or chart ([#19122](https://github.com/apache/superset/issues/19122)) ([cb03570](https://github.com/apache/superset/commit/cb0357005e323ba08de53948c352cfc04de3c05a))
- **report:** Capture unexpected errors in report screenshots. Fixes [#21653](https://github.com/apache/superset/issues/21653) ([#21724](https://github.com/apache/superset/issues/21724)) ([d1989a4](https://github.com/apache/superset/commit/d1989a4766ca624763fcefe50fa5a4c582e950f6))
- **report:** Fix permission check for set up email report on charts/dashboards. Fixes [#21559](https://github.com/apache/superset/issues/21559) ([#21561](https://github.com/apache/superset/issues/21561)) ([7f971b4](https://github.com/apache/superset/commit/7f971b41037c5f3ad9bf7fada1ff264bb94350f9))
- **reports:** Clear last value when state is WORKING ([#19941](https://github.com/apache/superset/issues/19941)) ([89a844a](https://github.com/apache/superset/commit/89a844a40f55d91d0ca1b6b737cc6a371f770149))
- **reports:** force data generation in csv reports ([#22196](https://github.com/apache/superset/issues/22196)) ([a8bc53d](https://github.com/apache/superset/commit/a8bc53d805b404adf395cf7a844402fffd6fe220))
- **reports:** Owners no longer showing undefined in reports ([#17223](https://github.com/apache/superset/issues/17223)) ([456efc0](https://github.com/apache/superset/commit/456efc0c2053a27083e513b77998f93571c79028))
- request samples with default row limit ([#19456](https://github.com/apache/superset/issues/19456)) ([d684ad0](https://github.com/apache/superset/commit/d684ad073d63953d803cf05b4b208484f1fe7e51))
- resample method shouldn't be freeform ([#21135](https://github.com/apache/superset/issues/21135)) ([fea68ef](https://github.com/apache/superset/commit/fea68ef23cd19853f6ceee42802ac3b4b1b05da0))
- Reset dataset name after saving a new dataset in SQL Lab ([#21529](https://github.com/apache/superset/issues/21529)) ([cbadb87](https://github.com/apache/superset/commit/cbadb8773f06ca62ad4d9ebf04df211af3de9853))
- Reset sorting bar issue in Barchart ([#19371](https://github.com/apache/superset/issues/19371)) ([94e06c2](https://github.com/apache/superset/commit/94e06c2b6a1f782133bb9ef85a1d46ce7eacf9ba))
- resolve issues post `0.10.0` ([5c5a060](https://github.com/apache/superset/commit/5c5a060252bd0acb7f0688bc84f05a07cda5e74b))
- respect chart cache timeout setting ([#21637](https://github.com/apache/superset/issues/21637)) ([5ea9249](https://github.com/apache/superset/commit/5ea924905971338a53604b5d0ef9be5d04aa65db))
- Respecting max/min opacities, and adding tests. ([#20555](https://github.com/apache/superset/issues/20555)) ([ac8e502](https://github.com/apache/superset/commit/ac8e502228d1b247c1b56ee692c2cefade1bf1a9))
- responsive y-axis on stacked charts ([#141](https://github.com/apache/superset/issues/141)) ([a6c10eb](https://github.com/apache/superset/commit/a6c10eb3cfd7532e7127932773d8226a3ab7d5b3))
- Returns 404 instead of 500 for unknown dashboard filter state keys ([#17878](https://github.com/apache/superset/issues/17878)) ([3a9bd12](https://github.com/apache/superset/commit/3a9bd12e3d294450e703ed87937e8e2c6308216e))
- Revert "[#20095](https://github.com/apache/superset/issues/20095) - fix(database): make to display validation error msg when all … ([#21277](https://github.com/apache/superset/issues/21277)) ([4b22137](https://github.com/apache/superset/commit/4b221378cc609fd418e0b43a31239da04804ccee))
- revert "feat(sqla): apply time grain to all temporal groupbys" ([#17239](https://github.com/apache/superset/issues/17239)) ([b7bda70](https://github.com/apache/superset/commit/b7bda7031e6067c5d093d4fceeb539feb7e35777)), closes [#16318](https://github.com/apache/superset/issues/16318)
- Revert "refactor: converted QueryAutoRefresh to functional component … ([#19226](https://github.com/apache/superset/issues/19226)) ([fc87218](https://github.com/apache/superset/commit/fc8721800b00ea8a4a627ec54adb5852857f6d3c)), closes [#18179](https://github.com/apache/superset/issues/18179)
- revert [#17654](https://github.com/apache/superset/issues/17654) to fix subselect table name parsing ([#18017](https://github.com/apache/superset/issues/18017)) ([14b9298](https://github.com/apache/superset/commit/14b9298ef72e73372c2d3f3b1f9f5a1cfb064e1d))
- revert [#21356](https://github.com/apache/superset/issues/21356)(able to sort bar on the bar chart V2) ([#21481](https://github.com/apache/superset/issues/21481)) ([1c0bff3](https://github.com/apache/superset/commit/1c0bff3dfb3649d219abe6a13d9018ded14f334f))
- revert default series limit and update eligible choices ([#1430](https://github.com/apache/superset/issues/1430)) ([4e31029](https://github.com/apache/superset/commit/4e3102935cc10e4a3f407f0e351eb88a2e0bdae0)), closes [#1033](https://github.com/apache/superset/issues/1033)
- Revert default series sort-by metric and enforce non-xor with series limit ([#17236](https://github.com/apache/superset/issues/17236)) ([1c12167](https://github.com/apache/superset/commit/1c12167d8d12b6a092356c008286f6f07f1c9954))
- revert handle null values in time-series table ([#18684](https://github.com/apache/superset/issues/18684)) ([35684c5](https://github.com/apache/superset/commit/35684c54b3150ad9f62ffb845761eba47840e6a7))
- revert permission refactoring PR ([#21313](https://github.com/apache/superset/issues/21313)) ([286474c](https://github.com/apache/superset/commit/286474c3d83903beb37ab5dc650aa2a0977033bb))
- revert RESTful apis and react view for RLS ([#22818](https://github.com/apache/superset/issues/22818)) ([8226110](https://github.com/apache/superset/commit/8226110be8bea6f1b06ce02def7ea56df44e6b50))
- Revert shared controls typing change. ([#22014](https://github.com/apache/superset/issues/22014)) ([4cbd70d](https://github.com/apache/superset/commit/4cbd70db34b140a026ef1a86a8ef0ba3355a350e))
- Reverts [#20749](https://github.com/apache/superset/issues/20749) and [#20645](https://github.com/apache/superset/issues/20645) ([#20796](https://github.com/apache/superset/issues/20796)) ([3311128](https://github.com/apache/superset/commit/3311128c5e6c5de2ea5d6a2dfeb01ea3179e9af8))
- Right click on country map with code filter ([#22081](https://github.com/apache/superset/issues/22081)) ([824dc71](https://github.com/apache/superset/commit/824dc7188b953270ca754f96ca615e96c61dbea4))
- Right-click on misconfigured World Map ([#21697](https://github.com/apache/superset/issues/21697)) ([770f68f](https://github.com/apache/superset/commit/770f68f5b187b573f50f53a80d9cfffb24f0c583))
- RLS new db migration downgrade fails on SQLite ([#20449](https://github.com/apache/superset/issues/20449)) ([ba4ba02](https://github.com/apache/superset/commit/ba4ba0267e6f9f6ce6fed09c5d89965eee5c9f92))
- rm eslint-plugin-translation-vars engine requirement ([#20420](https://github.com/apache/superset/issues/20420)) ([fa7f144](https://github.com/apache/superset/commit/fa7f144a687a438f7a67c99b167dd4af10471712))
- rolling and cum operator in multiple series chart ([#1386](https://github.com/apache/superset/issues/1386)) ([b5dcf1a](https://github.com/apache/superset/commit/b5dcf1ae81209973d1c6a2c0960ee574715e284a))
- rolling and cum operator on multiple series ([#16945](https://github.com/apache/superset/issues/16945)) ([fd84614](https://github.com/apache/superset/commit/fd8461406d62e818c4bc88075ac25ddf44ba9caf))
- running dev-server on a different port ([#17775](https://github.com/apache/superset/issues/17775)) ([4fd6df9](https://github.com/apache/superset/commit/4fd6df9ef89fd7425d998828cce944a0cc4a19a4))
- Save dataset + chart when Chart source is Query ([#20880](https://github.com/apache/superset/issues/20880)) ([0d8889d](https://github.com/apache/superset/commit/0d8889dc9ce9490a8a5502e3400255a74229a031))
- save dataset and repopulate state ([#20965](https://github.com/apache/superset/issues/20965)) ([463406f](https://github.com/apache/superset/commit/463406ff095375613bf0270343a4af53142c84d6))
- Save properties after applying changes in Dashboard ([#17570](https://github.com/apache/superset/issues/17570)) ([12bd1fc](https://github.com/apache/superset/commit/12bd1fcde5bb3f0c5d6897a044a599934acdb902))
- scale type category missing ordinal ([814e572](https://github.com/apache/superset/commit/814e5725c20acc7b17282511d8b155a76ae59711))
- **scatter:** fix legend and labels ([#43](https://github.com/apache/superset/issues/43)) ([c3e5edf](https://github.com/apache/superset/commit/c3e5edf7cf064d12febdb974d5a9ac3190b91ab9))
- **schedule-query:** getUISchema function called in SchemaForm component ([#20256](https://github.com/apache/superset/issues/20256)) ([4137fe0](https://github.com/apache/superset/commit/4137fe03a00e0a5732141895002cd55607b28d64))
- Select clear and loading icons overlap ([#19070](https://github.com/apache/superset/issues/19070)) ([79a7a5d](https://github.com/apache/superset/commit/79a7a5d1b1682f79f1aab1723f76a34dcb9bf030))
- Selected tab after save and go to dashboard ([#21630](https://github.com/apache/superset/issues/21630)) ([6af35a7](https://github.com/apache/superset/commit/6af35a7d982e823e95cf85e35ab1a1f7870714ff))
- **select:** make to consider the case sensitive in case of d3 format selector ([#19159](https://github.com/apache/superset/issues/19159)) ([d099f5e](https://github.com/apache/superset/commit/d099f5ed4ad6f5b553c7e3eedbc34cf5ad55eae7))
- **Select:** options will be overwritten due to seState ([#17951](https://github.com/apache/superset/issues/17951)) ([2ae29c9](https://github.com/apache/superset/commit/2ae29c92812dd134a58e2e5a59093779d65bd831))
- **select:** render when empty multiselect ([#19612](https://github.com/apache/superset/issues/19612)) ([1ad82af](https://github.com/apache/superset/commit/1ad82af058ec79a544f48df7a1aa9b0a165ecfb8))
- **select:** select component sort functionality on certain options ([#17638](https://github.com/apache/superset/issues/17638)) ([f476ba2](https://github.com/apache/superset/commit/f476ba23a279cb87a94ad3075e035cad0ae264b6))
- series limit solution for source is query ([#20977](https://github.com/apache/superset/issues/20977)) ([e350823](https://github.com/apache/superset/commit/e3508232ab3dedef01e055c370e11bcab3263a24))
- set allow `filter_select` for Query objects in Explore ([#20754](https://github.com/apache/superset/issues/20754)) ([81bd496](https://github.com/apache/superset/commit/81bd4968d0a916cb2a20e47b20e31a1434be4f46))
- set correct favicon from config for login and FAB list views ([#21498](https://github.com/apache/superset/issues/21498)) ([b29e7e7](https://github.com/apache/superset/commit/b29e7e7d9e6f4c1f429eb1220f03640596579e9f))
- set correct schema on config import ([#16041](https://github.com/apache/superset/issues/16041)) ([1fbce88](https://github.com/apache/superset/commit/1fbce88a46f188465970209ed99fc392081dc6c9))
- Set fixed maxWidth of the cron schedule modal ([#19485](https://github.com/apache/superset/issues/19485)) ([7cfd892](https://github.com/apache/superset/commit/7cfd892bb9950041b362060a092ac15a8297f6a5))
- set reference to columns properly for sqllab -> explore ([#20747](https://github.com/apache/superset/issues/20747)) ([510c1c4](https://github.com/apache/superset/commit/510c1c4817024af051cc30f315a042c282dbd3b2))
- should be able to remove selection from X-AXIS control ([#21371](https://github.com/apache/superset/issues/21371)) ([eb4ba5b](https://github.com/apache/superset/commit/eb4ba5b08975df2124057c25d3732ef68a0e880a))
- should raise exception when apply a categorical axis ([#20451](https://github.com/apache/superset/issues/20451)) ([8bbbd6f](https://github.com/apache/superset/commit/8bbbd6f03fbd7fccf457706d942f114b7abb682d))
- Show full long number in text email report for table chart. ([#19575](https://github.com/apache/superset/issues/19575)) ([4dc1934](https://github.com/apache/superset/commit/4dc19345d8b1144b6b72cd139313b33fd950936c))
- show onhover menu only in edit mode ([#17034](https://github.com/apache/superset/issues/17034)) ([bdbcfbc](https://github.com/apache/superset/commit/bdbcfbc8fc37bb044fb47477b92eb63717d95f1b))
- show only necessary tick labels on log scale ([#19](https://github.com/apache/superset/issues/19)) ([49a6951](https://github.com/apache/superset/commit/49a6951f4f2bb1c7f093919b1d8cafa790b08c54))
- show question mark icon when can not infer datatype ([#1001](https://github.com/apache/superset/issues/1001)) ([fc149ce](https://github.com/apache/superset/commit/fc149ced493a0c8ff47d83e86311429be7642073))
- show SCHEDULED_QUERIES when defined ([#17854](https://github.com/apache/superset/issues/17854)) ([c6c4143](https://github.com/apache/superset/commit/c6c4143b044a6ed19db2c3c8bc9b5abdd1cb3a78)), closes [/github.com/apache/superset/blob/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b/superset-frontend/src/SqlLab/components/ScheduleQueryButton/index.tsx#L33](https://github.com//github.com/apache/superset/blob/69f9ee8f5eddcf8ac7a8bfb697be4fc95f34e66b/superset-frontend/src/SqlLab/components/ScheduleQueryButton/index.tsx/issues/L33)
- Show sqllab state when deleting databases ([#17331](https://github.com/apache/superset/issues/17331)) ([e5fe186](https://github.com/apache/superset/commit/e5fe18660cd362a8bca6c4465097665415d18d6d))
- show the total row count in the SQL Lab Query History tab when limited by DISPLAY_MAX_ROW ([#19054](https://github.com/apache/superset/issues/19054)) ([bd76648](https://github.com/apache/superset/commit/bd76648e4e74725b95fb927196e690a8be68b2e7))
- Show Totals error with sort and group by together ([#19072](https://github.com/apache/superset/issues/19072)) ([bc6aad0](https://github.com/apache/superset/commit/bc6aad0a88bbbbfd6c592f8813d1b72471788897))
- show value on the selected series ([#1429](https://github.com/apache/superset/issues/1429)) ([3a5bfa6](https://github.com/apache/superset/commit/3a5bfa6488472a38ef874bba6ee07dcd1819d3d9))
- single y axis bounds ([#148](https://github.com/apache/superset/issues/148)) ([e5d1e7c](https://github.com/apache/superset/commit/e5d1e7ca272e347171bb2d4f253bb4000c382c56))
- **SIP-68:** handle empty table name during migration ([#19793](https://github.com/apache/superset/issues/19793)) ([fa68036](https://github.com/apache/superset/commit/fa680369ea66c9713d63b609df19bebe5cd99d08))
- slug is empty if filename is non-ASCII ([#22118](https://github.com/apache/superset/issues/22118)) ([394fb2f](https://github.com/apache/superset/commit/394fb2f2d0e05f27ced88e8ff4fc6994696cab68))
- small bump to shillelagh ([#21953](https://github.com/apache/superset/issues/21953)) ([102909e](https://github.com/apache/superset/commit/102909e00404cd25a62dbd5142790a8e69f1a681))
- small cleanup for created by me dashboards API ([#19755](https://github.com/apache/superset/issues/19755)) ([f06db79](https://github.com/apache/superset/commit/f06db796b5a609915d96b0a176f474d5142d9813))
- small rendering for no results message ([#309](https://github.com/apache/superset/issues/309)) ([eef4699](https://github.com/apache/superset/commit/eef4699807d34c79a3e987f07b9f81c6a837d8c3))
- smartDateVerbose at seconds ([#132](https://github.com/apache/superset/issues/132)) ([cbc1de5](https://github.com/apache/superset/commit/cbc1de5c760e74a891e2c1cdc08fc088c14b2058))
- **snowflake:** Allow encrypted_extra field to be imported ([#22357](https://github.com/apache/superset/issues/22357)) ([d41cb66](https://github.com/apache/superset/commit/d41cb66737fab210f1cd799a3325dad5ef83af4d))
- Source from Apache Foundation's website link ([#18894](https://github.com/apache/superset/issues/18894)) ([7345795](https://github.com/apache/superset/commit/7345795a2f2cc5fbbeca1fc7ea6e3e9ba817bc4a))
- Spacing in alert modal ([#22709](https://github.com/apache/superset/issues/22709)) ([2ccdb72](https://github.com/apache/superset/commit/2ccdb72830ffb549c0112442ba0bc7e4219261d4))
- **SQL Editor:** names new query tabs correctly ([#18951](https://github.com/apache/superset/issues/18951)) ([5a5ff99](https://github.com/apache/superset/commit/5a5ff99c372041e14621bc20015edd1b057cb417))
- SQL Lab cancel query in Redshift database connection does not wo… ([#16326](https://github.com/apache/superset/issues/16326)) ([90d486a](https://github.com/apache/superset/commit/90d486a643e59b44278d2cef64652151eb6248f6)), closes [#16325](https://github.com/apache/superset/issues/16325)
- sql lab crash caused by invalid template ([#17133](https://github.com/apache/superset/issues/17133)) ([96f4421](https://github.com/apache/superset/commit/96f44219615a287db267f9dc1c0073aa038e0ed0))
- sql lab ctrl t behaved differently from clicking ([#19420](https://github.com/apache/superset/issues/19420)) ([56381f4](https://github.com/apache/superset/commit/56381f4ee8a7a1e36fcb33b2b3a5e16793ab0b8b))
- SQL Lab QuerySource via referrer ([#22172](https://github.com/apache/superset/issues/22172)) ([f40e6d1](https://github.com/apache/superset/commit/f40e6d10543e96164ce068cbee93f99a8283ce57))
- SQL Lab sorting of non-numbers ([#18006](https://github.com/apache/superset/issues/18006)) ([27000da](https://github.com/apache/superset/commit/27000da2f8f7cffd9fe9cebbd592238573fc780e))
- **sql Lab tabs:** Empty SQL Lab tabs ([#18817](https://github.com/apache/superset/issues/18817)) ([147dc5a](https://github.com/apache/superset/commit/147dc5af71e67f667dea6990ab1a3efbca5698d6))
- SQL Lab UI Error: Objects are not valid as a React child ([#19783](https://github.com/apache/superset/issues/19783)) ([dfba9ea](https://github.com/apache/superset/commit/dfba9ea596605dc11b29ca1c82615db539e394b2))
- **sql lab:** add quotes when autocompleting table names with spaces in the editor ([#19311](https://github.com/apache/superset/issues/19311)) ([8d4a52c](https://github.com/apache/superset/commit/8d4a52c9d014047baecbdab76f48eb729e3842dc))
- **sql lab:** deleting the last saved query or the last executed from history ([#19225](https://github.com/apache/superset/issues/19225)) ([aa5c80b](https://github.com/apache/superset/commit/aa5c80bda6856295368c937307bcec75bba957cf))
- **sql lab:** display the 'View Results' button consistently in the history tab on sync mode ([#19362](https://github.com/apache/superset/issues/19362)) ([6d5d03e](https://github.com/apache/superset/commit/6d5d03e592087df497a85d1a10447166cc6ab628))
- **sql lab:** increase the size of the action icons in the history tab ([#19313](https://github.com/apache/superset/issues/19313)) ([c6c9188](https://github.com/apache/superset/commit/c6c9188a2405ae326e4055ce611089ec9ae80fbb))
- **sql lab:** MultiSelector component render twice ([#20706](https://github.com/apache/superset/issues/20706)) ([115ab70](https://github.com/apache/superset/commit/115ab700df0f3bf4c8ce0321be7b439c82afc97f))
- **sql lab:** NULL styling in grid cell ([#17385](https://github.com/apache/superset/issues/17385)) ([eb029ab](https://github.com/apache/superset/commit/eb029ab068afb314a892f8945e960813118f71a1))
- **sql lab:** replace the output column in the query history table ([#19370](https://github.com/apache/superset/issues/19370)) ([d4e7c65](https://github.com/apache/superset/commit/d4e7c65f6abc656625d827af362d2b6b0d0e1877))
- **sql lab:** Save Dataset Modal Autocomplete should display list when overwritting ([#20512](https://github.com/apache/superset/issues/20512)) ([8a57a71](https://github.com/apache/superset/commit/8a57a71bed30a781a1d5e5b2ce42ccd08045b3e9))
- **sql lab:** Selecting edit on a query from query history doesn't update the SQL Editor properly ([#19290](https://github.com/apache/superset/issues/19290)) ([bbe0af3](https://github.com/apache/superset/commit/bbe0af348bd0c973ce62f1a0b95fd9b7c04fd97e))
- **sql lab:** SQL Lab Compile Query Delay ([#20206](https://github.com/apache/superset/issues/20206)) ([653cf77](https://github.com/apache/superset/commit/653cf773f7c3337a6a20072e22137db3f7e4e2af))
- **sql lab:** Syntax errors should return with 422 status ([#20491](https://github.com/apache/superset/issues/20491)) ([383313b](https://github.com/apache/superset/commit/383313b105b0e82bea0f38cc971630eded5affe0))
- **sql lab:** table selector should display all the selected tables ([#19257](https://github.com/apache/superset/issues/19257)) ([26a0f05](https://github.com/apache/superset/commit/26a0f0575931850f81a593785d29232f40fd7d71))
- **sql lab:** View result button is not showing consistently ([#20164](https://github.com/apache/superset/issues/20164)) ([9205785](https://github.com/apache/superset/commit/92057858c2ff88c65c69f3818ecebe30d97413f2))
- **sql lab:** when editing a saved query, the status is lost when switching tabs ([#19448](https://github.com/apache/superset/issues/19448)) ([800ced5](https://github.com/apache/superset/commit/800ced5e257d5d83d6dbe4ced0e7318ac40d026f))
- **sql_lab:** Add custom timestamp type for literal casting for presto timestamps ([#13082](https://github.com/apache/superset/issues/13082)) ([1b55778](https://github.com/apache/superset/commit/1b55778427cdb5e4b40074536a3ae2a597f30a69))
- **sql-lab:** do not replace undefined schema with empty object ([#19664](https://github.com/apache/superset/issues/19664)) ([87d4798](https://github.com/apache/superset/commit/87d47987b7800a183f3eebf2cfa7781d450e6e37))
- **sqla:** apply jinja to metrics ([#19565](https://github.com/apache/superset/issues/19565)) ([34b5576](https://github.com/apache/superset/commit/34b55765c4b0cbd8f0b9f89c6ca0f62f4478270e))
- **sqla:** avoid unnecessary groupby for when no metrics ([#18579](https://github.com/apache/superset/issues/18579)) ([55cd7fb](https://github.com/apache/superset/commit/55cd7fb412a497b124633f596ff351358448bea9))
- **sqla:** convert prequery results to native python types ([#17195](https://github.com/apache/superset/issues/17195)) ([2ba046f](https://github.com/apache/superset/commit/2ba046f228595625d1011a945120227508b055b0))
- **sqla:** copy temporal range logic to helper ([#22405](https://github.com/apache/superset/issues/22405)) ([1014a32](https://github.com/apache/superset/commit/1014a327f5ed2e1e4f1daec283825e94c7640d05))
- SQLAlchemy coercing subquery warning on RLS ([#21257](https://github.com/apache/superset/issues/21257)) ([6223042](https://github.com/apache/superset/commit/622304205058d31b34a6590f4c0d652421730464))
- **sqla:** make text clause escaping optional ([#17641](https://github.com/apache/superset/issues/17641)) ([b2ffa26](https://github.com/apache/superset/commit/b2ffa268cd4587d283fd824bea8155d2203db8d1))
- **sqla:** replace custom dttm type with literal_column ([#19917](https://github.com/apache/superset/issues/19917)) ([99f1f9e](https://github.com/apache/superset/commit/99f1f9ec610159db650081d9691835eea0f42b88))
- **sqla:** use same template processor in all methods ([#22280](https://github.com/apache/superset/issues/22280)) ([1ad5147](https://github.com/apache/superset/commit/1ad514701609785f19b27ad495ba34f3b9fff585))
- sqllab schema select error msg ([#18564](https://github.com/apache/superset/issues/18564)) ([151d30b](https://github.com/apache/superset/commit/151d30bea482b446d97917b3b15288780869aff2))
- **sqllab/charts:** casting from timestamp[us] to timestamp[ns] would result in out of bounds timestamp ([#18873](https://github.com/apache/superset/issues/18873)) ([8b72354](https://github.com/apache/superset/commit/8b72354654a8d1eec02510ca011644d3856fa09e))
- **sqllab:** Add templateParams on kv store ([#22013](https://github.com/apache/superset/issues/22013)) ([c3f1873](https://github.com/apache/superset/commit/c3f1873c4314ba19a508118a9876c345e50ab204))
- **sqllab:** Async queries are now fetched properly ([#21698](https://github.com/apache/superset/issues/21698)) ([d21e1d7](https://github.com/apache/superset/commit/d21e1d799d7d5c04606f6b70dbc5666e54a15f39))
- **sqllab:** async query broken due to [#21320](https://github.com/apache/superset/issues/21320) ([#21667](https://github.com/apache/superset/issues/21667)) ([50cb396](https://github.com/apache/superset/commit/50cb396bf23a016d51801f04ce5e330e5b2f73ce))
- **sqllab:** avoid unexpected re-rendering on DatabaseSelector ([#21141](https://github.com/apache/superset/issues/21141)) ([a1389d3](https://github.com/apache/superset/commit/a1389d3a9f90a6dc1ca1fb6203a90f8ba70214a9))
- **sqllab:** avoid unexpected re-rendering on DatabaseSelector ([#21316](https://github.com/apache/superset/issues/21316)) ([e2b77a7](https://github.com/apache/superset/commit/e2b77a7543d851d03ba8cfae2d852381c269b87c))
- **sqllab:** Bugfix for tracking url transformation ([#17263](https://github.com/apache/superset/issues/17263)) ([2544a4a](https://github.com/apache/superset/commit/2544a4a8accf29edb7bb45ffd1c9fc97ddc7ad40))
- **sqllab:** clean unwanted scrollbar ([#22990](https://github.com/apache/superset/issues/22990)) ([a1b7eb3](https://github.com/apache/superset/commit/a1b7eb387078f24dd6d5cbf93682d6167d21b557))
- **sqllab:** Copy link doesn't apply the unsaved changes ([#21311](https://github.com/apache/superset/issues/21311)) ([acd9515](https://github.com/apache/superset/commit/acd9515353a15901a9870e7493bbed238a3e9e88))
- **sqllab:** Fix autocomplete for SQL Lab ([#22329](https://github.com/apache/superset/issues/22329)) ([96de314](https://github.com/apache/superset/commit/96de314c0cee53eaea4008b07b599907a5450f1f))
- **sqllab:** fix control x to stop query ([#21899](https://github.com/apache/superset/issues/21899)) ([88e98d5](https://github.com/apache/superset/commit/88e98d576c12a0802c71315b5f089be834d0774b))
- **sqllab:** Fix cursor alignment in SQL lab editor by avoiding Lucida Console font on Windows ([#21380](https://github.com/apache/superset/issues/21380)) ([3098e65](https://github.com/apache/superset/commit/3098e657e5699b60e5c3e10df1249bc3f4ca1729))
- **sqllab:** fix query results sorting ([#18666](https://github.com/apache/superset/issues/18666)) ([5bb406b](https://github.com/apache/superset/commit/5bb406b296b77292d2191cb92ae0967149c8057b))
- **sqllab:** Fix spacing on Schedule option in SqlEditor dropdown ([#21832](https://github.com/apache/superset/issues/21832)) ([fcb9800](https://github.com/apache/superset/commit/fcb98003a3ffeea25de64082100ca7d9109f9864))
- **sqllab:** Fix tab state ([#20947](https://github.com/apache/superset/issues/20947)) ([c06d5eb](https://github.com/apache/superset/commit/c06d5eb70ce4ee40e3433b3d6e3bf5e4501e50fe))
- **sqllab:** Floating numbers not sorting correctly in result column ([#17573](https://github.com/apache/superset/issues/17573)) ([05752e3](https://github.com/apache/superset/commit/05752e3fe81abf9e9edfd2069e16f4075869775a))
- **sqllab:** Have table name tooltip only show when name is truncated ([#17386](https://github.com/apache/superset/issues/17386)) ([8e1619b](https://github.com/apache/superset/commit/8e1619b1055e50c9ee7cbab650f777ec6a64ef3e))
- **sqllab:** hide tracking url when fetching ([#20905](https://github.com/apache/superset/issues/20905)) ([5ae0e83](https://github.com/apache/superset/commit/5ae0e83b8ae01403639ec23569cd4b840dd154f5))
- **sqllab:** Hover tooltip flashes in SQL Lab ([#17068](https://github.com/apache/superset/issues/17068)) ([635898a](https://github.com/apache/superset/commit/635898a76db13612bcdeafb72a8ef0f06dd5d0f1))
- **sqllab:** inconsistent addNewQueryEditor behavior ([#21999](https://github.com/apache/superset/issues/21999)) ([19779d7](https://github.com/apache/superset/commit/19779d7517b1dcec99d6e9213f21a263a13a6b99))
- **sqllab:** Invalid schema fetch by deprecated value ([#22968](https://github.com/apache/superset/issues/22968)) ([d3d59ee](https://github.com/apache/superset/commit/d3d59ee0ae5aad485d24cb32c4c1754305fc5e0e))
- **sqllab:** Invalid schema fetch for deprecated value ([#22695](https://github.com/apache/superset/issues/22695)) ([d591cc8](https://github.com/apache/superset/commit/d591cc80820c57c54e0e1f7e269527af2ac3c37b))
- **sqllab:** invalid table metadata request ([#21304](https://github.com/apache/superset/issues/21304)) ([222f1e7](https://github.com/apache/superset/commit/222f1e7ea8e95066abd78a06f470d74777f87cc5))
- **sqllab:** make to hide the delete button of most recent query history ([#19358](https://github.com/apache/superset/issues/19358)) ([5db36ec](https://github.com/apache/superset/commit/5db36ec81c0e8b6d4ce8435a77c3dce8a036fec6))
- **sqllab:** missing zero values while copy-to-clipboard ([#21153](https://github.com/apache/superset/issues/21153)) ([4e23d62](https://github.com/apache/superset/commit/4e23d62d4f3714808af8b915caa5790900688526))
- **sqllab:** null database with backend persistence ([#19548](https://github.com/apache/superset/issues/19548)) ([2d81c4c](https://github.com/apache/superset/commit/2d81c4c79f93b9954d5090964b4f140bfb35723e))
- **sqllab:** Overflow bigint in json-tree view ([#22609](https://github.com/apache/superset/issues/22609)) ([a8f3a4f](https://github.com/apache/superset/commit/a8f3a4fb6e90f061a9b87e7366f7f7c7184ca629))
- **sqllab:** perf regression on [#21532](https://github.com/apache/superset/issues/21532) refactor ([#21632](https://github.com/apache/superset/issues/21632)) ([8d1b7ec](https://github.com/apache/superset/commit/8d1b7ecfde4eadbf74af1a467adaf69102acc404))
- **sqllab:** Query limit dropdown number breaks to separate lines ([#17382](https://github.com/apache/superset/issues/17382)) ([1beda79](https://github.com/apache/superset/commit/1beda796f2d5eeaf5a7c6a1d9ba3ff8bffa39dfe))
- **sqllab:** remove link to sqllab if missing perms ([#22566](https://github.com/apache/superset/issues/22566)) ([5b2ca97](https://github.com/apache/superset/commit/5b2ca97341306b8b06ae55ff77eb2528a57f20ce))
- **sqllab:** remove set state on component update lifecycle ([#21771](https://github.com/apache/superset/issues/21771)) ([792820e](https://github.com/apache/superset/commit/792820ef480b7e8c44b5cb3f9c45b51b42add794))
- **sqllab:** Removed the tooltip from CopyToClipboard button in sqllab ([#18749](https://github.com/apache/superset/issues/18749)) ([91236a5](https://github.com/apache/superset/commit/91236a5225d23b3d7b44c3c93cfdf5a41251e6cc))
- **sqllab:** Replace stringified 'null' schema column values with NULL ([#18992](https://github.com/apache/superset/issues/18992)) ([19eb73b](https://github.com/apache/superset/commit/19eb73b3162bcfb404f83fc2d1669422b03f8510))
- **sqllab:** result set min-height ([#21016](https://github.com/apache/superset/issues/21016)) ([58245dd](https://github.com/apache/superset/commit/58245dd7f7343da6b8a1e64be654f3d77991ec4d))
- **sqllab:** resultset disappeared on switching tabs ([#21741](https://github.com/apache/superset/issues/21741)) ([d7ee443](https://github.com/apache/superset/commit/d7ee443a134f88aa7fff8d2d038b50c94fb039e2))
- **sqllab:** reverts [#22695](https://github.com/apache/superset/issues/22695) ([#22861](https://github.com/apache/superset/issues/22861)) ([0045816](https://github.com/apache/superset/commit/0045816772b17d80050a46d6e18e7e5a4edc18fb))
- **sqllab:** SqlEditorLeftBar listening to database changes ([#21628](https://github.com/apache/superset/issues/21628)) ([71bf267](https://github.com/apache/superset/commit/71bf2673071d5db6688fbaefd4457aeeae3464bb))
- **sqllab:** SqlJsonExecutionContext.query null pointer ([#16997](https://github.com/apache/superset/issues/16997)) ([cde4cdc](https://github.com/apache/superset/commit/cde4cdcd0cb23f3b4a34172231ae4318456fda54))
- **sqllab:** tracking url and error alert padding ([#20937](https://github.com/apache/superset/issues/20937)) ([ac58582](https://github.com/apache/superset/commit/ac585821d8d6810d76a244a322cd1e24d15c265a))
- **sqllab:** type error on renderBigIntStr ([#22813](https://github.com/apache/superset/issues/22813)) ([02a3c0d](https://github.com/apache/superset/commit/02a3c0d0e619d7c203889e383c97d6ffdc2ea891))
- **sqllab:** Un-render deselected tabs ([#18934](https://github.com/apache/superset/issues/18934)) ([420a63f](https://github.com/apache/superset/commit/420a63f3436fb01084720aa9fdc863c1766a3262))
- **sqllab:** unable to create new tabs ([#21260](https://github.com/apache/superset/issues/21260)) ([034ee1c](https://github.com/apache/superset/commit/034ee1c3c1fda20b238ba1cc9093a4156d9fa01e))
- **sqllab:** update persistent queryEditor keys ([#21246](https://github.com/apache/superset/issues/21246)) ([ad6b98c](https://github.com/apache/superset/commit/ad6b98c2b7db12b4c555f06bc87fe34f47216247))
- **sqllab:** Updated blank states for query results and query history ([#19111](https://github.com/apache/superset/issues/19111)) ([bb618a4](https://github.com/apache/superset/commit/bb618a47ff1e1747cf66bffa8bceee133a5c9064))
- **sqllab:** wiped out unsaved changes by delayed actions ([#21877](https://github.com/apache/superset/issues/21877)) ([fb8231b](https://github.com/apache/superset/commit/fb8231b50c4ed8fc10db5bc50594b23110bdc515))
- sqloxide optional ([#19570](https://github.com/apache/superset/issues/19570)) ([6136942](https://github.com/apache/superset/commit/61369427594adde9f6a3e6ffcc90ffa54b67adab))
- **sql:** unable to filter text with quotes ([#17881](https://github.com/apache/superset/issues/17881)) ([9671384](https://github.com/apache/superset/commit/9671384efebb2cf77fcd9bedae63192c0cf6570d))
- **ssh_tunnel:** Display SSHTunnel Switch when editing a DB that was created with the Dynamic Form ([#23195](https://github.com/apache/superset/issues/23195)) ([e0a394f](https://github.com/apache/superset/commit/e0a394fe9b5804cc86fc585f338f480bdf8f4a3e))
- **ssh_tunnel:** Fix bug on database edition for databases with ssh tunnels ([#23006](https://github.com/apache/superset/issues/23006)) ([ddd8d17](https://github.com/apache/superset/commit/ddd8d17aa4785918afc5395312678d206a2f100a))
- **ssh-tunnel:** add password to `from_private_key` function ([#23175](https://github.com/apache/superset/issues/23175)) ([f5a5c26](https://github.com/apache/superset/commit/f5a5c261e0691a6d14c8a8080d2c7f81c7d0aafe))
- **ssh-tunnel:** fix dataset creation flow through modal for DB with tunnel ([#22581](https://github.com/apache/superset/issues/22581)) ([d18c7d6](https://github.com/apache/superset/commit/d18c7d6128d7e99f7756ad4006f79df3fb0cc3d6))
- **ssh-tunnel:** update fields for open tunnel with private + private key passwords ([#22764](https://github.com/apache/superset/issues/22764)) ([e6271f0](https://github.com/apache/superset/commit/e6271f0ca7e6b96a8975dac7cea936ecc6c1ca47))
- **ssh-tunnel:** wrap pkey into StringIO buffer before creating the tunnel ([#22763](https://github.com/apache/superset/issues/22763)) ([c536f71](https://github.com/apache/superset/commit/c536f713d6bfd4865f7d853e75c83096e57ec21a))
- **sshtunnel:** argument params to properly setting `server_port` ([#23196](https://github.com/apache/superset/issues/23196)) ([a6d714b](https://github.com/apache/superset/commit/a6d714b0c46c609703c1f6d088ae3f54bae94643))
- Stop query in SQL Lab with impala engine ([#22635](https://github.com/apache/superset/issues/22635)) ([8bf6d80](https://github.com/apache/superset/commit/8bf6d801553a13552831be0fe8ed41bf5171824c))
- string aggregation is incorrect in PivotTableV2 ([#19102](https://github.com/apache/superset/issues/19102)) ([22b7496](https://github.com/apache/superset/commit/22b7496d2ea444ca619aa21f9e820bb610cc5648))
- stringify ValueErrors for NaT types ([#22628](https://github.com/apache/superset/issues/22628)) ([804e89d](https://github.com/apache/superset/commit/804e89d725cd9202ff595d1fe5b49bdffa235d73))
- **style:** throw if there is no theme ([#761](https://github.com/apache/superset/issues/761)) ([9907d13](https://github.com/apache/superset/commit/9907d130634822490059782288eb309b545aad59))
- Styling fixes for horizontal filter bar ([#22337](https://github.com/apache/superset/issues/22337)) ([d2b76a8](https://github.com/apache/superset/commit/d2b76a8b1a42b16c72979693380f26b4d8c02fe5))
- subject Remove margin to fit last label ([#900](https://github.com/apache/superset/issues/900)) ([4e27daf](https://github.com/apache/superset/commit/4e27daf8a2b252e8f96802fc62dd2641b1a5fe06))
- Sunburst chart respects and prefers Metric's D3 Format ([#282](https://github.com/apache/superset/issues/282)) ([97735be](https://github.com/apache/superset/commit/97735be32a41ac9a33c987af14cac5e30fc3bcdd))
- **superset-embedded-sdk:** Buffer is not defined ([#21641](https://github.com/apache/superset/issues/21641)) ([7ec136f](https://github.com/apache/superset/commit/7ec136fec27a29338493745ae91ec110708a8a2a))
- **superset-ui-legacy-preset-chart-deckgl:** fix download map as image ([#25](https://github.com/apache/superset/issues/25)) ([18d0c48](https://github.com/apache/superset/commit/18d0c48333b1b620d586163f080dcc214394204b))
- **superset-ui-query:** add unit tests for [#387](https://github.com/apache/superset/issues/387) ([#390](https://github.com/apache/superset/issues/390)) ([8ab578e](https://github.com/apache/superset/commit/8ab578e121b3057d9086fbae3c7c3eafb916dc32))
- superset-ui/core code coverage ([#20676](https://github.com/apache/superset/issues/20676)) ([8d4994a](https://github.com/apache/superset/commit/8d4994a89900c2cf636444e4febad61ce3b69d68))
- superset-ui/core codes coverage ([#20324](https://github.com/apache/superset/issues/20324)) ([d04357c](https://github.com/apache/superset/commit/d04357c47bec7bac49c602f3d2166375892200ad))
- **superset.cli:** superset cli group doesn't support superset extension app ([#17539](https://github.com/apache/superset/issues/17539)) ([da75028](https://github.com/apache/superset/commit/da7502829527b4a2221cfbb4495859d517d47ec4))
- **superset:** Fixed API for bulk delete of embedded dashboards ([#21911](https://github.com/apache/superset/issues/21911)) ([7edf1fb](https://github.com/apache/superset/commit/7edf1fbdf0593261d1c4e99ae0dbc525bab804a3))
- Support the Clipboard API in modern browsers ([#20058](https://github.com/apache/superset/issues/20058)) ([0e38c68](https://github.com/apache/superset/commit/0e38c686c69dd7c8c5cb4a9b3615b395b02ae973))
- Supports form_data param in old Explore endpoint ([#21469](https://github.com/apache/superset/issues/21469)) ([2c7323a](https://github.com/apache/superset/commit/2c7323a87def2a60581c162db34783a48307e9aa))
- suppress translation warning in jest ([#20404](https://github.com/apache/superset/issues/20404)) ([9fad26f](https://github.com/apache/superset/commit/9fad26fa1919fceda4abdfce0b973d536b42b6af))
- switch form_data between different datasource ([#20867](https://github.com/apache/superset/issues/20867)) ([cb9ae38](https://github.com/apache/superset/commit/cb9ae383614456fc872dbb257a14e30fcf2434bf))
- Switch tab on drag hover ([#21648](https://github.com/apache/superset/issues/21648)) ([b2a360f](https://github.com/apache/superset/commit/b2a360fa14046e384e48ed6273f42eef394ad005))
- Table Autosizing Has Unnecessary Scroll Bars ([#19628](https://github.com/apache/superset/issues/19628)) ([9554135](https://github.com/apache/superset/commit/955413539b3edd892efd6bc069240efb5f5a29ac))
- Table chart column config issue ([#19841](https://github.com/apache/superset/issues/19841)) ([9376940](https://github.com/apache/superset/commit/9376940282475e47b0213cee6336551502463a69))
- Table content disappears when switching between tabs ([#21251](https://github.com/apache/superset/issues/21251)) ([0c87ff7](https://github.com/apache/superset/commit/0c87ff783ac00ad0ac4f7544ff4d910cd2d105b7))
- table viz sort icon bottom aligned ([#20447](https://github.com/apache/superset/issues/20447)) ([93774d1](https://github.com/apache/superset/commit/93774d1860fd40dfee1f18e2787d9d0b79b551e2))
- **table-chart:** don't color empty cells in table chart with color formatters ([#21501](https://github.com/apache/superset/issues/21501)) ([60bab42](https://github.com/apache/superset/commit/60bab4269f1a0ebd42c85aab1ecd8c34ae1b9448))
- **table:** Fix backend pagination table case ([#1007](https://github.com/apache/superset/issues/1007)) ([716a962](https://github.com/apache/superset/commit/716a9624c07f3836cc1edeb40aafebea4fafe645))
- **table:** fix rendering boolean ([#256](https://github.com/apache/superset/issues/256)) ([33e9610](https://github.com/apache/superset/commit/33e96103017bf169bceded3ac822eef3c62bfb67))
- **table:** fix sorting, column width calculation, and text wrapping ([#253](https://github.com/apache/superset/issues/253)) ([7fff83e](https://github.com/apache/superset/commit/7fff83e6dc32e4002885724b877192755561edee))
- **table:** fixed performance issue ([#241](https://github.com/apache/superset/issues/241)) ([aa9f1c0](https://github.com/apache/superset/commit/aa9f1c0b89760895a3cb77b6e45415768e1ecca6))
- **table:** TableVis dynamic height enabled ([#229](https://github.com/apache/superset/issues/229)) ([f8358fc](https://github.com/apache/superset/commit/f8358fcd229057029a7cabae7230d2f92e411a9c)), closes [#233](https://github.com/apache/superset/issues/233)
- **tablevis:** Set proper width for each column ([#189](https://github.com/apache/superset/issues/189)) ([d922d1e](https://github.com/apache/superset/commit/d922d1e244bbe63185d5df3d251188606899a4b5))
- **tablevis:** update datatable change ([02b9772](https://github.com/apache/superset/commit/02b9772ea890d6c3b67a986d97473acb62ef099e))
- **tags:** Adding **init** to tags ([#21591](https://github.com/apache/superset/issues/21591)) ([18ec294](https://github.com/apache/superset/commit/18ec294336865cb88329831fc761294f914c6319))
- take form_data reference for metrics for pivot_v2 table reports ([#21029](https://github.com/apache/superset/issues/21029)) ([e13c5b2](https://github.com/apache/superset/commit/e13c5b2b7b1be52e74643981990eb646ccc76d20))
- Talisman configuration ([#22591](https://github.com/apache/superset/issues/22591)) ([84177cb](https://github.com/apache/superset/commit/84177cbc750b9a72eaaa0d7b624821caa8bb2190))
- **temporary-cache:** when user is anonymous ([#20181](https://github.com/apache/superset/issues/20181)) ([64c4226](https://github.com/apache/superset/commit/64c4226817b04ff598be29b52d8e2c4a679ef70a))
- **teradata:** LIMIT syntax ([#18240](https://github.com/apache/superset/issues/18240)) ([8c37654](https://github.com/apache/superset/commit/8c376548e3cf6464e5710e80120f82227174fcdc))
- **test:** make test_clean_requests_after_schema_grant more idempotent ([#19625](https://github.com/apache/superset/issues/19625)) ([738bd04](https://github.com/apache/superset/commit/738bd04b4fde728474233e562a97a6c84efc8049))
- tests can failed on different order executions ([#17885](https://github.com/apache/superset/issues/17885)) ([886e4ef](https://github.com/apache/superset/commit/886e4ef7f544ec50922fadb96c7edd8ac1102d67))
- **textarea-control:** ace editor input exception ([#18146](https://github.com/apache/superset/issues/18146)) ([7bb8674](https://github.com/apache/superset/commit/7bb867407af99060b8a4eb03a6d8bf8e15569abc))
- The dynamic form to connect to Snowflake DB is not returning any errors ([#20013](https://github.com/apache/superset/issues/20013)) ([c6dd7fe](https://github.com/apache/superset/commit/c6dd7fedbd9547dd5a3374b1c5f30e3337077260))
- the TimePicker overlay the AdhocFilter ([#22234](https://github.com/apache/superset/issues/22234)) ([0fdc520](https://github.com/apache/superset/commit/0fdc52079704ae33ab59385b789b9c4768e8ca63))
- Time Column on Generic X-axis ([#23021](https://github.com/apache/superset/issues/23021)) ([464ddee](https://github.com/apache/superset/commit/464ddee4b4164460193027645d87cb25e7b2320e))
- time comparision ([#19659](https://github.com/apache/superset/issues/19659)) ([d7dd411](https://github.com/apache/superset/commit/d7dd4119d4277dcd4682631de154b6aae27cbe69))
- Time filter position and click in Horizontal FilterBar ([#22338](https://github.com/apache/superset/issues/22338)) ([f64423a](https://github.com/apache/superset/commit/f64423a7409955561a4a27dba6912ad34d717220))
- time filter should be [start, end) ([#19166](https://github.com/apache/superset/issues/19166)) ([e4c9a0d](https://github.com/apache/superset/commit/e4c9a0d8aea3c06abf75cea4ef259bbee804d304))
- time formatter test ([#1012](https://github.com/apache/superset/issues/1012)) ([b354c15](https://github.com/apache/superset/commit/b354c15b0008966d1e5acc901cda6f7c528dc88f))
- time grain can't be removed in explore ([#21644](https://github.com/apache/superset/issues/21644)) ([4c17f0e](https://github.com/apache/superset/commit/4c17f0e71e05caa55410edb2317e084c52a25440))
- time grain key from P0.25Y to P3M ([#21919](https://github.com/apache/superset/issues/21919)) ([c6c9215](https://github.com/apache/superset/commit/c6c9215a2b8651be13151939f7206c78868e2a7c))
- Time Offset in SQLite and refine logic in Date Type conversion ([#21378](https://github.com/apache/superset/issues/21378)) ([2dfcba0](https://github.com/apache/superset/commit/2dfcba04b0e191cc46405a5514f99bf61831f48d))
- Time range filter applied on a dashboard is not persisting to the chart explore ([#22920](https://github.com/apache/superset/issues/22920)) ([e9423c3](https://github.com/apache/superset/commit/e9423c3c878f89124041dc2ee4ffaa7c9f461491))
- **time-format:** remove week number ([#493](https://github.com/apache/superset/issues/493)) ([7140b11](https://github.com/apache/superset/commit/7140b116ad988f5175e2e355fdc5e4088cc158e1))
- **time-series table:** display null values in time-series table and sortable ([#19024](https://github.com/apache/superset/issues/19024)) ([d539fc2](https://github.com/apache/superset/commit/d539fc217a52bb1fc82ebe0f6d5aa2f03031db28))
- Timeseries visualization with Chart Source = Query ([#20795](https://github.com/apache/superset/issues/20795)) ([2c01097](https://github.com/apache/superset/commit/2c010974e8c3607ff19d864c9edd910b1f7920e8))
- title case in menus ([#17135](https://github.com/apache/superset/issues/17135)) ([0257cf7](https://github.com/apache/superset/commit/0257cf774d034f17d60c84cb6d1bd6762d7720fb))
- **tooltip-not-dissapeared:** make the tooltip disappear when mouse away ([#18892](https://github.com/apache/superset/issues/18892)) ([ca93d63](https://github.com/apache/superset/commit/ca93d63bbb72630f90afcd7fc514014cad9b3e52))
- tooltips on nvd3 charts ([#1162](https://github.com/apache/superset/issues/1162)) ([5c0d196](https://github.com/apache/superset/commit/5c0d196c69a6eb33397dddfbcb133b09b5d66f53))
- **translations:** French translation (typo fixes) ([#21942](https://github.com/apache/superset/issues/21942)) ([a993c3c](https://github.com/apache/superset/commit/a993c3ca2c16d5e8dcfeee6fdd800c058a03731c))
- trap SQLAlchemy common exceptions & throw 422 error instead ([#19672](https://github.com/apache/superset/issues/19672)) ([4513cc4](https://github.com/apache/superset/commit/4513cc475831c3fd4869b44255edf91dabe18e0f))
- **treemap-v2:** color scheme not work when there is only one dimension ([#20671](https://github.com/apache/superset/issues/20671)) ([bd6037e](https://github.com/apache/superset/commit/bd6037ef50a579c9e9e3a133482670f6acb5fe5f))
- **Trino:** create `PrestoBaseEngineSpec` base class to share common code between Trino and Presto ([#21066](https://github.com/apache/superset/issues/21066)) ([ccb293a](https://github.com/apache/superset/commit/ccb293a083acbaae8c975059f74cac341c7dbe9a))
- **trino:** Fix Trino timestamp conversion ([#21737](https://github.com/apache/superset/issues/21737)) ([90d79c7](https://github.com/apache/superset/commit/90d79c78d2d507fba28f08a28eaf510e0872c149))
- type of AnnotationLayer ([#21878](https://github.com/apache/superset/issues/21878)) ([f4a4ab4](https://github.com/apache/superset/commit/f4a4ab41e05be90b31ab2f9d2a0f23110bd5df21))
- typing issues surfaced by typescript 3.7 ([#260](https://github.com/apache/superset/issues/260)) ([62e801f](https://github.com/apache/superset/commit/62e801fd0746bb418ae8f83e7d9179fc9cca9ee4))
- Typing of labelMap ([#21181](https://github.com/apache/superset/issues/21181)) ([1143e17](https://github.com/apache/superset/commit/1143e17742d1fa4c4cbae2c86e4998f4cc7e9f88))
- typo on doc string ([#19346](https://github.com/apache/superset/issues/19346)) ([2af2d00](https://github.com/apache/superset/commit/2af2d00e852032e1d4eaaa50fd7e8d5415a1db16))
- **ui:** Quick Fix for app_icon ([#21399](https://github.com/apache/superset/issues/21399)) ([9ada541](https://github.com/apache/superset/commit/9ada541fd9a69b4bc6c3d1095e5c60f6c7dc955a))
- unable bump new version ([#1434](https://github.com/apache/superset/issues/1434)) ([9b059b8](https://github.com/apache/superset/commit/9b059b8127edf3bb27edbec86d5401cd06efabcf))
- Unable to download the Dashboard as image in case there's an image added through Markdown ([#20362](https://github.com/apache/superset/issues/20362)) ([c5d3678](https://github.com/apache/superset/commit/c5d3678a31e622aab0648c9176883f0932870558))
- Unable to export multiple Dashboards with the same name ([#20383](https://github.com/apache/superset/issues/20383)) ([3fe53f7](https://github.com/apache/superset/commit/3fe53f735e645a96ca5158054b5c9cb26e3e83e7))
- Unable to select None for Alert's log retention ([#17268](https://github.com/apache/superset/issues/17268)) ([85a19a9](https://github.com/apache/superset/commit/85a19a9cc21b47bb701574d6a63b1633686bfb1b))
- unable to set destroyOnClose on ModalTrigger ([#20201](https://github.com/apache/superset/issues/20201)) ([e140b7a](https://github.com/apache/superset/commit/e140b7aa87c06068890ee02379252bcb3cbefe95))
- unable to show view as table modal ([#21025](https://github.com/apache/superset/issues/21025)) ([dfe5a04](https://github.com/apache/superset/commit/dfe5a0493886136620ec3046d315b8d1159503d5))
- Unable to sync columns when dataset name has '+' ([#21019](https://github.com/apache/superset/issues/21019)) ([0c84203](https://github.com/apache/superset/commit/0c8420305368e1ea54deb48535dff77b2c84ba38))
- unambiguous trino driver ([#18683](https://github.com/apache/superset/issues/18683)) ([40ab26d](https://github.com/apache/superset/commit/40ab26d4f14b2fbf24ba46a7bf8c75af1f366c52))
- undefined error when adding extra sequential color scheme ([#18152](https://github.com/apache/superset/issues/18152)) ([c77d24c](https://github.com/apache/superset/commit/c77d24cda31558e374d7a253f02e7131dd6c45f2))
- unexpected commit causes pytest failure ([#20780](https://github.com/apache/superset/issues/20780)) ([922b4b8](https://github.com/apache/superset/commit/922b4b8d1dd6767d9e675ce95b3ffefe16034a7a))
- Unexpected error on simple filter ([#22814](https://github.com/apache/superset/issues/22814)) ([d479009](https://github.com/apache/superset/commit/d479009e35a86dfda321492afeda2a1683a9345a))
- Unhandled exception Str Column Type ([#22147](https://github.com/apache/superset/issues/22147)) ([cc38400](https://github.com/apache/superset/commit/cc38400d7120188b4d0b29f03012ab3e06d952b4))
- Unnecessary queries when changing filter values ([#16994](https://github.com/apache/superset/issues/16994)) ([c471a85](https://github.com/apache/superset/commit/c471a851705a9ca85dabf6090eef3ca368210790))
- unset row_limit when it's not a number ([#387](https://github.com/apache/superset/issues/387)) ([0cb4e4f](https://github.com/apache/superset/commit/0cb4e4f9ffcf4091ba78c7fcea4e317c1a9a5858))
- update chart sorting control labels/descriptions ([#1462](https://github.com/apache/superset/issues/1462)) ([3894cb0](https://github.com/apache/superset/commit/3894cb0e268ee488e042fa774e6e03eb818c8bda))
- update connection modal to use existing catalog ([#20372](https://github.com/apache/superset/issues/20372)) ([160e674](https://github.com/apache/superset/commit/160e674b9049c006d3fada3e99a89a2c9dbe80ac))
- Update eslint error message to reflect location of antd components ([#19857](https://github.com/apache/superset/issues/19857)) ([768e4b7](https://github.com/apache/superset/commit/768e4b7a546f7f6abdbc079f117014eac0cec23d))
- Update exception for DatasourceNotFound from `DatasourceDao.get_datasource()` ([#21217](https://github.com/apache/superset/issues/21217)) ([653c9f0](https://github.com/apache/superset/commit/653c9f0e7fd319bf0a10f75839fa8f89d4fea66f))
- update kubernetes.mdx ([#14512](https://github.com/apache/superset/issues/14512)) ([a304116](https://github.com/apache/superset/commit/a3041166a30fed715f41c13d96e0076e05f249d0))
- update lineMulti when queryData changes ([#782](https://github.com/apache/superset/issues/782)) ([ec1a1a2](https://github.com/apache/superset/commit/ec1a1a2ec5ac78346b4b72d116e05e1c6d8c6cd3))
- Update package-lock.json of superset-frontend and cypress-base ([#17125](https://github.com/apache/superset/issues/17125)) ([5253193](https://github.com/apache/superset/commit/525319370837f5adbb10466f51212289db1d13db))
- update package.json ([9377688](https://github.com/apache/superset/commit/937768808155f8b9ec9c68ce2b883fbfa6e2900a))
- update Permissions for right nav ([#19051](https://github.com/apache/superset/issues/19051)) ([4bf4d58](https://github.com/apache/superset/commit/4bf4d58423e39c3cf3b592adece41049984ffced))
- update slug name ([#17961](https://github.com/apache/superset/issues/17961)) ([765c72a](https://github.com/apache/superset/commit/765c72a8584068fdac85195a71279477a12db632))
- update standalone url for slack reports ([#18756](https://github.com/apache/superset/issues/18756)) ([5d2e726](https://github.com/apache/superset/commit/5d2e726f76cb104552acb1abeda06bd8cd715fe6))
- Update time grain expressions for Spark >= 3.x ([#18690](https://github.com/apache/superset/issues/18690)) ([03b2b06](https://github.com/apache/superset/commit/03b2b06e90f34e67fbda1172eab2c7de6dc8246a))
- Update typo in docker-add-drivers.mdx ([#21965](https://github.com/apache/superset/issues/21965)) ([85c9480](https://github.com/apache/superset/commit/85c9480791b46496b955f22e300171417d6fe01f))
- update values for default timezone selector ([#17124](https://github.com/apache/superset/issues/17124)) ([ae4ced8](https://github.com/apache/superset/commit/ae4ced8da6933cdc657452d1f11415c49c6c68b8))
- update yarn.lock ([#1067](https://github.com/apache/superset/issues/1067)) ([8d1e28c](https://github.com/apache/superset/commit/8d1e28c8bb34d116b279c29323042c74899be61c))
- update yarn.lock for react-icons ([636dc28](https://github.com/apache/superset/commit/636dc28ced343bde810929c0dda8a6a77ce34496))
- Updated connection string for Firebolt ([#17242](https://github.com/apache/superset/issues/17242)) ([0a660a1](https://github.com/apache/superset/commit/0a660a1a3852da0e636c0d4e094d63bb970561b9))
- URI form is blank when trying to connect from sql lab ([#20004](https://github.com/apache/superset/issues/20004)) ([cc026e9](https://github.com/apache/superset/commit/cc026e9fec156bb2f4a89c59d3291a8900a84e0d))
- Use cache_manager.cache rather than cache_manager.data_cache for caching table metadata ([#20726](https://github.com/apache/superset/issues/20726)) ([8bfc9b7](https://github.com/apache/superset/commit/8bfc9b76a6d109dd5ca7bb5c3eb3b64f771f73b5))
- use correct number format ([#47](https://github.com/apache/superset/issues/47)) ([ec5be03](https://github.com/apache/superset/commit/ec5be03d8fbb6a3c44d660f2b53492d654bc6cbb))
- Use Home page in SPA ([#21006](https://github.com/apache/superset/issues/21006)) ([dcab326](https://github.com/apache/superset/commit/dcab32676b4dede51ab12cf1d90a6c1c61697d93))
- use proper time grain when using native filters or filter box ([#1104](https://github.com/apache/superset/issues/1104)) ([e51f034](https://github.com/apache/superset/commit/e51f034317e5dd46afd92f5f0c3547ad3370475a))
- Use SPA Dataset link in Chart and Dashboard ([#20941](https://github.com/apache/superset/issues/20941)) ([96a63bc](https://github.com/apache/superset/commit/96a63bcbfedb72a9f2b3a65eb31fc231d851496f))
- user UUIDs on export for Native Filter Configuration ([#18562](https://github.com/apache/superset/issues/18562)) ([7194a01](https://github.com/apache/superset/commit/7194a01040c679d813c147f17bb6d346b16930ab))
- Users being able to update datasets across DBs ([#17348](https://github.com/apache/superset/issues/17348)) ([a1961cf](https://github.com/apache/superset/commit/a1961cfc6ffc77354c7917d0a5d29d30df1d83ac))
- **utils:** use getaddrinfo for hostname check to support ipv6 ([#21042](https://github.com/apache/superset/issues/21042)) ([2aa3bb6](https://github.com/apache/superset/commit/2aa3bb6c00fa4a86680622e714f818b46962155d))
- **utils:** use getaddrinfo response to support dual-stack port checks ([#21043](https://github.com/apache/superset/issues/21043)) ([38782bb](https://github.com/apache/superset/commit/38782bb98aa1ca85ef97c73ce9b7dea658ee047e))
- Validate required fields in sql_json API ([#21003](https://github.com/apache/superset/issues/21003)) ([a2b21b5](https://github.com/apache/superset/commit/a2b21b55be8941e1756bd6c10f5b3dd063a20ee3))
- various typo fixes in MD files ([#17309](https://github.com/apache/superset/issues/17309)) ([6b1de57](https://github.com/apache/superset/commit/6b1de57207c38ade4a3bb5700e95066cc14f70ee))
- Verify when null value should be undefined in Select ([#17013](https://github.com/apache/superset/issues/17013)) ([a57ae35](https://github.com/apache/superset/commit/a57ae350111586382ea076a98a855ee7e3952202))
- **VERSIONED_EXPORTS:** Ensure dashboards and charts adher to the VERSIONED_EXPORTS feature flag ([#20368](https://github.com/apache/superset/issues/20368)) ([c3fdd52](https://github.com/apache/superset/commit/c3fdd526977318107685e9b9b28540f2eb89227d))
- **ViewQuery-Modal:** Copy icon is out of box when resize query modal ([#21243](https://github.com/apache/superset/issues/21243)) ([1cc2148](https://github.com/apache/superset/commit/1cc214853864760de5bfec409fe5934635711d70))
- **views/core:** iteration over None type ([#14305](https://github.com/apache/superset/issues/14305)) ([c54027a](https://github.com/apache/superset/commit/c54027a0f92251c0f6d18d7277309208360c0b9c))
- Visualizations don't load when using keyboard shortcuts ([#17542](https://github.com/apache/superset/issues/17542)) ([a959e6d](https://github.com/apache/superset/commit/a959e6df453d204b074440c1127d2b30930adfaa))
- **viz-gallery:** respect denylist in viz gallery ([#22658](https://github.com/apache/superset/issues/22658)) ([08f45ef](https://github.com/apache/superset/commit/08f45ef207fb159bf0de49dd0a90f423c77965a7))
- **viz:** BigQuery time grain 'minute'/'second' throws an error ([#20350](https://github.com/apache/superset/issues/20350)) ([5afeba3](https://github.com/apache/superset/commit/5afeba34bd72526844d0f71764309a6669d96c5a))
- **viz:** Header scrolling for Time Table in dashboard ([#20874](https://github.com/apache/superset/issues/20874)) ([99085d5](https://github.com/apache/superset/commit/99085d583ddadf8e092f6648195cde29efef6976))
- **webdriver:** default WEBDRIVER_OPTION_ARGS and update Firefox deps ([#23388](https://github.com/apache/superset/issues/23388)) ([b92e4fb](https://github.com/apache/superset/commit/b92e4fb49ea8756dbedff17cc20d5f746ea5df1f))
- **websocket:** bump ts-node to fix startup error ([#22563](https://github.com/apache/superset/issues/22563)) ([7df1d70](https://github.com/apache/superset/commit/7df1d70a9512bfed146b4026d1e0d6f69165804a))
- weight tooltip issue ([#19397](https://github.com/apache/superset/issues/19397)) ([f6d550b](https://github.com/apache/superset/commit/f6d550b7fc3643350483850064e65dbd3d026dc4))
- welcome page user authentication check ([#20605](https://github.com/apache/superset/issues/20605)) ([92bf1b8](https://github.com/apache/superset/commit/92bf1b8ef6b42c9624876a2433077173818795b6))
- word cloud import bug ([#65](https://github.com/apache/superset/issues/65)) ([381d51d](https://github.com/apache/superset/commit/381d51d8a40723e0938ba5d9b96e572234434461))
- Workaround for sqlparse issue [#652](https://github.com/apache/superset/issues/652) ([#17995](https://github.com/apache/superset/issues/17995)) ([63ca09e](https://github.com/apache/superset/commit/63ca09e345ef8a474625d7baae4f0c4f0a44c0d1))
- World Map right-click value ([#21209](https://github.com/apache/superset/issues/21209)) ([d41f44f](https://github.com/apache/superset/commit/d41f44fcdf387072bc5d7700a5e8871c6594baef))
- **world-map:** remove categorical color option ([#19781](https://github.com/apache/superset/issues/19781)) ([5e468f7](https://github.com/apache/superset/commit/5e468f7a4cccc496ccafa52f9aba5b7688145fe4))
- wrong type for filters field ([#183](https://github.com/apache/superset/issues/183)) ([3d6d622](https://github.com/apache/superset/commit/3d6d622b18da74c38b45bbe8f08c8513e4cca9f1))
- X Axis should be called Y Axis when using the Bar Chart V2 on Horizontal mode ([#20659](https://github.com/apache/superset/issues/20659)) ([c29261b](https://github.com/apache/superset/commit/c29261b63dee723f108b3404e29a498ecf8421f8))
- y axis bounds when input are nan ([#22](https://github.com/apache/superset/issues/22)) ([532feac](https://github.com/apache/superset/commit/532feac81a9ce2fd46c92fbaac5c0bacbb25ce48))
- y-axis bounds for stacked viz types ([#45](https://github.com/apache/superset/issues/45)) ([dde88df](https://github.com/apache/superset/commit/dde88df4e02797c330754a5ec199cb61bf71137e))

### Code Refactoring

- **chart:** remove and rename fields in ChartProps ([#174](https://github.com/apache/superset/issues/174)) ([3df26ae](https://github.com/apache/superset/commit/3df26ae76da8e2945d6416bb8a61176191410804))
- make @superset-ui/core peer dependency ([#111](https://github.com/apache/superset/issues/111)) ([ca04f8c](https://github.com/apache/superset/commit/ca04f8ce85e2b4dd1153a862c0788f013c797ba1))

- Add overwritePolicy for Registry (#37) ([307ce86](https://github.com/apache/superset/commit/307ce86ecefd52219a78a53ae7231468d7e7d24e)), closes [#37](https://github.com/apache/superset/issues/37)
- Rename `D3Formatter` to `D3NumberFormatter` (#36) ([f6ea69b](https://github.com/apache/superset/commit/f6ea69b7b275ea65cce5344573921472bf8bd5c5)), closes [#36](https://github.com/apache/superset/issues/36)
- Rename ColorScheme field 'name' to 'id' (#35) ([4e39bf7](https://github.com/apache/superset/commit/4e39bf7f6eadbef19aaed48aec10cba6eeaf9164)), closes [#35](https://github.com/apache/superset/issues/35)
- Make CategoricalColorScale instance a function and remove .toFunction() (#33) ([af725ce](https://github.com/apache/superset/commit/af725ce874563b9c02af1e9248ed751074c352b8)), closes [#33](https://github.com/apache/superset/issues/33)

### Features

- add tableselector to dataset creation page ([#21075](https://github.com/apache/superset/issues/21075)) ([8c2719b](https://github.com/apache/superset/commit/8c2719b11cebe451c5ba68193cf8dd51e4dce8e3))
- 🎸 add .clone() function to ChartMetadata ([#112](https://github.com/apache/superset/issues/112)) ([9454aed](https://github.com/apache/superset/commit/9454aed59f43d7bc634c174f9784c49c0c7f2560))
- 🎸 Improved QueryObject to handle more fields ([#116](https://github.com/apache/superset/issues/116)) ([86c0c26](https://github.com/apache/superset/commit/86c0c262130e384d4379b93110349226eff5ca95))
- 🎸 line chart makes first appearance ([7d3e683](https://github.com/apache/superset/commit/7d3e6835c8ad85560d93049c949236f3646053f6))
- 🚀 Docs V2 CI Script ([#18560](https://github.com/apache/superset/issues/18560)) ([9c3205b](https://github.com/apache/superset/commit/9c3205b5733a10ba9464f86674d23e61a0cf77e3))
- 10/15/30 min grain to Pinot ([#19724](https://github.com/apache/superset/issues/19724)) ([a6f4601](https://github.com/apache/superset/commit/a6f46013d966b243fbdca072e7898cdbf2a2f3d6))
- a simple LRUCache in frontend ([#20842](https://github.com/apache/superset/issues/20842)) ([55a89df](https://github.com/apache/superset/commit/55a89dfac93f9855dbf1beb2ee0c0f21da54095b))
- add 'dashboard.nav.right' extension to registry ([#20835](https://github.com/apache/superset/issues/20835)) ([226712d](https://github.com/apache/superset/commit/226712d831a80cc44213c5ce8ed921518ea0397c))
- add @superset-ui/superset-ui package as one-stop install ([#255](https://github.com/apache/superset/issues/255)) ([4274520](https://github.com/apache/superset/commit/42745207811a84e5ee79db208f03c2b1b1e7c1ad))
- Add 3 new extension points for inserting custom icons ([#22027](https://github.com/apache/superset/issues/22027)) ([c870fbe](https://github.com/apache/superset/commit/c870fbe9e290e9305e6019bb4e9932bbd736b6dc))
- add a `where_in` filter for Jinja2 ([#19574](https://github.com/apache/superset/issues/19574)) ([83c3779](https://github.com/apache/superset/commit/83c3779a6c3f7cc371dd8b8bf70519ec473954db))
- add a config to enable retina quality images in screenshots ([#17409](https://github.com/apache/superset/issues/17409)) ([3ee9e11](https://github.com/apache/superset/commit/3ee9e11ce1bfc2f74ef8bfcd2ee0cc6a3f2249ef))
- Add a new database driver for Amazon DynamoDB ([#22077](https://github.com/apache/superset/issues/22077)) ([b32de3d](https://github.com/apache/superset/commit/b32de3dd9eba41dd850fafb35f24d276bd48c32f))
- add Advanced Analytics into mixed time series chart ([#19851](https://github.com/apache/superset/issues/19851)) ([f5e9f0e](https://github.com/apache/superset/commit/f5e9f0eb3b2045a9d441f59cb3a6109892e6aea9))
- add basic functionality for icicle chart to display static data ([#165](https://github.com/apache/superset/issues/165)) ([53a9943](https://github.com/apache/superset/commit/53a994321587e0e11a7904661af43eb0d27854bc))
- add BE pagination to table with pages ([#985](https://github.com/apache/superset/issues/985)) ([103f8e4](https://github.com/apache/superset/commit/103f8e41d9d969217821ef738e8f421b54aa011e))
- add box plot ([#78](https://github.com/apache/superset/issues/78)) ([6c7533b](https://github.com/apache/superset/commit/6c7533b565ad13fe3004e7448072f5a2013d003c))
- add calendar package and storybook ([#356](https://github.com/apache/superset/issues/356)) ([a8f3923](https://github.com/apache/superset/commit/a8f39238516cd48247812f8b91791e164b8876d3))
- add certification icon to metrics ([#748](https://github.com/apache/superset/issues/748)) ([3fa7675](https://github.com/apache/superset/commit/3fa767582c3d1a4b61813bd9c8808fb0f7a54efa))
- Add Certified filter to Datasets ([#20136](https://github.com/apache/superset/issues/20136)) ([f8ea778](https://github.com/apache/superset/commit/f8ea7788a90d679ab2e086289ebf6857ca1d2915))
- add certified icon to columoption ([#1330](https://github.com/apache/superset/issues/1330)) ([b9504ed](https://github.com/apache/superset/commit/b9504ed71375b6820b38da17d7a9791e23531224))
- Add channel encoder ([#224](https://github.com/apache/superset/issues/224)) ([937a7ec](https://github.com/apache/superset/commit/937a7ecb100865329a2de00ba112f5ba105b4cf5))
- add chart companion components ([#139](https://github.com/apache/superset/issues/139)) ([e5e09f9](https://github.com/apache/superset/commit/e5e09f9f267416d75f0b85887590c1ab09508eaa))
- add chart description in info tooltip ([#17207](https://github.com/apache/superset/issues/17207)) ([22896f2](https://github.com/apache/superset/commit/22896f28037c377e40d833e5c7ab2de8418d6c17))
- Add Chromatic publishing to superset-frontend storybook ([#21095](https://github.com/apache/superset/issues/21095)) ([6a0b7e5](https://github.com/apache/superset/commit/6a0b7e5598f18262cb83579bacd2440faaf5717b))
- add classNames for apply and clearAll buttons for superset filters ([#17554](https://github.com/apache/superset/issues/17554)) ([4cf429c](https://github.com/apache/superset/commit/4cf429c1545fd3d8e465d8591b9c9052920c9459))
- add color pallettes defined in SIP-34 ([#597](https://github.com/apache/superset/issues/597)) ([2d31777](https://github.com/apache/superset/commit/2d317774d6c3a1803ab6049b2140829a48ea86f5))
- add control grouping functionality ([#485](https://github.com/apache/superset/issues/485)) ([54b0df5](https://github.com/apache/superset/commit/54b0df5421923c2260163b878009fa30045977ce))
- add control panel support to chart plugin ([#203](https://github.com/apache/superset/issues/203)) ([a7a12c7](https://github.com/apache/superset/commit/a7a12c79a2732a643e353cc56b8cf0ad9b16983f))
- add country map of bulgaria in superset-ui-legacy-plugin-chart-country-map ([#2](https://github.com/apache/superset/issues/2)) ([3e05f6f](https://github.com/apache/superset/commit/3e05f6f143f43a49068b655d34a6272e53e0c35c))
- add databricks form ([#21573](https://github.com/apache/superset/issues/21573)) ([5c77f1a](https://github.com/apache/superset/commit/5c77f1ad2a317254e476c718b74de639c9fc943a))
- Add dataset tagging to the back-end ([#20892](https://github.com/apache/superset/issues/20892)) ([2e56489](https://github.com/apache/superset/commit/2e564897f860192c3e3ecbe41cfbac6b3e557b35))
- Add dataset visuals for when a table is selected ([#21893](https://github.com/apache/superset/issues/21893)) ([175ec85](https://github.com/apache/superset/commit/175ec854b9a509726dbe2ae8647a9da889fe0041))
- add deckgl files ([ad74e60](https://github.com/apache/superset/commit/ad74e60e99485a3b3105fe9f1a01b98bf5508dad))
- add default series_limit ([#1033](https://github.com/apache/superset/issues/1033)) ([75ef664](https://github.com/apache/superset/commit/75ef664c5d1f66b06241a140b708d022bf3e6323))
- add denylist for db engines ([#21486](https://github.com/apache/superset/issues/21486)) ([f58227a](https://github.com/apache/superset/commit/f58227a9124866d1db0dcb20947e9bee287ba0fc))
- add dimension type ([#117](https://github.com/apache/superset/issues/117)) ([ac241aa](https://github.com/apache/superset/commit/ac241aa59962e16231e1934c217c6149906ba8a7))
- add drag and drop column rearrangement for table viz ([#19381](https://github.com/apache/superset/issues/19381)) ([7e9b85f](https://github.com/apache/superset/commit/7e9b85f76ca8cae38c38e11f857634216b1cd71c))
- add dropGroupByControl ([#967](https://github.com/apache/superset/issues/967)) ([89c7d1d](https://github.com/apache/superset/commit/89c7d1d1aed19284345024756c9319f31c5014db))
- add duckdb as DataSource - Fixes [#14563](https://github.com/apache/superset/issues/14563) ([#19317](https://github.com/apache/superset/issues/19317)) ([202e34a](https://github.com/apache/superset/commit/202e34a259eda2619fc08b653df866c0f13c3e58))
- add duration formatter ([#209](https://github.com/apache/superset/issues/209)) ([dc9d0a0](https://github.com/apache/superset/commit/dc9d0a0d40d971e8e4a3a87ff701874542e8f5c4))
- Add ECharts Timeseries plugin ([#737](https://github.com/apache/superset/issues/737)) ([e916fd9](https://github.com/apache/superset/commit/e916fd9015fc976b0548954c4b8076c9681bfecc))
- add empty states to sqlab editor and select ([#19598](https://github.com/apache/superset/issues/19598)) ([06ec88e](https://github.com/apache/superset/commit/06ec88eb9934e90c93c9ee90a7871ceaf5abde06))
- add encodeable utilities for chart ([#15](https://github.com/apache/superset/issues/15)) ([2766975](https://github.com/apache/superset/commit/2766975ac54687eaa6c83fcc774e04e2e35e6fb7))
- Add Encoder ([#230](https://github.com/apache/superset/issues/230)) ([e11071c](https://github.com/apache/superset/commit/e11071cd9c4431428e6c6dd25c0a0d21d65d2266))
- add error boundary and responsiveness to SuperChart ([#175](https://github.com/apache/superset/issues/175)) ([34d475f](https://github.com/apache/superset/commit/34d475fac735474ce82bf1d04ef1d747f4fd30b1))
- Add excel export ([#22006](https://github.com/apache/superset/issues/22006)) ([6cf434e](https://github.com/apache/superset/commit/6cf434e5c16e8b4e387a79bbf7fca31bab9d96b8))
- add export_related flag ([#19215](https://github.com/apache/superset/issues/19215)) ([d01fdad](https://github.com/apache/superset/commit/d01fdad1d8da740af95e32adf2c9fc4bd1da7db5))
- add extension point for workspace home page ([#21033](https://github.com/apache/superset/issues/21033)) ([83dd851](https://github.com/apache/superset/commit/83dd85166f917a5cff8c94d2b4d2c298182494b9))
- add extension point to the right side of the menu bar ([#20514](https://github.com/apache/superset/issues/20514)) ([f2af81b](https://github.com/apache/superset/commit/f2af81b1c74a56e6854039cfe5f32e9b035ce262))
- add extension point to the top of welcome page ([#20575](https://github.com/apache/superset/issues/20575)) ([2389871](https://github.com/apache/superset/commit/2389871556cde32c61bc694f09b4e7dbc5432af5))
- add force option to report screenshots ([#17853](https://github.com/apache/superset/issues/17853)) ([2cd8054](https://github.com/apache/superset/commit/2cd80543581155225f2b538ad8cd5ebc7de5a9ff))
- add function for getting legend information ([#236](https://github.com/apache/superset/issues/236)) ([2923a93](https://github.com/apache/superset/commit/2923a9318de7e861d565847b27eeb29d8189d16a))
- add functions for parsing formatters from encoding ([#205](https://github.com/apache/superset/issues/205)) ([be65a04](https://github.com/apache/superset/commit/be65a04238f4b138ceff23025a45b9e31305fe53))
- add functions for parsing scales ([#207](https://github.com/apache/superset/issues/207)) ([024b318](https://github.com/apache/superset/commit/024b318dd249dba0087f4868b7794a0b91fe2b66))
- add getDomain to ChannelEncoder ([01264fd](https://github.com/apache/superset/commit/01264fdec124aecb31c04866fdb6141d9f515039))
- add header_data into emails ([#20903](https://github.com/apache/superset/issues/20903)) ([dda1dcf](https://github.com/apache/superset/commit/dda1dcf8ee217438acb45f2ad016ff1869c16112))
- Add Helm chart option for configOverrides through file ([#17811](https://github.com/apache/superset/issues/17811)) ([e3b44f4](https://github.com/apache/superset/commit/e3b44f482543b161cd2aabdc6b9dd7f3bde43da3))
- add hooks ([#158](https://github.com/apache/superset/issues/158)) ([eaa7851](https://github.com/apache/superset/commit/eaa785142861ff5ba44489f24912336b0cbd0171))
- add hooks on set_perm for new data permissions ([#20600](https://github.com/apache/superset/issues/20600)) ([f38dd1d](https://github.com/apache/superset/commit/f38dd1d42d2bb1da563367e4d054fe7eaa99eb04))
- add india to country_map visualization ([#182](https://github.com/apache/superset/issues/182)) ([b56b2bb](https://github.com/apache/superset/commit/b56b2bb1e2c64bf2b9a414cca5826c2a1784a54d))
- Add Iran to countries ([#306](https://github.com/apache/superset/issues/306)) ([b0a620e](https://github.com/apache/superset/commit/b0a620eee842f806006dda47fd32ba03114dee8a))
- add Korea(South) to Country Maps ([#230](https://github.com/apache/superset/issues/230)) ([bd84e26](https://github.com/apache/superset/commit/bd84e26a92bc0f3868c8835d588f978173d2078b))
- Add label and tooltip for the color schemes control ([#21040](https://github.com/apache/superset/issues/21040)) ([756ed0e](https://github.com/apache/superset/commit/756ed0e36acead74944112a8b678a7151319c26f))
- add labels to color scheme ([#125](https://github.com/apache/superset/issues/125)) ([c9b9935](https://github.com/apache/superset/commit/c9b99355518c36d49f5fb8839e0913ae06305e01))
- add Liechtenstein to country map chart ([#263](https://github.com/apache/superset/issues/263)) ([8392ad8](https://github.com/apache/superset/commit/8392ad83ef22a5850957f6981fd9a51bdafd0973))
- Add logging for ssh tunneling test_connection attempts ([#22625](https://github.com/apache/superset/issues/22625)) ([2de19f1](https://github.com/apache/superset/commit/2de19f1d6609aaa5496970ac6fd516c6d8c5915c))
- add main datetime column to dataset editor ([#17739](https://github.com/apache/superset/issues/17739)) ([63d9693](https://github.com/apache/superset/commit/63d9693f21786431ba7e2ec11d6658bcd3a1f9e9))
- add mergeMargin() function ([#114](https://github.com/apache/superset/issues/114)) ([e5d7e50](https://github.com/apache/superset/commit/e5d7e50ee2d6ec799ac10ae650e0917a9562f283))
- add modfied col and timezone info to schedule col ([#20165](https://github.com/apache/superset/issues/20165)) ([6f0d53e](https://github.com/apache/superset/commit/6f0d53eed8eaf085a6d0a76f68e50c7733754a3d))
- add monorepo config ([41f551e](https://github.com/apache/superset/commit/41f551edfc75009cdda276392f461edb20774c79))
- add more support for undefined format to number and time formatters ([#308](https://github.com/apache/superset/issues/308)) ([5966ff1](https://github.com/apache/superset/commit/5966ff10be7a3e53f0512d672109a3f2ec3c3937))
- add name, description and non null tables to RLS ([#20432](https://github.com/apache/superset/issues/20432)) ([60eb109](https://github.com/apache/superset/commit/60eb1094a4f270ba8931f3c2e1656bd257a948fb))
- add NoResultsComponent to charts ([#305](https://github.com/apache/superset/issues/305)) ([06d7ad5](https://github.com/apache/superset/commit/06d7ad571ad4c4fc6002000f8b4d2b4fdd9f22be))
- Add oneLine mode to AsyncSelect ([#22379](https://github.com/apache/superset/issues/22379)) ([a5a0cf9](https://github.com/apache/superset/commit/a5a0cf9ffb3036568a1144245665daaf00dc80b1))
- add orderby shared control ([#1122](https://github.com/apache/superset/issues/1122)) ([6675e60](https://github.com/apache/superset/commit/6675e60280f3cb8deb86d439865eb2d119e07fad))
- add parseLength function to @superset-ui/dimension ([#171](https://github.com/apache/superset/issues/171)) ([5a79a70](https://github.com/apache/superset/commit/5a79a7000f3f48237d0d96c60ab5042d50f9bc0c))
- add permalink to dashboard and explore ([#19078](https://github.com/apache/superset/issues/19078)) ([b7a0559](https://github.com/apache/superset/commit/b7a0559aaf5ff4266baf5069b93379fbecfb4a00))
- add plugin for Kepler ([#2](https://github.com/apache/superset/issues/2)) ([cac4e07](https://github.com/apache/superset/commit/cac4e07bfeb591719cf6a7122ee2934d27ecca17))
- add possibility to set ingress class name in Helm chart ([#17252](https://github.com/apache/superset/issues/17252)) ([37909aa](https://github.com/apache/superset/commit/37909aace0b8968475c2c731891cd9dc52f8de85))
- Add prettier to pre-commit workflow ([#17134](https://github.com/apache/superset/issues/17134)) ([cd9e994](https://github.com/apache/superset/commit/cd9e99402d29bfed6a897a7371144b096ee5249c))
- add promiseTimeout ([#223](https://github.com/apache/superset/issues/223)) ([c0c45c2](https://github.com/apache/superset/commit/c0c45c2d3c4a3cda3e453d1d1c40a7451887797d))
- add prop to `setDBEngine` in DatabaseModal ([#18653](https://github.com/apache/superset/issues/18653)) ([78e20e2](https://github.com/apache/superset/commit/78e20e21abe3f264701e796d36b900246b39c22b))
- add properties for font sizing ([#10](https://github.com/apache/superset/issues/10)) ([49cd2fe](https://github.com/apache/superset/commit/49cd2fedfb7262920a905067133318ca93f3eb8a))
- add pyproject.toml file to project ([#20291](https://github.com/apache/superset/issues/20291)) ([8466eec](https://github.com/apache/superset/commit/8466eec2283a30a5cf891b4f808d4c519aea84fa))
- add renameOperator ([#19776](https://github.com/apache/superset/issues/19776)) ([3c28cd4](https://github.com/apache/superset/commit/3c28cd4625fdeeaeeac3ed730907af1fb86bc86e))
- add resample operator to advanced analytic ([#1349](https://github.com/apache/superset/issues/1349)) ([c7744d4](https://github.com/apache/superset/commit/c7744d472014cfa37277fecd5d27ecd8c1133b5b))
- Add resize drag handle to Dataset SQL fields ([#20670](https://github.com/apache/superset/issues/20670)) ([dd353ca](https://github.com/apache/superset/commit/dd353ca86a93aed4189cdefddffcd425b6cbdcb5))
- add retry to callApi ([#384](https://github.com/apache/superset/issues/384)) ([b711d3e](https://github.com/apache/superset/commit/b711d3eba7e8a946fb82904c5a9f958471c0b284))
- add risingwave.py in db engine specs ([#22123](https://github.com/apache/superset/issues/22123)) ([e80e10e](https://github.com/apache/superset/commit/e80e10ec06472deb1156b229eb61522bb5fe6706))
- add rison request type to makeApi ([#843](https://github.com/apache/superset/issues/843)) ([c527f55](https://github.com/apache/superset/commit/c527f55e99784adf4ea3ed12758f7d37e82f840d))
- add samples endpoint ([#20170](https://github.com/apache/superset/issues/20170)) ([40abb44](https://github.com/apache/superset/commit/40abb44ba1376b37414bbedbd05ddca44c4f7450))
- add sankey chart with loops ([#77](https://github.com/apache/superset/issues/77)) ([c0920f6](https://github.com/apache/superset/commit/c0920f63971e80a9f2b1cfba976d615bb9588b70))
- Add Saudi Arabia country map ([#1416](https://github.com/apache/superset/issues/1416)) ([28dff9b](https://github.com/apache/superset/commit/28dff9b3950dd8ec14f32171ca88fdfc62a225cc))
- add scatter plot ([#90](https://github.com/apache/superset/issues/90)) ([3a0dd27](https://github.com/apache/superset/commit/3a0dd2741d868b3016ff1345698697eb9105c4b2))
- Add single select and inverse selection to numeric range ([#16722](https://github.com/apache/superset/issues/16722)) ([#17372](https://github.com/apache/superset/issues/17372)) ([54b56fe](https://github.com/apache/superset/commit/54b56fe12f18c034b301289cecb935342c0e3f5a))
- Add SMART_NUMBER formatter and make it default ([#109](https://github.com/apache/superset/issues/109)) ([0cde8a2](https://github.com/apache/superset/commit/0cde8a288495e21937196398b93463bfe234b349))
- add snowflake keypair authentication ([#21322](https://github.com/apache/superset/issues/21322)) ([9fdd75b](https://github.com/apache/superset/commit/9fdd75b9234490a971bb11a295209dadad8e3d1e))
- add sort by metric for charts with multiple metrics ([#952](https://github.com/apache/superset/issues/952)) ([b3f84f5](https://github.com/apache/superset/commit/b3f84f56578c414361d265d4cce10a2ec6b07a0b))
- add Spark Sql DB engine spec and support Spark 3.x ([#20462](https://github.com/apache/superset/issues/20462)) ([c4d2238](https://github.com/apache/superset/commit/c4d2238a1629851b0c044dba3f20c3af4c0a9031))
- add ssh tunneling to dynamic form for Database Connection UI ([#22689](https://github.com/apache/superset/issues/22689)) ([b9686fe](https://github.com/apache/superset/commit/b9686fe6fa808e11ee5c54c67929ccaf84e9435a))
- add statsd metrics for notifications ([#20158](https://github.com/apache/superset/issues/20158)) ([77ccec5](https://github.com/apache/superset/commit/77ccec50cc0b97057b074126e57697c6fd00c2c0))
- add storybook for missing chart and fix broken treemap ([#1427](https://github.com/apache/superset/issues/1427)) ([46b4eca](https://github.com/apache/superset/commit/46b4eca280d8ceeda10252ee4aade5badb647fa1))
- add success message for database modal ([#18183](https://github.com/apache/superset/issues/18183)) ([ac564ea](https://github.com/apache/superset/commit/ac564ea6b7bd42a8a34fab338df417d2608e76cb))
- add success toast to alerts and reports ([#19482](https://github.com/apache/superset/issues/19482)) ([44e3103](https://github.com/apache/superset/commit/44e3103fc9029edd4c7fd1c8402607eecebeb1b3))
- Add support for Azure Data Explorer (Kusto) db engine spec ([#17898](https://github.com/apache/superset/issues/17898)) ([d2d4f8e](https://github.com/apache/superset/commit/d2d4f8eb447c40a76e619d4cd6dec5ba21a9ea27))
- add support for comments in adhoc clauses ([#19248](https://github.com/apache/superset/issues/19248)) ([f341025](https://github.com/apache/superset/commit/f341025d80aacf7345e7c20f8463231b9197ea58))
- add support for conditional get requests ([#119](https://github.com/apache/superset/issues/119)) ([a63f947](https://github.com/apache/superset/commit/a63f947ff52cb96e52dc526c4b9b910af0cf82bc))
- add syria to Country Maps ([#1000](https://github.com/apache/superset/issues/1000)) ([5da7a6c](https://github.com/apache/superset/commit/5da7a6c778c5b2cea75a822cfe13597a18543a86))
- add tabs to edit dataset page ([#22043](https://github.com/apache/superset/issues/22043)) ([c05871e](https://github.com/apache/superset/commit/c05871eb378344e340ed7841e6db13eaa5efcf95))
- Add toast for successful table or schema refreshes in Sqllab ([#18169](https://github.com/apache/superset/issues/18169)) ([e6bb0fc](https://github.com/apache/superset/commit/e6bb0fc7ad61dc314156b283dcfbbd991ddaff9a))
- add tooltip and layout components for charts ([#13](https://github.com/apache/superset/issues/13)) ([4013721](https://github.com/apache/superset/commit/4013721e6103ef97aabca5f29629f96c898db846))
- add tooltip for full metric names ([#1066](https://github.com/apache/superset/issues/1066)) ([cc25094](https://github.com/apache/superset/commit/cc25094b85d713ee7c28717c721318bcb492e2d9))
- Add Türkiye Map to Country Map ([#20801](https://github.com/apache/superset/issues/20801)) ([4ffa3c2](https://github.com/apache/superset/commit/4ffa3c22d17b189a384f43a0e352b137900b10bc))
- Add types and type guards for encodeable ([#201](https://github.com/apache/superset/issues/201)) ([cb9e617](https://github.com/apache/superset/commit/cb9e617d90c225dfde7b4ed744ee32a08662309c))
- add types to published list ([297b723](https://github.com/apache/superset/commit/297b723e7ffc8a6d05b8ef931810117bb528d96b))
- add typescript declaration for external packages ([#12](https://github.com/apache/superset/issues/12)) ([4215a80](https://github.com/apache/superset/commit/4215a80aa8a35432e49d78bfe0e7c8d38bb354be))
- add validator package ([#322](https://github.com/apache/superset/issues/322)) ([dbc9860](https://github.com/apache/superset/commit/dbc98609a5f9b4a31fc92b8e64ca97c65ea78da7))
- add validator to umbrella package ([#327](https://github.com/apache/superset/issues/327)) ([6ffcfec](https://github.com/apache/superset/commit/6ffcfec6e7d65702f11e101ed1b1db121197694e))
- add Wrapper support and bounding box for dynamic width/height ([#215](https://github.com/apache/superset/issues/215)) ([095c183](https://github.com/apache/superset/commit/095c1839b2aa760cb4ff21d7112b228f867091ca))
- added Highly-used tag ([#1229](https://github.com/apache/superset/issues/1229)) ([5614683](https://github.com/apache/superset/commit/56146830f43cf3d380065490b0d1f992980a3e78))
- added italian regions country map ([#1319](https://github.com/apache/superset/issues/1319)) ([a783131](https://github.com/apache/superset/commit/a783131d7dfa8c992a4b0049a0c763d84648daaa))
- Added latin america countries to country map ([#21352](https://github.com/apache/superset/issues/21352)) ([f83af88](https://github.com/apache/superset/commit/f83af88fc7922774b4c1a7792f0602edcb80763d))
- added option to set pod annotations on init-db pod to Helm chart. ([#17581](https://github.com/apache/superset/issues/17581)) ([95177d7](https://github.com/apache/superset/commit/95177d72b631d1666f10ad3577b8e972f5aa1a8d))
- **added search bar:** added search bar ([3d8cbd5](https://github.com/apache/superset/commit/3d8cbd52eeda85cfb3a0da0a87f7efb0cc86a72f))
- Added success toasts for database, dataset, chart, dashboard, and query imports ([#18190](https://github.com/apache/superset/issues/18190)) ([c40b337](https://github.com/apache/superset/commit/c40b337978717b149984ed00c5359cf2c2394254))
- adding Canada into the list of country map choices ([#48](https://github.com/apache/superset/issues/48)) ([bbecb6d](https://github.com/apache/superset/commit/bbecb6dc8432f4b4f61e0033111db79b2dd1298f))
- adding to feature flag enum ([#1142](https://github.com/apache/superset/issues/1142)) ([47a5f34](https://github.com/apache/superset/commit/47a5f349626e469fe97d305951161f76bffda5ad))
- adding truncate metric control on timeseries charts ([#20373](https://github.com/apache/superset/issues/20373)) ([7c252d7](https://github.com/apache/superset/commit/7c252d75240559d0bba9be3be8419b65b86967df))
- adding XAxis to BigNumberTrend ([#21577](https://github.com/apache/superset/issues/21577)) ([f4646f8](https://github.com/apache/superset/commit/f4646f8edba396dba24e6ff4fbc054d073d77fd7))
- Adds a Content Security Policy (CSP) check for production environments ([#21874](https://github.com/apache/superset/issues/21874)) ([f4da74c](https://github.com/apache/superset/commit/f4da74ce8d6902be1ac3b881fb4a7bc521ec366f))
- Adds a helper text option to the Select component ([#21269](https://github.com/apache/superset/issues/21269)) ([fbe9807](https://github.com/apache/superset/commit/fbe980779e38f5fa8a9bd148e280f85ec8b0ec16))
- Adds a key-value endpoint to store charts form data ([#17882](https://github.com/apache/superset/issues/17882)) ([959b15e](https://github.com/apache/superset/commit/959b15eeca0a1e2e93c1a8688f8629d0f6ee5776))
- Adds a key-value endpoint to store the state of dashboard filters ([#17536](https://github.com/apache/superset/issues/17536)) ([2f2e8fe](https://github.com/apache/superset/commit/2f2e8fe412296b76cb17094a4c22fe5c3f8bc504))
- Adds a separator to Select All option ([#22776](https://github.com/apache/superset/issues/22776)) ([1fe4a71](https://github.com/apache/superset/commit/1fe4a71f5be10f182277b6008d212c7f40ced2e4))
- Adds drill to detail context menu for ECharts visualizations ([#20891](https://github.com/apache/superset/issues/20891)) ([3df8335](https://github.com/apache/superset/commit/3df8335f8792c85d7e2f7fefa5dd60fb2c0befaf))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds drill to detail context menu to Table ([#21168](https://github.com/apache/superset/issues/21168)) ([68fa4d2](https://github.com/apache/superset/commit/68fa4d2665cc0742b2194533271ce562a3ebbf14))
- Adds drill to detail context menu to World Map ([#21150](https://github.com/apache/superset/issues/21150)) ([4ca4a5c](https://github.com/apache/superset/commit/4ca4a5c7cb185ac7d318ef5349fbb23cd7ce1fd1))
- Adds MetadataBar to Drill to Detail modal ([#21343](https://github.com/apache/superset/issues/21343)) ([8ebf4ed](https://github.com/apache/superset/commit/8ebf4ed3ffc8cf5b7056c4d296667204b9cb5ac6))
- Adds more customization properties to DropdownContainer ([#22031](https://github.com/apache/superset/issues/22031)) ([b040211](https://github.com/apache/superset/commit/b040211970e456337455e44ba17bf78f11650097))
- Adds overflow to the DropdownContainer popover ([#22250](https://github.com/apache/superset/issues/22250)) ([afc10a2](https://github.com/apache/superset/commit/afc10a247b1ab736ffb888047ec3c3a3b995ecc0))
- Adds plugin-chart-handlebars ([#17903](https://github.com/apache/superset/issues/17903)) ([e632b82](https://github.com/apache/superset/commit/e632b82395bd379e2c4d42cb581972e6fe690a50))
- Adds support for clearing the Select cache ([#20397](https://github.com/apache/superset/issues/20397)) ([ca526e6](https://github.com/apache/superset/commit/ca526e63c8211fe308049f5d003a9826f5ebb50e))
- Adds support to multiple dependencies to the native filters ([#18793](https://github.com/apache/superset/issues/18793)) ([06e1e42](https://github.com/apache/superset/commit/06e1e4285ea52d27f9b7b7dfea59f9652ee0dcfe))
- Adds the /explore endpoint to the v1 API ([#20399](https://github.com/apache/superset/issues/20399)) ([2016336](https://github.com/apache/superset/commit/20163361b9d947c1bf5b7f8331bdc64c9aac1169))
- Adds the CROSS_REFERENCE feature flag ([#21708](https://github.com/apache/superset/issues/21708)) ([1cbf066](https://github.com/apache/superset/commit/1cbf0664152cef5d47720e1acffb955c328e291e))
- Adds the DropdownContainer component ([#21974](https://github.com/apache/superset/issues/21974)) ([97e3e79](https://github.com/apache/superset/commit/97e3e790a3627ff7e291865807bbe3634cc3a291))
- Adds the ECharts Sunburst chart ([#22833](https://github.com/apache/superset/issues/22833)) ([30abefb](https://github.com/apache/superset/commit/30abefb519978e2760a492de51dc0d19803edf3a))
- Adds the HORIZONTAL_FILTER_BAR feature flag ([#21935](https://github.com/apache/superset/issues/21935)) ([779d9f7](https://github.com/apache/superset/commit/779d9f75336ce38ab346e27dcb6a77e5a68cf823))
- Adds the MetadataBar component ([#21090](https://github.com/apache/superset/issues/21090)) ([1517956](https://github.com/apache/superset/commit/151795663bbdc8f52ab046a2dc4aa148b2efba51))
- Adds the MetadataBar to the Explore header ([#21560](https://github.com/apache/superset/issues/21560)) ([0dda5fe](https://github.com/apache/superset/commit/0dda5fe1cf04aec5b27b63f8bbb3173a13e02ebc))
- adds the option to show values for mixed time-series ([#1435](https://github.com/apache/superset/issues/1435)) ([8666f63](https://github.com/apache/superset/commit/8666f63c4a97ee01f1f96c2e3d26e0badb913c1c))
- adds TLS certificate validation option for SMTP ([#21272](https://github.com/apache/superset/issues/21272)) ([9fd7520](https://github.com/apache/superset/commit/9fd752057eb261b0e5db87636836fd30579ffce6))
- Adds virtualization option to antd based Table component ([#22135](https://github.com/apache/superset/issues/22135)) ([eba7b3d](https://github.com/apache/superset/commit/eba7b3d074350c3429778259baef19b7995f60ae))
- **advanced analysis:** support MultiIndex column in post processing stage ([#19116](https://github.com/apache/superset/issues/19116)) ([375c03e](https://github.com/apache/superset/commit/375c03e08407570bcf417acf5f3d25b28843329c))
- advanced analytics for timeseries in echart viz ([#1170](https://github.com/apache/superset/issues/1170)) ([f9d3a73](https://github.com/apache/superset/commit/f9d3a73e93e7f85ad246fd99520bc46ec31a3072))
- **advanced analytics:** support groupby in resample ([#18045](https://github.com/apache/superset/issues/18045)) ([0c7f728](https://github.com/apache/superset/commit/0c7f7288d8cded5dc73d49d1e0be397e748d4f10))
- **alerts:** Column for select tabs to send ([#17604](https://github.com/apache/superset/issues/17604)) ([1377465](https://github.com/apache/superset/commit/1377465a7d9f374500576b35683763c2cc29afe8))
- **alerts:** Select tabs to send backend ([#17749](https://github.com/apache/superset/issues/17749)) ([bdc35a2](https://github.com/apache/superset/commit/bdc35a221445d9ba62a4cfabc2f5561dc712084c))
- align metrics title to the right ([#721](https://github.com/apache/superset/issues/721)) ([835335d](https://github.com/apache/superset/commit/835335d3e4b48987adbbac3bfaa55ac05ba3d307))
- allow adding pod labels ([#18848](https://github.com/apache/superset/issues/18848)) ([dafc841](https://github.com/apache/superset/commit/dafc841e223c0f01092a2e116888a3304142e1b8))
- allow assets to be managed externally ([#18093](https://github.com/apache/superset/issues/18093)) ([1c0b141](https://github.com/apache/superset/commit/1c0b141e2de700f889fc04d5f77d91bc7305a858))
- allow boolean as axis config ([4259e44](https://github.com/apache/superset/commit/4259e4402bc64f33d688b490a205bd409d100933))
- allow chart plugin to be unregistered ([#168](https://github.com/apache/superset/issues/168)) ([09f9405](https://github.com/apache/superset/commit/09f94053349d77bae4ae24403f00e1cfa10e782a))
- allow legend overrides at multiple levels ([#81](https://github.com/apache/superset/issues/81)) ([ff7ef2b](https://github.com/apache/superset/commit/ff7ef2b2b3ffc5f77d7b242301591d914fbee21a))
- allow more HTML tags in report description ([#20908](https://github.com/apache/superset/issues/20908)) ([e739ff5](https://github.com/apache/superset/commit/e739ff507671cfd1892aad2e22fae83425c31851))
- allow overriding ChartLegend, its style and LegendGroup style ([#112](https://github.com/apache/superset/issues/112)) ([d7a5d8a](https://github.com/apache/superset/commit/d7a5d8ab85f0e5c75f6f4153839ad3372e1f8b9e))
- allow reactify callbacks to access props ([#200](https://github.com/apache/superset/issues/200)) ([f0204ea](https://github.com/apache/superset/commit/f0204ea9bdd4a8c565518eb243a3fddf5432cd4c))
- allow setting db UUID ([#20412](https://github.com/apache/superset/issues/20412)) ([998624b](https://github.com/apache/superset/commit/998624b1a5a498343bd7f37b5ca80402ba08e305))
- allow toggling of table viz's bar chart backgrounds ([#352](https://github.com/apache/superset/issues/352)) ([98848b3](https://github.com/apache/superset/commit/98848b361abc447c77928442a3aca7a4750aafd1))
- allow uploads in crud view ([#18953](https://github.com/apache/superset/issues/18953)) ([d771ddb](https://github.com/apache/superset/commit/d771ddbb94c8a5692ca4f167422b7c100b1b0093))
- Allow users to bust cache in report dashboard + alerts charts + alert dashboards ([#18795](https://github.com/apache/superset/issues/18795)) ([8c52fe3](https://github.com/apache/superset/commit/8c52fe347699b4d529997ea7600c72874d49f905))
- **annotation:** add toast feedback to annotation templates ([#18116](https://github.com/apache/superset/issues/18116)) ([9fa2812](https://github.com/apache/superset/commit/9fa2812343a573fd557ca704ec32a8ecd4a1e294))
- API for asset sync ([#19220](https://github.com/apache/superset/issues/19220)) ([b05e7db](https://github.com/apache/superset/commit/b05e7dbf2aa513cd50a20847a858625916579dcb))
- **api:** Add option to enable sync on import ([#20312](https://github.com/apache/superset/issues/20312)) ([a5ff094](https://github.com/apache/superset/commit/a5ff0949a65c9aedabb2c97a2843ff425534ecaf))
- **api:** Added "kind" to dataset/<pk> endpoint ([#20113](https://github.com/apache/superset/issues/20113)) ([11b33de](https://github.com/apache/superset/commit/11b33de61b5b28966164daddb30f5661bd109467))
- Applitools Cypress workflow ([#19956](https://github.com/apache/superset/issues/19956)) ([d0b8b1e](https://github.com/apache/superset/commit/d0b8b1e97d1280bff0506b2c8cc2325041f79df2))
- apply d3NumberFormat to table reports ([#17336](https://github.com/apache/superset/issues/17336)) ([03a2c6e](https://github.com/apache/superset/commit/03a2c6ee8aab94a85e10768e09ffa110bb008cfd))
- apply standardized form data to deckgl ([#20579](https://github.com/apache/superset/issues/20579)) ([290b89c](https://github.com/apache/superset/commit/290b89c7b4ae702c55f611bfac9cedb245ea8bd8))
- apply standardized form data to tier 2 charts ([#20530](https://github.com/apache/superset/issues/20530)) ([de524bc](https://github.com/apache/superset/commit/de524bc59f011fd361dcdb7d35c2cb51f7eba442))
- apply Time Grain to X-Axis column ([#21163](https://github.com/apache/superset/issues/21163)) ([ce3d38d](https://github.com/apache/superset/commit/ce3d38d2e72a56014fa96ee3d4afe066277cc5be))
- Area viz migration ([#20359](https://github.com/apache/superset/issues/20359)) ([4e6e87f](https://github.com/apache/superset/commit/4e6e87f62ee749e8326fa734225dde955c4d0025))
- auto select schema ([#22160](https://github.com/apache/superset/issues/22160)) ([17c2bd8](https://github.com/apache/superset/commit/17c2bd89a6ecc480851801d58fadbf130704f784))
- Automatically closes the DropdownContainer when scrolling outside of the component ([#22287](https://github.com/apache/superset/issues/22287)) ([8cf5728](https://github.com/apache/superset/commit/8cf572858ce2f0ec2a7765b31efbcf08d189e67b))
- Axis sort in the Bar Chart V2 ([#21993](https://github.com/apache/superset/issues/21993)) ([22fab5e](https://github.com/apache/superset/commit/22fab5e58ce574e962518067d982e3036449e580))
- **big-number:** allow fallback to last available value and fix time range for trend lines ([#403](https://github.com/apache/superset/issues/403)) ([80b6e06](https://github.com/apache/superset/commit/80b6e066ebdf66a08b0ba76f7c70663d8d2b6bbd))
- **big-number:** format datetime according to granularity ([#402](https://github.com/apache/superset/issues/402)) ([cb3206b](https://github.com/apache/superset/commit/cb3206b5833a0d68c1284b677e5a4f522957be28))
- **bigquery:** Custom message when Service Account doesnt have the correct Roles and Permissions ([#21838](https://github.com/apache/superset/issues/21838)) ([203b289](https://github.com/apache/superset/commit/203b289021be1dc720126ac57e33ad933fd39b36))
- blankstate metrics columns ([#20755](https://github.com/apache/superset/issues/20755)) ([2f3e11d](https://github.com/apache/superset/commit/2f3e11db668327ce55466a23fe6866458d2e08cc))
- bring lazy import back ([#84](https://github.com/apache/superset/issues/84)) ([68ebb11](https://github.com/apache/superset/commit/68ebb111f1fc880607b5b65695a20fbdd7af26b8))
- bump data-ui/xy-chart version ([70ecef2](https://github.com/apache/superset/commit/70ecef2a6d70c69e0c33b4747d0bed70bef1c580))
- bump dependencies ([492b19c](https://github.com/apache/superset/commit/492b19cad532d7fd80497b8443949205748f68a0))
- **business-types:** initial implementation of SIP-78 ([#18794](https://github.com/apache/superset/issues/18794)) ([ddc01ea](https://github.com/apache/superset/commit/ddc01ea7813ef7c02cfc2aee7cbf554a45628f25))
- bypass cache on screenshots for alerts ([#17695](https://github.com/apache/superset/issues/17695)) ([b7707e8](https://github.com/apache/superset/commit/b7707e8ff7ed9369f8902d15471a93226c9aab7c))
- callback hooks for Reactified components ([#131](https://github.com/apache/superset/issues/131)) ([2ac3c08](https://github.com/apache/superset/commit/2ac3c082abf199bee398124d511ed380df31f502))
- Certify Charts and Dashboards ([#17335](https://github.com/apache/superset/issues/17335)) ([83e49fc](https://github.com/apache/superset/commit/83e49fc9eee8da5ce5e2347722fedf1248d242d5))
- change bundle to target modern browser ([#10](https://github.com/apache/superset/issues/10)) ([8a4e141](https://github.com/apache/superset/commit/8a4e141448f5816d2ec7df1a57e2a5ad4d010938))
- change font size on responsive for sankey and sunburst chart ([#977](https://github.com/apache/superset/issues/977)) ([2625698](https://github.com/apache/superset/commit/2625698f1fb5dd87e5845f521dac37d58b006214))
- channels can take array of definitions ([c469e58](https://github.com/apache/superset/commit/c469e5854adc322e7da01cbc84b7377fdc38f12f))
- **chart & legend:** make to enable show legend by default ([#19927](https://github.com/apache/superset/issues/19927)) ([7b3d0f0](https://github.com/apache/superset/commit/7b3d0f040b050905f7d0901d0227f1cd6b761b56))
- **chart-controls:** d3 formatting with .2% [#1274](https://github.com/apache/superset/issues/1274) ([#1275](https://github.com/apache/superset/issues/1275)) ([15fbe4a](https://github.com/apache/superset/commit/15fbe4a72a7d437922084a50d92f8e818637e7ad))
- **chart-controls:** dnd version of time column ([#1226](https://github.com/apache/superset/issues/1226)) ([a94ef9f](https://github.com/apache/superset/commit/a94ef9ff0086b5daac4f88647a8352171cdc816b))
- **chart-controls:** implement color formatters utils ([#1215](https://github.com/apache/superset/issues/1215)) ([3bfa709](https://github.com/apache/superset/commit/3bfa70919747e4f205038aed08299ee4f584bef0))
- **chart-controls:** implement dnd controls for all charts ([#33](https://github.com/apache/superset/issues/33)) ([5e6af31](https://github.com/apache/superset/commit/5e6af313e2ff62dbd0e5049e0ef2cb55c4f0d12c))
- **chart-controls:** implement drag&drop controls for all charts ([#1127](https://github.com/apache/superset/issues/1127)) ([c461abb](https://github.com/apache/superset/commit/c461abbdeb780a0ba2aec338b2a8c1c9cf5eaced))
- **chart-controls:** move cross-filtering control to data panel ([#1248](https://github.com/apache/superset/issues/1248)) ([9fe5865](https://github.com/apache/superset/commit/9fe5865e056fe0ad9fe45f7a70aeb09971c0f263))
- **chart-data-api:** download multiple csvs as zip ([#18618](https://github.com/apache/superset/issues/18618)) ([125be78](https://github.com/apache/superset/commit/125be78ee6681b702ce5288657aba5ce190e7fce))
- **chart:** Add `<ChartDataProvider />` ([#120](https://github.com/apache/superset/issues/120)) ([061faab](https://github.com/apache/superset/commit/061faab818b925637e3fd5822ed9a063fcfd4ede))
- **chart:** add feature flag that displays the data pane closes by default ([#21649](https://github.com/apache/superset/issues/21649)) ([ebd7536](https://github.com/apache/superset/commit/ebd75366c0c7acd6d4619996c4f209b51af518e2))
- **chart:** add Mexico to country map viz ([#18007](https://github.com/apache/superset/issues/18007)) ([f451081](https://github.com/apache/superset/commit/f45108116673d5810c238bb911058dc8ed05b75a))
- **chart:** add shared plugin controls utilities ([#389](https://github.com/apache/superset/issues/389)) ([fb46642](https://github.com/apache/superset/commit/fb4664235bf3bb5dda2b332e59a74fbf8c9f702e))
- **chart:** Added Latvia to countries map ([#22220](https://github.com/apache/superset/issues/22220)) ([9578a44](https://github.com/apache/superset/commit/9578a443ef713f01f4cc9cd3a8616b819a7a7a65))
- **chart:** Added Papua New Guinea to countries map ([#22589](https://github.com/apache/superset/issues/22589)) ([b352947](https://github.com/apache/superset/commit/b3529479ab39fcc273189bf4db4a0f1fd8b1cc0c))
- **chart:** adjust chartclient to point to new endpoints ([#551](https://github.com/apache/superset/issues/551)) ([bdb0f50](https://github.com/apache/superset/commit/bdb0f50874daa34671185f51b0f850c6f7dd33bc))
- **chart:** Enable caching per user when user impersonation is enabled ([#20114](https://github.com/apache/superset/issues/20114)) ([68af598](https://github.com/apache/superset/commit/68af5980ea5ae98978c809f308891e2e27bed220))
- **charts:** allow query mutator to update queries after splitting original sql ([#21645](https://github.com/apache/superset/issues/21645)) ([cf00970](https://github.com/apache/superset/commit/cf00970cde573011bb3d8fcdfc43258963f45bdf))
- **CI:** clean up Python tests output ([#19489](https://github.com/apache/superset/issues/19489)) ([ea70816](https://github.com/apache/superset/commit/ea708162a559a426c1c44f035883d709fc5dac50))
- **code refactoring:** code refactoring ([c87a748](https://github.com/apache/superset/commit/c87a74841ea1ad05e4041748cfed3a45749e1085))
- **color:** add official ECharts color schemes ([#751](https://github.com/apache/superset/issues/751)) ([9f1aafa](https://github.com/apache/superset/commit/9f1aafa628e4c6632039367416574152c49f9dfc))
- **color:** color consistency enhancements ([#21507](https://github.com/apache/superset/issues/21507)) ([7a7181a](https://github.com/apache/superset/commit/7a7181a2449598b09298f3a113849caeb3309186))
- **color:** support analogous colors to prevent color conflict ([#19325](https://github.com/apache/superset/issues/19325)) ([90c9dae](https://github.com/apache/superset/commit/90c9daea08cd59ba7261c13e1ce4e80a72f84b48))
- **color:** support better color interpolation for sequential schemes ([#547](https://github.com/apache/superset/issues/547)) ([f2a053b](https://github.com/apache/superset/commit/f2a053b0345b219bc3228f02c3720617144caf3d))
- **config:** Add none force-refresh option for auto refresh ([#17039](https://github.com/apache/superset/issues/17039)) ([7a2e394](https://github.com/apache/superset/commit/7a2e39449a2844455950b894e00e8c710340b209))
- configure force_screenshot ([#17855](https://github.com/apache/superset/issues/17855)) ([9baeafe](https://github.com/apache/superset/commit/9baeafec9308ddafd3f962dbf609958e9b1963ab))
- **connection:** allow developer to get supersetclient instance ([#552](https://github.com/apache/superset/issues/552)) ([0a48d6e](https://github.com/apache/superset/commit/0a48d6e774af102ada64c2119558918ce215f70a))
- **connection:** easier API for json payload ([#634](https://github.com/apache/superset/issues/634)) ([ddd9fb4](https://github.com/apache/superset/commit/ddd9fb46c76656156de502f545ba6d9f4cdcc363))
- **connection:** optimize typing and API for SupersetClient ([#635](https://github.com/apache/superset/issues/635)) ([ba8c619](https://github.com/apache/superset/commit/ba8c619c2e8ca9f7726b0bb879b0ede0ef9582a2))
- **control-utils:** add infotooltipwithtrigger ([#442](https://github.com/apache/superset/issues/442)) ([307fb23](https://github.com/apache/superset/commit/307fb23bd64e742cb203525805e3238b79a2a14c))
- **control-utils:** add packages control-utils ([#417](https://github.com/apache/superset/issues/417)) ([2be7b4b](https://github.com/apache/superset/commit/2be7b4ba0a5b30e6684fd036dd7e1f76165de390))
- **control-utils:** add shared controls + dependencies, convert to typescript ([#459](https://github.com/apache/superset/issues/459)) ([28de288](https://github.com/apache/superset/commit/28de28864b84ad12c784ae790f31827bfe3332d0))
- **control-utils:** better typing for control configs ([#595](https://github.com/apache/superset/issues/595)) ([64ffc17](https://github.com/apache/superset/commit/64ffc1782ef433006ce4d2c9674cea72fe4654ee))
- convert dataframe tests ([#17655](https://github.com/apache/superset/issues/17655)) ([3873cdf](https://github.com/apache/superset/commit/3873cdff4de9ccd5170cb0b10212bc34998bb3d0))
- **core:** add applied_time_extras to QueryObject ([#809](https://github.com/apache/superset/issues/809)) ([88c98cf](https://github.com/apache/superset/commit/88c98cf1a8bdb84495f441024a61460e898750e5))
- **core:** add custom_params to form_data ([#929](https://github.com/apache/superset/issues/929)) ([b45cc00](https://github.com/apache/superset/commit/b45cc00c227c54b5422fda26af18ebd4ff9c4e1f))
- **core:** add extra form data fields for native filters ([#992](https://github.com/apache/superset/issues/992)) ([a1093df](https://github.com/apache/superset/commit/a1093df02165bec03a781637ef6c6605cd7eb4e0))
- **core:** add new feature flags ([#1133](https://github.com/apache/superset/issues/1133)) ([0a7e2da](https://github.com/apache/superset/commit/0a7e2da8cc80a3b32b67302d3b9643661901c7e4))
- **core:** add orderby to extractQueryFields ([#919](https://github.com/apache/superset/issues/919)) ([1846be0](https://github.com/apache/superset/commit/1846be099bbc6e7dff175ca2080c03011757c1b9))
- **core:** add support for adhoc columns ([#1342](https://github.com/apache/superset/issues/1342)) ([e16a836](https://github.com/apache/superset/commit/e16a83673176e8fbdc0af8c0f43f671ff7d06ddf))
- **core:** add support for annotations and url params ([#812](https://github.com/apache/superset/issues/812)) ([757854b](https://github.com/apache/superset/commit/757854b6a931fd0de60dfed386005505da483572))
- **core:** add support for case insensitive LIKE operator ([#1129](https://github.com/apache/superset/issues/1129)) ([a6cfaff](https://github.com/apache/superset/commit/a6cfaffa35e2b3b4d4d1d512783f0f2e01129c6a))
- **core:** add support for empty results and refresh indicator ([#1121](https://github.com/apache/superset/issues/1121)) ([c2c84da](https://github.com/apache/superset/commit/c2c84da6f0303c943bd5e34cf44dda2fcfd4e34e))
- **core:** add support for non-temporal series limit ([#1356](https://github.com/apache/superset/issues/1356)) ([614e06d](https://github.com/apache/superset/commit/614e06dede4bb6db76c16b7fe8516ae6001e2353))
- **core:** copy feature flags from main repo ([#982](https://github.com/apache/superset/issues/982)) ([0f8df43](https://github.com/apache/superset/commit/0f8df43a9b4f2eda91c920cebb8bbeae704eeb79))
- **core:** expand native filter hook and add chart metadata fields ([#943](https://github.com/apache/superset/issues/943)) ([25a98fb](https://github.com/apache/superset/commit/25a98fba97937b990880a1a5052718593a2b1698))
- **core:** Registry listeners ([#1191](https://github.com/apache/superset/issues/1191)) ([29df573](https://github.com/apache/superset/commit/29df573a94122197c6082eb7b8df4dc0b643709e))
- **core:** remove defaults for time range filter and Metrics ([#1114](https://github.com/apache/superset/issues/1114)) ([1a4e3e8](https://github.com/apache/superset/commit/1a4e3e8cc62d4d9ce25d68e90ec2cd323e3f0dce))
- **country-map:** added new countries in country-chart-map ([#18081](https://github.com/apache/superset/issues/18081)) ([0cec0c9](https://github.com/apache/superset/commit/0cec0c9a68c9489c54bea8d10ea7b28c1729e2dc))
- Create Chart onClick Functionality ([#20809](https://github.com/apache/superset/issues/20809)) ([7495cdb](https://github.com/apache/superset/commit/7495cdbfe0e3d8ef79b6500581d03ba74684a3a2))
- Create dataset blank state ([#21058](https://github.com/apache/superset/issues/21058)) ([6094274](https://github.com/apache/superset/commit/6094274f0b017b4a456cd78c3039a57be2d63fc5))
- Create dataset header component ([#21189](https://github.com/apache/superset/issues/21189)) ([6e8cad3](https://github.com/apache/superset/commit/6e8cad3e160f0ca7f7dd330861f050ed82a1053b))
- create function for get_sqla_engine with context ([#21790](https://github.com/apache/superset/issues/21790)) ([7600da8](https://github.com/apache/superset/commit/7600da80412186d0f5d0c85e6cd831fbae2e9d9e))
- create reusable selector factory for Encoder ([852b9e6](https://github.com/apache/superset/commit/852b9e609d291c97b1ed4c3d1724c55594cbe732))
- create table component based on ant design Table ([#21520](https://github.com/apache/superset/issues/21520)) ([736b534](https://github.com/apache/superset/commit/736b53418a3b3394dc967458d03d4c0ebcadabdd))
- Creating dataset/add route ([#20869](https://github.com/apache/superset/issues/20869)) ([460b213](https://github.com/apache/superset/commit/460b2130577f85d1996b547fb77b69a00f4ba28e))
- Cross-referenced Dashboards in Chart list (Column + Filter) ([#21760](https://github.com/apache/superset/issues/21760)) ([49b48ee](https://github.com/apache/superset/commit/49b48eeca484fafa2f1c5ef2520694b1bdf5c522))
- **CRUD:** add new empty state ([#19310](https://github.com/apache/superset/issues/19310)) ([d49fd01](https://github.com/apache/superset/commit/d49fd01ff3e3ee153e5e50352ec2151f028a5456))
- **css:** adds `chartId`-based class to dashboard chart holder ([#19873](https://github.com/apache/superset/issues/19873)) ([60188ef](https://github.com/apache/superset/commit/60188ef65476c534647db813c35add3236076cec))
- CSV File Upload form updates ([#21922](https://github.com/apache/superset/issues/21922)) ([6bb4d87](https://github.com/apache/superset/commit/6bb4d87deb95c6230223860fedde07073913d780))
- CSV File Upload form updates (Grouping with Collapse/Expand) ([#21992](https://github.com/apache/superset/issues/21992)) ([2fd0a61](https://github.com/apache/superset/commit/2fd0a6146ed458a47e1a1e07f91d373dda93d290))
- Custom filters control ([#17006](https://github.com/apache/superset/issues/17006)) ([eebc953](https://github.com/apache/superset/commit/eebc953dd599ed13a4893e9c9c726bddb19f7666))
- customize no data message in nvd3 charts ([#330](https://github.com/apache/superset/issues/330)) ([d350dd2](https://github.com/apache/superset/commit/d350dd2f0abdfe1d249aea8d3544839814fe642e))
- customize recent activity access ([#17589](https://github.com/apache/superset/issues/17589)) ([c4b0495](https://github.com/apache/superset/commit/c4b04952d0e446b2347d2e6928478e2207102567))
- **dashboard:** Add create chart button in dashboard edit mode ([#20126](https://github.com/apache/superset/issues/20126)) ([b2a7fad](https://github.com/apache/superset/commit/b2a7fadba951c09fad5867676aaa0470404856df))
- **dashboard:** Add description to the native filter ([#17025](https://github.com/apache/superset/issues/17025)) ([65f1644](https://github.com/apache/superset/commit/65f1644208d499dd52dfd1437f74ec0c228acd9b))
- **dashboard:** Add divider component in native filters ([#17410](https://github.com/apache/superset/issues/17410)) ([9576478](https://github.com/apache/superset/commit/9576478a5dbbfa2e6d057ce16ac19ec9b6ad6940))
- **dashboard:** Add Drill to Detail modal w/ chart menu + right-click support ([#20728](https://github.com/apache/superset/issues/20728)) ([52648ec](https://github.com/apache/superset/commit/52648ecd7f6158473ec198e1ade9a5a69008b752))
- **dashboard:** Add edit button to dashboard native filters filter cards ([#22364](https://github.com/apache/superset/issues/22364)) ([3b45ad8](https://github.com/apache/superset/commit/3b45ad8b97ff7a72ac4d57cfbd2289bf38022cfc))
- **dashboard:** Add thumbnails to dashboard edit draggable chart list ([#20528](https://github.com/apache/superset/issues/20528)) ([d50784d](https://github.com/apache/superset/commit/d50784dd808cf908567e2c7f9fa67188202c59b9))
- **dashboard:** add toast feedback to dashboard actions ([#18114](https://github.com/apache/superset/issues/18114)) ([d9eef8e](https://github.com/apache/superset/commit/d9eef8ec2f15d81309860865319a578f6f5906a5))
- **dashboard:** Chart title click redirects to Explore ([#20111](https://github.com/apache/superset/issues/20111)) ([b746e6f](https://github.com/apache/superset/commit/b746e6f844d457d9a8c81d64e9154f315a61a29d))
- **dashboard:** confirm overwrite to prevent unintended changes ([#21819](https://github.com/apache/superset/issues/21819)) ([ef6b9a9](https://github.com/apache/superset/commit/ef6b9a97d594f748ab710e27281d41ee5250d33a))
- **dashboard:** Display a loading spinner while dashboard is being saved ([#22588](https://github.com/apache/superset/issues/22588)) ([399f6e3](https://github.com/apache/superset/commit/399f6e3ddc8bb21fd7b39cdf850510b2692fbe12))
- **dashboard:** Implement empty states for dashboard ([#18712](https://github.com/apache/superset/issues/18712)) ([f8b3ece](https://github.com/apache/superset/commit/f8b3ece27bea68bc237f61123d2400ee2e1bca44))
- **dashboard:** Implement empty states for empty tabs ([#19408](https://github.com/apache/superset/issues/19408)) ([fc8cb22](https://github.com/apache/superset/commit/fc8cb223761ef78f888d5d4dbf038caa1028b277))
- **dashboard:** Let users re-arrange native filters ([#16154](https://github.com/apache/superset/issues/16154)) ([9e6d5fc](https://github.com/apache/superset/commit/9e6d5fc7752667bbd0df740b0ee50487cecc6c3c))
- **dashboard:** Make FilterBar width resizable ([#20778](https://github.com/apache/superset/issues/20778)) ([1debaca](https://github.com/apache/superset/commit/1debacaaca156c6d63606f3c4aabce8adf13a837))
- **dashboard:** make permalink deterministic ([#20632](https://github.com/apache/superset/issues/20632)) ([c3ac612](https://github.com/apache/superset/commit/c3ac61271ab0b5637b3b199b43fa69be1cfd3bae))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- **dashboard:** Move dashboard auto refresh intervals options to config ([#21924](https://github.com/apache/superset/issues/21924)) ([edce579](https://github.com/apache/superset/commit/edce57904728156312b795923019a1520147d045))
- **dashboard:** Rearrange items in chart header controls dropdown ([#20049](https://github.com/apache/superset/issues/20049)) ([3043a54](https://github.com/apache/superset/commit/3043a54bfc1198bdef8128ec88c8e571d9640cff))
- **dashboard:** Support changing filter bar location ([#22004](https://github.com/apache/superset/issues/22004)) ([68e8b00](https://github.com/apache/superset/commit/68e8b00cdec21db491995567be0aedbe26ea9482))
- **dashboard:** Transition to Explore with React Router ([#20606](https://github.com/apache/superset/issues/20606)) ([de4f7db](https://github.com/apache/superset/commit/de4f7db57ec33c497be9c880fde534a1f026241f))
- **database:** Add user_id and dttm composite index to Log model. ([#19532](https://github.com/apache/superset/issues/19532)) ([d16f274](https://github.com/apache/superset/commit/d16f274991537ef8183eff4636792d2d186d4e16))
- Databricks native driver ([#20320](https://github.com/apache/superset/issues/20320)) ([ec331e6](https://github.com/apache/superset/commit/ec331e683e03e2422e956729f3f32a2442f7d82c))
- Dataset Creation Footer Component ([#21241](https://github.com/apache/superset/issues/21241)) ([c4638fa](https://github.com/apache/superset/commit/c4638fa2b9f9d66ac204b89d24bde7d57e06ebb9))
- **datasets:** Change in API to create virtual datasets ([#21840](https://github.com/apache/superset/issues/21840)) ([decb2fb](https://github.com/apache/superset/commit/decb2fb59190108edd4e3fd3099158dd944aec94))
- **datasets:** Populate Usage tab in Edit Dataset view ([#22670](https://github.com/apache/superset/issues/22670)) ([32fac77](https://github.com/apache/superset/commit/32fac77b5ffd39f693634ee09bcdb205860cb788))
- datasource access to allow more granular access to tables on SQL Lab ([#18064](https://github.com/apache/superset/issues/18064)) ([5ee070c](https://github.com/apache/superset/commit/5ee070c40228d6abbb30e4a8f7888886cf35d7f1))
- **datatable:** render html correctly ([#199](https://github.com/apache/superset/issues/199)) ([a937a2a](https://github.com/apache/superset/commit/a937a2a00ea386896252c7e2188d57c3c55a8033))
- **db_engine_specs:** big query cost estimation ([#21325](https://github.com/apache/superset/issues/21325)) ([001100d](https://github.com/apache/superset/commit/001100ddf02db7be1ea94a1cac16475d00436b78))
- DBC UI Snowflake Form ([#16856](https://github.com/apache/superset/issues/16856)) ([40b88f0](https://github.com/apache/superset/commit/40b88f04f6d360d66fcab7206e2e481d71ddf884)), closes [#16861](https://github.com/apache/superset/issues/16861) [#16875](https://github.com/apache/superset/issues/16875) [#16934](https://github.com/apache/superset/issues/16934) [#17022](https://github.com/apache/superset/issues/17022)
- DBC-UI Globally available across the app 🌎 ([#18722](https://github.com/apache/superset/issues/18722)) ([209e3f4](https://github.com/apache/superset/commit/209e3f45548ae8d0b3ac63d2c393883b733d2b22))
- **deck.gl:** add color range for deck.gl 3D ([#19520](https://github.com/apache/superset/issues/19520)) ([c0a00fd](https://github.com/apache/superset/commit/c0a00fd302ec66fbe0ca766cf73978c99ba00d82))
- **demo:** add helpers for resizable chart demo ([#557](https://github.com/apache/superset/issues/557)) ([5adb9aa](https://github.com/apache/superset/commit/5adb9aaa4332f0586e7c405134f1bf526e3f5478))
- deprecate /superset/extra_table_metadata migrate to api v1 ([#19921](https://github.com/apache/superset/issues/19921)) ([4fdf230](https://github.com/apache/superset/commit/4fdf230a568b014309357b9d691c30fe1a50b32f))
- deprecate /superset/testconn and migrate to api v1 ([#20002](https://github.com/apache/superset/issues/20002)) ([7b7de95](https://github.com/apache/superset/commit/7b7de9592b1852e1582f5be84e4d954e3f55f011))
- deprecate /superset/validate_sql_json migrate to api v1 ([#19935](https://github.com/apache/superset/issues/19935)) ([87a4379](https://github.com/apache/superset/commit/87a4379d0ac1d6bd1b7c91e22742393271929ed5))
- deprecate created_slices API endpoint ([#21664](https://github.com/apache/superset/issues/21664)) ([3057e42](https://github.com/apache/superset/commit/3057e4270cd76232271072b74ad13e7301bd3a79))
- deprecate old API and create new API for dashes created by me ([#19434](https://github.com/apache/superset/issues/19434)) ([d6d2777](https://github.com/apache/superset/commit/d6d2777ada0768682fde7f32cd7e49ec6b0203f2))
- deprecate old API on core superset fave_dashboards ([#19754](https://github.com/apache/superset/issues/19754)) ([85b0ef8](https://github.com/apache/superset/commit/85b0ef8526f9f672306120fc1fda8f9d4661bc80))
- deprecate old SuperChart API that accepts chartProps ([#202](https://github.com/apache/superset/issues/202)) ([0fb91c0](https://github.com/apache/superset/commit/0fb91c0e6bb8396ed423324b05595b67e006d72e))
- derived metrics use different line style ([#20242](https://github.com/apache/superset/issues/20242)) ([7faf874](https://github.com/apache/superset/commit/7faf874c1b9613258606fb10f5800a185c30c81e))
- disable edits on external assets ([#19344](https://github.com/apache/superset/issues/19344)) ([d304849](https://github.com/apache/superset/commit/d304849b46b39bb6a261b735b7ca658962bc31e0))
- Disables HTML rendering in Toast by default ([#21853](https://github.com/apache/superset/issues/21853)) ([47b1e0c](https://github.com/apache/superset/commit/47b1e0ca9dfdea153e133442bee676ba9a73aba0))
- **docker-compose:** add TAG option ([#18214](https://github.com/apache/superset/issues/18214)) ([0a91a68](https://github.com/apache/superset/commit/0a91a6880a0769ace79224b9a967eec6a685d03d))
- **docker:** Build multiple python version images ([#22770](https://github.com/apache/superset/issues/22770)) ([931b01e](https://github.com/apache/superset/commit/931b01ee85702aabe7632a278e0f13837087b5a1))
- don't ask for password when DB exists ([#17776](https://github.com/apache/superset/issues/17776)) ([73ae892](https://github.com/apache/superset/commit/73ae892066ca719c5ff1ecf6dfe2d237fef41934))
- Drill ODBC/JDBC Impersonation feature ([#17353](https://github.com/apache/superset/issues/17353)) ([333b137](https://github.com/apache/superset/commit/333b1371f75437e213f1319e506183690bba0705))
- drop missing columns control ([#20586](https://github.com/apache/superset/issues/20586)) ([309327d](https://github.com/apache/superset/commit/309327dcbdec954283ef6cd03fccf264a830e4a5))
- Dynamic dashboard component ([#17208](https://github.com/apache/superset/issues/17208)) ([bcad1ac](https://github.com/apache/superset/commit/bcad1acec27823756dc403f6e982f5e59ec6d6cf))
- echarts gauge chart ([#993](https://github.com/apache/superset/issues/993)) ([9070ac9](https://github.com/apache/superset/commit/9070ac954eb4988d4a6ab7ded7bd03d9ca102484))
- editable title xl certified badge ([#18626](https://github.com/apache/superset/issues/18626)) ([00eb6b1](https://github.com/apache/superset/commit/00eb6b1f5711e1af0b8dcfc05346ad0dacadddda))
- embedded dashboard ([#18561](https://github.com/apache/superset/issues/18561)) ([1fbdabd](https://github.com/apache/superset/commit/1fbdabd2cf88ce4da0b99897ce00afd03ae47d27))
- Embedded dashboard configuration ([#19364](https://github.com/apache/superset/issues/19364)) ([8e29ec5](https://github.com/apache/superset/commit/8e29ec5a6685867ffc035d20999c54c2abe36fb1))
- embedded dashboard core ([#17530](https://github.com/apache/superset/issues/17530)) ([4ad5ad0](https://github.com/apache/superset/commit/4ad5ad045a9adb506d14b2c02fdbefc564d25bdb)), closes [#17175](https://github.com/apache/superset/issues/17175) [#17450](https://github.com/apache/superset/issues/17450) [#17517](https://github.com/apache/superset/issues/17517) [#17529](https://github.com/apache/superset/issues/17529) [#17757](https://github.com/apache/superset/issues/17757) [#17836](https://github.com/apache/superset/issues/17836)
- Embedded SDK ([#18250](https://github.com/apache/superset/issues/18250)) ([1c2936b](https://github.com/apache/superset/commit/1c2936ba7b3e54d65f6607b14cd0b341f83d9b91))
- **embedded-dashboard:** Share Switchboard State for Sending Events from Plugins ([#21319](https://github.com/apache/superset/issues/21319)) ([20b9dc8](https://github.com/apache/superset/commit/20b9dc84449969706efb94210bc11b2e43cc9a0f))
- **embedded-SDK:** enable CSV download ([#20416](https://github.com/apache/superset/issues/20416)) ([655646d](https://github.com/apache/superset/commit/655646d35bea8f52d805d1bcc36e58d10fb8a6d5))
- **embedded:** +2 functions: getDashboardPermalink, getActiveTabs ([#21444](https://github.com/apache/superset/issues/21444)) ([b787c3f](https://github.com/apache/superset/commit/b787c3fef4655c1142da3d827fe6766c853ffe72))
- **embedded:** add optional dashboard ui configuration ([#19031](https://github.com/apache/superset/issues/19031)) ([124cb0d](https://github.com/apache/superset/commit/124cb0dc669756f0cec1b1a82cdaddf35520282e))
- **embedded:** API get embedded dashboard config by uuid ([#19650](https://github.com/apache/superset/issues/19650)) ([224769b](https://github.com/apache/superset/commit/224769bd452b831ae4ab4d7fc658b61805970b62))
- **embedded:** aud claim and type for guest token ([#18651](https://github.com/apache/superset/issues/18651)) ([e6ea197](https://github.com/apache/superset/commit/e6ea197e9f2a1ea513c40afb0ae1c27ef7a5aa13))
- **embedded:** enforce allow domains ([#20251](https://github.com/apache/superset/issues/20251)) ([f53018c](https://github.com/apache/superset/commit/f53018c7c5ebbec04ffd879e1b09fb4a3ffa5609))
- **embedded:** make guest token JWT audience callable or str ([#18748](https://github.com/apache/superset/issues/18748)) ([b2613f6](https://github.com/apache/superset/commit/b2613f648c9674e80e1bca885ee79ddd2805a21c))
- **embedded:** provides filter bar visibility setting on embedded dashboard ([#21069](https://github.com/apache/superset/issues/21069)) ([#21070](https://github.com/apache/superset/issues/21070)) ([eb80568](https://github.com/apache/superset/commit/eb805682e2d9b8ff6c4bda446e665d1045afe55f))
- Enable new dataset creation flow ([#22610](https://github.com/apache/superset/issues/22610)) ([c87f654](https://github.com/apache/superset/commit/c87f654901f5a975fa2f348c2893b2aa78db5707))
- Enable new dataset creation flow II ([#22835](https://github.com/apache/superset/issues/22835)) ([260ac40](https://github.com/apache/superset/commit/260ac40b23e99a49be70781e56bc037e5f952090))
- Enabling source maps full time ([#19710](https://github.com/apache/superset/issues/19710)) ([34008f7](https://github.com/apache/superset/commit/34008f78c9456bd40c0893dd8e239b5c47b612e4))
- **encodable:** add function for setting domain ([#256](https://github.com/apache/superset/issues/256)) ([1772b67](https://github.com/apache/superset/commit/1772b671cf63c860a0584e3975c8dd3c75e9ed85))
- **encodable:** fill missing fields in user-specified channel definition ([#222](https://github.com/apache/superset/issues/222)) ([1978d9b](https://github.com/apache/superset/commit/1978d9bc2e5fb717432e45fa32feb8e6ea47efce))
- **encodable:** handle edge cases when making domain includes zero ([#257](https://github.com/apache/superset/issues/257)) ([e719c19](https://github.com/apache/superset/commit/e719c1936525df7a601bfca52420f4cbbb3e3667))
- **encodable:** implement axis functions for ChannelEncoder ([#247](https://github.com/apache/superset/issues/247)) ([9ef8318](https://github.com/apache/superset/commit/9ef831829b9630593f7320ca840813a2d8a91df1))
- **encodable:** make applyDomain() able to handle domain from dataset ([#254](https://github.com/apache/superset/issues/254)) ([f5f944b](https://github.com/apache/superset/commit/f5f944b40500181c5e4beb8c4f0d55ddb6ddc51f))
- **encodable:** only set scale domain if both bounds are defined ([#250](https://github.com/apache/superset/issues/250)) ([b672373](https://github.com/apache/superset/commit/b6723737a33f2d544b5cd5d3f06c2dfb8583df7e))
- Environment tag ([#20295](https://github.com/apache/superset/issues/20295)) ([25cc789](https://github.com/apache/superset/commit/25cc7897b1ac0ba3294d437b16e7eae5a0bc78c9))
- explicit distribute columns on BoxPlot and apply time grain ([#21593](https://github.com/apache/superset/issues/21593)) ([93f08e7](https://github.com/apache/superset/commit/93f08e778bfd48be150749f22d0b184467da73ac))
- Explore popovers should close on escape ([#19902](https://github.com/apache/superset/issues/19902)) ([dbc653d](https://github.com/apache/superset/commit/dbc653d442e48078546210a76df5eb216b30b707))
- **explore-popover:** Show disabled 'Save' button in explore popover ([#21318](https://github.com/apache/superset/issues/21318)) ([0dbaaad](https://github.com/apache/superset/commit/0dbaaad83d9a80b1c3ea46af7859f7f4f7d677e0))
- **explore:** add config for default time filter ([#21879](https://github.com/apache/superset/issues/21879)) ([9a063ab](https://github.com/apache/superset/commit/9a063abb3b28e32b1107950942571d564bb283f8))
- **explore:** Add empty state to annotations ([#20160](https://github.com/apache/superset/issues/20160)) ([0ee1f49](https://github.com/apache/superset/commit/0ee1f492a799f339e1adf3b260a95ff541c331de))
- **explore:** adhoc column expressions [ID-3] ([#17379](https://github.com/apache/superset/issues/17379)) ([e2a429b](https://github.com/apache/superset/commit/e2a429b0c8042ba867f834f5dc5561d1e402289b)), closes [#16531](https://github.com/apache/superset/issues/16531) [#16570](https://github.com/apache/superset/issues/16570) [#16559](https://github.com/apache/superset/issues/16559) [#16412](https://github.com/apache/superset/issues/16412) [#16573](https://github.com/apache/superset/issues/16573) [#16568](https://github.com/apache/superset/issues/16568) [#16535](https://github.com/apache/superset/issues/16535) [#16548](https://github.com/apache/superset/issues/16548) [#16595](https://github.com/apache/superset/issues/16595) [#16594](https://github.com/apache/superset/issues/16594) [#16601](https://github.com/apache/superset/issues/16601)
- **explore:** Allow using time formatter on temporal columns in data table ([#18569](https://github.com/apache/superset/issues/18569)) ([830f2e7](https://github.com/apache/superset/commit/830f2e71d3328ffa0a50af353ad9eb656e0812ed))
- **explore:** Apply denormalization to tier 2 charts form data ([#20524](https://github.com/apache/superset/issues/20524)) ([e12ee59](https://github.com/apache/superset/commit/e12ee59b13822241dca8d8015f1222c477edd4f3))
- **explore:** Dataset panel option tooltips ([#19259](https://github.com/apache/superset/issues/19259)) ([45c28c8](https://github.com/apache/superset/commit/45c28c8046c56d4ebe1dfaf0235783fe864ae75f))
- **explore:** Dataset Panel Options when Source = Query II ([#20299](https://github.com/apache/superset/issues/20299)) ([c842c9e](https://github.com/apache/superset/commit/c842c9e2d8d2b579e514fb291def3f3b0a5860e3))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- **explore:** Don't discard controls with custom sql when changing datasource ([#20934](https://github.com/apache/superset/issues/20934)) ([cddc361](https://github.com/apache/superset/commit/cddc361adc483ed605857a2eb39c5efffa089076))
- **explore:** export csv data pivoted for Pivot Table [ID-9] ([#17512](https://github.com/apache/superset/issues/17512)) ([07e8837](https://github.com/apache/superset/commit/07e8837093b79b08e18224dd6765a2fc15a0e770))
- **explore:** Fill dashboard name when adding new chart from dashboard view ([#20129](https://github.com/apache/superset/issues/20129)) ([3e3fbcc](https://github.com/apache/superset/commit/3e3fbccdcb03faaf484b5077827fa48d3183f629))
- **explore:** Frontend implementation of dataset creation from infobox ([#19855](https://github.com/apache/superset/issues/19855)) ([ba0c37d](https://github.com/apache/superset/commit/ba0c37d3df85b1af39404af1d578daeb0ff2d278))
- **explore:** Implement chart empty states ([#18678](https://github.com/apache/superset/issues/18678)) ([167e18e](https://github.com/apache/superset/commit/167e18e806799dede3aa56da98be11f4751f0272))
- **explore:** Implement data panel redesign ([#19751](https://github.com/apache/superset/issues/19751)) ([594523e](https://github.com/apache/superset/commit/594523e895a8fa455ba6db5d6cc4df80d20179a1))
- **explore:** Implement data table empty states ([#18679](https://github.com/apache/superset/issues/18679)) ([42d97fb](https://github.com/apache/superset/commit/42d97fb078a50bca9ecb815f508a198ff5231487))
- **explore:** Implement metrics and columns popovers empty states ([#18681](https://github.com/apache/superset/issues/18681)) ([c1205b5](https://github.com/apache/superset/commit/c1205b5279e891af8c3276ee2dd7343623e8cbb3))
- **explore:** Implement viz switcher redesign ([#20248](https://github.com/apache/superset/issues/20248)) ([86f146e](https://github.com/apache/superset/commit/86f146e217ddb7c2ebd499acddaa5e8c3b3ab560))
- **explore:** improve UI in the control panel ([#19748](https://github.com/apache/superset/issues/19748)) ([e3a54aa](https://github.com/apache/superset/commit/e3a54aa3c15bdd0c970aa73f898288a408205c97))
- **explore:** Keep or reset chart config after datasource change ([#18215](https://github.com/apache/superset/issues/18215)) ([7096982](https://github.com/apache/superset/commit/70969821de07bbeac880c476202e5dd3d7a962e8))
- **explore:** More explicit labels of adhoc filter operators ([#19691](https://github.com/apache/superset/issues/19691)) ([b81982d](https://github.com/apache/superset/commit/b81982d8f3ae5dea8a70b20406a77f81393c578f))
- **explore:** more toast feedback on user actions in Explore ([#18108](https://github.com/apache/superset/issues/18108)) ([e632193](https://github.com/apache/superset/commit/e632193eb00803594a1bbc20c2f6cb6fb29deb1f))
- **explore:** Move chart actions into dropdown ([#19446](https://github.com/apache/superset/issues/19446)) ([1a1322d](https://github.com/apache/superset/commit/1a1322d3d92960416a4874997b53aec3bd59eff6))
- **explore:** Move chart header to top of the page ([#19529](https://github.com/apache/superset/issues/19529)) ([602afba](https://github.com/apache/superset/commit/602afbaa31d72eefd213d85649eee494e72add7a))
- **explore:** Move timer, row counter and cached pills to chart container ([#19458](https://github.com/apache/superset/issues/19458)) ([03d3eaa](https://github.com/apache/superset/commit/03d3eaacafc6ebdad7fdbcef6efa4df553468ba1))
- **explore:** Redesign of Run/Save buttons ([#19558](https://github.com/apache/superset/issues/19558)) ([c8304a2](https://github.com/apache/superset/commit/c8304a2821cc86d01e3e3c01ee597c94b1fb64e9))
- **explore:** Replace overlay with alert banner when chart controls change ([#19696](https://github.com/apache/superset/issues/19696)) ([6f4480a](https://github.com/apache/superset/commit/6f4480a06cf4b48f7ab69a55016a0c9ad2c3790b))
- **explore:** Show confirmation modal if user exits Explore without saving changes ([#19993](https://github.com/apache/superset/issues/19993)) ([ca9766c](https://github.com/apache/superset/commit/ca9766c109ae0849748e791405554f54e5d13249))
- **explore:** SQL popover in datasource panel ([#19308](https://github.com/apache/superset/issues/19308)) ([60dcd65](https://github.com/apache/superset/commit/60dcd651f44b7e1aa1b030e0cd5c64334a346e60))
- **explore:** standardized controls for time pivot chart ([#21321](https://github.com/apache/superset/issues/21321)) ([79525df](https://github.com/apache/superset/commit/79525dfaf29b810af668e3b6c5a56cd866370d92))
- **explore:** support show annotation label [ID-8] ([#17307](https://github.com/apache/superset/issues/17307)) ([a3cce57](https://github.com/apache/superset/commit/a3cce5705dfe21ad76b8edc22e6418620a463eb1))
- **explore:** UI changes in dataset panel on Explore page ([#19394](https://github.com/apache/superset/issues/19394)) ([a076ae6](https://github.com/apache/superset/commit/a076ae6d9913a62d353d1cc2d4ed09e27ce9f6e2))
- **explore:** UX changes in fast viz switcher ([#20848](https://github.com/apache/superset/issues/20848)) ([5c2c2e8](https://github.com/apache/superset/commit/5c2c2e804064ba674ae18abe5aec495454b7ff21))
- export/import `allow_dml` flag ([#22806](https://github.com/apache/superset/issues/22806)) ([6f0fed7](https://github.com/apache/superset/commit/6f0fed77cfe737122cec98374dc6774240cd6396))
- expose form_data to datasourceControl ([#1148](https://github.com/apache/superset/issues/1148)) ([6b4480b](https://github.com/apache/superset/commit/6b4480b63f842987d7f30b38c29fd3983077e21f))
- external management flags in CRUD ([#19318](https://github.com/apache/superset/issues/19318)) ([9766726](https://github.com/apache/superset/commit/9766726b26e780c9e0d68eb8e8f9c27332c7a9d2))
- extra_jwt support to be used in dashboard_rbac ([#1021](https://github.com/apache/superset/issues/1021)) ([e71d929](https://github.com/apache/superset/commit/e71d929034ad15e359e04536ad3252d8d9200b90))
- **feature-flag:** add ALERTS_ATTACH_REPORTS feature flag ([#1042](https://github.com/apache/superset/issues/1042)) ([803fd44](https://github.com/apache/superset/commit/803fd44dac513ce100df209dfc17e2a775d1d431))
- file skeleton necessary for icicle chart visualization ([#162](https://github.com/apache/superset/issues/162)) ([4760af2](https://github.com/apache/superset/commit/4760af293ecac9436451c1500f0d9dd58bc7d03a))
- filter parameters from DB API ([#21248](https://github.com/apache/superset/issues/21248)) ([34a79ad](https://github.com/apache/superset/commit/34a79add04d4525c164699248c30c9d6588c876d))
- filter with created_by for charts and dashboards ([#21199](https://github.com/apache/superset/issues/21199)) ([05354a9](https://github.com/apache/superset/commit/05354a96bfaeacaa39974977b4502cd26bef8413))
- **Filter-sets:** connect to api ([#17055](https://github.com/apache/superset/issues/17055)) ([37944e1](https://github.com/apache/superset/commit/37944e18d6dccb04a5a768134b6fc1f4a2e625a3))
- **filters:** add onFilterUpdate handler to list view filters ([#21443](https://github.com/apache/superset/issues/21443)) ([f27e20e](https://github.com/apache/superset/commit/f27e20e30dc90b068887cb79cb030eb020f8ea6d))
- Flow for tables that already have a dataset ([#22136](https://github.com/apache/superset/issues/22136)) ([04b7a26](https://github.com/apache/superset/commit/04b7a26365edac524cbeb7336bd64898cdf52835))
- generate consistent QueryObject whether GenericAxis is enabled or disabled ([#21519](https://github.com/apache/superset/issues/21519)) ([4d12e37](https://github.com/apache/superset/commit/4d12e3709eb7ab1cc4f687c15ed54a4738266482))
- generate label map on the backend ([#21124](https://github.com/apache/superset/issues/21124)) ([11bf7b9](https://github.com/apache/superset/commit/11bf7b9125eefd93796a46d964c3f027fbc9ce4d))
- **generator-superset:** add scaffolder for chart plugin ([#456](https://github.com/apache/superset/issues/456)) ([dfa166c](https://github.com/apache/superset/commit/dfa166ca819b1c93957af25db5365467c1fa3d7a))
- Generic X-axis improvements ([#22707](https://github.com/apache/superset/issues/22707)) ([af73c59](https://github.com/apache/superset/commit/af73c59b0a436ae88f64f12d4d40e4abf5fb54e8))
- getter function to return color mapping ([#124](https://github.com/apache/superset/issues/124)) ([9dd30b0](https://github.com/apache/superset/commit/9dd30b0350baa22943578f93027cc182de109b9b))
- groupby filter ([#1064](https://github.com/apache/superset/issues/1064)) ([2bb19f1](https://github.com/apache/superset/commit/2bb19f16ee6480d5538db8bac7f29d46e2aa6bc7))
- hack db connection modal ctabtns ([#20017](https://github.com/apache/superset/issues/20017)) ([9da7c1f](https://github.com/apache/superset/commit/9da7c1f7b83abea20e3620d5461a47dc4a2ab019))
- **handlebars plugin:** adding handlebars helpers for common math operations ([#20648](https://github.com/apache/superset/issues/20648)) ([9856d88](https://github.com/apache/superset/commit/9856d88c03c78a97f6037077e0d0e1e2bac491fe))
- have user go to explore after dataset creation ([#19965](https://github.com/apache/superset/issues/19965)) ([c795dc2](https://github.com/apache/superset/commit/c795dc23b96a0af3be4bcf1b287137de261b18ca))
- Helm - custom service account creation and management ([#17880](https://github.com/apache/superset/issues/17880)) ([6991417](https://github.com/apache/superset/commit/699141745aca5bbfb929f4166c9f599be8d27974))
- **Helm Chart:** Support resource limits and requests for each component ([#20052](https://github.com/apache/superset/issues/20052)) ([259e03e](https://github.com/apache/superset/commit/259e03ee12b0c82d801a0ad5765de4456a9646c5))
- **helm:** add `metadata namespace` ([#22020](https://github.com/apache/superset/issues/22020)) ([53ed8f2](https://github.com/apache/superset/commit/53ed8f2d5a64a655cf508d38f1b617df435d3628))
- **helm:** Add ability to customize affinity per deployment ([#22827](https://github.com/apache/superset/issues/22827)) ([b132451](https://github.com/apache/superset/commit/b132451581e456d202881991f675cb7665af0eb1))
- **helm:** add annotations on ServiceAccount ([#21536](https://github.com/apache/superset/issues/21536)) ([8ee34e1](https://github.com/apache/superset/commit/8ee34e175d9c2ee2d77ca9eb7406f8d06e790c7d))
- **helm:** add deploymentLabels variable ([#22541](https://github.com/apache/superset/issues/22541)) ([d6bce09](https://github.com/apache/superset/commit/d6bce09ac32d3146d22a14d205139551637170af))
- **helm:** add liveness and readiness for deployment webserver ([#20567](https://github.com/apache/superset/issues/20567)) ([554ed64](https://github.com/apache/superset/commit/554ed6495e33f57ea5e4f5834c01e0e51c6a8e73))
- **helm:** add RollingUpdate parameters ([#20931](https://github.com/apache/superset/issues/20931)) ([3f8e9a5](https://github.com/apache/superset/commit/3f8e9a567aa500c707dd024676cc3f6b721e0c71))
- **helm:** Add schema of values in Helm Chart ([#18161](https://github.com/apache/superset/issues/18161)) ([6200977](https://github.com/apache/superset/commit/62009773a63b9a149b259135d762102aedaae2b3))
- **helm:** Added env variable SERVER_WORKER_AMOUNT ([#21236](https://github.com/apache/superset/issues/21236)) ([05bdaf2](https://github.com/apache/superset/commit/05bdaf23765b90bf072f23250049174cc2ba5047))
- **helm:** allow persisting nodePort for services ([#22713](https://github.com/apache/superset/issues/22713)) ([a307223](https://github.com/apache/superset/commit/a307223857a3888931c2a876ba6e9d5b31a85add))
- **helm:** allow to customize init image ([#18649](https://github.com/apache/superset/issues/18649)) ([4db70b5](https://github.com/apache/superset/commit/4db70b5c18fc7d66ae05bfa24badf7659d4319d7))
- **HelmChart:** Add securityContext on pod level ([#20666](https://github.com/apache/superset/issues/20666)) ([ae306d6](https://github.com/apache/superset/commit/ae306d6d1f76d6437e640c649e6a4c4e8b3060cb))
- **HelmChart:** Configurable securityContext in Pods ([#20509](https://github.com/apache/superset/issues/20509)) ([1a80668](https://github.com/apache/superset/commit/1a806687fc75c5ed4f561ece1264149e37dd7df3))
- **helm:** Make Chart.AppVersion default value for image tag ([#22854](https://github.com/apache/superset/issues/22854)) ([ede18be](https://github.com/apache/superset/commit/ede18be08e74f1798e9af10706c3cfeaa08067ad))
- **Helm:** Redis with password supported in helm charts and redis chart version updated ([#18642](https://github.com/apache/superset/issues/18642)) ([33d1c96](https://github.com/apache/superset/commit/33d1c967649890500fb788678e8a10afc08bc99a))
- **helm:** support different replicaCount ([#20883](https://github.com/apache/superset/issues/20883)) ([8e0f16f](https://github.com/apache/superset/commit/8e0f16fade43ac0e819fff1d64273eb003ad675d))
- **helm:** Support for flower and websocket containers ([#21806](https://github.com/apache/superset/issues/21806)) ([06da7bf](https://github.com/apache/superset/commit/06da7bf65c5d7aaa2247faf826fa9e46653e82ad))
- helper functions for RLS ([#19055](https://github.com/apache/superset/issues/19055)) ([8234395](https://github.com/apache/superset/commit/8234395466d0edaead3c36b57fd0b81621cc1c5c))
- Hide nav create with RBAC ([#17157](https://github.com/apache/superset/issues/17157)) ([b5246b2](https://github.com/apache/superset/commit/b5246b29dfb5fe104674dac83996dada8031852a))
- Horizontal filter bar states ([#22064](https://github.com/apache/superset/issues/22064)) ([25114a7](https://github.com/apache/superset/commit/25114a7b97ca96341cdb2d5e6fceceddf6ebc3c4))
- implement ECharts pie chart ([#772](https://github.com/apache/superset/issues/772)) ([2169a0b](https://github.com/apache/superset/commit/2169a0b37e48b122d0babfb3f4242af362ecba72))
- Implement EmptyState components ([#18676](https://github.com/apache/superset/issues/18676)) ([a7d505d](https://github.com/apache/superset/commit/a7d505db4136d94ffd93c93c3f1a553c22f9081e))
- implement Filter dnd ([#978](https://github.com/apache/superset/issues/978)) ([b202007](https://github.com/apache/superset/commit/b2020076dac3d55d0007f2bd88630681f96d01d1))
- implement labelFlush behavior for continuous axes ([#117](https://github.com/apache/superset/issues/117)) ([c691415](https://github.com/apache/superset/commit/c691415702a61d8579c7c943f03b867d21570699))
- implement Metrics dnd ([#1004](https://github.com/apache/superset/issues/1004)) ([7c023cf](https://github.com/apache/superset/commit/7c023cfc87b77e10673daca37674fb783cfde22a))
- import external management columns ([#19315](https://github.com/apache/superset/issues/19315)) ([c7f9060](https://github.com/apache/superset/commit/c7f9060a2fcf84cc2b73af692b15c864676ed557))
- import theme colors ([#601](https://github.com/apache/superset/issues/601)) ([8cc4399](https://github.com/apache/superset/commit/8cc4399815dd432c7b9fe98413f63d81f22b3d37))
- import/export assets commands ([#19217](https://github.com/apache/superset/issues/19217)) ([51061f0](https://github.com/apache/superset/commit/51061f0d672abca29f84943acb16a37403f25c2e))
- improve adhoc SQL validation ([#19454](https://github.com/apache/superset/issues/19454)) ([6828624](https://github.com/apache/superset/commit/6828624f61fff21485b0b2e91ac53701d43cb0d7))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- improve line chart margin/axis and add buildquery ([#66](https://github.com/apache/superset/issues/66)) ([1f33026](https://github.com/apache/superset/commit/1f33026b380c34133ab75ecad84f5806245d8cf1))
- improve logic in is_select ([#17329](https://github.com/apache/superset/issues/17329)) ([93bafa0](https://github.com/apache/superset/commit/93bafa0e6ae02cef068419ac7d350d2446a1e82a))
- improve margin merging ([#159](https://github.com/apache/superset/issues/159)) ([aedc1b4](https://github.com/apache/superset/commit/aedc1b405d69a4c8b13e25264aac6b2014bb0b70))
- Improve state key generation for dashboards and charts ([#18576](https://github.com/apache/superset/issues/18576)) ([48a8095](https://github.com/apache/superset/commit/48a80950de06dee1d0af5b11b33401108395f04d))
- improve table performance ([#246](https://github.com/apache/superset/issues/246)) ([b785b20](https://github.com/apache/superset/commit/b785b20b970f8839c45781e99f4808718871268e))
- improve the tooltip for the time pivot chart ([#30](https://github.com/apache/superset/issues/30)) ([ec2c194](https://github.com/apache/superset/commit/ec2c1946c8be328a03be41cc117f86f4f95f6c6d))
- improve world map colors ([#711](https://github.com/apache/superset/issues/711)) ([4317795](https://github.com/apache/superset/commit/43177957ca3c319f957549e3d82344c1af80fba4))
- Improves key expiration handling in Explore ([#18624](https://github.com/apache/superset/issues/18624)) ([f03b4db](https://github.com/apache/superset/commit/f03b4dbedb29087c6958804aa803b5fb3200c7bb))
- Improves SafeMarkdown HTML sanitization ([#21895](https://github.com/apache/superset/issues/21895)) ([7d1df3b](https://github.com/apache/superset/commit/7d1df3b78d5d7147dd9d627317e3f9f10d279ae0))
- increment the version number ([#44](https://github.com/apache/superset/issues/44)) ([5a643dd](https://github.com/apache/superset/commit/5a643dd047408e36bdd9b39daacf718099092f0a))
- Increments charts endpoint with related dashboards ([#21518](https://github.com/apache/superset/issues/21518)) ([2ec744d](https://github.com/apache/superset/commit/2ec744da21c33c49cada569aaf3c5b5d9d7562f1))
- Integrate ant d table component into DatasetPanel ([#21948](https://github.com/apache/superset/issues/21948)) ([defe5c8](https://github.com/apache/superset/commit/defe5c8ba71851d6870985bbbc1c6c0650aa87b8))
- integrate line chart with build query and update typings ([#73](https://github.com/apache/superset/issues/73)) ([23c4aa3](https://github.com/apache/superset/commit/23c4aa3d1e4c0bc35ce07f7441d9f21bb06cb6e9))
- Introduce a library for embedded iframe <-> host communication ([#18652](https://github.com/apache/superset/issues/18652)) ([225015f](https://github.com/apache/superset/commit/225015fd5a94c1a92cc9b110e3e3db5cd532d47b))
- introduce hashids permalink keys ([#19324](https://github.com/apache/superset/issues/19324)) ([f4b71ab](https://github.com/apache/superset/commit/f4b71abb2279be4720e8a66999ace62b630fedf3))
- introduce shared modules logic ([#871](https://github.com/apache/superset/issues/871)) ([e794063](https://github.com/apache/superset/commit/e794063a3a5f361d92da7d7933b9b19c95ee1c8e))
- **key-value:** add superset metastore cache ([#19232](https://github.com/apache/superset/issues/19232)) ([72b9a7f](https://github.com/apache/superset/commit/72b9a7fa5b1a0c1d5f9769778280b32501356570))
- **legacy-plugin-chart-big-number:** add control panel config for the BigNumber charts ([#419](https://github.com/apache/superset/issues/419)) ([9c2495c](https://github.com/apache/superset/commit/9c2495c03ca6df4f3bd5e5b98ce7a71eeeba18bf))
- **legacy-plugin-chart-calendar:** increase the contrast of calendar heatmap color and label ([#1452](https://github.com/apache/superset/issues/1452)) ([a71d3ca](https://github.com/apache/superset/commit/a71d3caa6c095e92abb42c77c557a7e27ffb82f8))
- **legacy-plugin-chart-chord:** control panel ([#481](https://github.com/apache/superset/issues/481)) ([d76cd6b](https://github.com/apache/superset/commit/d76cd6b46e86a17e24fd93620211b623b104cc35))
- **legacy-plugin-chart-country-map:** add Australia geojson file ([#1268](https://github.com/apache/superset/issues/1268)) ([f0b5398](https://github.com/apache/superset/commit/f0b53989d070cb06a677336965982ce1d252c22c))
- **legacy-plugin-chart-country-map:** add peru country map ([#1424](https://github.com/apache/superset/issues/1424)) ([e494f00](https://github.com/apache/superset/commit/e494f0065c8f9b452ae9b9776b31c95530e7ed77))
- **legacy-plugin-chart-country-map:** add six new maps ([#1327](https://github.com/apache/superset/issues/1327)) ([884b8ec](https://github.com/apache/superset/commit/884b8ec098a664a259e1aa383698e007ca97dfa5))
- **legacy-plugin-chart-country-map:** Add Slovenia map ([#1054](https://github.com/apache/superset/issues/1054)) ([8295e7a](https://github.com/apache/superset/commit/8295e7a428c3094395479cdcc6be639b684f0314))
- **legacy-plugin-chart-country-map:** add Switzerland to country map chart ([#260](https://github.com/apache/superset/issues/260)) ([bdf5a60](https://github.com/apache/superset/commit/bdf5a601aeb9d7554a9da51c01cbc5c1b9f84a7d))
- **legacy-plugin-chart-country-map:** Add Uruguay map ([#944](https://github.com/apache/superset/issues/944)) ([af68270](https://github.com/apache/superset/commit/af6827018df906c8ef9ab2784caa66a95792b424))
- **legacy-plugin-chart-country-map:** add Vietnam map ([#1334](https://github.com/apache/superset/issues/1334)) ([d237bb6](https://github.com/apache/superset/commit/d237bb6e074d392cb903e44bea6e34b5d45d10fe))
- **legacy-plugin-chart-country-map:** added finland map ([#1258](https://github.com/apache/superset/issues/1258)) ([e693381](https://github.com/apache/superset/commit/e69338102931aad86b3ed5368ff5656aac8a7e89))
- **legacy-plugin-chart-country-map:** added indonesia map ([#1088](https://github.com/apache/superset/issues/1088)) ([ac7dfad](https://github.com/apache/superset/commit/ac7dfada0e00e83807fee831cb8c08c71433706f))
- **legacy-plugin-chart-country-map:** migrate and replace india map ([#376](https://github.com/apache/superset/issues/376)) ([8dd02b3](https://github.com/apache/superset/commit/8dd02b36339462e1c0ac3885929d31f419d00f69))
- **legacy-plugin-chart-event-flow:** control panel ([#501](https://github.com/apache/superset/issues/501)) ([53e8a4f](https://github.com/apache/superset/commit/53e8a4ff5b959442c5b3faeb03ac1ebcf525379a))
- **legacy-plugin-chart-event-flow:** migrate package ([#514](https://github.com/apache/superset/issues/514)) ([ae6a1bb](https://github.com/apache/superset/commit/ae6a1bbefb8e420cf04408408bc42cc6c35a39d2))
- **legacy-plugin-chart-force-directed:** control panel ([#502](https://github.com/apache/superset/issues/502)) ([081e223](https://github.com/apache/superset/commit/081e2237f8efdb35366627451bc01b55f632fb0d))
- **legacy-plugin-chart-heatmap:** control panel ([#503](https://github.com/apache/superset/issues/503)) ([aee724b](https://github.com/apache/superset/commit/aee724b1ad29beb4b024fb8f74dba6afe9921638))
- **legacy-plugin-chart-histogram:** control panel ([#504](https://github.com/apache/superset/issues/504)) ([6e4dd8e](https://github.com/apache/superset/commit/6e4dd8ef1959d2f85ce677c17392144068bee7d3))
- **legacy-plugin-chart-histogram:** cumulative histogram option ([#1381](https://github.com/apache/superset/issues/1381)) ([98e2f74](https://github.com/apache/superset/commit/98e2f744b32550a1ff75a943365e4b36b8bcfd52))
- **legacy-plugin-chart-histogram:** subject Add legend option to histogram chart ([#905](https://github.com/apache/superset/issues/905)) ([f059610](https://github.com/apache/superset/commit/f0596103a86ec6a2d8496cdd526039674569c708))
- **legacy-plugin-chart-horizon:** control panel ([#505](https://github.com/apache/superset/issues/505)) ([39655ff](https://github.com/apache/superset/commit/39655ff1b208e6647da06aa24010c197c070c824))
- **legacy-plugin-chart-iframe:** control panel ([#506](https://github.com/apache/superset/issues/506)) ([ffb9e87](https://github.com/apache/superset/commit/ffb9e8718f1d080ef1db76da48add62855a00429))
- **legacy-plugin-chart-map-box:** control panel ([#507](https://github.com/apache/superset/issues/507)) ([2cd7891](https://github.com/apache/superset/commit/2cd7891c9af3df238447c77dee4af663c074e6dd))
- **legacy-plugin-chart-map-box:** show all points in mapbox chart ([#960](https://github.com/apache/superset/issues/960)) ([978af22](https://github.com/apache/superset/commit/978af22b3e405d54237428ef79753e947ad1917c))
- **legacy-plugin-chart-markup:** add controls to markup chart ([#479](https://github.com/apache/superset/issues/479)) ([66fea8c](https://github.com/apache/superset/commit/66fea8c66b0c89a5f0ce1ba5ab42ed0d578eed08))
- **legacy-plugin-chart-nvd3:** add control panels ([#469](https://github.com/apache/superset/issues/469)) ([8281ac9](https://github.com/apache/superset/commit/8281ac92fa155aff1bda66674ee78e47c8fa5bd4))
- **legacy-plugin-chart-parallel-coordinates:** add control panels ([#510](https://github.com/apache/superset/issues/510)) ([27bc742](https://github.com/apache/superset/commit/27bc742547ee889625795643af006a65f75cbf4c))
- **legacy-plugin-chart-partition:** add control panel ([#470](https://github.com/apache/superset/issues/470)) ([8f5fb6a](https://github.com/apache/superset/commit/8f5fb6a6042ee598128cc37208b4fa4a1fb4aab9))
- **legacy-plugin-chart-pivot-table:** add support for timestamp format ([#734](https://github.com/apache/superset/issues/734)) ([baf2b68](https://github.com/apache/superset/commit/baf2b68356519c7f6b8ad7224e53bbd73bc72796))
- **legacy-plugin-chart-rose:** add time grain ([#696](https://github.com/apache/superset/issues/696)) ([79c4f3f](https://github.com/apache/superset/commit/79c4f3f2ab9496a2bb1bc09e18dbe915221ff7d7))
- **legacy-plugin-chart-sankey:** allow sort by metric ([#831](https://github.com/apache/superset/issues/831)) ([5f5e275](https://github.com/apache/superset/commit/5f5e27527990335acf8a6c6084e54bea7408bdd6))
- **legacy-plugin-chart-sunburst:** add linear color scheme ([#714](https://github.com/apache/superset/issues/714)) ([5908582](https://github.com/apache/superset/commit/5908582d00a056e62f78868a8cbf40fefff6af42))
- **legacy-preset-big-number:** use emotion styling ([#455](https://github.com/apache/superset/issues/455)) ([b6931fb](https://github.com/apache/superset/commit/b6931fbcd6b662b0bacd3c380eb2ecb0aa5996ab))
- **legacy-preset-chart-big-number:** add timestamp above number ([#1278](https://github.com/apache/superset/issues/1278)) ([c4bc66a](https://github.com/apache/superset/commit/c4bc66a1bf40fa3c8a9c9cccd43d49508c1d7a35))
- **legacy-preset-chart-deckgl:** Add ,.1f and ,.2f value formats to deckgl charts ([#18945](https://github.com/apache/superset/issues/18945)) ([c56dc8e](https://github.com/apache/superset/commit/c56dc8eace6a71b45240d1bb6768d75661052a2e))
- **legacy-preset-chart-nvd3:** add a new label type to pie chart ([#699](https://github.com/apache/superset/issues/699)) ([d9a2808](https://github.com/apache/superset/commit/d9a2808fe31b2f55bea9d01204371f9aca43384e))
- **legacy-preset-chart-nvd3:** add richtooltip in nvd3 bar chart ([#17615](https://github.com/apache/superset/issues/17615)) ([72f3215](https://github.com/apache/superset/commit/72f3215ffc74ead33dba57196aeaf4e1db63fd6c))
- **legacy-preset-chart-nvd3:** show negative values on bars ([#8](https://github.com/apache/superset/issues/8)) ([53ab714](https://github.com/apache/superset/commit/53ab7147cf7dfdf59323eaad45ebae0a91cd3274))
- **legacy-preset-chart-nvd3:** subject Add legend option to nvd3 chart ([#904](https://github.com/apache/superset/issues/904)) ([d02f17c](https://github.com/apache/superset/commit/d02f17c098e69af00e13aa144909ecb7c9e61356))
- **legacy-preset-chart-nvd3:** subject Add Y bounds for nvd3 charts ([#908](https://github.com/apache/superset/issues/908)) ([d58984a](https://github.com/apache/superset/commit/d58984aeb60257845f17e851bf782985ee8c0240))
- **legacy-preset-chart-nvd3:** subject NVD3 Bar chart sort by ([#947](https://github.com/apache/superset/issues/947)) ([afa98bf](https://github.com/apache/superset/commit/afa98bf41e1eb5a8495ccf18779b0c1eef689cff))
- **legacy-table-chart:** add query mode switch ([#609](https://github.com/apache/superset/issues/609)) ([aade5ef](https://github.com/apache/superset/commit/aade5ef42c1a8e0896bcb4c1aa5f60bb411f83c7))
- **legacy-time-table:** add time table to storybook ([#680](https://github.com/apache/superset/issues/680)) ([4b6aa11](https://github.com/apache/superset/commit/4b6aa112ba6ebb9bc08420a1aff43a5b38e72581))
- line chart with revised encodeable utilities ([#26](https://github.com/apache/superset/issues/26)) ([049b40b](https://github.com/apache/superset/commit/049b40bc80e71728227177d7a97589db3058e015))
- linear imputation in Resample ([#19393](https://github.com/apache/superset/issues/19393)) ([a39dd44](https://github.com/apache/superset/commit/a39dd4493e8b40cc142451bc71e4d1d4f2705d3f))
- **linting:** restrict direct use of supersetTheme in favor of ThemeProvider ([#17001](https://github.com/apache/superset/issues/17001)) ([5f73ca8](https://github.com/apache/superset/commit/5f73ca85d5c7b0ba34eae251addbc77fd7bdec61))
- log decorator util - adding automatic logs out of the box ([#18620](https://github.com/apache/superset/issues/18620)) ([41f3c95](https://github.com/apache/superset/commit/41f3c9534518f032ab71522d33508b923eeae1d7))
- logger supports console.table, with console.log fallback ([#738](https://github.com/apache/superset/issues/738)) ([86eedab](https://github.com/apache/superset/commit/86eedab4d0d33bfa6ee37db3cd72dfec28f28208))
- make all deckgl charts handle their own tooltips ([#13](https://github.com/apache/superset/issues/13)) ([8fbeba1](https://github.com/apache/superset/commit/8fbeba101c9563c3c209f881e1cdf3bfb3af3e89))
- make CategoricalScale compatible with D3 ScaleOrdinal ([#357](https://github.com/apache/superset/issues/357)) ([735e8b2](https://github.com/apache/superset/commit/735e8b2dd60ec9ee0f74c857485faea8fee585d4))
- make CTA text in Alerts & Reports mails configurable ([#19779](https://github.com/apache/superset/issues/19779)) ([0b22287](https://github.com/apache/superset/commit/0b22287ad9f3908ce62f51e2a17de8975beafed2))
- Make filters and dividers display horizontally in horizontal native filters filter bar ([#22169](https://github.com/apache/superset/issues/22169)) ([64939f2](https://github.com/apache/superset/commit/64939f2872a16b708d315693f9f9810604788aff))
- make formatTime and formatNumber handle undefined format ([#307](https://github.com/apache/superset/issues/307)) ([83a1901](https://github.com/apache/superset/commit/83a1901a355d8150f9e84e7c8cc66a339993b35d))
- make GET request work for fetchExploreJson, closes [#668](https://github.com/apache/superset/issues/668) ([#777](https://github.com/apache/superset/issues/777)) ([6ac6880](https://github.com/apache/superset/commit/6ac6880fd9532d361d221925c6bd45d25f6e14b9))
- Make Jinja template applied in timestamp columns ([#17237](https://github.com/apache/superset/issues/17237)) ([5aaa333](https://github.com/apache/superset/commit/5aaa3330a66c90047da3dcc557970cf9383d4933))
- make polygon support geojson feature and fix autozoom ([#11](https://github.com/apache/superset/issues/11)) ([940e449](https://github.com/apache/superset/commit/940e449bbe8fff732dd14f8ac86d8e535da0123a))
- make time formatter handle number and fix formatters type warnings ([#358](https://github.com/apache/superset/issues/358)) ([aa84115](https://github.com/apache/superset/commit/aa84115ca48edf45f1a6bffb29d5c09268d5d133))
- Making bar graphs in Table viz from fixed-size divs instead of calculated gradients ([#21482](https://github.com/apache/superset/issues/21482)) ([135909f](https://github.com/apache/superset/commit/135909f814e989c2314ddbb5da90e5364cd36d17))
- **metrics:** Provide override for disabling ad-hoc metrics ([#17202](https://github.com/apache/superset/issues/17202)) ([561d1ac](https://github.com/apache/superset/commit/561d1ac9f2f3861619e319cf69befb57d6559485))
- migrate chart plugins ([#375](https://github.com/apache/superset/issues/375)) ([81ca3b9](https://github.com/apache/superset/commit/81ca3b980188f14f08c9eea7b16dbaccc7b11095))
- migrate heatmap, horizon, iframe and markup ([#367](https://github.com/apache/superset/issues/367)) ([12bf14b](https://github.com/apache/superset/commit/12bf14b7cd1ae5321ffed724867a4233197dd44c))
- migrate legacy-plugin-chart-chord ([#365](https://github.com/apache/superset/issues/365)) ([d36b36e](https://github.com/apache/superset/commit/d36b36ecfc280f8650734e22c0847c5b05623b51))
- migrate xy-chart to use encodable ([#438](https://github.com/apache/superset/issues/438)) ([493df5c](https://github.com/apache/superset/commit/493df5c8088ad5f863427c757b9d6437d98266b9)), closes [#420](https://github.com/apache/superset/issues/420) [#421](https://github.com/apache/superset/issues/421) [#427](https://github.com/apache/superset/issues/427) [#430](https://github.com/apache/superset/issues/430) [#432](https://github.com/apache/superset/issues/432) [#433](https://github.com/apache/superset/issues/433) [#436](https://github.com/apache/superset/issues/436)
- Move cross filters to Dashboard ([#22785](https://github.com/apache/superset/issues/22785)) ([9ed2326](https://github.com/apache/superset/commit/9ed2326a20329d41abc8e0995b0ba6110379088f))
- Move Database Import option into DB Connection modal ([#19314](https://github.com/apache/superset/issues/19314)) ([d52e386](https://github.com/apache/superset/commit/d52e3867acbcb1d31d1e7f6c1215123f91f9f313))
- multiple results pane on explore and dashboard ([#20277](https://github.com/apache/superset/issues/20277)) ([fd12987](https://github.com/apache/superset/commit/fd129873ceeb74dc2e59d9b94ed1c9d006f1386c))
- native filter components ([#840](https://github.com/apache/superset/issues/840)) ([a52cd69](https://github.com/apache/superset/commit/a52cd691f0404169c5e687f4181c0de93c5987a7))
- **native_filter_migration:** add transition mode ([#16992](https://github.com/apache/superset/issues/16992)) ([7d22c9c](https://github.com/apache/superset/commit/7d22c9ce170d0bd6ad31c680d007881b61dd378f))
- **native-filters:** add AppSection type ([#1038](https://github.com/apache/superset/issues/1038)) ([05bd319](https://github.com/apache/superset/commit/05bd319e2773fcf703216234899b3a610f4d1abd))
- **native-filters:** Adjust filter components for horizontal mode ([#22273](https://github.com/apache/superset/issues/22273)) ([eb6045a](https://github.com/apache/superset/commit/eb6045adfa77e06c8aaf3de217719ca59d4328e1))
- **native-filters:** Don't scroll main window when scrolling filter bar ([#18876](https://github.com/apache/superset/issues/18876)) ([e5c7478](https://github.com/apache/superset/commit/e5c74780268c78355e21bc0f7af0069a59bed41e))
- **native-filters:** Implement filter cards ([#18874](https://github.com/apache/superset/issues/18874)) ([0922c3f](https://github.com/apache/superset/commit/0922c3ff2dd79e68e633ea5fe1c17fa16307fd8a))
- **native-filters:** Re-arrange controls in FilterBar ([#18784](https://github.com/apache/superset/issues/18784)) ([9d5c050](https://github.com/apache/superset/commit/9d5c0505cf9bf67be499abd4829195adf6ad17d5))
- **nav:** Update Tabbed Nav on CRUD Pages ([#21213](https://github.com/apache/superset/issues/21213)) ([fb835d1](https://github.com/apache/superset/commit/fb835d143705a94ca229c651a4c7f7dbc1675ed2))
- new config to filter specific users from dropdown lists ([#21515](https://github.com/apache/superset/issues/21515)) ([ab7cfec](https://github.com/apache/superset/commit/ab7cfec975b3f06eb386e14532d42bc6a02a0687))
- new dataset/table/column models ([#17543](https://github.com/apache/superset/issues/17543)) ([00c99c9](https://github.com/apache/superset/commit/00c99c91ec302a13978c5fd3a1099d6f4648a20e))
- New time range label ([#22317](https://github.com/apache/superset/issues/22317)) ([2d30e9c](https://github.com/apache/superset/commit/2d30e9cbe9e22fe5e09ca9f06e68c8563d9c741a))
- Normalize orderby clause ([#1206](https://github.com/apache/superset/issues/1206)) ([e96428e](https://github.com/apache/superset/commit/e96428e6c8fce496e3e601dfe05498e6b42ae464))
- **number-format:** bump pretty-ms to 5.1.0 ([#262](https://github.com/apache/superset/issues/262)) ([7212d12](https://github.com/apache/superset/commit/7212d1240b038ad3c2b3065a77ce6d9de9ffe009))
- On window focus, redirect to login if the user has been logged out ([#18773](https://github.com/apache/superset/issues/18773)) ([da3bc48](https://github.com/apache/superset/commit/da3bc48803e2653be127f948e259a762fa0f9718))
- only show active user for chart/dashboard/datasource owner drop… ([#20837](https://github.com/apache/superset/issues/20837)) ([9be4870](https://github.com/apache/superset/commit/9be4870c7f855f086671f281875d165fe27d8d13))
- optimize functions for getting text dimension ([#199](https://github.com/apache/superset/issues/199)) ([77e7a53](https://github.com/apache/superset/commit/77e7a5319ac59b55083d6d1498ede1f96ec215a2))
- Pass dashboard context to explore through local storage ([#20743](https://github.com/apache/superset/issues/20743)) ([0945d4a](https://github.com/apache/superset/commit/0945d4a2f46667aebb9b93d0d7685215627ad237))
- per-db add metrics ([#20990](https://github.com/apache/superset/issues/20990)) ([bb3871d](https://github.com/apache/superset/commit/bb3871ddaf8835c67d9cb498a2ca99a9a48a1ec3))
- Persist SQL Lab autocomplete setting across tabs and visits ([#17708](https://github.com/apache/superset/issues/17708)) ([5b0aa27](https://github.com/apache/superset/commit/5b0aa27f2bb3e9570241500132b9e09f9dd1f5a3))
- **plugin-chart-boxplot:** add control panel ([#464](https://github.com/apache/superset/issues/464)) ([dc3f219](https://github.com/apache/superset/commit/dc3f2198484b44877687ecd2083c2c0ab096090d))
- **plugin-chart-choropleth-map:** add package ([#560](https://github.com/apache/superset/issues/560)) ([72c2b7a](https://github.com/apache/superset/commit/72c2b7afc06810813ee4e179aabe4db8e78b4cdb)), closes [#527](https://github.com/apache/superset/issues/527) [#529](https://github.com/apache/superset/issues/529) [#528](https://github.com/apache/superset/issues/528) [#541](https://github.com/apache/superset/issues/541) [#548](https://github.com/apache/superset/issues/548)
- **plugin-chart-echart:** New Tree chart ([#1018](https://github.com/apache/superset/issues/1018)) ([d1312ab](https://github.com/apache/superset/commit/d1312ab2a8d6c09579aa5302962527af1d84521f))
- **plugin-chart-echarts:** [feature-parity] support double clicking legend and series to view single selected series ([#1324](https://github.com/apache/superset/issues/1324)) ([ff8979b](https://github.com/apache/superset/commit/ff8979b46e5a2c59baa367a67b8c79406274f9f0))
- **plugin-chart-echarts:** [feature-parity] support extra control for the area chart V2 ([#16493](https://github.com/apache/superset/issues/16493)) ([eab0009](https://github.com/apache/superset/commit/eab0009101a295acf4d8d31df8a57f8fe0deb517))
- **plugin-chart-echarts:** able to sort bar on the bar chart V2 ([#21356](https://github.com/apache/superset/issues/21356)) ([59437ea](https://github.com/apache/superset/commit/59437ea6e7ec02267c6e03e174be39a6cae48893))
- **plugin-chart-echarts:** add aggregate total for the Pie/Donuct chart ([#19622](https://github.com/apache/superset/issues/19622)) ([a6bf041](https://github.com/apache/superset/commit/a6bf041eddcde0247461f35c806414df00ef105e))
- **plugin-chart-echarts:** add BoxPlot chart ([#801](https://github.com/apache/superset/issues/801)) ([88acb6b](https://github.com/apache/superset/commit/88acb6ba9d6e8ef948d90d97f514047599cf3735))
- **plugin-chart-echarts:** Add cross filter for timeseries ([#1016](https://github.com/apache/superset/issues/1016)) ([9fdc8c3](https://github.com/apache/superset/commit/9fdc8c3f6e73e0becdbcb42b12c19735b7a06ad2))
- **plugin-chart-echarts:** add graph echart ([#918](https://github.com/apache/superset/issues/918)) ([d47f6ce](https://github.com/apache/superset/commit/d47f6ceeae906fefe9db6d53105f121cb4e534d4))
- **plugin-chart-echarts:** add label date format for piechart and boxplot ([#973](https://github.com/apache/superset/issues/973)) ([1c40ac5](https://github.com/apache/superset/commit/1c40ac56c7d3031f82bcc0cc97a0ec9fb9992c99))
- **plugin-chart-echarts:** add legend customization options ([#833](https://github.com/apache/superset/issues/833)) ([54948a0](https://github.com/apache/superset/commit/54948a091d95e30c2193207f30bce5e03f985ece))
- **plugin-chart-echarts:** add mixed timeseries chart ([#1027](https://github.com/apache/superset/issues/1027)) ([7670a90](https://github.com/apache/superset/commit/7670a90836429394163e5d7da56f28fe8ed07642))
- **plugin-chart-echarts:** add more robust formatting for series ([#783](https://github.com/apache/superset/issues/783)) ([66e681c](https://github.com/apache/superset/commit/66e681cbab57ef41ca90639caa14530ac9396453))
- **plugin-chart-echarts:** add only_total control to ts chart ([#1313](https://github.com/apache/superset/issues/1313)) ([471f245](https://github.com/apache/superset/commit/471f2451819564537f20d472031fdfcebe92e549))
- **plugin-chart-echarts:** add orderby on Radar chart ([#1112](https://github.com/apache/superset/issues/1112)) ([32ebeff](https://github.com/apache/superset/commit/32ebeff93b3c998b45a7469f846361ffe5fea6bd))
- **plugin-chart-echarts:** add support for custom forecasts ([#1389](https://github.com/apache/superset/issues/1389)) ([f1613fd](https://github.com/apache/superset/commit/f1613fd17e2115c45c494b1cb237de53bfccb2d3))
- **plugin-chart-echarts:** add support for formula annotations ([#817](https://github.com/apache/superset/issues/817)) ([06ef549](https://github.com/apache/superset/commit/06ef5491223bb531afe736756a864aba7aad23f6))
- **plugin-chart-echarts:** add support for generic axis to mixed chart ([#20097](https://github.com/apache/superset/issues/20097)) ([d5c5e58](https://github.com/apache/superset/commit/d5c5e58583771a35d8870ce3694b2a3f1b688159))
- **plugin-chart-echarts:** Add support for series values to ECharts timeseries charts ([#1279](https://github.com/apache/superset/issues/1279)) ([f68d465](https://github.com/apache/superset/commit/f68d46525970975de76e69c8f5a740adf631335c))
- **plugin-chart-echarts:** add x and y label support for 9 charts ([#1351](https://github.com/apache/superset/issues/1351)) ([e149c53](https://github.com/apache/superset/commit/e149c537ee0c547dc3a8fa6a3b14222ee81d8c77)), closes [#16512](https://github.com/apache/superset/issues/16512)
- **plugin-chart-echarts:** add x-filtering in gauge chart ([#1203](https://github.com/apache/superset/issues/1203)) ([4333a68](https://github.com/apache/superset/commit/4333a683f0eb9b62c4025c88e3fede16655d186a))
- **plugin-chart-echarts:** add x-filtering to treemap ([#1115](https://github.com/apache/superset/issues/1115)) ([3d3c873](https://github.com/apache/superset/commit/3d3c873f3cfee2def4db08af55087b4c5d2df16e))
- **plugin-chart-echarts:** Add xAxis label format && showMin and showMax labels ([#894](https://github.com/apache/superset/issues/894)) ([bee49e7](https://github.com/apache/superset/commit/bee49e7d4bdaa5b6973883b7428b3a6ec352fc80))
- **plugin-chart-echarts:** arrange legend and zoom ([#920](https://github.com/apache/superset/issues/920)) ([d142881](https://github.com/apache/superset/commit/d142881fc99b171900d4bd4fee7fe1f53393bddc))
- **plugin-chart-echarts:** bump to version 5.0 ([#852](https://github.com/apache/superset/issues/852)) ([8c4c4ef](https://github.com/apache/superset/commit/8c4c4ef0206eac06a3c9d9b2a17e88723c186937)), closes [#11854](https://github.com/apache/superset/issues/11854)
- **plugin-chart-echarts:** create separate entry points for timeseries (2nd) ([#1262](https://github.com/apache/superset/issues/1262)) ([7441009](https://github.com/apache/superset/commit/74410090986867b9e3e895954725d24783fdfd84))
- **plugin-chart-echarts:** crossfilter with single selection in the funnel chart ([#1211](https://github.com/apache/superset/issues/1211)) ([178986a](https://github.com/apache/superset/commit/178986a5fa85ccec1a21803df6339747736f8651))
- **plugin-chart-echarts:** echarts funnel chart ([#1006](https://github.com/apache/superset/issues/1006)) ([639c8ba](https://github.com/apache/superset/commit/639c8bac7425f962c9b2eb5176e0ddf771541d6a))
- **plugin-chart-echarts:** Echarts Treemap ([#1094](https://github.com/apache/superset/issues/1094)) ([012e5dc](https://github.com/apache/superset/commit/012e5dcbc0b536e66537ee5dd0982262ad4cdea3))
- **plugin-chart-echarts:** Emit cross filters for pie and boxplot ([#1010](https://github.com/apache/superset/issues/1010)) ([acd23f3](https://github.com/apache/superset/commit/acd23f3ba36cebc8785bddd66218979d39d39c6e))
- **plugin-chart-echarts:** Enhancements of treemap tooltip ([#1103](https://github.com/apache/superset/issues/1103)) ([2fa01f7](https://github.com/apache/superset/commit/2fa01f7975455bada71845b29002e3769c028134))
- **plugin-chart-echarts:** hide/show dependent controls ([#1097](https://github.com/apache/superset/issues/1097)) ([902fcf4](https://github.com/apache/superset/commit/902fcf42ce73db53fb4af287144318e2b4b5b6be))
- **plugin-chart-echarts:** implement cross filter in mixd-timeseries chart ([#1256](https://github.com/apache/superset/issues/1256)) ([e54ae04](https://github.com/apache/superset/commit/e54ae04906f16d4d1b1c4c995713ae07383b3c50))
- **plugin-chart-echarts:** implement event interval and timeseries annotations ([#828](https://github.com/apache/superset/issues/828)) ([8bfaf4e](https://github.com/apache/superset/commit/8bfaf4eb0ecaad0cd83132132b1ef41b4299b791))
- **plugin-chart-echarts:** implement x-filter opacity in ts chart ([#1244](https://github.com/apache/superset/issues/1244)) ([5bff9a4](https://github.com/apache/superset/commit/5bff9a4dd0c55c9f35741f50041412ad7698622d))
- **plugin-chart-echarts:** make groupby optional ([#820](https://github.com/apache/superset/issues/820)) ([387c863](https://github.com/apache/superset/commit/387c863682337a0fa4be7c499e9b0b6a952e3b59))
- **plugin-chart-echarts:** Radar chart POC ([#1029](https://github.com/apache/superset/issues/1029)) ([18b1ef0](https://github.com/apache/superset/commit/18b1ef008daafdd559a4b624ebd63cb3c4a91165))
- **plugin-chart-echarts:** remove loading from timeseries tooltip ([#787](https://github.com/apache/superset/issues/787)) ([e918c04](https://github.com/apache/superset/commit/e918c04090bcd97ce1068d86ddcafba05da6cf4f))
- **plugin-chart-echarts:** rich tooltip in ts chart supports scroll and highlighted ([#1304](https://github.com/apache/superset/issues/1304)) ([10238c3](https://github.com/apache/superset/commit/10238c38057d87849bf01c6e19c8c576beab5d9d))
- **plugin-chart-echarts:** single select by default for pie chart ([#1204](https://github.com/apache/superset/issues/1204)) ([4c6017e](https://github.com/apache/superset/commit/4c6017eaa4506a20d28f3c5103fc6768c182296a))
- **plugin-chart-echarts:** sort by metric checkbox check by default ([#1111](https://github.com/apache/superset/issues/1111)) ([f73b9a4](https://github.com/apache/superset/commit/f73b9a4cf83e95772c84188439c534629c57925c))
- **plugin-chart-echarts:** subject Add option to rotate label defaul 45 ([#921](https://github.com/apache/superset/issues/921)) ([df47d95](https://github.com/apache/superset/commit/df47d95f5ec2fd45dadff2bb60a3b6aff88dc27f))
- **plugin-chart-echarts:** subject Add rich tooltip ([#906](https://github.com/apache/superset/issues/906)) ([3f9a5d2](https://github.com/apache/superset/commit/3f9a5d26c26f253bcd8b3297afeba93334eb599c))
- **plugin-chart-echarts:** subject add sort by metric for Pie Chart ([#946](https://github.com/apache/superset/issues/946)) ([ab2e6f3](https://github.com/apache/superset/commit/ab2e6f31a5f6ad3feb95e89fee9bcdfd48ea3636))
- **plugin-chart-echarts:** subject Add time formatter on the tooltip title ([#912](https://github.com/apache/superset/issues/912)) ([2345e34](https://github.com/apache/superset/commit/2345e342cba46d273107f59e2290c10f852e2a53))
- **plugin-chart-echarts:** subject fix tooltip format title ([#956](https://github.com/apache/superset/issues/956)) ([f11f2eb](https://github.com/apache/superset/commit/f11f2eb4867f688ef9771002ffd1812d4062f02c))
- **plugin-chart-echarts:** subject Update echarts to v5.0.1 ([#928](https://github.com/apache/superset/issues/928)) ([d3d343d](https://github.com/apache/superset/commit/d3d343d6c48b4d3de61d21bf784e8c424f006c01))
- **plugin-chart-echarts:** support always show annotation label ([#1449](https://github.com/apache/superset/issues/1449)) ([259ff67](https://github.com/apache/superset/commit/259ff67ef78b56eb3403ee19559868ce2d8712b7))
- **plugin-chart-echarts:** support horizontal bar chart ([#19918](https://github.com/apache/superset/issues/19918)) ([9854d2d](https://github.com/apache/superset/commit/9854d2d0e8f849366b264353819c6fdf4b0d804d))
- **plugin-chart-echarts:** support non-timeseries x-axis ([#17917](https://github.com/apache/superset/issues/17917)) ([e9651ea](https://github.com/apache/superset/commit/e9651ea52fdc0edb574bfb9dc1b22c225bcc068f)), closes [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037)
- **plugin-chart-echarts:** Support stacking negative and positive values ([#20408](https://github.com/apache/superset/issues/20408)) ([c959d92](https://github.com/apache/superset/commit/c959d92dd17499e3fb7a0f4f02f3781516f3d3e6))
- **plugin-chart-echarts:** supports sunburst chart v2 [WIP] ([#21625](https://github.com/apache/superset/issues/21625)) ([b53941f](https://github.com/apache/superset/commit/b53941fb3eef7ab3936a0a3f16e22c921d946f53))
- **plugin-chart-echarts:** Treemap improvements ([#1125](https://github.com/apache/superset/issues/1125)) ([78c915c](https://github.com/apache/superset/commit/78c915c46441ba2027895d31115bed5484e1c823))
- **plugin-chart-echarts:** x-filtering improvement in radar chart ([#1205](https://github.com/apache/superset/issues/1205)) ([6d52c44](https://github.com/apache/superset/commit/6d52c44ab7438c674a982d7140b861d164a61fd9))
- **plugin-chart-graph:** add node/edge size and edge symbol control ([#1084](https://github.com/apache/superset/issues/1084)) ([8531910](https://github.com/apache/superset/commit/85319109a5a40de5b61978f5d1fd78c798b74137))
- **plugin-chart-pivot-table:** add automatic conditional formatter ([#1264](https://github.com/apache/superset/issues/1264)) ([a109dc2](https://github.com/apache/superset/commit/a109dc2313820c366adddf8fe275d69805511e48))
- **plugin-chart-pivot-table:** add sort by result to data pane ([#1243](https://github.com/apache/superset/issues/1243)) ([5a235ca](https://github.com/apache/superset/commit/5a235ca676aa2ade461975b6c2a19c984b635d1d))
- **plugin-chart-pivot-table:** column, date and conditional formatting ([#1217](https://github.com/apache/superset/issues/1217)) ([fe5f9b0](https://github.com/apache/superset/commit/fe5f9b093e1bddba0366501c19ff49f0b817d1f5))
- **plugin-chart-pivot-table:** enable cross filtering ([#1083](https://github.com/apache/superset/issues/1083)) ([139a067](https://github.com/apache/superset/commit/139a067c66e19afc9f56f465071ad30155f3ef61))
- **plugin-chart-pivot-table:** enable metrics to be used as row groups ([#1172](https://github.com/apache/superset/issues/1172)) ([cb5e908](https://github.com/apache/superset/commit/cb5e9084aae84b1289944e7d2e460812733fbb43))
- **plugin-chart-pivot-table:** implement barchart highlight ([#1089](https://github.com/apache/superset/issues/1089)) ([bce9e39](https://github.com/apache/superset/commit/bce9e39f814824328a3490a2f6ffb5b5efdf2474))
- **plugin-chart-pivot-table:** multiple improvements ([#1232](https://github.com/apache/superset/issues/1232)) ([0433df8](https://github.com/apache/superset/commit/0433df8e423b68e47e2e772d8b4226abe2592d4f))
- **plugin-chart-pivot-table:** sort by metric ([#1240](https://github.com/apache/superset/issues/1240)) ([8d54c69](https://github.com/apache/superset/commit/8d54c69e57dc8877da522318372e327d60010974))
- **plugin-chart-pivot-table:** support series limit ([#17803](https://github.com/apache/superset/issues/17803)) ([2c3f39f](https://github.com/apache/superset/commit/2c3f39f3f2a4369bf03403c452d124c24c521e7d))
- **plugin-chart-sunburst:** migrate control panel from incubator-superset ([#443](https://github.com/apache/superset/issues/443)) ([9d946f0](https://github.com/apache/superset/commit/9d946f0a04ad3eb64c99d1e0c988f38b53182ad0))
- **plugin-chart-table:** add column config control ([#1019](https://github.com/apache/superset/issues/1019)) ([a101117](https://github.com/apache/superset/commit/a101117f9e78527e90e73ed7dd5d419de3107961))
- **plugin-chart-table:** add small number formatter ([#1028](https://github.com/apache/superset/issues/1028)) ([090e3b1](https://github.com/apache/superset/commit/090e3b1e914af8c654069dcb2d4c302c89e2ae0f))
- **plugin-chart-table:** add support for temporal x-filter ([#1281](https://github.com/apache/superset/issues/1281)) ([7040050](https://github.com/apache/superset/commit/7040050cec865d5bea927f55f69e3bdafcbf67f6))
- **plugin-chart-table:** add tooltip about multiple sort ([#958](https://github.com/apache/superset/issues/958)) ([b5627c7](https://github.com/apache/superset/commit/b5627c73ea262653d97aa92ac51a4e25f6ca5910))
- **plugin-chart-table:** added emit target name ([#1157](https://github.com/apache/superset/issues/1157)) ([094f35f](https://github.com/apache/superset/commit/094f35fa0b4f3ef590e35dacad5bf634d594749a))
- **plugin-chart-table:** disable show_totals by default ([#1078](https://github.com/apache/superset/issues/1078)) ([08a0d0a](https://github.com/apache/superset/commit/08a0d0a324cad6ee9931d7a5ed6964d162b176b2))
- **plugin-chart-table:** enable emitting cross-filters ([#1041](https://github.com/apache/superset/issues/1041)) ([fcd11cd](https://github.com/apache/superset/commit/fcd11cde42b4c30be1f9cee2e3130675bfc80408))
- **plugin-chart-table:** implement conditional formatting ([#1218](https://github.com/apache/superset/issues/1218)) ([18e5ab2](https://github.com/apache/superset/commit/18e5ab2ccbf7283182486c1a27477906309d781e))
- **plugin-chart-table:** Implement showing totals ([#1034](https://github.com/apache/superset/issues/1034)) ([f4eeebf](https://github.com/apache/superset/commit/f4eeebf368c21ca88a5369394341014ccc9befb9))
- **plugin-chart-table:** rewrite with react-table ([#623](https://github.com/apache/superset/issues/623)) ([92ac471](https://github.com/apache/superset/commit/92ac4712163497482b3d4f1546a8061d9e78ff1d))
- **plugin-chart-table:** table x-filtering supports single select ([#1220](https://github.com/apache/superset/issues/1220)) ([631c867](https://github.com/apache/superset/commit/631c867c467f6cdcb350cf4e7d1caf2f4566ba80))
- **plugin-chart-treemap:** add control panel ([#461](https://github.com/apache/superset/issues/461)) ([07dc493](https://github.com/apache/superset/commit/07dc49366b27497ae7b94837d4a49512ebb61933))
- **plugin-chart-word-cloud:** add control panel ([#454](https://github.com/apache/superset/issues/454)) ([49f4044](https://github.com/apache/superset/commit/49f4044cbe93c2db855a176739d35630d6ede77a))
- **plugin-chart-word-cloud:** allow minimum size ([#487](https://github.com/apache/superset/issues/487)) ([3364f0f](https://github.com/apache/superset/commit/3364f0f6da9d4d832bda97d88216793b7998a732))
- **plugin-chart-word-cloud:** convert word cloud to use encodable ([#258](https://github.com/apache/superset/issues/258)) ([b6e3fdf](https://github.com/apache/superset/commit/b6e3fdffa649fbce48fc01e8bf98c6605524cc0d))
- **plugin-chart-word-cloud:** subject Add order by desc on metric ([#939](https://github.com/apache/superset/issues/939)) ([bf2a80c](https://github.com/apache/superset/commit/bf2a80ca7b884840c0870814738dc21762bfa1bc))
- **plugin-chart-world-map:** add control panel ([#462](https://github.com/apache/superset/issues/462)) ([3102d93](https://github.com/apache/superset/commit/3102d932834e55fc982e6643e85c80f9be4e66c2))
- **plugin-word-cloud:** change how wordcloud is exported ([#418](https://github.com/apache/superset/issues/418)) ([91d00ac](https://github.com/apache/superset/commit/91d00ac8b11298f759e12bf916723d04b91ce23c))
- **preset-chart-nvd3:** migration from plugins repo ([#399](https://github.com/apache/superset/issues/399)) ([587e6e1](https://github.com/apache/superset/commit/587e6e1a7739165b146ed84e8cf295f953be4c58))
- **preset-chart-xy:** migrate from plugins repo ([#377](https://github.com/apache/superset/issues/377)) ([afed1a0](https://github.com/apache/superset/commit/afed1a0818b56fe96c276c75d3dfbdf61e5644ee))
- print comment for chromatic storybook link ([#21170](https://github.com/apache/superset/issues/21170)) ([cda7d70](https://github.com/apache/superset/commit/cda7d705650fd36b7051c1002ab8f152017c9a70))
- Programmatically open "more filters" dropdown in Horizontal Filter Bar ([#22276](https://github.com/apache/superset/issues/22276)) ([df91664](https://github.com/apache/superset/commit/df91664217b5369d1f742ce03596a366e18cd4b9))
- properly translate the table chart ([#724](https://github.com/apache/superset/issues/724)) ([6def6b4](https://github.com/apache/superset/commit/6def6b4c0b01fafdc8c17156ba2ca7c566dbbe88))
- **prophet:** enable confidence intervals and y_hat without forecast ([#17658](https://github.com/apache/superset/issues/17658)) ([cd88b8e](https://github.com/apache/superset/commit/cd88b8e81ea3721f93d0cfdd0329f380a2c3d061))
- query datasets from SQL Lab ([#15241](https://github.com/apache/superset/issues/15241)) ([05a138a](https://github.com/apache/superset/commit/05a138a191cb0e22cf7b6b9cce6fa985843d1809))
- **query:** add `makeApi` API generator ([#666](https://github.com/apache/superset/issues/666)) ([18dfdd2](https://github.com/apache/superset/commit/18dfdd2a5a71c779d7488b815bf9102df6867037))
- **query:** Add force to QueryContext ([#445](https://github.com/apache/superset/issues/445)) ([4322d1c](https://github.com/apache/superset/commit/4322d1cd398e5f69e9ad0b43cf78804aeec41cd9))
- **query:** add functions to wrap api calls with typings ([#555](https://github.com/apache/superset/issues/555)) ([9a53bdf](https://github.com/apache/superset/commit/9a53bdfb681bdab00023df868a9944f1603acc1e))
- **query:** add more query wrappers ([#570](https://github.com/apache/superset/issues/570)) ([d277421](https://github.com/apache/superset/commit/d2774211240e547f1a08f693843dd5d75840fb5f))
- **query:** add new fields to QueryContext and QueryObject ([#583](https://github.com/apache/superset/issues/583)) ([9955156](https://github.com/apache/superset/commit/9955156265fca962fe79822e7443b701d70daa5a))
- **query:** remove redundant metric label truncation ([#492](https://github.com/apache/superset/issues/492)) ([dfb5ac4](https://github.com/apache/superset/commit/dfb5ac42ddec9c5d5d544f7c6797207ff7171d8a))
- **rbac:** add customizable related filters ([#22526](https://github.com/apache/superset/issues/22526)) ([037deb9](https://github.com/apache/superset/commit/037deb9a1d0170a7c10f9f47aad9474050fca31f))
- re-export types from @superset-ui/dimension ([#115](https://github.com/apache/superset/issues/115)) ([a98cde6](https://github.com/apache/superset/commit/a98cde6b3e6ddec97cdc06baa9513f892b053a42))
- refactor all `get_sqla_engine` to use contextmanager in codebase ([#21943](https://github.com/apache/superset/issues/21943)) ([e23efef](https://github.com/apache/superset/commit/e23efefc462fcc6f76a456f52f57f81e0c241a0a))
- remove children from XYChartLayout parameter ([28ef524](https://github.com/apache/superset/commit/28ef524596dd2b99c626c92eaec7947021e19248))
- Remove legacy sql alchemy db connection link from G Sheet connection ([#19450](https://github.com/apache/superset/issues/19450)) ([9407598](https://github.com/apache/superset/commit/94075983f8abfcc7749cede5af9e24d2a9f1abe0))
- remove loading indicator when typing in select ([#18799](https://github.com/apache/superset/issues/18799)) ([5a8eb09](https://github.com/apache/superset/commit/5a8eb09afba377375c1f92b9eec180d0e503edf2))
- remove the default Y-axis truncate in bar chart ([#1450](https://github.com/apache/superset/issues/1450)) ([4359ed0](https://github.com/apache/superset/commit/4359ed0e727057ea0ec039941406599d0c7ead33))
- **remove unused package:** remove corejs and other unused package ([7522f28](https://github.com/apache/superset/commit/7522f28ece0e481a3039dff6a3a6d684b0463313))
- Renders Explore in SPA ([#20572](https://github.com/apache/superset/issues/20572)) ([662bab1](https://github.com/apache/superset/commit/662bab1e6d1b502a77a117f8ab7e82d3029151c0))
- **report:** capture dashboard reports in specific states ([#20552](https://github.com/apache/superset/issues/20552)) ([4d192e6](https://github.com/apache/superset/commit/4d192e6e4d74157c1eb8fed63df7ddaee4c8ecf7))
- **reports:** execute as other than selenium user ([#21931](https://github.com/apache/superset/issues/21931)) ([a02a778](https://github.com/apache/superset/commit/a02a778cc3d0fdf2036884376b53b33444d15c03))
- responsive heatmap ([#989](https://github.com/apache/superset/issues/989)) ([e67064e](https://github.com/apache/superset/commit/e67064e9521680ce3da7857fcf25cd19c936cd32))
- Reuse Dashboard redux data in Explore ([#20668](https://github.com/apache/superset/issues/20668)) ([ff5b4bc](https://github.com/apache/superset/commit/ff5b4bc0e47f057e0660d453a9e53f939613356b))
- **rightmenu:** Add Datasets to + Menu and Hide Databases when one has been connected ([#21530](https://github.com/apache/superset/issues/21530)) ([c19708b](https://github.com/apache/superset/commit/c19708b4329b8239bbf2b34f02ece8c84001870b))
- RLS for SQL Lab ([#19999](https://github.com/apache/superset/issues/19999)) ([f2881e5](https://github.com/apache/superset/commit/f2881e5bbd6a3efbf3e9c1d62a60cee39c2fa028))
- **RLS:** RESTful apis and react view for RLS ([#22325](https://github.com/apache/superset/issues/22325)) ([159dcd7](https://github.com/apache/superset/commit/159dcd7e62e9466e2da4ad81cd25c06770fb4a5e))
- root context provider extension point ([#22188](https://github.com/apache/superset/issues/22188)) ([aa97ba4](https://github.com/apache/superset/commit/aa97ba4509431a82922f2fa6930928093c876d6f))
- Run Applitools on public Storybook ([#19852](https://github.com/apache/superset/issues/19852)) ([c3ba86e](https://github.com/apache/superset/commit/c3ba86ecc5b687c10403d5b37fce2e398dea610d))
- save active tabs in dashboard permalink ([#19983](https://github.com/apache/superset/issues/19983)) ([cadd259](https://github.com/apache/superset/commit/cadd259788c99415862cef7e8a5da9aaf4ed12cd))
- Save column data into json_metadata for all Query executions ([#20059](https://github.com/apache/superset/issues/20059)) ([660af40](https://github.com/apache/superset/commit/660af409a426806ead2d21fe80bff60c5480c264))
- scroll to bottom when adding a new native filter and the page is filled ([#19053](https://github.com/apache/superset/issues/19053)) ([cfb967f](https://github.com/apache/superset/commit/cfb967f430a75d363693d79494239b1686fd6e5d))
- Select all for synchronous select ([#22084](https://github.com/apache/superset/issues/22084)) ([02c9242](https://github.com/apache/superset/commit/02c9242d680a67dca18ae05b2ca585c0cf385ad0))
- **select filter:** add CRLF separator for Windows ([#21867](https://github.com/apache/superset/issues/21867)) ([7c4102c](https://github.com/apache/superset/commit/7c4102c20e8391f5174486afdaadfcd402e0dc60))
- Selectable dropdown triggered by icon component ([#21955](https://github.com/apache/superset/issues/21955)) ([5c27aaf](https://github.com/apache/superset/commit/5c27aafc0b62a57148111b2756a3f4c0192fa8a1))
- **select:** keep options order when in single mode ([#19085](https://github.com/apache/superset/issues/19085)) ([ae13d83](https://github.com/apache/superset/commit/ae13d8313b5687374f5b24e02bccdcc717ba19eb))
- **select:** sort exact and startsWith match to first ([#18856](https://github.com/apache/superset/issues/18856)) ([c75f233](https://github.com/apache/superset/commit/c75f233109008eee60cce6fea4f7f2d9256d53ef))
- **self-trigger:** add backend pagination for the table ([#959](https://github.com/apache/superset/issues/959)) ([0e0f67a](https://github.com/apache/superset/commit/0e0f67a778c4e2495bc1335cfe45bfe91517d0c7))
- Set default for Accept field in header to take application/json ([#1413](https://github.com/apache/superset/issues/1413)) ([67f1083](https://github.com/apache/superset/commit/67f1083af66c487e562bef42bdb1df7592e2ef8a))
- setting limit value when Pie chart switches ([#20392](https://github.com/apache/superset/issues/20392)) ([0a50a9b](https://github.com/apache/superset/commit/0a50a9b3804837ea7130f91bfcfcca57ab50129f))
- shorter timeout on test_connection ([#18001](https://github.com/apache/superset/issues/18001)) ([51090c3](https://github.com/apache/superset/commit/51090c3f1b4068552d5c4dc18d51b5f03fba1860))
- show user email in dashboard API ([#19004](https://github.com/apache/superset/issues/19004)) ([be88cb9](https://github.com/apache/superset/commit/be88cb9ba00a706dc5402e0b5311975bb013972a))
- showing results pane in dashboard ([#20144](https://github.com/apache/superset/issues/20144)) ([41f33a3](https://github.com/apache/superset/commit/41f33a38bce11b81e40a65aaa3487e9562766ef4))
- Shows related dashboards in Explore ([#21685](https://github.com/apache/superset/issues/21685)) ([200bed6](https://github.com/apache/superset/commit/200bed6f7ea6f4e7e1a1f2a2b74d2dcbcd689c02))
- simplify Encoder creation ([52d120a](https://github.com/apache/superset/commit/52d120a05b7ad6d41f2ab92ed56831a4b746b901))
- simplify memoized_func ([#19905](https://github.com/apache/superset/issues/19905)) ([aff10a7](https://github.com/apache/superset/commit/aff10a7fad0b6a48c578e70d2746d04bdf4d753c))
- simplify SQLite time grain ([#19745](https://github.com/apache/superset/issues/19745)) ([90130e4](https://github.com/apache/superset/commit/90130e4b4f8533c798484711794635d707fc3027))
- simply the data processing logic ([aa7ef1a](https://github.com/apache/superset/commit/aa7ef1ad9067a531ed94006c4f5db153e8598d97))
- Single metric sort ([#953](https://github.com/apache/superset/issues/953)) ([4313a51](https://github.com/apache/superset/commit/4313a517dfbe6b73d6f90ac9fc87ebc42372d083))
- **sip-68:** Add DatasourceDAO class to manage querying different datasources easier ([#20030](https://github.com/apache/superset/issues/20030)) ([21c5b26](https://github.com/apache/superset/commit/21c5b26fc819aa6531b17d6fc83cc3cc849389a8))
- smart tooltip in datasourcepanel ([#18080](https://github.com/apache/superset/issues/18080)) ([aa21a96](https://github.com/apache/superset/commit/aa21a963a6137a1d29ad422c6d7bf79839bc7078))
- split superset-ui/query from superset-ui/chart ([#178](https://github.com/apache/superset/issues/178)) ([9decd81](https://github.com/apache/superset/commit/9decd815ec5ba36b7267da6402435fd2d9ae2e5f))
- **sql lab:** display presto and trino tracking url ([#20799](https://github.com/apache/superset/issues/20799)) ([77db065](https://github.com/apache/superset/commit/77db0651d819f4bda367fc59a4e95954cb0929e1))
- **sql lab:** enable ACE editor search in SQL editors ([#19328](https://github.com/apache/superset/issues/19328)) ([eab9388](https://github.com/apache/superset/commit/eab9388f7cdaca20588d4c94c929225fd9d59870))
- **SQL Lab:** Make SQL Lab explore use the default viz from the config file ([#20056](https://github.com/apache/superset/issues/20056)) ([daded10](https://github.com/apache/superset/commit/daded1099262a694d7cc861a8a798dba4102d5e8))
- **sqllab:** Add a configuration option to disable data preview ([#19104](https://github.com/apache/superset/issues/19104)) ([02ef9ca](https://github.com/apache/superset/commit/02ef9ca4cd60d0d05f0afd2cebc1cabb83dfd4df))
- **sqllab:** Add event logger ([#23040](https://github.com/apache/superset/issues/23040)) ([4980621](https://github.com/apache/superset/commit/4980621902716205c2d531a36850d201ebb3a79c))
- **SqlLab:** Change Save Dataset Button to Split Save Query Button IV ([#20852](https://github.com/apache/superset/issues/20852)) ([8a04536](https://github.com/apache/superset/commit/8a04536f9d417fcaa926ee43f65b1c870277eea9))
- **sqllab:** Make LeftBar width resizable ([#21300](https://github.com/apache/superset/issues/21300)) ([2d70ef6](https://github.com/apache/superset/commit/2d70ef670ef81179916d9ab558a7ce6e4b84b82e))
- **sqllab:** save query parameters in database ([#21682](https://github.com/apache/superset/issues/21682)) ([61319fd](https://github.com/apache/superset/commit/61319fd759b336992259a4e84f1459a134d55df0))
- **ssh_tunnel:** Add feature flag to SSH Tunnel API ([#22805](https://github.com/apache/superset/issues/22805)) ([d6a4a5d](https://github.com/apache/superset/commit/d6a4a5da7976070cb949409763b22519a0d3f379))
- **ssh_tunnel:** Rename allow_ssh_tunneling and change the default value to False ([#22723](https://github.com/apache/superset/issues/22723)) ([ad758c0](https://github.com/apache/superset/commit/ad758c080259970c9ea587fd8dd3f56d1dab7722))
- **ssh_tunnel:** SQLAlchemy Form UI ([#22513](https://github.com/apache/superset/issues/22513)) ([5399365](https://github.com/apache/superset/commit/539936522fbbda46ebb39b65ed298f6e251a548f))
- **ssh_tunnel:** SSH Tunnel Switch extension ([#22967](https://github.com/apache/superset/issues/22967)) ([cf395ac](https://github.com/apache/superset/commit/cf395ac2d8e04782cffc93e8a0a0b28678c407fe))
- **ssh-tunnelling:** Setup SSH Tunneling Commands for Database Connections ([#21912](https://github.com/apache/superset/issues/21912)) ([ebaad10](https://github.com/apache/superset/commit/ebaad10d6ce72fa9d939833720b44880d5139bb9))
- **standardized form data:** keep all columns and metrics ([#20377](https://github.com/apache/superset/issues/20377)) ([bbbe102](https://github.com/apache/superset/commit/bbbe102887a524b1ee0ffd4ada8481078dbe5496))
- standardized form_data ([#20010](https://github.com/apache/superset/issues/20010)) ([dd4b581](https://github.com/apache/superset/commit/dd4b581fb55d920fc3b709fc044cea5339802ee2))
- store reference to container and update bindings ([#180](https://github.com/apache/superset/issues/180)) ([9f8461b](https://github.com/apache/superset/commit/9f8461b9659240e80099a167b998f4934b969870))
- style package for theming and styled components ([#362](https://github.com/apache/superset/issues/362)) ([11dbae7](https://github.com/apache/superset/commit/11dbae71a6dd0a69e81e49f98aa33bb1b352c546))
- style pkg exports emotion's css module ([#718](https://github.com/apache/superset/issues/718)) ([4e5f69b](https://github.com/apache/superset/commit/4e5f69b24ff1bd7bf9bbe98c8a76c2b0cbec7c96))
- **style:** add style to umbrella package ([#366](https://github.com/apache/superset/issues/366)) ([f2cf0a2](https://github.com/apache/superset/commit/f2cf0a2a7f037e3bb523a48dd8403ed6660cda01))
- **style:** adding typographic variables to theme ([#463](https://github.com/apache/superset/issues/463)) ([761b1d7](https://github.com/apache/superset/commit/761b1d7b02f67e02f14527b1663bca7cb7163df9))
- **superset-ui-connection:** Allow PUT and PATCH in call API ([3c53885](https://github.com/apache/superset/commit/3c53885abac8a24eaac4c280ee1c7fd302da2918))
- **superset-ui-core:** add feature flag for the analogous colors ([#19987](https://github.com/apache/superset/issues/19987)) ([80b5578](https://github.com/apache/superset/commit/80b55786809310e28566d745308b167f0e74b144))
- **superset-ui-style:** export ThemeProvider and useTheme ([#553](https://github.com/apache/superset/issues/553)) ([a39a058](https://github.com/apache/superset/commit/a39a058919a25bf13521f461e16abdbfef6c7f65))
- **superset-ui-style:** export ThemeProvider and useTheme from emotion-theming ([87f0090](https://github.com/apache/superset/commit/87f00900ca2f3e8d2d1a722583cbb9d2c0d01127))
- **superset-ui:** include control utils in the umbrella package ([#421](https://github.com/apache/superset/issues/421)) ([7cce8f0](https://github.com/apache/superset/commit/7cce8f008187d61105c4b734ea21f397cd793489))
- SupersetClient config to override 401 behavior ([#19144](https://github.com/apache/superset/issues/19144)) ([96a123f](https://github.com/apache/superset/commit/96a123f553f80ae7454daaf139b33e1397d9e3f7))
- support custom tooltip for scatterplot and box plot ([c01f2a9](https://github.com/apache/superset/commit/c01f2a9bfc681061a727e2bef0472ade434e9bf0))
- support disabling domain sharding with a query param ([#17177](https://github.com/apache/superset/issues/17177)) ([80a459f](https://github.com/apache/superset/commit/80a459f43bf27b29ce71f343f98e189d283cc52b))
- support line strokeWidth ([#105](https://github.com/apache/superset/issues/105)) ([a2c1d69](https://github.com/apache/superset/commit/a2c1d69c2ca03c701b8b14871ed78154e8c7c9f9))
- support locale in number and time format ([#182](https://github.com/apache/superset/issues/182)) ([3fc8551](https://github.com/apache/superset/commit/3fc855101404e9932b055f9a4c8167be46dcd9db))
- support mulitple temporal filters in AdhocFilter and move the Time Section away ([#21767](https://github.com/apache/superset/issues/21767)) ([a9b229d](https://github.com/apache/superset/commit/a9b229dd1dd9cb9dc8166b1392179fcccb4da138))
- support multi queries request ([#846](https://github.com/apache/superset/issues/846)) ([250589f](https://github.com/apache/superset/commit/250589fa2741c0f814bfd77e61a1fec2e6274981))
- support multiple columns with time grain in Table Chart ([#21547](https://github.com/apache/superset/issues/21547)) ([d67b046](https://github.com/apache/superset/commit/d67b04683c5e671a8e0278994fb36b23978c1ff4))
- support multiple time columns with time grain in Pivot Table v2 ([#21537](https://github.com/apache/superset/issues/21537)) ([e671d80](https://github.com/apache/superset/commit/e671d8020982111e117e7415dee41672cc32d780))
- support no data within BigNumber viz ([#327](https://github.com/apache/superset/issues/327)) ([4613183](https://github.com/apache/superset/commit/4613183946fea17628d5bf595561aa070a22a1ce))
- support None operand in EQUAL operator ([#21713](https://github.com/apache/superset/issues/21713)) ([05648eb](https://github.com/apache/superset/commit/05648eb489a7b5eec1c452cf1f037566dd942505))
- support polygon tooltip independently from superset app ([#12](https://github.com/apache/superset/issues/12)) ([abc4a04](https://github.com/apache/superset/commit/abc4a04294af6c116c1ad4299aca1eeb3e7f33c8))
- support sort the rich tooltip by metric desc ([#1445](https://github.com/apache/superset/issues/1445)) ([7193572](https://github.com/apache/superset/commit/71935725c3a807fd2ca08449f2340718a918b09f))
- support tooltip and legend overrides ([#101](https://github.com/apache/superset/issues/101)) ([97a95ff](https://github.com/apache/superset/commit/97a95ffcda35df79a00bd483044507fe64cfe421))
- support warning_markdown on metrics ([#1011](https://github.com/apache/superset/issues/1011)) ([9993b33](https://github.com/apache/superset/commit/9993b336ffa2ce8900e2d430ac804d800ebca75a))
- supports mulitple filters in samples endpoint ([#21008](https://github.com/apache/superset/issues/21008)) ([802b69f](https://github.com/apache/superset/commit/802b69f97bb9fd35fe8aed225cfd6a03875cf747))
- switch from `sqlalchemy-trino` to `trino` python client ([#19957](https://github.com/apache/superset/issues/19957)) ([58e65ad](https://github.com/apache/superset/commit/58e65ad5bb2178583dec0a33605580fc7af81d96))
- **table:** enable table filter and better typing ([#344](https://github.com/apache/superset/issues/344)) ([9b009e7](https://github.com/apache/superset/commit/9b009e71987b225915222d4d1b368f2f2b3b6830))
- **tablevis:** this pr is to add a new tablevis plguin to the system ([11a6929](https://github.com/apache/superset/commit/11a692940b5a59733a38a1b02ed245ec7dafcfcb))
- the samples endpoint supports filters and pagination ([#20683](https://github.com/apache/superset/issues/20683)) ([f011aba](https://github.com/apache/superset/commit/f011abae2b1bbcffc4eddb1a88872dea622693fb))
- **thumbnails:** add support for user specific thumbs ([#22328](https://github.com/apache/superset/issues/22328)) ([aa0cae9](https://github.com/apache/superset/commit/aa0cae9b490405ede604804877304b1df6dd08c1))
- **time-format:** add full-date to weekly time formatter ([#486](https://github.com/apache/superset/issues/486)) ([868ebbe](https://github.com/apache/superset/commit/868ebbe09dd0c067f3f8383724e596222803c9e3))
- **time-format:** bump d3-time-format ([#244](https://github.com/apache/superset/issues/244)) ([9b0d77a](https://github.com/apache/superset/commit/9b0d77adea6bf01d339d062535494a8724f56e4f))
- **time-format:** improve support for formatting with granularity in mind ([#509](https://github.com/apache/superset/issues/509)) ([17075ae](https://github.com/apache/superset/commit/17075ae02179951da9bde15352b148fc8d20895d))
- **timeseries-chart:** add percentage threshold input control ([#17758](https://github.com/apache/superset/issues/17758)) ([6bd4dd2](https://github.com/apache/superset/commit/6bd4dd257a6089a093bae3f251cf9f0976d353e6))
- **TimeTableViz:** sort by first metric ([#18896](https://github.com/apache/superset/issues/18896)) ([760dab9](https://github.com/apache/superset/commit/760dab9abdb2199b50006e01cb1e9cc0743cf966))
- TreeMap migration ([#20346](https://github.com/apache/superset/issues/20346)) ([7626c31](https://github.com/apache/superset/commit/7626c3137234d76b065559913705e19c3f59cf7f))
- Trino Authentications ([#17593](https://github.com/apache/superset/issues/17593)) ([0b67fe1](https://github.com/apache/superset/commit/0b67fe1beb0a9b0b56f0fcbb7e80c3e7ea3a1fac))
- trino support server-cert ([#16346](https://github.com/apache/superset/issues/16346)) ([ebb3419](https://github.com/apache/superset/commit/ebb34196f29ff9e826ab572d45f71056db5bb403))
- **trino:** add query cancellation ([#21035](https://github.com/apache/superset/issues/21035)) ([5113b01](https://github.com/apache/superset/commit/5113b01031705128df2064068a0809f07019c8ae))
- **trino:** support early cancellation of queries ([#22498](https://github.com/apache/superset/issues/22498)) ([b6d39d1](https://github.com/apache/superset/commit/b6d39d194c90dbbf0050bb3d32d2e1a513dfc0a6))
- truncate long values in table viz, a per-column setting ([#19383](https://github.com/apache/superset/issues/19383)) ([7e504ff](https://github.com/apache/superset/commit/7e504ff680698106cf9008b4c2814b01fcac90bb))
- UI override registry ([#19671](https://github.com/apache/superset/issues/19671)) ([4927685](https://github.com/apache/superset/commit/4927685c3059c0207713bceeea7c60f1f3b75ec3))
- **ui:** Adding manifest prefix config ([#19141](https://github.com/apache/superset/issues/19141)) ([4b34817](https://github.com/apache/superset/commit/4b34817b195fe93aa0bffd211bc978966a4aee4e))
- update ChartFormData and QueryObject to support filters. ([#164](https://github.com/apache/superset/issues/164)) ([c9e3e73](https://github.com/apache/superset/commit/c9e3e73f2ed24bbc8919e94662737305c6f4c9c8))
- update data format returned from query api and add getGroupBys ([#72](https://github.com/apache/superset/issues/72)) ([8273942](https://github.com/apache/superset/commit/827394261ae35105240b75d7af81839c08a97a53))
- update dependencies to 0.13 ([46db778](https://github.com/apache/superset/commit/46db778baabe267c298f74aee1eda5cf595026ba))
- update dependencies to 0.13 ([8256d99](https://github.com/apache/superset/commit/8256d99cd1b5530b64451d1a788fcb396a5073d1))
- update dependencies to make plugins compatible with 0.11 ([#38](https://github.com/apache/superset/issues/38)) ([ad67c39](https://github.com/apache/superset/commit/ad67c39ab7204d3e8076344e73e661c24114b8e4))
- update line chart thumbnail and scale extraction ([#61](https://github.com/apache/superset/issues/61)) ([1a3b10e](https://github.com/apache/superset/commit/1a3b10e18073f96f21a2a904219b94850cb44865))
- Update makefile with frontend build ([#17734](https://github.com/apache/superset/issues/17734)) ([215ee08](https://github.com/apache/superset/commit/215ee08a475c1ba0e49e58213ce2dbec14bf1b16))
- Update nav bar with new data information architecture for SQL Lab + SQL ([#21245](https://github.com/apache/superset/issues/21245)) ([b302818](https://github.com/apache/superset/commit/b3028185225fdc8ee3eb8b9058f3867d1a28ea86))
- Update query states to use spinner vs. progress bar ([#17804](https://github.com/apache/superset/issues/17804)) ([9e69940](https://github.com/apache/superset/commit/9e699401713460a46b28e6fed19f6ebd6cd228ca))
- Update ShortKey for stop query running in SqlLab editor ([#19692](https://github.com/apache/superset/issues/19692)) ([60e06c1](https://github.com/apache/superset/commit/60e06c1692651d5434b69427843e2539f13f4431))
- update time comparison choices (again) ([#17968](https://github.com/apache/superset/issues/17968)) ([05d9cde](https://github.com/apache/superset/commit/05d9cde203b99f8c63106446f0be58668cc9f0c9))
- update time comparison choices (again) ([#22458](https://github.com/apache/superset/issues/22458)) ([9e81c3a](https://github.com/apache/superset/commit/9e81c3a1192a18226d505178d16e1e395917a719))
- update time_compare description and choices ([#818](https://github.com/apache/superset/issues/818)) ([85f9cda](https://github.com/apache/superset/commit/85f9cdad0a0bd159dd00a120c90afdf7c9670ba5))
- update tooltip and use selector ([#31](https://github.com/apache/superset/issues/31)) ([818f462](https://github.com/apache/superset/commit/818f4628f73632e30ae65ae8a6d925e20cbb790a))
- update type for line chart series ([#175](https://github.com/apache/superset/issues/175)) ([bb501ad](https://github.com/apache/superset/commit/bb501adda57cfe3099ab6e73bd03a73e86900848))
- updated viz plugin generator ([#636](https://github.com/apache/superset/issues/636)) ([fb69984](https://github.com/apache/superset/commit/fb69984857238b935e56e5c39151e34ecc7b392c))
- Updates button styles of Modal pre-defined functions ([#22737](https://github.com/apache/superset/issues/22737)) ([d2a355b](https://github.com/apache/superset/commit/d2a355b2fba8b3b4e8ec1fe5a58a3c1d00f6dd23))
- upgrade [@superset-ui](https://github.com/superset-ui) to v0.12 ([#183](https://github.com/apache/superset/issues/183)) ([9e47ea8](https://github.com/apache/superset/commit/9e47ea8a962f18cb57abc67859efc37722323732))
- Upgrade documentation V2 ([#17411](https://github.com/apache/superset/issues/17411)) ([ac2545e](https://github.com/apache/superset/commit/ac2545e357bff22697fb91aa6ce73eded1f12750)), closes [#17714](https://github.com/apache/superset/issues/17714) [#17736](https://github.com/apache/superset/issues/17736) [#17990](https://github.com/apache/superset/issues/17990) [#17929](https://github.com/apache/superset/issues/17929) [#18036](https://github.com/apache/superset/issues/18036) [#18115](https://github.com/apache/superset/issues/18115) [#18128](https://github.com/apache/superset/issues/18128) [#18092](https://github.com/apache/superset/issues/18092) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18041](https://github.com/apache/superset/issues/18041) [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051) [#17593](https://github.com/apache/superset/issues/17593) [#18058](https://github.com/apache/superset/issues/18058) [#18059](https://github.com/apache/superset/issues/18059) [#18027](https://github.com/apache/superset/issues/18027) [#18045](https://github.com/apache/superset/issues/18045) [#18048](https://github.com/apache/superset/issues/18048) [#18073](https://github.com/apache/superset/issues/18073) [#17771](https://github.com/apache/superset/issues/17771) [#18060](https://github.com/apache/superset/issues/18060) [#17207](https://github.com/apache/superset/issues/17207) [#18087](https://github.com/apache/superset/issues/18087) [#18086](https://github.com/apache/superset/issues/18086) [#18082](https://github.com/apache/superset/issues/18082) [#18097](https://github.com/apache/superset/issues/18097) [#17807](https://github.com/apache/superset/issues/17807) [#18089](https://github.com/apache/superset/issues/18089) [#18100](https://github.com/apache/superset/issues/18100) [#18101](https://github.com/apache/superset/issues/18101) [#18105](https://github.com/apache/superset/issues/18105) [#18111](https://github.com/apache/superset/issues/18111) [#18083](https://github.com/apache/superset/issues/18083) [#17882](https://github.com/apache/superset/issues/17882) [#17843](https://github.com/apache/superset/issues/17843) [#17917](https://github.com/apache/superset/issues/17917) [#18021](https://github.com/apache/superset/issues/18021) [#18039](https://github.com/apache/superset/issues/18039) [#17569](https://github.com/apache/superset/issues/17569) [#18037](https://github.com/apache/superset/issues/18037) [#18081](https://github.com/apache/superset/issues/18081) [#18100](https://github.com/apache/superset/issues/18100) [#18133](https://github.com/apache/superset/issues/18133) [#18100](https://github.com/apache/superset/issues/18100) [#18116](https://github.com/apache/superset/issues/18116) [#18114](https://github.com/apache/superset/issues/18114) [#18108](https://github.com/apache/superset/issues/18108) [#18125](https://github.com/apache/superset/issues/18125) [#18152](https://github.com/apache/superset/issues/18152) [#18093](https://github.com/apache/superset/issues/18093) [#18130](https://github.com/apache/superset/issues/18130) [#18151](https://github.com/apache/superset/issues/18151)
- use a new official CH driver: clickhouse-connect ([#22039](https://github.com/apache/superset/issues/22039)) ([38a3fbd](https://github.com/apache/superset/commit/38a3fbdc33292204bcb28f3e433fda7561035fb6))
- Use SPA navigation between AddSlice and Dataset list pages ([#21683](https://github.com/apache/superset/issues/21683)) ([2907869](https://github.com/apache/superset/commit/2907869c2694ef28b27e672ff143b323e174fa2c))
- Use SPA navigation from datasets list to Explore ([#20890](https://github.com/apache/superset/issues/20890)) ([6ec164e](https://github.com/apache/superset/commit/6ec164e6a901fae1c88b03227e627fd8a4619400))
- Uses new table component in Drill to Detail ([#22173](https://github.com/apache/superset/issues/22173)) ([3ffe782](https://github.com/apache/superset/commit/3ffe7828a75eeb16af88798ab6ae01bbb835d770))
- Virtual dataset duplication ([#20309](https://github.com/apache/superset/issues/20309)) ([16032ed](https://github.com/apache/superset/commit/16032ed3e2b474ac6fba1510f82e6a7e640ce1d1))
- Visualize SqlLab.Query model data in Explore 📈 ([#20281](https://github.com/apache/superset/issues/20281)) ([e5e8867](https://github.com/apache/superset/commit/e5e886739460c011a885a13b873665410045a19c))
- **viz-gallery:** add 'feature' tag and fuzzy search weighting ([#18662](https://github.com/apache/superset/issues/18662)) ([7524e1e](https://github.com/apache/superset/commit/7524e1e3c86f3de2b3b0343c3ec5efc0b345937a))
- **viz-gallery:** add search weight for viz-name ([#19581](https://github.com/apache/superset/issues/19581)) ([e625c03](https://github.com/apache/superset/commit/e625c03cd50e57e26b04d3f5de28be307fa74029))
- **vizgallery:** Double-click viz type to submit form ([#20513](https://github.com/apache/superset/issues/20513)) ([280b4be](https://github.com/apache/superset/commit/280b4be4498bdf811d9be83d6ce6514bc5832b87))
- **viz:** Pivot table chart POC ([#1023](https://github.com/apache/superset/issues/1023)) ([9b6f23d](https://github.com/apache/superset/commit/9b6f23d3a7387d700485f1221f46fc0c4d982e93))
- **welcome:** make examples tab customizable ([#22302](https://github.com/apache/superset/issues/22302)) ([b954f8f](https://github.com/apache/superset/commit/b954f8f56080270fa7f1f68aa962c9e789e96728))
- When editing the label/title in the Metrics popover, hitting Enter should save what you've typed ([#19898](https://github.com/apache/superset/issues/19898)) ([5bfc95e](https://github.com/apache/superset/commit/5bfc95e79e89961967ba4acc8d24131157ccd16b))
- Word cloud typography update ([#518](https://github.com/apache/superset/issues/518)) ([72cc39b](https://github.com/apache/superset/commit/72cc39b4e0257b8a5672b66c42029ff0ed9a0b87))
- **world-map:** support color by metric or country column ([#19881](https://github.com/apache/superset/issues/19881)) ([766f737](https://github.com/apache/superset/commit/766f737728c273d39a35dfa281e874a0efeabec3))

### Performance Improvements

- **dashboard:** Improve performance of complex dashboards ([#19064](https://github.com/apache/superset/issues/19064)) ([3c1fb94](https://github.com/apache/superset/commit/3c1fb944c1f28635ed032ae87385201da4b6faa7))
- **dashboard:** Send chart requests before native filter requests ([#19077](https://github.com/apache/superset/issues/19077)) ([b8091e3](https://github.com/apache/superset/commit/b8091e33a93cad079e2fb7b57e3cf0f9688332c4))
- **dashboard:** Virtualization POC ([#21438](https://github.com/apache/superset/issues/21438)) ([406e44b](https://github.com/apache/superset/commit/406e44bba11f6b233c3b07d29efd158b8cfc9615))
- faster legacy table chart ([#385](https://github.com/apache/superset/issues/385)) ([2973c10](https://github.com/apache/superset/commit/2973c101973f17e83650a8b8abe8e7821f13b0c4)), closes [/github.com/DataTables/DataTables/blob/83657a29e33ce93ee940ce25684940eb3acb2913/media/js/jquery.dataTables.js#L3113-L3117](https://github.com//github.com/DataTables/DataTables/blob/83657a29e33ce93ee940ce25684940eb3acb2913/media/js/jquery.dataTables.js/issues/L3113-L3117)
- Implement model specific lookups by id to improve performance ([#20974](https://github.com/apache/superset/issues/20974)) ([17b5803](https://github.com/apache/superset/commit/17b58037f85dfb9db68167484d6afe5bda8f4f1c))
- improve perf in SIP-68 migration ([#19416](https://github.com/apache/superset/issues/19416)) ([63b5e2e](https://github.com/apache/superset/commit/63b5e2e4fa0a1f12450a108793896db4fbd43c6d))
- Memoize the common_bootstrap_payload and include user param ([#21018](https://github.com/apache/superset/issues/21018)) ([#21439](https://github.com/apache/superset/issues/21439)) ([44654e5](https://github.com/apache/superset/commit/44654e5abcc70d1fd934529dc82d7fe1d1bb20ef))
- **native-filters:** Decrease number of unnecessary rerenders in native filters ([#17115](https://github.com/apache/superset/issues/17115)) ([2ad9101](https://github.com/apache/superset/commit/2ad9101d1e7284d0a4d4cf649dfab76315920ffa))
- **native-filters:** improve native filter modal form performance ([#21821](https://github.com/apache/superset/issues/21821)) ([bf00193](https://github.com/apache/superset/commit/bf001931c8c7e58a211e411fa74ca4991c6aa2a8))
- **native-filters:** reduce the re-rendering of native filter modal ([#21781](https://github.com/apache/superset/issues/21781)) ([66f166b](https://github.com/apache/superset/commit/66f166be0f5485b9a51c80aef703b9d8d0fd93d5))
- **plugin-chart-table:** Add memoization to avoid rerenders ([#19976](https://github.com/apache/superset/issues/19976)) ([0f68dee](https://github.com/apache/superset/commit/0f68deedf105300c8bd2536bd205d128799c0381))
- Prevent rerendering and re-querying metadata of filters in horizontal bar ([#22389](https://github.com/apache/superset/issues/22389)) ([605cfa0](https://github.com/apache/superset/commit/605cfa045a8b774713f8ddf57abb1f2825c645cf))
- refactor SIP-68 db migrations with INSERT SELECT FROM ([#19421](https://github.com/apache/superset/issues/19421)) ([231716c](https://github.com/apache/superset/commit/231716cb50983b04178602b86c846b7673f9d8c3))
- speed up db migration for deprecating time_range_endpoints ([#19495](https://github.com/apache/superset/issues/19495)) ([90dbe8d](https://github.com/apache/superset/commit/90dbe8d340f227e3ffe374984a202516d779d5d8))
- **sqllab:** Rendering perf improvement using immutable state ([#20877](https://github.com/apache/superset/issues/20877)) ([f77b910](https://github.com/apache/superset/commit/f77b910e2cc9f1bd90ac0f3a9097ec5d394b582d))
- **word-cloud:** reduce render to improve performance ([#21504](https://github.com/apache/superset/issues/21504)) ([94a724e](https://github.com/apache/superset/commit/94a724e49bd8887d3c3bba1551f6f7415c64eb0a))

### Reverts

- Revert "ok (#21116)" (#21247) ([f2d67f7](https://github.com/apache/superset/commit/f2d67f75d013b8f9469fec474d7f6203007cd633)), closes [#21116](https://github.com/apache/superset/issues/21116) [#21247](https://github.com/apache/superset/issues/21247)
- Revert "feat: Reuse Dashboard redux data in Explore (#20668)" (#20689) ([5317462](https://github.com/apache/superset/commit/5317462b49d050d93d91eee5e97ec56e15f9f298)), closes [#20668](https://github.com/apache/superset/issues/20668) [#20689](https://github.com/apache/superset/issues/20689)
- Revert "feat(plugin-chart-echarts): Support stacking negative and positive values (#20408)" (#20571) ([f5f8dde](https://github.com/apache/superset/commit/f5f8ddec3e5c947896521003295e1acd93851674)), closes [#20408](https://github.com/apache/superset/issues/20408) [#20571](https://github.com/apache/superset/issues/20571)
- Revert "feat(explore): Show confirmation modal if user exits Explore without saving changes (#19993)" (#20092) ([9cdaa28](https://github.com/apache/superset/commit/9cdaa280429ec297db16d56c94fd77b5d2aff107)), closes [#19993](https://github.com/apache/superset/issues/19993) [#20092](https://github.com/apache/superset/issues/20092)
- Revert "chore(deps): bump d3-svg-legend in /superset-frontend (#19846)" (#19972) ([f144de4](https://github.com/apache/superset/commit/f144de4ee2bf213bb7e17f903bd3975d504c4136)), closes [#19846](https://github.com/apache/superset/issues/19846) [#19972](https://github.com/apache/superset/issues/19972)
- Revert "fix(sql lab): display the 'View Results' button consistently in the history tab on sync mode (#19362)" (#19906) ([1fa841e](https://github.com/apache/superset/commit/1fa841ee29cb502aa9d9e12e32a90558929b088a)), closes [#19362](https://github.com/apache/superset/issues/19362) [#19906](https://github.com/apache/superset/issues/19906)
- Revert "Update superset-e2e.yml (#18041)" (#18051) ([5da3c45](https://github.com/apache/superset/commit/5da3c45fc64b27d0f732cc9e26bf24f1ef9afa90)), closes [#18041](https://github.com/apache/superset/issues/18041) [#18051](https://github.com/apache/superset/issues/18051)
- Revert "fix(Dashboard): Only apply changes when editing properties (#17392)" (#17618) ([8963cca](https://github.com/apache/superset/commit/8963cca265ee6457542eeb22c33e31e1858e664c)), closes [#17392](https://github.com/apache/superset/issues/17392) [#17618](https://github.com/apache/superset/issues/17618)
- Revert "chore: isolate the one actual jquery dependency (#1339)" (#1355) ([e1944cf](https://github.com/apache/superset/commit/e1944cfb43276b44873b22d2fc2f86018c14147c)), closes [#1339](https://github.com/apache/superset/issues/1339) [#1355](https://github.com/apache/superset/issues/1355)
- Revert "chore: remove V2 and add Deprecated (#1250)" (#1253) ([f083d28](https://github.com/apache/superset/commit/f083d2897a9157a785f57c899c733d4a700355b8)), closes [#1250](https://github.com/apache/superset/issues/1250) [#1253](https://github.com/apache/superset/issues/1253)
- Revert "feat(superset-ui-style): export ThemeProvider and useTheme from emotion-theming" ([be31aa4](https://github.com/apache/superset/commit/be31aa49979b1ab927914d89898b4e74be3be37b))
- Revert "build: try to merge superset-ui-plugins" ([4d0d05f](https://github.com/apache/superset/commit/4d0d05f71f936963e381cfc901ca78f252b85c2b))
- Revert "build: clean up tsbuild.info, too" ([6f42844](https://github.com/apache/superset/commit/6f4284436614f71f6eff93d083068b9a70486058))
- Revert "Handle BigNumber conversions in JSON properly (without loss of precision) (#71)" (#126) ([f71180e](https://github.com/apache/superset/commit/f71180e251cc154370eef6d291be8270a1480e74)), closes [#71](https://github.com/apache/superset/issues/71) [#126](https://github.com/apache/superset/issues/126) [#71](https://github.com/apache/superset/issues/71)
- Revert "[Chart]Unify Metric format (#63)" (#65) ([908f969](https://github.com/apache/superset/commit/908f9693f0452a02cd98183aad3365dab1d32060)), closes [#63](https://github.com/apache/superset/issues/63) [#65](https://github.com/apache/superset/issues/65)
- Revert "fix(native-filters): Fix update ownState (#17181)" (#17311) ([7c6d6f4](https://github.com/apache/superset/commit/7c6d6f47bf71dce15e049f37fe82076bf7cb9c63)), closes [#17181](https://github.com/apache/superset/issues/17181) [#17311](https://github.com/apache/superset/issues/17311)
- Revert "fix: the calculated columns explicit type convert into date (#14813)" (#16950) ([b7e7ef2](https://github.com/apache/superset/commit/b7e7ef283150837c2c1d78719c11e20424c67d87)), closes [#14813](https://github.com/apache/superset/issues/14813) [#16950](https://github.com/apache/superset/issues/16950)
- Partial revert of 17236 ([#17383](https://github.com/apache/superset/issues/17383)) ([675ffaf](https://github.com/apache/superset/commit/675ffaf8df98b9f16be30a8e46deea0c61a0c238))

### BREAKING CHANGES

- **chart:** ChartProps fields are removed and renamed.

- test: update tests

- fix: unit tests

- fix: type
- No longer accept chartProps as a single prop in <SuperChart>. Developers must specify each field in chartProps individually.
- some api and types are removed from @superset-ui/chart and moved to /query

- feat: split superset-ui/query from superset-ui/chart

- fix: update references

- test: fix broken tests

- refactor: rename ChartFormData to QueryFormData

- fix: rename file

- fix: remove annotation layer from query package
- @superset-ui/core becomes peer dependency
- NumberFormat.xxx are renamed

- feat: Make smart number default formatter

- fix: add unit test

- refactor: move formatters outside
- Change Registry constructor API to take object instead of single string name.
  feat: Add overwritePolicy for Registry so developer can customize whether overwriting is ALLOW, WARN or PROHIBIT.
- rename D3Formatter to D3NumberFormatter
- Rename ColorScheme field 'name' to 'id'
- Remove categoricalColorScale.toFunction().
- The color scale no longer convert input to lowercase before finding color.
- Fix: Also transform input value before setting color.
