<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->
## Change Log

### 1.4.2 (Sat Mar 19 00:08:06 2022 +0200)
**Features**
- [#19248](https://github.com/apache/superset/pull/19248) feat: add support for comments in adhoc clauses (@villebro)
- [#18214](https://github.com/apache/superset/pull/18214) feat(docker-compose): add TAG option (@villebro)

**Fixes**
- [#17641](https://github.com/apache/superset/pull/17641) fix(sqla): make text clause escaping optional (@villebro)
- [#18566](https://github.com/apache/superset/pull/18566) fix(plugin-chart-echarts): area chart opacity bug (@villebro)

### 1.4.1 (Mon Jan 10 13:00:39 2022 +0000)
**Fixes**
- [#17980](https://github.com/apache/superset/pull/17980) fix: css template API response, less data (@dpgaspar)
- [#17984](https://github.com/apache/superset/pull/17984) fix: Change default SECRET_KEY, improve docs and banner warning on de… (@dpgaspar)
- [#17981](https://github.com/apache/superset/pull/17981) fix: API logger output (@dpgaspar)
- [#18006](https://github.com/apache/superset/pull/18006) fix: SQL Lab sorting of non-numbers (@etr2460)
- [#17573](https://github.com/apache/superset/pull/17573) fix(sqllab): Floating numbers not sorting correctly in result column (@lyndsiWilliams)
- [#17961](https://github.com/apache/superset/pull/17961) fix: update slug name (@pkdotson)
- [#17992](https://github.com/apache/superset/pull/17992) fix:  dashboard reload crash (@pkdotson)
- [#18048](https://github.com/apache/superset/pull/18048) fix(dashboard): scope status of native filter not update (@stephenLYZ)
- [#16869](https://github.com/apache/superset/pull/16869) fix: handle TIME column serialization (@frafra)

### 1.4.0
**Database Migrations**
- [#17335](https://github.com/apache/superset/pull/17335) feat: Certify Charts and Dashboards (@geido)
- [#17078](https://github.com/apache/superset/pull/17078) chore(engine): Translate fractional time grains—requires @superset-ui bump (@john-bodley)
- [#16849](https://github.com/apache/superset/pull/16849) chore: db migrate timeseries_limit_metric to legacy_order_by (@zhaoyongjie)
- [#14015](https://github.com/apache/superset/pull/14015) feat(filter-set): Add filterset resource (@ofekisr)
- [#16454](https://github.com/apache/superset/pull/16454) feat: add certifiedby & certification details fields to the edit dataset columns fields (@pkdotson)
- [#16549](https://github.com/apache/superset/pull/16549) feat(dashboard): Native filters - add type to native filter configuration (@m-ajay)
- [#16301](https://github.com/apache/superset/pull/16301) fix: remove mergepoint from past migration (@etr2460)

**Features**
- [#17353](https://github.com/apache/superset/pull/17353) feat: Drill ODBC/JDBC Impersonation feature (@Z0ltrix)
- [#17006](https://github.com/apache/superset/pull/17006) feat: Custom filters control (@simcha90)
- [#16889](https://github.com/apache/superset/pull/16889) feat: upgrade docker image to py38 and add support for py39 (@villebro)
- [#16903](https://github.com/apache/superset/pull/16903) feat: add Firebolt DB engine spec (@apurva-sigmoid)
- [#16862](https://github.com/apache/superset/pull/16862) feat: add Databricks ODBC engine spec (@betodealmeida)
- [#16628](https://github.com/apache/superset/pull/16628) feat: Add Private Google Sheets to dynamic form (@AAfghahi)
- [#16219](https://github.com/apache/superset/pull/16219) feat: added extraEnvRaw variable to load values from other secrets in Helm chart (@elyzov)
- [#16795](https://github.com/apache/superset/pull/16795) feat: handle temporal columns in group bys (@betodealmeida)
- [#16770](https://github.com/apache/superset/pull/16770) feat: add support for JOIN in Druid (@betodealmeida)
- [#16533](https://github.com/apache/superset/pull/16533) feat: Add Cypress makefile cmds (@hughhhh)
- [#16607](https://github.com/apache/superset/pull/16607) feat: add resample operator in post processing (@zhaoyongjie)
- [#16683](https://github.com/apache/superset/pull/16683) feat: add global max row limit (@villebro)
- [#16703](https://github.com/apache/superset/pull/16703) feat: Helm chart: Support hostAliases (@xasx)
- [#16660](https://github.com/apache/superset/pull/16660) feat: add support for generic series limit (@villebro)
- [#16695](https://github.com/apache/superset/pull/16695) feat: show nice error page in prod (@betodealmeida)
- [#16527](https://github.com/apache/superset/pull/16527) feat: adding logging to validation (@AAfghahi)
- [#16680](https://github.com/apache/superset/pull/16680) feat(sqla): add time grain and time column to jinja params (@villebro)
- [#16618](https://github.com/apache/superset/pull/16618) feat: feature flag configurable custom backend (@dpgaspar)
- [#16593](https://github.com/apache/superset/pull/16593) feat: Tabs in column (@simcha90)
- [#16375](https://github.com/apache/superset/pull/16375) feat: Backend Validation for Creation Method (@AAfghahi)
- [#16535](https://github.com/apache/superset/pull/16535) feat: Add Aurora Data API engine spec (@betodealmeida)
- [#14449](https://github.com/apache/superset/pull/14449) feat: Add parquet upload (@exemplary-citizen)
- [#16234](https://github.com/apache/superset/pull/16234) feat: add function list to auto-complete to Clickhouse datasource (@Slach)
- [#16394](https://github.com/apache/superset/pull/16394) feat: Draggable and Resizable Modal (@geido)
- [#16404](https://github.com/apache/superset/pull/16404) feat: add activate command (@hughhhh)
- [#16386](https://github.com/apache/superset/pull/16386) feat: config to customize bootstrap data overrides (@suddjian)
- [#16361](https://github.com/apache/superset/pull/16361) feat: Add extraVolumes and extraVolumeMounts to all main containers (@cccs-tom)
- [#16327](https://github.com/apache/superset/pull/16327) feat: Add new dev commands to Makefile (@hughhhh)
- [#16335](https://github.com/apache/superset/pull/16335) feat: improve embedded data table in text reports (@betodealmeida)
- [#16318](https://github.com/apache/superset/pull/16318) feat(sqla): apply time grain to all temporal groupbys (@villebro)
- [#16281](https://github.com/apache/superset/pull/16281) feat: timezone editor (@AAfghahi)
- [#16119](https://github.com/apache/superset/pull/16119) feat(explore): make dnd controls clickable (@kgabryje)
- [#15149](https://github.com/apache/superset/pull/15149) feat(dao): admin can remove self from object owners (@villebro)
- [#16201](https://github.com/apache/superset/pull/16201) feat: Allow users to connect via legacy SQLA form (@hughhhh)
- [#15686](https://github.com/apache/superset/pull/15686) feat: import configuration from directory (@betodealmeida)
- [#16090](https://github.com/apache/superset/pull/16090) feat(explore): each control can define its own canDrop for dnd (@kgabryje)
- [#16136](https://github.com/apache/superset/pull/16136) feat: add profiling to Superset pages (@betodealmeida)

**Fixes**
- [#17945](https://github.com/apache/superset/pull/17945) fix(dashboard): scope status of filter not update in dashboard metadata (@stephenLYZ)
- [#17349](https://github.com/apache/superset/pull/17349) fix(Dashboard): Check validity of control item (@geido)
- [#17842](https://github.com/apache/superset/pull/17842) fix(dashboard): update native filter info in metadata is not updated (@stephenLYZ)
- [#17835](https://github.com/apache/superset/pull/17835) fix: resolve tests for 1.4 (@eschutho)
- [#17781](https://github.com/apache/superset/pull/17781) fix(dashboard): commit update once (@serenajiang)
- [#17766](https://github.com/apache/superset/pull/17766) fix: Remove positions from json_metadata (@geido)
- [#17330](https://github.com/apache/superset/pull/17330) fix: import should accept old keys (@eschutho)
- [#17570](https://github.com/apache/superset/pull/17570) fix: Save properties after applying changes in Dashboard (@geido)
- [#17707](https://github.com/apache/superset/pull/17707) fix(Dashboard): Copy dashboard with duplicating charts 500 error (@geido)
- [#16041](https://github.com/apache/superset/pull/16041) fix: set correct schema on config import (@betodealmeida)
- [#17386](https://github.com/apache/superset/pull/17386) fix(sqllab): Have table name tooltip only show when name is truncated (@corbinrobb)
- [#17431](https://github.com/apache/superset/pull/17431) fix: use full resultType with csv download on chart in dashboard (@eschutho)
- [#17419](https://github.com/apache/superset/pull/17419) fix: avoid escaping bind-like params containing colons (@villebro)
- [#17311](https://github.com/apache/superset/pull/17311) fix: Revert "fix(native-filters): Fix update ownState" (@etr2460)
- [#17183](https://github.com/apache/superset/pull/17183) fix(Dashboard): Handle undefined tab when collapsing tabs (@geido)
- [#17133](https://github.com/apache/superset/pull/17133) fix: sql lab crash caused by invalid template (@graceguo-supercat)
- [#17123](https://github.com/apache/superset/pull/17123) fix(explore): remove unnecessary parameters from the explore url (@suddjian)
- [#17117](https://github.com/apache/superset/pull/17117) fix: undefined error when anonymous user browses dashboards or charts (@wijnanjo)
- [#17068](https://github.com/apache/superset/pull/17068) fix(sqllab): Hover tooltip flashes in SQL Lab (@lyndsiWilliams)
- [#17100](https://github.com/apache/superset/pull/17100) fix: prevent caching error pages (@etr2460)
- [#17080](https://github.com/apache/superset/pull/17080) fix: accept headers on import (@betodealmeida)
- [#17029](https://github.com/apache/superset/pull/17029) fix(other): column name in created content on profile page (@jinghua-qa)
- [#17018](https://github.com/apache/superset/pull/17018) fix: Exclude SUPERSET_DEFAULT from the list of available color schemes (@geido)
- [#16998](https://github.com/apache/superset/pull/16998) fix: ensure known dashboard id is used in save first (@pkdotson)
- [#17330](https://github.com/apache/superset/pull/17330) fix: import should accept old keys (@betodealmeida)
- [#17345](https://github.com/apache/superset/pull/17345) fix: clear 'delete' confirmation (@betodealmeida)
- [#17338](https://github.com/apache/superset/pull/17338) fix: add fallback and validation for report and cron timezones (@eschutho)
- [#17265](https://github.com/apache/superset/pull/17265) fix: Allow users to update database in Dataset Edit Modal (@hughhhh)
- [#17124](https://github.com/apache/superset/pull/17124) fix: update values for default timezone selector (@eschutho)
- [#17176](https://github.com/apache/superset/pull/17176) fix(AlertReportModal): Text Area Change (@AAfghahi)
- [#17201](https://github.com/apache/superset/pull/17201) fix(explore): Metrics disappearing after removing metric from dataset (@kgabryje)
- [#16994](https://github.com/apache/superset/pull/16994) fix: Unnecessary queries when changing filter values (@michael-s-molina)
- [#17003](https://github.com/apache/superset/pull/17003) fix: letter format of sort chart in dashboard edit (@jinghua-qa)
- [#16997](https://github.com/apache/superset/pull/16997) fix(sqllab): SqlJsonExecutionContext.query null pointer (@serenajiang)
- [#16912](https://github.com/apache/superset/pull/16912) fix: FilterableTable result div width (@lyndsiWilliams)
- [#16978](https://github.com/apache/superset/pull/16978) fix: Use production build config for cypress tests and fix webpack (@etr2460)
- [#17089](https://github.com/apache/superset/pull/17089) fix: Color consistency (@geido)
- [#17034](https://github.com/apache/superset/pull/17034) fix: show onhover menu only in edit mode (@pkdotson)
- [#17013](https://github.com/apache/superset/pull/17013) fix: Verify when null value should be undefined in Select (@geido)
- [#17263](https://github.com/apache/superset/pull/17263) fix(sqllab): Bugfix for tracking url transformation (@CodeingBoy)
- [#16976](https://github.com/apache/superset/pull/16976) fix(cli): fail CLI script on failed import/export (@EBoisseauSierra)
- [#17181](https://github.com/apache/superset/pull/17181) fix(native-filters): Fix update ownState (@simcha90)
- [#17027](https://github.com/apache/superset/pull/17027) fix: error alert levels again (@etr2460)
- [#17026](https://github.com/apache/superset/pull/17026) fix: error alerts again (@etr2460)
- [#17015](https://github.com/apache/superset/pull/17015) fix: error alerts js crash (@etr2460)
- [#17023](https://github.com/apache/superset/pull/17023) fix: Filtering db names while creating dataset is not working (@michael-s-molina)
- [#17174](https://github.com/apache/superset/pull/17174) fix: use typing_extension instead (@hughhhh)
- [#17167](https://github.com/apache/superset/pull/17167) fix(Explore): Undefined owners (@geido)
- [#17140](https://github.com/apache/superset/pull/17140) fix(filter-indicator): show filters handled by jinja as applied (@villebro)
- [#17111](https://github.com/apache/superset/pull/17111) fix: escape bind-like strings in virtual table query (@villebro)
- [#17113](https://github.com/apache/superset/pull/17113) fix: Bump FAB to 3.3.4 (@dpgaspar)
- [#17084](https://github.com/apache/superset/pull/17084) fix(dashboard): race condition between hydrating dashboard and set active tabs (@kgabryje)
- [#17063](https://github.com/apache/superset/pull/17063) fix: Owners selection in dataset edit UX (@hughhhh)
- [#17044](https://github.com/apache/superset/pull/17044) fix: clear modal state after adding dataset (@betodealmeida)
- [#17040](https://github.com/apache/superset/pull/17040) fix: Loading indicator of table and schema selectors (@michael-s-molina)
- [#17019](https://github.com/apache/superset/pull/17019) fix(gsheets): bug fix for private sheets (@AAfghahi)
- [#17007](https://github.com/apache/superset/pull/17007) fix(dashboard): Race condition when setting activeTabs with nested tabs (@kgabryje)
- [#16945](https://github.com/apache/superset/pull/16945) fix: rolling and cum operator on multiple series (@zhaoyongjie)
- [#16941](https://github.com/apache/superset/pull/16941) fix: check if owners are actually being updated in `PUT /datasets/<id>` (@hughhhh)
- [#16822](https://github.com/apache/superset/pull/16822) fix(BigQuery): explicitly quote columns in select_star (@betodealmeida)
- [#16988](https://github.com/apache/superset/pull/16988) fix: When click on "View all" from favorite tab, get error (@michael-s-molina)
- [#16968](https://github.com/apache/superset/pull/16968) fix: Revert "fix: RBAC hide right menu (#16902)" (@eschutho)
- [#16958](https://github.com/apache/superset/pull/16958) fix(build): make npm linking work pt. 2 (@villebro)
- [#16930](https://github.com/apache/superset/pull/16930) fix: replace absolute difference with difference in compareOperator (@zhaoyongjie)
- [#16946](https://github.com/apache/superset/pull/16946) fix(query_object): missing series validation not raised an exception (@ofekisr)
- [#16931](https://github.com/apache/superset/pull/16931) fix: replace absolute difference with difference in legacy charts (@zhaoyongjie)
- [#16902](https://github.com/apache/superset/pull/16902) fix: RBAC hide right menu (@hughhhh)
- [#16921](https://github.com/apache/superset/pull/16921) fix: Native filters cyclic dependency (@michael-s-molina)
- [#16925](https://github.com/apache/superset/pull/16925) fix: Unable to add dataset (@michael-s-molina)
- [#16923](https://github.com/apache/superset/pull/16923) fix(Explore): Handle undefined operatorId (@geido)
- [#16871](https://github.com/apache/superset/pull/16871) fix(Explore): Clear filter value when changing columns (@geido)
- [#16906](https://github.com/apache/superset/pull/16906) fix: Inclusive sign in time range display (@michael-s-molina)
- [#16908](https://github.com/apache/superset/pull/16908) fix: Disable lazy loading for the Database selector (@michael-s-molina)
- [#16895](https://github.com/apache/superset/pull/16895) fix: time comparison can't guarantee the accuracy (@zhaoyongjie)
- [#16859](https://github.com/apache/superset/pull/16859) fix: Fix Uniqueness check before update for Sqllab Overwrites (@hughhhh)
- [#16899](https://github.com/apache/superset/pull/16899) fix(GSheets): Fixing DB Connections Bug (@AAfghahi)
- [#16876](https://github.com/apache/superset/pull/16876) fix: Removing parent filter causes incorrect state of child filter (@michael-s-molina)
- [#16896](https://github.com/apache/superset/pull/16896) fix(sqla): allow series limit without subquery support (@villebro)
- [#16877](https://github.com/apache/superset/pull/16877) fix(native-filters): Overhead when changing the filter name (@michael-s-molina)
- [#16867](https://github.com/apache/superset/pull/16867) fix(build): enable hot reloading of linked packages (@villebro)
- [#16851](https://github.com/apache/superset/pull/16851) fix(dashboard): Fill form with the latest values when undo in native filters (@geido)
- [#16854](https://github.com/apache/superset/pull/16854) fix(native-filters): ignore unset filter box time range (@villebro)
- [#16840](https://github.com/apache/superset/pull/16840) fix(gallery): Hide the bottom info section when no chart is being selected (@stephenLYZ)
- [#16828](https://github.com/apache/superset/pull/16828) fix(native-filters): emitted filter label format (@villebro)
- [#16831](https://github.com/apache/superset/pull/16831) fix(native-filters): filter indicator stale state (@villebro)
- [#16758](https://github.com/apache/superset/pull/16758) fix(helm): Exit init script immediately on error (@sourcecode-glitch)
- [#16837](https://github.com/apache/superset/pull/16837) fix(SqlLab): display tooltip when disabled (@AAfghahi)
- [#16836](https://github.com/apache/superset/pull/16836) fix: 500 tab title (@etr2460)
- [#16833](https://github.com/apache/superset/pull/16833) fix: Updates the selected values when changing the native filter type, column or default value (@michael-s-molina)
- [#16800](https://github.com/apache/superset/pull/16800) fix: list Db2 as supported databases (@shawnzhu)
- [#16763](https://github.com/apache/superset/pull/16763) fix: show Import button only if has perms (@betodealmeida)
- [#16768](https://github.com/apache/superset/pull/16768) fix: encode rison characters when searching (@betodealmeida)
- [#16767](https://github.com/apache/superset/pull/16767) fix: typo in log (@betodealmeida)
- [#16769](https://github.com/apache/superset/pull/16769) fix: handle CTEs with comments on is_select (@betodealmeida)
- [#16754](https://github.com/apache/superset/pull/16754) fix: only fetch db function when db exists in sql lab (@eschutho)
- [#16753](https://github.com/apache/superset/pull/16753) fix: save query should use the correct sql  (@eschutho)
- [#16736](https://github.com/apache/superset/pull/16736) fix: update execution logs and states for alerts (@eschutho)
- [#16656](https://github.com/apache/superset/pull/16656) fix: set importer as owner (@betodealmeida)
- [#16674](https://github.com/apache/superset/pull/16674) fix: report with timeout chart (@graceguo-supercat)
- [#16706](https://github.com/apache/superset/pull/16706) fix: Ignores case and special keys when searching in the Select component (@michael-s-molina)
- [#16700](https://github.com/apache/superset/pull/16700) fix(explore): make clicked dnd filters unique (@villebro)
- [#16666](https://github.com/apache/superset/pull/16666) fix: Select refactoring known issues (@geido)
- [#16624](https://github.com/apache/superset/pull/16624) fix(dataset): create ES-View dataset raise exception #16623 (@aniaan)
- [#16696](https://github.com/apache/superset/pull/16696) fix: remove useless-suppression for pylint (@zhaoyongjie)
- [#16608](https://github.com/apache/superset/pull/16608) fix: Normalise `*.sh` File Endings (@gvee-uk)
- [#16668](https://github.com/apache/superset/pull/16668) fix: reset perf logger timer for soft navigation for SPA pages (@graceguo-supercat)
- [#16639](https://github.com/apache/superset/pull/16639) fix: Ensure alerts & reports aren't schduled when flag is off (@jfrag1)
- [#16629](https://github.com/apache/superset/pull/16629) fix: pybabel extract fails (@hushaoqing)
- [#16621](https://github.com/apache/superset/pull/16621) fix(dashboard): label colors included in explore url (@kgabryje)
- [#16632](https://github.com/apache/superset/pull/16632) fix(dnd): make clicked dnd metrics unique (@villebro)
- [#16570](https://github.com/apache/superset/pull/16570) fix(tests): make parquet select deterministic with order by (@villebro)
- [#16531](https://github.com/apache/superset/pull/16531) fix: Adds a loading message when needed in the Select component (@michael-s-molina)
- [#16461](https://github.com/apache/superset/pull/16461) fix(datasets): add support for removing owners (@villebro)
- [#16472](https://github.com/apache/superset/pull/16472) fix: select database fix (@AAfghahi)
- [#16411](https://github.com/apache/superset/pull/16411) fix: make chart rerender on timeseries columns change (@pkdotson)
- [#16511](https://github.com/apache/superset/pull/16511) fix: stop endless loading when dataset no longer exist (@pkdotson)
- [#16469](https://github.com/apache/superset/pull/16469) fix: sql lab refetch button (@graceguo-supercat)
- [#16451](https://github.com/apache/superset/pull/16451) fix: create example DB if needed (@betodealmeida)
- [#16478](https://github.com/apache/superset/pull/16478) fix: Revert "chore: Changes the DatabaseSelector and TableSelector to use the new Select component" (@etr2460)
- [#16477](https://github.com/apache/superset/pull/16477) fix(explore): JS error for creating new metrics from columns (@ktmud)
- [#16437](https://github.com/apache/superset/pull/16437) fix(explore): update overwrite button on perm change (@villebro)
- [#16417](https://github.com/apache/superset/pull/16417) fix(dashboard): undo and redo buttons weird alignment  (@MaxHuiYYDS)
- [#16413](https://github.com/apache/superset/pull/16413) fix: setupPlugin in chart list page (@graceguo-supercat)
- [#16367](https://github.com/apache/superset/pull/16367) fix: Disable Slack notification method if no api token (@graceguo-supercat)
- [#16408](https://github.com/apache/superset/pull/16408) fix: Revert "fix(explore): let admin overwrite slice" (@rusackas)
- [#16419](https://github.com/apache/superset/pull/16419) fix(explore): retain chart ownership on query context update (@villebro)
- [#16391](https://github.com/apache/superset/pull/16391) fix: Show cross filter option only when cross filter is enabled (@michael-s-molina)
- [#16323](https://github.com/apache/superset/pull/16323) fix: Return original document title when leaving a dashboard (@geido)
- [#16397](https://github.com/apache/superset/pull/16397) fix(api): return total count on related endpoint (@villebro)
- [#16410](https://github.com/apache/superset/pull/16410) fix: regex for multi-region IPs (@AAfghahi)
- [#16405](https://github.com/apache/superset/pull/16405) fix(pylint): Fix master (@john-bodley)
- [#16366](https://github.com/apache/superset/pull/16366) fix: show run button when time series column is updated. (@pkdotson)
- [#16383](https://github.com/apache/superset/pull/16383) fix: big number default date format (@etr2460)
- [#16380](https://github.com/apache/superset/pull/16380) fix: ensure certified fields are populated in metrics (@pkdotson)
- [#16360](https://github.com/apache/superset/pull/16360) fix: import dashboard w/o metadata (@betodealmeida)
- [#16330](https://github.com/apache/superset/pull/16330) fix: Fix parsing onSaving reports toast when user hasn't saved chart (@hughhhh)
- [#16355](https://github.com/apache/superset/pull/16355) fix: columns/index rebuild (@betodealmeida)
- [#16324](https://github.com/apache/superset/pull/16324) fix: Blank space in Change dataset modal without warning message (@geido)
- [#16347](https://github.com/apache/superset/pull/16347) fix: send CSV pivoted in reports (@betodealmeida)
- [#16329](https://github.com/apache/superset/pull/16329) fix: adjust initial state of report modal (@eschutho)
- [#16322](https://github.com/apache/superset/pull/16322) fix(explore): reordering columns with dnd sometimes glitching (@kgabryje)
- [#16306](https://github.com/apache/superset/pull/16306) fix: pass correct report_format (@eschutho)
- [#16303](https://github.com/apache/superset/pull/16303) fix: allow reports to update query_context (@betodealmeida)
- [#16296](https://github.com/apache/superset/pull/16296) fix: revert "disable text reports for now" (@betodealmeida)
- [#16243](https://github.com/apache/superset/pull/16243) fix: reverting Dataset names (@AAfghahi)
- [#16297](https://github.com/apache/superset/pull/16297) fix: rename Databricks (@betodealmeida)
- [#16280](https://github.com/apache/superset/pull/16280) fix: set dashboard mine tab to created_by filter (@pkdotson)
- [#16275](https://github.com/apache/superset/pull/16275) fix: Fix table height in Change dataset modal when pagination is off (@geido)
- [#16290](https://github.com/apache/superset/pull/16290) fix(explore): let admin overwrite slice (@villebro)
- [#16272](https://github.com/apache/superset/pull/16272) fix(dashboard): unset empty time filter indicator (@villebro)
- [#16257](https://github.com/apache/superset/pull/16257) fix: disable text reports for now (@betodealmeida)
- [#16232](https://github.com/apache/superset/pull/16232) fix: Stop the scrollbar in the Change Dataset modal from scrolling down to the pagination component (@geido)
- [#16168](https://github.com/apache/superset/pull/16168) fix(Dashboard): Omnibar dropdown visibility and keyboard commands (@geido)
- [#16250](https://github.com/apache/superset/pull/16250) fix: skip perms on query context update (@betodealmeida)
- [#16235](https://github.com/apache/superset/pull/16235) fix: Revert "feat: Changing Dataset names (#16199)" (@AAfghahi)
- [#16060](https://github.com/apache/superset/pull/16060) fix(Explore): Show the tooltip only when label does not fit the container in METRICS/FILTERS/GROUP BY/SORT BY of the DATA panel (@geido)
- [#16192](https://github.com/apache/superset/pull/16192) fix(Explore): Show the tooltip only when label does not fit the container in the Dataset panel (@geido)
- [#16194](https://github.com/apache/superset/pull/16194) fix(viz): deduce metric name if empty (@villebro)
- [#16211](https://github.com/apache/superset/pull/16211) fix: pyinstrument dependency (@betodealmeida)
- [#16145](https://github.com/apache/superset/pull/16145) fix: Hide Safari default tooltip (@geido)
- [#16056](https://github.com/apache/superset/pull/16056) fix: Make sheet_name into a `ValidationInputError` (@hughhhh)
- [#16137](https://github.com/apache/superset/pull/16137) fix: test_import_2_slices_for_same_table (@betodealmeida)
- [#15659](https://github.com/apache/superset/pull/15659) fix: Make db service use correct env file (@jongillham)
- [#15762](https://github.com/apache/superset/pull/15762) fix: Align alert solid small svg center (@duynguyenhoang)

**Others**
- [#17964](https://github.com/apache/superset/pull/17964) chore: bump FAB to 3.4.3 (@dpgaspar)
- [#17894](https://github.com/apache/superset/pull/17894) chore: bump gunicorn to 20.1.0 (@mporracindie)
- [#17420](https://github.com/apache/superset/pull/17420) chore: Bump FAB to 3.4.0 (@kamalkeshavani-aiinside)
- [#17752](https://github.com/apache/superset/pull/17752) chore: add release to pip requirements (@eschutho)
- [#17724](https://github.com/apache/superset/pull/17724) ci: temp fix for mysqlclient on an OS regression bug (@dpgaspar)
- [#17702](https://github.com/apache/superset/pull/17702) chore(sql): clean up invalid filter clause exception types (@villebro)
- [#17579](https://github.com/apache/superset/pull/17579) chore(datasets): Sanitizing /save response (@craig-rueda)
- [#17005](https://github.com/apache/superset/pull/17005) ci: skip unnecessary test steps (@villebro)
- [#16609](https://github.com/apache/superset/pull/16609) chore: Select component refactoring - SelectAsyncControl - Iteration 5 (@geido)
- [#17037](https://github.com/apache/superset/pull/17037) chore(Dashboard): Disable save button in Native Filters when an error is present (@geido)
- [#16940](https://github.com/apache/superset/pull/16940) chore(Dashboard): Highlight errored filters on the left pane of the Native Filters form plus several enhancements (@geido)
- [#17065](https://github.com/apache/superset/pull/17065) chore: add logging on successful data uploads (@eschutho)
- [#16990](https://github.com/apache/superset/pull/16990) chore: Translates the favorite filter param (@michael-s-molina)
- [#16965](https://github.com/apache/superset/pull/16965) chore: upgrade superset-ui dependencies (@graceguo-supercat)
- [#16510](https://github.com/apache/superset/pull/16510) chore: Select component refactoring - SelectControl - Iteration 5 (@geido)
- [#16943](https://github.com/apache/superset/pull/16943) chore: Moves spec files to the src folder - iteration 7 (@michael-s-molina)
- [#16935](https://github.com/apache/superset/pull/16935) chore: Moves spec files to the src folder - iteration 6 (@michael-s-molina)
- [#16917](https://github.com/apache/superset/pull/16917) refactor: sql lab command: separate concerns into different modules (@ofekisr)
- [#16874](https://github.com/apache/superset/pull/16874) chore(native_filter): feature on by default (@junlincc)
- [#16910](https://github.com/apache/superset/pull/16910) chore: add certified columns to top of list (@pkdotson)
- [#16927](https://github.com/apache/superset/pull/16927) chore: Moves spec files to the src folder - iteration 5 (@michael-s-molina)
- [#16919](https://github.com/apache/superset/pull/16919) chore: Adds the drag icon (@michael-s-molina)
- [#16880](https://github.com/apache/superset/pull/16880) chore: Moves the stylesheets folder to the assets folder (@michael-s-molina)
- [#16916](https://github.com/apache/superset/pull/16916) ci: check npm lockfile version (@villebro)
- [#16852](https://github.com/apache/superset/pull/16852) refactor: sql lab: handling command exceptions  (@ofekisr)
- [#16857](https://github.com/apache/superset/pull/16857) chore: Upgrades Storybook to version 6.3.8 to make it compatible with Webpack 5 (@michael-s-molina)
- [#16819](https://github.com/apache/superset/pull/16819) chore: move repro steps up in issue template  (@junlincc)
- [#16442](https://github.com/apache/superset/pull/16442) chore: Select component refactoring - TimeSeriesColumnControl - Iteration 5 (@geido)
- [#16446](https://github.com/apache/superset/pull/16446) chore: Select component refactoring - SaveModal - Iteration 5 (@geido)
- [#16445](https://github.com/apache/superset/pull/16445) chore: Select component refactoring - PropertiesModal - Iteration 5 (@geido)
- [#16440](https://github.com/apache/superset/pull/16440) chore: Select component refactoring - DndColumnSelectControl - Iteration 5 (@geido)
- [#16423](https://github.com/apache/superset/pull/16423) chore: Select component refactoring - MetricControl - Iteration 5 (@geido)
- [#15777](https://github.com/apache/superset/pull/15777) chore: Select component refactoring - FilterControl - Iteration 5 (@geido)
- [#16850](https://github.com/apache/superset/pull/16850) chore: bump superset-ui to 0.18.8 (@villebro)
- [#16843](https://github.com/apache/superset/pull/16843) refactor: sqllab: move sqllab ralated enumns and utils to more logical place (@ofekisr)
- [#16809](https://github.com/apache/superset/pull/16809) chore: upgrade to Node 16 (@villebro)
- [#16823](https://github.com/apache/superset/pull/16823) chore: Remove immutable.js (@etr2460)
- [#16807](https://github.com/apache/superset/pull/16807) chore: bump superset to 0.18.6 (@villebro)
- [#16784](https://github.com/apache/superset/pull/16784) chore: Update documentation on schema changes (@frafra)
- [#16672](https://github.com/apache/superset/pull/16672) chore: Update OpenAPI definition /database/available (@WingCode)
- [#16626](https://github.com/apache/superset/pull/16626) test: RTL overhaul - hackathon (@lyndsiWilliams)
- [#14429](https://github.com/apache/superset/pull/14429) chore: Moves the images folder to the assets folder (@michael-s-molina)
- [#16701](https://github.com/apache/superset/pull/16701) chore: Upgrade Webpack to v5 (@kgabryje)
- [#14431](https://github.com/apache/superset/pull/14431) chore: Moves messageToasts to the components folder (@michael-s-molina)
- [#16393](https://github.com/apache/superset/pull/16393) refactor: Changes the list views to use the new Select component (@michael-s-molina)
- [#16483](https://github.com/apache/superset/pull/16483) refactor: Changes the DatabaseSelector and TableSelector to use the new Select component (@michael-s-molina)
- [#16762](https://github.com/apache/superset/pull/16762) chore: log URI before downloading data on import (@betodealmeida)
- [#16732](https://github.com/apache/superset/pull/16732) chore: add browser info to template (@junlincc)
- [#16748](https://github.com/apache/superset/pull/16748) ci: bump npm to version 7 (@villebro)
- [#16741](https://github.com/apache/superset/pull/16741) chore: Upgrade immer package version (@simcha90)
- [#16725](https://github.com/apache/superset/pull/16725) chore: bump superset-ui 0.18.5 (@zhaoyongjie)
- [#16627](https://github.com/apache/superset/pull/16627) other: Provide option to add environment variables to only supersetNode (@dd-willgan)
- [#16693](https://github.com/apache/superset/pull/16693) chore: add semantic title to the pull request template (@suddjian)
- [#16720](https://github.com/apache/superset/pull/16720) chore: bump path-parse module in websocket sidecar app (@rusackas)
- [#16712](https://github.com/apache/superset/pull/16712) chore: Improves the Select component to avoid additional queries when all values have been loaded (@michael-s-molina)
- [#16589](https://github.com/apache/superset/pull/16589) chore(pylint): Remove top-level disable (@john-bodley)
- [#16540](https://github.com/apache/superset/pull/16540) chore: Add option to set a custom color scheme as default (@suddjian)
- [#16669](https://github.com/apache/superset/pull/16669) chore: bump sasl (@eschutho)
- [#16287](https://github.com/apache/superset/pull/16287) chore(pylint): Reenable too-many-lines check (@john-bodley)
- [#16682](https://github.com/apache/superset/pull/16682) refactor: sql_json view endpoint: move all logic from view to Command class (@ofekisr)
- [#16677](https://github.com/apache/superset/pull/16677) refactor: sql_json view endpoint: use execution context instead of query (@ofekisr)
- [#16676](https://github.com/apache/superset/pull/16676) refactor: sql_json view endpoint: separate flask response creation concern  (@ofekisr)
- [#16675](https://github.com/apache/superset/pull/16675) refactor: sql_json view endpoint: extract methods (@ofekisr)
- [#16653](https://github.com/apache/superset/pull/16653) refactor: sql_json view endpoint: separate setting query limit concern (@ofekisr)
- [#16649](https://github.com/apache/superset/pull/16649) refactor: sql_json view endpoint: separate query rendering concern (@ofekisr)
- [#16647](https://github.com/apache/superset/pull/16647) refactor: sql_json view endpoint: separate validate query concern (@ofekisr)
- [#16646](https://github.com/apache/superset/pull/16646) refactor: sql_json view endpoint: separate save query concern (@ofekisr)
- [#16638](https://github.com/apache/superset/pull/16638) chore: Writes the tests for the new Select component (@michael-s-molina)
- [#16615](https://github.com/apache/superset/pull/16615) chore: Bump FAB to 3.3.2 (@dpgaspar)
- [#16617](https://github.com/apache/superset/pull/16617) chore: Pylint downgrade (@amitmiran137)
- [#16587](https://github.com/apache/superset/pull/16587) chore: Merges latest Select changes (@michael-s-molina)
- [#16545](https://github.com/apache/superset/pull/16545) perf(dashboard): decrease number of rerenders of FiltersBadge (@kgabryje)
- [#16525](https://github.com/apache/superset/pull/16525) perf(dashboard): reduce rerenders of DragDroppable (@kgabryje)
- [#16601](https://github.com/apache/superset/pull/16601) chore(deps): bump superset-ui to 0.18.2 (@villebro)
- [#16595](https://github.com/apache/superset/pull/16595) refactor: sql_json view endpoint: separate concern into ad hod method (@ofekisr)
- [#16548](https://github.com/apache/superset/pull/16548) refactor: sql_json view endpoint: encapsulate ctas parameters (@ofekisr)
- [#16568](https://github.com/apache/superset/pull/16568) docs: update security page for small typos (@joeADSP)
- [#16559](https://github.com/apache/superset/pull/16559) chore: bump emotion to help with cache clobbering (@eschutho)
- [#16563](https://github.com/apache/superset/pull/16563) chore: bump superset-ui to 0.18.1 (@zhaoyongjie)
- [#16544](https://github.com/apache/superset/pull/16544) chore: bump superset-ui to 0.18.0 (@villebro)
- [#16546](https://github.com/apache/superset/pull/16546) refactor: sql_json view endpoint: extract to method for code reusing (@ofekisr)
- [#16449](https://github.com/apache/superset/pull/16449) refactor: sql_json view endpoint: separate getting and checking existi… (@ofekisr)
- [#16447](https://github.com/apache/superset/pull/16447) chore: Make View Query Modal draggable and resizable in Dashboard (@geido)
- [#16470](https://github.com/apache/superset/pull/16470) chore: remove myself from codeowners on Preset integration (@willbarrett)
- [#16496](https://github.com/apache/superset/pull/16496) docs: update entries for v1.2 and v1.3 (@villebro)
- [#16390](https://github.com/apache/superset/pull/16390) chore: Docs/superset1.3 release notes (@srinify)
- [#16473](https://github.com/apache/superset/pull/16473) docs: Make code snippet usable with required imports in configuration doc (@shawnzhu)
- [#16421](https://github.com/apache/superset/pull/16421) perf(dashboard): decouple redux props from dashboard components (@kgabryje)
- [#16444](https://github.com/apache/superset/pull/16444) perf(dashboard): reduce number of rerenders of Charts (@kgabryje)
- [#16463](https://github.com/apache/superset/pull/16463) chore(ci): bump pylint to 2.10.2 (@villebro)
- [#16466](https://github.com/apache/superset/pull/16466) chore: fixed slack invite link (@srinify)
- [#16362](https://github.com/apache/superset/pull/16362) refactor(explore): improve typing for Dnd controls (@ktmud)
- [#16441](https://github.com/apache/superset/pull/16441) refactor: sql_json view endpoint (@ofekisr)
- [#16415](https://github.com/apache/superset/pull/16415) docs: make FEATURE_FLAGS.md reference a link (@suddjian)
- [#16420](https://github.com/apache/superset/pull/16420) chore(viz): bump superset-ui to 0.17.87 (@villebro)
- [#16422](https://github.com/apache/superset/pull/16422) chore: Removes the TODOs and uses the default page size in AlertReportModal (@michael-s-molina)
- [#16144](https://github.com/apache/superset/pull/16144) chore: Changes the AlertReportModal to use the new Select component (@michael-s-molina)
- [#16273](https://github.com/apache/superset/pull/16273) chore: Enhance Omnibar (@geido)
- [#16334](https://github.com/apache/superset/pull/16334) chore: Changes the DatabaseSelector and TableSelector to use the new Select component (@michael-s-molina)
- [#16392](https://github.com/apache/superset/pull/16392) chore: Displays the dataset description in a tooltip in the datasets list (@michael-s-molina)
- [#16388](https://github.com/apache/superset/pull/16388) chore(pylint): Enable useless-suppression check (@john-bodley)
- [#16148](https://github.com/apache/superset/pull/16148) test: Functional RTL for email report modal II (@lyndsiWilliams)
- [#16286](https://github.com/apache/superset/pull/16286) docs: document FLASK_APP_MUTATOR (@shawnzhu)
- [#16353](https://github.com/apache/superset/pull/16353) chore(viz): bump deckgl plugin to 0.4.11 (@villebro)
- [#16113](https://github.com/apache/superset/pull/16113) docs: add VkusVill and TechAudit to users list (@ETselikov)
- [#16350](https://github.com/apache/superset/pull/16350) chore: bump superset-ui to v0.17.85 (@rusackas)
- [#16320](https://github.com/apache/superset/pull/16320) chore(explore): make metric/column search input clearable (@kgabryje)
- [#16308](https://github.com/apache/superset/pull/16308) docs: Add Care to users list of Apache Superset (@alandao2021)
- [#16285](https://github.com/apache/superset/pull/16285) refactor: re-arrange dashboard page js bundles (@graceguo-supercat)
- [#16288](https://github.com/apache/superset/pull/16288) chore(explore): remove unnecessary favstar redirect (@villebro)
- [#16266](https://github.com/apache/superset/pull/16266) chore(pylint): Reenable raise-missing-from check (@john-bodley)
- [#16264](https://github.com/apache/superset/pull/16264) chore(pylint): Reenable too-few-public-methods check (@john-bodley)
- [#16263](https://github.com/apache/superset/pull/16263) chore(pylint): Reenable import-outside-toplevel check (@john-bodley)
- [#16268](https://github.com/apache/superset/pull/16268) chore(pylint): Reenable too-many-locals check (@john-bodley)
- [#16256](https://github.com/apache/superset/pull/16256) chore(pylint): Reenable ungrouped-imports check (@john-bodley)
- [#16138](https://github.com/apache/superset/pull/16138) chore(pylint): Reenable super-with-arguments check (@john-bodley)
- [#16252](https://github.com/apache/superset/pull/16252) chore: Improves the flow to create a new chart (@michael-s-molina)
- [#16227](https://github.com/apache/superset/pull/16227) chore: upgrade mypy and add type guards (@villebro)
- [#16146](https://github.com/apache/superset/pull/16146) chore(pylint): Bump Pylint to 2.9.6 (@john-bodley)
- [#16200](https://github.com/apache/superset/pull/16200) chore: Shows the dataset description in the gallery dropdown (@michael-s-molina)
- [#16213](https://github.com/apache/superset/pull/16213) chore: bump py version for integration test (@hughhhh)
- [#16215](https://github.com/apache/superset/pull/16215) chore: Add feature flags to PR template (@junlincc)
- [#16163](https://github.com/apache/superset/pull/16163) chore: remove TerserPlugin step for build (@mistercrunch)
- [#15386](https://github.com/apache/superset/pull/15386) build: Removed jsx-remove-data-test-id usage from code for multi-build-variant testing (@adam-stasiak)
- [#16074](https://github.com/apache/superset/pull/16074) refactor: proper TypeError handling in memoize decorator (@sabiroid)
- [#16110](https://github.com/apache/superset/pull/16110) refactor: remove unnecessary dataset queries from dashboard requests (@graceguo-supercat)
- [#16129](https://github.com/apache/superset/pull/16129) docs: update install-from-scratch instructions for CentOS (@jberkus)
- [#16043](https://github.com/apache/superset/pull/16043) chore: Replaces the select for a dropdown button in the CSS editor (@michael-s-molina)
- [#16048](https://github.com/apache/superset/pull/16048) chore: Changes the RefreshIntervalModal component to use the new select component (@michael-s-molina)
- [#16064](https://github.com/apache/superset/pull/16064) chore: Changes the dashboard properties modal to use the new select component (@michael-s-molina)
- [#16101](https://github.com/apache/superset/pull/16101) docs: fix link and clarify postgres install instructions (@nytai)
- [#16040](https://github.com/apache/superset/pull/16040) refactor: adopt --app as celery global option (@john-bodley)
