/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

class AllocatedSlot
implements PhysicalSlot {
    private final AllocationID allocationId;
    private final TaskManagerLocation taskManagerLocation;
    private final ResourceProfile resourceProfile;
    private final TaskManagerGateway taskManagerGateway;
    private final int physicalSlotNumber;
    private final AtomicReference<PhysicalSlot.Payload> payloadReference;

    public AllocatedSlot(AllocationID allocationId, TaskManagerLocation location, int physicalSlotNumber, ResourceProfile resourceProfile, TaskManagerGateway taskManagerGateway) {
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)allocationId)));
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)location);
        this.physicalSlotNumber = physicalSlotNumber;
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
        this.payloadReference = new AtomicReference<Object>(null);
    }

    public SlotID getSlotId() {
        return new SlotID(this.getTaskManagerId(), this.physicalSlotNumber);
    }

    @Override
    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public ResourceID getTaskManagerId() {
        return this.getTaskManagerLocation().getResourceID();
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Override
    public boolean willBeOccupiedIndefinitely() {
        return this.isUsed() && this.payloadReference.get().willOccupySlotIndefinitely();
    }

    @Override
    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    @Override
    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.physicalSlotNumber;
    }

    public boolean isUsed() {
        return this.payloadReference.get() != null;
    }

    @Override
    public boolean tryAssignPayload(PhysicalSlot.Payload payload) {
        return this.payloadReference.compareAndSet(null, payload);
    }

    public void releasePayload(Throwable cause) {
        PhysicalSlot.Payload payload = this.payloadReference.get();
        if (payload != null) {
            payload.release(cause);
            this.payloadReference.set(null);
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        return "AllocatedSlot " + (Object)((Object)this.allocationId) + " @ " + this.taskManagerLocation + " - " + this.physicalSlotNumber;
    }
}

