/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import org.apache.streampark.console.core.entity.Effective;
import org.apache.streampark.console.core.enums.EffectiveType;
import org.apache.streampark.console.core.mapper.EffectiveMapper;
import org.apache.streampark.console.core.service.EffectiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class EffectiveServiceImpl
extends ServiceImpl<EffectiveMapper, Effective>
implements EffectiveService {
    private static final Logger log = LoggerFactory.getLogger(EffectiveServiceImpl.class);

    @Override
    public void delete(Long appId, EffectiveType effectiveType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Effective::getAppId, (Object)appId)).eq(Effective::getTargetType, (Object)effectiveType.getType());
        ((EffectiveMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public Effective get(Long appId, EffectiveType effectiveType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Effective::getAppId, (Object)appId)).eq(Effective::getTargetType, (Object)effectiveType.getType());
        return (Effective)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void saveOrUpdate(Long appId, EffectiveType type, Long id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Effective::getAppId, (Object)appId)).eq(Effective::getTargetType, (Object)type.getType());
        long count = this.count((Wrapper)queryWrapper);
        if (count == 0L) {
            Effective effective = new Effective();
            effective.setAppId(appId);
            effective.setTargetType(type.getType());
            effective.setTargetId(id);
            effective.setCreateTime(new Date());
            this.save(effective);
        } else {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(Effective::getAppId, (Object)appId)).eq(Effective::getTargetType, (Object)type.getType())).set(Effective::getTargetId, (Object)id));
        }
    }

    @Override
    public void removeApp(Long appId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Effective::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
    }
}

