/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.domain.router.RouterMeta;
import org.apache.streampark.console.base.domain.router.RouterTree;
import org.apache.streampark.console.base.domain.router.VueRouter;
import org.apache.streampark.console.base.util.VueRouterUtils;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.system.entity.Menu;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.mapper.MenuMapper;
import org.apache.streampark.console.system.service.MenuService;
import org.apache.streampark.console.system.service.RoleMenuServie;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class MenuServiceImpl
extends ServiceImpl<MenuMapper, Menu>
implements MenuService {
    private static final Logger log = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private RoleMenuServie roleMenuServie;

    @Override
    public List<String> findUserPermissions(Long userId, Long teamId) {
        User user = (User)Optional.ofNullable(this.userService.getById(userId)).orElseThrow(() -> new IllegalArgumentException(String.format("The userId [%s] not found", userId)));
        if (UserType.ADMIN.equals((Object)user.getUserType())) {
            return this.list().stream().map(Menu::getPerms).collect(Collectors.toList());
        }
        return ((MenuMapper)this.baseMapper).findUserPermissions(userId, teamId);
    }

    @Override
    public List<Menu> findUserMenus(Long userId, Long teamId) {
        User user = (User)Optional.ofNullable(this.userService.getById(userId)).orElseThrow(() -> new IllegalArgumentException(String.format("The userId:[%s] not found", userId)));
        if (UserType.ADMIN.equals((Object)user.getUserType())) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Menu::getType, (Object)"0")).orderByAsc(Menu::getOrderNum);
            return this.list((Wrapper)queryWrapper);
        }
        return ((MenuMapper)this.baseMapper).findUserMenus(userId, teamId);
    }

    @Override
    public Map<String, Object> findMenus(Menu menu) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)menu.getMenuName())) {
                queryWrapper.eq(Menu::getMenuName, (Object)menu.getMenuName());
            }
            if (StringUtils.isNotBlank((CharSequence)menu.getCreateTimeFrom()) && StringUtils.isNotBlank((CharSequence)menu.getCreateTimeTo())) {
                ((LambdaQueryWrapper)queryWrapper.ge(Menu::getCreateTime, (Object)menu.getCreateTimeFrom())).le(Menu::getCreateTime, (Object)menu.getCreateTimeTo());
            }
            List menus = ((MenuMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            ArrayList trees = new ArrayList();
            ArrayList ids = new ArrayList();
            menus.forEach(m -> {
                ids.add(m.getMenuId().toString());
                trees.add(new RouterTree((Menu)m));
            });
            result.put("ids", ids);
            result.put("total", menus.size());
            RouterTree routerTree = VueRouterUtils.buildRouterTree(trees);
            result.put("rows", routerTree);
        }
        catch (Exception e) {
            log.error("Failed to query menu", (Throwable)e);
            result.put("rows", null);
            result.put("total", 0);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createMenu(Menu menu) {
        menu.setCreateTime(new Date());
        this.setMenu(menu);
        this.save(menu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMenu(Menu menu) throws Exception {
        menu.setModifyTime(new Date());
        this.setMenu(menu);
        ((MenuMapper)this.baseMapper).updateById(menu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMenus(String[] menuIds) throws Exception {
        this.roleMenuServie.deleteByMenuId(menuIds);
        this.removeByIds(Arrays.asList(menuIds));
    }

    @Override
    public ArrayList<VueRouter<Menu>> getUserRouters(Long userId, Long teamId) {
        ArrayList routes = new ArrayList();
        List<Menu> menus = this.findUserMenus(userId, teamId);
        menus.forEach(menu -> {
            VueRouter route = new VueRouter();
            route.setId(menu.getMenuId().toString());
            route.setParentId(menu.getParentId().toString());
            route.setPath(menu.getPath());
            route.setComponent(menu.getComponent());
            route.setName(menu.getMenuName());
            route.setMeta(new RouterMeta(true, !menu.isDisplay(), true, menu.getIcon()));
            routes.add(route);
        });
        return VueRouterUtils.buildVueRouter(routes);
    }

    private void setMenu(Menu menu) {
        if (menu.getParentId() == null) {
            menu.setParentId(0L);
        }
        if ("1".equals(menu.getType())) {
            menu.setPath(null);
            menu.setIcon(null);
            menu.setComponent(null);
        }
    }
}

