/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverterRegistrar {
    private static final ModelConverters modelConvertersInstance = ModelConverters.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelConverterRegistrar.class);

    public ModelConverterRegistrar(List<ModelConverter> modelConverters) {
        for (ModelConverter modelConverter : modelConverters) {
            Optional<ModelConverter> registeredConverterOptional = this.getRegisteredConverterSameAs(modelConverter);
            registeredConverterOptional.ifPresent(arg_0 -> ((ModelConverters)modelConvertersInstance).removeConverter(arg_0));
            modelConvertersInstance.addConverter(modelConverter);
        }
    }

    private Optional<ModelConverter> getRegisteredConverterSameAs(ModelConverter modelConverter) {
        try {
            Field convertersField = FieldUtils.getDeclaredField(ModelConverters.class, (String)"converters", (boolean)true);
            List modelConverters = (List)convertersField.get(modelConvertersInstance);
            return modelConverters.stream().filter(registeredModelConverter -> this.isSameConverter((ModelConverter)registeredModelConverter, modelConverter)).findFirst();
        }
        catch (IllegalAccessException exception) {
            LOGGER.warn(exception.getMessage());
            return Optional.empty();
        }
    }

    private boolean isSameConverter(ModelConverter modelConverter1, ModelConverter modelConverter2) {
        Class<?> modelConverter1Class = modelConverter1.getClass();
        Class<?> modelConverter2Class = modelConverter2.getClass();
        return modelConverter1Class.equals(modelConverter2Class);
    }
}

