/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;

public class StateHandleStoreUtils {
    public static byte[] serializeOrDiscard(StateObject stateObject) throws Exception {
        try {
            return InstantiationUtil.serializeObject((Object)stateObject);
        }
        catch (Exception e) {
            try {
                stateObject.discardState();
            }
            catch (Exception discardException) {
                e.addSuppressed(discardException);
            }
            ExceptionUtils.rethrowException((Throwable)e);
            return new byte[0];
        }
    }

    public static <T extends Serializable> T deserialize(byte[] data) throws IOException, ClassNotFoundException {
        return (T)((Serializable)InstantiationUtil.deserializeObject((byte[])data, (ClassLoader)Thread.currentThread().getContextClassLoader()));
    }
}

