/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ExternalLink;
import org.apache.streampark.console.core.enums.PlaceholderType;
import org.apache.streampark.console.core.mapper.ExternalLinkMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.ExternalLinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.PropertyPlaceholderHelper;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ExternalLinkServiceImpl
extends ServiceImpl<ExternalLinkMapper, ExternalLink>
implements ExternalLinkService {
    private static final Logger log = LoggerFactory.getLogger(ExternalLinkServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;

    @Override
    public void create(ExternalLink externalLink) {
        if (!this.check(externalLink)) {
            return;
        }
        externalLink.setCreateTime(new Date());
        externalLink.setModifyTime(new Date());
        externalLink.setId(null);
        this.save(externalLink);
    }

    @Override
    public void update(ExternalLink externalLink) {
        if (!this.check(externalLink)) {
            return;
        }
        externalLink.setModifyTime(new Date());
        ((ExternalLinkMapper)this.baseMapper).updateById(externalLink);
    }

    @Override
    public void delete(Long linkId) {
        ((ExternalLinkMapper)this.baseMapper).deleteById(linkId);
    }

    @Override
    public List<ExternalLink> render(Long appId) {
        Application app = (Application)this.applicationService.getById(appId);
        Utils.notNull((Object)app, (String)"Application doesn't exist");
        List externalLink = this.list();
        if (externalLink != null && externalLink.size() > 0) {
            externalLink.forEach(link -> this.renderLinkUrl((ExternalLink)link, app));
        }
        return externalLink;
    }

    private void renderLinkUrl(ExternalLink link, Application app) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PlaceholderType.JOB_ID.get(), app.getJobId());
        map.put(PlaceholderType.JOB_NAME.get(), app.getJobName());
        map.put(PlaceholderType.YARN_ID.get(), app.getAppId());
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
        link.setRenderedLinkUrl(propertyPlaceholderHelper.replacePlaceholders(link.getLinkUrl().trim(), map::get));
    }

    private boolean check(ExternalLink params) {
        ExternalLink result;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.nested(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(ExternalLink::getBadgeName, (Object)params.getBadgeName())).or()).eq(ExternalLink::getLinkUrl, (Object)params.getLinkUrl());
        });
        if (params.getId() != null) {
            queryWrapper.and(qw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw.ne(ExternalLink::getId, (Object)params.getId());
            });
        }
        if ((result = (ExternalLink)this.getOne((Wrapper)queryWrapper)) == null) {
            return true;
        }
        Utils.required((!result.getBadgeName().equals(params.getBadgeName()) ? 1 : 0) != 0, (Object)String.format("The name: %s is already existing.", result.getBadgeName()));
        Utils.required((!result.getLinkUrl().equals(params.getLinkUrl()) ? 1 : 0) != 0, (Object)String.format("The linkUrl: %s is already existing.", result.getLinkUrl()));
        return false;
    }
}

