/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.bean.AlertDingTalkParams;
import org.apache.streampark.console.core.bean.AlertEmailParams;
import org.apache.streampark.console.core.bean.AlertHttpCallbackParams;
import org.apache.streampark.console.core.bean.AlertLarkParams;
import org.apache.streampark.console.core.bean.AlertWeComParams;
import org.apache.streampark.console.core.entity.AlertConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@Schema(name="AlertConfig")
public class AlertConfigWithParams
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AlertConfigWithParams.class);
    @Schema(example="1")
    private Long id;
    @Schema(example="100000")
    private Long userId;
    @Schema(example="test-alert")
    private String alertName;
    @Schema(example="1", description="base type, email 1, dink-talk 2, we-com 4, http callback 8, lark 16, also choose a combination, e.g. 3 means email + dink-talk")
    private Integer alertType;
    @Schema(description="email alert parameters")
    private AlertEmailParams emailParams;
    @Schema(description="ding-talk alert parameters")
    private AlertDingTalkParams dingTalkParams;
    @Schema(description="we-com alert parameters")
    private AlertWeComParams weComParams;
    @Schema(description="http callback alert parameters")
    private AlertHttpCallbackParams httpCallbackParams;
    @Schema(description="lark alert parameters")
    private AlertLarkParams larkParams;

    public static AlertConfigWithParams of(AlertConfig config) {
        if (config == null) {
            return null;
        }
        AlertConfigWithParams params = new AlertConfigWithParams();
        BeanUtils.copyProperties((Object)config, (Object)params, (String[])new String[]{"emailParams", "dingTalkParams", "weComParams", "httpCallbackParams", "larkParams"});
        try {
            if (StringUtils.isNotBlank((CharSequence)config.getEmailParams())) {
                params.setEmailParams(JacksonUtils.read(config.getEmailParams(), AlertEmailParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getDingTalkParams())) {
                params.setDingTalkParams(JacksonUtils.read(config.getDingTalkParams(), AlertDingTalkParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getWeComParams())) {
                params.setWeComParams(JacksonUtils.read(config.getWeComParams(), AlertWeComParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getHttpCallbackParams())) {
                params.setHttpCallbackParams(JacksonUtils.read(config.getHttpCallbackParams(), AlertHttpCallbackParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getLarkParams())) {
                params.setLarkParams(JacksonUtils.read(config.getLarkParams(), AlertLarkParams.class));
            }
        }
        catch (JsonProcessingException e) {
            log.error("Json read failed", (Throwable)e);
        }
        return params;
    }

    public Long getId() {
        return this.id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public Integer getAlertType() {
        return this.alertType;
    }

    public AlertEmailParams getEmailParams() {
        return this.emailParams;
    }

    public AlertDingTalkParams getDingTalkParams() {
        return this.dingTalkParams;
    }

    public AlertWeComParams getWeComParams() {
        return this.weComParams;
    }

    public AlertHttpCallbackParams getHttpCallbackParams() {
        return this.httpCallbackParams;
    }

    public AlertLarkParams getLarkParams() {
        return this.larkParams;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setAlertType(Integer alertType) {
        this.alertType = alertType;
    }

    public void setEmailParams(AlertEmailParams emailParams) {
        this.emailParams = emailParams;
    }

    public void setDingTalkParams(AlertDingTalkParams dingTalkParams) {
        this.dingTalkParams = dingTalkParams;
    }

    public void setWeComParams(AlertWeComParams weComParams) {
        this.weComParams = weComParams;
    }

    public void setHttpCallbackParams(AlertHttpCallbackParams httpCallbackParams) {
        this.httpCallbackParams = httpCallbackParams;
    }

    public void setLarkParams(AlertLarkParams larkParams) {
        this.larkParams = larkParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertConfigWithParams)) {
            return false;
        }
        AlertConfigWithParams other = (AlertConfigWithParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$alertType = this.getAlertType();
        Integer other$alertType = other.getAlertType();
        if (this$alertType == null ? other$alertType != null : !((Object)this$alertType).equals(other$alertType)) {
            return false;
        }
        String this$alertName = this.getAlertName();
        String other$alertName = other.getAlertName();
        if (this$alertName == null ? other$alertName != null : !this$alertName.equals(other$alertName)) {
            return false;
        }
        AlertEmailParams this$emailParams = this.getEmailParams();
        AlertEmailParams other$emailParams = other.getEmailParams();
        if (this$emailParams == null ? other$emailParams != null : !((Object)this$emailParams).equals(other$emailParams)) {
            return false;
        }
        AlertDingTalkParams this$dingTalkParams = this.getDingTalkParams();
        AlertDingTalkParams other$dingTalkParams = other.getDingTalkParams();
        if (this$dingTalkParams == null ? other$dingTalkParams != null : !((Object)this$dingTalkParams).equals(other$dingTalkParams)) {
            return false;
        }
        AlertWeComParams this$weComParams = this.getWeComParams();
        AlertWeComParams other$weComParams = other.getWeComParams();
        if (this$weComParams == null ? other$weComParams != null : !((Object)this$weComParams).equals(other$weComParams)) {
            return false;
        }
        AlertHttpCallbackParams this$httpCallbackParams = this.getHttpCallbackParams();
        AlertHttpCallbackParams other$httpCallbackParams = other.getHttpCallbackParams();
        if (this$httpCallbackParams == null ? other$httpCallbackParams != null : !((Object)this$httpCallbackParams).equals(other$httpCallbackParams)) {
            return false;
        }
        AlertLarkParams this$larkParams = this.getLarkParams();
        AlertLarkParams other$larkParams = other.getLarkParams();
        return !(this$larkParams == null ? other$larkParams != null : !((Object)this$larkParams).equals(other$larkParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertConfigWithParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $alertType = this.getAlertType();
        result = result * 59 + ($alertType == null ? 43 : ((Object)$alertType).hashCode());
        String $alertName = this.getAlertName();
        result = result * 59 + ($alertName == null ? 43 : $alertName.hashCode());
        AlertEmailParams $emailParams = this.getEmailParams();
        result = result * 59 + ($emailParams == null ? 43 : ((Object)$emailParams).hashCode());
        AlertDingTalkParams $dingTalkParams = this.getDingTalkParams();
        result = result * 59 + ($dingTalkParams == null ? 43 : ((Object)$dingTalkParams).hashCode());
        AlertWeComParams $weComParams = this.getWeComParams();
        result = result * 59 + ($weComParams == null ? 43 : ((Object)$weComParams).hashCode());
        AlertHttpCallbackParams $httpCallbackParams = this.getHttpCallbackParams();
        result = result * 59 + ($httpCallbackParams == null ? 43 : ((Object)$httpCallbackParams).hashCode());
        AlertLarkParams $larkParams = this.getLarkParams();
        result = result * 59 + ($larkParams == null ? 43 : ((Object)$larkParams).hashCode());
        return result;
    }

    public String toString() {
        return "AlertConfigWithParams(id=" + this.getId() + ", userId=" + this.getUserId() + ", alertName=" + this.getAlertName() + ", alertType=" + this.getAlertType() + ", emailParams=" + this.getEmailParams() + ", dingTalkParams=" + this.getDingTalkParams() + ", weComParams=" + this.getWeComParams() + ", httpCallbackParams=" + this.getHttpCallbackParams() + ", larkParams=" + this.getLarkParams() + ")";
    }
}

