/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.impl.io.URLStorageFactory;
import org.apache.derby.io.StorageFile;

class URLFile
extends InputStreamFile {
    private final URLStorageFactory storageFactory;

    URLFile(URLStorageFactory uRLStorageFactory, String string) {
        super(uRLStorageFactory, string);
        this.storageFactory = uRLStorageFactory;
    }

    URLFile(URLStorageFactory uRLStorageFactory, String string, String string2) {
        super((BaseStorageFactory)uRLStorageFactory, string, string2);
        this.storageFactory = uRLStorageFactory;
    }

    URLFile(URLFile uRLFile, String string) {
        super(uRLFile, string);
        this.storageFactory = uRLFile.storageFactory;
    }

    private URLFile(URLStorageFactory uRLStorageFactory, String string, int n) {
        super((BaseStorageFactory)uRLStorageFactory, string, n);
        this.storageFactory = uRLStorageFactory;
    }

    public boolean exists() {
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                return false;
            }
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    StorageFile getParentDir(int n) {
        return new URLFile(this.storageFactory, this.path, n);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        try {
            URL uRL = new URL(this.path);
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(this.path);
        }
    }
}

