/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractRDBMSQueryResult
extends AbstractQueryResult {
    protected ResultSet rs;
    protected ResultObjectFactory rof;
    protected Map<Object, Map<Integer, Object>> bulkLoadedValueByMemberNumber;

    public AbstractRDBMSQueryResult(Query query, ResultObjectFactory rof, ResultSet rs) {
        super(query);
        this.rof = rof;
        this.rs = rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void registerMemberBulkResultSet(IteratorStatement iterStmt, ResultSet rs) {
        if (this.bulkLoadedValueByMemberNumber == null) {
            this.bulkLoadedValueByMemberNumber = new HashMap<Object, Map<Integer, Object>>();
        }
        try {
            ExecutionContext ec = this.query.getExecutionContext();
            AbstractMemberMetaData mmd = iterStmt.getBackingStore().getOwnerMemberMetaData();
            if (mmd.hasCollection()) {
                ElementContainerStore backingStore = (ElementContainerStore)iterStmt.getBackingStore();
                if (backingStore.isElementsAreEmbedded() || backingStore.isElementsAreSerialised()) {
                    int[] param = new int[backingStore.getElementMapping().getNumberOfDatastoreMappings()];
                    for (int i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (backingStore.getElementMapping() instanceof SerialisedPCMapping || backingStore.getElementMapping() instanceof SerialisedReferenceMapping || backingStore.getElementMapping() instanceof EmbeddedElementPCMapping) {
                        while (rs.next()) {
                            Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                            Object element = backingStore.getElementMapping().getObject(ec, rs, param, ec.findObjectProvider(owner), backingStore.getOwnerMemberMetaData().getAbsoluteFieldNumber());
                            this.addOwnerMemberValue(mmd, owner, element);
                        }
                    } else {
                        while (rs.next()) {
                            Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                            Object element = backingStore.getElementMapping().getObject(ec, rs, param);
                            this.addOwnerMemberValue(mmd, owner, element);
                        }
                    }
                } else if (backingStore.getElementMapping() instanceof ReferenceMapping) {
                    int[] param = new int[backingStore.getElementMapping().getNumberOfDatastoreMappings()];
                    for (int i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    while (rs.next()) {
                        Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                        Object element = backingStore.getElementMapping().getObject(ec, rs, param);
                        this.addOwnerMemberValue(mmd, owner, element);
                    }
                } else {
                    ResultObjectFactory scoROF = ((RDBMSStoreManager)this.query.getStoreManager()).newResultObjectFactory(backingStore.getEmd(), iterStmt.getStatementClassMapping(), false, null, ec.getClassLoaderResolver().classForName(backingStore.getOwnerMemberMetaData().getCollection().getElementType()));
                    while (rs.next()) {
                        Object owner = iterStmt.getOwnerMapIndex().getMapping().getObject(ec, rs, iterStmt.getOwnerMapIndex().getColumnPositions());
                        Object element = scoROF.getObject(ec, rs);
                        this.addOwnerMemberValue(mmd, owner, element);
                    }
                }
            }
        }
        catch (SQLException sqle) {
            NucleusLogger.DATASTORE.error((Object)("Exception thrown processing bulk loaded field " + iterStmt.getBackingStore().getOwnerMemberMetaData().getFullFieldName()), (Throwable)sqle);
        }
        finally {
            block60: {
                try {
                    Statement stmt = null;
                    stmt = rs.getStatement();
                    rs.close();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block60;
                    }
                    catch (SQLException e) {}
                    break block60;
                    catch (SQLException e) {
                        try {
                            NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("052605", (Object)e));
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (SQLException e2) {}
                            throw throwable;
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e3) {}
                    }
                }
                finally {
                    rs = null;
                }
            }
        }
    }

    public abstract void initialise() throws SQLException;

    private void addOwnerMemberValue(AbstractMemberMetaData mmd, Object owner, Object element) {
        Collection coll;
        Object ownerId = this.query.getExecutionContext().getApiAdapter().getIdForObject(owner);
        Map<Integer, Object> fieldValuesForOwner = this.bulkLoadedValueByMemberNumber.get(ownerId);
        if (fieldValuesForOwner == null) {
            fieldValuesForOwner = new HashMap<Integer, Object>();
            this.bulkLoadedValueByMemberNumber.put(ownerId, fieldValuesForOwner);
        }
        if ((coll = (Collection)fieldValuesForOwner.get(mmd.getAbsoluteFieldNumber())) == null) {
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
                fieldValuesForOwner.put(mmd.getAbsoluteFieldNumber(), coll);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        coll.add(element);
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        super.disconnect();
        this.rof = null;
        this.rs = null;
    }

    public synchronized void close() {
        super.close();
        this.rof = null;
        this.rs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResults() {
        if (this.rs != null) {
            try {
                Statement stmt = null;
                try {
                    stmt = this.rs.getStatement();
                    this.rs.close();
                }
                catch (SQLException e) {
                    NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("052605", (Object)e));
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                this.rs = null;
            }
        }
    }

    public int hashCode() {
        if (this.rs != null) {
            return this.rs.hashCode();
        }
        if (this.query != null) {
            return this.query.hashCode();
        }
        return StringUtils.toJVMIDString((Object)((Object)this)).hashCode();
    }
}

