/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.bindings;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppLifeCycle;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StandardUndeployer
implements AppLifeCycle.Binding {
    private static final Logger LOG = Log.getLogger(StandardUndeployer.class);

    public String[] getBindingTargets() {
        return new String[]{"undeploying"};
    }

    public void processBinding(Node node, App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        ContextHandlerCollection chcoll = app.getDeploymentManager().getContexts();
        this.recursiveRemoveContext(chcoll, handler);
    }

    private void recursiveRemoveContext(HandlerCollection coll, ContextHandler context) {
        Handler[] children = coll.getHandlers();
        int originalCount = children.length;
        for (Handler child : children) {
            LOG.debug("Child handler {}", child);
            if (child.equals(context)) {
                LOG.debug("Removing handler {}", child);
                coll.removeHandler(child);
                child.destroy();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("After removal: {} (originally {})", coll.getHandlers().length, originalCount);
                continue;
            }
            if (!(child instanceof HandlerCollection)) continue;
            this.recursiveRemoveContext((HandlerCollection)child, context);
        }
    }
}

