/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamespaceInfo
extends StorageInfo {
    final String buildVersion;
    String blockPoolID = "";
    String softwareVersion;

    public NamespaceInfo() {
        super(HdfsServerConstants.NodeType.NAME_NODE);
        this.buildVersion = null;
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT, String buildVersion, String softwareVersion) {
        super(HdfsConstants.NAMENODE_LAYOUT_VERSION, nsID, clusterID, cT, HdfsServerConstants.NodeType.NAME_NODE);
        this.blockPoolID = bpID;
        this.buildVersion = buildVersion;
        this.softwareVersion = softwareVersion;
    }

    public NamespaceInfo(int nsID, String clusterID, String bpID, long cT) {
        this(nsID, clusterID, bpID, cT, Storage.getBuildVersion(), VersionInfo.getVersion());
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getBlockPoolID() {
        return this.blockPoolID;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public String toString() {
        return super.toString() + ";bpid=" + this.blockPoolID;
    }

    public void validateStorage(NNStorage storage) throws IOException {
        if (this.layoutVersion != storage.getLayoutVersion() || this.namespaceID != storage.getNamespaceID() || this.cTime != storage.cTime || !this.clusterID.equals(storage.getClusterID()) || !this.blockPoolID.equals(storage.getBlockPoolID())) {
            throw new IOException("Inconsistent namespace information:\nNamespaceInfo has:\nLV=" + this.layoutVersion + ";" + "NS=" + this.namespaceID + ";" + "cTime=" + this.cTime + ";" + "CID=" + this.clusterID + ";" + "BPID=" + this.blockPoolID + ".\nStorage has:\n" + "LV=" + storage.getLayoutVersion() + ";" + "NS=" + storage.getNamespaceID() + ";" + "cTime=" + storage.getCTime() + ";" + "CID=" + storage.getClusterID() + ";" + "BPID=" + storage.getBlockPoolID() + ".");
        }
    }
}

