/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.post;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.header.JakartaMediaRangeList;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingJakartaAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.servlets.post.JakartaHtmlResponse;
import org.apache.sling.servlets.post.JakartaJSONResponse;
import org.apache.sling.servlets.post.JakartaPostResponse;
import org.apache.sling.servlets.post.JakartaPostResponseCreator;
import org.apache.sling.servlets.post.Modification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostServlet
extends SlingJakartaAllMethodsServlet {
    private static final long serialVersionUID = 7408267654653472120L;
    private final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<JakartaPostResponseCreatorHolder> postResponseCreators = new ArrayList<JakartaPostResponseCreatorHolder>();
    private transient JakartaPostResponseCreator[] cachedPostResponseCreators = new JakartaPostResponseCreator[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse httpResponse) throws ServletException, IOException {
        JakartaPostResponse response = this.createPostResponse(request);
        response.setReferer(request.getHeader("referer"));
        String path = this.getItemPath(request);
        response.setPath(path);
        response.setLocation(this.externalizePath(request, path));
        path = ResourceUtil.getParent((String)path);
        if (path != null) {
            response.setParentLocation(this.externalizePath(request, path));
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ArrayList<Modification> changes = new ArrayList<Modification>();
        try {
            this.handleOperation(request, response, changes);
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", new String[]{change.getSource(), change.getDestination()});
                        break;
                    }
                }
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (ResourceNotFoundException rnfe) {
            response.setStatus(404, rnfe.getMessage());
        }
        catch (Exception throwable) {
            Throwable cause;
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Exception while handling POST %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)throwable);
            }
            if ((cause = throwable.getCause()) == null) {
                cause = throwable;
            }
            if (cause instanceof AccessDeniedException) {
                response.setStatus(403, cause.getMessage());
            } else {
                response.setError((Throwable)throwable);
            }
        }
        finally {
            try {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
            catch (RepositoryException e) {
                this.log.warn("RepositoryException in finally block: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (response.isSuccessful()) {
            String redirect = null;
            try {
                redirect = this.getRedirectUrl((HttpServletRequest)request, response);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Exception while handling redirect for POST %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)e);
                }
                response.setStatus(422, "invalid redirect");
                response.setError((Throwable)e);
            }
            if (redirect != null) {
                httpResponse.sendRedirect(redirect);
                return;
            }
        }
        response.send((HttpServletResponse)httpResponse, this.isSetStatus(request));
    }

    JakartaPostResponse createPostResponse(SlingJakartaHttpServletRequest req) {
        String headerValue;
        for (JakartaPostResponseCreator creator : this.cachedPostResponseCreators) {
            JakartaPostResponse response = creator.createPostResponse(req);
            if (response == null) continue;
            return response;
        }
        JakartaMediaRangeList mediaRangeList = null;
        String queryParam = req.getParameter(":http-equiv-accept");
        if (!(queryParam != null && queryParam.trim().length() != 0 || (headerValue = req.getHeader("Accept")) != null && headerValue.trim().length() != 0)) {
            mediaRangeList = new JakartaMediaRangeList(req.getResponseContentType());
        }
        if (mediaRangeList == null) {
            mediaRangeList = new JakartaMediaRangeList((HttpServletRequest)req);
        }
        if ("application/json".equals(mediaRangeList.prefer(new String[]{"text/html", "application/json"}))) {
            return new JakartaJSONResponse();
        }
        return new JakartaHtmlResponse();
    }

    protected abstract void handleOperation(SlingJakartaHttpServletRequest var1, JakartaPostResponse var2, List<Modification> var3) throws RepositoryException;

    protected String getRedirectUrl(HttpServletRequest request, JakartaPostResponse ctx) throws IOException {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    throw new IOException("The redirect target included host information. This is not allowed for security reasons!");
                }
            }
            catch (URISyntaxException e) {
                throw new IOException("The redirect target was not a valid uri");
            }
            if (ctx.getPath() != null) {
                int star = result.indexOf(42);
                if (star >= 0) {
                    StringBuilder buf = new StringBuilder();
                    if (star > 0) {
                        buf.append(result.substring(0, star));
                    }
                    buf.append(ResourceUtil.getName((String)ctx.getPath()));
                    if (star < result.length() - 1) {
                        buf.append(result.substring(star + 1));
                    }
                    result = buf.toString();
                } else if (result.endsWith("/")) {
                    result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
                }
            }
        }
        return result;
    }

    protected boolean isSetStatus(SlingJakartaHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value, assuming standard status code", (Object)":status");
        return true;
    }

    protected String getItemPath(SlingJakartaHttpServletRequest request) {
        return request.getResource().getPath();
    }

    protected final String externalizePath(SlingJakartaHttpServletRequest request, String path) {
        StringBuilder ret = new StringBuilder();
        ret.append(SlingRequestPaths.getContextPath((HttpServletRequest)request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostResponseCreator(JakartaPostResponseCreator creator, Map<String, Object> properties) {
        JakartaPostResponseCreatorHolder nngh = new JakartaPostResponseCreatorHolder(creator, this.getRanking(properties));
        List<JakartaPostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.ranking() < this.postResponseCreators.get(index).ranking(); ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostResponseCreator(JakartaPostResponseCreator creator, Map<String, Object> properties) {
        List<JakartaPostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<JakartaPostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                JakartaPostResponseCreatorHolder current = i.next();
                if (current.creator() != creator) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    private void updatePostResponseCreatorCache() {
        JakartaPostResponseCreator[] localCache = new JakartaPostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (JakartaPostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.creator;
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    protected int getRanking(Map<String, Object> properties) {
        int n;
        Object val = properties.get("service.ranking");
        if (val instanceof Integer) {
            Integer intVal = (Integer)val;
            n = intVal;
        } else {
            n = 0;
        }
        return n;
    }

    private record JakartaPostResponseCreatorHolder(JakartaPostResponseCreator creator, int ranking) {
    }
}

