/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.security.user.XPathQueryBuilder;
import org.apache.jackrabbit.spi.commons.iterator.BoundedIterator;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.iterator.Predicate;
import org.apache.jackrabbit.spi.commons.iterator.Predicates;
import org.apache.jackrabbit.spi.commons.iterator.Transformer;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathQueryEvaluator
implements XPathQueryBuilder.ConditionVisitor {
    static final Logger log = LoggerFactory.getLogger(XPathQueryEvaluator.class);
    private final XPathQueryBuilder builder;
    private final UserManagerImpl userManager;
    private final SessionImpl session;
    private final StringBuilder xPath = new StringBuilder();

    public XPathQueryEvaluator(XPathQueryBuilder builder, UserManagerImpl userManager, SessionImpl session) {
        this.builder = builder;
        this.userManager = userManager;
        this.session = session;
    }

    public Iterator<Authorizable> eval() throws RepositoryException {
        this.xPath.append("//element(*,").append(this.getNtName(this.builder.getSelector())).append(')');
        Value bound = this.builder.getBound();
        long offset = this.builder.getOffset();
        if (bound != null && offset > 0L) {
            log.warn("Found bound {} and offset {} in limit. Discarding offset.", (Object)bound, (Object)offset);
            offset = 0L;
        }
        XPathQueryBuilder.Condition condition = this.builder.getCondition();
        String sortCol = this.builder.getSortProperty();
        QueryBuilder.Direction sortDir = this.builder.getSortDirection();
        if (bound != null) {
            if (sortCol == null) {
                log.warn("Ignoring bound {} since no sort order is specified");
            } else {
                XPathQueryBuilder.Condition boundCondition = this.builder.property(sortCol, XPathQueryEvaluator.getCollation(sortDir), bound);
                XPathQueryBuilder.Condition condition2 = condition = condition == null ? boundCondition : this.builder.and(condition, boundCondition);
            }
        }
        if (condition != null) {
            this.xPath.append('[');
            condition.accept(this);
            this.xPath.append(']');
        }
        if (sortCol != null) {
            boolean ignoreCase = this.builder.getSortIgnoreCase();
            this.xPath.append(" order by ").append(ignoreCase ? "" : "fn:lower-case(").append(sortCol).append(ignoreCase ? " " : ") ").append(sortDir.getDirection());
        }
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(this.xPath.toString(), "xpath");
        long maxCount = this.builder.getMaxCount();
        if (maxCount == 0L) {
            return Iterators.empty();
        }
        if (this.builder.getGroupName() == null) {
            if (offset > 0L) {
                query.setOffset(offset);
            }
            if (maxCount > 0L) {
                query.setLimit(maxCount);
            }
            return this.toAuthorizables(XPathQueryEvaluator.execute(query));
        }
        Iterator<Authorizable> result = this.toAuthorizables(XPathQueryEvaluator.execute(query));
        Iterator<Authorizable> filtered = this.filter(result, this.builder.getGroupName(), this.builder.isDeclaredMembersOnly());
        return BoundedIterator.create((long)offset, (long)maxCount, filtered);
    }

    @Override
    public void visit(XPathQueryBuilder.NodeCondition condition) throws RepositoryException {
        String repPrincipal = this.session.getJCRName(UserConstants.P_PRINCIPAL_NAME);
        this.xPath.append('(').append("jcr:like(@").append(XPathQueryEvaluator.escapeForQuery(repPrincipal)).append(",'").append(XPathQueryEvaluator.escapeForQuery(condition.getPattern())).append("')").append(" or ").append("jcr:like(fn:name(),'").append(XPathQueryEvaluator.escape(condition.getPattern())).append("')").append(')');
    }

    @Override
    public void visit(XPathQueryBuilder.PropertyCondition condition) throws RepositoryException {
        XPathQueryBuilder.RelationOp relOp = condition.getOp();
        if (relOp == XPathQueryBuilder.RelationOp.EX) {
            this.xPath.append(XPathQueryEvaluator.escapeForQuery(condition.getRelPath()));
        } else if (relOp == XPathQueryBuilder.RelationOp.LIKE) {
            this.xPath.append("jcr:like(").append(XPathQueryEvaluator.escapeForQuery(condition.getRelPath())).append(",'").append(XPathQueryEvaluator.escapeForQuery(condition.getPattern())).append("')");
        } else {
            this.xPath.append(XPathQueryEvaluator.escapeForQuery(condition.getRelPath())).append(condition.getOp().getOp()).append(XPathQueryEvaluator.format(condition.getValue()));
        }
    }

    @Override
    public void visit(XPathQueryBuilder.ContainsCondition condition) {
        this.xPath.append("jcr:contains(").append(XPathQueryEvaluator.escapeForQuery(condition.getRelPath())).append(",'").append(XPathQueryEvaluator.escapeForQuery(condition.getSearchExpr())).append("')");
    }

    @Override
    public void visit(XPathQueryBuilder.ImpersonationCondition condition) {
        this.xPath.append("@rep:impersonators='").append(XPathQueryEvaluator.escapeForQuery(condition.getName())).append('\'');
    }

    @Override
    public void visit(XPathQueryBuilder.NotCondition condition) throws RepositoryException {
        this.xPath.append("not(");
        condition.getCondition().accept(this);
        this.xPath.append(')');
    }

    @Override
    public void visit(XPathQueryBuilder.AndCondition condition) throws RepositoryException {
        int count = 0;
        for (XPathQueryBuilder.Condition c : condition) {
            this.xPath.append(count++ > 0 ? " and " : "");
            c.accept(this);
        }
    }

    @Override
    public void visit(XPathQueryBuilder.OrCondition condition) throws RepositoryException {
        int pos = this.xPath.length();
        int count = 0;
        for (XPathQueryBuilder.Condition c : condition) {
            this.xPath.append(count++ > 0 ? " or " : "");
            c.accept(this);
        }
        if (count > 1) {
            this.xPath.insert(pos, '(');
            this.xPath.append(')');
        }
    }

    public static String escape(String string) {
        int j;
        StringBuilder result = new StringBuilder();
        int k = 0;
        do {
            if ((j = string.indexOf(37, k)) < 0) {
                result.append(Text.escapeIllegalJcrChars((String)string.substring(k)));
            } else if (j > 0 && string.charAt(j - 1) == '\\') {
                result.append(Text.escapeIllegalJcrChars((String)(string.substring(k, j) + '%')));
            } else {
                result.append(Text.escapeIllegalJcrChars((String)string.substring(k, j))).append('%');
            }
            k = j + 1;
        } while (j >= 0);
        return result.toString();
    }

    public static String escapeForQuery(String value) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (c == '\'') {
                ret.append("''");
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private String getNtName(Class<? extends Authorizable> selector) throws RepositoryException {
        if (User.class.isAssignableFrom(selector)) {
            return this.session.getJCRName(UserConstants.NT_REP_USER);
        }
        if (Group.class.isAssignableFrom(selector)) {
            return this.session.getJCRName(UserConstants.NT_REP_GROUP);
        }
        return this.session.getJCRName(UserConstants.NT_REP_AUTHORIZABLE);
    }

    private static String format(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 6: {
                return '\'' + value.getString() + '\'';
            }
            case 3: 
            case 4: {
                return value.getString();
            }
            case 5: {
                return "xs:dateTime('" + value.getString() + "')";
            }
        }
        throw new RepositoryException("Property of type " + PropertyType.nameFromValue((int)value.getType()) + " not supported");
    }

    private static XPathQueryBuilder.RelationOp getCollation(QueryBuilder.Direction direction) throws RepositoryException {
        switch (direction) {
            case ASCENDING: {
                return XPathQueryBuilder.RelationOp.GT;
            }
            case DESCENDING: {
                return XPathQueryBuilder.RelationOp.LT;
            }
        }
        throw new RepositoryException("Unknown sort order " + direction);
    }

    private static Iterator<Node> execute(Query query) throws RepositoryException {
        return query.execute().getNodes();
    }

    private Iterator<Authorizable> toAuthorizables(Iterator<Node> nodes) {
        Transformer<Node, Authorizable> transformer = new Transformer<Node, Authorizable>(){

            public Authorizable transform(Node node) {
                try {
                    return XPathQueryEvaluator.this.userManager.getAuthorizable((NodeImpl)node);
                }
                catch (RepositoryException e) {
                    log.warn("Cannot create authorizable from node {}", (Object)node);
                    log.debug(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        return Iterators.transformIterator(nodes, (Transformer)transformer);
    }

    private Iterator<Authorizable> filter(Iterator<Authorizable> authorizables, String groupName, boolean declaredMembersOnly) throws RepositoryException {
        Predicate<Authorizable> predicate;
        Authorizable groupAuth = this.userManager.getAuthorizable(groupName);
        if (groupAuth == null || !groupAuth.isGroup()) {
            predicate = Predicates.FALSE();
        } else {
            final Group group = (Group)groupAuth;
            predicate = declaredMembersOnly ? new Predicate<Authorizable>(){

                public boolean evaluate(Authorizable authorizable) {
                    try {
                        return authorizable != null && group.isDeclaredMember(authorizable);
                    }
                    catch (RepositoryException e) {
                        log.warn("Cannot determine whether {} is member of group {}", (Object)authorizable, (Object)group);
                        log.debug(e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            } : new Predicate<Authorizable>(){

                public boolean evaluate(Authorizable authorizable) {
                    try {
                        return authorizable != null && group.isMember(authorizable);
                    }
                    catch (RepositoryException e) {
                        log.warn("Cannot determine whether {} is member of group {}", (Object)authorizable, (Object)group);
                        log.debug(e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
            };
        }
        return Iterators.filterIterator(authorizables, (Predicate)predicate);
    }
}

