/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.javax.activation.internal;

import com.sun.activation.registries.MailcapFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.DataContentHandler;
import javax.activation.MailcapCommandMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiMailcapCommandMap
extends MailcapCommandMap {
    private static final Logger log = LoggerFactory.getLogger(OsgiMailcapCommandMap.class);
    private final Map<Bundle, MailcapFile> db = new HashMap<Bundle, MailcapFile>();
    private final Object sync = new Object();
    private Caller caller = null;

    public synchronized void addMailcap(String mailcap) {
        Bundle bundle;
        if (this.caller == null) {
            this.caller = new Caller();
        }
        if ((bundle = this.caller.get()) != null) {
            this.db.computeIfAbsent(bundle, x -> new MailcapFile()).appendToMailcap(mailcap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMailcapEntries(InputStream mailcapFile, Bundle originatingBundle) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            this.db.put(originatingBundle, new MailcapFile(mailcapFile));
        }
        log.debug("Added mailcap entries from bundle {}", (Object)originatingBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMailcapEntriesForBundle(Bundle bundle) {
        boolean removed;
        Object object = this.sync;
        synchronized (object) {
            removed = this.db.remove(bundle) != null;
        }
        if (removed) {
            log.debug("Removed mailcap entries from bundle {}", (Object)bundle);
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        this.getPreferredCommands(mimeType, commands, false);
        this.getPreferredCommands(mimeType, commands, true);
        return commands.toArray(new CommandInfo[commands.size()]);
    }

    private void getPreferredCommands(String mimeType, List<CommandInfo> accumulator, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            Map commandMap;
            Map map = commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null) continue;
            for (Object verbObject : commandMap.keySet()) {
                String verb = (String)verbObject;
                if (this.commandsHaveVerb(accumulator, verb)) continue;
                List commands = (List)commandMap.get(verb);
                String className = (String)commands.get(0);
                accumulator.add(new CommandInfo(verb, className));
            }
        }
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        this.getAllCommands(mimeType, commands, false);
        this.getAllCommands(mimeType, commands, true);
        return commands.toArray(new CommandInfo[commands.size()]);
    }

    private void getAllCommands(String mimeType, List<CommandInfo> accumulator, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            Map commandMap;
            Map map = commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null) continue;
            for (Object verbAsObject : commandMap.keySet()) {
                String verb = (String)verbAsObject;
                List commands = (List)commandMap.get(verb);
                for (Object command : commands) {
                    accumulator.add(new CommandInfo(verb, (String)command));
                }
            }
        }
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        CommandInfo command = null;
        command = this.getCommand(mimeType, cmdName, false);
        if (command != null) {
            return command;
        }
        command = this.getCommand(mimeType, cmdName, true);
        return command;
    }

    private CommandInfo getCommand(String mimeType, String commandName, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String cmdClassName;
            List commands;
            Map commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null || (commands = (List)commandMap.get(commandName)) == null || (cmdClassName = (String)commands.get(0)) == null) continue;
            return new CommandInfo(commandName, cmdClassName);
        }
        return null;
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        DataContentHandler dch;
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        if ((dch = this.findDataContentHandler(mimeType, false)) != null) {
            return dch;
        }
        return this.findDataContentHandler(mimeType, true);
    }

    private DataContentHandler findDataContentHandler(String mimeType, boolean fallback) {
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String name;
            DataContentHandler dch;
            List v;
            Map commandMap = fallback ? entry.getValue().getMailcapFallbackList(mimeType) : entry.getValue().getMailcapList(mimeType);
            if (commandMap == null || (v = (List)commandMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = (String)v.get(0), entry.getKey())) == null) continue;
            return dch;
        }
        return null;
    }

    public synchronized String[] getMimeTypes() {
        ArrayList<String> mimeTypesList = new ArrayList<String>();
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String[] mimeTypes;
            for (String mimeType : mimeTypes = entry.getValue().getMimeTypes()) {
                if (mimeTypesList.contains(mimeType)) continue;
                mimeTypesList.add(mimeType);
            }
        }
        return mimeTypesList.toArray(new String[mimeTypesList.size()]);
    }

    public synchronized String[] getNativeCommands(String mimeType) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (Map.Entry<Bundle, MailcapFile> entry : this.db.entrySet()) {
            String[] cmds = entry.getValue().getNativeCommands(mimeType);
            if (cmds == null) continue;
            for (String cmd : cmds) {
                if (cmdList.contains(cmd)) continue;
                cmdList.add(cmd);
            }
        }
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private DataContentHandler getDataContentHandler(String name, Bundle bundle) {
        try {
            return (DataContentHandler)bundle.loadClass(name).newInstance();
        }
        catch (InstantiationException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.warn("Unable to instantiate " + DataContentHandler.class.getSimpleName() + " class ' " + name + " ' from bundle " + bundle, (Throwable)e);
        }
        return null;
    }

    private boolean commandsHaveVerb(List<CommandInfo> commands, String verb) {
        for (CommandInfo commandInfo : commands) {
            if (!commandInfo.getCommandName().equals(verb)) continue;
            return true;
        }
        return false;
    }

    private static final class Caller
    extends SecurityManager {
        private Caller() {
        }

        Bundle get() {
            Class<?>[] stack = this.getClassContext();
            for (int i = 0; i < stack.length; ++i) {
                Bundle bundle = FrameworkUtil.getBundle(stack[i]);
                if (bundle == null || bundle.equals(FrameworkUtil.getBundle(this.getClass()))) continue;
                return bundle;
            }
            return null;
        }
    }
}

