/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.client.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.sling.hapi.client.ClientException;
import org.apache.sling.hapi.client.Document;
import org.apache.sling.hapi.client.HtmlClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHtmlClientImpl
implements HttpClient,
HtmlClient {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractHtmlClientImpl.class);
    protected CloseableHttpClient client;
    protected URI baseUrl;

    public AbstractHtmlClientImpl(CloseableHttpClient client, String baseUrl) throws URISyntaxException {
        this.client = client;
        this.baseUrl = new URI(baseUrl);
    }

    public AbstractHtmlClientImpl(String baseUrl) throws URISyntaxException {
        this(HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build(), baseUrl);
    }

    public AbstractHtmlClientImpl(String baseUrl, String user, String password) throws URISyntaxException {
        this.baseUrl = new URI(baseUrl);
        HttpHost targetHost = URIUtils.extractHost((URI)this.baseUrl);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
        this.client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    @Override
    public <T extends Document> T enter(String url) throws ClientException {
        return this.get(url);
    }

    @Override
    public <T extends Document> T get(String url) throws ClientException {
        try {
            URI absoluteUri = this.absoluteUri(url);
            LOG.info("GET " + absoluteUri);
            HttpResponse response = this.execute((HttpUriRequest)new HttpGet(absoluteUri));
            return this.newDocument(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (URISyntaxException e) {
            throw new ClientException("Invalid get url " + url, e);
        }
        catch (Exception e) {
            throw new ClientException("Could not execute GET request", e);
        }
    }

    @Override
    public <T extends Document> T post(String url, HttpEntity entity) throws ClientException {
        try {
            URI absoluteUri = this.absoluteUri(url);
            LOG.info("POST " + absoluteUri);
            HttpPost post = new HttpPost(absoluteUri);
            post.setEntity(entity);
            HttpResponse response = this.execute((HttpUriRequest)post);
            return this.newDocument(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (URISyntaxException e) {
            throw new ClientException("Invalid post url " + url, e);
        }
        catch (Exception e) {
            throw new ClientException("Could not execute POST request", e);
        }
    }

    @Override
    public <T extends Document> T delete(String url) throws ClientException {
        try {
            URI absoluteUri = this.absoluteUri(url);
            LOG.info("DELETE " + absoluteUri);
            HttpResponse response = this.execute((HttpUriRequest)new HttpDelete(absoluteUri));
            return this.newDocument(response.getEntity().toString());
        }
        catch (URISyntaxException e) {
            throw new ClientException("Invalid post url " + url, e);
        }
        catch (Exception e) {
            throw new ClientException("Could not execute DELETE request", e);
        }
    }

    @Override
    public abstract <T extends Document> T newDocument(String var1);

    private URI absoluteUri(String url) throws URISyntaxException {
        URI getUrl = new URI(url);
        return this.baseUrl.resolve(getUrl);
    }

    public HttpParams getParams() {
        return this.client.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        return this.client.execute(httpUriRequest);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.client.execute(httpUriRequest, httpContext);
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) throws IOException, ClientProtocolException {
        return this.client.execute(httpHost, httpRequest);
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.client.execute(httpHost, httpRequest, httpContext);
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.client.execute(httpUriRequest, responseHandler);
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)this.client.execute(httpUriRequest, responseHandler, httpContext);
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.client.execute(httpHost, httpRequest, responseHandler);
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        return (T)this.client.execute(httpHost, httpRequest, responseHandler, httpContext);
    }
}

