/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.osgi.ManifestHeader;

class InitialContentImportOptions {
    private static final String OVERWRITE_DIRECTIVE = "overwrite";
    private static final String IGNORE_CONTENT_READERS_DIRECTIVE = "ignoreImportProviders";
    private final boolean overwrite;
    private final Set<String> ignoreImportProviders;

    public InitialContentImportOptions(String optionsString) {
        ManifestHeader header = ManifestHeader.parse((String)("/dummy/path;" + optionsString));
        ManifestHeader.Entry[] entries = header.getEntries();
        if (entries.length > 0) {
            this.overwrite = BooleanUtils.toBoolean((String)entries[0].getDirectiveValue(OVERWRITE_DIRECTIVE));
            String ignoreImportProvidersString = StringUtils.defaultString((String)entries[0].getDirectiveValue(IGNORE_CONTENT_READERS_DIRECTIVE));
            this.ignoreImportProviders = new HashSet<String>(Arrays.asList(StringUtils.split((String)ignoreImportProvidersString, (String)",")));
        } else {
            this.overwrite = false;
            this.ignoreImportProviders = Collections.emptySet();
        }
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public Set<String> getIgnoreImportProviders() {
        return this.ignoreImportProviders;
    }
}

