/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue.impl;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.queue.OffsetQueue;
import org.apache.sling.distribution.journal.queue.impl.EntryUtil;
import org.apache.sling.distribution.journal.queue.impl.QueueEntryFactory;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueState;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.DistributionQueueType;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PubErrQueue
implements DistributionQueue {
    private static final String UNSUPPORTED_CLEAR_OPERATION = "Unsupported clear operation";
    private static final Logger LOG = LoggerFactory.getLogger(PubErrQueue.class);
    private final OffsetQueue<DistributionQueueItem> agentQueue;
    private final QueueEntryFactory entryFactory;
    private final OffsetQueue<Long> errorQueue;
    private final String queueName;

    public PubErrQueue(String queueName, OffsetQueue<DistributionQueueItem> agentQueue, OffsetQueue<Long> errorQueue) {
        this.queueName = Objects.requireNonNull(queueName);
        this.agentQueue = Objects.requireNonNull(agentQueue);
        this.errorQueue = Objects.requireNonNull(errorQueue);
        this.entryFactory = new QueueEntryFactory(queueName, queueItem -> 0, queueItem -> null);
    }

    @Nonnull
    public String getName() {
        return this.queueName;
    }

    public DistributionQueueEntry add(@Nonnull DistributionQueueItem distributionQueueItem) {
        throw new UnsupportedOperationException("Unsupported add operation");
    }

    public DistributionQueueEntry getHead() {
        Long refOffset = this.errorQueue.getHeadItem();
        if (refOffset != null) {
            DistributionQueueItem queueItem = this.agentQueue.getItem(refOffset);
            return this.entryFactory.create(queueItem);
        }
        return null;
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> getEntries(int skip, int limit) {
        ArrayList<DistributionQueueEntry> entries = new ArrayList<DistributionQueueEntry>();
        for (long refOffset : this.errorQueue.getHeadItems(skip, limit)) {
            DistributionQueueItem queueItem = this.agentQueue.getItem(refOffset);
            if (queueItem != null) {
                entries.add(this.entryFactory.create(queueItem));
                continue;
            }
            LOG.warn("queueItem at offset {} not found", (Object)refOffset);
        }
        return entries;
    }

    public DistributionQueueEntry getEntry(@Nonnull String entryId) {
        try {
            DistributionQueueItem queueItem = this.agentQueue.getItem(EntryUtil.entryOffset(entryId));
            return queueItem != null ? this.entryFactory.create(queueItem) : null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public DistributionQueueEntry remove(@Nonnull String entryId) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> remove(Set<String> entryIds) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public Iterable<DistributionQueueEntry> clear(int limit) {
        throw new UnsupportedOperationException(UNSUPPORTED_CLEAR_OPERATION);
    }

    @Nonnull
    public DistributionQueueStatus getStatus() {
        return new DistributionQueueStatus(this.errorQueue.getSize(), DistributionQueueState.PASSIVE);
    }

    @Nonnull
    public DistributionQueueType getType() {
        return DistributionQueueType.ORDERED;
    }

    public boolean hasCapability(String capability) {
        return false;
    }
}

