/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.DistributionEventDistributeDistributionTrigger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionTrigger.class}, property={"webconsole.configurationFactory.nameHint=Trigger name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class DistributionEventDistributeDistributionTriggerFactory
implements DistributionTrigger {
    private DistributionEventDistributeDistributionTrigger trigger;

    @Activate
    public void activate(BundleContext bundleContext, Config conf) {
        String path = conf.path();
        this.trigger = new DistributionEventDistributeDistributionTrigger(path, bundleContext);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Trigger - Distribution Event Triggers Factory")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the trigger.")
        public String name();

        @AttributeDefinition(name="Path", description="The path for which the distribution events will be forwarded.")
        public String path();
    }
}

