/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.shenyu.v24x.util;

import java.util.Objects;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.adapter.DefaultServerWebExchange;

public class CommonUtil {
    public static EnhancedInstance getEnhancedServerWebExchange(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof DefaultServerWebExchange) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return CommonUtil.getEnhancedServerWebExchange(delegate);
        }
        return instance;
    }

    public static void createLocalSpan(Object[] allArguments, String localOp) {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        EnhancedInstance enhancedInstance = CommonUtil.getEnhancedServerWebExchange(allArguments[0]);
        AbstractSpan span = ContextManager.createLocalSpan((String)localOp);
        span.setComponent((Component)ComponentsDefine.APACHE_SHENYU);
        SpanLayer.asRPCFramework((AbstractSpan)span);
        if (enhancedInstance != null && enhancedInstance.getSkyWalkingDynamicField() != null) {
            ContextManager.continued((ContextSnapshot)((ContextSnapshot)enhancedInstance.getSkyWalkingDynamicField()));
        }
        exchange.getAttributes().put("PROXY_RPC_SPAN", span);
    }

    public static Object stopLocalSpan(Object[] allArguments, Object ret) {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        AbstractSpan span = (AbstractSpan)exchange.getAttributes().get("PROXY_RPC_SPAN");
        if (Objects.isNull(span)) {
            return ret;
        }
        Optional.ofNullable(exchange.getResponse().getStatusCode()).ifPresent(httpStatus -> {
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(httpStatus.value()));
            if (httpStatus.isError()) {
                span.errorOccurred();
            }
        });
        ContextManager.stopSpan((AbstractSpan)span);
        return ret;
    }

    public static void logErrorLocalSpan(Object[] allArguments, Throwable t) {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        AbstractSpan span = (AbstractSpan)exchange.getAttributes().get("PROXY_RPC_SPAN");
        if (Objects.isNull(span)) {
            return;
        }
        span.errorOccurred().log(t);
    }
}

