/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.language.Argument;
import graphql.language.AstTransformer;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.idl.TypeInfo;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

@PublicApi
public class AstSorter {
    public <T extends Node> T sort(T nodeToBeSorted) {
        NodeVisitorStub visitor = new NodeVisitorStub(){

            @Override
            public TraversalControl visitDocument(Document node, TraverserContext<Node> context) {
                Document changedNode = node.transform(builder -> {
                    List<Definition> definitions = AstSorter.this.sort(node.getDefinitions(), AstSorter.this.comparingDefinitions());
                    builder.definitions(definitions);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitOperationDefinition(OperationDefinition node, TraverserContext<Node> context) {
                OperationDefinition changedNode = node.transform(builder -> {
                    builder.variableDefinitions(AstSorter.this.sort(node.getVariableDefinitions(), AstSorter.this.comparing(VariableDefinition::getName)));
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.selectionSet(AstSorter.this.sortSelectionSet(node.getSelectionSet()));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitField(Field node, TraverserContext<Node> context) {
                Field changedNode = node.transform(builder -> {
                    builder.arguments(AstSorter.this.sort(node.getArguments(), AstSorter.this.comparing(Argument::getName)));
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.selectionSet(AstSorter.this.sortSelectionSet(node.getSelectionSet()));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitFragmentDefinition(FragmentDefinition node, TraverserContext<Node> context) {
                FragmentDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.selectionSet(AstSorter.this.sortSelectionSet(node.getSelectionSet()));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitInlineFragment(InlineFragment node, TraverserContext<Node> context) {
                InlineFragment changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.selectionSet(AstSorter.this.sortSelectionSet(node.getSelectionSet()));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitFragmentSpread(FragmentSpread node, TraverserContext<Node> context) {
                FragmentSpread changedNode = node.transform(builder -> {
                    List<Directive> directives = AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName));
                    builder.directives((List)directives);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitDirective(Directive node, TraverserContext<Node> context) {
                Directive changedNode = node.transform(builder -> {
                    List<Argument> arguments = AstSorter.this.sort(node.getArguments(), AstSorter.this.comparing(Argument::getName));
                    builder.arguments(arguments);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitObjectValue(ObjectValue node, TraverserContext<Node> context) {
                ObjectValue changedNode = node.transform(builder -> {
                    List<ObjectField> objectFields = AstSorter.this.sort(node.getObjectFields(), AstSorter.this.comparing(ObjectField::getName));
                    builder.objectFields(objectFields);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitSchemaDefinition(SchemaDefinition node, TraverserContext<Node> context) {
                SchemaDefinition changedNode = node.transform(builder -> {
                    builder.directives(AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.operationTypeDefinitions(AstSorter.this.sort(node.getOperationTypeDefinitions(), AstSorter.this.comparing(OperationTypeDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitEnumTypeDefinition(EnumTypeDefinition node, TraverserContext<Node> context) {
                EnumTypeDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.enumValueDefinitions(AstSorter.this.sort(node.getEnumValueDefinitions(), AstSorter.this.comparing(EnumValueDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitScalarTypeDefinition(ScalarTypeDefinition node, TraverserContext<Node> context) {
                ScalarTypeDefinition changedNode = node.transform(builder -> {
                    List<Directive> directives = AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName));
                    builder.directives((List)directives);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitInputObjectTypeDefinition(InputObjectTypeDefinition node, TraverserContext<Node> context) {
                InputObjectTypeDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.inputValueDefinitions(AstSorter.this.sort(node.getInputValueDefinitions(), AstSorter.this.comparing(InputValueDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitObjectTypeDefinition(ObjectTypeDefinition node, TraverserContext<Node> context) {
                ObjectTypeDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.implementz(AstSorter.this.sort(node.getImplements(), AstSorter.this.comparingTypes()));
                    builder.fieldDefinitions(AstSorter.this.sort(node.getFieldDefinitions(), AstSorter.this.comparing(FieldDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitInterfaceTypeDefinition(InterfaceTypeDefinition node, TraverserContext<Node> context) {
                InterfaceTypeDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.implementz(AstSorter.this.sort(node.getImplements(), AstSorter.this.comparingTypes()));
                    builder.definitions(AstSorter.this.sort(node.getFieldDefinitions(), AstSorter.this.comparing(FieldDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitUnionTypeDefinition(UnionTypeDefinition node, TraverserContext<Node> context) {
                UnionTypeDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.memberTypes(AstSorter.this.sort(node.getMemberTypes(), AstSorter.this.comparingTypes()));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitFieldDefinition(FieldDefinition node, TraverserContext<Node> context) {
                FieldDefinition changedNode = node.transform(builder -> {
                    builder.directives((List)AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName)));
                    builder.inputValueDefinitions(AstSorter.this.sort(node.getInputValueDefinitions(), AstSorter.this.comparing(InputValueDefinition::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitInputValueDefinition(InputValueDefinition node, TraverserContext<Node> context) {
                InputValueDefinition changedNode = node.transform(builder -> {
                    List<Directive> directives = AstSorter.this.sort(node.getDirectives(), AstSorter.this.comparing(Directive::getName));
                    builder.directives((List)directives);
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }

            @Override
            public TraversalControl visitDirectiveDefinition(DirectiveDefinition node, TraverserContext<Node> context) {
                DirectiveDefinition changedNode = node.transform(builder -> {
                    builder.inputValueDefinitions(AstSorter.this.sort(node.getInputValueDefinitions(), AstSorter.this.comparing(InputValueDefinition::getName)));
                    builder.directiveLocations(AstSorter.this.sort(node.getDirectiveLocations(), AstSorter.this.comparing(DirectiveLocation::getName)));
                });
                return TreeTransformerUtil.changeNode(context, changedNode);
            }
        };
        AstTransformer astTransformer = new AstTransformer();
        Node newDoc = astTransformer.transform(nodeToBeSorted, visitor);
        return (T)newDoc;
    }

    private Comparator<Type> comparingTypes() {
        return this.comparing(type -> TypeInfo.typeInfo(type).getName());
    }

    private Comparator<Selection> comparingSelections() {
        Function<Selection, String> byName = s -> {
            if (s instanceof FragmentSpread) {
                return ((FragmentSpread)s).getName();
            }
            if (s instanceof Field) {
                return ((Field)s).getName();
            }
            if (s instanceof InlineFragment) {
                TypeName typeCondition = ((InlineFragment)s).getTypeCondition();
                return typeCondition == null ? "" : typeCondition.getName();
            }
            return "";
        };
        Function<Selection, Integer> byType = s -> {
            if (s instanceof Field) {
                return 1;
            }
            if (s instanceof FragmentSpread) {
                return 2;
            }
            if (s instanceof InlineFragment) {
                return 3;
            }
            return 4;
        };
        return this.comparing(byType).thenComparing(this.comparing(byName));
    }

    private Comparator<Definition> comparingDefinitions() {
        Function<Definition, String> byName = d -> {
            if (d instanceof OperationDefinition) {
                String name = ((OperationDefinition)d).getName();
                return name == null ? "" : name;
            }
            if (d instanceof FragmentDefinition) {
                return ((FragmentDefinition)d).getName();
            }
            if (d instanceof DirectiveDefinition) {
                return ((DirectiveDefinition)d).getName();
            }
            if (d instanceof TypeDefinition) {
                return ((TypeDefinition)d).getName();
            }
            return "";
        };
        Function<Definition, Integer> byType = d -> {
            if (d instanceof OperationDefinition) {
                OperationDefinition.Operation operation = ((OperationDefinition)d).getOperation();
                if (OperationDefinition.Operation.QUERY == operation || operation == null) {
                    return 101;
                }
                if (OperationDefinition.Operation.MUTATION == operation) {
                    return 102;
                }
                if (OperationDefinition.Operation.SUBSCRIPTION == operation) {
                    return 104;
                }
                return 100;
            }
            if (d instanceof FragmentDefinition) {
                return 200;
            }
            if (d instanceof DirectiveDefinition) {
                return 300;
            }
            if (d instanceof SchemaDefinition) {
                return 400;
            }
            if (d instanceof TypeDefinition) {
                if (d instanceof ObjectTypeDefinition) {
                    return 501;
                }
                if (d instanceof InterfaceTypeDefinition) {
                    return 502;
                }
                if (d instanceof UnionTypeDefinition) {
                    return 503;
                }
                if (d instanceof EnumTypeDefinition) {
                    return 504;
                }
                if (d instanceof ScalarTypeDefinition) {
                    return 505;
                }
                if (d instanceof InputObjectTypeDefinition) {
                    return 506;
                }
                return 500;
            }
            return -1;
        };
        return this.comparing(byType).thenComparing(byName);
    }

    private SelectionSet sortSelectionSet(SelectionSet selectionSet) {
        if (selectionSet == null) {
            return null;
        }
        List<Selection> selections = this.sort(selectionSet.getSelections(), this.comparingSelections());
        return selectionSet.transform(builder -> builder.selections(selections));
    }

    private <T> List<T> sort(List<T> items, Comparator<T> comparing) {
        items = new ArrayList<T>(items);
        items.sort(comparing);
        return items;
    }

    private <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> keyExtractor) {
        return Comparator.comparing(keyExtractor, Comparator.nullsLast(Comparator.naturalOrder()));
    }
}

