/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.istio;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntry;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntrySpec;
import io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.skywalking.library.kubernetes.IstioServiceEntries;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.ServiceNameFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IstioServiceEntryRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IstioServiceEntryRegistry.class);
    protected final EnvoyMetricReceiverConfig config;
    protected final ServiceNameFormatter serviceNameFormatter;
    protected final LoadingCache<String, ServiceMetaInfo> ipServiceMetaInfoMap;
    protected final Map<String, DnsAddressEndpointGroup> hostnameResolvers = new ConcurrentHashMap<String, DnsAddressEndpointGroup>();

    public IstioServiceEntryRegistry(final EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceNameFormatter = new ServiceNameFormatter(config.getIstioServiceNameRule());
        final Set<String> ignoredNamespaces = config.getIstioServiceEntryIgnoredNamespaces();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L));
        this.ipServiceMetaInfoMap = cacheBuilder.build((CacheLoader)new CacheLoader<String, ServiceMetaInfo>(){

            public ServiceMetaInfo load(String ip) {
                Optional<ServiceEntry> serviceEntry = IstioServiceEntries.INSTANCE.list().parallelStream().filter(se -> se.getMetadata() != null).filter(se -> se.getSpec() != null).filter(se -> !ignoredNamespaces.contains(se.getMetadata().getNamespace())).filter(se -> {
                    ServiceEntrySpec spec = se.getSpec();
                    if (spec.getResolution() == null) {
                        log.debug("Unsupported service entry resolution: {}", (Object)spec.getResolution());
                        return false;
                    }
                    switch (spec.getResolution()) {
                        case STATIC: {
                            return spec.getAddresses().parallelStream().anyMatch(address -> {
                                if (address.contains("/")) {
                                    SubnetUtils subnet = new SubnetUtils(address);
                                    return subnet.getInfo().isInRange(ip);
                                }
                                return Objects.equals(ip, address);
                            }) || spec.getEndpoints().parallelStream().map(WorkloadEntrySpec::getAddress).anyMatch(address -> Objects.equals(address, ip));
                        }
                        case DNS: 
                        case DNS_ROUND_ROBIN: {
                            return spec.getHosts().parallelStream().map(host -> IstioServiceEntryRegistry.this.hostnameResolvers.computeIfAbsent((String)host, it -> ((DnsAddressEndpointGroupBuilder)DnsAddressEndpointGroup.builder((String)it).backoff(Backoff.exponential((long)1000L, (long)32000L).withJitter(0.2).withMaxAttempts(3))).build())).anyMatch(dnsAddressEndpointGroup -> {
                                if (dnsAddressEndpointGroup.whenReady().isDone()) {
                                    return dnsAddressEndpointGroup.endpoints().parallelStream().anyMatch(endpoint -> Objects.equals(endpoint.ipAddr(), ip));
                                }
                                return false;
                            });
                        }
                    }
                    log.debug("Unsupported service entry resolution: {}", (Object)spec.getResolution());
                    return false;
                }).findFirst();
                if (serviceEntry.isEmpty()) {
                    log.debug("No corresponding service entry for IP: {}", (Object)ip);
                    return config.serviceMetaInfoFactory().unknown();
                }
                log.debug("Composing service meta info from service entry for IP: {}", (Object)ip);
                return IstioServiceEntryRegistry.this.composeServiceMetaInfo(serviceEntry.get(), ip);
            }
        });
    }

    protected List<ServiceMetaInfo.KeyValue> transformLabelsToTags(ObjectMeta serviceEntryMeta) {
        Map labels = serviceEntryMeta.getLabels();
        ArrayList<ServiceMetaInfo.KeyValue> tags = new ArrayList<ServiceMetaInfo.KeyValue>();
        tags.add(new ServiceMetaInfo.KeyValue("namespace", serviceEntryMeta.getNamespace()));
        if (Objects.isNull(labels)) {
            return tags;
        }
        return labels.entrySet().stream().map(each -> new ServiceMetaInfo.KeyValue((String)each.getKey(), (String)each.getValue())).collect(Collectors.toCollection(() -> tags));
    }

    public ServiceMetaInfo findService(String ip) {
        return (ServiceMetaInfo)this.ipServiceMetaInfoMap.get((Object)ip);
    }

    protected ServiceMetaInfo composeServiceMetaInfo(ServiceEntry serviceEntry, String ip) {
        ImmutableMap context = ImmutableMap.of((Object)"serviceEntry", (Object)serviceEntry);
        ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo();
        try {
            serviceMetaInfo.setServiceName(this.serviceNameFormatter.format((Map<String, Object>)context));
        }
        catch (Exception e) {
            log.error("Failed to evaluate serviceEntry name.", (Throwable)e);
            ObjectMeta serviceMetadata = serviceEntry.getMetadata();
            if (Objects.isNull(serviceMetadata)) {
                log.warn("Service metadata is null, {}", (Object)serviceEntry);
                return this.config.serviceMetaInfoFactory().unknown();
            }
            serviceMetaInfo.setServiceName(serviceMetadata.getName());
        }
        serviceMetaInfo.setTags(this.transformLabelsToTags(serviceEntry.getMetadata()));
        serviceMetaInfo.setServiceInstanceName(ip);
        return serviceMetaInfo;
    }
}

