/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium.handler;

import com.google.protobuf.util.Timestamps;
import io.cilium.api.flow.DNS;
import io.cilium.api.flow.Endpoint;
import io.cilium.api.flow.Flow;
import io.cilium.api.flow.HTTP;
import io.cilium.api.flow.Kafka;
import io.cilium.api.flow.L7FlowType;
import io.cilium.api.flow.TrafficDirection;
import io.cilium.api.flow.Verdict;
import io.cilium.api.observer.GetFlowsRequest;
import io.cilium.api.observer.ObserverGrpc;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.source.CiliumEndpoint;
import org.apache.skywalking.oap.server.core.source.CiliumEndpointRelation;
import org.apache.skywalking.oap.server.core.source.CiliumMetrics;
import org.apache.skywalking.oap.server.core.source.CiliumService;
import org.apache.skywalking.oap.server.core.source.CiliumServiceInstance;
import org.apache.skywalking.oap.server.core.source.CiliumServiceInstanceRelation;
import org.apache.skywalking.oap.server.core.source.CiliumServiceRelation;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumFetcherConfig;
import org.apache.skywalking.oap.server.fetcher.cilium.ExcludeRules;
import org.apache.skywalking.oap.server.fetcher.cilium.handler.DNSCodes;
import org.apache.skywalking.oap.server.fetcher.cilium.handler.KafkaCodes;
import org.apache.skywalking.oap.server.fetcher.cilium.handler.ServiceMetadata;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.CiliumNode;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.CiliumNodeUpdateListener;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiliumFlowListener
implements CiliumNodeUpdateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CiliumFlowListener.class);
    private static final Executor EXECUTOR = Executors.newCachedThreadPool();
    private final SourceReceiver sourceReceiver;
    private final Integer retrySecond;
    private final boolean convertClientAsServerTraffic;
    private final ExcludeRules excludeRules;
    public static final Layer SERVICE_LAYER = Layer.CILIUM_SERVICE;

    public CiliumFlowListener(ModuleManager moduleManager, CiliumFetcherConfig config, ExcludeRules excludeRules) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.retrySecond = config.getFetchFailureRetrySecond();
        this.convertClientAsServerTraffic = config.isConvertClientAsServerTraffic();
        this.excludeRules = excludeRules;
    }

    @Override
    public void onNodeAdded(CiliumNode node) {
        String address = node.getAddress();
        EXECUTOR.execute((Runnable)new RunnableWithExceptionProtection(() -> {
            ObserverGrpc.ObserverBlockingStub stub = node.getObserverStub();
            if (stub == null) {
                return;
            }
            Iterator flows = stub.getFlows(GetFlowsRequest.newBuilder().setSince(Timestamps.now()).setFollow(true).build());
            Thread thread = Thread.currentThread();
            node.addingCloseable(thread::interrupt);
            flows.forEachRemaining(flow -> {
                switch (flow.getResponseTypesCase()) {
                    case FLOW: {
                        log.debug("Detect flow data: address: {}, flow: {}", (Object)address, (Object)flow.getFlow());
                        this.handleFlow(node, flow.getFlow());
                        break;
                    }
                    case LOST_EVENTS: {
                        log.warn("Detected lost events, address: {}, events: {}", (Object)address, (Object)flow.getLostEvents());
                        break;
                    }
                    case NODE_STATUS: {
                        log.debug("Detected node status, address: {}, status: {}", (Object)address, (Object)flow.getNodeStatus());
                    }
                }
            });
        }, t -> {
            if (t instanceof InterruptedException || t.getCause() != null && t.getCause() instanceof InterruptedException) {
                log.debug("detected the node have been closed: {}, stopping to get flows", (Object)node.getAddress());
                return;
            }
            log.error("Failed to fetch flows from Cilium node: {}, will retry after {} seconds.", new Object[]{node.getAddress(), this.retrySecond, t});
            try {
                TimeUnit.SECONDS.sleep(this.retrySecond.intValue());
            }
            catch (InterruptedException e) {
                log.error("Failed to sleep for {} seconds.", (Object)this.retrySecond, (Object)e);
                return;
            }
            this.onNodeAdded(node);
        }));
    }

    @Override
    public void onNodeDelete(CiliumNode node) {
    }

    protected void handleFlow(CiliumNode node, Flow flow) {
        if (this.shouldIgnoreFlow(node, flow)) {
            return;
        }
        flow = this.convertTraffic(node, flow);
        ServiceMetadata sourceMetadata = new ServiceMetadata(flow.getSource());
        ServiceMetadata destMetadata = new ServiceMetadata(flow.getDestination());
        DetectPoint detectPoint = this.parseDetectPoint(flow);
        if (this.convertClientAsServerTraffic) {
            detectPoint = DetectPoint.SERVER;
        }
        log.debug("ready to building cilium traffic from {}{} -> {}{}, flow: {}, type: {}", new Object[]{detectPoint.equals((Object)DetectPoint.CLIENT) ? "*" : "", sourceMetadata.getServiceName(), detectPoint.equals((Object)DetectPoint.SERVER) ? "*" : "", destMetadata.getServiceName(), this.parseDirectionString(flow), flow.getType()});
        switch (flow.getType()) {
            case L3_L4: {
                this.buildL34Metrics(node, flow, sourceMetadata, destMetadata, detectPoint);
                break;
            }
            case L7: {
                this.buildL7Metrics(node, flow, sourceMetadata, destMetadata, detectPoint);
            }
        }
    }

    protected Flow convertTraffic(CiliumNode node, Flow flow) {
        Flow.Builder builder = flow.toBuilder();
        if (flow.getIsReply().getValue()) {
            builder.setTrafficDirection(this.convertDirection(flow.getTrafficDirection()));
            Endpoint source = flow.getSource();
            Endpoint dest = flow.getDestination();
            builder.setSource(dest);
            builder.setDestination(source);
        }
        if (this.convertClientAsServerTraffic) {
            builder.setTrafficDirection(this.convertDirection(builder.getTrafficDirection()));
        }
        return builder.build();
    }

    protected TrafficDirection convertDirection(TrafficDirection direction) {
        switch (direction) {
            case INGRESS: {
                return TrafficDirection.EGRESS;
            }
            case EGRESS: {
                return TrafficDirection.INGRESS;
            }
        }
        return direction;
    }

    private void buildL34Metrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint) {
        ServiceMetadata currentService = detectPoint.equals((Object)DetectPoint.CLIENT) ? sourceMetadata : destMetadata;
        List<CiliumMetrics> metrics = Arrays.asList(this.buildService(node, flow, currentService, detectPoint), this.buildServiceRelation(node, flow, sourceMetadata, destMetadata, detectPoint), this.buildServiceInstance(node, flow, currentService, detectPoint), this.buildServiceInstanceRelation(node, flow, sourceMetadata, destMetadata, detectPoint));
        metrics.forEach(metric -> {
            this.setBasicInfo((CiliumMetrics)metric, flow, "tcp");
            this.sourceReceiver.receive((ISource)metric);
        });
    }

    private void buildL7Metrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint) {
        switch (flow.getL7().getRecordCase()) {
            case HTTP: {
                this.buildHttpMetrics(node, flow, sourceMetadata, destMetadata, detectPoint, flow.getL7().getHttp());
                break;
            }
            case DNS: {
                this.buildDnsMetrics(node, flow, sourceMetadata, destMetadata, detectPoint, flow.getL7().getDns());
                break;
            }
            case KAFKA: {
                this.buildKafkaMetrics(node, flow, sourceMetadata, destMetadata, detectPoint, flow.getL7().getKafka());
            }
        }
    }

    private void buildKafkaMetrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint, Kafka kafka) {
        if (flow.getL7().getType() != L7FlowType.RESPONSE) {
            return;
        }
        boolean success = kafka.getErrorCode() == 0;
        String endpoint = "Kafka/" + kafka.getTopic() + "/" + kafka.getApiKey();
        List<CiliumMetrics> metrics = this.buildingL7Metrics(node, flow, sourceMetadata, destMetadata, detectPoint, endpoint);
        metrics.stream().filter(Objects::nonNull).forEach(metric -> {
            this.setBasicInfo((CiliumMetrics)metric, flow, "kafka");
            metric.setSuccess(success);
            metric.setDuration(flow.getL7().getLatencyNs());
            metric.setKafka(new CiliumMetrics.KafkaMetrics());
            metric.getKafka().setErrorCode(kafka.getErrorCode());
            metric.getKafka().setErrorCodeString(KafkaCodes.ERROR_CODES.getOrDefault(kafka.getErrorCode(), "UNKNOWN"));
            metric.getKafka().setApiVersion(kafka.getApiVersion());
            metric.getKafka().setApiKey(kafka.getApiKey());
            metric.getKafka().setCorrelationId(kafka.getCorrelationId());
            metric.getKafka().setTopic(kafka.getTopic());
            this.sourceReceiver.receive((ISource)metric);
        });
    }

    private void buildDnsMetrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint, DNS dns) {
        if (flow.getL7().getType() != L7FlowType.RESPONSE) {
            return;
        }
        boolean success = dns.getRcode() == 0;
        String endpoint = "DNS/" + (dns.getQtypesCount() > 0 ? (String)dns.getQtypesList().get(0) : "UNKNOWN");
        List<CiliumMetrics> metrics = this.buildingL7Metrics(node, flow, sourceMetadata, destMetadata, detectPoint, endpoint);
        metrics.stream().filter(Objects::nonNull).forEach(metric -> {
            this.setBasicInfo((CiliumMetrics)metric, flow, "dns");
            metric.setSuccess(success);
            metric.setDuration(flow.getL7().getLatencyNs());
            metric.setDns(new CiliumMetrics.DNSMetrics());
            metric.getDns().setDomain(dns.getQuery());
            metric.getDns().setQueryType(dns.getQtypesCount() > 0 ? (String)dns.getQtypesList().get(0) : "UNKNOWN");
            metric.getDns().setRcode(dns.getRcode());
            metric.getDns().setRcodeString(DNSCodes.RETURN_CODES.getOrDefault(dns.getRcode(), "UNKNOWN"));
            metric.getDns().setTtl(dns.getTtl());
            metric.getDns().setIpCount(dns.getIpsCount());
            this.sourceReceiver.receive((ISource)metric);
        });
    }

    private void buildHttpMetrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint, HTTP http) {
        URL url;
        if (http.getCode() == 0) {
            return;
        }
        try {
            url = new URL(http.getUrl());
        }
        catch (MalformedURLException e) {
            log.warn("Failed to parse the URL: {} from {} -> {}", new Object[]{http.getUrl(), sourceMetadata.getServiceInstanceName(), destMetadata.getServiceInstanceName(), e});
            return;
        }
        String endpointName = http.getMethod() + ":" + url.getPath();
        boolean httpSuccess = this.parseHTTPSuccess(flow, http);
        List<CiliumMetrics> metrics = this.buildingL7Metrics(node, flow, sourceMetadata, destMetadata, detectPoint, endpointName);
        metrics.stream().filter(Objects::nonNull).forEach(metric -> {
            this.setBasicInfo((CiliumMetrics)metric, flow, "http");
            metric.setSuccess(httpSuccess);
            metric.setDuration(flow.getL7().getLatencyNs());
            metric.setHttp(new CiliumMetrics.HTTPMetrics());
            metric.getHttp().setUrl(http.getUrl());
            metric.getHttp().setCode(http.getCode());
            metric.getHttp().setProtocol(http.getProtocol());
            metric.getHttp().setMethod(http.getMethod());
            this.sourceReceiver.receive((ISource)metric);
        });
    }

    private List<CiliumMetrics> buildingL7Metrics(CiliumNode node, Flow flow, ServiceMetadata sourceMetadata, ServiceMetadata destMetadata, DetectPoint detectPoint, String endpointName) {
        ServiceMetadata currentService = detectPoint.equals((Object)DetectPoint.CLIENT) ? sourceMetadata : destMetadata;
        return Arrays.asList(this.buildService(node, flow, currentService, detectPoint), this.buildServiceRelation(node, flow, sourceMetadata, destMetadata, detectPoint), this.buildServiceInstance(node, flow, currentService, detectPoint), this.buildServiceInstanceRelation(node, flow, sourceMetadata, destMetadata, detectPoint), this.buildEndpoint(node, flow, currentService, endpointName, detectPoint), this.buildEndpointRelation(node, flow, sourceMetadata, destMetadata, detectPoint, endpointName));
    }

    private void setBasicInfo(CiliumMetrics metric, Flow flow, String type) {
        metric.setVerdict(this.parseVerdictString(flow));
        metric.setType(type);
        metric.setDirection(this.parseDirectionString(flow));
        metric.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)(flow.getTime().getSeconds() * 1000L)));
        if (Verdict.DROPPED.equals((Object)flow.getVerdict())) {
            metric.setDropReason(flow.getDropReasonDesc().toString());
        }
    }

    protected boolean shouldIgnoreEndpoint(Endpoint endpoint) {
        if (endpoint.getID() != 0) {
            return false;
        }
        return StringUtil.isEmpty((String)endpoint.getPodName()) || StringUtil.isEmpty((String)endpoint.getNamespace());
    }

    protected boolean shouldIgnoreFlow(CiliumNode node, Flow flow) {
        if (!flow.hasSource() || !flow.hasDestination()) {
            return true;
        }
        if (this.shouldIgnoreEndpoint(flow.getSource()) || this.shouldIgnoreEndpoint(flow.getDestination())) {
            return true;
        }
        switch (flow.getVerdict()) {
            case FORWARDED: 
            case DROPPED: {
                break;
            }
            default: {
                return true;
            }
        }
        if (flow.getTrafficDirection() == TrafficDirection.TRAFFIC_DIRECTION_UNKNOWN) {
            return true;
        }
        switch (flow.getType()) {
            case L3_L4: 
            case L7: {
                break;
            }
            default: {
                return true;
            }
        }
        if (this.convertClientAsServerTraffic && DetectPoint.SERVER.equals((Object)this.parseDetectPoint(flow))) {
            return true;
        }
        return this.excludeRules.shouldExclude(flow.getSource()) && this.excludeRules.shouldExclude(flow.getDestination());
    }

    private String parseVerdictString(Flow flow) {
        switch (flow.getVerdict()) {
            case FORWARDED: {
                return "forwarded";
            }
            case DROPPED: {
                return "dropped";
            }
        }
        return "";
    }

    private String parseDirectionString(Flow flow) {
        switch (flow.getTrafficDirection()) {
            case INGRESS: {
                return "ingress";
            }
            case EGRESS: {
                return "egress";
            }
        }
        return "";
    }

    protected CiliumMetrics buildService(CiliumNode node, Flow flow, ServiceMetadata metadata, DetectPoint detectPoint) {
        CiliumService service = new CiliumService();
        service.setServiceName(metadata.getServiceName());
        service.setLayer(SERVICE_LAYER);
        service.setDetectPoint(detectPoint);
        return service;
    }

    protected CiliumMetrics buildServiceRelation(CiliumNode node, Flow flow, ServiceMetadata source, ServiceMetadata dest, DetectPoint detectPoint) {
        CiliumServiceRelation serviceRelation = new CiliumServiceRelation();
        serviceRelation.setSourceServiceName(source.getServiceName());
        serviceRelation.setSourceLayer(SERVICE_LAYER);
        serviceRelation.setDestServiceName(dest.getServiceName());
        serviceRelation.setDestLayer(SERVICE_LAYER);
        serviceRelation.setDetectPoint(detectPoint);
        serviceRelation.setComponentId(this.parseComponentId(flow));
        return serviceRelation;
    }

    protected CiliumMetrics buildServiceInstance(CiliumNode node, Flow flow, ServiceMetadata metadata, DetectPoint detectPoint) {
        CiliumServiceInstance serviceInstance = new CiliumServiceInstance();
        serviceInstance.setServiceName(metadata.getServiceName());
        serviceInstance.setServiceInstanceName(metadata.getServiceInstanceName());
        serviceInstance.setLayer(SERVICE_LAYER);
        serviceInstance.setDetectPoint(detectPoint);
        return serviceInstance;
    }

    protected CiliumMetrics buildServiceInstanceRelation(CiliumNode node, Flow flow, ServiceMetadata source, ServiceMetadata dest, DetectPoint detectPoint) {
        CiliumServiceInstanceRelation serviceInstanceRelation = new CiliumServiceInstanceRelation();
        serviceInstanceRelation.setSourceServiceName(source.getServiceName());
        serviceInstanceRelation.setSourceServiceInstanceName(source.getServiceInstanceName());
        serviceInstanceRelation.setSourceLayer(SERVICE_LAYER);
        serviceInstanceRelation.setDestServiceName(dest.getServiceName());
        serviceInstanceRelation.setDestServiceInstanceName(dest.getServiceInstanceName());
        serviceInstanceRelation.setDestLayer(SERVICE_LAYER);
        serviceInstanceRelation.setDetectPoint(detectPoint);
        serviceInstanceRelation.setComponentId(this.parseComponentId(flow));
        return serviceInstanceRelation;
    }

    protected CiliumMetrics buildEndpoint(CiliumNode node, Flow flow, ServiceMetadata source, String endpointName, DetectPoint detectPoint) {
        if (DetectPoint.CLIENT.equals((Object)detectPoint)) {
            return null;
        }
        CiliumEndpoint endpoint = new CiliumEndpoint();
        endpoint.setServiceName(source.getServiceName());
        endpoint.setEndpointName(endpointName);
        endpoint.setLayer(SERVICE_LAYER);
        return endpoint;
    }

    protected CiliumMetrics buildEndpointRelation(CiliumNode node, Flow flow, ServiceMetadata source, ServiceMetadata dest, DetectPoint detectPoint, String endpointName) {
        CiliumEndpointRelation endpointRelation = new CiliumEndpointRelation();
        endpointRelation.setSourceServiceName(source.getServiceName());
        endpointRelation.setSourceEndpointName(endpointName);
        endpointRelation.setSourceLayer(SERVICE_LAYER);
        endpointRelation.setDestServiceName(dest.getServiceName());
        endpointRelation.setDestEndpointName(endpointName);
        endpointRelation.setDestLayer(SERVICE_LAYER);
        endpointRelation.setDetectPoint(detectPoint);
        return endpointRelation;
    }

    protected boolean parseHTTPSuccess(Flow flow, HTTP http) {
        return http.getCode() < 500;
    }

    private DetectPoint parseDetectPoint(Flow flow) {
        boolean isReply = flow.getIsReply().getValue();
        if (!isReply) {
            return flow.getSource().getID() != 0 ? DetectPoint.CLIENT : DetectPoint.SERVER;
        }
        return flow.getDestination().getID() != 0 ? DetectPoint.CLIENT : DetectPoint.SERVER;
    }

    private int parseComponentId(Flow flow) {
        switch (flow.getType()) {
            case L3_L4: {
                return 110;
            }
            case L7: {
                switch (flow.getL7().getRecordCase()) {
                    case HTTP: {
                        return 49;
                    }
                    case DNS: {
                        return 159;
                    }
                    case KAFKA: {
                        return 27;
                    }
                }
            }
        }
        return 0;
    }
}

