/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium;

import java.io.IOException;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumFetcherConfig;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumFetcherModule;
import org.apache.skywalking.oap.server.fetcher.cilium.CiliumOALDefine;
import org.apache.skywalking.oap.server.fetcher.cilium.ExcludeRules;
import org.apache.skywalking.oap.server.fetcher.cilium.handler.CiliumFlowListener;
import org.apache.skywalking.oap.server.fetcher.cilium.handler.ServiceMetadata;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.CiliumNodeManager;
import org.apache.skywalking.oap.server.fetcher.cilium.nodes.GrpcStubBuilder;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.FieldsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiliumFetcherProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CiliumFetcherProvider.class);
    private CiliumFetcherConfig config;
    protected String excludeRulesFile = "cilium-rules/exclude.yaml";
    protected String fieldMappingFile = "cilium-rules/metadata-service-mapping.yaml";

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return CiliumFetcherModule.class;
    }

    public ModuleProvider.ConfigCreator<CiliumFetcherConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<CiliumFetcherConfig>(){

            public Class<CiliumFetcherConfig> type() {
                return CiliumFetcherConfig.class;
            }

            public void onInitialized(CiliumFetcherConfig initialized) {
                CiliumFetcherProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        ExcludeRules excludeRules;
        ((OALEngineLoaderService)this.getManager().find("core").provider().getService(OALEngineLoaderService.class)).load((OALDefine)CiliumOALDefine.INSTANCE);
        try {
            FieldsHelper.forClass(ServiceMetadata.class).init(this.fieldMappingFile);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        try {
            excludeRules = ExcludeRules.loadRules(this.excludeRulesFile);
        }
        catch (IOException e) {
            throw new ModuleStartException("loading exclude rules error", (Throwable)e);
        }
        CiliumNodeManager ciliumNodeManager = new CiliumNodeManager(this.getManager(), new GrpcStubBuilder(this.config), this.config);
        ciliumNodeManager.addListener(new CiliumFlowListener(this.getManager(), this.config, excludeRules));
        ciliumNodeManager.start();
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"core", "cluster"};
    }
}

