/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl.counter;

import com.google.common.collect.ImmutableMap;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.skywalking.oap.meter.analyzer.dsl.counter.ID;

public class CounterWindow {
    public static final CounterWindow INSTANCE = new CounterWindow();
    private final Map<ID, Tuple2<Long, Double>> lastElementMap = new ConcurrentHashMap<ID, Tuple2<Long, Double>>();
    private final Map<ID, Queue<Tuple2<Long, Double>>> windows = new ConcurrentHashMap<ID, Queue<Tuple2<Long, Double>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple2<Long, Double> increase(String name, ImmutableMap<String, String> labels, Double value, long windowSize, long now) {
        Queue window;
        ID id = new ID(name, labels);
        Queue queue = window = this.windows.computeIfAbsent(id, unused -> new PriorityQueue());
        synchronized (queue) {
            window.offer(Tuple.of((Object)now, (Object)value));
            long waterLevel = now - windowSize;
            Tuple2 peek = (Tuple2)window.peek();
            if ((Long)peek._1 > waterLevel) {
                return peek;
            }
            Tuple2 result = peek;
            while ((Long)peek._1 < waterLevel) {
                result = (Tuple2)window.poll();
                peek = (Tuple2)window.element();
            }
            if (waterLevel - (Long)result._1 <= (Long)peek._1 - waterLevel) {
                return result;
            }
            return peek;
        }
    }

    public Tuple2<Long, Double> pop(String name, ImmutableMap<String, String> labels, Double value, long now) {
        ID id = new ID(name, labels);
        Tuple2 element = Tuple.of((Object)now, (Object)value);
        Tuple2<Long, Double> result = this.lastElementMap.put(id, (Tuple2<Long, Double>)element);
        if (result == null) {
            return element;
        }
        return result;
    }

    public void reset() {
        this.windows.clear();
    }

    @Generated
    private CounterWindow() {
    }

    @Generated
    public String toString() {
        return "CounterWindow(lastElementMap=" + String.valueOf(this.lastElementMap) + ", windows=" + String.valueOf(this.windows) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CounterWindow)) {
            return false;
        }
        CounterWindow other = (CounterWindow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<ID, Tuple2<Long, Double>> this$lastElementMap = this.lastElementMap;
        Map<ID, Tuple2<Long, Double>> other$lastElementMap = other.lastElementMap;
        if (this$lastElementMap == null ? other$lastElementMap != null : !((Object)this$lastElementMap).equals(other$lastElementMap)) {
            return false;
        }
        Map<ID, Queue<Tuple2<Long, Double>>> this$windows = this.windows;
        Map<ID, Queue<Tuple2<Long, Double>>> other$windows = other.windows;
        return !(this$windows == null ? other$windows != null : !((Object)this$windows).equals(other$windows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CounterWindow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ID, Tuple2<Long, Double>> $lastElementMap = this.lastElementMap;
        result = result * 59 + ($lastElementMap == null ? 43 : ((Object)$lastElementMap).hashCode());
        Map<ID, Queue<Tuple2<Long, Double>>> $windows = this.windows;
        result = result * 59 + ($windows == null ? 43 : ((Object)$windows).hashCode());
        return result;
    }
}

