/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter;

import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.meter.ScopeType;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.DetectPoint;

public class MeterEntity {
    private static NamingControl NAMING_CONTROL;
    private ScopeType scopeType;
    private String serviceName;
    private String instanceName;
    private Map<String, String> instanceProperties;
    private String endpointName;
    private String processName;
    private String sourceServiceName;
    private String destServiceName;
    private String sourceProcessId;
    private String destProcessId;
    private DetectPoint detectPoint;
    private Layer layer;
    private int componentId;
    private String attr0;
    private String attr1;
    private String attr2;
    private String attr3;
    private String attr4;
    private String attr5;

    private MeterEntity() {
    }

    public String id() {
        switch (this.scopeType) {
            case SERVICE: {
                return IDManager.ServiceID.buildId(this.serviceName, true);
            }
            case SERVICE_INSTANCE: {
                return IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, true), this.instanceName);
            }
            case ENDPOINT: {
                return IDManager.EndpointID.buildId(IDManager.ServiceID.buildId(this.serviceName, true), this.endpointName);
            }
            case PROCESS: {
                return IDManager.ProcessID.buildId(IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, true), this.instanceName), this.processName);
            }
            case SERVICE_RELATION: {
                return IDManager.ServiceID.buildRelationId(new IDManager.ServiceID.ServiceRelationDefine(this.sourceServiceId(), this.destServiceId()));
            }
            case PROCESS_RELATION: {
                return IDManager.ProcessID.buildRelationId(new IDManager.ProcessID.ProcessRelationDefine(this.sourceProcessId, this.destProcessId));
            }
        }
        throw new UnexpectedException("Unexpected scope type of entity " + this.toString());
    }

    public String serviceId() {
        return IDManager.ServiceID.buildId(this.serviceName, true);
    }

    public String serviceInstanceId() {
        return IDManager.ServiceInstanceID.buildId(this.serviceId(), this.instanceName);
    }

    public String sourceServiceId() {
        return IDManager.ServiceID.buildId(this.sourceServiceName, true);
    }

    public String destServiceId() {
        return IDManager.ServiceID.buildId(this.destServiceName, true);
    }

    public static void setNamingControl(NamingControl namingControl) {
        NAMING_CONTROL = namingControl;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = NAMING_CONTROL.formatServiceName(serviceName);
    }

    public static MeterEntity newService(String serviceName, Layer layer) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.SERVICE;
        meterEntity.serviceName = NAMING_CONTROL.formatServiceName(serviceName);
        meterEntity.layer = layer;
        return meterEntity;
    }

    public static MeterEntity newServiceInstance(String serviceName, String serviceInstance, Layer layer, Map<String, String> properties) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.SERVICE_INSTANCE;
        meterEntity.serviceName = NAMING_CONTROL.formatServiceName(serviceName);
        meterEntity.instanceName = NAMING_CONTROL.formatInstanceName(serviceInstance);
        meterEntity.instanceProperties = properties;
        meterEntity.layer = layer;
        return meterEntity;
    }

    public static MeterEntity newEndpoint(String serviceName, String endpointName, Layer layer) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.ENDPOINT;
        meterEntity.serviceName = NAMING_CONTROL.formatServiceName(serviceName);
        meterEntity.endpointName = NAMING_CONTROL.formatEndpointName(serviceName, endpointName);
        meterEntity.layer = layer;
        return meterEntity;
    }

    public static MeterEntity newProcess(String serviceName, String instanceName, String processName, String layerName) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.PROCESS;
        meterEntity.serviceName = NAMING_CONTROL.formatServiceName(serviceName);
        meterEntity.instanceName = NAMING_CONTROL.formatInstanceName(instanceName);
        meterEntity.processName = processName;
        meterEntity.layer = Layer.nameOf(layerName);
        return meterEntity;
    }

    public static MeterEntity newServiceRelation(String sourceServiceName, String destServiceName, DetectPoint detectPoint, Layer layer, int componentId) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.SERVICE_RELATION;
        meterEntity.sourceServiceName = NAMING_CONTROL.formatServiceName(sourceServiceName);
        meterEntity.destServiceName = NAMING_CONTROL.formatServiceName(destServiceName);
        meterEntity.detectPoint = detectPoint;
        meterEntity.layer = layer;
        meterEntity.componentId = componentId;
        return meterEntity;
    }

    public static MeterEntity newProcessRelation(String serviceName, String instanceName, String sourceProcessId, String destProcessId, int componentId, DetectPoint detectPoint) {
        MeterEntity meterEntity = new MeterEntity();
        meterEntity.scopeType = ScopeType.PROCESS_RELATION;
        meterEntity.serviceName = serviceName;
        meterEntity.instanceName = instanceName;
        meterEntity.sourceProcessId = sourceProcessId;
        meterEntity.destProcessId = destProcessId;
        meterEntity.componentId = componentId;
        meterEntity.detectPoint = detectPoint;
        return meterEntity;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeterEntity)) {
            return false;
        }
        MeterEntity other = (MeterEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getComponentId() != other.getComponentId()) {
            return false;
        }
        ScopeType this$scopeType = this.getScopeType();
        ScopeType other$scopeType = other.getScopeType();
        if (this$scopeType == null ? other$scopeType != null : !((Object)((Object)this$scopeType)).equals((Object)other$scopeType)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$instanceName = this.getInstanceName();
        String other$instanceName = other.getInstanceName();
        if (this$instanceName == null ? other$instanceName != null : !this$instanceName.equals(other$instanceName)) {
            return false;
        }
        Map<String, String> this$instanceProperties = this.getInstanceProperties();
        Map<String, String> other$instanceProperties = other.getInstanceProperties();
        if (this$instanceProperties == null ? other$instanceProperties != null : !((Object)this$instanceProperties).equals(other$instanceProperties)) {
            return false;
        }
        String this$endpointName = this.getEndpointName();
        String other$endpointName = other.getEndpointName();
        if (this$endpointName == null ? other$endpointName != null : !this$endpointName.equals(other$endpointName)) {
            return false;
        }
        String this$processName = this.getProcessName();
        String other$processName = other.getProcessName();
        if (this$processName == null ? other$processName != null : !this$processName.equals(other$processName)) {
            return false;
        }
        String this$sourceServiceName = this.getSourceServiceName();
        String other$sourceServiceName = other.getSourceServiceName();
        if (this$sourceServiceName == null ? other$sourceServiceName != null : !this$sourceServiceName.equals(other$sourceServiceName)) {
            return false;
        }
        String this$destServiceName = this.getDestServiceName();
        String other$destServiceName = other.getDestServiceName();
        if (this$destServiceName == null ? other$destServiceName != null : !this$destServiceName.equals(other$destServiceName)) {
            return false;
        }
        String this$sourceProcessId = this.getSourceProcessId();
        String other$sourceProcessId = other.getSourceProcessId();
        if (this$sourceProcessId == null ? other$sourceProcessId != null : !this$sourceProcessId.equals(other$sourceProcessId)) {
            return false;
        }
        String this$destProcessId = this.getDestProcessId();
        String other$destProcessId = other.getDestProcessId();
        if (this$destProcessId == null ? other$destProcessId != null : !this$destProcessId.equals(other$destProcessId)) {
            return false;
        }
        DetectPoint this$detectPoint = this.getDetectPoint();
        DetectPoint other$detectPoint = other.getDetectPoint();
        if (this$detectPoint == null ? other$detectPoint != null : !((Object)((Object)this$detectPoint)).equals((Object)other$detectPoint)) {
            return false;
        }
        Layer this$layer = this.getLayer();
        Layer other$layer = other.getLayer();
        if (this$layer == null ? other$layer != null : !((Object)((Object)this$layer)).equals((Object)other$layer)) {
            return false;
        }
        String this$attr0 = this.getAttr0();
        String other$attr0 = other.getAttr0();
        if (this$attr0 == null ? other$attr0 != null : !this$attr0.equals(other$attr0)) {
            return false;
        }
        String this$attr1 = this.getAttr1();
        String other$attr1 = other.getAttr1();
        if (this$attr1 == null ? other$attr1 != null : !this$attr1.equals(other$attr1)) {
            return false;
        }
        String this$attr2 = this.getAttr2();
        String other$attr2 = other.getAttr2();
        if (this$attr2 == null ? other$attr2 != null : !this$attr2.equals(other$attr2)) {
            return false;
        }
        String this$attr3 = this.getAttr3();
        String other$attr3 = other.getAttr3();
        if (this$attr3 == null ? other$attr3 != null : !this$attr3.equals(other$attr3)) {
            return false;
        }
        String this$attr4 = this.getAttr4();
        String other$attr4 = other.getAttr4();
        if (this$attr4 == null ? other$attr4 != null : !this$attr4.equals(other$attr4)) {
            return false;
        }
        String this$attr5 = this.getAttr5();
        String other$attr5 = other.getAttr5();
        return !(this$attr5 == null ? other$attr5 != null : !this$attr5.equals(other$attr5));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MeterEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getComponentId();
        ScopeType $scopeType = this.getScopeType();
        result = result * 59 + ($scopeType == null ? 43 : ((Object)((Object)$scopeType)).hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $instanceName = this.getInstanceName();
        result = result * 59 + ($instanceName == null ? 43 : $instanceName.hashCode());
        Map<String, String> $instanceProperties = this.getInstanceProperties();
        result = result * 59 + ($instanceProperties == null ? 43 : ((Object)$instanceProperties).hashCode());
        String $endpointName = this.getEndpointName();
        result = result * 59 + ($endpointName == null ? 43 : $endpointName.hashCode());
        String $processName = this.getProcessName();
        result = result * 59 + ($processName == null ? 43 : $processName.hashCode());
        String $sourceServiceName = this.getSourceServiceName();
        result = result * 59 + ($sourceServiceName == null ? 43 : $sourceServiceName.hashCode());
        String $destServiceName = this.getDestServiceName();
        result = result * 59 + ($destServiceName == null ? 43 : $destServiceName.hashCode());
        String $sourceProcessId = this.getSourceProcessId();
        result = result * 59 + ($sourceProcessId == null ? 43 : $sourceProcessId.hashCode());
        String $destProcessId = this.getDestProcessId();
        result = result * 59 + ($destProcessId == null ? 43 : $destProcessId.hashCode());
        DetectPoint $detectPoint = this.getDetectPoint();
        result = result * 59 + ($detectPoint == null ? 43 : ((Object)((Object)$detectPoint)).hashCode());
        Layer $layer = this.getLayer();
        result = result * 59 + ($layer == null ? 43 : ((Object)((Object)$layer)).hashCode());
        String $attr0 = this.getAttr0();
        result = result * 59 + ($attr0 == null ? 43 : $attr0.hashCode());
        String $attr1 = this.getAttr1();
        result = result * 59 + ($attr1 == null ? 43 : $attr1.hashCode());
        String $attr2 = this.getAttr2();
        result = result * 59 + ($attr2 == null ? 43 : $attr2.hashCode());
        String $attr3 = this.getAttr3();
        result = result * 59 + ($attr3 == null ? 43 : $attr3.hashCode());
        String $attr4 = this.getAttr4();
        result = result * 59 + ($attr4 == null ? 43 : $attr4.hashCode());
        String $attr5 = this.getAttr5();
        result = result * 59 + ($attr5 == null ? 43 : $attr5.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MeterEntity(scopeType=" + String.valueOf((Object)this.getScopeType()) + ", serviceName=" + this.getServiceName() + ", instanceName=" + this.getInstanceName() + ", instanceProperties=" + String.valueOf(this.getInstanceProperties()) + ", endpointName=" + this.getEndpointName() + ", processName=" + this.getProcessName() + ", sourceServiceName=" + this.getSourceServiceName() + ", destServiceName=" + this.getDestServiceName() + ", sourceProcessId=" + this.getSourceProcessId() + ", destProcessId=" + this.getDestProcessId() + ", detectPoint=" + String.valueOf((Object)this.getDetectPoint()) + ", layer=" + String.valueOf((Object)this.getLayer()) + ", componentId=" + this.getComponentId() + ", attr0=" + this.getAttr0() + ", attr1=" + this.getAttr1() + ", attr2=" + this.getAttr2() + ", attr3=" + this.getAttr3() + ", attr4=" + this.getAttr4() + ", attr5=" + this.getAttr5() + ")";
    }

    @Generated
    public ScopeType getScopeType() {
        return this.scopeType;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    @Generated
    public Map<String, String> getInstanceProperties() {
        return this.instanceProperties;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public String getProcessName() {
        return this.processName;
    }

    @Generated
    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public String getSourceProcessId() {
        return this.sourceProcessId;
    }

    @Generated
    public String getDestProcessId() {
        return this.destProcessId;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public String getAttr0() {
        return this.attr0;
    }

    @Generated
    public String getAttr1() {
        return this.attr1;
    }

    @Generated
    public String getAttr2() {
        return this.attr2;
    }

    @Generated
    public String getAttr3() {
        return this.attr3;
    }

    @Generated
    public String getAttr4() {
        return this.attr4;
    }

    @Generated
    public String getAttr5() {
        return this.attr5;
    }

    @Generated
    public void setAttr0(String attr0) {
        this.attr0 = attr0;
    }

    @Generated
    public void setAttr1(String attr1) {
        this.attr1 = attr1;
    }

    @Generated
    public void setAttr2(String attr2) {
        this.attr2 = attr2;
    }

    @Generated
    public void setAttr3(String attr3) {
        this.attr3 = attr3;
    }

    @Generated
    public void setAttr4(String attr4) {
        this.attr4 = attr4;
    }

    @Generated
    public void setAttr5(String attr5) {
        this.attr5 = attr5;
    }
}

