/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BasicTrace;
import org.apache.skywalking.oap.server.core.query.type.QueryOrder;
import org.apache.skywalking.oap.server.core.query.type.Span;
import org.apache.skywalking.oap.server.core.query.type.TraceBrief;
import org.apache.skywalking.oap.server.core.query.type.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.RoutingUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;

public class TraceQueryEsDAO
extends EsDAO
implements ITraceQueryDAO {
    private final int segmentQueryMaxSize;

    public TraceQueryEsDAO(ElasticSearchClient client, int segmentQueryMaxSize) {
        super(client);
        this.segmentQueryMaxSize = segmentQueryMaxSize;
    }

    public TraceBrief queryBasicTraces(Duration duration, long minDuration, long maxDuration, String serviceId, String serviceInstanceId, String endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder, List<Tag> tags) throws IOException {
        long startSecondTB = 0L;
        long endSecondTB = 0L;
        if (Objects.nonNull(duration)) {
            startSecondTB = duration.getStartTimeBucketInSec();
            endSecondTB = duration.getEndTimeBucketInSec();
        }
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("segment")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"segment"));
        }
        if (startSecondTB != 0L && endSecondTB != 0L) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (minDuration != 0L || maxDuration != 0L) {
            RangeQueryBuilder rangeQueryBuilder = Query.range((String)"latency");
            if (minDuration != 0L) {
                rangeQueryBuilder.gte((Object)minDuration);
            }
            if (maxDuration != 0L) {
                rangeQueryBuilder.lte((Object)maxDuration);
            }
            query.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (StringUtil.isNotEmpty((String)serviceInstanceId)) {
            query.must((QueryBuilder)Query.term((String)"service_instance_id", (Object)serviceInstanceId));
        }
        if (!Strings.isNullOrEmpty((String)endpointId)) {
            query.must((QueryBuilder)Query.term((String)"endpoint_id", (Object)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            query.must((QueryBuilder)Query.term((String)"trace_id", (Object)traceId));
        }
        switch (traceState) {
            case ERROR: {
                query.must((QueryBuilder)Query.match((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                query.must((QueryBuilder)Query.match((String)"is_error", (Object)0));
            }
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).source("trace_id").source("segment_id").source("endpoint_id").source("start_time").source("latency").source("is_error");
        switch (queryOrder) {
            case BY_START_TIME: {
                search.sort("start_time", Sort.Order.DESC);
                break;
            }
            case BY_DURATION: {
                search.sort("latency", Sort.Order.DESC);
            }
        }
        if (CollectionUtils.isNotEmpty(tags)) {
            BoolQueryBuilder tagMatchQuery = Query.bool();
            tags.forEach(tag -> tagMatchQuery.must((QueryBuilder)Query.term((String)"tags", (Object)tag.toString())));
            query.must((QueryBuilder)tagMatchQuery);
        }
        search.size(Integer.valueOf(limit)).from(Integer.valueOf(from));
        SearchResponse response = this.searchDebuggable(new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName("segment"), startSecondTB, endSecondTB), search.build());
        TraceBrief traceBrief = new TraceBrief();
        for (SearchHit searchHit : response.getHits().getHits()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)searchHit.getSource().get("segment_id"));
            basicTrace.setStart(String.valueOf(searchHit.getSource().get("start_time")));
            basicTrace.getEndpointNames().add(IDManager.EndpointID.analysisId((String)((String)searchHit.getSource().get("endpoint_id"))).getEndpointName());
            basicTrace.setDuration(((Number)searchHit.getSource().get("latency")).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)searchHit.getSource().get("is_error")).intValue()));
            basicTrace.getTraceIds().add((String)searchHit.getSource().get("trace_id"));
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(String traceId, @Nullable Duration duration) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("segment");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.term((String)"trace_id", (Object)traceId)).size(Integer.valueOf(this.segmentQueryMaxSize));
        SearchParams searchParams = new SearchParams();
        RoutingUtils.addRoutingValueToSearchParam(searchParams, traceId);
        SearchResponse response = this.searchDebuggable(index, search.build(), searchParams);
        return this.buildRecords(response);
    }

    public List<SegmentRecord> queryBySegmentIdList(List<String> segmentIdList, @Nullable Duration duration) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("segment");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.terms((String)"segment_id", segmentIdList)).size(Integer.valueOf(this.segmentQueryMaxSize));
        SearchParams searchParams = new SearchParams();
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build(), searchParams);
        return this.buildRecords(response);
    }

    public List<SegmentRecord> queryByTraceIdWithInstanceId(List<String> traceIdList, List<String> instanceIdList, @Nullable Duration duration) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("segment");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.bool().must((QueryBuilder)Query.terms((String)"trace_id", traceIdList)).must((QueryBuilder)Query.terms((String)"service_instance_id", instanceIdList))).size(Integer.valueOf(this.segmentQueryMaxSize));
        SearchParams searchParams = new SearchParams();
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build(), searchParams);
        return this.buildRecords(response);
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        return Collections.emptyList();
    }

    private List<SegmentRecord> buildRecords(SearchResponse response) {
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            SegmentRecord segmentRecord = new SegmentRecord.Builder().storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("segment", searchHit.getSource()));
            segmentRecords.add(segmentRecord);
        }
        return segmentRecords;
    }
}

