/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.profiling.pprof.storage.PprofProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofDataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class PprofDataQueryEsDAO
extends EsDAO
implements IPprofDataQueryDAO {
    public PprofDataQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<PprofProfilingDataRecord> getByTaskIdAndInstances(String taskId, List<String> instanceIds) {
        if (StringUtil.isBlank((String)taskId) || CollectionUtils.isEmpty(instanceIds)) {
            return new ArrayList<PprofProfilingDataRecord>();
        }
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("pprof_profiling_data");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("pprof_profiling_data")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"pprof_profiling_data"));
        }
        query.must((QueryBuilder)Query.term((String)"task_id", (Object)taskId));
        query.must((QueryBuilder)Query.terms((String)"instance_id", instanceIds));
        SearchBuilder search = Search.builder().query((QueryBuilder)query);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList dataRecords = Lists.newArrayList();
        for (SearchHit searchHit : response.getHits().getHits()) {
            dataRecords.add(this.parseData(searchHit));
        }
        return dataRecords;
    }

    private PprofProfilingDataRecord parseData(SearchHit data) {
        Map sourceAsMap = data.getSource();
        PprofProfilingDataRecord.Builder builder = new PprofProfilingDataRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("pprof_profiling_data", sourceAsMap));
    }
}

