/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLog;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBBrowserLogQueryDAO
extends AbstractBanyanDBDAO
implements IBrowserLogQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"service_id", (Object)"service_version_id", (Object)"page_path_id", (Object)"error_category", (Object)"data_binary");

    public BanyanDBBrowserLogQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public BrowserErrorLogs queryBrowserErrorLogs(final String serviceId, final String serviceVersionId, final String pagePathId, final BrowserErrorCategory category, Duration duration, final int limit, final int from) throws IOException {
        long startSecondTB = duration.getStartTimeBucketInSec();
        long endSecondTB = duration.getEndTimeBucketInSec();
        TimestampRange tsRange = null;
        if (startSecondTB > 0L && endSecondTB > 0L) {
            tsRange = new TimestampRange(TimeBucket.getTimestamp((long)startSecondTB), TimeBucket.getTimestamp((long)endSecondTB));
        }
        StreamQueryResponse resp = this.query("browser_error_log", TAGS, tsRange, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                if (StringUtil.isNotEmpty((String)serviceId)) {
                    query.and(this.eq("service_id", serviceId));
                }
                if (StringUtil.isNotEmpty((String)serviceVersionId)) {
                    query.and(this.eq("service_version_id", serviceVersionId));
                }
                if (StringUtil.isNotEmpty((String)pagePathId)) {
                    query.and(this.eq("page_path_id", pagePathId));
                }
                if (Objects.nonNull(category)) {
                    query.and(this.eq("error_category", category.getValue()));
                }
                query.setOffset(from);
                query.setLimit(limit);
            }
        });
        BrowserErrorLogs logs = new BrowserErrorLogs();
        for (RowEntity rowEntity : resp.getElements()) {
            byte[] dataBinary = (byte[])rowEntity.getTagValue("data_binary");
            if (dataBinary == null || dataBinary.length <= 0) continue;
            BrowserErrorLog log = this.parserDataBinary(dataBinary);
            logs.getLogs().add(log);
        }
        return logs;
    }
}

