/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;

@FunctionalInterface
public interface LROp {
    public double apply(double var1, double var3, int var5) throws IllegalExpressionException;

    public static ExpressionResult doLROp(ExpressionResult left, ExpressionResult right, int opType, LROp calculate) throws IllegalExpressionException {
        if (left.getType() == ExpressionResultType.SINGLE_VALUE && right.getType() == ExpressionResultType.SINGLE_VALUE) {
            return LROp.single2SingleBinaryOp(left, right, opType, calculate);
        }
        if ((left.getType() == ExpressionResultType.TIME_SERIES_VALUES || left.getType() == ExpressionResultType.SORTED_LIST || left.getType() == ExpressionResultType.RECORD_LIST) && right.getType() == ExpressionResultType.SINGLE_VALUE) {
            return LROp.many2OneBinaryOp(left, right, opType, calculate);
        }
        if (left.getType() == ExpressionResultType.SINGLE_VALUE && (right.getType() == ExpressionResultType.TIME_SERIES_VALUES || right.getType() == ExpressionResultType.SORTED_LIST || right.getType() == ExpressionResultType.RECORD_LIST)) {
            return LROp.one2ManyBinaryOp(left, right, opType, calculate);
        }
        if (left.getType() == ExpressionResultType.TIME_SERIES_VALUES && right.getType() == ExpressionResultType.TIME_SERIES_VALUES) {
            return LROp.seriesBinaryOp(left, right, opType, calculate);
        }
        throw new IllegalExpressionException("Unsupported operation.");
    }

    private static ExpressionResult seriesBinaryOp(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        ExpressionResult result = new ExpressionResult();
        result = !seriesLeft.isLabeledResult() && !seriesRight.isLabeledResult() ? LROp.seriesNoLabeled(seriesLeft, seriesRight, opType, calculate) : (seriesLeft.isLabeledResult() && !seriesRight.isLabeledResult() ? LROp.seriesLabeledWithNoLabeled(seriesLeft, seriesRight, opType, calculate) : (!seriesLeft.isLabeledResult() && seriesRight.isLabeledResult() ? LROp.seriesNoLabeledWithLabeled(seriesLeft, seriesRight, opType, calculate) : LROp.seriesLabeledWithLabeled(seriesLeft, seriesRight, opType, calculate)));
        return result;
    }

    private static ExpressionResult single2SingleBinaryOp(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (!singleLeft.isLabeledResult() && !singleRight.isLabeledResult()) {
            return LROp.single2SingleNoLabeled(singleLeft, singleRight, opType, calculate);
        }
        if (singleLeft.isLabeledResult() && !singleRight.isLabeledResult()) {
            return LROp.many2OneBinaryOp(singleLeft, singleRight, opType, calculate);
        }
        if (!singleLeft.isLabeledResult() && singleRight.isLabeledResult()) {
            return LROp.one2ManyBinaryOp(singleLeft, singleRight, opType, calculate);
        }
        return LROp.single2SingleLabeled(singleLeft, singleRight, opType, calculate);
    }

    private static ExpressionResult single2SingleNoLabeled(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (singleLeft.getResults().isEmpty() || ((MQEValues)singleLeft.getResults().get(0)).getValues().size() != 1) {
            throw new IllegalExpressionException("Single to Single, left result is empty or has more than one value.");
        }
        if (singleRight.getResults().isEmpty() || ((MQEValues)singleRight.getResults().get(0)).getValues().size() != 1) {
            throw new IllegalExpressionException("Single to Single, right result is empty or has more than one value.");
        }
        ExpressionResult result = new ExpressionResult();
        MQEValue mqeValue = new MQEValue();
        MQEValues mqeValues = new MQEValues();
        mqeValues.getValues().add(mqeValue);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.SINGLE_VALUE);
        MQEValue left = (MQEValue)((MQEValues)singleLeft.getResults().get(0)).getValues().get(0);
        MQEValue right = (MQEValue)((MQEValues)singleRight.getResults().get(0)).getValues().get(0);
        if (left.isEmptyValue() || right.isEmptyValue()) {
            mqeValue.setEmptyValue(true);
        } else {
            double value = calculate.apply(left.getDoubleValue(), right.getDoubleValue(), opType);
            mqeValue.setDoubleValue(value);
        }
        return result;
    }

    private static ExpressionResult single2SingleLabeled(ExpressionResult singleLeft, ExpressionResult singleRight, int opType, LROp calculate) throws IllegalExpressionException {
        HashMap labelMapR = new HashMap();
        singleRight.getResults().forEach(mqeValuesR -> labelMapR.put(new HashSet(mqeValuesR.getMetric().getLabels()), mqeValuesR.getValues()));
        for (MQEValues mqeValuesL : singleLeft.getResults()) {
            if (mqeValuesL.getValues().size() != 1) {
                throw new IllegalExpressionException("Single Labeled to Single Labeled, left labeled result is empty or has more than one value.");
            }
            MQEValue valueL = (MQEValue)mqeValuesL.getValues().get(0);
            List mqeValuesR2 = (List)labelMapR.get(new HashSet(mqeValuesL.getMetric().getLabels()));
            if (mqeValuesR2 == null) {
                valueL.setEmptyValue(true);
                continue;
            }
            if (mqeValuesR2.size() != 1) {
                throw new IllegalExpressionException("Single Labeled to Single Labeled, right labeled result has more than one value.");
            }
            MQEValue valueR = (MQEValue)mqeValuesR2.get(0);
            if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                valueL.setEmptyValue(true);
                continue;
            }
            double value = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
            valueL.setDoubleValue(value);
        }
        return singleLeft;
    }

    private static ExpressionResult many2OneBinaryOp(ExpressionResult manyResult, ExpressionResult singleResult, int opType, LROp calculate) throws IllegalExpressionException {
        if (singleResult.getResults().isEmpty() || ((MQEValues)singleResult.getResults().get(0)).getValues().size() != 1) {
            throw new IllegalExpressionException("Many to One, single result is empty or has more than one value.");
        }
        for (MQEValues mqeValues : manyResult.getResults()) {
            for (MQEValue mqeValue : mqeValues.getValues()) {
                if (mqeValue.isEmptyValue()) continue;
                double newValue = calculate.apply(mqeValue.getDoubleValue(), ((MQEValue)((MQEValues)singleResult.getResults().get(0)).getValues().get(0)).getDoubleValue(), opType);
                mqeValue.setDoubleValue(newValue);
            }
        }
        return manyResult;
    }

    private static ExpressionResult one2ManyBinaryOp(ExpressionResult singleResult, ExpressionResult manyResult, int opType, LROp calculate) throws IllegalExpressionException {
        if (singleResult.getResults().isEmpty() || ((MQEValues)singleResult.getResults().get(0)).getValues().size() != 1) {
            throw new IllegalExpressionException("One to Many, single result is empty or has more than one value.");
        }
        for (MQEValues mqeValues : manyResult.getResults()) {
            for (MQEValue mqeValue : mqeValues.getValues()) {
                if (mqeValue.isEmptyValue()) continue;
                double newValue = calculate.apply(((MQEValue)((MQEValues)singleResult.getResults().get(0)).getValues().get(0)).getDoubleValue(), mqeValue.getDoubleValue(), opType);
                mqeValue.setDoubleValue(newValue);
            }
        }
        return manyResult;
    }

    private static ExpressionResult seriesNoLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (seriesLeft.getResults().isEmpty() || seriesRight.getResults().isEmpty()) {
            throw new IllegalExpressionException("Series No Labeled, left or right result is empty.");
        }
        MQEValues mqeValuesL = (MQEValues)seriesLeft.getResults().get(0);
        MQEValues mqeValuesR = (MQEValues)seriesRight.getResults().get(0);
        if (mqeValuesL.getValues().size() != mqeValuesR.getValues().size()) {
            throw new IllegalExpressionException("Series No Labeled, left and right series value size not equal.");
        }
        for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
            MQEValue valueL = (MQEValue)mqeValuesL.getValues().get(i);
            MQEValue valueR = (MQEValue)mqeValuesR.getValues().get(i);
            if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                valueL.setEmptyValue(true);
                continue;
            }
            double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
            ((MQEValue)mqeValuesL.getValues().get(i)).setDoubleValue(newValue);
        }
        return seriesLeft;
    }

    private static ExpressionResult seriesLabeledWithNoLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (seriesRight.getResults().isEmpty()) {
            throw new IllegalExpressionException("Series Labeled with No Labeled, no labeled result is empty.");
        }
        MQEValues mqeValuesR = (MQEValues)seriesRight.getResults().get(0);
        for (MQEValues mqeValuesL : seriesLeft.getResults()) {
            if (mqeValuesL.getValues().size() != mqeValuesR.getValues().size()) {
                throw new IllegalExpressionException("Series Labeled with No Labeled, left and right series value size not equal.");
            }
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = (MQEValue)mqeValuesL.getValues().get(i);
                MQEValue valueR = (MQEValue)mqeValuesR.getValues().get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                ((MQEValue)mqeValuesL.getValues().get(i)).setDoubleValue(newValue);
            }
        }
        return seriesLeft;
    }

    private static ExpressionResult seriesNoLabeledWithLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        if (seriesLeft.getResults().isEmpty()) {
            throw new IllegalExpressionException("Series No Labeled with Labeled, no labeled result is empty.");
        }
        MQEValues mqeValuesL = (MQEValues)seriesLeft.getResults().get(0);
        for (MQEValues mqeValuesR : seriesRight.getResults()) {
            if (mqeValuesL.getValues().size() != mqeValuesR.getValues().size()) {
                throw new IllegalExpressionException("Series No Labeled with Labeled, left and right series value size not equal.");
            }
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = (MQEValue)mqeValuesL.getValues().get(i);
                MQEValue valueR = (MQEValue)mqeValuesR.getValues().get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                ((MQEValue)mqeValuesR.getValues().get(i)).setDoubleValue(newValue);
            }
        }
        return seriesRight;
    }

    private static ExpressionResult seriesLabeledWithLabeled(ExpressionResult seriesLeft, ExpressionResult seriesRight, int opType, LROp calculate) throws IllegalExpressionException {
        HashMap labelMapR = new HashMap();
        seriesRight.getResults().forEach(mqeValuesR -> labelMapR.put(new HashSet(mqeValuesR.getMetric().getLabels()), mqeValuesR.getValues()));
        for (MQEValues mqeValuesL : seriesLeft.getResults()) {
            for (int i = 0; i < mqeValuesL.getValues().size(); ++i) {
                MQEValue valueL = (MQEValue)mqeValuesL.getValues().get(i);
                List mqeValuesR2 = (List)labelMapR.get(new HashSet(mqeValuesL.getMetric().getLabels()));
                if (mqeValuesR2 == null) {
                    valueL.setEmptyValue(true);
                    continue;
                }
                if (mqeValuesR2.size() != mqeValuesL.getValues().size()) {
                    throw new IllegalExpressionException("Series Labeled with Labeled, left and right series value size not equal.");
                }
                MQEValue valueR = (MQEValue)mqeValuesR2.get(i);
                if (valueL.isEmptyValue() || valueR.isEmptyValue()) {
                    valueL.setEmptyValue(true);
                    continue;
                }
                double newValue = calculate.apply(valueL.getDoubleValue(), valueR.getDoubleValue(), opType);
                ((MQEValue)mqeValuesL.getValues().get(i)).setDoubleValue(newValue);
            }
        }
        return seriesLeft;
    }
}

