/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.Optional;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class RoutingUtils {
    public static void addRoutingValueToSearchParam(SearchParams searchParams, String routingValue) {
        if (!IndexController.INSTANCE.isEnableCustomRouting()) {
            return;
        }
        searchParams.routing(routingValue);
    }

    public static void addRoutingValuesToSearchParam(SearchParams searchParams, Iterable<String> routingValues) {
        if (!IndexController.INSTANCE.isEnableCustomRouting()) {
            return;
        }
        searchParams.routing(routingValues);
    }

    public static Optional<String> getRoutingValue(Model model, ElasticSearchConverter.ToStorage toStorage) {
        if (!IndexController.INSTANCE.isEnableCustomRouting()) {
            return Optional.empty();
        }
        Optional routingField = model.getElasticSearchModelExtension().getRouting();
        return routingField.map(v -> RoutingUtils.extractRoutingValue(v, toStorage));
    }

    private static String extractRoutingValue(String routingField, ElasticSearchConverter.ToStorage toStorage) {
        Object value = toStorage.get(routingField);
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

