/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.deserializer;

import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializer;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializerNotFoundException;
import org.apache.shardingsphere.elasticjob.restful.deserializer.factory.DeserializerFactory;

public final class RequestBodyDeserializerFactory {
    private static final Map<String, RequestBodyDeserializer> REQUEST_BODY_DESERIALIZERS = new ConcurrentHashMap<String, RequestBodyDeserializer>();
    private static final Map<String, DeserializerFactory> DEFAULT_REQUEST_BODY_DESERIALIZER_FACTORIES = new ConcurrentHashMap<String, DeserializerFactory>();
    private static final RequestBodyDeserializer MISSING_DESERIALIZER = new RequestBodyDeserializer(){

        @Override
        public String mimeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T deserialize(Class<T> targetType, byte[] requestBodyBytes) {
            throw new UnsupportedOperationException();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RequestBodyDeserializer getRequestBodyDeserializer(String contentType) {
        RequestBodyDeserializer result = REQUEST_BODY_DESERIALIZERS.get(contentType);
        if (null == result) {
            Class<RequestBodyDeserializerFactory> clazz = RequestBodyDeserializerFactory.class;
            // MONITORENTER : org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializerFactory.class
            if (null == REQUEST_BODY_DESERIALIZERS.get(contentType)) {
                RequestBodyDeserializerFactory.instantiateRequestBodyDeserializerFromFactories(contentType);
            }
            result = REQUEST_BODY_DESERIALIZERS.get(contentType);
            // MONITOREXIT : clazz
        }
        if (MISSING_DESERIALIZER != result) return result;
        throw new RequestBodyDeserializerNotFoundException(contentType);
    }

    private static void instantiateRequestBodyDeserializerFromFactories(String contentType) {
        DeserializerFactory factory = DEFAULT_REQUEST_BODY_DESERIALIZER_FACTORIES.get(contentType);
        RequestBodyDeserializer deserializer = Optional.ofNullable(factory).map(DeserializerFactory::createDeserializer).orElse(MISSING_DESERIALIZER);
        REQUEST_BODY_DESERIALIZERS.put(contentType, deserializer);
    }

    @Generated
    private RequestBodyDeserializerFactory() {
    }

    static {
        for (RequestBodyDeserializer deserializer : ServiceLoader.load(RequestBodyDeserializer.class)) {
            REQUEST_BODY_DESERIALIZERS.put(deserializer.mimeType(), deserializer);
        }
        for (DeserializerFactory factory : ServiceLoader.load(DeserializerFactory.class)) {
            DEFAULT_REQUEST_BODY_DESERIALIZER_FACTORIES.put(factory.mimeType(), factory);
        }
    }
}

